/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUI;
import com.aelitis.azureus.ui.swt.shells.main.DebugMenuHelper;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.views.skin.SBC_PlusFTUX;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarItem;
import org.gudy.azureus2.plugins.ui.toolbar.UIToolBarManager;
import org.gudy.azureus2.ui.swt.KeyBindings;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.IMenuConstants;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.pluginsimpl.UIToolBarManagerImpl;

public class MainMenu
implements IMainMenu,
IMenuConstants {
    private static final String PREFIX_V2 = "MainWindow.menu";
    private static final String PREFIX_V3 = "v3.MainWindow.menu";
    private Menu menuBar;

    public MainMenu(SWTSkin skin, Shell shell) {
        if (null == skin) {
            System.err.println("MainMenu: The parameter [SWTSkin skin] can not be null");
            return;
        }
        this.buildMenu(shell);
    }

    private void buildMenu(Shell parent) {
        this.menuBar = new Menu((Decorations)parent, 2);
        parent.setMenuBar(this.menuBar);
        this.addFileMenu();
        this.addSimpleViewMenu();
        this.addCommunityMenu();
        this.addToolsMenu();
        if (COConfigurationManager.getBooleanParameter("show_torrents_menu")) {
            this.addTorrentMenu();
        }
        if (!Constants.isWindows) {
            this.addWindowMenu();
        }
        if (Constants.isCVSVersion()) {
            final Menu menuDebug = org.gudy.azureus2.ui.swt.mainwindow.DebugMenuHelper.createDebugMenuItem(this.menuBar);
            menuDebug.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    Object[] items = menuDebug.getItems();
                    Utils.disposeSWTObjects(items);
                    DebugMenuHelper.createDebugMenuItem(menuDebug);
                    MenuFactory.addSeparatorMenuItem(menuDebug);
                    MenuItem menuItem = new MenuItem(menuDebug, 8);
                    menuItem.setText("Log Views");
                    menuItem.setEnabled(false);
                    PluginsMenuHelper.getInstance().buildPluginLogsMenu(menuDebug);
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }
        this.addV3HelpMenu();
        MenuFactory.updateEnabledStates(this.menuBar);
    }

    private void addFileMenu() {
        MenuItem fileItem = MenuFactory.createFileMenuItem(this.menuBar);
        final Menu fileMenu = fileItem.getMenu();
        this.builFileMenu(fileMenu);
        fileMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                MenuItem[] menuItems = fileMenu.getItems();
                for (int i = 0; i < menuItems.length; ++i) {
                    menuItems[i].dispose();
                }
                MainMenu.this.builFileMenu(fileMenu);
            }
        });
    }

    private void builFileMenu(Menu fileMenu) {
        MenuItem openMenuItem = MenuFactory.createOpenMenuItem(fileMenu);
        Menu openSubMenu = openMenuItem.getMenu();
        MenuFactory.addOpenTorrentMenuItem(openSubMenu);
        MenuFactory.addOpenURIMenuItem(openSubMenu);
        MenuFactory.addOpenTorrentForTrackingMenuItem(openSubMenu);
        MenuFactory.addOpenVuzeFileMenuItem(openSubMenu);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode > 0) {
            Menu shareSubMenu = MenuFactory.createShareMenuItem(fileMenu).getMenu();
            MenuFactory.addShareFileMenuItem(shareSubMenu);
            MenuFactory.addShareFolderMenuItem(shareSubMenu);
            MenuFactory.addShareFolderContentMenuItem(shareSubMenu);
            MenuFactory.addShareFolderContentRecursiveMenuItem(shareSubMenu);
        }
        MenuFactory.addCreateMenuItem(fileMenu);
        if (FeatureManagerUI.enabled) {
            MenuFactory.addSeparatorMenuItem(fileMenu);
            MenuFactory.addMenuItem(fileMenu, "menu.plus", new Listener(){

                public void handleEvent(Event event2) {
                    SBC_PlusFTUX.setSourceRef("menu-file");
                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                    mdi.showEntryByID("Plus");
                }
            });
        }
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.addCloseWindowMenuItem(fileMenu);
        MenuFactory.addCloseDetailsMenuItem(fileMenu);
        MenuFactory.addCloseDownloadBarsToMenu(fileMenu);
        MenuFactory.addSeparatorMenuItem(fileMenu);
        MenuFactory.createTransfersMenuItem(fileMenu);
        if (!Utils.isCarbon) {
            MenuFactory.addSeparatorMenuItem(fileMenu);
            MenuFactory.addRestartMenuItem(fileMenu);
        }
        if (!Constants.isOSX) {
            MenuFactory.addExitMenuItem(fileMenu);
        }
    }

    private void addSimpleViewMenu() {
        try {
            MenuItem viewItem = MenuFactory.createViewMenuItem(this.menuBar);
            final Menu viewMenu = viewItem.getMenu();
            viewMenu.addListener(22, new Listener(){

                public void handleEvent(Event event2) {
                    Utils.disposeSWTObjects(viewMenu.getItems());
                    MainMenu.this.buildSimpleViewMenu(viewMenu, -1);
                }
            });
            final KeyBindings.KeyBindingInfo binding_info = KeyBindings.getKeyBindingInfo("v3.MainWindow.menu.view.pluginbar");
            if (binding_info != null) {
                Display.getDefault().addFilter(1, new Listener(){

                    public void handleEvent(Event event2) {
                        if (event2.keyCode == binding_info.accelerator) {
                            Utils.disposeSWTObjects(viewMenu.getItems());
                            MainMenu.this.buildSimpleViewMenu(viewMenu, event2.keyCode);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void buildSimpleViewMenu(final Menu viewMenu, int accelerator) {
        try {
            SWTSkin skin;
            SWTSkinObject plugin_bar;
            MenuFactory.addMenuItem(viewMenu, 32, "v3.MainWindow.menu.view.sidebar", new Listener(){

                public void handleEvent(Event event2) {
                    SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                    if (sidebar != null) {
                        sidebar.flipSideBarVisibility();
                    }
                }
            });
            if (COConfigurationManager.getIntParameter("User Mode") > 1 && (plugin_bar = (skin = SWTSkinFactory.getInstance()).getSkinObject("pluginbar")) != null) {
                MenuItem mi = MainMenu.createViewMenuItem(skin, viewMenu, "v3.MainWindow.menu.view.pluginbar", "pluginbar.visible", "pluginbar", true, -1);
                if (accelerator != -1 && mi.getAccelerator() == accelerator) {
                    Listener[] listeners;
                    for (Listener l : listeners = mi.getListeners(13)) {
                        try {
                            l.handleEvent(null);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                }
            }
            MenuItem itemStatusBar = MenuFactory.createTopLevelMenuItem(viewMenu, "v3.MainWindow.menu.view.statusbar");
            itemStatusBar.setText(itemStatusBar.getText());
            Menu menuStatusBar = itemStatusBar.getMenu();
            String[] statusAreaLangs = new String[]{"ConfigView.section.style.status.show_sr", "ConfigView.section.style.status.show_nat", "ConfigView.section.style.status.show_ddb", "ConfigView.section.style.status.show_ipf"};
            String[] statusAreaConfig = new String[]{"Status Area Show SR", "Status Area Show NAT", "Status Area Show DDB", "Status Area Show IPF"};
            for (int i = 0; i < statusAreaConfig.length; ++i) {
                final String configID = statusAreaConfig[i];
                String langID = statusAreaLangs[i];
                final MenuItem item = new MenuItem(menuStatusBar, 32);
                Messages.setLanguageText((Widget)item, langID);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        COConfigurationManager.setParameter(configID, !COConfigurationManager.getBooleanParameter(configID));
                    }
                });
                menuStatusBar.addListener(22, new Listener(){

                    public void handleEvent(Event event2) {
                        item.setSelection(COConfigurationManager.getBooleanParameter(configID));
                    }
                });
            }
            if (Constants.isWindows) {
                MenuFactory.addSeparatorMenuItem(viewMenu);
            }
            boolean needsSep = false;
            boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
            if (enabled) {
                MenuFactory.addMenuItem(viewMenu, 32, "MainWindow.menu.view.beta", new Listener(){

                    public void handleEvent(Event event2) {
                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                        if (mdi != null) {
                            mdi.showEntryByID("BetaProgramme");
                        }
                    }
                });
                needsSep = true;
            }
            if (Constants.isWindows && FeatureAvailability.isGamesEnabled()) {
                MenuFactory.addMenuItem(viewMenu, "v3.MainWindow.menu.games", new Listener(){

                    public void handleEvent(Event event2) {
                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                        mdi.showEntryByID("Games");
                    }
                });
                needsSep = true;
            }
            if (needsSep |= PluginsMenuHelper.getInstance().buildViewMenu(viewMenu, viewMenu.getShell())) {
                MenuFactory.addSeparatorMenuItem(viewMenu);
            }
            int simple_advanced_menu_type = Constants.isLinux ? 32 : 16;
            MenuFactory.addMenuItem(viewMenu, simple_advanced_menu_type, "v3.MainWindow.menu.view.asSimpleList", new Listener(){

                public void handleEvent(Event event2) {
                    UIToolBarItem item;
                    UIToolBarManager tb = UIToolBarManagerImpl.getInstance();
                    if (tb != null && (item = tb.getToolBarItem("modeBig")) != null) {
                        item.triggerToolBarItem(0L, SelectedContentManager.convertSelectedContentToObject(null));
                    }
                }
            });
            MenuFactory.addMenuItem(viewMenu, simple_advanced_menu_type, "v3.MainWindow.menu.view.asAdvancedList", new Listener(){

                public void handleEvent(Event event2) {
                    UIToolBarItem item;
                    UIToolBarManager tb = UIToolBarManagerImpl.getInstance();
                    if (tb != null && (item = tb.getToolBarItem("modeSmall")) != null) {
                        item.triggerToolBarItem(0L, SelectedContentManager.convertSelectedContentToObject(null));
                    }
                }
            });
            viewMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    UIToolBarManager tb;
                    MenuItem itemShowAsAdv;
                    UIToolBarManager tb2;
                    MenuItem itemShowAsSimple;
                    ToolBarView tb3;
                    MenuItem itemShowText;
                    MultipleDocumentInterface mdi;
                    MenuItem sidebarMenuItem = MenuFactory.findMenuItem(viewMenu, "v3.MainWindow.menu.view.sidebar");
                    if (sidebarMenuItem != null && (mdi = UIFunctionsManager.getUIFunctions().getMDI()) != null) {
                        sidebarMenuItem.setSelection(mdi.isVisible());
                    }
                    if ((itemShowText = MenuFactory.findMenuItem(viewMenu, "v3.MainWindow.menu.view.toolbartext")) != null && (tb3 = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class)) != null) {
                        itemShowText.setSelection(tb3.getShowText());
                    }
                    if ((itemShowAsSimple = MenuFactory.findMenuItem(viewMenu, "v3.MainWindow.menu.view.asSimpleList")) != null && (tb2 = UIToolBarManagerImpl.getInstance()) != null) {
                        UIToolBarItem item = tb2.getToolBarItem("modeBig");
                        long state = item == null ? 0L : item.getState();
                        itemShowAsSimple.setEnabled((state & 1L) > 0L);
                        itemShowAsSimple.setSelection((state & 2L) > 0L);
                    }
                    if ((itemShowAsAdv = MenuFactory.findMenuItem(viewMenu, "v3.MainWindow.menu.view.asAdvancedList")) != null && (tb = UIToolBarManagerImpl.getInstance()) != null) {
                        UIToolBarItem item = tb.getToolBarItem("modeSmall");
                        long state = item == null ? 0L : item.getState();
                        itemShowAsAdv.setEnabled((state & 1L) > 0L);
                        itemShowAsAdv.setSelection((state & 2L) > 0L);
                    }
                }

                public void menuHidden(MenuEvent e) {
                }
            });
        }
        catch (Exception e) {
            Debug.out("Error creating View Menu", e);
        }
    }

    private void addToolsMenu() {
        MenuItem toolsItem = MenuFactory.createToolsMenuItem(this.menuBar);
        Menu toolsMenu = toolsItem.getMenu();
        MenuFactory.addMyTrackerMenuItem(toolsMenu);
        MenuFactory.addMySharesMenuItem(toolsMenu);
        MenuFactory.addConsoleMenuItem(toolsMenu);
        MenuFactory.addStatisticsMenuItem(toolsMenu);
        MenuFactory.addSpeedLimitsToMenu(toolsMenu);
        MenuFactory.addTransferBarToMenu(toolsMenu);
        MenuFactory.addAllPeersMenuItem(toolsMenu);
        MenuFactory.addClientStatsMenuItem(toolsMenu);
        MenuFactory.addBlockedIPsMenuItem(toolsMenu);
        MenuFactory.addSeparatorMenuItem(toolsMenu);
        MenuFactory.createPluginsMenuItem(toolsMenu, true);
        MenuFactory.addPairingMenuItem(toolsMenu);
        MenuFactory.addOptionsMenuItem(toolsMenu);
    }

    private void addV3HelpMenu() {
        MenuItem helpItem = MenuFactory.createHelpMenuItem(this.menuBar);
        Menu helpMenu = helpItem.getMenu();
        if (!Constants.isOSX) {
            MenuFactory.addAboutMenuItem(helpMenu);
            MenuFactory.addSeparatorMenuItem(helpMenu);
        }
        MenuFactory.addMenuItem(helpMenu, "v3.MainWindow.menu.getting_started", new Listener(){

            public void handleEvent(Event event2) {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi != null) {
                    mdi.showEntryByID("Welcome");
                }
            }
        });
        MenuFactory.addHelpSupportMenuItem(helpMenu, ContentNetworkUtils.getUrl(ConstantsVuze.getDefaultContentNetwork(), 16));
        MenuFactory.addHealthMenuItem(helpMenu);
        MenuFactory.addReleaseNotesMenuItem(helpMenu);
        if (!SystemProperties.isJavaWebStartInstance()) {
            MenuFactory.addSeparatorMenuItem(helpMenu);
            MenuFactory.addCheckUpdateMenuItem(helpMenu);
            MenuFactory.addBetaMenuItem(helpMenu);
            MenuFactory.addVoteMenuItem(helpMenu);
        }
        if (FeatureManagerUI.enabled) {
            MenuFactory.addMenuItem(helpMenu, "menu.register", new Listener(){

                public void handleEvent(Event event2) {
                    FeatureManagerUI.openLicenceEntryWindow(false, null);
                }
            });
        }
        MenuFactory.addDonationMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        MenuFactory.addConfigWizardMenuItem(helpMenu);
        MenuFactory.addNatTestMenuItem(helpMenu);
        MenuFactory.addNetStatusMenuItem(helpMenu);
        MenuFactory.addSpeedTestMenuItem(helpMenu);
        MenuFactory.addAdvancedHelpMenuItem(helpMenu);
        MenuFactory.addSeparatorMenuItem(helpMenu);
        MenuFactory.addDebugHelpMenuItem(helpMenu);
    }

    private void addWindowMenu() {
        MenuItem menu_window = MenuFactory.createWindowMenuItem(this.menuBar);
        Menu windowMenu = menu_window.getMenu();
        MenuFactory.addMinimizeWindowMenuItem(windowMenu);
        MenuFactory.addZoomWindowMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.addBringAllToFrontMenuItem(windowMenu);
        MenuFactory.addSeparatorMenuItem(windowMenu);
        MenuFactory.appendWindowMenuItems(windowMenu);
    }

    private void addTorrentMenu() {
        MenuFactory.createTorrentMenuItem(this.menuBar);
    }

    public Menu getMenu(String id) {
        if ("menu.bar".equals(id)) {
            return this.menuBar;
        }
        return MenuFactory.findMenu(this.menuBar, id);
    }

    private void addCommunityMenu() {
        MenuItem item = MenuFactory.createTopLevelMenuItem(this.menuBar, "MainWindow.menu.community");
        final Menu communityMenu = item.getMenu();
        communityMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                Utils.disposeSWTObjects(communityMenu.getItems());
                MenuFactory.addMenuItem(communityMenu, "MainWindow.menu.community.forums", new Listener(){

                    public void handleEvent(Event e) {
                        Utils.launch(ContentNetworkUtils.getUrl(ConstantsVuze.getDefaultContentNetwork(), 20));
                    }
                });
                MenuFactory.addMenuItem(communityMenu, "MainWindow.menu.community.wiki", new Listener(){

                    public void handleEvent(Event e) {
                        Utils.launch(ContentNetworkUtils.getUrl(ConstantsVuze.getDefaultContentNetwork(), 21));
                    }
                });
                MenuBuildUtils.addChatMenu(communityMenu, "MainWindow.menu.community.chat", "General: Help");
                MenuFactory.addMenuItem(communityMenu, "MainWindow.menu.community.blog", new Listener(){

                    public void handleEvent(Event e) {
                        Utils.launch(ContentNetworkUtils.getUrl(ConstantsVuze.getDefaultContentNetwork(), 19));
                    }
                });
            }
        });
    }

    public Menu getMenuBar() {
        return this.menuBar;
    }

    public static MenuItem createViewMenuItem(final SWTSkin skin, Menu viewMenu, String textID, final String configID, final String viewID, final boolean fast, int menuIndex) {
        if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID)) {
            COConfigurationManager.setBooleanDefault(configID, true);
        }
        MenuItem item = MenuFactory.addMenuItem(viewMenu, 32, menuIndex, textID, new Listener(){

            public void handleEvent(Event event2) {
                SWTSkinObject skinObject = skin.getSkinObject(viewID);
                if (skinObject != null) {
                    boolean newVisibility = !skinObject.isVisible();
                    SWTSkinUtils.setVisibility(skin, configID, viewID, newVisibility, true, fast);
                }
            }
        });
        SWTSkinUtils.setVisibility(skin, configID, viewID, COConfigurationManager.getBooleanParameter(configID), false, true);
        final MenuItem itemViewPluginBar = item;
        final ParameterListener listener = new ParameterListener(){

            public void parameterChanged(String parameterName) {
                itemViewPluginBar.setSelection(COConfigurationManager.getBooleanParameter(parameterName));
            }
        };
        COConfigurationManager.addAndFireParameterListener(configID, listener);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.removeParameterListener(configID, listener);
            }
        });
        return item;
    }

    public static void setVisibility(SWTSkin skin, String configID, String viewID, boolean visible) {
        SWTSkinUtils.setVisibility(skin, configID, viewID, visible, true, false);
    }

    public static void setVisibility(SWTSkin skin, String configID, String viewID, boolean visible, boolean save) {
        SWTSkinUtils.setVisibility(skin, configID, viewID, visible, save, false);
    }
}

