/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;

public class DownloadManagerStatsImpl
implements DownloadManagerStats {
    private static int share_ratio_progress_interval;
    private DownloadManagerImpl download_manager;
    private int completed;
    private long saved_data_bytes_downloaded;
    private long saved_protocol_bytes_downloaded;
    private long saved_data_bytes_uploaded;
    private long saved_protocol_bytes_uploaded;
    private long session_start_data_bytes_downloaded;
    private long session_start_data_bytes_uploaded;
    private long saved_discarded = 0L;
    private long saved_hashfails = 0L;
    private long saved_SecondsDownloading = 0L;
    private long saved_SecondsOnlySeeding = 0L;
    private int saved_SecondsSinceDownload = 0;
    private int saved_SecondsSinceUpload = 0;
    private long saved_peak_receive_rate = 0L;
    private long saved_peak_send_rate = 0L;
    private long saved_skipped_file_set_size;
    private long saved_skipped_but_downloaded;
    private long saved_completed_download_bytes = -1L;
    private int max_upload_rate_bps = 0;
    private int max_download_rate_bps = 0;
    private static final int HISTORY_MAX_SECS = 1800;
    private volatile boolean history_retention_required;
    private long[] history;
    private int history_pos;
    private boolean history_wrapped;
    private int last_sr_progress = -1;
    private static final int HISTORY_DIV = 64;

    protected DownloadManagerStatsImpl(DownloadManagerImpl dm) {
        this.download_manager = dm;
    }

    public long getDataReceiveRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getDataReceiveRate();
        }
        return 0L;
    }

    public long getProtocolReceiveRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getProtocolReceiveRate();
        }
        return 0L;
    }

    public long getDataSendRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getDataSendRate();
        }
        return 0L;
    }

    public long getProtocolSendRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getProtocolSendRate();
        }
        return 0L;
    }

    public long getPeakDataReceiveRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        long result = this.saved_peak_receive_rate;
        if (pm != null) {
            result = Math.max(result, pm.getStats().getPeakDataReceiveRate());
        }
        return result;
    }

    public long getPeakDataSendRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        long result = this.saved_peak_send_rate;
        if (pm != null) {
            result = Math.max(result, pm.getStats().getPeakDataSendRate());
        }
        return result;
    }

    public long getSmoothedDataReceiveRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getSmoothedDataReceiveRate();
        }
        return 0L;
    }

    public long getSmoothedDataSendRate() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getSmoothedDataSendRate();
        }
        return 0L;
    }

    public long getETA() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getETA(false);
        }
        return -1L;
    }

    public long getSmoothedETA() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getETA(true);
        }
        return -1L;
    }

    public int getCompleted() {
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm == null) {
            int state = this.download_manager.getState();
            if (state == 20 || state == 30 || state == 5) {
                return this.completed;
            }
            return this.getDownloadCompleted(true);
        }
        if (dm.getState() == 2 || dm.getState() == 3 || dm.getState() == 1) {
            return dm.getPercentDone();
        }
        return this.getDownloadCompleted(true);
    }

    public void setCompleted(int _completed) {
        this.completed = _completed;
    }

    public int getDownloadCompleted(boolean bLive) {
        DiskManager dm;
        if (bLive && (dm = this.download_manager.getDiskManager()) != null) {
            int computed_completion;
            int state = dm.getState();
            boolean transient_state = state == 1 || state == 2 || state == 3;
            long total = dm.getTotalLength();
            long completed_download_bytes = total - dm.getRemaining();
            int n = computed_completion = total == 0L ? 0 : (int)(1000L * completed_download_bytes / total);
            if (!transient_state) {
                this.saved_completed_download_bytes = completed_download_bytes;
            }
            return computed_completion;
        }
        long total = this.download_manager.getSize();
        int computed_completion = total == 0L ? 0 : (int)(1000L * this.getDownloadCompletedBytes() / total);
        return computed_completion;
    }

    public void setDownloadCompletedBytes(long completedBytes) {
        this.saved_completed_download_bytes = completedBytes;
    }

    public void recalcDownloadCompleteBytes() {
        DiskManager dm = this.getDiskManagerIfNotTransient();
        if (dm != null) {
            long total = dm.getTotalLength();
            this.saved_completed_download_bytes = total - dm.getRemaining();
        }
        if (this.saved_completed_download_bytes < 0L) {
            DiskManagerFileInfo[] files = this.download_manager.getDiskManagerFileInfoSet().getFiles();
            long total_size = 0L;
            for (DiskManagerFileInfo file : files) {
                total_size += file.getDownloaded();
            }
            this.saved_completed_download_bytes = total_size;
        }
    }

    public long getDownloadCompletedBytes() {
        this.recalcDownloadCompleteBytes();
        return this.saved_completed_download_bytes;
    }

    public String getElapsedTime() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getElapsedTime();
        }
        return "";
    }

    public long getTimeStarted() {
        return this.getTimeStarted(false);
    }

    private long getTimeStarted(boolean mono) {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getTimeStarted(mono);
        }
        return -1L;
    }

    public long getTimeStartedSeeding() {
        return this.getTimeStartedSeeding(false);
    }

    private long getTimeStartedSeeding(boolean mono) {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getTimeStartedSeeding(mono);
        }
        return -1L;
    }

    public long getTotalDataBytesReceived() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_data_bytes_downloaded + pm.getStats().getTotalDataBytesReceived();
        }
        return this.saved_data_bytes_downloaded;
    }

    public long getSessionDataBytesReceived() {
        long total = this.getTotalDataBytesReceived();
        long res = total - this.session_start_data_bytes_downloaded;
        if (res < 0L) {
            this.session_start_data_bytes_downloaded = total;
            res = 0L;
        }
        return res;
    }

    public long getTotalGoodDataBytesReceived() {
        long downloaded = this.getTotalDataBytesReceived();
        if ((downloaded -= this.getHashFailBytes() + this.getDiscarded()) < 0L) {
            downloaded = 0L;
        }
        return downloaded;
    }

    public long getTotalProtocolBytesReceived() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_protocol_bytes_downloaded + pm.getStats().getTotalProtocolBytesReceived();
        }
        return this.saved_protocol_bytes_downloaded;
    }

    public void resetTotalBytesSentReceived(long new_sent, long new_received) {
        boolean running;
        boolean bl = running = this.download_manager.getPeerManager() != null;
        if (running) {
            this.download_manager.stopIt(70, false, false);
        }
        if (new_sent >= 0L) {
            this.saved_data_bytes_uploaded = new_sent;
            this.session_start_data_bytes_uploaded = new_sent;
            this.saved_protocol_bytes_uploaded = 0L;
        }
        if (new_received >= 0L) {
            this.saved_data_bytes_downloaded = new_received;
            this.session_start_data_bytes_downloaded = new_received;
            this.saved_protocol_bytes_downloaded = 0L;
        }
        this.saved_discarded = 0L;
        this.saved_hashfails = 0L;
        if (running) {
            this.download_manager.setStateWaiting();
        }
    }

    public long getTotalDataBytesSent() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_data_bytes_uploaded + pm.getStats().getTotalDataBytesSent();
        }
        return this.saved_data_bytes_uploaded;
    }

    public long getTotalProtocolBytesSent() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_protocol_bytes_uploaded + pm.getStats().getTotalProtocolBytesSent();
        }
        return this.saved_protocol_bytes_uploaded;
    }

    public long getSessionDataBytesSent() {
        long total = this.getTotalDataBytesSent();
        long res = total - this.session_start_data_bytes_uploaded;
        if (res < 0L) {
            this.session_start_data_bytes_uploaded = total;
            res = 0L;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecentHistoryRetention(boolean required) {
        DownloadManagerStatsImpl downloadManagerStatsImpl = this;
        synchronized (downloadManagerStatsImpl) {
            if (required) {
                if (!this.history_retention_required) {
                    this.history = new long[1800];
                    this.history_pos = 0;
                    this.history_retention_required = true;
                }
            } else {
                this.history = null;
                this.history_retention_required = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getRecentHistory() {
        DownloadManagerStatsImpl downloadManagerStatsImpl = this;
        synchronized (downloadManagerStatsImpl) {
            if (this.history == null) {
                return new int[3][0];
            }
            int entries = this.history_wrapped ? 1800 : this.history_pos;
            int start = this.history_wrapped ? this.history_pos : 0;
            int[][] result = new int[3][entries];
            int pos = start;
            for (int i = 0; i < entries; ++i) {
                if (pos == 1800) {
                    pos = 0;
                }
                long entry = this.history[pos++];
                int send_rate = (int)(entry >> 42 & 0x1FFFFFL);
                int recv_rate = (int)(entry >> 21 & 0x1FFFFFL);
                int swarm_rate = (int)(entry & 0x1FFFFFL);
                result[0][i] = send_rate * 64;
                result[1][i] = recv_rate * 64;
                result[2][i] = swarm_rate * 64;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timerTick(int tick_count) {
        if (tick_count % 15 == 0) {
            if (this.last_sr_progress == -1) {
                long temp = this.download_manager.getDownloadState().getLongAttribute("sr.prog");
                this.last_sr_progress = (int)temp;
            }
            if (share_ratio_progress_interval <= 0) {
                if (this.last_sr_progress != 0) {
                    this.last_sr_progress = 0;
                    this.download_manager.getDownloadState().setLongAttribute("sr.prog", 0L);
                }
            } else {
                int current_sr = this.getShareRatio();
                if ((current_sr = current_sr / share_ratio_progress_interval * share_ratio_progress_interval) != this.last_sr_progress) {
                    this.last_sr_progress = current_sr;
                    long data = (SystemTime.getCurrentTime() / 1000L << 32) + (long)this.last_sr_progress;
                    this.download_manager.getDownloadState().setLongAttribute("sr.prog", data);
                }
            }
        }
        if (!this.history_retention_required) {
            return;
        }
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return;
        }
        PEPeerManagerStats stats2 = pm.getStats();
        long send_rate = stats2.getDataSendRate() + stats2.getProtocolSendRate();
        long receive_rate = stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate();
        long peer_swarm_average = this.getTotalAveragePerPeer();
        long entry = (send_rate - 1L + 32L) / 64L << 42 & 0x7FFFFC0000000000L | (receive_rate - 1L + 32L) / 64L << 21 & 0x3FFFFE00000L | (peer_swarm_average - 1L + 32L) / 64L & 0x1FFFFFL;
        DownloadManagerStatsImpl downloadManagerStatsImpl = this;
        synchronized (downloadManagerStatsImpl) {
            if (this.history != null) {
                this.history[this.history_pos++] = entry;
                if (this.history_pos == 1800) {
                    this.history_pos = 0;
                    this.history_wrapped = true;
                }
            }
        }
    }

    public long getRemaining() {
        DiskManager disk_manager = this.getDiskManagerIfNotTransient();
        if (disk_manager == null) {
            long size = this.download_manager.getSize();
            return size - this.getDownloadCompletedBytes();
        }
        return disk_manager.getRemaining();
    }

    private DiskManager getDiskManagerIfNotTransient() {
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm == null) {
            return null;
        }
        int state = dm.getState();
        boolean transient_state = state == 1 || state == 2 || state == 3;
        return transient_state ? null : dm;
    }

    public long getDiscarded() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_discarded + pm.getStats().getTotalDiscarded();
        }
        return this.saved_discarded;
    }

    public long getHashFailCount() {
        TOTorrent t = this.download_manager.getTorrent();
        if (t == null) {
            return 0L;
        }
        long total = this.getHashFailBytes();
        long res = total / t.getPieceLength();
        if (res == 0L && total > 0L) {
            res = 1L;
        }
        return res;
    }

    public long getHashFailBytes() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_hashfails + pm.getStats().getTotalHashFailBytes();
        }
        return this.saved_hashfails;
    }

    public long getTotalAverage() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getTotalAverage();
        }
        return 0L;
    }

    public long getTotalAveragePerPeer() {
        int div = this.download_manager.getNbPeers() + (this.download_manager.isDownloadComplete(false) ? 0 : 1);
        long average = div < 1 ? 0L : this.getTotalAverage() / (long)div;
        return average;
    }

    public int getShareRatio() {
        long downloaded = this.getTotalGoodDataBytesReceived();
        long uploaded = this.getTotalDataBytesSent();
        if (downloaded <= 0L) {
            return -1;
        }
        return (int)(1000L * uploaded / downloaded);
    }

    public void setShareRatio(int ratio) {
        if (ratio < 0) {
            ratio = 0;
        }
        if (ratio > 1000000) {
            ratio = 1000000;
        }
        DiskManagerFileInfo[] files = this.download_manager.getDiskManagerFileInfoSet().getFiles();
        long total_size = 0L;
        for (DiskManagerFileInfo file : files) {
            if (file.isSkipped()) continue;
            total_size += file.getLength();
        }
        if (total_size == 0L) {
            return;
        }
        this.saved_hashfails = 0L;
        this.saved_discarded = 0L;
        this.saved_data_bytes_downloaded = 0L;
        this.saved_data_bytes_uploaded = 0L;
        long downloaded = this.getTotalGoodDataBytesReceived();
        long uploaded = this.getTotalDataBytesSent();
        long target_downloaded = total_size;
        long target_uploaded = (long)ratio * total_size / 1000L;
        this.saved_data_bytes_downloaded = target_downloaded - downloaded;
        this.saved_data_bytes_uploaded = target_uploaded - uploaded;
        if (this.download_manager.getPeerManager() == null) {
            this.saveSessionTotals();
        }
    }

    public long getSecondsDownloading() {
        long lTimeStartedDL = this.getTimeStarted(true);
        if (lTimeStartedDL >= 0L) {
            long lTimeEndedDL = this.getTimeStartedSeeding(true);
            if (lTimeEndedDL == -1L) {
                lTimeEndedDL = SystemTime.getMonotonousTime();
            }
            if (lTimeEndedDL > lTimeStartedDL) {
                return this.saved_SecondsDownloading + (lTimeEndedDL - lTimeStartedDL) / 1000L;
            }
        }
        return this.saved_SecondsDownloading;
    }

    public long getSecondsOnlySeeding() {
        long lTimeStarted = this.getTimeStartedSeeding(true);
        if (lTimeStarted >= 0L) {
            return this.saved_SecondsOnlySeeding + (SystemTime.getMonotonousTime() - lTimeStarted) / 1000L;
        }
        return this.saved_SecondsOnlySeeding;
    }

    public float getAvailability() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return -1.0f;
        }
        return pm.getMinAvailability();
    }

    public long getBytesUnavailable() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return -1L;
        }
        return pm.getBytesUnavailable();
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.max_upload_rate_bps;
    }

    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.max_upload_rate_bps = max_rate_bps;
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.max_download_rate_bps;
    }

    public void setDownloadRateLimitBytesPerSecond(int max_rate_bps) {
        this.max_download_rate_bps = max_rate_bps;
    }

    public int getTimeSinceLastDataReceivedInSeconds() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        int res = this.saved_SecondsSinceDownload;
        if (pm != null) {
            int current = pm.getStats().getTimeSinceLastDataReceivedInSeconds();
            if (current >= 0) {
                res = current;
            } else if (res >= 0) {
                long now = SystemTime.getCurrentTime();
                long elapsed = now - pm.getTimeStarted(false);
                if (elapsed < 0L) {
                    elapsed = 0L;
                }
                res = (int)((long)res + elapsed / 1000L);
            }
        }
        return res;
    }

    public int getTimeSinceLastDataSentInSeconds() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        int res = this.saved_SecondsSinceUpload;
        if (pm != null) {
            int current = pm.getStats().getTimeSinceLastDataSentInSeconds();
            if (current >= 0) {
                res = current;
            } else if (res >= 0) {
                long now = SystemTime.getCurrentTime();
                long elapsed = now - pm.getTimeStarted(false);
                if (elapsed < 0L) {
                    elapsed = 0L;
                }
                res = (int)((long)res + elapsed / 1000L);
            }
        }
        return res;
    }

    public long getAvailWentBadTime() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            long bad_time = pm.getAvailWentBadTime();
            if (bad_time > 0L) {
                return bad_time;
            }
            if ((double)pm.getMinAvailability() >= 1.0) {
                return 0L;
            }
        }
        DownloadManagerState state = this.download_manager.getDownloadState();
        return state.getLongAttribute("badavail");
    }

    protected void saveSessionTotals() {
        this.saved_data_bytes_downloaded = this.getTotalDataBytesReceived();
        this.saved_data_bytes_uploaded = this.getTotalDataBytesSent();
        this.saved_protocol_bytes_downloaded = this.getTotalProtocolBytesReceived();
        this.saved_protocol_bytes_uploaded = this.getTotalProtocolBytesSent();
        this.saved_discarded = this.getDiscarded();
        this.saved_hashfails = this.getHashFailBytes();
        this.saved_SecondsDownloading = this.getSecondsDownloading();
        this.saved_SecondsOnlySeeding = this.getSecondsOnlySeeding();
        this.saved_SecondsSinceDownload = this.getTimeSinceLastDataReceivedInSeconds();
        this.saved_SecondsSinceUpload = this.getTimeSinceLastDataSentInSeconds();
        this.saved_peak_receive_rate = this.getPeakDataReceiveRate();
        this.saved_peak_send_rate = this.getPeakDataSendRate();
        DownloadManagerState state = this.download_manager.getDownloadState();
        state.setIntAttribute("timesincedl", this.saved_SecondsSinceDownload);
        state.setIntAttribute("timesinceul", this.saved_SecondsSinceUpload);
        state.setLongAttribute("badavail", this.getAvailWentBadTime());
        state.setLongAttribute("pkdo", this.saved_peak_receive_rate);
        state.setLongAttribute("pkup", this.saved_peak_send_rate);
    }

    protected void setSavedDownloadedUploaded(long d, long u) {
        this.saved_data_bytes_downloaded = d;
        this.saved_data_bytes_uploaded = u;
    }

    public void restoreSessionTotals(long _saved_data_bytes_downloaded, long _saved_data_bytes_uploaded, long _saved_discarded, long _saved_hashfails, long _saved_SecondsDownloading, long _saved_SecondsOnlySeeding) {
        this.saved_data_bytes_downloaded = _saved_data_bytes_downloaded;
        this.saved_data_bytes_uploaded = _saved_data_bytes_uploaded;
        this.saved_discarded = _saved_discarded;
        this.saved_hashfails = _saved_hashfails;
        this.saved_SecondsDownloading = _saved_SecondsDownloading;
        this.saved_SecondsOnlySeeding = _saved_SecondsOnlySeeding;
        this.session_start_data_bytes_downloaded = this.saved_data_bytes_downloaded;
        this.session_start_data_bytes_uploaded = _saved_data_bytes_uploaded;
        DownloadManagerState state = this.download_manager.getDownloadState();
        this.saved_SecondsSinceDownload = state.getIntAttribute("timesincedl");
        this.saved_SecondsSinceUpload = state.getIntAttribute("timesinceul");
        this.saved_peak_receive_rate = state.getLongAttribute("pkdo");
        this.saved_peak_send_rate = state.getLongAttribute("pkup");
    }

    public void setSkippedFileStats(long skipped_file_set_size, long skipped_but_downloaded) {
        this.saved_skipped_file_set_size = skipped_file_set_size;
        this.saved_skipped_but_downloaded = skipped_but_downloaded;
    }

    public long getRemainingExcludingDND() {
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm != null) {
            return dm.getRemainingExcludingDND();
        }
        long remaining = this.getRemaining();
        long rem = remaining - (this.saved_skipped_file_set_size - this.saved_skipped_but_downloaded);
        if (rem < 0L) {
            rem = 0L;
        }
        return rem;
    }

    public long getSizeExcludingDND() {
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm != null) {
            return dm.getSizeExcludingDND();
        }
        long totalLength = this.download_manager.getSize();
        return totalLength - this.saved_skipped_file_set_size;
    }

    public int getPercentDoneExcludingDND() {
        long sizeExcludingDND = this.getSizeExcludingDND();
        if (sizeExcludingDND == 0L) {
            return 1000;
        }
        if (sizeExcludingDND < 0L) {
            return 0;
        }
        float pct = (float)(sizeExcludingDND - this.getRemainingExcludingDND()) / (float)sizeExcludingDND;
        return (int)(1000.0f * pct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateEvidence(IndentWriter writer) {
        writer.println("DownloadManagerStats");
        try {
            writer.indent();
            writer.println("recv_d=" + this.getTotalDataBytesReceived() + ",recv_p=" + this.getTotalProtocolBytesReceived() + ",recv_g=" + this.getTotalGoodDataBytesReceived() + ",sent_d=" + this.getTotalDataBytesSent() + ",sent_p=" + this.getTotalProtocolBytesSent() + ",discard=" + this.getDiscarded() + ",hash_fails=" + this.getHashFailCount() + "/" + this.getHashFailBytes() + ",comp=" + this.getCompleted() + "[live:" + this.getDownloadCompleted(true) + "/" + this.getDownloadCompleted(false) + "]" + ",remaining=" + this.getRemaining());
            writer.println("down_lim=" + this.getDownloadRateLimitBytesPerSecond() + ",up_lim=" + this.getUploadRateLimitBytesPerSecond());
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener("Share Ratio Progress Interval", new ParameterListener(){

            public void parameterChanged(String name) {
                share_ratio_progress_interval = COConfigurationManager.getIntParameter(name);
            }
        });
    }
}

