/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.I2PHelpers;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenFileOptions;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentOpenOptions {
    private static final String PARAM_DEFSAVEPATH = "Default save path";
    private static final String PARAM_MOVEWHENDONE = "Move Completed When Done";
    public static final int QUEUELOCATION_BOTTOM = 1;
    public static final int QUEUELOCATION_TOP = 0;
    public static final int STARTMODE_FORCESTARTED = 2;
    public static final int STARTMODE_QUEUED = 0;
    public static final int STARTMODE_SEEDING = 3;
    public static final int STARTMODE_STOPPED = 1;
    public String sOriginatingLocation;
    public String sFileName;
    private String sDestDir;
    private String manualRename;
    private String sDestSubDir;
    private boolean explicitDataDir;
    private TOTorrent torrent;
    private long totalSize;
    public int iStartID;
    public int iQueueLocation;
    public boolean isValid;
    public boolean bDeleteFileOnCancel;
    private TorrentOpenFileOptions[] files = null;
    public boolean disableIPFilter = false;
    private Map<Integer, File> initial_linkage_map = null;
    private CopyOnWriteList<FileListener> fileListeners = new CopyOnWriteList(1);
    public Map<String, Boolean> peerSource = new HashMap<String, Boolean>();
    private Map<String, Boolean> enabledNetworks = new HashMap<String, Boolean>();
    private List<Tag> initialTags = new ArrayList<Tag>();
    private List<List<String>> updatedTrackers;
    private int max_up;
    private int max_down;
    private boolean hide_errors;

    public TorrentOpenOptions(String sFileName, TOTorrent torrent, boolean bDeleteFileOnCancel) {
        this();
        this.bDeleteFileOnCancel = bDeleteFileOnCancel;
        this.sFileName = sFileName;
        this.sOriginatingLocation = sFileName;
        this.setTorrent(torrent);
    }

    public TorrentOpenOptions() {
        this.iStartID = TorrentOpenOptions.getDefaultStartMode();
        this.iQueueLocation = 1;
        this.isValid = true;
        this.sDestDir = COConfigurationManager.getStringParameter(PARAM_DEFSAVEPATH);
        for (int i = 0; i < AENetworkClassifier.AT_NETWORKS.length; ++i) {
            String nn = AENetworkClassifier.AT_NETWORKS[i];
            String config_name = "Network Selection Default." + nn;
            this.enabledNetworks.put(nn, COConfigurationManager.getBooleanParameter(config_name));
        }
    }

    public TorrentOpenOptions(TorrentOpenOptions toBeCloned) {
        this.sOriginatingLocation = toBeCloned.sOriginatingLocation;
        this.sFileName = toBeCloned.sFileName;
        this.sDestDir = toBeCloned.sDestDir;
        this.sDestSubDir = toBeCloned.sDestSubDir;
        this.iStartID = toBeCloned.iStartID;
        this.iQueueLocation = toBeCloned.iQueueLocation;
        this.isValid = toBeCloned.isValid;
        this.bDeleteFileOnCancel = toBeCloned.bDeleteFileOnCancel;
        this.disableIPFilter = toBeCloned.disableIPFilter;
        this.peerSource = toBeCloned.peerSource == null ? null : new HashMap<String, Boolean>(toBeCloned.peerSource);
        this.enabledNetworks = toBeCloned.enabledNetworks == null ? null : new HashMap<String, Boolean>(toBeCloned.enabledNetworks);
        ArrayList<Tag> arrayList = this.initialTags = toBeCloned.initialTags == null ? null : new ArrayList<Tag>(toBeCloned.initialTags);
        if (toBeCloned.updatedTrackers != null) {
            this.updatedTrackers = new ArrayList<List<String>>();
            for (List<String> l : toBeCloned.updatedTrackers) {
                this.updatedTrackers.add(new ArrayList<String>(l));
            }
        }
        this.max_up = toBeCloned.max_up;
        this.max_down = toBeCloned.max_down;
        this.hide_errors = toBeCloned.hide_errors;
    }

    public static int getDefaultStartMode() {
        return COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped") ? 1 : 0;
    }

    public File getInitialLinkage(int index) {
        return this.initial_linkage_map == null ? null : this.initial_linkage_map.get(index);
    }

    public String getParentDir() {
        return this.sDestDir;
    }

    public void setParentDir(String parentDir) {
        this.sDestDir = parentDir;
        this.parentDirChanged();
    }

    public void setManualRename(String manualRename) {
        this.manualRename = manualRename;
    }

    public String getManualRename() {
        return this.manualRename;
    }

    public String getSubDir() {
        return this.sDestSubDir;
    }

    public void setExplicitDataDir(String parent_dir, String sub_dir) {
        this.sDestDir = parent_dir;
        this.sDestSubDir = sub_dir;
        this.explicitDataDir = true;
        this.parentDirChanged();
    }

    public boolean isExplicitDataDir() {
        return this.explicitDataDir;
    }

    public boolean isSimpleTorrent() {
        return this.torrent.isSimpleTorrent();
    }

    public Map<String, Boolean> getEnabledNetworks() {
        return new HashMap<String, Boolean>(this.enabledNetworks);
    }

    public void setNetworkEnabled(String net, boolean enabled) {
        this.enabledNetworks.put(net, enabled);
    }

    public String getDataDir() {
        if (this.torrent.isSimpleTorrent()) {
            return this.sDestDir;
        }
        return new File(this.sDestDir, this.sDestSubDir == null ? FileUtil.convertOSSpecificChars(this.getTorrentName(), true) : this.sDestSubDir).getPath();
    }

    private String getSmartDestDir() {
        String sSmartDir = this.sDestDir;
        try {
            int iMatchLevel;
            String name = this.getTorrentName();
            String torrentFileName = this.sFileName == null ? "" : new File(this.sFileName).getName().replaceFirst("\\.torrent$", "");
            int totalSegmentsLengths = 0;
            String[][] segments = new String[][]{name.split("[^a-zA-Z]+"), torrentFileName.split("[^a-zA-Z]+")};
            List<DownloadManager> downloadManagers = AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
            for (int x = 0; x < segments.length; ++x) {
                String[] segmentArray = segments[x];
                for (int i = 0; i < segmentArray.length; ++i) {
                    int l = segmentArray[i].length();
                    if (l <= 1) continue;
                    segmentArray[i] = segmentArray[i].toLowerCase();
                    totalSegmentsLengths += l;
                }
            }
            String temp_dir = AETemporaryFileHandler.getTempDirectory().getAbsolutePath().toLowerCase(Locale.US);
            int maxMatches = 0;
            DownloadManager match = null;
            for (DownloadManager dm : downloadManagers) {
                DownloadManagerState dms;
                if (dm.getState() == 100 || (dms = dm.getDownloadState()).getFlag(16L) || dms.getFlag(512L) || dm.getSaveLocation().getAbsolutePath().toLowerCase(Locale.US).startsWith(temp_dir)) continue;
                int numMatches = 0;
                String dmName = dm.getDisplayName().toLowerCase();
                for (int x = 0; x < segments.length; ++x) {
                    String[] segmentArray = segments[x];
                    for (int i = 0; i < segmentArray.length; ++i) {
                        String segment;
                        int l = segmentArray[i].length();
                        if (l <= 1 || dmName.indexOf(segment = segmentArray[i]) < 0) continue;
                        numMatches += l;
                    }
                }
                if (numMatches <= maxMatches) continue;
                maxMatches = numMatches;
                match = dm;
            }
            if (match != null && (iMatchLevel = maxMatches * 100 / totalSegmentsLengths) >= 30) {
                File f = match.getSaveLocation();
                if (!f.isDirectory() || match.getDiskManagerFileInfo().length > 1) {
                    f = f.getParentFile();
                }
                if (f != null && f.isDirectory()) {
                    sSmartDir = f.getAbsolutePath();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sSmartDir;
    }

    public List<Tag> getInitialTags() {
        return new ArrayList<Tag>(this.initialTags);
    }

    public void setInitialTags(List<Tag> tags) {
        this.initialTags = tags;
    }

    public List<List<String>> getTrackers(boolean if_updated) {
        if (this.updatedTrackers != null) {
            return this.updatedTrackers;
        }
        if (if_updated) {
            return null;
        }
        if (this.torrent == null) {
            return new ArrayList<List<String>>(0);
        }
        return TorrentUtils.announceGroupsToList(this.torrent);
    }

    public void setTrackers(List<List<String>> trackers) {
        this.updatedTrackers = trackers;
    }

    public void setMaxUploadSpeed(int kbs) {
        this.max_up = kbs;
    }

    public int getMaxUploadSpeed() {
        return this.max_up;
    }

    public void setMaxDownloadSpeed(int kbs) {
        this.max_down = kbs;
    }

    public int getMaxDownloadSpeed() {
        return this.max_down;
    }

    public void setHideErrors(boolean h) {
        this.hide_errors = h;
    }

    public boolean getHideErrors() {
        return this.hide_errors;
    }

    public TorrentOpenFileOptions[] getFiles() {
        if (this.files == null && this.torrent != null) {
            TOTorrentFile[] tfiles = this.torrent.getFiles();
            this.files = new TorrentOpenFileOptions[tfiles.length];
            Set<String> skip_extensons = TorrentUtils.getSkipExtensionsSet();
            for (int i = 0; i < this.files.length; ++i) {
                int pos;
                TOTorrentFile torrentFile = tfiles[i];
                String orgFullName = torrentFile.getRelativePath();
                String orgFileName = new File(orgFullName).getName();
                boolean wanted = true;
                if (skip_extensons.size() > 0 && (pos = orgFileName.lastIndexOf(46)) != -1) {
                    String ext = orgFileName.substring(pos + 1);
                    wanted = !skip_extensons.contains(ext);
                }
                this.files[i] = new TorrentOpenFileOptions(this, i, orgFullName, orgFileName, torrentFile.getLength(), wanted);
            }
        }
        return this.files;
    }

    public long getTotalSize() {
        TorrentOpenFileOptions[] files;
        if (this.totalSize == 0L && (files = this.getFiles()) != null) {
            for (TorrentOpenFileOptions file : files) {
                this.totalSize += file.lSize;
            }
        }
        return this.totalSize;
    }

    public String getTorrentName() {
        return TorrentUtils.getLocalisedName(this.torrent);
    }

    public boolean allFilesMoving() {
        TorrentOpenFileOptions[] files = this.getFiles();
        for (int j = 0; j < files.length; ++j) {
            if (!files[j].isLinked()) continue;
            return false;
        }
        return true;
    }

    public boolean allFilesExist() {
        TorrentOpenFileOptions[] files = this.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File file;
            TorrentOpenFileOptions fileInfo2 = files[i];
            if (!fileInfo2.isToDownload() || (file = fileInfo2.getDestFileFullName()).exists() && file.length() == fileInfo2.lSize) continue;
            return false;
        }
        return true;
    }

    public void renameDuplicates() {
        if (this.iStartID == 3 || !COConfigurationManager.getBooleanParameter("DefaultDir.AutoSave.AutoRename") || this.allFilesExist()) {
            return;
        }
        if (!this.torrent.isSimpleTorrent()) {
            if (new File(this.getDataDir()).isDirectory()) {
                File f;
                int idx = 0;
                while ((f = new File(this.getDataDir() + "-" + ++idx)).isDirectory()) {
                }
                this.sDestSubDir = f.getName();
            }
        } else {
            TorrentOpenFileOptions[] fileInfos = this.getFiles();
            for (int i = 0; i < fileInfos.length; ++i) {
                TorrentOpenFileOptions info = fileInfos[i];
                File file = info.getDestFileFullName();
                int idx = 0;
                while (file.exists()) {
                    file = new File(info.getDestPathName(), ++idx + "-" + info.getDestFileName());
                }
                info.setDestFileName(file.getName(), false);
            }
        }
    }

    public boolean okToDisableAll() {
        return true;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void setTorrent(TOTorrent torrent) {
        String def_save_path;
        this.torrent = torrent;
        if (COConfigurationManager.getBooleanParameter("DefaultDir.BestGuess") && !COConfigurationManager.getBooleanParameter(PARAM_MOVEWHENDONE) && ((def_save_path = COConfigurationManager.getStringParameter(PARAM_DEFSAVEPATH)) == null || def_save_path.trim().length() == 0)) {
            this.sDestDir = this.getSmartDestDir();
        }
        if (torrent == null) {
            this.initial_linkage_map = null;
        } else {
            boolean enable_tor;
            this.initial_linkage_map = TorrentUtils.getInitialLinkage(torrent);
            try {
                LocaleTorrentUtil.getTorrentEncoding(torrent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Set<String> tracker_hosts = TorrentUtils.getUniqueTrackerHosts(torrent);
            HashSet<String> networks = new HashSet<String>();
            boolean decentralised = false;
            for (String host : tracker_hosts) {
                if (TorrentUtils.isDecentralised(host)) {
                    decentralised = true;
                    continue;
                }
                String network = AENetworkClassifier.categoriseAddress(host);
                networks.add(network);
            }
            List<String> network_cache = TorrentUtils.getNetworkCache(torrent);
            networks.addAll(network_cache);
            boolean enable_i2p = networks.contains("I2P");
            String enable_i2p_reason = null;
            if (enable_i2p) {
                enable_i2p_reason = MessageText.getString("azneti2phelper.install.reason.i2ptracker");
            } else if (tracker_hosts.size() != 1 || decentralised) {
                // empty if block
            }
            if (this.enabledNetworks.get("I2P").booleanValue()) {
                enable_i2p = true;
            }
            if (enable_i2p) {
                String[] providers = new String[]{"azneti2p", "azneti2phelper"};
                boolean found = false;
                for (String provider2 : providers) {
                    if (AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(provider2) == null) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.enabledNetworks.put("I2P", true);
                    if (networks.contains("I2P") && networks.size() == 1) {
                        this.enabledNetworks.put("Public", false);
                    }
                } else {
                    final boolean[] install_outcome = new boolean[]{false};
                    if (I2PHelpers.installI2PHelper(enable_i2p_reason, "azneti2phelper.install.open.torrent", install_outcome, new Runnable(){

                        public void run() {
                            if (!install_outcome[0]) {
                                // empty if block
                            }
                        }
                    })) {
                        this.enabledNetworks.put("I2P", true);
                        if (networks.contains("I2P") && networks.size() == 1) {
                            this.enabledNetworks.put("Public", false);
                        }
                    }
                }
            }
            if (enable_tor = networks.contains("Tor")) {
                String[] providers = new String[]{"aznettor"};
                boolean found = false;
                for (String provider3 : providers) {
                    if (AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(provider3) == null) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.enabledNetworks.put("Tor", true);
                    if (!networks.contains("Public")) {
                        this.enabledNetworks.put("Public", false);
                    }
                }
            }
            this.renameDuplicates();
        }
    }

    public void addListener(FileListener l) {
        this.fileListeners.add(l);
    }

    public void removeListener(FileListener l) {
        this.fileListeners.remove(l);
    }

    public void fileDownloadStateChanged(TorrentOpenFileOptions torrentOpenFileOptions, boolean toDownload) {
        for (FileListener l : this.fileListeners) {
            try {
                l.toDownloadChanged(torrentOpenFileOptions, toDownload);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void filePriorityStateChanged(TorrentOpenFileOptions torrentOpenFileOptions, int priority) {
        for (FileListener l : this.fileListeners) {
            try {
                l.priorityChanged(torrentOpenFileOptions, priority);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void parentDirChanged() {
        for (FileListener l : this.fileListeners) {
            try {
                l.parentDirChanged();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public static interface FileListener {
        public void toDownloadChanged(TorrentOpenFileOptions var1, boolean var2);

        public void priorityChanged(TorrentOpenFileOptions var1, int var2);

        public void parentDirChanged();
    }
}

