/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.update;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.PluginUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderListener;
import org.gudy.azureus2.update.CorePatchChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUpdatePlugin
implements Plugin {
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.update";
    private static final String PLUGIN_RESOURCE_ID = "ConfigView.section.plugins.update";
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    private PluginInterface plugin_interface;
    private LoggerChannel log;
    private boolean loader_listener_added;
    private String last_id_info = "";

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Plugin Updater");
        this.log = this.plugin_interface.getLogger().getChannel("Plugin Update");
        this.log.setDiagnostic();
        this.log.setForce(true);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel(PLUGIN_RESOURCE_ID);
        final PluginConfig plugin_config = this.plugin_interface.getPluginconfig();
        boolean enabled = plugin_config.getPluginBooleanParameter("enable.update", true);
        model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        model.getStatus().setText(enabled ? "Running" : "Optional checks disabled");
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addBooleanParameter2("enable.update", "Plugin.pluginupdate.enablecheck", true);
        this.plugin_interface.addEventListener(new PluginEventListener(){

            public void handleEvent(PluginEvent ev) {
                if (ev.getType() == 7) {
                    PluginUpdatePlugin.this.plugin_interface.removeEventListener(this);
                    PluginUpdatePlugin.this.initComplete(plugin_config);
                }
            }
        });
    }

    protected void initComplete(final PluginConfig plugin_config) {
        UpdateManager update_manager = this.plugin_interface.getUpdateManager();
        update_manager.addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance inst) {
                SFPluginDetailsLoaderFactory.getSingleton().reset();
            }
        });
        final PluginManager plugin_manager = this.plugin_interface.getPluginManager();
        PluginInterface[] plugins = plugin_manager.getPlugins();
        int mandatory_count = 0;
        int non_mandatory_count = 0;
        for (int i = 0; i < plugins.length; ++i) {
            PluginInterface pi = plugins[i];
            boolean pi_mandatory = pi.getPluginState().isMandatory();
            if (pi_mandatory) {
                ++mandatory_count;
                continue;
            }
            ++non_mandatory_count;
        }
        final int f_non_mandatory_count = non_mandatory_count;
        final int f_mandatory_count = mandatory_count;
        update_manager.registerUpdatableComponent(new UpdatableComponent(){

            public String getName() {
                return "Non-mandatory plugins";
            }

            public int getMaximumCheckTime() {
                return f_non_mandatory_count * 30;
            }

            public void checkForUpdate(UpdateChecker checker) {
                if (PluginUpdatePlugin.this.checkForUpdateSupport(checker, null, false) == 0) {
                    VersionCheckClient vc = VersionCheckClient.getSingleton();
                    String[] rps = vc.getRecommendedPlugins();
                    boolean found_one = false;
                    for (int i = 0; i < rps.length; ++i) {
                        String rp_id = rps[i];
                        if (plugin_manager.getPluginInterfaceByID(rp_id, false) != null) continue;
                        final String config_key = "recommended.processed." + rp_id;
                        if (!plugin_config.getPluginBooleanParameter(config_key, false)) {
                            try {
                                final PluginInstaller installer = PluginUpdatePlugin.this.plugin_interface.getPluginManager().getPluginInstaller();
                                StandardPlugin[] sps = installer.getStandardPlugins();
                                for (int j = 0; j < sps.length; ++j) {
                                    final StandardPlugin sp = sps[j];
                                    if (!sp.getId().equals(rp_id)) continue;
                                    found_one = true;
                                    checker.getCheckInstance().addListener(new UpdateCheckInstanceListener(){

                                        public void cancelled(UpdateCheckInstance instance) {
                                        }

                                        public void complete(UpdateCheckInstance instance) {
                                            if (instance.getUpdates().length == 0) {
                                                PluginUpdatePlugin.this.installRecommendedPlugin(installer, sp);
                                                plugin_config.setPluginParameter(config_key, true);
                                            }
                                        }
                                    });
                                    break;
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                        if (found_one) break;
                    }
                    if (!found_one) {
                        Set<String> auto_install = vc.getAutoInstallPluginIDs();
                        final ArrayList<String> to_do = new ArrayList<String>();
                        for (String pid : auto_install) {
                            if (plugin_manager.getPluginInterfaceByID(pid, false) != null) continue;
                            to_do.add(pid);
                        }
                        if (to_do.size() > 0) {
                            new AEThread2("pup:autoinst"){

                                public void run() {
                                    try {
                                        Thread.sleep(120000L);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                        return;
                                    }
                                    UpdateManager update_manager = PluginUpdatePlugin.this.plugin_interface.getUpdateManager();
                                    final ArrayList<UpdateCheckInstance> l_instances = new ArrayList<UpdateCheckInstance>();
                                    update_manager.addListener(new UpdateManagerListener(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void checkInstanceCreated(UpdateCheckInstance instance) {
                                            List list = l_instances;
                                            synchronized (list) {
                                                l_instances.add(instance);
                                            }
                                        }
                                    });
                                    UpdateCheckInstance[] instances = update_manager.getCheckInstances();
                                    l_instances.addAll(Arrays.asList(instances));
                                    long start = SystemTime.getMonotonousTime();
                                    while (SystemTime.getMonotonousTime() - start < 300000L) {
                                        try {
                                            Thread.sleep(5000L);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                            return;
                                        }
                                        if (l_instances.size() <= 0) continue;
                                        boolean all_done = true;
                                        for (UpdateCheckInstance instance : l_instances) {
                                            if (instance.isCompleteOrCancelled()) continue;
                                            all_done = false;
                                            break;
                                        }
                                        if (!all_done) continue;
                                        break;
                                    }
                                    if (update_manager.getInstallers().length > 0) {
                                        return;
                                    }
                                    PluginInstaller installer = PluginUpdatePlugin.this.plugin_interface.getPluginManager().getPluginInstaller();
                                    ArrayList<StandardPlugin> sps = new ArrayList<StandardPlugin>();
                                    for (String pid : to_do) {
                                        try {
                                            StandardPlugin sp = installer.getStandardPlugin(pid);
                                            if (sp != null) {
                                                PluginUpdatePlugin.this.log.log("Auto-installing " + pid);
                                                sps.add(sp);
                                                continue;
                                            }
                                            PluginUpdatePlugin.this.log.log("Standard plugin '" + pid + "' missing");
                                        }
                                        catch (Throwable e) {
                                            PluginUpdatePlugin.this.log.log("Standard plugin '" + pid + "' missing", e);
                                        }
                                    }
                                    if (sps.size() > 0) {
                                        HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
                                        properties.put(1, 3);
                                        properties.put(3, true);
                                        try {
                                            installer.install(sps.toArray(new InstallablePlugin[sps.size()]), false, properties, new PluginInstallationListener(){

                                                public void completed() {
                                                }

                                                public void cancelled() {
                                                }

                                                public void failed(PluginException e) {
                                                }
                                            });
                                        }
                                        catch (Throwable e) {
                                            PluginUpdatePlugin.this.log.log("Auto install failed", e);
                                        }
                                    }
                                }
                            }.start();
                        }
                    }
                }
            }
        }, false);
        update_manager.registerUpdatableComponent(new UpdatableComponent(){

            public String getName() {
                return "Mandatory plugins";
            }

            public int getMaximumCheckTime() {
                return f_mandatory_count * 30;
            }

            public void checkForUpdate(UpdateChecker checker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(checker, null, true);
            }
        }, true);
        update_manager.addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance instance) {
                PluginUpdatePlugin.this.log.log(1, "**** Update check starts ****");
            }
        });
    }

    protected void installRecommendedPlugin(PluginInstaller installer, StandardPlugin plugin) {
        try {
            installer.requestInstall(MessageText.getString("plugin.installer.recommended.plugin"), plugin);
        }
        catch (Throwable e) {
            this.log.log(e);
        }
    }

    public UpdatableComponent getCustomUpdateableComponent(final String id, final boolean mandatory) {
        return new UpdatableComponent(){

            public String getName() {
                return "Installation of '" + id + "'";
            }

            public int getMaximumCheckTime() {
                return 30;
            }

            public void checkForUpdate(UpdateChecker checker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(checker, new String[]{id}, mandatory);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int checkForUpdateSupport(UpdateChecker checker, String[] ids_to_check, boolean mandatory) {
        int num_updates_found;
        block28: {
            num_updates_found = 0;
            if (mandatory || ids_to_check != null || this.plugin_interface.getPluginconfig().getPluginBooleanParameter("enable.update", true)) break block28;
            int n = num_updates_found;
            Object var41_8 = null;
            checker.completed();
            return n;
        }
        try {
            try {
                int i;
                String id;
                PluginInterface[] plugins = this.plugin_interface.getPluginManager().getPlugins();
                ArrayList<PluginInterface> plugins_to_check = new ArrayList<PluginInterface>();
                ArrayList<String> plugins_to_check_ids = new ArrayList<String>();
                HashMap<String, String> plugins_to_check_names = new HashMap<String, String>();
                for (int i2 = 0; i2 < plugins.length; ++i2) {
                    boolean pi_mandatory;
                    PluginInterface pi = plugins[i2];
                    if (pi.getPluginState().isDisabled() && !pi.getPluginState().hasFailed()) continue;
                    String mand = pi.getPluginProperties().getProperty("plugin.mandatory");
                    boolean bl = pi_mandatory = mand != null && mand.trim().toLowerCase().equals("true");
                    if (pi_mandatory != mandatory) continue;
                    id = pi.getPluginID();
                    String version = pi.getPluginVersion();
                    String name = pi.getPluginName();
                    if (ids_to_check != null) {
                        boolean id_selected = false;
                        for (int j = 0; j < ids_to_check.length; ++j) {
                            if (!ids_to_check[j].equals(id)) continue;
                            id_selected = true;
                            break;
                        }
                        if (!id_selected) continue;
                    }
                    if (version != null) {
                        if (plugins_to_check_ids.contains(id)) {
                            String s = (String)plugins_to_check_names.get(id);
                            if (!name.equals(id)) {
                                plugins_to_check_names.put(id, s + "," + name);
                            }
                        } else {
                            plugins_to_check_ids.add(id);
                            plugins_to_check.add(pi);
                            plugins_to_check_names.put(id, name.equals(id) ? "" : name);
                        }
                    }
                    String location = pi.getPluginDirectoryName();
                    this.log.log(1, (mandatory ? "*" : "-") + pi.getPluginName() + ", id = " + id + (version == null ? "" : ", version = " + pi.getPluginVersion()) + (location == null ? "" : ", loc = " + location));
                }
                SFPluginDetailsLoader loader = SFPluginDetailsLoaderFactory.getSingleton();
                if (!this.loader_listener_added) {
                    this.loader_listener_added = true;
                    loader.addListener(new SFPluginDetailsLoaderListener(){

                        public void log(String str) {
                            PluginUpdatePlugin.this.log.log(1, "[" + str + "]");
                        }
                    });
                }
                String[] ids = loader.getPluginIDs();
                String id_info = "";
                for (i = 0; i < ids.length; ++i) {
                    id = ids[i];
                    SFPluginDetails details = loader.getPluginDetails(id);
                    id_info = id_info + (i == 0 ? "" : ",") + ids[i] + "=" + details.getVersion() + "/" + details.getCVSVersion();
                }
                if (!id_info.equals(this.last_id_info)) {
                    this.last_id_info = id_info;
                    this.log.log(1, "Downloaded plugin info = " + id_info);
                }
                for (i = 0; i < plugins_to_check.size(); ++i) {
                    if (checker.getCheckInstance().isCancelled()) {
                        throw new Exception("Update check cancelled");
                    }
                    PluginInterface pi_being_checked = (PluginInterface)plugins_to_check.get(i);
                    String plugin_id = pi_being_checked.getPluginID();
                    boolean found = false;
                    for (int j = 0; j < ids.length; ++j) {
                        if (!ids[j].equalsIgnoreCase(plugin_id)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        if (pi_being_checked.getPluginState().isBuiltIn()) continue;
                        this.log.log(1, "Skipping " + plugin_id + " as not listed on web site");
                        continue;
                    }
                    String plugin_names = (String)plugins_to_check_names.get(plugin_id);
                    this.log.log(1, "Checking " + plugin_id);
                    try {
                        String sf_cvs_version;
                        String sf_cvs_version2;
                        String sf_plugin_version;
                        checker.reportProgress("Loading details for " + plugin_id + "/" + pi_being_checked.getPluginName());
                        SFPluginDetails details = loader.getPluginDetails(plugin_id);
                        if (plugin_names.length() == 0) {
                            plugin_names = details.getName();
                        }
                        boolean az_cvs = this.plugin_interface.getUtilities().isCVSVersion();
                        String pi_version_info = pi_being_checked.getPluginProperties().getProperty("plugin.version.info");
                        String az_plugin_version = pi_being_checked.getPluginVersion();
                        String sf_comp_version = sf_plugin_version = details.getVersion();
                        if (az_cvs && (sf_cvs_version2 = details.getCVSVersion()).length() > 0) {
                            sf_plugin_version = sf_cvs_version2;
                            sf_comp_version = sf_plugin_version.substring(0, sf_plugin_version.length() - 4);
                        }
                        if (sf_comp_version.length() == 0 || !Character.isDigit(sf_comp_version.charAt(0))) {
                            this.log.log(1, "Skipping " + plugin_id + " as no valid version to check");
                            continue;
                        }
                        int comp2 = PluginUtils.comparePluginVersions(az_plugin_version, sf_comp_version);
                        this.log.log(1, "    Current: " + az_plugin_version + (comp2 == 0 && sf_plugin_version.endsWith("_CVS") ? "_CVS" : "") + ", Latest: " + sf_plugin_version + (pi_version_info == null ? "" : " [" + pi_version_info + "]"));
                        checker.reportProgress("    current=" + az_plugin_version + (comp2 == 0 && sf_plugin_version.endsWith("_CVS") ? "_CVS" : "") + ", latest=" + sf_plugin_version);
                        if (comp2 >= 0 || pi_being_checked.getPlugin() instanceof UpdatableComponent) continue;
                        String sf_plugin_download = details.getDownloadURL();
                        if (az_cvs && (sf_cvs_version = details.getCVSVersion()).length() > 0) {
                            sf_plugin_download = details.getCVSDownloadURL();
                        }
                        this.log.log(1, "    Description:");
                        ArrayList update_desc = new ArrayList();
                        List desc_lines = HTMLUtils.convertHTMLToText("", details.getDescription());
                        this.logMultiLine("        ", desc_lines);
                        update_desc.addAll(desc_lines);
                        this.log.log(1, "    Comment:");
                        List comment_lines = HTMLUtils.convertHTMLToText("    ", details.getComment());
                        this.logMultiLine("    ", comment_lines);
                        update_desc.addAll(comment_lines);
                        String msg = "A newer version (version " + sf_plugin_version + ") of plugin '" + plugin_id + "' " + (plugin_names.length() == 0 ? "" : "(" + plugin_names + ") ") + "is available. ";
                        this.log.log(1, "");
                        this.log.log(1, "        " + msg + "Download from " + sf_plugin_download);
                        ResourceDownloaderFactory rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                        ResourceDownloader direct_rdl = rdf.create(new URL(sf_plugin_download));
                        ResourceDownloader direct_ap_rdl = rdf.createWithAutoPluginProxy(new URL(sf_plugin_download));
                        String torrent_download = "http://cf1.vuze.com/torrent/torrents/";
                        int slash_pos = sf_plugin_download.lastIndexOf("/");
                        torrent_download = slash_pos == -1 ? torrent_download + sf_plugin_download : torrent_download + sf_plugin_download.substring(slash_pos + 1);
                        torrent_download = torrent_download + ".torrent";
                        ResourceDownloader torrent_rdl = rdf.create(new URL(torrent_download));
                        torrent_rdl = rdf.getSuffixBasedDownloader(torrent_rdl);
                        ResourceDownloader alternate_rdl = rdf.getAlternateDownloader(new ResourceDownloader[]{torrent_rdl, direct_rdl, direct_ap_rdl});
                        rdf.getTimeoutDownloader(rdf.getRetryDownloader(alternate_rdl, 3), 10000).getSize();
                        String[] update_d = new String[update_desc.size()];
                        update_desc.toArray(update_d);
                        ++num_updates_found;
                        boolean plugin_unloadable = true;
                        for (int j = 0; j < plugins.length; ++j) {
                            PluginInterface pi = plugins[j];
                            if (!pi.getPluginID().equals(plugin_id)) continue;
                            plugin_unloadable &= pi.getPluginState().isUnloadable();
                        }
                        if (plugin_unloadable) {
                            checker.reportProgress("Plugin is unloadable");
                        }
                        Update update = this.addUpdate(pi_being_checked, checker, plugin_id + "/" + plugin_names, update_d, az_plugin_version, sf_plugin_version, alternate_rdl, sf_plugin_download.toLowerCase().endsWith(".jar"), plugin_unloadable ? 1 : 2, true);
                        update.setRelativeURLBase(details.getRelativeURLBase());
                        update.setDescriptionURL(details.getInfoURL());
                        continue;
                    }
                    catch (Throwable e) {
                        checker.reportProgress("Failed to load details for plugin '" + plugin_id + "': " + Debug.getNestedExceptionMessage(e));
                        this.log.log("    Plugin check failed", e);
                    }
                }
                Object var41_9 = null;
                checker.completed();
            }
            catch (Throwable e) {
                if (!"Update check cancelled".equals(e.getMessage())) {
                    this.log.log("Failed to load plugin details", e);
                }
                checker.reportProgress("Failed to load plugin details: " + Debug.getNestedExceptionMessage(e));
                checker.failed();
                Object var41_10 = null;
                checker.completed();
            }
        }
        catch (Throwable throwable) {
            Object var41_11 = null;
            checker.completed();
            throw throwable;
        }
        return num_updates_found;
    }

    public Update addUpdate(final PluginInterface pi_for_update, final UpdateChecker checker, String update_name, String[] update_details, final String old_version, final String new_version, ResourceDownloader resource_downloader, final boolean is_jar, final int restart_type, final boolean verify) {
        final Update update = checker.addUpdate(update_name, update_details, old_version, new_version, resource_downloader, restart_type);
        update.setUserObject(pi_for_update);
        resource_downloader.addListener(new ResourceDownloaderAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean completed(final ResourceDownloader downloader, InputStream data) {
                LoggerChannelListener list = new LoggerChannelListener(){

                    public void messageLogged(int type, String content) {
                        downloader.reportActivity(content);
                    }

                    public void messageLogged(String str, Throwable error) {
                        downloader.reportActivity(str);
                    }
                };
                try {
                    PluginUpdatePlugin.this.log.addListener(list);
                    PluginUpdatePlugin.this.installUpdate(checker, update, pi_for_update, restart_type == 1, is_jar, old_version, new_version, data, verify);
                    boolean bl = true;
                    Object var6_5 = null;
                    PluginUpdatePlugin.this.log.removeListener(list);
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    PluginUpdatePlugin.this.log.removeListener(list);
                    throw throwable;
                }
            }

            public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                if (!downloader.isCancelled()) {
                    Debug.out(downloader.getName() + " failed", e);
                }
                update.complete(false);
            }
        });
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void installUpdate(UpdateChecker checker, Update update, PluginInterface plugin, boolean unloadable, boolean is_jar, String old_version, String new_version, InputStream data, boolean verify) {
        this.log.log(1, "Installing plugin '" + update.getName() + "', version " + new_version);
        target_version = new_version.endsWith("_CVS") != false ? new_version.substring(0, new_version.length() - 4) : new_version;
        installer = null;
        update_successful = false;
        try {
            try {
                data = update.verifyData(data, verify);
                this.log.log("    Data verification stage complete");
                update_txt_found = false;
                plugin_dir_name = plugin.getPluginDirectoryName();
                if (plugin_dir_name == null || plugin_dir_name.length() == 0) {
                    this.log.log(1, "    This is a built-in plugin, updating core");
                    CorePatchChecker.patchAzureus2(update.getCheckInstance(), data, plugin.getPluginID() + "_" + new_version, this.log);
                    update.setRestartRequired(2);
                } else {
                    plugin_dir = new File(plugin_dir_name);
                    user_dir = new File(this.plugin_interface.getUtilities().getAzureusUserDir());
                    prog_dir = new File(this.plugin_interface.getUtilities().getAzureusProgramDir());
                    install_properties = new HashMap<String, List<String[]>>();
                    force_indirect_install = false;
                    if (Constants.isWindowsVistaOrHigher) {
                        test_file = new File(plugin_dir, "_aztest45.dll");
                        ok = false;
                        try {
                            if (test_file.exists()) {
                                test_file.delete();
                            }
                            os = new FileOutputStream(test_file);
                            try {
                                os.write(32);
                                var24_28 = null;
                            }
                            catch (Throwable var23_32) {
                                var24_29 = null;
                                os.close();
                                throw var23_32;
                            }
                            os.close();
                            ok = test_file.delete();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (!ok) {
                            this.log.log("Can't write directly to the plugin directroy, installing indirectly");
                            force_indirect_install = true;
                        }
                    }
                    if (force_indirect_install) {
                        temp_dir = AETemporaryFileHandler.createTempDir();
                        target_plugin_dir = new File(temp_dir, "plugin");
                        target_user_dir = new File(temp_dir, "user");
                        target_prog_dir = new File(temp_dir, "prog");
                        target_plugin_dir.mkdirs();
                        target_user_dir.mkdirs();
                        target_prog_dir.mkdirs();
                        installer = update.getCheckInstance().createInstaller();
                        update.setRestartRequired(2);
                    } else {
                        target_plugin_dir = plugin_dir;
                        target_user_dir = user_dir;
                        target_prog_dir = prog_dir;
                    }
                    target_jar_zip = new File(target_plugin_dir, plugin.getPluginID() + "_" + target_version + (is_jar != false ? ".jar" : ".zip"));
                    FileUtil.copyFile(data, new FileOutputStream(target_jar_zip));
                    if (!is_jar) {
                        zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(target_jar_zip)));
                        common_prefix = null;
                        selected_platform = null;
                        selected_sub_platforms = new ArrayList<String>();
                        try {
                            block40: while (true) {
                                if ((entry = zis.getNextEntry()) == null) break;
                                name = entry.getName();
                                if (name.equals("plugin_install.properties")) {
                                    baos = new ByteArrayOutputStream(32768);
                                    buffer = new byte[65536];
                                    while (true) {
                                        if ((len = zis.read(buffer)) <= 0) {
                                            try {
                                                lnr = new LineNumberReader(new InputStreamReader((InputStream)new ByteArrayInputStream(baos.toByteArray()), "UTF-8"));
                                                while (true) {
                                                    if ((line = lnr.readLine()) == null) continue block40;
                                                    if ((line = line.trim()).endsWith("defer_install")) {
                                                        force_indirect_install = true;
                                                        continue;
                                                    }
                                                    command = line.split(",");
                                                    if (command.length <= 1) continue;
                                                    commands = (ArrayList<String[]>)install_properties.get(command[0]);
                                                    if (commands == null) {
                                                        commands = new ArrayList<String[]>();
                                                        install_properties.put(command[0], commands);
                                                    }
                                                    commands.add(command);
                                                }
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                                continue block40;
                                            }
                                        }
                                        baos.write(buffer, 0, len);
                                    }
                                }
                                if (!name.equals("azureus.sig") && !name.endsWith("/")) {
                                    if (common_prefix == null) {
                                        common_prefix = name;
                                    } else {
                                        len = 0;
                                        for (i = 0; i < Math.min(common_prefix.length(), name.length()) && common_prefix.charAt(i) == name.charAt(i); ++len, ++i) {
                                        }
                                        common_prefix = common_prefix.substring(0, len);
                                    }
                                    plat_pos = name.indexOf("platform/");
                                    if (plat_pos != -1 && (plat_end_pos = name.indexOf("/", plat_pos += 9)) != -1) {
                                        platform = name.substring(plat_pos, plat_end_pos);
                                        sub_platform = null;
                                        sub_plat_pos = platform.indexOf("_");
                                        if (sub_plat_pos != -1) {
                                            sub_platform = platform.substring(sub_plat_pos + 1);
                                            platform = platform.substring(0, sub_plat_pos);
                                        }
                                        if (Constants.isWindows != false && platform.equalsIgnoreCase("windows") != false || Constants.isLinux != false && platform.equalsIgnoreCase("linux") != false || Constants.isUnix != false && platform.equalsIgnoreCase("unix") != false || Constants.isFreeBSD != false && platform.equalsIgnoreCase("freebsd") != false || Constants.isSolaris != false && platform.equalsIgnoreCase("solaris") != false || Constants.isOSX && platform.equalsIgnoreCase("osx")) {
                                            selected_platform = platform;
                                            if (sub_platform != null && !selected_sub_platforms.contains(sub_platform)) {
                                                selected_sub_platforms.add(sub_platform);
                                            }
                                        }
                                    }
                                }
                                buffer = new byte[65536];
                                while ((len = zis.read(buffer)) > 0) {
                                }
                            }
                            var37_59 = null;
                            zis.close();
                        }
                        catch (Throwable var36_66) {
                            var37_60 = null;
                            zis.close();
                            throw var36_66;
                        }
                        if (selected_platform != null) {
                            options = new String[selected_sub_platforms.size()];
                            selected_sub_platforms.toArray(options);
                            if (options.length == 1) {
                                selected_platform = selected_platform + "_" + options[0];
                                this.log.log(1, "platform is '" + selected_platform + "'");
                            } else if (options.length > 1) {
                                selected_sub_platform = (String)update.getDecision(0, "Select Platform", "Multiple platform options exist for this plugin, please select required one", options);
                                if (selected_sub_platform == null) {
                                    throw new Exception("Valid sub-platform selection not selected");
                                }
                                selected_platform = selected_platform + "_" + selected_sub_platform;
                                this.log.log(1, "platform is '" + selected_platform + "'");
                            }
                        }
                        if (common_prefix != null) {
                            pos = common_prefix.lastIndexOf("/");
                            common_prefix = pos == -1 ? "" : common_prefix.substring(0, pos + 1);
                            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(target_jar_zip)));
                            try {
                                block45: while (true) {
                                    block137: {
                                        if ((entry = zis.getNextEntry()) == null) {
                                            var55_95 = null;
                                            break;
                                        }
                                        name = entry.getName();
                                        entry_os = null;
                                        origin = null;
                                        initial_target = null;
                                        final_target = null;
                                        is_plugin_properties = false;
                                        try {
                                            if (name.length() >= common_prefix.length() && !name.equals("azureus.sig") && !name.endsWith("/")) {
                                                skip_file = false;
                                                file_name = entry.getName().substring(common_prefix.length());
                                                if (selected_platform != null && file_name.indexOf("platform/") != -1) {
                                                    bit_to_remove = "platform/" + selected_platform;
                                                    pp = file_name.indexOf(bit_to_remove);
                                                    if (pp != -1) {
                                                        file_name = file_name.substring(0, pp) + file_name.substring(pp + bit_to_remove.length() + 1);
                                                    } else {
                                                        skip_file = true;
                                                    }
                                                }
                                                if (file_name.startsWith("shared/lib")) {
                                                    update.setRestartRequired(2);
                                                    unloadable = false;
                                                    if (plugin.getPluginState().isShared()) {
                                                        origin_root = prog_dir;
                                                        install_root = target_prog_dir;
                                                    } else {
                                                        origin_root = user_dir;
                                                        install_root = target_user_dir;
                                                    }
                                                } else {
                                                    origin_root = plugin_dir;
                                                    install_root = target_plugin_dir;
                                                }
                                                origin = new File(origin_root, file_name);
                                                final_target = initial_target = new File(install_root, file_name);
                                                if (origin.exists()) {
                                                    if (file_name.indexOf(47) == -1 && (file_name.toLowerCase(MessageText.LOCALE_ENGLISH).endsWith(".properties") || file_name.toLowerCase(MessageText.LOCALE_ENGLISH).endsWith(".config"))) {
                                                        is_plugin_properties = file_name.toLowerCase(MessageText.LOCALE_ENGLISH).equals("plugin.properties");
                                                        old_file_name = file_name;
                                                        file_name = file_name + "_" + target_version;
                                                        final_target = new File(install_root, file_name);
                                                        this.log.log(1, "saving new file '" + old_file_name + "'as '" + file_name + "'");
                                                    } else if (this.isVersioned(file_name)) {
                                                        this.log.log(1, "Version '" + file_name + "' already present, skipping");
                                                        skip_file = true;
                                                    } else {
                                                        this.log.log(1, "overwriting '" + file_name + "'");
                                                        backup = new File(origin.getParentFile(), origin.getName() + ".bak");
                                                        if (force_indirect_install) {
                                                            if (backup.exists()) {
                                                                installer.addRemoveAction(backup.getAbsolutePath());
                                                            }
                                                            installer.addMoveAction(origin.getAbsolutePath(), backup.getAbsolutePath());
                                                        } else {
                                                            if (backup.exists()) {
                                                                backup.delete();
                                                            }
                                                            if (!initial_target.renameTo(backup)) {
                                                                this.log.log(1, "    failed to backup '" + file_name + "', deferring until restart");
                                                                if (installer == null) {
                                                                    update.setRestartRequired(2);
                                                                    installer = update.getCheckInstance().createInstaller();
                                                                }
                                                                tmp = new File(initial_target.getParentFile(), initial_target.getName() + ".tmp");
                                                                tmp.delete();
                                                                installer.addMoveAction(tmp.getAbsolutePath(), initial_target.getAbsolutePath());
                                                                final_target = tmp;
                                                            }
                                                        }
                                                    }
                                                }
                                                if (!skip_file) {
                                                    FileUtil.mkdirs(final_target.getParentFile());
                                                    entry_os = new FileOutputStream(final_target);
                                                }
                                            }
                                            buffer = new byte[65536];
                                            while (true) {
                                                if ((len = zis.read(buffer)) <= 0) {
                                                    var43_80 = null;
                                                    if (entry_os == null) break block137;
                                                    break;
                                                }
                                                if (entry_os == null) continue;
                                                entry_os.write(buffer, 0, len);
                                            }
                                        }
                                        catch (Throwable var42_76) {
                                            var43_80 = null;
                                            if (entry_os == null) throw var42_76;
                                            entry_os.close();
                                            throw var42_76;
                                        }
                                        entry_os.close();
                                    }
                                    if (is_plugin_properties) {
                                        old_props = new Properties();
                                        new_props = new Properties();
                                        props_to_delete = new ArrayList<String>();
                                        props_to_replace = new HashMap<String, String>();
                                        props_to_insert = new HashMap<String, String>();
                                        try {
                                            fis = new FileInputStream(origin);
                                            try {
                                                old_props.load(fis);
                                            }
                                            catch (Throwable var44_82) {
                                                var45_83 = null;
                                                fis.close();
                                                throw var44_82;
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                        new_props.put("plugin.version", target_version);
                                        prop_names = new String[]{"plugin.name", "plugin.names", "plugin.class", "plugin.classes", "plugin.version", "plugin.langfile"};
                                        for (z = 0; z < prop_names.length; ++z) {
                                            prop_name = prop_names[z];
                                            old_name = old_props.getProperty(prop_name);
                                            new_name = new_props.getProperty(prop_name);
                                            if (new_name == null) continue;
                                            if (prop_name.equals("plugin.name")) {
                                                props_to_delete.add("plugin.names");
                                            } else if (prop_name.equals("plugin.names")) {
                                                props_to_delete.add("plugin.name");
                                            } else if (prop_name.equals("plugin.class")) {
                                                props_to_delete.add("plugin.classes");
                                            } else if (prop_name.equals("plugin.classes")) {
                                                props_to_delete.add("plugin.class");
                                            }
                                            if (old_name == null) {
                                                props_to_insert.put(prop_name, new_name);
                                                continue;
                                            }
                                            if (new_name.equals(old_name)) continue;
                                            props_to_replace.put(prop_name, new_name);
                                        }
                                        tmp_file = force_indirect_install != false ? initial_target : new File(initial_target.getParentFile(), initial_target.getName() + ".tmp");
                                        lnr = null;
                                        tmp = null;
                                        try {
                                            lnr = new LineNumberReader(new FileReader(origin));
                                            tmp = new PrintWriter(new FileWriter(tmp_file));
                                            for (String pn : props_to_insert.keySet()) {
                                                pv = (String)props_to_insert.get(pn);
                                                this.log.log("    Inserting property:" + pn + "=" + pv);
                                                tmp.println(pn + "=" + pv);
                                            }
                                            while (true) {
                                                if ((line = lnr.readLine()) == null) {
                                                    var51_91 = null;
                                                    break;
                                                }
                                                ep = line.indexOf(61);
                                                if (ep != -1) {
                                                    pn = line.substring(0, ep).trim();
                                                    if (props_to_delete.contains(pn)) {
                                                        this.log.log("    Deleting property:" + pn);
                                                        continue;
                                                    }
                                                    rv = (String)props_to_replace.get(pn);
                                                    if (rv != null) {
                                                        this.log.log("    Replacing property:" + pn + " with " + rv);
                                                        tmp.println(pn + "=" + rv);
                                                        continue;
                                                    }
                                                    tmp.println(line);
                                                    continue;
                                                }
                                                tmp.println(line);
                                            }
                                        }
                                        catch (Throwable var50_93) {
                                            var51_91 = null;
                                            lnr.close();
                                            if (tmp == null) throw var50_93;
                                            tmp.close();
                                            throw var50_93;
                                        }
                                        lnr.close();
                                        if (tmp != null) {
                                            tmp.close();
                                        }
                                        bak_file = new File(origin.getParentFile(), origin.getName() + ".bak");
                                        if (force_indirect_install) {
                                            if (bak_file.exists()) {
                                                installer.addRemoveAction(bak_file.getAbsolutePath());
                                            }
                                            installer.addMoveAction(origin.getAbsolutePath(), bak_file.getAbsolutePath());
                                            continue;
                                        }
                                        if (bak_file.exists()) {
                                            bak_file.delete();
                                        }
                                        if (!initial_target.renameTo(bak_file)) {
                                            throw new IOException("Failed to rename '" + initial_target.toString() + "' to '" + bak_file.toString() + "'");
                                        }
                                        if (!tmp_file.renameTo(initial_target)) {
                                            bak_file.renameTo(initial_target);
                                            throw new IOException("Failed to rename '" + tmp_file.toString() + "' to '" + initial_target.toString() + "'");
                                        }
                                        bak_file.delete();
                                        continue;
                                    }
                                    if (final_target == null || !final_target.getName().equalsIgnoreCase("update.txt")) continue;
                                    update_txt_found = true;
                                    lnr = null;
                                    try {
                                        try {
                                            lnr = new LineNumberReader(new FileReader(final_target));
                                            while (true) {
                                                if ((line = lnr.readLine()) == null) {
                                                    var53_92 = null;
                                                    if (lnr == null) continue block45;
                                                    break;
                                                }
                                                this.log.log(1, line);
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            var53_92 = null;
                                            if (lnr == null) continue;
                                            lnr.close();
                                            continue;
                                        }
                                    }
                                    catch (Throwable var52_94) {
                                        var53_92 = null;
                                        if (lnr == null) throw var52_94;
                                        lnr.close();
                                        throw var52_94;
                                    }
                                    lnr.close();
                                }
                            }
                            catch (Throwable var54_97) {
                                var55_96 = null;
                                zis.close();
                                throw var54_97;
                            }
                            zis.close();
                        }
                    }
                    if (unloadable) {
                        plugin_id = plugin.getPluginID();
                        plugins = plugin.getPluginManager().getPlugins();
                        plugin_unloadable = true;
                        for (j = 0; j < plugins.length; ++j) {
                            pi = plugins[j];
                            if (!pi.getPluginID().equals(plugin_id)) continue;
                            plugin_unloadable &= pi.getPluginState().isUnloadable();
                        }
                        if (!plugin_unloadable) {
                            this.log.log("Switching unloadability for " + plugin_id + " as changed during update");
                            update.setRestartRequired(2);
                            unloadable = false;
                        }
                    }
                    if (force_indirect_install) {
                        defer_restart = false;
                        if (this.addInstallationActions(installer, install_properties, "%plugin%", target_plugin_dir, plugin_dir)) {
                            defer_restart = true;
                        }
                        if (this.addInstallationActions(installer, install_properties, "%app%", target_prog_dir, prog_dir)) {
                            defer_restart = true;
                        }
                        if (this.addInstallationActions(installer, install_properties, "%user%", target_user_dir, user_dir)) {
                            defer_restart = true;
                        }
                        if (defer_restart && update.getRestartRequired() == 2) {
                            this.log.log("Deferring restart for '" + plugin.getPluginID() + "'");
                            update.setRestartRequired(1);
                        }
                    } else {
                        defer_restart = false;
                        if (this.applyInstallProperties(install_properties, "%plugin%", plugin_dir)) {
                            defer_restart = true;
                        }
                        if (this.applyInstallProperties(install_properties, "%app%", prog_dir)) {
                            defer_restart = true;
                        }
                        if (this.applyInstallProperties(install_properties, "%user%", user_dir)) {
                            defer_restart = true;
                        }
                        if (unloadable) {
                            this.log.log("Plugin initialising, please wait... ");
                            plugin.getPluginState().reload();
                            this.log.log("... initialisation complete.");
                        } else if (defer_restart && update.getRestartRequired() == 2) {
                            this.log.log("Deferring restart for '" + plugin.getPluginID() + "'");
                            update.setRestartRequired(1);
                        }
                    }
                }
                b_disable = (Boolean)update.getCheckInstance().getProperty(3);
                if (update_txt_found || b_disable == null || !b_disable.booleanValue()) {
                    msg = "Version " + new_version + " of plugin '" + update.getName() + "' " + "installed successfully";
                    if (update_txt_found) {
                        msg = msg + " - See update log for details";
                    }
                    this.log.logAlertRepeatable(update_txt_found != false ? 2 : 1, msg);
                }
                try {
                    plugin_id = plugin.getPluginID();
                    PluginInitializer.fireEvent(checker.getCheckInstance().getType() == 1 ? 10 : 11, plugin_id);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                update_successful = true;
            }
            catch (Throwable e) {
                msg = "Version " + new_version + " of plugin '" + update.getName() + "' " + "failed to install - " + e.getMessage();
                this.log.logAlertRepeatable(3, msg);
                var57_99 = null;
                update.complete(update_successful);
                if (data == null) return;
                try {}
                catch (Throwable e) {
                    return;
                }
                data.close();
                return;
            }
            var57_98 = null;
            update.complete(update_successful);
            if (data == null) return;
            try {
                data.close();
                return;
            }
            catch (Throwable e) {
                return;
            }
        }
        catch (Throwable var56_104) {
            var57_100 = null;
            update.complete(update_successful);
            if (data == null) throw var56_104;
            ** try [egrp 17[TRYBLOCK] [30 : 4261->4269)] { 
lbl470:
            // 1 sources

            data.close();
            throw var56_104;
lbl472:
            // 1 sources

            catch (Throwable e) {
                // empty catch block
            }
            throw var56_104;
        }
    }

    protected boolean addInstallationActions(UpdateInstaller installer, Map<String, List<String[]>> install_properties, String prefix, File from_file, File to_file) throws UpdateException {
        boolean defer_restart;
        block6: {
            block5: {
                defer_restart = false;
                if (!from_file.isDirectory()) break block5;
                File[] files = from_file.listFiles();
                if (files == null) break block6;
                for (int i = 0; i < files.length; ++i) {
                    if (!this.addInstallationActions(installer, install_properties, prefix + "/" + files[i].getName(), files[i], new File(to_file, files[i].getName()))) continue;
                    defer_restart = true;
                }
                break block6;
            }
            installer.addMoveAction(from_file.getAbsolutePath(), to_file.getAbsolutePath());
            List<String[]> commands = install_properties.get(prefix);
            if (commands != null) {
                for (String[] command : commands) {
                    String cmd = command[1];
                    if (cmd.equals("chmod")) {
                        if (Constants.isWindows) continue;
                        this.log.log("Applying " + cmd + " " + command[2] + " to " + to_file);
                        installer.addChangeRightsAction(command[2], to_file.getAbsolutePath());
                        continue;
                    }
                    if (cmd.equals("rm")) {
                        this.log.log("Deleting " + to_file);
                        installer.addRemoveAction(to_file.getAbsolutePath());
                        continue;
                    }
                    if (!cmd.equals("defer_restart")) continue;
                    defer_restart = true;
                }
            }
        }
        return defer_restart;
    }

    protected boolean applyInstallProperties(Map<String, List<String[]>> install_properties, String prefix, File to_file) {
        boolean defer_restart;
        block7: {
            block6: {
                defer_restart = false;
                if (!to_file.isDirectory()) break block6;
                File[] files = to_file.listFiles();
                if (files == null) break block7;
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    String file_name = file.getName();
                    if (file_name.equals(".") || file_name.equals("..")) continue;
                    String new_prefix = prefix + "/" + file_name;
                    boolean match = false;
                    for (String s : install_properties.keySet()) {
                        if (!s.startsWith(new_prefix)) continue;
                        match = true;
                        break;
                    }
                    if (!match || !this.applyInstallProperties(install_properties, new_prefix, files[i])) continue;
                    defer_restart = true;
                }
                break block7;
            }
            List<String[]> commands = install_properties.get(prefix);
            if (commands != null) {
                for (String[] command : commands) {
                    String cmd = command[1];
                    if (cmd.equals("chmod")) {
                        if (Constants.isWindows) continue;
                        this.runCommand(new String[]{"chmod", command[2], to_file.getAbsolutePath().replaceAll(" ", "\\ ")});
                        continue;
                    }
                    if (cmd.equals("rm")) {
                        this.log.log("Deleting " + to_file);
                        to_file.delete();
                        continue;
                    }
                    if (!cmd.equals("defer_restart")) continue;
                    defer_restart = true;
                }
            }
        }
        return defer_restart;
    }

    private void runCommand(String[] command) {
        try {
            command[0] = this.findCommand(command[0]);
            String str = "";
            for (String s : command) {
                str = str + " " + s;
            }
            this.log.log("Executing" + str);
            Runtime.getRuntime().exec(command).waitFor();
        }
        catch (Throwable e) {
            this.log.log("Failed to execute command", e);
        }
    }

    private String findCommand(String name) {
        String[] locations;
        for (String s : locations = new String[]{"/bin", "/usr/bin"}) {
            File f = new File(s, name);
            if (!f.exists() || !f.canRead()) continue;
            return f.getAbsolutePath();
        }
        return name;
    }

    protected boolean isVersioned(String name) {
        int pos = name.lastIndexOf(95);
        if (pos == -1 || name.endsWith("_")) {
            return false;
        }
        String rem = name.substring(pos + 1);
        if ((pos = rem.lastIndexOf(46)) != -1) {
            rem = rem.substring(0, pos);
        }
        for (int i = 0; i < rem.length(); ++i) {
            char c = rem.charAt(i);
            if (c == '.' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    protected void logMultiLine(String indent, List lines) {
        for (int i = 0; i < lines.size(); ++i) {
            this.log.log(1, indent + (String)lines.get(i));
        }
    }
}

