/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.applet.Applet;
import java.io.File;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterfaceAlerts
implements UISWTConfigSection {
    private static final String INTERFACE_PREFIX = "ConfigView.section.interface.";
    private static final String LBLKEY_PREFIX = "ConfigView.label.";
    private static final String STYLE_PREFIX = "ConfigView.section.style.";
    private static final int REQUIRED_MODE = 0;

    public String configSectionGetParentSection() {
        return "style";
    }

    public String configSectionGetName() {
        return "interface.alerts";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("openFolderButton");
    }

    public int maxUserMode() {
        return 0;
    }

    public Composite configSectionCreate(final Composite parent) {
        Image imgOpenFolder = null;
        ImageLoader imageLoader = ImageLoader.getInstance();
        imgOpenFolder = imageLoader.getImage("openFolderButton");
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        cSection.setLayout((Layout)layout);
        Composite cArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData(768));
        if (Constants.isOSX) {
            new BooleanParameter(cArea, "Play Download Finished Announcement", "ConfigView.label.playdownloadspeech");
            StringParameter d_speechParameter = new StringParameter(cArea, "Play Download Finished Announcement Text");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 150;
            d_speechParameter.setLayoutData(gridData);
            ((Text)d_speechParameter.getControl()).setTextLimit(40);
        }
        new BooleanParameter(cArea, "Play Download Finished", "ConfigView.label.playdownloadfinished");
        gridData = new GridData(768);
        final StringParameter d_pathParameter = new StringParameter(cArea, "Play Download Finished File", "");
        if (d_pathParameter.getValue().length() == 0) {
            d_pathParameter.setValue("<default>");
        }
        d_pathParameter.setLayoutData(gridData);
        Button d_browse = new Button(cArea, 8);
        d_browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(d_browse.getBackground());
        d_browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        d_browse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FileDialog dialog = new FileDialog(parent.getShell(), 65536);
                dialog.setFilterExtensions(new String[]{"*.wav"});
                dialog.setFilterNames(new String[]{"*.wav"});
                dialog.setText(MessageText.getString("ConfigView.section.interface.wavlocation"));
                final String path = dialog.open();
                if (path != null) {
                    d_pathParameter.setValue(path);
                    new AEThread2("SoundTest"){

                        public void run() {
                            try {
                                Applet.newAudioClip(new File(path).toURI().toURL()).play();
                                Thread.sleep(2500L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
            }
        });
        Label d_sound_info = new Label(cArea, 64);
        Messages.setLanguageText((Widget)d_sound_info, "ConfigView.section.interface.wavlocation.info");
        gridData = new GridData(768);
        gridData.widthHint = 100;
        d_sound_info.setLayoutData((Object)gridData);
        if (Constants.isOSX) {
            BooleanParameter f_speechEnabledParameter = new BooleanParameter(cArea, "Play File Finished Announcement", "ConfigView.label.playfilespeech");
            StringParameter f_speechParameter = new StringParameter(cArea, "Play File Finished Announcement Text");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 150;
            f_speechParameter.setLayoutData(gridData);
            ((Text)f_speechParameter.getControl()).setTextLimit(40);
        }
        BooleanParameter f_play_sound = new BooleanParameter(cArea, "Play File Finished", "ConfigView.label.playfilefinished");
        gridData = new GridData(768);
        final StringParameter f_pathParameter = new StringParameter(cArea, "Play File Finished File", "");
        if (f_pathParameter.getValue().length() == 0) {
            f_pathParameter.setValue("<default>");
        }
        f_pathParameter.setLayoutData(gridData);
        Button f_browse = new Button(cArea, 8);
        f_browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(f_browse.getBackground());
        f_browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        f_browse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FileDialog dialog = new FileDialog(parent.getShell(), 65536);
                dialog.setFilterExtensions(new String[]{"*.wav"});
                dialog.setFilterNames(new String[]{"*.wav"});
                dialog.setText(MessageText.getString("ConfigView.section.interface.wavlocation"));
                final String path = dialog.open();
                if (path != null) {
                    f_pathParameter.setValue(path);
                    new AEThread2("SoundTest"){

                        public void run() {
                            try {
                                Applet.newAudioClip(new File(path).toURI().toURL()).play();
                                Thread.sleep(2500L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
            }
        });
        Label f_sound_info = new Label(cArea, 64);
        Messages.setLanguageText((Widget)f_sound_info, "ConfigView.section.interface.wavlocation.info");
        gridData = new GridData(768);
        gridData.widthHint = 100;
        f_sound_info.setLayoutData((Object)gridData);
        boolean isAZ3 = COConfigurationManager.getStringParameter("ui").equals("az3");
        if (isAZ3) {
            BooleanParameter p = new BooleanParameter(cArea, "Request Attention On New Download", "ConfigView.label.dl.add.req.attention");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            p.setLayoutData(gridData);
        }
        BooleanParameter activate_win = new BooleanParameter(cArea, "Activate Window On External Download", "ConfigView.label.show.win.on.add");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        activate_win.setLayoutData(gridData);
        Group gPopup = new Group(cSection, 0);
        Messages.setLanguageText((Widget)gPopup, "label.popups");
        layout = new GridLayout();
        layout.numColumns = 2;
        gPopup.setLayout((Layout)layout);
        gPopup.setLayoutData((Object)new GridData(768));
        BooleanParameter popup_dl_added = new BooleanParameter((Composite)gPopup, "Popup Download Added", "ConfigView.label.popupdownloadadded");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        popup_dl_added.setLayoutData(gridData);
        BooleanParameter popup_dl_completed = new BooleanParameter((Composite)gPopup, "Popup Download Finished", "ConfigView.label.popupdownloadfinished");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        popup_dl_completed.setLayoutData(gridData);
        BooleanParameter popup_file_completed = new BooleanParameter((Composite)gPopup, "Popup File Finished", "ConfigView.label.popupfilefinished");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        popup_file_completed.setLayoutData(gridData);
        BooleanParameter disable_sliding = new BooleanParameter((Composite)gPopup, "GUI_SWT_DisableAlertSliding", "ConfigView.section.style.disableAlertSliding");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        disable_sliding.setLayoutData(gridData);
        BooleanParameter show_alert_timestamps = new BooleanParameter((Composite)gPopup, "Show Timestamp For Alerts", "ConfigView.label.popup.timestamp");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        show_alert_timestamps.setLayoutData(gridData);
        Label label = new Label((Composite)gPopup, 64);
        Messages.setLanguageText((Widget)label, "ConfigView.label.popup.autohide");
        label.setLayoutData((Object)new GridData());
        IntParameter auto_hide_alert = new IntParameter((Composite)gPopup, "Message Popup Autoclose in Seconds", 0, 86400);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        auto_hide_alert.setLayoutData(gridData);
        return cSection;
    }
}

