/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportAlternativeContact;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.SystemTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTTransportAlternativeContactImpl
implements DHTTransportAlternativeContact {
    private final byte network_type;
    private final byte version;
    private final short initial_age;
    private final byte[] encoded;
    private final int id;
    private final int start_time = (int)(SystemTime.getMonotonousTime() / 1000L);

    protected DHTTransportAlternativeContactImpl(byte _network_type, byte _version, short _age, byte[] _encoded) {
        this.network_type = _network_type;
        this.version = _version;
        this.initial_age = (short)(_age < 0 ? Short.MAX_VALUE : (int)_age);
        this.encoded = _encoded;
        this.id = Arrays.hashCode(this.encoded);
    }

    @Override
    public int getNetworkType() {
        return this.network_type & 0xFF;
    }

    @Override
    public int getVersion() {
        return this.version & 0xFF;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int getLastAlive() {
        return this.start_time - this.initial_age;
    }

    @Override
    public int getAge() {
        if (this.initial_age < 0) {
            return Short.MAX_VALUE;
        }
        int rem = Short.MAX_VALUE - this.initial_age;
        int elapsed = (int)(SystemTime.getMonotonousTime() / 1000L) - this.start_time;
        if (rem < elapsed) {
            return Short.MAX_VALUE;
        }
        return (short)(this.initial_age + elapsed);
    }

    @Override
    public Map<String, Object> getProperties() {
        try {
            return BDecoder.decode(this.encoded);
        }
        catch (Throwable e) {
            return new HashMap<String, Object>();
        }
    }
}

