/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.MultiPeerDownloader2;
import com.aelitis.azureus.core.networkmanager.impl.MultiPeerUploader;
import com.aelitis.azureus.core.networkmanager.impl.SinglePeerDownloader;
import com.aelitis.azureus.core.networkmanager.impl.SinglePeerUploader;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class EntityHandler {
    private final HashMap upgraded_connections = new HashMap();
    private final AEMonitor lock = new AEMonitor("EntityHandler");
    private final MultiPeerUploader global_uploader;
    private final MultiPeerDownloader2 global_downloader;
    private boolean global_registered = false;
    private final int handler_type;

    public EntityHandler(int type, RateHandler rate_handler) {
        this.handler_type = type;
        if (this.handler_type == 0) {
            this.global_uploader = new MultiPeerUploader(rate_handler);
            this.global_downloader = null;
        } else {
            this.global_downloader = new MultiPeerDownloader2(rate_handler);
            this.global_uploader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPeerConnection(NetworkConnectionBase connection) {
        try {
            this.lock.enter();
            if (!this.global_registered) {
                if (this.handler_type == 0) {
                    NetworkManager.getSingleton().addWriteEntity(this.global_uploader, -1);
                } else {
                    NetworkManager.getSingleton().addReadEntity(this.global_downloader, -1);
                }
                this.global_registered = true;
            }
            Object var3_2 = null;
            this.lock.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.exit();
            throw throwable;
        }
        if (this.handler_type == 0) {
            this.global_uploader.addPeerConnection(connection);
        } else {
            this.global_downloader.addPeerConnection(connection);
        }
    }

    public void cancelPeerConnection(NetworkConnectionBase connection) {
        SinglePeerDownloader download_entity;
        if (this.handler_type == 0) {
            SinglePeerUploader upload_entity;
            if (!this.global_uploader.removePeerConnection(connection) && (upload_entity = (SinglePeerUploader)this.upgraded_connections.remove(connection)) != null) {
                NetworkManager.getSingleton().removeWriteEntity(upload_entity);
            }
        } else if (!this.global_downloader.removePeerConnection(connection) && (download_entity = (SinglePeerDownloader)this.upgraded_connections.remove(connection)) != null) {
            NetworkManager.getSingleton().removeReadEntity(download_entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradePeerConnection(NetworkConnectionBase connection, RateHandler handler, int partition_id) {
        try {
            this.lock.enter();
            if (this.handler_type == 0) {
                SinglePeerUploader upload_entity = new SinglePeerUploader(connection, handler);
                if (!this.global_uploader.removePeerConnection(connection)) {
                    Debug.out("upgradePeerConnection:: upload entity not found/removed !");
                }
                NetworkManager.getSingleton().addWriteEntity(upload_entity, partition_id);
                this.upgraded_connections.put(connection, upload_entity);
            } else {
                SinglePeerDownloader download_entity = new SinglePeerDownloader(connection, handler);
                if (!this.global_downloader.removePeerConnection(connection)) {
                    Debug.out("upgradePeerConnection:: download entity not found/removed !");
                }
                NetworkManager.getSingleton().addReadEntity(download_entity, partition_id);
                this.upgraded_connections.put(connection, download_entity);
            }
            Object var6_6 = null;
            this.lock.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downgradePeerConnection(NetworkConnectionBase connection) {
        try {
            this.lock.enter();
            if (this.handler_type == 0) {
                SinglePeerUploader upload_entity = (SinglePeerUploader)this.upgraded_connections.remove(connection);
                if (upload_entity != null) {
                    NetworkManager.getSingleton().removeWriteEntity(upload_entity);
                } else {
                    Debug.out("upload_entity == null");
                }
                this.global_uploader.addPeerConnection(connection);
            } else {
                SinglePeerDownloader download_entity = (SinglePeerDownloader)this.upgraded_connections.remove(connection);
                if (download_entity != null) {
                    NetworkManager.getSingleton().removeReadEntity(download_entity);
                } else {
                    Debug.out("download_entity == null");
                }
                this.global_downloader.addPeerConnection(connection);
            }
            Object var4_4 = null;
            this.lock.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateHandler getRateHandler(NetworkConnectionBase connection) {
        block7: {
            block5: {
                block6: {
                    try {
                        this.lock.enter();
                        if (this.handler_type != 0) break block5;
                        SinglePeerUploader upload_entity = (SinglePeerUploader)this.upgraded_connections.get(connection);
                        if (upload_entity == null) break block6;
                        RateHandler rateHandler = upload_entity.getRateHandler();
                        Object var5_8 = null;
                        this.lock.exit();
                        return rateHandler;
                    }
                    catch (Throwable throwable) {
                        Object var5_12 = null;
                        this.lock.exit();
                        throw throwable;
                    }
                }
                RateHandler rateHandler = this.global_uploader.getRateHandler();
                Object var5_9 = null;
                this.lock.exit();
                return rateHandler;
            }
            SinglePeerDownloader download_entity = (SinglePeerDownloader)this.upgraded_connections.get(connection);
            if (download_entity == null) break block7;
            RateHandler rateHandler = download_entity.getRateHandler();
            Object var5_10 = null;
            this.lock.exit();
            return rateHandler;
        }
        RateHandler rateHandler = this.global_downloader.getRateHandler();
        Object var5_11 = null;
        this.lock.exit();
        return rateHandler;
    }
}

