/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.test;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelectorFactory;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderAdapter;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderInitial;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.Debug;

public class PHETester {
    private final VirtualChannelSelector connect_selector = new VirtualChannelSelector("PHETester", 8, true);
    private byte[] TEST_HEADER = "TestHeader".getBytes();
    private static boolean OUTGOING_PLAIN = false;
    private static byte[] shared_secret = "sdsjdksjdkj".getBytes();

    public PHETester() {
        ProtocolDecoder.addSecrets(new byte[][]{shared_secret});
        VirtualServerChannelSelector accept_server = VirtualServerChannelSelectorFactory.createNonBlocking(new InetSocketAddress(8765), 0, new VirtualServerChannelSelector.SelectListener(){

            public void newConnectionAccepted(ServerSocketChannel server, SocketChannel channel2) {
                PHETester.this.incoming(channel2);
            }
        });
        accept_server.start();
        new Thread(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            PHETester.this.connect_selector.select(100L);
                        }
                    }
                    catch (Throwable t) {
                        Debug.out("connnectSelectLoop() EXCEPTION: ", t);
                        continue;
                    }
                    break;
                }
            }
        }.start();
        this.outgoings();
    }

    protected void incoming(SocketChannel channel2) {
        try {
            TCPTransportHelper helper = new TCPTransportHelper(channel2);
            ProtocolDecoderInitial protocolDecoderInitial = new ProtocolDecoderInitial(helper, null, false, null, new ProtocolDecoderAdapter(){

                public void decodeComplete(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                    System.out.println("incoming decode complete: " + decoder.getFilter().getName(false));
                    PHETester.this.readStream("incoming", decoder.getFilter());
                    PHETester.this.writeStream("ten fat monkies", decoder.getFilter());
                }

                public void decodeFailed(ProtocolDecoder decoder, Throwable cause) {
                    System.out.println("incoming decode failed: " + Debug.getNestedExceptionMessage(cause));
                }

                public void gotSecret(byte[] session_secret) {
                }

                public int getMaximumPlainHeaderLength() {
                    return PHETester.this.TEST_HEADER.length;
                }

                public int matchPlainHeader(ByteBuffer buffer) {
                    int pos = buffer.position();
                    int lim = buffer.limit();
                    buffer.flip();
                    boolean match = buffer.compareTo(ByteBuffer.wrap(PHETester.this.TEST_HEADER)) == 0;
                    buffer.position(pos);
                    buffer.limit(lim);
                    System.out.println("Match - " + match);
                    return match ? 2 : 1;
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void outgoings() {
        while (true) {
            this.outgoing();
            try {
                Thread.sleep(1000000L);
            }
            catch (Throwable throwable) {
            }
        }
    }

    protected void outgoing() {
        try {
            final SocketChannel channel2 = SocketChannel.open();
            try {
                channel2.configureBlocking(false);
            }
            catch (IOException e) {
                channel2.close();
                throw e;
            }
            if (channel2.connect(new InetSocketAddress("localhost", 8765))) {
                this.outgoing(channel2);
            } else {
                this.connect_selector.register(channel2, new VirtualChannelSelector.VirtualSelectorListener(){

                    public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                        try {
                            if (channel2.finishConnect()) {
                                PHETester.this.outgoing(channel2);
                                return true;
                            }
                            throw new IOException("finishConnect failed");
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            return false;
                        }
                    }

                    public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                        msg.printStackTrace();
                    }
                }, null);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void outgoing(SocketChannel channel2) {
        try {
            if (OUTGOING_PLAIN) {
                this.writeStream(this.TEST_HEADER, channel2);
                this.writeStream("two jolly porkers".getBytes(), channel2);
            } else {
                TCPTransportHelper helper = new TCPTransportHelper(channel2);
                ProtocolDecoderInitial protocolDecoderInitial = new ProtocolDecoderInitial(helper, new byte[][]{shared_secret}, true, null, new ProtocolDecoderAdapter(){

                    public void decodeComplete(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                        System.out.println("outgoing decode complete: " + decoder.getFilter().getName(false));
                        PHETester.this.readStream("incoming", decoder.getFilter());
                        PHETester.this.writeStream(PHETester.this.TEST_HEADER, decoder.getFilter());
                        PHETester.this.writeStream("two jolly porkers", decoder.getFilter());
                    }

                    public void decodeFailed(ProtocolDecoder decoder, Throwable cause) {
                        System.out.println("outgoing decode failed: " + Debug.getNestedExceptionMessage(cause));
                    }

                    public void gotSecret(byte[] session_secret) {
                    }

                    public int getMaximumPlainHeaderLength() {
                        throw new RuntimeException();
                    }

                    public int matchPlainHeader(ByteBuffer buffer) {
                        throw new RuntimeException();
                    }
                });
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void readStream(final String str, final TransportHelperFilter filter2) {
        try {
            TCPNetworkManager.getSingleton().getReadSelector().register(((TCPTransportHelper)filter2.getHelper()).getSocketChannel(), new VirtualChannelSelector.VirtualSelectorListener(){

                public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                    ByteBuffer buffer = ByteBuffer.allocate(1024);
                    try {
                        long len = filter2.read(new ByteBuffer[]{buffer}, 0, 1);
                        byte[] data = new byte[buffer.position()];
                        buffer.flip();
                        buffer.get(data);
                        System.out.println(str + ": " + new String(data));
                        return len > 0L;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        return false;
                    }
                }

                public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                    msg.printStackTrace();
                }
            }, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void writeStream(String str, TransportHelperFilter filter2) {
        this.writeStream(str.getBytes(), filter2);
    }

    protected void writeStream(byte[] data, TransportHelperFilter filter2) {
        try {
            filter2.write(new ByteBuffer[]{ByteBuffer.wrap(data)}, 0, 1);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void writeStream(byte[] data, SocketChannel channel2) {
        try {
            channel2.write(new ByteBuffer[]{ByteBuffer.wrap(data)}, 0, 1);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AEDiagnostics.startup(false);
        COConfigurationManager.setParameter("network.transport.encrypted.require", true);
        COConfigurationManager.setParameter("network.transport.encrypted.min_level", "Plain");
        new PHETester();
        try {
            Thread.sleep(10000000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

