/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZUTMetaData;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZMetaData
implements AZMessage,
AZUTMetaData {
    private final byte version;
    private DirectByteBuffer buffer = null;
    private int msg_type;
    private int piece;
    private DirectByteBuffer metadata;
    private int total_size;

    public AZMetaData(int _piece, byte _version) {
        this.msg_type = 0;
        this.piece = _piece;
        this.version = _version;
    }

    public AZMetaData(int _piece, ByteBuffer _data, int _total_size, byte _version) {
        this.msg_type = _data == null ? 2 : 1;
        this.piece = _piece;
        this.total_size = _total_size;
        this.version = _version;
        if (_data != null) {
            this.metadata = new DirectByteBuffer(_data);
        }
    }

    public AZMetaData(Map map, DirectByteBuffer data, byte _version) {
        if (map != null) {
            this.msg_type = ((Long)map.get("msg_type")).intValue();
            this.piece = ((Long)map.get("piece")).intValue();
        }
        this.metadata = data;
        this.version = _version;
    }

    public String getID() {
        return "AZ_METADATA";
    }

    public byte[] getIDBytes() {
        return ID_AZ_METADATA_BYTES;
    }

    public String getFeatureID() {
        return "AZ1";
    }

    public int getFeatureSubID() {
        return 8;
    }

    public int getType() {
        return 0;
    }

    public byte getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.getID() + " piece #" + this.piece + ", mt=" + this.msg_type;
    }

    public int getMessageType() {
        return this.msg_type;
    }

    public int getPiece() {
        return this.piece;
    }

    public DirectByteBuffer getMetadata() {
        return this.metadata;
    }

    public void setMetadata(DirectByteBuffer b) {
        this.metadata = b;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Number> payload_map = new HashMap<String, Number>();
            payload_map.put("msg_type", new Long(this.msg_type));
            payload_map.put("piece", new Long(this.piece));
            if (this.total_size > 0) {
                payload_map.put("total_size", this.total_size);
            }
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(payload_map, (byte)35);
        }
        if (this.msg_type == 1) {
            return new DirectByteBuffer[]{this.buffer, this.metadata};
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data, byte version) throws MessageException {
        int pos = data.position((byte)11);
        byte[] dict_bytes = new byte[Math.min(128, data.remaining((byte)11))];
        data.get((byte)11, dict_bytes);
        try {
            Map<String, Object> root = BDecoder.decode(dict_bytes);
            data.position((byte)11, pos + BEncoder.encode(root).length);
            return new AZMetaData(root, data, version);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new MessageException("decode failed", e);
        }
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
        if (this.metadata != null) {
            this.metadata.returnToPool();
        }
    }
}

