/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiChildCloseListener;
import com.aelitis.azureus.ui.mdi.MdiCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener2;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MdiListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUI;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.views.skin.SBC_PlusFTUX;
import com.aelitis.azureus.ui.swt.views.skin.SBC_TorrentDetailsView;
import com.aelitis.azureus.ui.swt.views.skin.SB_Discovery;
import com.aelitis.azureus.ui.swt.views.skin.SB_Transfers;
import com.aelitis.azureus.ui.swt.views.skin.SB_Vuze;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.FeatureUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.download.DownloadStubEvent;
import org.gudy.azureus2.plugins.download.DownloadStubListener;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener2;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.ConfigShell;
import org.gudy.azureus2.ui.swt.views.ConfigView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;
import org.gudy.azureus2.ui.swt.views.PeersSuperView;
import org.gudy.azureus2.ui.swt.views.TorrentOptionsView;
import org.gudy.azureus2.ui.swt.views.clientstats.ClientStatsView;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class MainMDISetup {
    public static void setupSideBar(final MultipleDocumentInterfaceSWT mdi, final MdiListener l) {
        if (Utils.isAZ2UI()) {
            MainMDISetup.setupSidebarClassic(mdi);
        } else {
            MainMDISetup.setupSidebarVuzeUI(mdi);
        }
        SBC_TorrentDetailsView.TorrentDetailMdiEntry.register(mdi);
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        pi.getUIManager().addUIListener(new UIManagerListener2(){

            public void UIDetached(UIInstance instance) {
            }

            public void UIAttached(UIInstance instance) {
            }

            public void UIAttachedComplete(UIInstance instance) {
                String startTab;
                ContentNetwork startupCN;
                PluginInitializer.getDefaultInterface().getUIManager().removeUIListener(this);
                MdiEntry currentEntry = mdi.getCurrentEntry();
                if (currentEntry != null) {
                    return;
                }
                String CFG_STARTTAB = "v3.StartTab";
                String CFG_STARTTAB_DS = "v3.StartTab.ds";
                String datasource = null;
                boolean showWelcome = COConfigurationManager.getBooleanParameter("v3.Show Welcome");
                if (ConfigurationChecker.isNewVersion()) {
                    showWelcome = true;
                }
                if ((startupCN = ContentNetworkManagerFactory.getSingleton().getStartupContentNetwork()) == null || !startupCN.isServiceSupported(8)) {
                    showWelcome = false;
                }
                if (showWelcome) {
                    startTab = "Welcome";
                } else {
                    if (!COConfigurationManager.hasParameter("v3.StartTab", true)) {
                        COConfigurationManager.setParameter("v3.StartTab", "Library");
                    }
                    startTab = COConfigurationManager.getStringParameter("v3.StartTab");
                    datasource = COConfigurationManager.getStringParameter("v3.StartTab.ds", null);
                }
                if (startTab.equals("Plus")) {
                    SBC_PlusFTUX.setSourceRef("lastview");
                }
                if (!mdi.loadEntryByID(startTab, true, false, datasource)) {
                    mdi.showEntryByID("Library");
                }
                if (l != null) {
                    mdi.addListener(l);
                }
            }
        });
        COConfigurationManager.addAndFireParameterListener("Beta Programme Enabled", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
                if (enabled) {
                    mdi.loadEntryByID("BetaProgramme", false);
                }
            }
        });
        mdi.registerEntry(StatsView.VIEW_ID, new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.plugins", new StatsView(), id, true, null, null);
                return entry;
            }
        });
        mdi.registerEntry("AllPeersView", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.transfers", new PeersSuperView(), id, true, null, null);
                entry.setImageLeftID("image.sidebar.allpeers");
                return entry;
            }
        });
        mdi.registerEntry("LoggerView", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.plugins", new LoggerView(), id, true, null, null);
                return entry;
            }
        });
        mdi.registerEntry("TagsOverview", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", id, "tagsview", "{mdi.entry.tagsoverview}", null, null, true, null);
                entry.setImageLeftID("image.sidebar.tag-overview");
                entry.setDefaultExpanded(true);
                return entry;
            }
        });
        mdi.registerEntry("TagDiscovery", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("TagsOverview", id, "tagdiscoveryview", "{mdi.entry.tagdiscovery}", null, null, true, null);
                entry.setImageLeftID("image.sidebar.tag-overview");
                return entry;
            }
        });
        mdi.registerEntry("ChatOverview", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "ChatOverview", "chatsview", "{mdi.entry.chatsoverview}", null, null, true, null);
                entry.setImageLeftID("image.sidebar.chat-overview");
                return entry;
            }
        });
        mdi.registerEntry("ArchivedDownloads", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                final DownloadManager download_manager = PluginInitializer.getDefaultInterface().getDownloadManager();
                final ViewTitleInfo title_info = new ViewTitleInfo(){

                    public Object getTitleInfoProperty(int propertyID) {
                        if (propertyID == 0) {
                            int num = download_manager.getDownloadStubCount();
                            return String.valueOf(num);
                        }
                        return null;
                    }
                };
                MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "ArchivedDownloads", "archivedlsview", "{mdi.entry.archiveddownloadsview}", title_info, null, true, null);
                entry.setImageLeftID("image.sidebar.archive");
                final DownloadStubListener stub_listener = new DownloadStubListener(){

                    public void downloadStubEventOccurred(DownloadStubEvent event2) {
                        ViewTitleInfoManager.refreshTitleInfo(title_info);
                    }
                };
                download_manager.addDownloadStubListener(stub_listener, false);
                entry.addListener(new MdiCloseListener(){

                    public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                        download_manager.removeDownloadStubListener(stub_listener);
                    }
                });
                entry.addListener(new MdiEntryDropListener(){

                    public boolean mdiEntryDrop(MdiEntry entry, Object data) {
                        if (data instanceof String) {
                            String str = (String)data;
                            if (str.startsWith("DownloadManager\n")) {
                                String[] bits = str.split("\n");
                                DownloadManager dm = PluginInitializer.getDefaultInterface().getDownloadManager();
                                ArrayList<Download> downloads = new ArrayList<Download>();
                                boolean failed = false;
                                for (int i = 1; i < bits.length; ++i) {
                                    byte[] hash = Base32.decode(bits[i]);
                                    try {
                                        Download download = dm.getDownload(hash);
                                        if (download.canStubbify()) {
                                            downloads.add(download);
                                            continue;
                                        }
                                        failed = true;
                                        continue;
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                }
                                final boolean f_failed = failed;
                                ManagerUtils.moveToArchive(downloads, new ManagerUtils.ArchiveCallback(){
                                    boolean error;
                                    {
                                        this.error = f_failed;
                                    }

                                    public void failed(DownloadStub original, Throwable e) {
                                        this.error = true;
                                    }

                                    public void completed() {
                                        if (this.error) {
                                            String title = MessageText.getString("archive.failed.title");
                                            String text = MessageText.getString("archive.failed.text");
                                            MessageBoxShell prompter = new MessageBoxShell(title, text, new String[]{MessageText.getString("Button.ok")}, 0);
                                            prompter.setAutoCloseInMS(0);
                                            prompter.open(null);
                                        }
                                    }
                                });
                            }
                            return true;
                        }
                        return false;
                    }
                });
                return entry;
            }
        });
        mdi.registerEntry("TorrentOptionsView", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.transfers", TorrentOptionsView.class, "TorrentOptionsView", true, null, null);
                return entry;
            }
        });
        mdi.registerEntry("MySharesView", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.transfers", MySharesView.class, "MySharesView", true, null, null);
                return entry;
            }
        });
        mdi.registerEntry("MyTrackerView", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.transfers", MyTrackerView.class, "MyTrackerView", true, null, null);
                return entry;
            }
        });
        mdi.registerEntry("ClientStatsView", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.plugins", ClientStatsView.class, "ClientStatsView", true, null, null);
                return entry;
            }
        });
        mdi.registerEntry("ConfigView", new MdiEntryCreationListener2(){

            @Override
            public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map<?, ?> params) {
                String section = datasource instanceof String ? (String)datasource : null;
                boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
                if (uiClassic || COConfigurationManager.getBooleanParameter("Show Options In Side Bar")) {
                    MdiEntry entry = ((MultipleDocumentInterfaceSWT)mdi).createEntryFromEventListener("header.plugins", ConfigView.class, "ConfigView", true, null, null);
                    return entry;
                }
                ConfigShell.getInstance().open(section);
                return null;
            }
        });
        try {
            final ShareManager share_manager = pi.getShareManager();
            if (share_manager.getShares().length > 0) {
                mdi.showEntryByID("MySharesView");
            } else {
                share_manager.addListener(new ShareManagerListener(){

                    public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
                    }

                    public void resourceDeleted(ShareResource resource) {
                    }

                    public void resourceAdded(ShareResource resource) {
                        share_manager.removeListener(this);
                        mdi.loadEntryByID("MySharesView", false);
                    }

                    public void reportProgress(int percent_complete) {
                    }

                    public void reportCurrentTask(String task_description) {
                    }
                });
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        TRHost trackerHost = AzureusCoreFactory.getSingleton().getTrackerHost();
        trackerHost.addListener(new TRHostListener(){
            boolean done = false;

            public void torrentRemoved(TRHostTorrent t) {
            }

            public void torrentChanged(TRHostTorrent t) {
            }

            public void torrentAdded(TRHostTorrent t) {
                if (this.done) {
                    return;
                }
                TRHost trackerHost = AzureusCoreFactory.getSingleton().getTrackerHost();
                trackerHost.removeListener(this);
                this.done = true;
                mdi.loadEntryByID("MyTrackerView", false);
            }

            public boolean handleExternalRequest(InetSocketAddress client_address, String user, String url, URL absolute_url, String header, InputStream is, OutputStream os, AsyncController async) throws IOException {
                return false;
            }
        });
        UIManager uim = pi.getUIManager();
        if (uim != null) {
            MenuItem menuItem = uim.getMenuManager().addMenuItem("mainmenu", "tags.view.heading");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("TagsOverview");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "tag.discovery.view.heading");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("TagDiscovery");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "chats.view.heading");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("ChatOverview");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "archivedlsview.view.heading");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("ArchivedDownloads");
                }
            });
        }
    }

    private static void setupSidebarClassic(final MultipleDocumentInterfaceSWT mdi) {
        mdi.registerEntry("Library", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
                String title = uiClassic ? "{MyTorrentsView.mytorrents}" : "{sidebar.Library}";
                MdiEntry entry = mdi.createEntryFromSkinRef(null, "Library", "library", title, null, null, false, "");
                entry.setImageLeftID("image.sidebar.library");
                return entry;
            }
        });
        mdi.registerEntry("Tag\\..*", new MdiEntryCreationListener2(){

            @Override
            public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map<?, ?> params) {
                if (datasource instanceof Tag) {
                    Tag tag = (Tag)datasource;
                    return SB_Transfers.setupTag(tag);
                }
                return null;
            }
        });
        mdi.showEntryByID("Library");
    }

    private static void setupSidebarVuzeUI(final MultipleDocumentInterfaceSWT mdi) {
        String[] preferredOrder = new String[]{"header.transfers", "header.vuze", "header.discovery", "header.devices", "header.dvd", "header.plugins"};
        mdi.setPreferredOrder(preferredOrder);
        for (int i = 0; i < preferredOrder.length; ++i) {
            String id = preferredOrder[i];
            mdi.registerEntry(id, new MdiEntryCreationListener(){

                public MdiEntry createMDiEntry(String id) {
                    MdiEntry entry = mdi.createHeader(id, "sidebar." + id, null);
                    if (entry == null) {
                        return null;
                    }
                    entry.setDefaultExpanded(true);
                    if (id.equals("header.plugins")) {
                        entry.addListener(new MdiChildCloseListener(){

                            public void mdiChildEntryClosed(MdiEntry parent, MdiEntry child, boolean user) {
                                if (mdi.getChildrenOf(parent.getId()).size() == 0) {
                                    parent.close(true);
                                }
                            }
                        });
                        PluginInterface pi = PluginInitializer.getDefaultInterface();
                        UIManager uim = pi.getUIManager();
                        MenuManager menuManager = uim.getMenuManager();
                        MenuItem menuItem = menuManager.addMenuItem("sidebar.header.plugins", "label.plugin.options");
                        menuItem.addListener(new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                if (uif != null) {
                                    uif.getMDI().showEntryByID("ConfigView", "plugins");
                                }
                            }
                        });
                    }
                    return entry;
                }
            });
        }
        mdi.registerEntry("About.Plugins", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.plugins", "About.Plugins", "main.generic.browse", "{mdi.entry.about.plugins}", null, null, true, "");
                String url = ConstantsVuze.getDefaultContentNetwork().getSiteRelativeURL("plugins", true);
                entry.setDatasource(url);
                entry.setImageLeftID("image.sidebar.plugin");
                return entry;
            }
        });
        final int burnInfoShown = COConfigurationManager.getIntParameter("burninfo.shown", 0);
        if (burnInfoShown == 0) {
            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                public void azureusCoreRunning(AzureusCore core) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (FeatureManagerUI.enabled) {
                                mdi.loadEntryByID("Plus", false);
                                if (!FeatureUtils.hasFullBurn()) {
                                    mdi.loadEntryByID("BurnInfo", false);
                                }
                                COConfigurationManager.setParameter("burninfo.shown", burnInfoShown + 1);
                            }
                        }
                    });
                }
            });
        }
        SB_Transfers.setup(mdi);
        new SB_Vuze(mdi);
        new SB_Discovery(mdi);
        mdi.loadEntryByID("Library", false);
        mdi.loadEntryByID("LibraryUnopened", false);
        mdi.loadEntryByID("Subscriptions", false);
        mdi.loadEntryByID("Devices", false);
        mdi.loadEntryByID("Activity", false);
    }
}

