/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiChildCloseListener;
import com.aelitis.azureus.ui.mdi.MdiCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MdiEntryLoadedListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.views.ViewTitleInfoBetaP;
import com.aelitis.azureus.ui.swt.views.skin.SBC_ActivityTableView;
import java.util.ArrayList;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;

public class SB_Vuze {
    private ArrayList<MdiEntry> children = new ArrayList();
    private ViewTitleInfo titleInfo;

    public SB_Vuze(MultipleDocumentInterface mdi) {
        this.setup(mdi);
    }

    private void setup(final MultipleDocumentInterface mdi) {
        mdi.registerEntry("BetaProgramme", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                final ViewTitleInfoBetaP viewTitleInfo = new ViewTitleInfoBetaP();
                MdiEntry entry = mdi.createEntryFromSkinRef("header.vuze", "BetaProgramme", "main.area.beta", "{Sidebar.beta.title}", viewTitleInfo, null, true, "");
                entry.setImageLeftID("image.sidebar.beta");
                entry.addListener(new MdiCloseListener(){

                    public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                        viewTitleInfo.clearIndicator();
                    }
                });
                return entry;
            }
        });
        mdi.registerEntry("Welcome", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.vuze", "Welcome", "main.area.welcome", MessageText.getString("v3.MainWindow.menu.getting_started").replaceAll("&", ""), null, null, true, "");
                entry.setImageLeftID("image.sidebar.welcome");
                SB_Vuze.this.addDropTest(entry);
                return entry;
            }
        });
        SBC_ActivityTableView.setupSidebarEntry();
        ViewTitleInfoManager.addListener(new ViewTitleInfoListener(){

            public void viewTitleInfoRefresh(ViewTitleInfo titleInfo) {
                MdiEntry[] childrenArray;
                for (MdiEntry entry : childrenArray = SB_Vuze.this.children.toArray(new MdiEntry[0])) {
                    if (entry.getViewTitleInfo() != titleInfo) continue;
                    if (SB_Vuze.this.titleInfo == null) break;
                    ViewTitleInfoManager.refreshTitleInfo(SB_Vuze.this.titleInfo);
                    break;
                }
            }
        });
        mdi.addListener(new MdiEntryLoadedListener(){

            public void mdiEntryLoaded(MdiEntry entry) {
                if ("header.vuze".equals(entry.getParentID())) {
                    SB_Vuze.this.children.add(entry);
                    entry.addListener(new MdiChildCloseListener(){

                        public void mdiChildEntryClosed(MdiEntry parent, MdiEntry child, boolean user) {
                            SB_Vuze.this.children.remove(child);
                        }
                    });
                }
                if (!entry.getId().equals("header.vuze")) {
                    return;
                }
                SB_Vuze.this.setupHeader(entry);
            }
        });
    }

    private void setupHeader(final MdiEntry entry) {
        this.titleInfo = new ViewTitleInfo(){

            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    MdiEntry[] entries;
                    if (entry.isExpanded()) {
                        return null;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (MdiEntry subEntry : entries = entry.getMDI().getEntries()) {
                        Object text;
                        ViewTitleInfo titleInfo;
                        if (!entry.getId().equals(subEntry.getParentID()) || (titleInfo = subEntry.getViewTitleInfo()) == null || !((text = titleInfo.getTitleInfoProperty(0)) instanceof String)) continue;
                        if (sb.length() > 0) {
                            sb.append(" | ");
                        }
                        sb.append(text);
                    }
                    if (sb.length() > 0) {
                        return sb.toString();
                    }
                } else if (propertyID == 1) {
                    MdiEntry[] entries;
                    if (entry.isExpanded()) {
                        return null;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (MdiEntry subEntry : entries = entry.getMDI().getEntries()) {
                        Object text;
                        ViewTitleInfo titleInfo;
                        if (!entry.getId().equals(subEntry.getParentID()) || (titleInfo = subEntry.getViewTitleInfo()) == null || !((text = titleInfo.getTitleInfoProperty(0)) instanceof String)) continue;
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(subEntry.getTitle() + ": " + text);
                    }
                    if (sb.length() > 0) {
                        return sb.toString();
                    }
                }
                return null;
            }
        };
        entry.setViewTitleInfo(this.titleInfo);
    }

    protected void addDropTest(MdiEntry entry) {
        if (!Constants.isCVSVersion()) {
            return;
        }
        entry.addListener(new MdiEntryDropListener(){

            public boolean mdiEntryDrop(MdiEntry entry, Object droppedObject) {
                String s = "You just dropped " + droppedObject.getClass() + "\n" + droppedObject + "\n\n";
                if (droppedObject.getClass().isArray()) {
                    Object[] o = (Object[])droppedObject;
                    for (int i = 0; i < o.length; ++i) {
                        s = s + "" + i + ":  ";
                        Object object = o[i];
                        s = object == null ? s + "null" : s + object.getClass() + ";" + object;
                        s = s + "\n";
                    }
                }
                UIFunctionsManager.getUIFunctions().promptUser("test", s, null, 0, null, null, false, 0, null);
                return true;
            }
        });
    }
}

