/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin.sidebar;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.BaseMDI;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectSash;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarToolTips;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarVitalityImageSWT;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.plugins.PluginUISWTSkinObject;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.IViewAlwaysInitialize;

public class SideBar
extends BaseMDI
implements ObfusticateImage,
AEDiagnosticsEvidenceGenerator {
    protected static final boolean END_INDENT = Constants.isLinux || Constants.isWindows2000 || Constants.isWindows9598ME;
    private static final boolean USE_PAINTITEM = !Utils.isCarbon;
    private static final boolean USE_PAINT = !Constants.isWindows && !Utils.isGTK;
    protected static final boolean USE_NATIVE_EXPANDER = Utils.isGTK;
    private static final int GAP_BETWEEN_LEVEL_1 = Math.min(5, Math.max(0, COConfigurationManager.getIntParameter("Side Bar Top Level Gap", 1)));
    protected static final int SIDEBAR_ATTENTION_PERIOD = 500;
    protected static final int SIDEBAR_ATTENTION_DURATION = 5000;
    private SWTSkin skin;
    private SWTSkinObjectContainer soSideBarContents;
    private SWTSkinObject soSideBarList;
    private Tree tree;
    private Font fontHeader;
    private Font font;
    private SWTSkinObject soSideBarPopout;
    private SelectionListener dropDownSelectionListener;
    private DropTarget dropTarget;
    protected SideBarEntrySWT draggingOver;
    private Color fg;
    private Color bg;
    private List<SideBarEntrySWT> attention_seekers = new ArrayList<SideBarEntrySWT>();
    private TimerEventPeriodic attention_event;
    private Composite cPluginsArea;
    public static SideBar instance = null;
    private List<UISWTViewCore> pluginViews = new ArrayList<UISWTViewCore>();

    public SideBar() {
        if (instance == null) {
            instance = this;
        }
        AEDiagnostics.addEvidenceGenerator(this);
    }

    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        super.skinObjectCreated(skinObject, params);
        this.skin = skinObject.getSkin();
        this.soSideBarContents = (SWTSkinObjectContainer)this.skin.getSkinObject("sidebar-contents");
        this.soSideBarList = this.skin.getSkinObject("sidebar-list");
        this.soSideBarPopout = this.skin.getSkinObject("sidebar-pop");
        SWTSkinObjectContainer soSideBarPluginsArea = (SWTSkinObjectContainer)this.skin.getSkinObject("sidebar-plugins");
        if (soSideBarPluginsArea != null) {
            Composite composite = soSideBarPluginsArea.getComposite();
            this.cPluginsArea = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            this.cPluginsArea.setLayout((Layout)layout);
            this.cPluginsArea.setLayoutData((Object)Utils.getFilledFormData());
        }
        this.addGeneralMenus();
        this.createSideBar();
        try {
            UIUpdater updater = UIFunctionsManager.getUIFunctions().getUIUpdater();
            if (!updater.isAdded(this)) {
                updater.addUpdater(this);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        Display.getDefault().addFilter(1, new Listener(){

            public void handleEvent(Event event2) {
                if (event2.keyCode == 0x1000012 || event2.keyCode == 0x1000010 || event2.keyCode == 116 && event2.stateMask == 0x410000) {
                    event2.doit = false;
                    event2.keyCode = 0;
                    event2.character = '\u0000';
                    SideBar.this.flipSideBarVisibility();
                }
            }
        });
        return null;
    }

    private void addGeneralMenus() {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getDefaultPluginInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        org.gudy.azureus2.plugins.ui.menus.MenuItem menuItem = menuManager.addMenuItem("sidebar._end_", "menu.pop.out");
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object data) {
                SideBarEntrySWT sbe = (SideBarEntrySWT)SideBar.this.currentEntry;
                menu.setVisible(sbe != null && sbe.canBuildStandAlone());
            }
        });
        menuItem.addListener(new MenuItemListener(){

            public void selected(org.gudy.azureus2.plugins.ui.menus.MenuItem menu, Object target) {
                SideBarEntrySWT sbe = (SideBarEntrySWT)SideBar.this.currentEntry;
                if (sbe != null) {
                    SkinnedDialog skinnedDialog = new SkinnedDialog("skin3_dlg_sidebar_popout", "shell", null, 3184);
                    SWTSkin skin = skinnedDialog.getSkin();
                    SWTSkinObjectContainer cont = sbe.buildStandAlone((SWTSkinObjectContainer)skin.getSkinObject("content-area"));
                    if (cont != null) {
                        skinnedDialog.setTitle(sbe.getTitle());
                        skinnedDialog.open();
                    } else {
                        skinnedDialog.close();
                    }
                }
            }
        });
    }

    public void flipSideBarVisibility() {
        final SWTSkinObjectSash soSash = (SWTSkinObjectSash)this.skin.getSkinObject("sidebar-sash");
        if (soSash == null) {
            return;
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                boolean visible = !soSash.isAboveVisible();
                soSash.setAboveVisible(visible);
                SideBar.this.updateSidebarVisibility();
                COConfigurationManager.setParameter("Show Side Bar", visible);
            }
        });
    }

    private void updateSidebarVisibility() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinObjectSash soSash = (SWTSkinObjectSash)SideBar.this.skin.getSkinObject("sidebar-sash");
                if (soSash == null) {
                    return;
                }
                if (soSash.isAboveVisible()) {
                    if (SideBar.this.soSideBarPopout != null) {
                        Object ld = SideBar.this.soSideBarPopout.getControl().getLayoutData();
                        if (ld instanceof FormData) {
                            FormData fd = (FormData)ld;
                            fd.width = 0;
                        }
                        SideBar.this.soSideBarPopout.setVisible(false);
                        Utils.relayout(SideBar.this.soSideBarPopout.getControl());
                    }
                } else if (SideBar.this.soSideBarPopout != null) {
                    Object ld = SideBar.this.soSideBarPopout.getControl().getLayoutData();
                    if (ld instanceof FormData) {
                        FormData fd = (FormData)ld;
                        fd.width = 24;
                    }
                    SideBar.this.soSideBarPopout.setVisible(true);
                    SideBar.this.soSideBarPopout.getControl().moveAbove(null);
                    Utils.relayout(SideBar.this.soSideBarPopout.getControl());
                }
            }
        });
    }

    public boolean isVisible() {
        SWTSkinObjectSash soSash = (SWTSkinObjectSash)this.skin.getSkinObject("sidebar-sash");
        if (soSash == null) {
            return false;
        }
        return soSash.isAboveVisible();
    }

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        super.skinObjectInitialShow(skinObject, params);
        COConfigurationManager.addParameterListener("Show Side Bar", new ParameterListener(){

            public void parameterChanged(String name) {
                boolean visible = COConfigurationManager.getBooleanParameter(name);
                if (visible != SideBar.this.isVisible()) {
                    SideBar.this.flipSideBarVisibility();
                }
            }
        });
        this.updateSidebarVisibility();
        return null;
    }

    protected void setupPluginViews() {
        super.setupPluginViews();
        this.createSideBarPluginViews();
    }

    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        try {
            UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void createSideBar() {
        if (this.soSideBarList == null) {
            return;
        }
        Composite parent = (Composite)this.soSideBarList.getControl();
        this.tree = new Tree(parent, 0x20010210);
        this.tree.setHeaderVisible(false);
        new SideBarToolTips(this, this.tree);
        this.tree.setLayoutData((Object)Utils.getFilledFormData());
        SWTSkinProperties skinProperties = this.skin.getSkinProperties();
        this.bg = skinProperties.getColor("color.sidebar.bg");
        this.fg = skinProperties.getColor("color.sidebar.fg");
        this.tree.setBackground(this.bg);
        this.tree.setForeground(this.fg);
        FontData[] fontData = this.tree.getFont().getFontData();
        int fontHeight = (Constants.isOSX ? 11 : 12) + (this.tree.getItemHeight() > 18 ? this.tree.getItemHeight() - 18 : 0);
        if (Constants.isLinux && this.tree.getItemHeight() >= 38) {
            fontHeight = 13;
        }
        fontData[0].setStyle(1);
        FontUtils.getFontHeightFromPX((Device)this.tree.getDisplay(), fontData, null, fontHeight);
        this.fontHeader = new Font((Device)this.tree.getDisplay(), fontData);
        this.font = FontUtils.getFontWithHeight(this.tree.getFont(), null, fontHeight);
        this.tree.setFont(this.font);
        this.tree.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 0) {
                    SideBarEntrySWT[] sideBarEntries = SideBar.this.mapIdToEntry.values().toArray(new SideBarEntrySWT[0]);
                    SideBar.this.swt_updateSideBarHitAreasY(sideBarEntries);
                }
            }
        });
        Listener treeListener = new Listener(){
            TreeItem lastTopItem = null;
            boolean mouseDowned = false;
            private boolean wasExpanded;

            public void handleEvent(final Event event2) {
                TreeItem treeItem = (TreeItem)event2.item;
                Tree tree = SideBar.this.getTree();
                try {
                    switch (event2.type) {
                        case 41: {
                            int clientWidth = tree.getClientArea().width;
                            String text = treeItem.getText(event2.index);
                            Point size = event2.gc.textExtent(text);
                            if (event2.x + event2.width < clientWidth) {
                                event2.width = size.x + event2.x;
                                event2.x = 0;
                            }
                            if (Constants.isWindows) {
                                event2.width = clientWidth - event2.x;
                            }
                            event2.height = 20;
                            break;
                        }
                        case 42: {
                            if (!USE_PAINTITEM) break;
                            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                            if (entry != null) {
                                boolean selected;
                                boolean bl = selected = SideBar.this.currentEntry == entry && entry.isSelectable();
                                event2.detail = !selected ? (event2.detail &= 0xFFFFFFFD) : (event2.detail |= 2);
                                entry.swt_paintSideBar(event2);
                            }
                            break;
                        }
                        case 9: {
                            if (!USE_PAINT) {
                                return;
                            }
                            Rectangle bounds = event2.getBounds();
                            int indent = END_INDENT ? tree.getClientArea().width - 1 : 0;
                            int y = event2.y + 1;
                            treeItem = tree.getItem(new Point(indent, y));
                            while (treeItem != null) {
                                TreeItem oldTreeItem;
                                Rectangle itemBounds;
                                SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                                Rectangle rectangle = itemBounds = entry == null ? null : entry.swt_getBounds();
                                if (itemBounds != null && entry != null) {
                                    event2.item = treeItem;
                                    boolean selected = SideBar.this.currentEntry == entry && entry.isSelectable();
                                    event2.detail = selected ? 2 : 0;
                                    Rectangle newClip = bounds.intersection(itemBounds);
                                    event2.setBounds(newClip);
                                    event2.gc.setClipping(newClip);
                                    entry.swt_paintSideBar(event2);
                                    y = itemBounds.y + itemBounds.height + 1;
                                } else {
                                    y += tree.getItemHeight();
                                }
                                if (y <= bounds.y + bounds.height && (oldTreeItem = treeItem) != (treeItem = tree.getItem(new Point(indent, y)))) continue;
                                break;
                            }
                            if (tree.getTopItem() == this.lastTopItem) break;
                            this.lastTopItem = tree.getTopItem();
                            SideBarEntrySWT[] sideBarEntries = SideBar.this.mapIdToEntry.values().toArray(new SideBarEntrySWT[0]);
                            SideBar.this.swt_updateSideBarHitAreasY(sideBarEntries);
                            break;
                        }
                        case 40: {
                            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                            if (entry == null) {
                                event2.detail = 0;
                            }
                            event2.doit = true;
                            break;
                        }
                        case 11: {
                            tree.redraw();
                            break;
                        }
                        case 13: {
                            if (treeItem == null) {
                                return;
                            }
                            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                            if (entry != null && entry.isSelectable()) {
                                SideBar.this.showEntry(entry);
                                break;
                            }
                            if (SideBar.this.currentEntry == null) break;
                            TreeItem topItem = tree.getTopItem();
                            tree.setRedraw(false);
                            TreeItem ti = ((SideBarEntrySWT)SideBar.this.currentEntry).getTreeItem();
                            if (ti != null) {
                                tree.setSelection(ti);
                            }
                            tree.setTopItem(topItem);
                            tree.setRedraw(true);
                            event2.doit = false;
                            break;
                        }
                        case 5: {
                            int indent = END_INDENT ? tree.getClientArea().width - 1 : 0;
                            treeItem = tree.getItem(new Point(indent, event2.y));
                            SideBarEntrySWT entry = (SideBarEntrySWT)(treeItem == null || treeItem.isDisposed() ? null : treeItem.getData("MdiEntry"));
                            int cursorNo = 0;
                            if (treeItem != null) {
                                Rectangle closeArea = (Rectangle)treeItem.getData("closeArea");
                                if (closeArea != null && closeArea.contains(event2.x, event2.y)) {
                                    cursorNo = 21;
                                } else if (entry != null && !entry.isCollapseDisabled() && treeItem.getItemCount() > 0) {
                                    cursorNo = 21;
                                }
                            }
                            Cursor cursor = event2.display.getSystemCursor(cursorNo);
                            if (tree.getCursor() != cursor) {
                                tree.setCursor(cursor);
                            }
                            if (treeItem != null) {
                                this.wasExpanded = entry != null && entry.isExpanded();
                                break;
                            }
                            this.wasExpanded = false;
                            break;
                        }
                        case 3: {
                            this.mouseDowned = true;
                            break;
                        }
                        case 4: {
                            if (!this.mouseDowned) {
                                return;
                            }
                            this.mouseDowned = false;
                            if (tree.getItemCount() == 0 || event2.button != 1) {
                                return;
                            }
                            int indent = END_INDENT ? tree.getClientArea().width - 1 : 0;
                            treeItem = tree.getItem(new Point(indent, event2.y));
                            if (treeItem == null) {
                                return;
                            }
                            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                            Rectangle closeArea = (Rectangle)treeItem.getData("closeArea");
                            if (closeArea != null && closeArea.contains(event2.x, event2.y)) {
                                treeItem.dispose();
                                return;
                            }
                            if (SideBar.this.currentEntry != entry && Constants.isOSX) {
                                SideBar.this.showEntry(entry);
                            }
                            if (entry == null) break;
                            MdiEntryVitalityImage[] vitalityImages = entry.getVitalityImages();
                            for (int i = 0; i < vitalityImages.length; ++i) {
                                Rectangle hitArea;
                                SideBarVitalityImageSWT vitalityImage = (SideBarVitalityImageSWT)vitalityImages[i];
                                if (vitalityImage == null || !vitalityImage.isVisible() || (hitArea = vitalityImage.getHitArea()) == null) continue;
                                Rectangle itemBounds = entry.swt_getBounds();
                                int relY = event2.y - (itemBounds == null ? 0 : itemBounds.y);
                                if (!hitArea.contains(event2.x, relY)) continue;
                                vitalityImage.triggerClickedListeners(event2.x, relY);
                                return;
                            }
                            if (!(entry.isCollapseDisabled() || treeItem.getItemCount() <= 0 || entry.isSelectable() && event2.x >= 20)) {
                                MdiEntry currentEntry = SideBar.this.getCurrentEntry();
                                if (currentEntry != null && entry.getId().equals(currentEntry.getParentID())) {
                                    SideBar.this.showEntryByID("Library");
                                }
                                entry.setExpanded(!this.wasExpanded);
                                this.wasExpanded = !this.wasExpanded;
                            }
                            break;
                        }
                        case 12: {
                            SideBar.this.fontHeader.dispose();
                            SideBar.this.font.dispose();
                            if (SideBar.this.dropTarget != null && !SideBar.this.dropTarget.isDisposed()) {
                                SideBar.this.dropTarget.dispose();
                            }
                            SideBar.this.saveCloseables();
                            break;
                        }
                        case 18: {
                            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                            if (entry.isCollapseDisabled()) {
                                tree.setRedraw(false);
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        ((TreeItem)event2.item).setExpanded(true);
                                        SideBar.this.getTree().setRedraw(true);
                                    }
                                });
                                break;
                            }
                            MdiEntry currentEntry = SideBar.this.getCurrentEntry();
                            if (currentEntry != null && entry.getId().equals(currentEntry.getParentID())) {
                                SideBar.this.showEntryByID("Library");
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        };
        this.tree.addListener(41, treeListener);
        this.tree.addListener(11, treeListener);
        this.tree.addListener(9, treeListener);
        if (USE_PAINTITEM) {
            this.tree.addListener(42, treeListener);
            this.tree.addListener(40, treeListener);
        }
        this.tree.addListener(13, treeListener);
        this.tree.addListener(12, treeListener);
        this.tree.addListener(4, treeListener);
        this.tree.addListener(3, treeListener);
        this.tree.addListener(5, treeListener);
        this.tree.addListener(18, treeListener);
        this.dropTarget = new DropTarget((Control)this.tree, 1);
        this.dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
        this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dropAccept(DropTargetEvent event2) {
                event2.currentDataType = URLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
            }

            public void dragEnter(DropTargetEvent event2) {
            }

            public void dragOperationChanged(DropTargetEvent event2) {
            }

            public void dragOver(DropTargetEvent event2) {
                SideBarEntrySWT entry;
                TreeItem treeItem = event2.item instanceof TreeItem ? (TreeItem)event2.item : null;
                SideBar.this.draggingOver = treeItem != null ? (entry = (SideBarEntrySWT)treeItem.getData("MdiEntry")) : null;
                if (SideBar.this.draggingOver == null || !SideBar.this.draggingOver.hasDropListeners()) {
                    boolean isTorrent = TorrentOpener.doesDropHaveTorrents(event2);
                    event2.detail = isTorrent ? 1 : 0;
                    SideBar.this.draggingOver = null;
                } else if ((event2.operations & 4) > 0) {
                    event2.detail = 4;
                } else if ((event2.operations & 1) > 0) {
                    event2.detail = 1;
                } else if ((event2.operations & 0x10) > 0) {
                    event2.detail = 1;
                }
                if (Constants.isOSX) {
                    SideBar.this.tree.redraw();
                }
                event2.feedback = 25;
            }

            public void dragLeave(DropTargetEvent event2) {
                SideBar.this.draggingOver = null;
                SideBar.this.tree.redraw();
            }

            public void drop(DropTargetEvent event2) {
                SideBar.this.draggingOver = null;
                SideBar.this.tree.redraw();
                if (!(event2.item instanceof TreeItem)) {
                    SideBar.this.defaultDrop(event2);
                    return;
                }
                TreeItem treeItem = (TreeItem)event2.item;
                SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                boolean handled = entry.triggerDropListeners(event2.data);
                if (!handled) {
                    SideBar.this.defaultDrop(event2);
                }
            }
        });
        final Menu menuTree = new Menu((Control)this.tree);
        this.tree.setMenu(menuTree);
        menuTree.addMenuListener(new MenuListener(){
            boolean bShown = false;

            public void menuHidden(MenuEvent e) {
                this.bShown = false;
                if (Constants.isOSX) {
                    return;
                }
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        if (bShown || menuTree.isDisposed()) {
                            return;
                        }
                        Utils.disposeSWTObjects(menuTree.getItems());
                    }
                });
            }

            public void menuShown(MenuEvent e) {
                Utils.disposeSWTObjects(menuTree.getItems());
                this.bShown = true;
                Point ptMouse = SideBar.this.tree.toControl(e.display.getCursorLocation());
                int indent = END_INDENT ? ((SideBar)SideBar.this).tree.getClientArea().width - 1 : 0;
                TreeItem treeItem = SideBar.this.tree.getItem(new Point(indent, ptMouse.y));
                if (treeItem == null) {
                    return;
                }
                SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
                SideBar.this.fillMenu(menuTree, entry, "sidebar");
                if (menuTree.getItemCount() == 0) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            menuTree.setVisible(false);
                        }
                    });
                }
            }
        });
        if (this.soSideBarPopout != null) {
            SWTSkinObject soExpand;
            SWTSkinObject soDropDown = this.skin.getSkinObject("sidebar-dropdown");
            if (soDropDown != null) {
                final Menu menuDropDown = new Menu(soDropDown.getControl());
                menuDropDown.addMenuListener(new MenuListener(){
                    boolean bShown = false;

                    public void menuHidden(MenuEvent e) {
                        this.bShown = false;
                        if (Constants.isOSX) {
                            return;
                        }
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            public void runSupport() {
                                if (bShown || menuDropDown.isDisposed()) {
                                    return;
                                }
                                Utils.disposeSWTObjects(menuDropDown.getItems());
                            }
                        });
                    }

                    public void menuShown(MenuEvent e) {
                        Utils.disposeSWTObjects(menuDropDown.getItems());
                        this.bShown = true;
                        SideBar.this.fillDropDownMenu(menuDropDown, SideBar.this.tree.getItems(), 0);
                    }
                });
                this.dropDownSelectionListener = new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String id = (String)e.widget.getData("Plugin.viewID");
                        SideBar.this.showEntryByID(id);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                };
                SWTSkinButtonUtility btnDropDown = new SWTSkinButtonUtility(soDropDown);
                btnDropDown.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        Control c = buttonUtility.getSkinObject().getControl();
                        menuDropDown.setLocation(c.getDisplay().getCursorLocation());
                        menuDropDown.setVisible(!menuDropDown.getVisible());
                    }
                });
            }
            if ((soExpand = this.skin.getSkinObject("sidebar-expand")) != null) {
                SWTSkinButtonUtility btnExpand = new SWTSkinButtonUtility(soExpand);
                btnExpand.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                    public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                        SideBar.this.flipSideBarVisibility();
                    }
                });
            }
        }
    }

    private void createSideBarPluginViews() {
        UISWTViewEventListenerHolder[] pluginViews;
        if (this.cPluginsArea == null) {
            return;
        }
        UISWTInstanceImpl uiSWTinstance = (UISWTInstanceImpl)UIFunctionsManagerSWT.getUIFunctionsSWT().getUISWTInstance();
        if (uiSWTinstance == null) {
            return;
        }
        for (UISWTViewEventListenerHolder l : pluginViews = uiSWTinstance.getViewListeners("SideBarArea")) {
            if (l == null) continue;
            try {
                UISWTViewImpl view = new UISWTViewImpl(l.getViewID(), "SideBarArea", false);
                view.setEventListener(l, true);
                this.addSideBarView(view, this.cPluginsArea);
                this.cPluginsArea.getParent().getParent().layout(true, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        uiSWTinstance.addSWTViewListener(new UISWTInstanceImpl.SWTViewListener(){

            public void setViewAdded(final String parent, final String id, final UISWTViewEventListener l) {
                if (!parent.equals("SideBarArea")) {
                    return;
                }
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        try {
                            UISWTViewImpl view = new UISWTViewImpl(id, parent, false);
                            view.setEventListener(l, true);
                            SideBar.this.addSideBarView(view, SideBar.this.cPluginsArea);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }

            public void setViewRemoved(String parent, String id, final UISWTViewEventListener l) {
                if (!parent.equals("SideBarArea")) {
                    return;
                }
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        try {
                            for (UISWTViewCore view : SideBar.this.pluginViews) {
                                if (!l.equals(view.getEventListener())) continue;
                                view.closeView();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.cPluginsArea.getParent().getParent().layout(true, true);
    }

    private void addSideBarView(UISWTViewImpl view, Composite cPluginsArea) {
        Composite parent = new Composite(cPluginsArea, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        parent.setLayoutData((Object)gridData);
        parent.setLayout((Layout)new FormLayout());
        view.initialize(parent);
        parent.setVisible(true);
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            boolean useGridLayout;
            Control control = children[i];
            Object ld = control.getLayoutData();
            boolean bl = useGridLayout = ld != null && ld instanceof GridData;
            if (useGridLayout) {
                GridLayout gridLayout = new GridLayout();
                gridLayout.horizontalSpacing = 0;
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                gridLayout.verticalSpacing = 0;
                parent.setLayout((Layout)gridLayout);
                break;
            }
            if (ld != null) continue;
            control.setLayoutData((Object)Utils.getFilledFormData());
        }
        this.pluginViews.add(view);
    }

    protected void defaultDrop(DropTargetEvent event2) {
        TorrentOpener.openDroppedTorrents(event2, false);
    }

    protected void fillDropDownMenu(Menu menuDropDown, TreeItem[] items, int indent) {
        int i;
        String s = "";
        for (i = 0; i < indent; ++i) {
            s = s + "   ";
        }
        for (i = 0; i < items.length; ++i) {
            TreeItem[] subItems;
            String o;
            TreeItem treeItem = items[i];
            SideBarEntrySWT entry = (SideBarEntrySWT)treeItem.getData("MdiEntry");
            if (entry == null) continue;
            MenuItem menuItem = new MenuItem(menuDropDown, entry.isSelectable() ? 16 : 64);
            String id = entry.getId();
            menuItem.setData("Plugin.viewID", (Object)id);
            ViewTitleInfo titleInfo = entry.getViewTitleInfo();
            String ind = "";
            if (titleInfo != null && (o = (String)titleInfo.getTitleInfoProperty(0)) != null) {
                ind = "  (" + o + ")";
            }
            menuItem.setText(s + entry.getTitle() + ind);
            menuItem.addSelectionListener(this.dropDownSelectionListener);
            if (this.currentEntry != null && this.currentEntry.getId().equals(id)) {
                menuItem.setSelection(true);
            }
            if ((subItems = treeItem.getItems()).length <= 0) continue;
            Menu parent = menuDropDown;
            if (!entry.isSelectable()) {
                parent = new Menu((Decorations)menuDropDown.getParent().getShell(), 4);
                menuItem.setMenu(parent);
            }
            this.fillDropDownMenu(parent, subItems, indent + 1);
        }
    }

    private void swt_updateSideBarHitAreasY(SideBarEntrySWT[] entries) {
        for (int x = 0; x < entries.length; ++x) {
            Rectangle closeArea;
            Rectangle itemBounds;
            SideBarEntrySWT entry = entries[x];
            TreeItem treeItem = entry.getTreeItem();
            if (treeItem == null || treeItem.isDisposed() || (itemBounds = entry.swt_getBounds()) == null) continue;
            if (entry.isCloseable() && (closeArea = (Rectangle)treeItem.getData("closeArea")) != null) {
                closeArea.y = itemBounds.y + (itemBounds.height - closeArea.height) / 2;
            }
            MdiEntryVitalityImage[] vitalityImages = entry.getVitalityImages();
            for (int i = 0; i < vitalityImages.length; ++i) {
                Rectangle bounds;
                Image image;
                SideBarVitalityImageSWT vitalityImage = (SideBarVitalityImageSWT)vitalityImages[i];
                if (!vitalityImage.isVisible() || (image = vitalityImage.getImage()) == null || (bounds = vitalityImage.getHitArea()) == null) continue;
                bounds.y = (itemBounds.height - bounds.height) / 2;
            }
        }
    }

    protected int indexOf(final MdiEntry entry) {
        Object o = Utils.execSWTThreadWithObject("indexOf", new AERunnableObject(){

            public Object runSupport() {
                TreeItem treeItem = ((SideBarEntrySWT)entry).getTreeItem();
                if (treeItem == null) {
                    return -1;
                }
                TreeItem parentItem = treeItem.getParentItem();
                if (parentItem != null) {
                    return parentItem.indexOf(treeItem);
                }
                return SideBar.this.tree.indexOf(treeItem);
            }
        }, 500L);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return -1;
    }

    public MdiEntry createHeader(String id, String titleID, String preferredAfterID) {
        MdiEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        SideBarEntrySWT entry = new SideBarEntrySWT(this, this.skin, id, null);
        entry.setSelectable(false);
        entry.setPreferredAfterID(preferredAfterID);
        entry.setTitleID(titleID);
        this.setupNewEntry(entry, id, true, false);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupNewEntry(final SideBarEntrySWT entry, final String id, final boolean expandParent, final boolean closeable) {
        Map map = this.mapIdToEntry;
        synchronized (map) {
            this.mapIdToEntry.put(id, entry);
        }
        entry.setCloseable(closeable);
        entry.setParentSkinObject(this.soSideBarContents);
        entry.setDestroyOnDeactivate(false);
        if ("header.plugins".equals(entry.getParentID()) && entry.getImageLeftID() == null) {
            entry.setImageLeftID("image.sidebar.plugin");
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SideBar.this._setupNewEntry(entry, id, expandParent, closeable);
            }
        });
    }

    protected void _setupNewEntry(SideBarEntrySWT entry, String id, boolean expandParent, boolean closeable) {
        TreeItem treeItem;
        String parentID = entry.getParentID();
        MdiEntry parent = this.getEntry(parentID);
        TreeItem parentTreeItem = null;
        if (parent instanceof SideBarEntrySWT) {
            SideBarEntrySWT parentSWT = (SideBarEntrySWT)parent;
            parentTreeItem = parentSWT.getTreeItem();
            if (expandParent) {
                parentTreeItem.setExpanded(true);
            }
        }
        int index = -1;
        String preferredAfterID = entry.getPreferredAfterID();
        if (preferredAfterID != null) {
            if (preferredAfterID.length() == 0) {
                index = 0;
            } else {
                MdiEntry entryAbove;
                boolean hack_it = preferredAfterID.startsWith("~");
                if (hack_it) {
                    preferredAfterID = preferredAfterID.substring(1);
                }
                if ((entryAbove = this.getEntry(preferredAfterID)) != null) {
                    index = this.indexOf(entryAbove);
                    if (!hack_it && index >= 0) {
                        ++index;
                    }
                }
            }
        }
        if (index == -1 && parent == null) {
            String orderID;
            index = 0;
            String[] order = this.getPreferredOrder();
            for (int i = 0; i < order.length && !(orderID = order[i]).equals(id); ++i) {
                int i2;
                MdiEntry entry2 = this.getEntry(orderID);
                if (entry2 == null || (i2 = this.indexOf(entry2)) < 0) continue;
                index = i2 + 1;
            }
        }
        if (GAP_BETWEEN_LEVEL_1 > 0 && parentTreeItem == null && this.tree.getItemCount() > 0 && index != 0) {
            for (int i = 0; i < GAP_BETWEEN_LEVEL_1; ++i) {
                this.createTreeItem(null, index);
                if (index < 0) continue;
                ++index;
            }
        }
        if ((treeItem = this.createTreeItem(parentTreeItem, index)) != null) {
            treeItem.setData("MdiEntry", (Object)entry);
            entry.setTreeItem(treeItem);
            this.triggerEntryLoadedListeners(entry);
        }
        if (GAP_BETWEEN_LEVEL_1 > 0 && parentTreeItem == null && this.tree.getItemCount() > 1 && index == 0) {
            for (int i = 0; i < GAP_BETWEEN_LEVEL_1; ++i) {
                this.createTreeItem(null, ++index);
            }
        }
    }

    private TreeItem createTreeItem(Object parentSwtItem, int index) {
        TreeItem treeItem;
        if (parentSwtItem == null) {
            parentSwtItem = this.tree;
        }
        if (parentSwtItem instanceof Tree) {
            Tree tree = (Tree)parentSwtItem;
            if (tree.isDisposed()) {
                return null;
            }
            treeItem = index >= 0 && index < tree.getItemCount() ? new TreeItem(tree, 0, index) : new TreeItem(tree, 0);
        } else {
            if (((TreeItem)parentSwtItem).isDisposed()) {
                return null;
            }
            treeItem = index >= 0 && index < ((TreeItem)parentSwtItem).getItemCount() ? new TreeItem((TreeItem)parentSwtItem, 0, index) : new TreeItem((TreeItem)parentSwtItem, 0);
        }
        return treeItem;
    }

    public void showEntry(MdiEntry newEntry) {
        if (this.tree.isDisposed()) {
            return;
        }
        if (newEntry == null || !newEntry.isSelectable()) {
            return;
        }
        SideBarEntrySWT oldEntry = (SideBarEntrySWT)this.currentEntry;
        if (this.currentEntry == newEntry) {
            this.triggerSelectionListener(newEntry, newEntry);
            return;
        }
        this.currentEntry = (MdiEntrySWT)newEntry;
        if (oldEntry != null && oldEntry != newEntry) {
            oldEntry.redraw();
        }
        if (this.currentEntry != null) {
            ((BaseMdiEntry)this.currentEntry).show();
        }
        if (oldEntry != null && oldEntry != newEntry) {
            oldEntry.hide();
            oldEntry.redraw();
        }
        newEntry.redraw();
        this.triggerSelectionListener(newEntry, oldEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdiEntry createEntryFromEventListener(String parentEntryID, String parentViewID, UISWTViewEventListener l, String id, boolean closeable, Object datasource, String preferredAfterID) {
        MdiEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        SideBarEntrySWT entry = new SideBarEntrySWT(this, this.skin, id, parentViewID);
        try {
            Map map = this.mapIdToEntry;
            synchronized (map) {
                this.mapIdToEntry.put(id, entry);
            }
            entry.setEventListener(l, true);
            entry.setParentID(parentEntryID);
            entry.setDatasource(datasource);
            entry.setPreferredAfterID(preferredAfterID);
            this.setupNewEntry(entry, id, false, closeable);
            if (l instanceof IViewAlwaysInitialize) {
                entry.build();
            }
        }
        catch (Exception e) {
            Debug.out(e);
            entry.close(true);
            entry = null;
        }
        return entry;
    }

    public MdiEntry createEntryFromSkinRef(String parentID, String id, String configID, String title, ViewTitleInfo titleInfo, Object params, boolean closeable, String preferredAfterID) {
        MdiEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        SideBarEntrySWT entry = new SideBarEntrySWT(this, this.skin, id, null);
        entry.setTitle(title);
        entry.setSkinRef(configID, params);
        entry.setParentID(parentID);
        entry.setViewTitleInfo(titleInfo);
        entry.setPreferredAfterID(preferredAfterID);
        this.setupNewEntry(entry, id, false, closeable);
        return entry;
    }

    public void updateUI() {
        Object[] views = this.pluginViews.toArray();
        for (int i = 0; i < views.length; ++i) {
            try {
                UISWTViewCore view = (UISWTViewCore)views[i];
                Composite composite = view.getComposite();
                if (composite == null) continue;
                if (composite.isDisposed()) {
                    this.pluginViews.remove(view);
                    continue;
                }
                if (!composite.isVisible()) continue;
                view.triggerEvent(5, null);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        if (this.tree.getSelectionCount() == 0) {
            return;
        }
        super.updateUI();
    }

    protected boolean wasEntryLoadedOnce(String id) {
        boolean loadedOnce = COConfigurationManager.getBooleanParameter("sb.once." + id, false);
        return loadedOnce;
    }

    protected void setEntryLoadedOnce(String id) {
        COConfigurationManager.setParameter("sb.once." + id, true);
    }

    public Font getHeaderFont() {
        return this.fontHeader;
    }

    protected Tree getTree() {
        return this.tree;
    }

    public MdiEntrySWT getEntryFromSkinObject(PluginUISWTSkinObject pluginSkinObject) {
        if (pluginSkinObject instanceof SWTSkinObject) {
            for (Control control = ((SWTSkinObject)pluginSkinObject).getControl(); control != null && !control.isDisposed(); control = control.getParent()) {
                Object entry = control.getData("BaseMDIEntry");
                if (!(entry instanceof BaseMdiEntry)) continue;
                BaseMdiEntry mdiEntry = (BaseMdiEntry)entry;
                return mdiEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestAttention(SideBarEntrySWT entry) {
        List<SideBarEntrySWT> list = this.attention_seekers;
        synchronized (list) {
            if (!this.attention_seekers.contains(entry)) {
                this.attention_seekers.add(entry);
            }
            if (this.attention_event == null) {
                this.attention_event = SimpleTimer.addPeriodicEvent("SideBar:attention", 500L, new TimerEventPerformer(){
                    int tick_count = 0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        ++this.tick_count;
                        final ArrayList<SideBarEntrySWT> repaints = new ArrayList<SideBarEntrySWT>();
                        List list = SideBar.this.attention_seekers;
                        synchronized (list) {
                            TimerEventPeriodic ev;
                            Iterator it = SideBar.this.attention_seekers.iterator();
                            while (it.hasNext()) {
                                SideBarEntrySWT entry = (SideBarEntrySWT)it.next();
                                if (entry.isDisposed()) {
                                    it.remove();
                                    continue;
                                }
                                if (!entry.attentionUpdate(this.tick_count)) {
                                    it.remove();
                                }
                                repaints.add(entry);
                            }
                            if (SideBar.this.attention_seekers.size() == 0 && (ev = SideBar.this.attention_event) != null) {
                                ev.cancel();
                                SideBar.this.attention_event = null;
                            }
                        }
                        if (repaints.size() > 0) {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    for (SideBarEntrySWT entry : repaints) {
                                        entry.redraw();
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        MdiEntrySWT[] entries;
        for (MdiEntrySWT entry : entries = this.getEntriesSWT()) {
            Object var9_8;
            if (entry == null || entry instanceof AEDiagnosticsEvidenceGenerator) continue;
            writer.println("Sidebar View (No Generator): " + entry.getId());
            try {
                try {
                    writer.indent();
                    writer.println("Parent: " + entry.getParentID());
                    writer.println("Title: " + entry.getTitle());
                }
                catch (Exception e) {
                    var9_8 = null;
                    writer.exdent();
                    continue;
                }
                var9_8 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                writer.exdent();
                throw throwable;
            }
        }
    }

    public Image obfusticatedImage(Image image) {
        SideBarEntrySWT[] sideBarEntries;
        Rectangle treeBounds = this.tree.getBounds();
        for (SideBarEntrySWT entry : sideBarEntries = this.mapIdToEntry.values().toArray(new SideBarEntrySWT[0])) {
            Rectangle entryBounds = entry.swt_getBounds();
            if (entryBounds == null || !treeBounds.intersects(entryBounds)) continue;
            entry.obfusticatedImage(image);
        }
        return image;
    }
}

