/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TrackerStatus;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TrackerChecker
implements AEDiagnosticsEvidenceGenerator,
SystemTime.ChangeListener,
TimerEventPerformer {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private HashMap trackers;
    private AEMonitor trackers_mon = new AEMonitor("TrackerChecker:trackers");
    private TRTrackerBTScraperImpl scraper;
    private long nextScrapeCheckOn;
    TRTrackerBTScraperResponseImpl oldResponse;

    protected TrackerChecker(TRTrackerBTScraperImpl _scraper) {
        this.scraper = _scraper;
        this.trackers = new HashMap();
        if (!COConfigurationManager.getBooleanParameter("Tracker Client Scrape Total Disable")) {
            this.runScrapes();
        }
        AEDiagnostics.addEvidenceGenerator(this);
        SystemTime.registerClockChangeListener(this);
    }

    protected TRTrackerScraperResponseImpl getHashData(TRTrackerAnnouncer tracker_client) {
        try {
            return this.getHashData(tracker_client.getTrackerURL(), tracker_client.getTorrent().getHashWrapper());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected TRTrackerScraperResponseImpl getHashData(TOTorrent torrent, URL target_url) {
        try {
            return this.getHashData(target_url == null ? torrent.getAnnounceURL() : target_url, torrent.getHashWrapper());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerScraperResponseImpl getHashData(URL trackerUrl, HashWrapper hash) {
        if (trackerUrl == null) {
            return null;
        }
        TRTrackerScraperResponseImpl data = null;
        String url_str = trackerUrl.toString();
        TrackerStatus ts = null;
        try {
            this.trackers_mon.enter();
            ts = (TrackerStatus)this.trackers.get(url_str);
            if (ts != null) {
                data = ts.getHashData(hash);
            } else {
                ts = new TrackerStatus(this, this.scraper.getScraper(), trackerUrl);
                this.trackers.put(url_str, ts);
                if (!ts.isTrackerScrapeUrlValid() && Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hash), LOGID, 3, "Can't scrape using url '" + trackerUrl + "' as it doesn't end in " + "'/announce', skipping."));
                }
            }
            Object var7_6 = null;
            this.trackers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.trackers_mon.exit();
            throw throwable;
        }
        if (data == null) {
            data = ts.addHash(hash);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TRTrackerScraperResponseImpl peekHashData(TOTorrent torrent, URL target_url) {
        try {
            URL trackerUrl;
            URL uRL = trackerUrl = target_url == null ? torrent.getAnnounceURL() : target_url;
            if (trackerUrl == null) {
                return null;
            }
            String url_str = trackerUrl.toString();
            try {
                this.trackers_mon.enter();
                TrackerStatus ts = (TrackerStatus)this.trackers.get(url_str);
                if (ts != null) {
                    TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = ts.getHashData(torrent.getHashWrapper());
                    Object var8_8 = null;
                    this.trackers_mon.exit();
                    return tRTrackerScraperResponseImpl;
                }
                Object var8_9 = null;
                this.trackers_mon.exit();
                return null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.trackers_mon.exit();
                throw throwable;
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    protected void removeHash(TOTorrent torrent) {
        try {
            this.removeHash(torrent.getAnnounceURL().toString(), torrent.getHashWrapper());
            TOTorrentAnnounceURLSet[] sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
            for (int i = 0; i < sets.length; ++i) {
                URL[] urls = sets[i].getAnnounceURLs();
                for (int j = 0; j < urls.length; ++j) {
                    this.removeHash(urls[j].toString(), torrent.getHashWrapper());
                }
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    protected void removeHash(String trackerUrl, HashWrapper hash) {
        TrackerStatus ts = (TrackerStatus)this.trackers.get(trackerUrl);
        if (ts != null) {
            ts.removeHash(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncUpdate(TOTorrent torrent, URL target_url) {
        if (torrent == null) {
            return;
        }
        try {
            HashWrapper hash = torrent.getHashWrapper();
            TrackerStatus matched_ts = null;
            try {
                this.trackers_mon.enter();
                for (TrackerStatus ts : this.trackers.values()) {
                    Object var9_9;
                    if (target_url != null && !target_url.toString().equals(ts.getTrackerURL().toString())) continue;
                    Map hashmap = ts.getHashes();
                    try {
                        ts.getHashesMonitor().enter();
                        if (hashmap.get(hash) != null) {
                            matched_ts = ts;
                            var9_9 = null;
                            ts.getHashesMonitor().exit();
                            break;
                        }
                        var9_9 = null;
                        ts.getHashesMonitor().exit();
                    }
                    catch (Throwable throwable) {
                        var9_9 = null;
                        ts.getHashesMonitor().exit();
                        throw throwable;
                    }
                }
                Object var11_11 = null;
                this.trackers_mon.exit();
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.trackers_mon.exit();
                throw throwable;
            }
            if (matched_ts != null) {
                matched_ts.updateSingleHash(hash, true, false);
            }
        }
        catch (Throwable e) {
            Debug.out("scrape syncUpdate() exception", e);
        }
    }

    public void perform(TimerEvent event2) {
        this.runScrapes();
    }

    private void runScrapes() {
        long delay;
        TRTrackerBTScraperResponseImpl nextResponseScraping = this.checkForNextScrape();
        if (Logger.isEnabled() && nextResponseScraping != this.oldResponse && nextResponseScraping != null) {
            Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(nextResponseScraping.getHash()), LOGID, 0, "Next scrape will be " + nextResponseScraping.getURL() + " in " + (nextResponseScraping.getNextScrapeStartTime() - SystemTime.getCurrentTime()) / 1000L + " sec,type=" + (nextResponseScraping.getTrackerStatus().getSupportsMultipeHashScrapes() ? "multi" : "single") + ",active=" + nextResponseScraping.getTrackerStatus().getNumActiveScrapes()));
        }
        if (nextResponseScraping == null) {
            delay = 60000L;
        } else {
            long scrape_time = nextResponseScraping.getNextScrapeStartTime();
            long time_to_scrape = scrape_time - SystemTime.getCurrentTime() + 25L;
            if (time_to_scrape <= 0L) {
                if (nextResponseScraping.getTrackerStatus().getNumActiveScrapes() > 0) {
                    delay = 2000L;
                } else {
                    try {
                        nextResponseScraping.getTrackerStatus().updateSingleHash(nextResponseScraping.getHash(), false);
                        delay = 0L;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        delay = 30000L;
                    }
                }
            } else {
                delay = time_to_scrape;
                if (delay > 30000L) {
                    delay = 30000L;
                }
            }
        }
        this.nextScrapeCheckOn = SystemTime.getCurrentTime() + delay;
        this.oldResponse = nextResponseScraping;
        TRTrackerBTAnnouncerImpl.tracker_timer.addEvent(this.nextScrapeCheckOn, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TRTrackerBTScraperResponseImpl checkForNextScrape() {
        boolean hasEarlierBlockedScrape;
        long earliestBlocked = Long.MAX_VALUE;
        TRTrackerBTScraperResponseImpl earliestBlockedResponse = null;
        long earliestNonBlocked = Long.MAX_VALUE;
        TRTrackerBTScraperResponseImpl earliestNonBlockedResponse = null;
        try {
            this.trackers_mon.enter();
            for (TrackerStatus ts : this.trackers.values()) {
                Object var16_13;
                if (!ts.isTrackerScrapeUrlValid()) continue;
                boolean hasActiveScrapes = ts.getNumActiveScrapes() > 0;
                Map hashmap = ts.getHashes();
                try {
                    ts.getHashesMonitor().enter();
                    for (TRTrackerBTScraperResponseImpl response : hashmap.values()) {
                        if (response.getStatus() == 3) continue;
                        long nextScrapeStartTime = response.getNextScrapeStartTime();
                        if (hasActiveScrapes) {
                            if (nextScrapeStartTime >= earliestBlocked) continue;
                            earliestBlocked = nextScrapeStartTime;
                            earliestBlockedResponse = response;
                            continue;
                        }
                        if (nextScrapeStartTime >= earliestNonBlocked) continue;
                        earliestNonBlocked = nextScrapeStartTime;
                        earliestNonBlockedResponse = response;
                    }
                    var16_13 = null;
                    ts.getHashesMonitor().exit();
                }
                catch (Throwable throwable) {
                    var16_13 = null;
                    ts.getHashesMonitor().exit();
                    throw throwable;
                }
            }
            Object var18_15 = null;
            this.trackers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            this.trackers_mon.exit();
            throw throwable;
        }
        boolean bl = hasEarlierBlockedScrape = earliestBlocked != Long.MAX_VALUE && earliestBlocked < earliestNonBlocked;
        if (hasEarlierBlockedScrape && earliestNonBlocked - SystemTime.getCurrentTime() > 2000L) {
            return earliestBlockedResponse;
        }
        return earliestNonBlockedResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clockChangeDetected(long current_time, long offset) {
        if (Math.abs(offset) < 60000L) {
            return;
        }
        try {
            this.trackers_mon.enter();
            for (TrackerStatus ts : this.trackers.values()) {
                Object var13_9;
                Map hashmap = ts.getHashes();
                try {
                    ts.getHashesMonitor().enter();
                    for (TRTrackerBTScraperResponseImpl response : hashmap.values()) {
                        long time = response.getNextScrapeStartTime();
                        if (time <= 0L) continue;
                        response.setNextScrapeStartTime(time + offset);
                    }
                    var13_9 = null;
                    ts.getHashesMonitor().exit();
                }
                catch (Throwable throwable) {
                    var13_9 = null;
                    ts.getHashesMonitor().exit();
                    throw throwable;
                }
            }
            Object var15_11 = null;
            this.trackers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var15_12 = null;
            this.trackers_mon.exit();
            throw throwable;
        }
    }

    public void clockChangeCompleted(long current_time, long offset) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("BTScraper - now = " + SystemTime.getCurrentTime());
        try {
            writer.indent();
            try {
                this.trackers_mon.enter();
                for (Map.Entry entry : this.trackers.entrySet()) {
                    Object var10_9;
                    TrackerStatus ts = (TrackerStatus)entry.getValue();
                    writer.println("Tracker: " + ts.getString());
                    try {
                        writer.indent();
                        ts.getHashesMonitor().enter();
                        Map hashmap = ts.getHashes();
                        for (Map.Entry hash_entry : hashmap.entrySet()) {
                            TRTrackerBTScraperResponseImpl response = (TRTrackerBTScraperResponseImpl)hash_entry.getValue();
                            writer.println(response.getString());
                        }
                        var10_9 = null;
                        ts.getHashesMonitor().exit();
                        writer.exdent();
                    }
                    catch (Throwable throwable) {
                        var10_9 = null;
                        ts.getHashesMonitor().exit();
                        writer.exdent();
                        throw throwable;
                    }
                }
                Object var12_11 = null;
                this.trackers_mon.exit();
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                this.trackers_mon.exit();
                throw throwable;
            }
            Object var14_14 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            writer.exdent();
            throw throwable;
        }
    }

    public long getNextScrapeCheckOn() {
        return this.nextScrapeCheckOn;
    }
}

