/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class ClipboardCopy {
    public static void copyToClipBoard(final String data) {
        Runnable do_it = new Runnable(){

            public void run() {
                new Clipboard(SWTThread.getInstance().getDisplay()).setContents(new Object[]{data.replaceAll("\\x00", " ")}, new Transfer[]{TextTransfer.getInstance()});
            }
        };
        if (Utils.isSWTThread()) {
            do_it.run();
        } else {
            Utils.execSWTThread(do_it);
        }
    }

    public static void addCopyToClipMenu(final Control control, final copyToClipProvider provider2) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (control.isDisposed()) {
                    return;
                }
                final String text = provider2.getText();
                if (control.getMenu() != null || text == null || text.length() == 0) {
                    return;
                }
                if (e.button != 3 && (e.button != 1 || e.stateMask != 262144)) {
                    return;
                }
                final Menu menu = new Menu((Decorations)control.getShell(), 8);
                MenuItem item = new MenuItem(menu, 0);
                String msg_text_id = provider2 instanceof copyToClipProvider2 ? ((copyToClipProvider2)provider2).getMenuResource() : "label.copy.to.clipboard";
                item.setText(MessageText.getString(msg_text_id));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent arg0) {
                        new Clipboard(control.getDisplay()).setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
                    }
                });
                control.setMenu(menu);
                menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuHidden(MenuEvent arg0) {
                        if (control.getMenu() == menu) {
                            control.setMenu(null);
                        }
                    }
                });
                menu.setVisible(true);
            }
        });
    }

    public static void addCopyToClipMenu(final Control control) {
        ClipboardCopy.addCopyToClipMenu(control, new copyToClipProvider(){

            public String getText() {
                return (String)control.getData();
            }
        });
    }

    public static interface copyToClipProvider {
        public String getText();
    }

    public static interface copyToClipProvider2
    extends copyToClipProvider {
        public String getMenuResource();
    }
}

