/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.core.util.RegExUtil;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.views.FilesViewMenuUtil;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.file.FileInfoView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.files.DoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileAvailabilityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileCRC32Item;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileETAItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileExtensionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileIndexItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileMD5Item;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileReadSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileSHA1Item;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileWriteSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FirstPieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ModeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PercentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PieceCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PriorityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ProgressGraphItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.RemainingPiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.StorageTypeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.TorrentRelativePathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AlertsItem;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesView
extends TableViewTab<DiskManagerFileInfo>
implements TableDataSourceChangedListener,
TableSelectionListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
DownloadManagerStateAttributeListener,
DownloadManagerListener,
TableLifeCycleListener,
TableViewFilterCheck<DiskManagerFileInfo>,
KeyListener {
    private static boolean registeredCoreSubViews = false;
    boolean refreshing = false;
    private DragSource dragSource = null;
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new PathItem(), new SizeItem(), new DoneItem(), new PercentItem(), new FirstPieceItem(), new PieceCountItem(), new RemainingPiecesItem(), new ProgressGraphItem(), new ModeItem(), new PriorityItem(), new StorageTypeItem(), new FileExtensionItem(), new FileIndexItem(), new TorrentRelativePathItem(), new FileCRC32Item(), new FileMD5Item(), new FileSHA1Item(), new FileAvailabilityItem(), new AlertsItem("Files"), new FileReadSpeedItem(), new FileWriteSpeedItem(), new FileETAItem()};
    public static final String MSGID_PREFIX = "FilesView";
    private DownloadManager manager = null;
    private boolean enable_tabs = true;
    public static boolean show_full_path;
    public static boolean hide_dnd_files;
    private MenuItem path_item;
    private TableViewSWT<DiskManagerFileInfo> tv;
    private final boolean allowTabViews;
    private boolean force_refresh = false;

    public FilesView() {
        super(MSGID_PREFIX);
        this.allowTabViews = true;
    }

    public FilesView(boolean allowTabViews) {
        super(MSGID_PREFIX);
        this.allowTabViews = allowTabViews;
    }

    @Override
    public TableViewSWT<DiskManagerFileInfo> initYourTableView() {
        UISWTInstance pluginUI;
        this.tv = TableViewFactory.createTableViewSWT(org.gudy.azureus2.plugins.disk.DiskManagerFileInfo.class, "Files", this.getPropertiesPrefix(), basicItems, "firstpiece", 0x10010002);
        this.tv.setRowDefaultIconSize(new Point(16, 16));
        if (this.allowTabViews) {
            this.tv.setEnableTabViews(this.enable_tabs, true, null);
        }
        this.tv.enableFilterCheck(null, this);
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (pluginUI = uiFunctions.getUISWTInstance()) != null && !registeredCoreSubViews) {
            pluginUI.addView("Files", "FileInfoView", FileInfoView.class, this.manager);
            registeredCoreSubViews = true;
        }
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addRefreshListener(this, true);
        this.tv.addSelectionListener(this, false);
        this.tv.addMenuFillListener(this);
        this.tv.addLifeCycleListener(this);
        this.tv.addKeyListener(this);
        return this.tv;
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        DownloadManager newManager = null;
        if (newDataSource instanceof Object[]) {
            Object[] newDataSources = (Object[])newDataSource;
            if (newDataSources.length == 1) {
                Object temp = ((Object[])newDataSource)[0];
                if (temp instanceof DownloadManager) {
                    newManager = (DownloadManager)temp;
                } else if (temp instanceof DiskManagerFileInfo) {
                    newManager = ((DiskManagerFileInfo)temp).getDownloadManager();
                }
            }
        } else if (newDataSource instanceof DownloadManager) {
            newManager = (DownloadManager)newDataSource;
        } else if (newDataSource instanceof DiskManagerFileInfo) {
            newManager = ((DiskManagerFileInfo)newDataSource).getDownloadManager();
        }
        if (newManager == this.manager) {
            this.tv.setEnabled(this.manager != null);
            return;
        }
        if (this.manager != null) {
            this.manager.getDownloadState().removeListener(this, "filelinks2", 1);
            this.manager.removeListener(this);
        }
        this.manager = newManager;
        if (this.manager != null) {
            this.manager.getDownloadState().addListener(this, "filelinks2", 1);
            this.manager.addListener(this);
        }
        if (!this.tv.isDisposed()) {
            this.tv.removeAllTableRows();
            this.tv.setEnabled(this.manager != null);
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void focusChanged(TableRowCore focus) {
    }

    @Override
    public void selected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void stateChanged(DownloadManager manager, int state) {
    }

    @Override
    public void downloadComplete(DownloadManager manager) {
    }

    @Override
    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    @Override
    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    @Override
    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
        if (hide_dnd_files) {
            this.tv.refilter();
        }
    }

    @Override
    public boolean filterCheck(DiskManagerFileInfo ds, String filter2, boolean regex) {
        if (hide_dnd_files && ds.isSkipped()) {
            return false;
        }
        if (filter2 == null || filter2.length() == 0) {
            return true;
        }
        if (this.tv.getFilterControl() == null) {
            return true;
        }
        try {
            Pattern pattern;
            File file = ds.getFile(true);
            String name = filter2.contains(File.separator) ? file.getAbsolutePath() : file.getName();
            String s = regex ? filter2 : "\\Q" + filter2.replaceAll("[|;]", "\\\\E|\\\\Q") + "\\E";
            boolean match_result = true;
            if (regex && s.startsWith("!")) {
                s = s.substring(1);
                match_result = false;
            }
            return (pattern = RegExUtil.getCachedPattern("fv:search", s, 2)).matcher(name).find() == match_result;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public void filterSet(String filter2) {
    }

    public void updateSelectedContent() {
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        ArrayList<SelectedContent> listSelected = new ArrayList<SelectedContent>(dataSources.length);
        for (Object ds : dataSources) {
            if (!(ds instanceof DiskManagerFileInfo)) continue;
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            listSelected.add(new SelectedContent(fileInfo2.getDownloadManager(), fileInfo2.getIndex()));
        }
        ISelectedContent[] sc = listSelected.toArray(new SelectedContent[0]);
        SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), sc, this.tv);
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)this.tv.getFirstSelectedDataSource();
        if (fileInfo2 == null) {
            return;
        }
        String mode = COConfigurationManager.getStringParameter("list.dm.dblclick");
        if (mode.equals("2")) {
            boolean openMode = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
            ManagerUtils.open(fileInfo2, openMode);
        } else {
            boolean webInBrowser = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowser");
            if (webInBrowser && ManagerUtils.browseWebsite(fileInfo2)) {
                return;
            }
            if (mode.equals("3") || mode.equals("4")) {
                if (fileInfo2.getAccessMode() == 1) {
                    if (mode.equals("4") && fileInfo2.getDownloaded() == fileInfo2.getLength() && Utils.isQuickViewSupported(fileInfo2)) {
                        Utils.setQuickViewActive(fileInfo2, true);
                    } else {
                        Utils.launch(fileInfo2);
                    }
                }
            } else if (mode.equals("5")) {
                ManagerUtils.browse(fileInfo2);
            } else {
                DownloadManager dm;
                AZ3Functions.provider az3 = AZ3Functions.getProvider();
                if (az3 != null && (az3.canPlay(dm = fileInfo2.getDownloadManager(), fileInfo2.getIndex()) || (stateMask & 0x40000) != 0)) {
                    az3.play(dm, fileInfo2.getIndex());
                    return;
                }
                if (fileInfo2.getAccessMode() == 1) {
                    Utils.launch(fileInfo2);
                }
            }
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        Object[] data_sources = this.tv.getSelectedDataSources().toArray();
        FilesViewMenuUtil.fillMenu(this.tv, menu, this.manager, data_sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableRefresh() {
        if (this.refreshing) {
            return;
        }
        try {
            this.refreshing = true;
            if (this.tv.isDisposed()) {
                Object var8_1 = null;
                this.refreshing = false;
                return;
            }
            DiskManagerFileInfo[] files = this.getFileInfo();
            if (files != null && (this.force_refresh || !this.doAllExist(files))) {
                this.force_refresh = false;
                List datasources = this.tv.getDataSources();
                if (datasources.size() == files.length) {
                    ArrayList<DiskManagerFileInfo> toAdd = new ArrayList<DiskManagerFileInfo>(Arrays.asList(files));
                    ArrayList<DiskManagerFileInfo> toRemove = new ArrayList<DiskManagerFileInfo>();
                    for (int i = 0; i < datasources.size(); ++i) {
                        DiskManagerFileInfo info = (DiskManagerFileInfo)datasources.get(i);
                        if (files[info.getIndex()] == info) {
                            toAdd.set(info.getIndex(), null);
                            continue;
                        }
                        toRemove.add(info);
                    }
                    this.tv.removeDataSources((DiskManagerFileInfo[])toRemove.toArray(new DiskManagerFileInfo[toRemove.size()]));
                    this.tv.addDataSources((DiskManagerFileInfo[])toAdd.toArray(new DiskManagerFileInfo[toAdd.size()]));
                    this.tv.tableInvalidate();
                } else {
                    this.tv.removeAllTableRows();
                    DiskManagerFileInfo[] filesCopy = new DiskManagerFileInfo[files.length];
                    System.arraycopy(files, 0, filesCopy, 0, files.length);
                    this.tv.addDataSources((DiskManagerFileInfo[])filesCopy);
                }
                this.tv.processDataSourceQueue();
            }
        }
        catch (Throwable throwable) {
            Object var8_3 = null;
            this.refreshing = false;
            throw throwable;
        }
        Object var8_2 = null;
        this.refreshing = false;
    }

    private boolean doAllExist(DiskManagerFileInfo[] files) {
        for (int i = 0; i < files.length; ++i) {
            DiskManagerFileInfo fileinfo = files[i];
            if (!this.tv.isFiltered(fileinfo)) continue;
            TableRowCore row = this.tv.getRow(fileinfo);
            if (row == null) {
                return false;
            }
            if (row.getDataSource(true) == fileinfo) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        if (sColumnName.equals("path")) {
            this.path_item = new MenuItem(menuThisColumn, 32);
            this.path_item.setSelection(show_full_path);
            Messages.setLanguageText((Widget)this.path_item, "FilesView.fullpath");
            this.path_item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    show_full_path = FilesView.this.path_item.getSelection();
                    FilesView.this.tv.columnInvalidate("path");
                    FilesView.this.tv.refreshTable(false);
                    COConfigurationManager.setParameter("FilesView.show.full.path", show_full_path);
                }
            });
        } else if (sColumnName.equals("file_eta")) {
            final MenuItem item = new MenuItem(menuThisColumn, 32);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.eta.abs");
            item.setSelection(MyTorrentsView.eta_absolute);
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    MyTorrentsView.eta_absolute = item.getSelection();
                    FilesView.this.tv.columnInvalidate("eta");
                    FilesView.this.tv.refreshTable(false);
                    COConfigurationManager.setParameter("mtv.eta.show_absolute", MyTorrentsView.eta_absolute);
                }
            });
        } else if (sColumnName.equals("priority")) {
            final MenuItem item = new MenuItem(menuThisColumn, 32);
            Messages.setLanguageText((Widget)item, "FilesView.hide.dnd");
            item.setSelection(hide_dnd_files);
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    hide_dnd_files = item.getSelection();
                    COConfigurationManager.setParameter("FilesView.hide.dnd", hide_dnd_files);
                    FilesView.this.tv.refilter();
                }
            });
        }
    }

    private DiskManagerFileInfo[] getFileInfo() {
        if (this.manager == null) {
            return null;
        }
        return this.manager.getDiskManagerFileInfoSet().getFiles();
    }

    @Override
    public void attributeEventOccurred(DownloadManager dm, String attribute_name, int event_type) {
        Object oIsChangingLinks = dm.getUserData("is_changing_links");
        if (oIsChangingLinks instanceof Boolean && ((Boolean)oIsChangingLinks).booleanValue()) {
            return;
        }
        this.force_refresh = true;
    }

    @Override
    public void tableViewInitialized() {
        this.createDragDrop();
    }

    @Override
    public void tableViewTabInitComplete() {
        this.updateSelectedContent();
        super.tableViewTabInitComplete();
    }

    @Override
    public void tableViewDestroyed() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    Utils.disposeSWTObjects(new Object[]{FilesView.this.dragSource});
                    FilesView.this.dragSource = null;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        });
        if (this.manager != null) {
            this.manager.getDownloadState().removeListener(this, "filelinks2", 1);
            this.manager.removeListener(this);
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    private void createDragDrop() {
        try {
            Transfer[] types = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
            if (this.dragSource != null && !this.dragSource.isDisposed()) {
                this.dragSource.dispose();
            }
            this.dragSource = this.tv.createDragSource(1);
            if (this.dragSource != null) {
                this.dragSource.setTransfer(types);
                this.dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){
                    private String eventData1;
                    private String[] eventData2;

                    public void dragStart(DragSourceEvent event2) {
                        TableRowCore[] rows = FilesView.this.tv.getSelectedRows();
                        if (rows.length == 0 || FilesView.this.manager == null || FilesView.this.manager.getTorrent() == null) {
                            event2.doit = false;
                            return;
                        }
                        event2.doit = true;
                        Object[] selectedDownloads = FilesView.this.tv.getSelectedDataSources().toArray();
                        this.eventData2 = new String[selectedDownloads.length];
                        this.eventData1 = "DiskManagerFileInfo\n";
                        TOTorrent torrent = FilesView.this.manager.getTorrent();
                        for (int i = 0; i < selectedDownloads.length; ++i) {
                            DiskManagerFileInfo fi = (DiskManagerFileInfo)selectedDownloads[i];
                            try {
                                this.eventData1 = this.eventData1 + torrent.getHashWrapper().toBase32String() + ";" + fi.getIndex() + "\n";
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                this.eventData2[i] = fi.getFile(true).getAbsolutePath();
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        if (FileTransfer.getInstance().isSupportedType(event2.dataType)) {
                            event2.data = this.eventData2;
                            event2.detail = 1;
                        } else {
                            event2.data = this.eventData1;
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.log(new LogEvent(LogIDs.GUI, "failed to init drag-n-drop", t));
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        if (event2.getType() == 0 && event2 instanceof UISWTViewEventImpl) {
            String parent = ((UISWTViewEventImpl)event2).getParentID();
            this.enable_tabs = parent != null && parent.equals("TorrentDetailsView");
        }
        boolean b = super.eventOccurred(event2);
        if (event2.getType() == 3) {
            this.updateSelectedContent();
        } else if (event2.getType() == 4) {
            SelectedContentManager.clearCurrentlySelectedContent();
        }
        return b;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 0x100000B && (e.stateMask & SWT.MODIFIER_MASK) == 0) {
            FilesViewMenuUtil.rename(this.tv, null, this.tv.getSelectedDataSources(true), true, false);
            e.doit = false;
            return;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames("Files", basicItems);
        COConfigurationManager.addAndFireParameterListener("FilesView.show.full.path", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                show_full_path = COConfigurationManager.getBooleanParameter("FilesView.show.full.path");
            }
        });
    }
}

