/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.HashSet;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListenerEx;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.PeersSuperView;
import org.gudy.azureus2.ui.swt.views.PeersView;
import org.gudy.azureus2.ui.swt.views.peer.PeerInfoView;
import org.gudy.azureus2.ui.swt.views.peer.RemotePieceDistributionView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DownloadNameItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeersGeneralView
extends TableViewTab<PEPeer>
implements TagListener,
TableLifeCycleListener,
TableViewSWTMenuFillListener,
UISWTViewCoreEventListenerEx {
    private TableViewSWT<PEPeer> tv;
    private Shell shell;
    private Tag tag;

    public PeersGeneralView(Tag _tag) {
        super("AllPeersView");
        this.tag = _tag;
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public UISWTViewCoreEventListener getClone() {
        return new PeersGeneralView(this.tag);
    }

    @Override
    public String getFullTitle() {
        return this.tag.getTagName(true);
    }

    @Override
    public TableViewSWT<PEPeer> initYourTableView() {
        UISWTInstance pluginUI;
        TableColumnCore[] items = PeersView.getBasicColumnItems("AllPeers");
        TableColumnCore[] basicItems = new TableColumnCore[items.length + 1];
        System.arraycopy(items, 0, basicItems, 0, items.length);
        basicItems[items.length] = new DownloadNameItem("AllPeers");
        this.tv = TableViewFactory.createTableViewSWT(Peer.class, "AllPeers", this.getPropertiesPrefix(), basicItems, "connected_time", 0x10010002);
        this.tv.setRowDefaultHeight(16);
        this.tv.setEnableTabViews(true, true, null);
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (pluginUI = uiFunctions.getUISWTInstance()) != null && !PeersSuperView.registeredCoreSubViews) {
            pluginUI.addView("AllPeers", "PeerInfoView", PeerInfoView.class, null);
            pluginUI.addView("AllPeers", "RemotePieceDistributionView", RemotePieceDistributionView.class, null);
            pluginUI.addView("AllPeers", "LoggerView", LoggerView.class, true);
            PeersSuperView.registeredCoreSubViews = true;
        }
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        return this.tv;
    }

    @Override
    public void taggableAdded(Tag tag, Taggable tagged) {
        this.tv.addDataSource((PEPeer)tagged);
    }

    @Override
    public void taggableSync(Tag tag) {
        if (this.tv.getRowCount() != tag.getTaggedCount()) {
            HashSet peers_in_table = new HashSet(this.tv.getDataSources());
            HashSet<Taggable> peers_in_tag = new HashSet<Taggable>(tag.getTagged());
            for (PEPeer pEPeer : peers_in_table) {
                if (peers_in_tag.contains(pEPeer)) continue;
                this.tv.removeDataSource(pEPeer);
            }
            for (PEPeer pEPeer : peers_in_tag) {
                if (peers_in_table.contains(pEPeer)) continue;
                this.tv.addDataSource(pEPeer);
            }
        }
    }

    @Override
    public void taggableRemoved(Tag tag, Taggable tagged) {
        this.tv.removeDataSource((PEPeer)tagged);
    }

    @Override
    public void tableViewInitialized() {
        this.shell = this.tv.getComposite().getShell();
        this.tag.addTagListener(this, true);
    }

    @Override
    public void tableViewDestroyed() {
        this.tag.removeTagListener(this);
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        PeersView.fillMenu(menu, this.tv, this.shell, null);
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }
}

