/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.ui.common.table.impl.CoreTableColumn;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewUtils {
    private static SimpleDateFormat formatOverride = null;
    public static final String SM_PROP_PERMIT_UPLOAD_DISABLE = "enable_upload_disable";
    public static final String SM_PROP_PERMIT_DOWNLOAD_DISABLE = "enable_download_disable";
    private static final Map<String, Object> SM_DEFAULTS;

    public static String formatETA(long value, boolean absolute, SimpleDateFormat override) {
        SimpleDateFormat df;
        SimpleDateFormat simpleDateFormat = df = override != null ? override : formatOverride;
        if (absolute && df != null && value > 0L && value != 31536000L && value < 1827387392L) {
            try {
                return df.format(new Date(SystemTime.getCurrentTime() + 1000L * value));
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return DisplayFormatters.formatETA(value, absolute);
    }

    public static CustomDateFormat addCustomDateFormat(CoreTableColumn column) {
        return new CustomDateFormat(column);
    }

    public static void addSpeedMenu(Shell shell, Menu menuAdvanced, boolean doUpMenu, boolean doDownMenu, boolean isTorrentContext, boolean hasSelection, boolean downSpeedDisabled, boolean downSpeedUnlimited, long totalDownSpeed, long downSpeedSetMax, long maxDownload, boolean upSpeedDisabled, boolean upSpeedUnlimited, long totalUpSpeed, long upSpeedSetMax, long maxUpload, int num_entries, Map<String, Object> _properties, SpeedAdapter adapter) {
        if (doDownMenu) {
            org.eclipse.swt.widgets.MenuItem itemDownSpeed = new org.eclipse.swt.widgets.MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemDownSpeed, "MyTorrentsView.menu.setDownSpeed");
            Utils.setMenuItemImage(itemDownSpeed, "speed");
            Menu menuDownSpeed = new Menu((Decorations)shell, 4);
            itemDownSpeed.setMenu(menuDownSpeed);
            ViewUtils.addSpeedMenuDown(shell, menuDownSpeed, isTorrentContext, hasSelection, downSpeedDisabled, downSpeedUnlimited, totalDownSpeed, downSpeedSetMax, maxDownload, num_entries, _properties, adapter);
        }
        if (doUpMenu) {
            org.eclipse.swt.widgets.MenuItem itemUpSpeed = new org.eclipse.swt.widgets.MenuItem(menuAdvanced, 64);
            Messages.setLanguageText((Widget)itemUpSpeed, "MyTorrentsView.menu.setUpSpeed");
            Utils.setMenuItemImage(itemUpSpeed, "speed");
            Menu menuUpSpeed = new Menu((Decorations)shell, 4);
            itemUpSpeed.setMenu(menuUpSpeed);
            ViewUtils.addSpeedMenuUp(shell, menuUpSpeed, isTorrentContext, hasSelection, upSpeedDisabled, upSpeedUnlimited, totalUpSpeed, upSpeedSetMax, maxUpload, num_entries, _properties, adapter);
        }
    }

    public static void addSpeedMenuUp(final Shell shell, Menu menuSpeed, boolean isTorrentContext, boolean hasSelection, boolean upSpeedDisabled, boolean upSpeedUnlimited, long totalUpSpeed, long upSpeedSetMax, long maxUpload, final int num_entries, Map<String, Object> _properties, final SpeedAdapter adapter) {
        HashMap<String, Object> properties = new HashMap<String, Object>(SM_DEFAULTS);
        if (_properties != null) {
            properties.putAll(_properties);
        }
        String menu_key = "MyTorrentsView.menu.manual";
        if (num_entries > 1) {
            menu_key = menu_key + (isTorrentContext ? ".per_torrent" : ".per_peer");
        }
        if (menuSpeed != null) {
            boolean allowDisable;
            org.eclipse.swt.widgets.MenuItem itemCurrentUpSpeed = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
            itemCurrentUpSpeed.setEnabled(false);
            String separator = "";
            StringBuffer speedText = new StringBuffer();
            if (upSpeedDisabled) {
                speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.disabled"));
                separator = " / ";
            }
            if (upSpeedUnlimited) {
                speedText.append(separator);
                speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
                separator = " / ";
            }
            if (totalUpSpeed > 0L) {
                speedText.append(separator);
                speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalUpSpeed));
            }
            itemCurrentUpSpeed.setText(speedText.toString());
            new org.eclipse.swt.widgets.MenuItem(menuSpeed, 2);
            Listener itemsUpSpeedListener = new Listener(){

                public void handleEvent(Event e) {
                    if (e.widget != null && e.widget instanceof org.eclipse.swt.widgets.MenuItem) {
                        org.eclipse.swt.widgets.MenuItem item = (org.eclipse.swt.widgets.MenuItem)e.widget;
                        int speed = item.getData("maxul") == null ? 0 : (Integer)item.getData("maxul");
                        adapter.setUpSpeed(speed);
                    }
                }
            };
            if (num_entries > 1 || !upSpeedUnlimited) {
                org.eclipse.swt.widgets.MenuItem mi = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)mi, "MyTorrentsView.menu.setSpeed.unlimit");
                mi.setData("maxul", (Object)new Integer(0));
                mi.addListener(13, itemsUpSpeedListener);
            }
            if ((allowDisable = ((Boolean)properties.get(SM_PROP_PERMIT_UPLOAD_DISABLE)).booleanValue()) && !upSpeedDisabled) {
                org.eclipse.swt.widgets.MenuItem mi = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)mi, "MyTorrentsView.menu.setSpeed.disable");
                mi.setData("maxul", (Object)new Integer(-1));
                mi.addListener(13, itemsUpSpeedListener);
            }
            if (hasSelection) {
                maxUpload = maxUpload == 0L ? 76800L : (upSpeedSetMax <= 0L ? 204800L : 4L * (upSpeedSetMax / 1024L) * 1024L);
                for (int i = 0; i < 10; ++i) {
                    org.eclipse.swt.widgets.MenuItem mi = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
                    mi.addListener(13, itemsUpSpeedListener);
                    int limit = (int)(maxUpload / (long)(10 * num_entries) * (long)(10 - i));
                    String speed = DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * num_entries);
                    if (num_entries > 1) {
                        speed = MessageText.getString("MyTorrentsView.menu.setSpeed.multi", new String[]{speed, String.valueOf(num_entries), DisplayFormatters.formatByteCountToKiBEtcPerSec(limit)});
                    }
                    mi.setText(speed);
                    mi.setData("maxul", (Object)new Integer(limit));
                }
            }
            new org.eclipse.swt.widgets.MenuItem(menuSpeed, 2);
            org.eclipse.swt.widgets.MenuItem itemUpSpeedManualSingle = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
            Messages.setLanguageText((Widget)itemUpSpeedManualSingle, menu_key);
            itemUpSpeedManualSingle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int speed_value = ViewUtils.getManualSpeedValue(shell, false);
                    if (speed_value > 0) {
                        adapter.setUpSpeed(speed_value);
                    }
                }
            });
            if (num_entries > 1) {
                org.eclipse.swt.widgets.MenuItem itemUpSpeedManualShared = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)itemUpSpeedManualShared, isTorrentContext ? "MyTorrentsView.menu.manual.shared_torrents" : "MyTorrentsView.menu.manual.shared_peers");
                itemUpSpeedManualShared.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int speed_value = ViewUtils.getManualSharedSpeedValue(shell, false, num_entries);
                        if (speed_value > 0) {
                            adapter.setUpSpeed(speed_value);
                        }
                    }
                });
            }
        }
    }

    public static void addSpeedMenuDown(final Shell shell, Menu menuSpeed, boolean isTorrentContext, boolean hasSelection, boolean downSpeedDisabled, boolean downSpeedUnlimited, long totalDownSpeed, long downSpeedSetMax, long maxDownload, final int num_entries, Map<String, Object> _properties, final SpeedAdapter adapter) {
        HashMap<String, Object> properties = new HashMap<String, Object>(SM_DEFAULTS);
        if (_properties != null) {
            properties.putAll(_properties);
        }
        String menu_key = "MyTorrentsView.menu.manual";
        if (num_entries > 1) {
            menu_key = menu_key + (isTorrentContext ? ".per_torrent" : ".per_peer");
        }
        if (menuSpeed != null) {
            boolean allowDisable;
            org.eclipse.swt.widgets.MenuItem itemCurrentDownSpeed = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
            itemCurrentDownSpeed.setEnabled(false);
            StringBuffer speedText = new StringBuffer();
            String separator = "";
            if (downSpeedDisabled) {
                speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.disabled"));
                separator = " / ";
            }
            if (downSpeedUnlimited) {
                speedText.append(separator);
                speedText.append(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
                separator = " / ";
            }
            if (totalDownSpeed > 0L) {
                speedText.append(separator);
                speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalDownSpeed));
            }
            itemCurrentDownSpeed.setText(speedText.toString());
            new org.eclipse.swt.widgets.MenuItem(menuSpeed, 2);
            Listener itemsDownSpeedListener = new Listener(){

                public void handleEvent(Event e) {
                    if (e.widget != null && e.widget instanceof org.eclipse.swt.widgets.MenuItem) {
                        org.eclipse.swt.widgets.MenuItem item = (org.eclipse.swt.widgets.MenuItem)e.widget;
                        int speed = item.getData("maxdl") == null ? 0 : (Integer)item.getData("maxdl");
                        adapter.setDownSpeed(speed);
                    }
                }
            };
            if (num_entries > 1 || !downSpeedUnlimited) {
                org.eclipse.swt.widgets.MenuItem mi = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)mi, "MyTorrentsView.menu.setSpeed.unlimit");
                mi.setData("maxdl", (Object)new Integer(0));
                mi.addListener(13, itemsDownSpeedListener);
            }
            if ((allowDisable = ((Boolean)properties.get(SM_PROP_PERMIT_DOWNLOAD_DISABLE)).booleanValue()) && !downSpeedDisabled) {
                org.eclipse.swt.widgets.MenuItem mi = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)mi, "MyTorrentsView.menu.setSpeed.down.disable");
                mi.setData("maxdl", (Object)new Integer(-1));
                mi.addListener(13, itemsDownSpeedListener);
            }
            if (hasSelection) {
                if (maxDownload == 0L) {
                    maxDownload = downSpeedSetMax <= 0L ? 204800L : 4L * (downSpeedSetMax / 1024L) * 1024L;
                }
                for (int i = 0; i < 10; ++i) {
                    org.eclipse.swt.widgets.MenuItem mi = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
                    mi.addListener(13, itemsDownSpeedListener);
                    int limit = (int)(maxDownload / (long)(10 * num_entries) * (long)(10 - i));
                    String speed = DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * num_entries);
                    if (num_entries > 1) {
                        speed = MessageText.getString("MyTorrentsView.menu.setSpeed.multi", new String[]{speed, String.valueOf(num_entries), DisplayFormatters.formatByteCountToKiBEtcPerSec(limit)});
                    }
                    mi.setText(speed);
                    mi.setData("maxdl", (Object)new Integer(limit));
                }
            }
            new org.eclipse.swt.widgets.MenuItem(menuSpeed, 2);
            org.eclipse.swt.widgets.MenuItem itemDownSpeedManualSingle = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
            Messages.setLanguageText((Widget)itemDownSpeedManualSingle, menu_key);
            itemDownSpeedManualSingle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int speed_value = ViewUtils.getManualSpeedValue(shell, true);
                    if (speed_value > 0) {
                        adapter.setDownSpeed(speed_value);
                    }
                }
            });
            if (num_entries > 1) {
                org.eclipse.swt.widgets.MenuItem itemDownSpeedManualShared = new org.eclipse.swt.widgets.MenuItem(menuSpeed, 8);
                Messages.setLanguageText((Widget)itemDownSpeedManualShared, isTorrentContext ? "MyTorrentsView.menu.manual.shared_torrents" : "MyTorrentsView.menu.manual.shared_peers");
                itemDownSpeedManualShared.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int speed_value = ViewUtils.getManualSharedSpeedValue(shell, true, num_entries);
                        if (speed_value > 0) {
                            adapter.setDownSpeed(speed_value);
                        }
                    }
                });
            }
        }
    }

    public static int getManualSpeedValue(Shell shell, boolean for_download) {
        String kbps_str = MessageText.getString("MyTorrentsView.dialog.setNumber.inKbps", new String[]{DisplayFormatters.getRateUnit(1)});
        String set_num_str = MessageText.getString("MyTorrentsView.dialog.setNumber." + (for_download ? "download" : "upload"));
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow();
        entryWindow.initTexts("MyTorrentsView.dialog.setSpeed.title", new String[]{set_num_str}, "MyTorrentsView.dialog.setNumber.text", new String[]{kbps_str, set_num_str});
        entryWindow.prompt();
        if (!entryWindow.hasSubmittedInput()) {
            return -1;
        }
        String sReturn = entryWindow.getSubmittedInput();
        if (sReturn == null) {
            return -1;
        }
        try {
            int result = (int)(Double.valueOf(sReturn) * 1024.0);
            if (DisplayFormatters.isRateUsingBits()) {
                result /= 8;
            }
            if (result <= 0) {
                throw new NumberFormatException("non-positive number entered");
            }
            return result;
        }
        catch (NumberFormatException er) {
            MessageBox mb = new MessageBox(shell, 33);
            mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
            mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
            mb.open();
            return -1;
        }
    }

    public static int getManualSharedSpeedValue(Shell shell, boolean for_download, int num_entries) {
        int result = ViewUtils.getManualSpeedValue(shell, for_download);
        if (result == -1) {
            return -1;
        }
        if ((result /= num_entries) == 0) {
            result = 1;
        }
        return result;
    }

    public static void setViewRequiresOneDownload(Composite genComposite) {
        if (genComposite == null || genComposite.isDisposed()) {
            return;
        }
        Utils.disposeComposite(genComposite, false);
        Label lab = new Label(genComposite, 0);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, true);
        gridData.verticalIndent = 10;
        lab.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lab, "view.one.download.only");
        genComposite.layout(true);
        Composite parent = genComposite.getParent();
        if (parent instanceof ScrolledComposite) {
            ScrolledComposite scrolled_comp = (ScrolledComposite)parent;
            Rectangle r = scrolled_comp.getClientArea();
            scrolled_comp.setMinSize(genComposite.computeSize(r.width, -1));
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener("Table.column.dateformat", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                String temp = COConfigurationManager.getStringParameter("Table.column.dateformat", "");
                if (temp == null || temp.trim().length() == 0) {
                    formatOverride = null;
                } else {
                    try {
                        SimpleDateFormat format = new SimpleDateFormat(temp.trim());
                        format.format(new Date());
                        formatOverride = format;
                    }
                    catch (Throwable e) {
                        formatOverride = null;
                    }
                }
            }
        });
        SM_DEFAULTS = new HashMap<String, Object>();
        SM_DEFAULTS.put(SM_PROP_PERMIT_UPLOAD_DISABLE, false);
        SM_DEFAULTS.put(SM_PROP_PERMIT_DOWNLOAD_DISABLE, false);
    }

    public static class CustomDateFormat {
        private CoreTableColumn column;
        private TableContextMenuItem custom_date_menu;
        private SimpleDateFormat custom_date_format;

        private CustomDateFormat(CoreTableColumn _column) {
            this.column = _column;
            this.custom_date_menu = this.column.addContextMenuItem("label.date.format", 1);
            this.custom_date_menu.setStyle(1);
            this.custom_date_menu.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    Object existing_o = CustomDateFormat.this.column.getUserData("CustomDate");
                    String existing_text = "";
                    if (existing_o instanceof String) {
                        existing_text = (String)existing_o;
                    } else if (existing_o instanceof byte[]) {
                        try {
                            existing_text = new String((byte[])existing_o, "UTF-8");
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("ConfigView.section.style.customDateFormat", "label.date.format");
                    entryWindow.setPreenteredText(existing_text, false);
                    entryWindow.prompt(new UIInputReceiverListener(){

                        public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                            if (!entryWindow.hasSubmittedInput()) {
                                return;
                            }
                            String date_format = entryWindow.getSubmittedInput();
                            if (date_format == null) {
                                return;
                            }
                            date_format = date_format.trim();
                            CustomDateFormat.this.column.setUserData("CustomDate", date_format);
                            CustomDateFormat.this.column.invalidateCells();
                            CustomDateFormat.this.update();
                        }
                    });
                }
            });
        }

        public void update() {
            Object cd = this.column.getUserData("CustomDate");
            String format = null;
            if (cd instanceof byte[]) {
                try {
                    cd = new String((byte[])cd, "UTF-8");
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (cd instanceof String) {
                String str = (String)cd;
                if ((str = str.trim()).length() > 0) {
                    format = str;
                }
            }
            if (format == null) {
                format = MessageText.getString("label.table.default");
                this.custom_date_format = null;
            } else {
                try {
                    this.custom_date_format = new SimpleDateFormat(format);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            this.custom_date_menu.setText(MessageText.getString("label.date.format") + " <" + format + "> ...");
        }

        public SimpleDateFormat getDateFormat() {
            return this.custom_date_format;
        }
    }

    public static interface SpeedAdapter {
        public void setUpSpeed(int var1);

        public void setDownSpeed(int var1);
    }

    public static interface ViewTitleExtraInfo {
        public void update(Composite var1, int var2, int var3);

        public void setEnabled(Composite var1, boolean var2);
    }
}

