/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.welcome;

import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.ui.swt.BrowserWrapper;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class WelcomeWindow {
    private static final String lineSeparator = System.getProperty("line.separator");
    Display display;
    Shell shell;
    Color black;
    Color white;
    Color light;
    Color grey;
    Color green;
    Color blue;
    Color fg;
    Color bg;
    String sWhatsNew;
    Font monospace;
    private Composite cWhatsNew;
    private Label labelLoading;

    public WelcomeWindow(Shell parentShell) {
        try {
            this.init(parentShell);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void init(Shell parentShell) {
        this.shell = ShellFactory.createShell(parentShell, 2160);
        Utils.setShellIcon(this.shell);
        this.monospace = Constants.isOSX ? new Font((Device)this.shell.getDisplay(), "Courier", 12, 0) : new Font((Device)this.shell.getDisplay(), "Courier New", 8, 0);
        this.shell.setText(MessageText.getString("window.welcome.title", new String[]{"5.6.1.3_B05"}));
        this.display = this.shell.getDisplay();
        GridLayout layout = new GridLayout();
        this.shell.setLayout((Layout)layout);
        this.cWhatsNew = new Composite((Composite)this.shell, 2048);
        GridData data = new GridData(1808);
        this.cWhatsNew.setLayoutData((Object)data);
        this.cWhatsNew.setLayout((Layout)new FillLayout());
        Button bClose = new Button((Composite)this.shell, 8);
        bClose.setText(MessageText.getString("Button.close"));
        data = new GridData();
        data.widthHint = 70;
        data.horizontalAlignment = Constants.isOSX ? 0x1000000 : 131072;
        bClose.setLayoutData((Object)data);
        Listener closeListener = new Listener(){

            public void handleEvent(Event event2) {
                WelcomeWindow.this.close();
            }
        };
        bClose.addListener(13, closeListener);
        this.shell.addListener(21, closeListener);
        this.shell.setDefaultButton(bClose);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    WelcomeWindow.this.close();
                }
            }
        });
        this.shell.setSize(750, 500);
        Utils.centreWindow(this.shell);
        this.shell.layout();
        this.shell.open();
        this.pullWhatsNew(this.cWhatsNew);
    }

    private void pullWhatsNew(Composite cWhatsNew) {
        this.labelLoading = new Label(cWhatsNew, 0x1000000);
        this.labelLoading.setText(MessageText.getString("installPluginsWizard.details.loading"));
        this.shell.layout(true, true);
        this.shell.update();
        this.getWhatsNew(1);
    }

    public void setWhatsNew() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                WelcomeWindow.this._setWhatsNew();
            }
        });
    }

    public void _setWhatsNew() {
        if (this.sWhatsNew.indexOf("<html") >= 0 || this.sWhatsNew.indexOf("<HTML") >= 0) {
            BrowserWrapper browser = Utils.createSafeBrowser(this.cWhatsNew, 0);
            if (browser != null) {
                browser.setText(this.sWhatsNew);
            } else {
                try {
                    File tempFile = File.createTempFile("AZU", ".html");
                    tempFile.deleteOnExit();
                    FileUtil.writeBytesAsFile(tempFile.getAbsolutePath(), this.sWhatsNew.getBytes("utf8"));
                    Utils.launch(tempFile.getAbsolutePath());
                    this.shell.dispose();
                    return;
                }
                catch (IOException e) {}
            }
        } else {
            StyledText helpPanel = new StyledText(this.cWhatsNew, 768);
            helpPanel.setEditable(false);
            try {
                helpPanel.setRedraw(false);
                helpPanel.setWordWrap(false);
                helpPanel.setFont(this.monospace);
                this.black = ColorCache.getColor((Device)this.display, 0, 0, 0);
                this.white = ColorCache.getColor((Device)this.display, 255, 255, 255);
                this.light = ColorCache.getColor((Device)this.display, 200, 200, 200);
                this.grey = ColorCache.getColor((Device)this.display, 50, 50, 50);
                this.green = ColorCache.getColor((Device)this.display, 30, 80, 30);
                this.blue = ColorCache.getColor((Device)this.display, 20, 20, 80);
                helpPanel.setForeground(this.grey);
                String[] lines = this.sWhatsNew.split("\\r?\\n");
                for (int i = 0; i < lines.length; ++i) {
                    String text;
                    char styleChar;
                    String line = lines[i];
                    boolean setStyle = false;
                    this.fg = this.grey;
                    this.bg = this.white;
                    int style = 0;
                    if (line.length() < 2) {
                        styleChar = ' ';
                        text = " " + lineSeparator;
                    } else {
                        styleChar = line.charAt(0);
                        text = line.substring(1) + lineSeparator;
                    }
                    switch (styleChar) {
                        case '*': {
                            text = "  * " + text;
                            this.fg = this.green;
                            setStyle = true;
                            break;
                        }
                        case '+': {
                            text = "     " + text;
                            this.fg = this.black;
                            this.bg = this.light;
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case '!': {
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case '@': {
                            this.fg = this.blue;
                            setStyle = true;
                            break;
                        }
                        case '$': {
                            this.bg = this.blue;
                            this.fg = this.white;
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case ' ': {
                            text = "  " + text;
                            break;
                        }
                        default: {
                            text = styleChar + text;
                        }
                    }
                    helpPanel.append(text);
                    if (!setStyle) continue;
                    int lineCount = helpPanel.getLineCount() - 1;
                    int charCount = helpPanel.getCharCount();
                    int lineOfs = helpPanel.getOffsetAtLine(lineCount - 1);
                    int lineLen = charCount - lineOfs;
                    helpPanel.setStyleRange(new StyleRange(lineOfs, lineLen, this.fg, this.bg, style));
                    helpPanel.setLineBackground(lineCount - 1, 1, this.bg);
                }
                helpPanel.setRedraw(true);
            }
            catch (Exception e) {
                System.out.println("Unable to load help contents because:" + e);
            }
        }
        if (this.labelLoading != null && !this.labelLoading.isDisposed()) {
            this.labelLoading.dispose();
        }
        this.shell.layout(true, true);
    }

    private void getWhatsNew(final int phase) {
        String helpFile = null;
        if (phase == 1) {
            helpFile = MessageText.getString("window.welcome.file");
            if (!helpFile.toLowerCase().startsWith("http://plugins.vuze.com/")) {
                this.getWhatsNew(2);
                return;
            }
        } else {
            helpFile = MessageText.getString("window.welcome.file");
            InputStream stream = this.getClass().getResourceAsStream(helpFile);
            if (stream == null) {
                String helpFullPath = "/org/gudy/azureus2/internat/whatsnew/" + helpFile;
                stream = this.getClass().getResourceAsStream(helpFullPath);
            }
            if (stream == null) {
                stream = this.getClass().getResourceAsStream("/ChangeLog.txt");
            }
            if (stream == null) {
                this.sWhatsNew = "Welcome Window: Error loading resource: " + helpFile;
            } else {
                try {
                    this.sWhatsNew = FileUtil.readInputStreamAsString(stream, 65535, "utf8");
                    stream.close();
                }
                catch (IOException e) {
                    Debug.out(e);
                }
            }
            this.setWhatsNew();
            return;
        }
        final String url = helpFile;
        new AEThread2("getWhatsNew", true){

            public void run() {
                String s;
                ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
                try {
                    ResourceDownloader rd = rdf.create(new URL(url));
                    InputStream is = rd.download();
                    int length = is.available();
                    byte[] data = new byte[length];
                    is.read(data);
                    is.close();
                    s = new String(data);
                }
                catch (ResourceDownloaderException rde) {
                    s = "";
                }
                catch (Exception e) {
                    Debug.out(e);
                    s = "";
                }
                WelcomeWindow.this.sWhatsNew = s;
                if (WelcomeWindow.this.sWhatsNew == null || WelcomeWindow.this.sWhatsNew.length() == 0) {
                    WelcomeWindow.this.getWhatsNew(phase + 1);
                    return;
                }
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (WelcomeWindow.this.cWhatsNew != null && !WelcomeWindow.this.cWhatsNew.isDisposed()) {
                            WelcomeWindow.this.setWhatsNew();
                        }
                    }
                });
            }
        }.start();
    }

    private void close() {
        this.monospace.dispose();
        this.shell.dispose();
    }

    public static void main(String[] args) {
        System.out.println(Locale.getDefault().getCountry());
        new WelcomeWindow(null);
        Display display = Display.getDefault();
        while (true) {
            if (display.readAndDispatch()) {
                continue;
            }
            display.sleep();
        }
    }
}

