/*
 * Decompiled with CFR 0.152.
 */
package org.json.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.json.simple.ItemList;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONArray
extends ArrayList<Object> {
    public JSONArray() {
    }

    public JSONArray(Collection<Object> arg0) {
        super(arg0);
    }

    public JSONArray(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public String toString() {
        ItemList list = new ItemList();
        for (Object value : this) {
            if (value instanceof String) {
                list.add("\"" + JSONObject.escape((String)value) + "\"");
                continue;
            }
            list.add(String.valueOf(value));
        }
        return "[" + list.toString() + "]";
    }

    public void toString(StringBuilder sb) {
        sb.append("[");
        Iterator iter = this.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            Object value = iter.next();
            if (value instanceof String) {
                sb.append("\"");
                JSONObject.escape(sb, (String)value);
                sb.append("\"");
                continue;
            }
            if (value instanceof JSONObject) {
                ((JSONObject)value).toString(sb);
                continue;
            }
            if (value instanceof JSONArray) {
                ((JSONArray)value).toString(sb);
                continue;
            }
            sb.append(String.valueOf(value));
        }
        sb.append("]");
    }
}

