/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.content.ContentException;
import com.aelitis.azureus.core.content.RelatedAttributeLookupListener;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.content.RelatedContentLookupListener;
import com.aelitis.azureus.core.content.RelatedContentManagerListener;
import com.aelitis.azureus.core.content.RelatedContentSearcher;
import com.aelitis.azureus.core.proxy.impl.AEPluginProxyHandler;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginInterface;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedContentManager {
    public static final long FILE_ASSOC_MIN_SIZE = 0x3200000L;
    public static final int RCM_SEARCH_PROPERTY_CONTENT_NETWORK = 50000;
    public static final int RCM_SEARCH_PROPERTY_TRACKER_KEYS = 50001;
    public static final int RCM_SEARCH_PROPERTY_WEB_SEED_KEYS = 50002;
    public static final int RCM_SEARCH_PROPERTY_TAGS = 50003;
    public static final int RCM_SEARCH_PROPERTY_NETWORKS = 50004;
    private static final boolean TRACE = false;
    private static final int MAX_HISTORY = 16;
    private static final int MAX_TITLE_LENGTH = 80;
    private static final int MAX_CONCURRENT_PUBLISH = 2;
    private static final int TEMPORARY_SPACE_DELTA = 50;
    private static final int MAX_RANK = 100;
    private static final String CONFIG_FILE = "rcm.config";
    private static final String PERSIST_DEL_FILE = "rcmx.config";
    private static final String CONFIG_TOTAL_UNREAD = "rcm.numunread.cache";
    private static RelatedContentManager singleton;
    private static AzureusCore core;
    protected static final int TIMER_PERIOD = 30000;
    private static final int CONFIG_SAVE_CHECK_PERIOD = 60000;
    private static final int CONFIG_SAVE_PERIOD = 300000;
    private static final int CONFIG_SAVE_CHECK_TICKS = 2;
    private static final int CONFIG_SAVE_TICKS = 10;
    private static final int PUBLISH_CHECK_PERIOD = 30000;
    private static final int PUBLISH_CHECK_TICKS = 1;
    private static final int PUBLISH_SLEEPING_CHECK_PERIOD = 300000;
    private static final int PUBLISH_SLEEPING_CHECK_TICKS = 10;
    private static final int SECONDARY_LOOKUP_PERIOD = 900000;
    private static final int SECONDARY_LOOKUP_TICKS = 30;
    private static final int REPUBLISH_PERIOD = 28800000;
    private static final int REPUBLISH_TICKS = 960;
    private static final int I2P_SEARCHER_CHECK_PERIOD = 600000;
    private static final int I2P_SEARCHER_CHECK_TICKS = 20;
    private static final int INITIAL_PUBLISH_DELAY = 180000;
    private static final int INITIAL_PUBLISH_TICKS = 6;
    private static final int CONFIG_DISCARD_MILLIS = 60000;
    protected static final byte NET_NONE = 0;
    protected static final byte NET_PUBLIC = 1;
    protected static final byte NET_I2P = 2;
    protected static final byte NET_TOR = 4;
    private static final String[] NET_PUBLIC_ARRAY;
    private static final String[] NET_I2P_ARRAY;
    private static final String[] NET_TOR_ARRAY;
    private static final String[] NET_PUBLIC_AND_I2P_ARRAY;
    protected final Object rcm_lock = new Object();
    private PluginInterface plugin_interface;
    private TorrentAttribute ta_networks;
    private TorrentAttribute ta_category;
    private DHTPluginInterface public_dht_plugin;
    private volatile Map<Byte, DHTPluginInterface> i2p_dht_plugin_map = new HashMap<Byte, DHTPluginInterface>();
    private TagManager tag_manager;
    private long global_random_id = -1L;
    private LinkedList<DownloadInfo> pub_download_infos1 = new LinkedList();
    private LinkedList<DownloadInfo> pub_download_infos2 = new LinkedList();
    private LinkedList<DownloadInfo> non_pub_download_infos1 = new LinkedList();
    private LinkedList<DownloadInfo> non_pub_download_infos2 = new LinkedList();
    private ByteArrayHashMapEx<DownloadInfo> download_info_map = new ByteArrayHashMapEx();
    private Set<String> download_priv_set = new HashSet<String>();
    private final boolean enabled;
    private int max_search_level;
    private int max_results;
    private AtomicInteger temporary_space = new AtomicInteger();
    private int publishing_count = 0;
    private CopyOnWriteList<RelatedContentManagerListener> listeners = new CopyOnWriteList();
    private AESemaphore initialisation_complete_sem = new AESemaphore("RCM:init");
    private ContentCache content_cache_ref;
    private WeakReference<ContentCache> content_cache;
    private boolean content_dirty;
    private long last_config_access;
    private int content_discard_ticks;
    private AtomicInteger total_unread = new AtomicInteger(COConfigurationManager.getIntParameter("rcm.numunread.cache", 0));
    private AsyncDispatcher content_change_dispatcher = new AsyncDispatcher();
    private static final int SECONDARY_LOOKUP_CACHE_MAX = 10;
    private LinkedList<SecondaryLookup> secondary_lookups = new LinkedList();
    private boolean secondary_lookup_in_progress;
    private long secondary_lookup_complete_time;
    private RCMSearchXFer transfer_type = new RCMSearchXFer();
    private final CopyOnWriteList<RelatedContentSearcher> searchers = new CopyOnWriteList();
    private boolean added_i2p_searcher;
    private static final int MAX_TRANSIENT_CACHE = 256;
    protected static Map<String, DownloadInfo> transient_info_cache;
    private boolean persist;
    private boolean last_pub_was_pub;
    private static final int MAX_TAGS = 3;
    private static final int MAX_TAG_LENGTH = 20;
    private static final int PD_BLOOM_INITIAL_SIZE = 1000;
    private static final int PD_BLOOM_INCREMENT_SIZE = 1000;
    private BloomFilter persist_del_bloom;

    public static synchronized void preInitialise(AzureusCore _core) {
        core = _core;
    }

    public static synchronized RelatedContentManager getSingleton() throws ContentException {
        if (singleton == null) {
            singleton = new RelatedContentManager();
        }
        return singleton;
    }

    protected RelatedContentManager() throws ContentException {
        COConfigurationManager.addAndFireParameterListener("rcm.persist", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                if (!COConfigurationManager.getBooleanParameter("rcm.persist")) {
                    // empty if block
                }
                RelatedContentManager.this.persist = true;
            }
        });
        COConfigurationManager.removeParameter("rcm.dlinfo.history");
        COConfigurationManager.addAndFireParameterListeners(new String[]{"rcm.ui.enabled", "rcm.max_search_level", "rcm.max_results"}, new ParameterListener(){

            public void parameterChanged(String name) {
                RelatedContentManager.this.max_search_level = COConfigurationManager.getIntParameter("rcm.max_search_level", 3);
                RelatedContentManager.this.max_results = COConfigurationManager.getIntParameter("rcm.max_results", 500);
            }
        });
        if (!FeatureAvailability.isRCMEnabled() || !COConfigurationManager.getBooleanParameter("rcm.overall.enabled", true)) {
            this.enabled = false;
            this.deleteRelatedContent();
            this.initialisation_complete_sem.releaseForever();
            return;
        }
        this.enabled = true;
        try {
            if (core == null) {
                throw new ContentException("getSingleton called before pre-initialisation");
            }
            while (this.global_random_id == -1L) {
                this.global_random_id = COConfigurationManager.getLongParameter("rcm.random.id", -1L);
                if (this.global_random_id != -1L) continue;
                this.global_random_id = RandomUtils.nextLong();
                COConfigurationManager.setParameter("rcm.random.id", this.global_random_id);
            }
            this.plugin_interface = core.getPluginManager().getDefaultPluginInterface();
            this.ta_networks = this.plugin_interface.getTorrentManager().getAttribute("Networks");
            this.ta_category = this.plugin_interface.getTorrentManager().getAttribute("Category");
            this.tag_manager = TagManagerFactory.getTagManager();
            this.plugin_interface.getUtilities().createDelayedTask(new AERunnable(){

                public void runSupport() {
                    SimpleTimer.addEvent("rcm.delay.init", SystemTime.getOffsetTime(15000L), new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            RelatedContentManager.this.delayedInit();
                        }
                    });
                }
            }).queue();
        }
        catch (Throwable e) {
            this.initialisation_complete_sem.releaseForever();
            if (e instanceof ContentException) {
                throw (ContentException)e;
            }
            throw new ContentException("Initialisation failed", e);
        }
    }

    protected PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    private void delayedInit() {
        this.plugin_interface.addListener(new PluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void initializationComplete() {
                if (!RelatedContentManager.this.persist) {
                    RelatedContentManager.this.deleteRelatedContent();
                }
                try {
                    PluginInterface dht_pi = RelatedContentManager.this.plugin_interface.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                    if (dht_pi != null) {
                        DHTPlugin dp = (DHTPlugin)dht_pi.getPlugin();
                        RelatedContentManager.this.public_dht_plugin = dp;
                        RelatedContentSearcher public_searcher = new RelatedContentSearcher(RelatedContentManager.this, RelatedContentManager.this.transfer_type, dp, true);
                        RelatedContentManager.this.searchers.add(public_searcher);
                        DownloadManager dm = RelatedContentManager.this.plugin_interface.getDownloadManager();
                        Download[] downloads = dm.getDownloads();
                        RelatedContentManager.this.addDownloads(downloads, true);
                        dm.addListener(new DownloadManagerListener(){

                            public void downloadAdded(Download download) {
                                RelatedContentManager.this.addDownloads(new Download[]{download}, false);
                            }

                            public void downloadRemoved(Download download) {
                            }
                        }, false);
                        SimpleTimer.addPeriodicEvent("RCM:publisher", 30000L, new TimerEventPerformer(){
                            private int tick_count;

                            public void perform(TimerEvent event2) {
                                ++this.tick_count;
                                if (this.tick_count == 1 || this.tick_count % 20 == 0) {
                                    RelatedContentManager.this.checkI2PSearcher(false);
                                }
                                if (RelatedContentManager.this.enabled && this.tick_count >= 6) {
                                    if (this.tick_count % (RelatedContentManager.this.public_dht_plugin.isSleeping() ? 10 : 1) == 0) {
                                        RelatedContentManager.this.publish();
                                    }
                                    if (this.tick_count % 30 == 0) {
                                        RelatedContentManager.this.secondaryLookup();
                                    }
                                    if (this.tick_count % 960 == 0) {
                                        RelatedContentManager.this.republish();
                                    }
                                    if (this.tick_count % 2 == 0) {
                                        RelatedContentManager.this.saveRelatedContent(this.tick_count);
                                    }
                                }
                                for (RelatedContentSearcher searcher : RelatedContentManager.this.searchers) {
                                    searcher.timerTick(RelatedContentManager.this.enabled, this.tick_count);
                                }
                            }
                        });
                    }
                    Object var7_6 = null;
                    RelatedContentManager.this.initialisation_complete_sem.releaseForever();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    RelatedContentManager.this.initialisation_complete_sem.releaseForever();
                    throw throwable;
                }
            }

            public void closedownInitiated() {
                RelatedContentManager.this.saveRelatedContent(0);
            }

            public void closedownComplete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkI2PSearcher(boolean force) {
        CopyOnWriteList<RelatedContentSearcher> copyOnWriteList = this.searchers;
        synchronized (copyOnWriteList) {
            if (this.added_i2p_searcher) {
                return;
            }
            if (!force) {
                DownloadManager dm = this.plugin_interface.getDownloadManager();
                Download[] downloads = dm.getDownloads();
                boolean found = false;
                for (Download download : downloads) {
                    String[] nets = PluginCoreUtils.unwrap(download).getDownloadState().getNetworks();
                    if (nets.length != 1 || nets[0] != "I2P") continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return;
                }
            }
            List<DistributedDatabase> ddbs = DDBaseImpl.getDDBs(new String[]{"I2P"});
            for (DistributedDatabase ddb : ddbs) {
                if (ddb.getNetwork() != "I2P") continue;
                DHTPluginInterface i2p_dht = ((DDBaseImpl)ddb).getDHTPlugin();
                RelatedContentSearcher i2p_searcher = new RelatedContentSearcher(this, this.transfer_type, i2p_dht, false);
                this.searchers.add(i2p_searcher);
                this.added_i2p_searcher = true;
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxSearchLevel() {
        return this.max_search_level;
    }

    public void setMaxSearchLevel(int _level) {
        COConfigurationManager.setParameter("rcm.max_search_level", _level);
    }

    public int getMaxResults() {
        return this.max_results;
    }

    public void setMaxResults(int _max) {
        COConfigurationManager.setParameter("rcm.max_results", _max);
        this.enforceMaxResults(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHTPluginInterface selectDHT(byte networks) {
        DHTPluginInterface result = null;
        if ((networks & 1) != 0) {
            result = this.public_dht_plugin;
        } else if ((networks & 2) != 0) {
            Map<Byte, DHTPluginInterface> map = this.i2p_dht_plugin_map;
            synchronized (map) {
                result = this.i2p_dht_plugin_map.get(networks);
                if (result == null && !this.i2p_dht_plugin_map.containsKey(networks)) {
                    try {
                        List<DistributedDatabase> ddbs = DDBaseImpl.getDDBs(RelatedContentManager.convertNetworks(networks));
                        for (DistributedDatabase ddb : ddbs) {
                            if (ddb.getNetwork() != "I2P") continue;
                            result = ((DDBaseImpl)ddb).getDHTPlugin();
                        }
                        Object var8_7 = null;
                        this.i2p_dht_plugin_map.put(networks, result);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.i2p_dht_plugin_map.put(networks, result);
                        throw throwable;
                    }
                    {
                    }
                }
            }
        }
        if (result != null && !result.isEnabled()) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDownloads(Download[] downloads, boolean initialising) {
        Object object = this.rcm_lock;
        synchronized (object) {
            ArrayList<DownloadInfo> new_info = new ArrayList<DownloadInfo>(downloads.length);
            for (Download download : downloads) {
                try {
                    int seeds_leechers;
                    LinkedList<DownloadInfo> download_infos2;
                    LinkedList<DownloadInfo> download_infos1;
                    DownloadManagerState state;
                    TOTorrent to_torrent;
                    byte nets;
                    byte[] hash;
                    Torrent torrent;
                    if (!download.isPersistent() || (torrent = download.getTorrent()) == null || this.download_info_map.containsKey(hash = torrent.getHash()) || (nets = this.getNetworks(download)) == 0 || TorrentUtils.isReallyPrivate(to_torrent = PluginCoreUtils.unwrap(torrent)) || (state = PluginCoreUtils.unwrap(download).getDownloadState()).getFlag(16L)) continue;
                    if ((nets & 1) != 0) {
                        download_infos1 = this.pub_download_infos1;
                        download_infos2 = this.pub_download_infos2;
                    } else {
                        download_infos1 = this.non_pub_download_infos1;
                        download_infos2 = this.non_pub_download_infos2;
                    }
                    long rand = this.global_random_id ^ state.getLongParameter("rand");
                    long cache = state.getLongAttribute("scrapecache");
                    if (cache == -1L) {
                        seeds_leechers = -1;
                    } else {
                        int seeds = (int)(cache >> 32 & 0xFFFFFFL);
                        int leechers = (int)(cache & 0xFFFFFFL);
                        seeds_leechers = seeds << 16 | leechers & 0xFFFF;
                    }
                    byte[][] keys = this.getKeys(download);
                    DownloadInfo info = new DownloadInfo(hash, hash, download.getName(), (int)rand, torrent.isPrivate() ? StringInterner.intern(torrent.getAnnounceURL().getHost()) : null, keys[0], keys[1], this.getTags(download), nets, 0, false, torrent.getSize(), (int)(to_torrent.getCreationDate() / 3600L), seeds_leechers, (byte)PlatformTorrentUtils.getContentNetworkID(to_torrent));
                    new_info.add(info);
                    if (initialising || download_infos1.size() == 0) {
                        download_infos1.add(info);
                    } else {
                        download_infos1.add(RandomUtils.nextInt(download_infos1.size()), info);
                    }
                    download_infos2.add(info);
                    this.download_info_map.put(hash, info);
                    if (info.getTracker() == null) continue;
                    this.download_priv_set.add(this.getPrivateInfoKey(info));
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            List history = COConfigurationManager.getListParameter("rcm.dlinfo.history.privx", new ArrayList());
            if (initialising) {
                int padd = 16 - this.download_info_map.size();
                for (int i = 0; i < history.size() && padd > 0; ++i) {
                    try {
                        DownloadInfo info = this.deserialiseDI((Map)history.get(i), null);
                        if (info == null || this.download_info_map.containsKey(info.getHash())) continue;
                        this.download_info_map.put(info.getHash(), info);
                        if (info.getTracker() != null) {
                            this.download_priv_set.add(this.getPrivateInfoKey(info));
                        }
                        if ((info.getNetworksInternal() & 1) != 0) {
                            this.pub_download_infos1.add(info);
                            this.pub_download_infos2.add(info);
                        } else {
                            this.non_pub_download_infos1.add(info);
                            this.non_pub_download_infos2.add(info);
                        }
                        --padd;
                        continue;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                Collections.shuffle(this.pub_download_infos1);
                Collections.shuffle(this.non_pub_download_infos1);
            } else if (new_info.size() > 0) {
                final ArrayList<String> base32_hashes = new ArrayList<String>();
                for (DownloadInfo info : new_info) {
                    Map<String, Object> map;
                    byte[] hash = info.getHash();
                    if (hash != null) {
                        base32_hashes.add(Base32.encode(hash));
                    }
                    if ((map = this.serialiseDI(info, null)) == null) continue;
                    history.add(map);
                }
                while (history.size() > 16) {
                    history.remove(0);
                }
                COConfigurationManager.setParameter("rcm.dlinfo.history.privx", history);
                if (base32_hashes.size() > 0) {
                    this.content_change_dispatcher.dispatch(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            ArrayList<DownloadInfo> to_remove = new ArrayList<DownloadInfo>();
                            Object object = RelatedContentManager.this.rcm_lock;
                            synchronized (object) {
                                ContentCache content_cache = RelatedContentManager.this.loadRelatedContent();
                                for (String h : base32_hashes) {
                                    DownloadInfo di = content_cache.related_content.get(h);
                                    if (di == null) continue;
                                    to_remove.add(di);
                                }
                            }
                            if (to_remove.size() > 0) {
                                RelatedContentManager.this.delete(to_remove.toArray(new RelatedContent[to_remove.size()]));
                            }
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void republish() {
        Object object = this.rcm_lock;
        synchronized (object) {
            List list;
            if (this.publishing_count > 0) {
                return;
            }
            if (this.pub_download_infos1.isEmpty()) {
                list = this.download_info_map.values();
                for (DownloadInfo info : list) {
                    if ((info.getNetworksInternal() & 1) == 0) continue;
                    this.pub_download_infos1.add(info);
                    this.pub_download_infos2.add(info);
                }
                Collections.shuffle(this.pub_download_infos1);
            }
            if (this.non_pub_download_infos1.isEmpty()) {
                list = this.download_info_map.values();
                for (DownloadInfo info : list) {
                    if ((info.getNetworksInternal() & 1) != 0) continue;
                    this.non_pub_download_infos1.add(info);
                    this.non_pub_download_infos2.add(info);
                }
                Collections.shuffle(this.non_pub_download_infos1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish() {
        while (true) {
            DownloadInfo info1 = null;
            DownloadInfo info2 = null;
            Object object = this.rcm_lock;
            synchronized (object) {
                LinkedList<DownloadInfo> download_infos2;
                LinkedList<DownloadInfo> download_infos1;
                if (this.publishing_count >= 2) {
                    return;
                }
                if (this.download_info_map.size() == 1) {
                    return;
                }
                boolean pub_ok = false;
                if (!(this.pub_download_infos1.isEmpty() || this.pub_download_infos1.size() == 1 && this.pub_download_infos1.getFirst() == this.pub_download_infos2.getFirst())) {
                    pub_ok = true;
                }
                boolean non_pub_ok = false;
                if (!(this.non_pub_download_infos1.isEmpty() || this.non_pub_download_infos1.size() == 1 && this.non_pub_download_infos1.getFirst() == this.non_pub_download_infos2.getFirst())) {
                    non_pub_ok = true;
                }
                if (!pub_ok && !non_pub_ok) {
                    return;
                }
                if (pub_ok && non_pub_ok) {
                    if (this.last_pub_was_pub) {
                        pub_ok = false;
                    }
                    boolean bl = this.last_pub_was_pub = !this.last_pub_was_pub;
                }
                if (pub_ok) {
                    download_infos1 = this.pub_download_infos1;
                    download_infos2 = this.pub_download_infos2;
                } else {
                    download_infos1 = this.non_pub_download_infos1;
                    download_infos2 = this.non_pub_download_infos2;
                }
                if (download_infos1.isEmpty() || this.download_info_map.size() == 1) {
                    return;
                }
                info1 = download_infos1.removeFirst();
                Iterator it = download_infos2.iterator();
                while (it.hasNext()) {
                    info2 = (DownloadInfo)it.next();
                    if (info1 == info2 && download_infos2.size() != 1) continue;
                    it.remove();
                    break;
                }
                if (info1 == info2) {
                    return;
                }
                ++this.publishing_count;
            }
            try {
                if (this.publish(info1, info2)) continue;
                object = this.rcm_lock;
                synchronized (object) {
                    --this.publishing_count;
                    continue;
                }
            }
            catch (Throwable e) {
                Object object2 = this.rcm_lock;
                synchronized (object2) {
                    --this.publishing_count;
                }
                Debug.out(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishNext() {
        Object object = this.rcm_lock;
        synchronized (object) {
            --this.publishing_count;
            if (this.publishing_count < 0) {
                this.publishing_count = 0;
            }
        }
        this.publish();
    }

    protected boolean publish(final DownloadInfo from_info, final DownloadInfo to_info) throws Exception {
        long size;
        final DHTPluginInterface dht_plugin = this.selectDHT(from_info.getNetworksInternal());
        if (dht_plugin == null) {
            return false;
        }
        final String from_hash = ByteFormatter.encodeString(from_info.getHash());
        final String to_hash = ByteFormatter.encodeString(to_info.getHash());
        final byte[] key_bytes = ("az:rcm:assoc:" + from_hash).getBytes("UTF-8");
        String title = to_info.getTitle();
        if (title.length() > 80) {
            title = title.substring(0, 80);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("d", title);
        map.put("r", new Long(Math.abs(to_info.getRand() % 1000)));
        String tracker = to_info.getTracker();
        if (tracker == null) {
            map.put("h", to_info.getHash());
        } else {
            map.put("t", tracker);
        }
        if (to_info.getLevel() == 0) {
            try {
                Download d = to_info.getRelatedToDownload();
                if (d != null) {
                    byte nets;
                    String[] _tags;
                    byte[][] keys;
                    Torrent torrent = d.getTorrent();
                    if (torrent != null) {
                        long secs;
                        long hours;
                        long cnet = PlatformTorrentUtils.getContentNetworkID(PluginCoreUtils.unwrap(torrent));
                        if (cnet != -1L) {
                            map.put("c", new Long(cnet));
                        }
                        if ((hours = (secs = torrent.getCreationDate()) / 3600L) > 0L) {
                            map.put("p", new Long(hours));
                        }
                    }
                    int leechers = -1;
                    int seeds = -1;
                    long cache = PluginCoreUtils.unwrap(d).getDownloadState().getLongAttribute("scrapecache");
                    if (cache != -1L) {
                        seeds = (int)(cache >> 32 & 0xFFFFFFL);
                        leechers = (int)(cache & 0xFFFFFFL);
                    }
                    if (leechers > 0) {
                        map.put("l", new Long(leechers));
                    }
                    if (seeds > 0) {
                        map.put("z", new Long(seeds));
                    }
                    if ((keys = this.getKeys(d))[0] != null) {
                        map.put("k", keys[0]);
                    }
                    if (keys[1] != null) {
                        map.put("w", keys[1]);
                    }
                    if ((_tags = this.getTags(d)) != null) {
                        map.put("g", this.encodeTags(_tags));
                    }
                    if ((nets = this.getNetworks(d)) != 1) {
                        map.put("o", new Long(nets & 0xFF));
                    }
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        final HashSet<String> my_tags = new HashSet<String>();
        try {
            String[] _tags;
            Download d = from_info.getRelatedToDownload();
            if (d != null && (_tags = this.getTags(d)) != null) {
                map.put("b", from_info.getRand() % 100);
                map.put("m", this.encodeTags(_tags));
                for (String tag : _tags) {
                    my_tags.add(tag);
                }
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if ((size = to_info.getSize()) != 0L) {
            map.put("s", new Long(size));
        }
        final byte[] map_bytes = BEncoder.encode(map);
        int max_hits = 30;
        dht_plugin.get(key_bytes, "Content rel test: " + from_hash.substring(0, 16), (byte)0, 30, 30000L, false, false, new DHTPluginOperationListener(){
            private boolean diversified;
            private int hits;
            private Set<String> entries = new HashSet<String>();

            public void starts(byte[] key) {
            }

            public boolean diversified() {
                this.diversified = true;
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                try {
                    Map<String, Object> map = BDecoder.decode(value.getValue());
                    DownloadInfo info = RelatedContentManager.this.decodeInfo(map, from_info.getHash(), 1, false, this.entries);
                    try {
                        Long b;
                        String[] r_tags = RelatedContentManager.this.decodeTags((byte[])map.get("m"));
                        if (r_tags != null && ((b = (Long)map.get("b")) == null || (long)(from_info.getRand() % 100) != b % 100L)) {
                            for (String tag : r_tags) {
                                Set set = my_tags;
                                synchronized (set) {
                                    my_tags.remove(tag);
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (info != null) {
                        RelatedContentManager.this.analyseResponse(info, null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++this.hits;
            }

            public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete(byte[] key, boolean timeout_occurred) {
                int f_cutoff = my_tags.size() > 0 ? 20 : 10;
                try {
                    boolean do_it;
                    if (this.diversified || this.hits >= f_cutoff) {
                        do_it = false;
                    } else if (this.hits <= f_cutoff / 2) {
                        do_it = true;
                    } else {
                        boolean bl = do_it = RandomUtils.nextInt(this.hits - f_cutoff / 2 + 1) == 0;
                    }
                    if (do_it) {
                        try {
                            dht_plugin.put(key_bytes, "Content rel: " + from_hash.substring(0, 16) + " -> " + to_hash.substring(0, 16), map_bytes, (byte)16, new DHTPluginOperationListener(){

                                public boolean diversified() {
                                    return true;
                                }

                                public void starts(byte[] key) {
                                }

                                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                                }

                                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                                }

                                public void complete(byte[] key, boolean timeout_occurred) {
                                    RelatedContentManager.this.publishNext();
                                }
                            });
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            RelatedContentManager.this.publishNext();
                        }
                    } else {
                        RelatedContentManager.this.publishNext();
                    }
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    RelatedContentManager.this.checkAlternativePubs(to_info, map_bytes, f_cutoff);
                    throw throwable;
                }
                RelatedContentManager.this.checkAlternativePubs(to_info, map_bytes, f_cutoff);
            }
        });
        return true;
    }

    private void checkAlternativePubs(DownloadInfo to_info, final byte[] map_bytes, final int f_cutoff) {
        Download dl = to_info.getRelatedToDownload();
        if (dl != null) {
            DiskManagerFileInfo[] files = dl.getDiskManagerFileInfo();
            ArrayList<Long> sizes = new ArrayList<Long>();
            for (DiskManagerFileInfo file : files) {
                long size = file.getLength();
                if (size < 0x3200000L) continue;
                sizes.add(size);
            }
            final DHTPluginInterface dht_plugin = this.selectDHT(to_info.getNetworksInternal());
            if (dht_plugin != null && sizes.size() > 0) {
                try {
                    final String to_hash = ByteFormatter.encodeString(to_info.getHash());
                    final long selected_size = (Long)sizes.get(new Random().nextInt(sizes.size()));
                    final byte[] key_bytes = ("az:rcm:size:assoc:" + selected_size).getBytes("UTF-8");
                    int max_hits = 30;
                    dht_plugin.get(key_bytes, "Content size rel test: " + to_hash.substring(0, 16), (byte)0, max_hits, 30000L, false, false, new DHTPluginOperationListener(){
                        private boolean diversified;
                        private int hits;
                        private Set<String> entries = new HashSet<String>();

                        public void starts(byte[] key) {
                        }

                        public boolean diversified() {
                            this.diversified = true;
                            return false;
                        }

                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                            ++this.hits;
                        }

                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                        }

                        public void complete(byte[] key, boolean timeout_occurred) {
                            boolean do_it;
                            if (this.diversified || this.hits >= f_cutoff) {
                                do_it = false;
                            } else if (this.hits <= f_cutoff / 2) {
                                do_it = true;
                            } else {
                                boolean bl = do_it = RandomUtils.nextInt(this.hits - f_cutoff / 2 + 1) == 0;
                            }
                            if (do_it) {
                                try {
                                    dht_plugin.put(key_bytes, "Content size rel: " + selected_size + " -> " + to_hash.substring(0, 16), map_bytes, (byte)16, new DHTPluginOperationListener(){

                                        public boolean diversified() {
                                            return true;
                                        }

                                        public void starts(byte[] key) {
                                        }

                                        public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                                        }

                                        public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                                        }

                                        public void complete(byte[] key, boolean timeout_occurred) {
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadInfo decodeInfo(Map map, byte[] from_hash, int level, boolean explicit, Set<String> unique_keys) {
        try {
            String title = new String((byte[])map.get("d"), "UTF-8");
            String tracker = null;
            byte[] hash = (byte[])map.get("h");
            if (hash == null) {
                tracker = new String((byte[])map.get("t"), "UTF-8");
            }
            int rand = ((Long)map.get("r")).intValue();
            String key = title + " % " + rand;
            Set<String> set = unique_keys;
            synchronized (set) {
                if (unique_keys.contains(key)) {
                    return null;
                }
                unique_keys.add(key);
            }
            Long l_size = (Long)map.get("s");
            long size = l_size == null ? 0L : l_size;
            Long cnet = (Long)map.get("c");
            Long published = (Long)map.get("p");
            Long leechers = (Long)map.get("l");
            Long seeds = (Long)map.get("z");
            int seeds_leechers = leechers == null && seeds == null ? -1 : (leechers == null ? seeds.intValue() << 16 : (seeds == null ? leechers.intValue() & 0xFFFF : seeds.intValue() << 16 | leechers.intValue() & 0xFFFF));
            byte[] tracker_keys = (byte[])map.get("k");
            byte[] ws_keys = (byte[])map.get("w");
            if (tracker_keys != null && tracker_keys.length % 4 != 0) {
                tracker_keys = null;
            }
            if (ws_keys != null && ws_keys.length % 4 != 0) {
                ws_keys = null;
            }
            byte[] _tags = (byte[])map.get("g");
            String[] tags = this.decodeTags(_tags);
            Long _nets = (Long)map.get("o");
            byte nets = _nets == null ? (byte)1 : _nets.byteValue();
            return new DownloadInfo(from_hash, hash, title, rand, tracker, tracker_keys, ws_keys, tags, nets, level, explicit, size, published == null ? 0 : published.intValue(), seeds_leechers, (byte)(cnet == null ? -1L : (long)cnet.byteValue()));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void lookupAttributes(byte[] from_hash, RelatedAttributeLookupListener listener) throws ContentException {
        this.lookupAttributes(from_hash, new String[]{"Public"}, listener);
    }

    public void lookupAttributes(final byte[] from_hash, final String[] networks, final RelatedAttributeLookupListener listener) throws ContentException {
        if (from_hash == null) {
            throw new ContentException("hash is null");
        }
        if (!this.initialisation_complete_sem.isReleasedForever() || this.public_dht_plugin != null && this.public_dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupAttributesSupport(from_hash, RelatedContentManager.convertNetworks(networks), listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupAttributesSupport(from_hash, RelatedContentManager.convertNetworks(networks), listener);
        }
    }

    private void lookupAttributesSupport(final byte[] from_hash, byte networks, final RelatedAttributeLookupListener listener) throws ContentException {
        try {
            if (!this.enabled) {
                throw new ContentException("rcm is disabled");
            }
            DHTPluginInterface dht_plugin = this.selectDHT(networks);
            if (dht_plugin == null) {
                throw new Exception("DHT Plugin unavailable for networks " + this.getString(RelatedContentManager.convertNetworks(networks)));
            }
            final String dht_plugin_network = dht_plugin == this.public_dht_plugin ? "Public" : "I2P";
            String from_hash_str = ByteFormatter.encodeString(from_hash);
            byte[] key_bytes = ("az:rcm:assoc:" + from_hash_str).getBytes("UTF-8");
            String op_str = "Content attr read: " + from_hash_str.substring(0, 16);
            dht_plugin.get(key_bytes, op_str, (byte)0, 512, 30000L, false, true, new DHTPluginOperationListener(){
                private Set<String> tags = new HashSet<String>();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void starts(byte[] key) {
                    if (listener != null) {
                        String[] l_tags;
                        try {
                            listener.lookupStart();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        ContentCache content_cache = RelatedContentManager.this.loadRelatedContent();
                        DownloadInfo info = content_cache.related_content.get(Base32.encode(from_hash));
                        if (info != null && (l_tags = info.getTags()) != null) {
                            for (String tag : l_tags) {
                                Set<String> set = this.tags;
                                synchronized (set) {
                                    if (this.tags.contains(tag)) {
                                        continue;
                                    }
                                    this.tags.add(tag);
                                }
                                try {
                                    listener.tagFound(tag, dht_plugin_network);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    }
                }

                public boolean diversified() {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    block9: {
                        try {
                            Map<String, Object> map = BDecoder.decode(value.getValue());
                            String[] r_tags = RelatedContentManager.this.decodeTags((byte[])map.get("m"));
                            if (r_tags == null) break block9;
                            for (String tag : r_tags) {
                                Set<String> set = this.tags;
                                synchronized (set) {
                                    if (this.tags.contains(tag)) {
                                        continue;
                                    }
                                    this.tags.add(tag);
                                }
                                try {
                                    listener.tagFound(tag, dht_plugin_network);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                public void complete(byte[] key, boolean timeout_occurred) {
                    if (listener != null) {
                        try {
                            listener.lookupComplete();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            ContentException ce = e instanceof ContentException ? (ContentException)e : new ContentException("Lookup failed", e);
            if (listener != null) {
                try {
                    listener.lookupFailed(ce);
                }
                catch (Throwable f) {
                    Debug.out(f);
                }
            }
            throw ce;
        }
    }

    public void lookupContent(final byte[] hash, final RelatedContentLookupListener listener) throws ContentException {
        if (hash == null) {
            throw new ContentException("hash is null");
        }
        byte net = 1;
        try {
            Download download = this.plugin_interface.getDownloadManager().getDownload(hash);
            if (download != null) {
                net = this.getNetworks(download);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        final byte f_net = net;
        if (!this.initialisation_complete_sem.isReleasedForever() || this.public_dht_plugin != null && this.public_dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(hash, 0, f_net, true, listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupContentSupport(hash, 0, f_net, true, listener);
        }
    }

    public void lookupContent(final byte[] hash, String[] networks, final RelatedContentLookupListener listener) throws ContentException {
        if (hash == null) {
            throw new ContentException("hash is null");
        }
        final byte net = RelatedContentManager.convertNetworks(networks);
        if (net == 0) {
            throw new ContentException("No networks specified");
        }
        if (!this.initialisation_complete_sem.isReleasedForever() || this.public_dht_plugin != null && this.public_dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(hash, 0, net, true, listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupContentSupport(hash, 0, net, true, listener);
        }
    }

    public void lookupContent(final long file_size, final RelatedContentLookupListener listener) throws ContentException {
        if (file_size < 0x3200000L) {
            throw new ContentException("file size is invalid - min=52428800");
        }
        if (!this.initialisation_complete_sem.isReleasedForever() || this.public_dht_plugin != null && this.public_dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(file_size, (byte)1, listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupContentSupport(file_size, (byte)1, listener);
        }
    }

    public void lookupContent(final long file_size, String[] networks, final RelatedContentLookupListener listener) throws ContentException {
        if (file_size < 0x3200000L) {
            throw new ContentException("file size is invalid - min=52428800");
        }
        final byte net = RelatedContentManager.convertNetworks(networks);
        if (net == 0) {
            throw new ContentException("No networks specified");
        }
        if (!this.initialisation_complete_sem.isReleasedForever() || this.public_dht_plugin != null && this.public_dht_plugin.isInitialising()) {
            AsyncDispatcher dispatcher = new AsyncDispatcher();
            dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    try {
                        RelatedContentManager.this.initialisation_complete_sem.reserve();
                        RelatedContentManager.this.lookupContentSupport(file_size, net, listener);
                    }
                    catch (ContentException e) {
                        Debug.out(e);
                    }
                }
            });
        } else {
            this.lookupContentSupport(file_size, net, listener);
        }
    }

    private void lookupContentSupport(long file_size, byte networks, RelatedContentLookupListener listener) throws ContentException {
        if (!this.enabled) {
            throw new ContentException("rcm is disabled");
        }
        try {
            byte[] key_bytes = ("az:rcm:size:assoc:" + file_size).getBytes("UTF-8");
            byte[] from_hash = new SHA1Simple().calculateHash(key_bytes);
            String op_str = "Content rel read: size=" + file_size;
            this.lookupContentSupport0(from_hash, key_bytes, op_str, 0, networks, true, listener);
        }
        catch (ContentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ContentException("lookup failed", e);
        }
    }

    private void lookupContentSupport(byte[] from_hash, int level, byte networks, boolean explicit, RelatedContentLookupListener listener) throws ContentException {
        if (!this.enabled) {
            throw new ContentException("rcm is disabled");
        }
        try {
            String from_hash_str = ByteFormatter.encodeString(from_hash);
            byte[] key_bytes = ("az:rcm:assoc:" + from_hash_str).getBytes("UTF-8");
            String op_str = "Content rel read: " + from_hash_str.substring(0, 16);
            this.lookupContentSupport0(from_hash, key_bytes, op_str, level, networks, explicit, listener);
        }
        catch (ContentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ContentException("lookup failed", e);
        }
    }

    private String getString(String[] args) {
        String str = "";
        for (String s : args) {
            str = str + (str.length() == 0 ? "" : ",") + s;
        }
        return str;
    }

    private void lookupContentSupport0(final byte[] from_hash, byte[] key_bytes, String op_str, final int level, byte networks, final boolean explicit, final RelatedContentLookupListener listener) throws ContentException {
        try {
            int max_hits = 30;
            DHTPluginInterface dht_plugin = this.selectDHT(networks);
            if (dht_plugin == null) {
                throw new Exception("DHT Plugin unavailable for networks '" + this.getString(RelatedContentManager.convertNetworks(networks)) + "'");
            }
            dht_plugin.get(key_bytes, op_str, (byte)0, 30, 60000L, false, true, new DHTPluginOperationListener(){
                private Set<String> entries = new HashSet<String>();
                private RelatedContentManagerListener manager_listener = new RelatedContentManagerListener(){
                    private Set<RelatedContent> content_list = new HashSet<RelatedContent>();

                    public void contentFound(RelatedContent[] content) {
                        this.handle(content);
                    }

                    public void contentChanged(RelatedContent[] content) {
                        this.handle(content);
                    }

                    public void contentRemoved(RelatedContent[] content) {
                    }

                    public void contentChanged() {
                    }

                    public void contentReset() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void handle(RelatedContent[] content) {
                        ArrayList<RelatedContent> new_content = new ArrayList<RelatedContent>(content.length);
                        Set<RelatedContent> set = this.content_list;
                        synchronized (set) {
                            for (RelatedContent rc : content) {
                                if (this.content_list.contains(rc)) continue;
                                new_content.add(rc);
                            }
                            if (new_content.size() == 0) {
                                return;
                            }
                            this.content_list.addAll(new_content);
                        }
                        listener.contentFound(new_content.toArray(new RelatedContent[new_content.size()]));
                    }
                };

                public void starts(byte[] key) {
                    if (listener != null) {
                        try {
                            listener.lookupStart();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }

                public boolean diversified() {
                    return true;
                }

                public void valueRead(DHTPluginContact originator, DHTPluginValue value) {
                    try {
                        Map<String, Object> map = BDecoder.decode(value.getValue());
                        DownloadInfo info = RelatedContentManager.this.decodeInfo(map, from_hash, level + 1, explicit, this.entries);
                        if (info != null) {
                            RelatedContentManager.this.analyseResponse(info, listener == null ? null : this.manager_listener);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                public void valueWritten(DHTPluginContact target, DHTPluginValue value) {
                }

                public void complete(byte[] key, boolean timeout_occurred) {
                    if (listener != null) {
                        try {
                            listener.lookupComplete();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            ContentException ce = e instanceof ContentException ? (ContentException)e : new ContentException("Lookup failed", e);
            if (listener != null) {
                try {
                    listener.lookupFailed(ce);
                }
                catch (Throwable f) {
                    Debug.out(f);
                }
            }
            throw ce;
        }
    }

    protected void popuplateSecondaryLookups(ContentCache content_cache) {
        Random rand = new Random();
        this.secondary_lookups.clear();
        List primaries = this.download_info_map.values();
        int primary_count = primaries.size();
        int primaries_to_add = primary_count < 2 ? 0 : (primary_count < 5 ? (rand.nextInt(4) == 0 ? 1 : 0) : (primary_count < 10 ? 1 : 2));
        if (primaries_to_add > 0) {
            HashSet<DownloadInfo> added = new HashSet<DownloadInfo>();
            for (int i = 0; i < primaries_to_add; ++i) {
                DownloadInfo info = (DownloadInfo)primaries.get(rand.nextInt(primaries.size()));
                if (added.contains(info)) continue;
                added.add(info);
                this.secondary_lookups.addLast(new SecondaryLookup(info.getHash(), info.getLevel(), info.getNetworksInternal()));
            }
        }
        Map<String, DownloadInfo> related_content = content_cache.related_content;
        Iterator<DownloadInfo> it = related_content.values().iterator();
        ArrayList<DownloadInfo> secondary_cache_temp = new ArrayList<DownloadInfo>(related_content.size());
        while (it.hasNext()) {
            DownloadInfo di = it.next();
            if (di.getHash() == null || di.getLevel() >= this.max_search_level) continue;
            secondary_cache_temp.add(di);
        }
        int cache_size = Math.min(secondary_cache_temp.size(), 10 - this.secondary_lookups.size());
        if (cache_size > 0) {
            int i;
            for (i = 0; i < cache_size; ++i) {
                int index = rand.nextInt(secondary_cache_temp.size());
                DownloadInfo x = (DownloadInfo)secondary_cache_temp.get(index);
                secondary_cache_temp.set(index, (DownloadInfo)secondary_cache_temp.get(i));
                secondary_cache_temp.set(i, x);
            }
            for (i = 0; i < cache_size; ++i) {
                DownloadInfo x = (DownloadInfo)secondary_cache_temp.get(i);
                this.secondary_lookups.addLast(new SecondaryLookup(x.getHash(), x.getLevel(), x.getNetworksInternal()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void secondaryLookup() {
        SecondaryLookup sl;
        long now = SystemTime.getMonotonousTime();
        Object object = this.rcm_lock;
        synchronized (object) {
            if (this.secondary_lookup_in_progress) {
                return;
            }
            if (now - this.secondary_lookup_complete_time < 900000L) {
                return;
            }
            if (this.secondary_lookups.size() == 0) {
                ContentCache cc;
                ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
                if (cc == null) {
                    cc = this.loadRelatedContent();
                } else {
                    this.popuplateSecondaryLookups(cc);
                }
            }
            if (this.secondary_lookups.size() == 0) {
                return;
            }
            sl = this.secondary_lookups.removeFirst();
            this.secondary_lookup_in_progress = true;
        }
        try {
            this.lookupContentSupport(sl.getHash(), sl.getLevel(), sl.getNetworks(), false, new RelatedContentLookupListener(){

                public void lookupStart() {
                }

                public void contentFound(RelatedContent[] content) {
                }

                public void lookupComplete() {
                    this.next();
                }

                public void lookupFailed(ContentException error) {
                    this.next();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void next() {
                    SecondaryLookup next_sl;
                    Object object = RelatedContentManager.this.rcm_lock;
                    synchronized (object) {
                        if (RelatedContentManager.this.secondary_lookups.size() == 0) {
                            RelatedContentManager.this.secondary_lookup_in_progress = false;
                            RelatedContentManager.this.secondary_lookup_complete_time = SystemTime.getMonotonousTime();
                            return;
                        }
                        next_sl = (SecondaryLookup)RelatedContentManager.this.secondary_lookups.removeFirst();
                    }
                    final 16 listener = this;
                    SimpleTimer.addEvent("RCM:SLDelay", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent event2) {
                            try {
                                RelatedContentManager.this.lookupContentSupport(next_sl.getHash(), next_sl.getLevel(), next_sl.getNetworks(), false, listener);
                            }
                            catch (Throwable e) {
                                Object object = RelatedContentManager.this.rcm_lock;
                                synchronized (object) {
                                    RelatedContentManager.this.secondary_lookup_in_progress = false;
                                    RelatedContentManager.this.secondary_lookup_complete_time = SystemTime.getMonotonousTime();
                                }
                            }
                        }
                    });
                }
            });
        }
        catch (Throwable e) {
            Object object2 = this.rcm_lock;
            synchronized (object2) {
                this.secondary_lookup_in_progress = false;
                this.secondary_lookup_complete_time = now;
            }
        }
    }

    protected void contentChanged(final DownloadInfo info) {
        this.setConfigDirty();
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentChanged(new RelatedContent[]{info});
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected void contentChanged(boolean is_dirty) {
        if (is_dirty) {
            this.setConfigDirty();
        }
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentChanged();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RelatedContent[] content) {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache content_cache = this.loadRelatedContent();
            this.delete(content, content_cache, true);
        }
    }

    protected void delete(final RelatedContent[] content, ContentCache content_cache, boolean persistent) {
        if (persistent) {
            this.addPersistentlyDeleted(content);
        }
        Map<String, DownloadInfo> related_content = content_cache.related_content;
        Iterator<DownloadInfo> it = related_content.values().iterator();
        while (it.hasNext()) {
            DownloadInfo di = it.next();
            for (RelatedContent c : content) {
                if (c != di) continue;
                it.remove();
                if (!di.isUnread()) continue;
                this.decrementUnread();
            }
        }
        ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = content_cache.related_content_map;
        ArrayList<byte[]> delete = new ArrayList<byte[]>();
        block2: for (byte[] key : related_content_map.keys()) {
            ArrayList infos = (ArrayList)related_content_map.get(key);
            for (RelatedContent c : content) {
                if (!infos.remove(c) || infos.size() != 0) continue;
                delete.add(key);
                continue block2;
            }
        }
        for (byte[] key : delete) {
            related_content_map.remove(key);
        }
        this.setConfigDirty();
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    try {
                        l.contentRemoved(content);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected String getPrivateInfoKey(RelatedContent info) {
        return info.getTitle() + ":" + info.getTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyseResponse(DownloadInfo to_info, final RelatedContentManagerListener listener) {
        try {
            Object object = this.rcm_lock;
            synchronized (object) {
                String key;
                byte[] target = to_info.getHash();
                if (target != null) {
                    if (this.download_info_map.containsKey(target)) {
                        return;
                    }
                    key = Base32.encode(target);
                } else {
                    key = this.getPrivateInfoKey(to_info);
                    if (this.download_priv_set.contains(key)) {
                        return;
                    }
                }
                if (this.isPersistentlyDeleted(to_info)) {
                    return;
                }
                ContentCache content_cache = this.loadRelatedContent();
                DownloadInfo target_info = null;
                boolean changed_content = false;
                boolean new_content = false;
                target_info = content_cache.related_content.get(key);
                if (target_info == null) {
                    if (this.enoughSpaceFor(content_cache, to_info)) {
                        target_info = to_info;
                        content_cache.related_content.put(key, target_info);
                        byte[] from_hash = to_info.getRelatedToHash();
                        ArrayList<DownloadInfo> links = (ArrayList<DownloadInfo>)content_cache.related_content_map.get(from_hash);
                        if (links == null) {
                            links = new ArrayList<DownloadInfo>(1);
                            content_cache.related_content_map.put(from_hash, links);
                        }
                        links.add(target_info);
                        links.trimToSize();
                        target_info.setPublic(content_cache);
                        if (this.secondary_lookups.size() < 10) {
                            byte[] hash = target_info.getHash();
                            int level = target_info.getLevel();
                            if (hash != null && level < this.max_search_level) {
                                this.secondary_lookups.add(new SecondaryLookup(hash, level, target_info.getNetworksInternal()));
                            }
                        }
                        new_content = true;
                    } else {
                        transient_info_cache.put(key, to_info);
                    }
                } else {
                    changed_content = target_info.addInfo(to_info);
                }
                if (target_info != null) {
                    boolean something_changed;
                    final RelatedContent[] f_target = new RelatedContent[]{target_info};
                    final boolean f_change = changed_content;
                    boolean bl = something_changed = changed_content || new_content;
                    if (something_changed) {
                        this.setConfigDirty();
                    }
                    this.content_change_dispatcher.dispatch(new AERunnable(){

                        public void runSupport() {
                            if (something_changed) {
                                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                                    try {
                                        if (f_change) {
                                            l.contentChanged(f_target);
                                            continue;
                                        }
                                        l.contentFound(f_target);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                            if (listener != null) {
                                try {
                                    if (f_change) {
                                        listener.contentChanged(f_target);
                                    } else {
                                        listener.contentFound(f_target);
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected boolean enoughSpaceFor(ContentCache content_cache, DownloadInfo fi) {
        int now_secs;
        Map<String, DownloadInfo> related_content = content_cache.related_content;
        if (related_content.size() < this.max_results + this.temporary_space.get()) {
            return true;
        }
        Iterator<Map.Entry<String, DownloadInfo>> it = related_content.entrySet().iterator();
        int max_level = fi.getLevel();
        HashMap<Integer, DownloadInfo> oldest_per_rank = new HashMap<Integer, DownloadInfo>();
        int min_rank = Integer.MAX_VALUE;
        int max_rank = -1;
        while (it.hasNext()) {
            int rank;
            int info_level;
            Map.Entry<String, DownloadInfo> entry = it.next();
            DownloadInfo info = entry.getValue();
            if (info.isExplicit() || (info_level = info.getLevel()) < max_level) continue;
            if (info_level > max_level) {
                max_level = info_level;
                min_rank = Integer.MAX_VALUE;
                max_rank = -1;
                oldest_per_rank.clear();
            }
            if ((rank = info.getRank()) < min_rank) {
                min_rank = rank;
            } else if (rank > max_rank) {
                max_rank = rank;
            }
            DownloadInfo oldest = (DownloadInfo)oldest_per_rank.get(rank);
            if (oldest == null) {
                oldest_per_rank.put(rank, info);
                continue;
            }
            if (info.getLastSeenSecs() >= oldest.getLastSeenSecs()) continue;
            oldest_per_rank.put(rank, info);
        }
        DownloadInfo to_remove = (DownloadInfo)oldest_per_rank.get(min_rank);
        if (to_remove != null) {
            this.delete(new RelatedContent[]{to_remove}, content_cache, false);
            return true;
        }
        if (max_level == 1 && (to_remove = (DownloadInfo)oldest_per_rank.get(max_rank)) != null && (now_secs = (int)(SystemTime.getCurrentTime() / 1000L)) - to_remove.getLastSeenSecs() >= 86400) {
            this.delete(new RelatedContent[]{to_remove}, content_cache, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelatedContent[] getRelatedContent() {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache content_cache = this.loadRelatedContent();
            return content_cache.related_content.values().toArray(new DownloadInfo[content_cache.related_content.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DownloadInfo> getRelatedContentAsList() {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache content_cache = this.loadRelatedContent();
            return new ArrayList<DownloadInfo>(content_cache.related_content.values());
        }
    }

    public void reset() {
        this.reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(boolean reset_perm_dels) {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache cc;
            ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
            if (cc == null) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                cc.related_content = new HashMap<String, DownloadInfo>();
                cc.related_content_map = new ByteArrayHashMapEx();
            }
            this.pub_download_infos1.clear();
            this.pub_download_infos2.clear();
            this.non_pub_download_infos1.clear();
            this.non_pub_download_infos2.clear();
            List list = this.download_info_map.values();
            for (DownloadInfo info : list) {
                if ((info.getNetworksInternal() & 1) != 0) {
                    this.pub_download_infos1.add(info);
                    this.pub_download_infos2.add(info);
                    continue;
                }
                this.non_pub_download_infos1.add(info);
                this.non_pub_download_infos2.add(info);
            }
            Collections.shuffle(this.pub_download_infos1);
            Collections.shuffle(this.non_pub_download_infos1);
            this.total_unread.set(0);
            if (reset_perm_dels) {
                this.resetPersistentlyDeleted();
            }
            this.setConfigDirty();
        }
        this.content_change_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                for (RelatedContentManagerListener l : RelatedContentManager.this.listeners) {
                    l.contentReset();
                }
            }
        });
    }

    public SearchInstance searchRCM(Map<String, Object> search_parameters, SearchObserver observer) throws SearchException {
        this.initialisation_complete_sem.reserve();
        if (!this.enabled) {
            throw new SearchException("rcm is disabled");
        }
        String[] networks = (String[])search_parameters.get("n");
        String target_net = "Public";
        if (networks != null) {
            for (String net : networks) {
                if (net == "Public") {
                    target_net = "Public";
                    break;
                }
                if (net != "I2P") continue;
                target_net = "I2P";
            }
        }
        if (target_net == "I2P") {
            this.checkI2PSearcher(true);
        }
        for (RelatedContentSearcher searcher : this.searchers) {
            String net = searcher.getDHTPlugin().getNetwork();
            if (net != target_net) continue;
            return searcher.searchRCM(search_parameters, observer);
        }
        throw new SearchException("no searchers available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConfigDirty() {
        Object object = this.rcm_lock;
        synchronized (object) {
            this.content_dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ContentCache loadRelatedContent() {
        boolean fire_event = false;
        try {
            ContentCache contentCache;
            Object object = this.rcm_lock;
            synchronized (object) {
                ContentCache cc;
                this.last_config_access = SystemTime.getMonotonousTime();
                ContentCache contentCache2 = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
                if (cc == null) {
                    fire_event = true;
                    cc = new ContentCache();
                    this.content_cache = new WeakReference<ContentCache>(cc);
                    try {
                        int new_total_unread = 0;
                        if (FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
                            Map<Object, Object> map = FileUtil.readResilientConfigFile(CONFIG_FILE);
                            Map<String, DownloadInfo> related_content = cc.related_content;
                            ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = cc.related_content_map;
                            byte[] data = (byte[])map.get("d");
                            if (data != null) {
                                try {
                                    map = BDecoder.decode(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(CryptoManagerFactory.getSingleton().deobfuscate(data)))));
                                }
                                catch (Throwable e) {
                                    map = new HashMap();
                                }
                            }
                            Map rcm_map = (Map)map.get("rcm");
                            Object rc_map_stuff = map.get("rc");
                            if (rc_map_stuff != null && rcm_map != null) {
                                String key;
                                HashMap<Integer, DownloadInfo> id_map = new HashMap<Integer, DownloadInfo>();
                                if (rc_map_stuff instanceof Map) {
                                    Map rc_map = (Map)rc_map_stuff;
                                    for (Map.Entry entry : rc_map.entrySet()) {
                                        try {
                                            key = (String)entry.getKey();
                                            Map info_map = (Map)entry.getValue();
                                            DownloadInfo info = this.deserialiseDI(info_map, cc);
                                            if (info.isUnread()) {
                                                ++new_total_unread;
                                            }
                                            related_content.put(key, info);
                                            int id = ((Long)info_map.get("_i")).intValue();
                                            id_map.put(id, info);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                } else {
                                    List rc_map_list = (List)rc_map_stuff;
                                    for (Map map2 : rc_map_list) {
                                        try {
                                            key = new String((byte[])map2.get("_k"), "UTF-8");
                                            DownloadInfo info = this.deserialiseDI(map2, cc);
                                            if (info.isUnread()) {
                                                ++new_total_unread;
                                            }
                                            related_content.put(key, info);
                                            int id = ((Long)map2.get("_i")).intValue();
                                            id_map.put(id, info);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                                if (rcm_map.size() != 0 && id_map.size() != 0) {
                                    for (String key2 : rcm_map.keySet()) {
                                        try {
                                            byte[] byArray = Base32.decode(key2);
                                            int[] ids = ImportExportUtils.importIntArray(rcm_map, key2);
                                            if (ids == null || ids.length == 0) continue;
                                            ArrayList<DownloadInfo> di_list = new ArrayList<DownloadInfo>(ids.length);
                                            for (int id : ids) {
                                                DownloadInfo di = (DownloadInfo)id_map.get(id);
                                                if (di == null) continue;
                                                di.setRelatedToHash(byArray);
                                                di_list.add(di);
                                            }
                                            if (di_list.size() <= 0) continue;
                                            related_content_map.put(byArray, di_list);
                                        }
                                        catch (Throwable throwable) {
                                            Debug.out(throwable);
                                        }
                                    }
                                }
                                Iterator<DownloadInfo> it = related_content.values().iterator();
                                while (it.hasNext()) {
                                    DownloadInfo di = it.next();
                                    if (di.getRelatedToHash() != null) continue;
                                    if (di.isUnread()) {
                                        --new_total_unread;
                                    }
                                    it.remove();
                                }
                                this.popuplateSecondaryLookups(cc);
                            }
                        }
                        if (this.total_unread.get() != new_total_unread) {
                            this.total_unread.set(new_total_unread);
                            COConfigurationManager.setParameter(CONFIG_TOTAL_UNREAD, new_total_unread);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    this.enforceMaxResults(cc, false);
                }
                this.content_cache_ref = cc;
                contentCache = cc;
            }
            Object var24_34 = null;
            if (!fire_event) return contentCache;
            this.contentChanged(false);
            return contentCache;
        }
        catch (Throwable throwable) {
            Object var24_35 = null;
            if (!fire_event) throw throwable;
            this.contentChanged(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRelatedContent(int tick_count) {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache cc;
            COConfigurationManager.setParameter(CONFIG_TOTAL_UNREAD, this.total_unread.get());
            long now = SystemTime.getMonotonousTime();
            ContentCache contentCache = cc = this.content_cache == null ? null : (ContentCache)this.content_cache.get();
            if (!this.content_dirty) {
                if (cc != null && now - this.last_config_access > 60000L) {
                    if (this.content_cache_ref != null) {
                        this.content_discard_ticks = 0;
                    }
                    this.content_cache_ref = null;
                }
                return;
            }
            if (tick_count % 10 != 0) {
                return;
            }
            this.last_config_access = now;
            this.content_dirty = false;
            if (cc != null) {
                if (this.persist) {
                    Map<String, DownloadInfo> related_content = cc.related_content;
                    ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = cc.related_content_map;
                    if (related_content.size() == 0) {
                        FileUtil.deleteResilientConfigFile(CONFIG_FILE);
                    } else {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        Set<Map.Entry<String, DownloadInfo>> rcs = related_content.entrySet();
                        ArrayList<Map<String, Object>> rc_map_list = new ArrayList<Map<String, Object>>(rcs.size());
                        map.put("rc", rc_map_list);
                        int id = 0;
                        HashMap<DownloadInfo, Integer> info_map = new HashMap<DownloadInfo, Integer>();
                        for (Map.Entry<String, DownloadInfo> entry : rcs) {
                            DownloadInfo info = entry.getValue();
                            Map<String, Object> di_map = this.serialiseDI(info, cc);
                            if (di_map == null) continue;
                            info_map.put(info, id);
                            di_map.put("_i", new Long(id));
                            di_map.put("_k", entry.getKey());
                            rc_map_list.add(di_map);
                            ++id;
                        }
                        HashMap rcm_map = new HashMap();
                        map.put("rcm", rcm_map);
                        for (byte[] hash : related_content_map.keys()) {
                            DownloadInfo di;
                            Integer index;
                            List dis = (List)related_content_map.get(hash);
                            int[] ids = new int[dis.size()];
                            int pos = 0;
                            Iterator i$ = dis.iterator();
                            while (i$.hasNext() && (index = (Integer)info_map.get(di = (DownloadInfo)i$.next())) != null) {
                                ids[pos++] = index;
                            }
                            if (pos != ids.length) continue;
                            ImportExportUtils.exportIntArray(rcm_map, Base32.encode(hash), ids);
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(102400);
                        try {
                            GZIPOutputStream gos = new GZIPOutputStream(baos);
                            gos.write(BEncoder.encode(map));
                            gos.close();
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        map.clear();
                        map.put("d", CryptoManagerFactory.getSingleton().obfuscate(baos.toByteArray()));
                        FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
                    }
                } else {
                    this.deleteRelatedContent();
                }
                for (RelatedContentSearcher searcher : this.searchers) {
                    searcher.updateKeyBloom(cc);
                }
            }
        }
    }

    private void deleteRelatedContent() {
        FileUtil.deleteResilientConfigFile(CONFIG_FILE);
        FileUtil.deleteResilientConfigFile(PERSIST_DEL_FILE);
    }

    public int getNumUnread() {
        return this.total_unread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllRead() {
        boolean changed = false;
        Object object = this.rcm_lock;
        synchronized (object) {
            DownloadInfo[] content;
            for (DownloadInfo c : content = (DownloadInfo[])this.getRelatedContent()) {
                if (!c.isUnread()) continue;
                changed = true;
                c.setUnreadInternal(false);
            }
            this.total_unread.set(0);
        }
        if (changed) {
            this.contentChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache content_cache = this.loadRelatedContent();
            this.addPersistentlyDeleted(content_cache.related_content.values().toArray(new DownloadInfo[content_cache.related_content.size()]));
            this.reset(false);
        }
    }

    protected void incrementUnread() {
        this.total_unread.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementUnread() {
        Object object = this.rcm_lock;
        synchronized (object) {
            int val = this.total_unread.decrementAndGet();
            if (val < 0) {
                this.total_unread.set(0);
            }
        }
    }

    protected Download getDownload(byte[] hash) {
        try {
            return this.plugin_interface.getDownloadManager().getDownload(hash);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private byte[][] getKeys(Download download) {
        byte[] tracker_keys = null;
        byte[] ws_keys = null;
        try {
            Torrent torrent = download.getTorrent();
            if (torrent != null) {
                TOTorrentAnnounceURLSet[] sets;
                TOTorrent to_torrent = PluginCoreUtils.unwrap(torrent);
                HashSet<String> tracker_domains = new HashSet<String>();
                this.addURLToDomainKeySet(tracker_domains, to_torrent.getAnnounceURL());
                TOTorrentAnnounceURLGroup group = to_torrent.getAnnounceURLGroup();
                for (TOTorrentAnnounceURLSet set : sets = group.getAnnounceURLSets()) {
                    URL[] urls;
                    for (URL u : urls = set.getAnnounceURLs()) {
                        this.addURLToDomainKeySet(tracker_domains, u);
                    }
                }
                tracker_keys = this.domainsToArray(tracker_domains, 8);
                HashSet<String> ws_domains = new HashSet<String>();
                List getright = BDecoder.decodeStrings(this.getURLList(to_torrent, "url-list"));
                List webseeds = BDecoder.decodeStrings(this.getURLList(to_torrent, "httpseeds"));
                for (List l : new List[]{getright, webseeds}) {
                    for (Object o : l) {
                        if (!(o instanceof String)) continue;
                        try {
                            this.addURLToDomainKeySet(ws_domains, new URL((String)o));
                        }
                        catch (Throwable e) {}
                    }
                }
                ws_keys = this.domainsToArray(ws_domains, 3);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return new byte[][]{tracker_keys, ws_keys};
    }

    protected byte[] domainsToArray(Set<String> domains, int max) {
        int entries = Math.min(domains.size(), max);
        if (entries > 0) {
            byte[] keys = new byte[entries * 4];
            int pos = 0;
            for (String dom : domains) {
                int hash = dom.hashCode();
                byte[] bytes = new byte[]{(byte)(hash >> 24), (byte)(hash >> 16), (byte)(hash >> 8), (byte)hash};
                System.arraycopy(bytes, 0, keys, pos, 4);
                pos += 4;
            }
            return keys;
        }
        return null;
    }

    protected List getURLList(TOTorrent torrent, String key) {
        Object obj = torrent.getAdditionalProperty(key);
        if (obj instanceof byte[]) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(obj);
            return l;
        }
        if (obj instanceof List) {
            return (List)BEncoder.clone(obj);
        }
        return new ArrayList();
    }

    private void addURLToDomainKeySet(Set<String> set, URL u) {
        String prot = u.getProtocol();
        if (prot != null && (prot.equalsIgnoreCase("http") || prot.equalsIgnoreCase("udp"))) {
            String host = u.getHost().toLowerCase(Locale.US);
            if (host.contains(":")) {
                return;
            }
            String[] bits = host.split("\\.");
            int len = bits.length;
            if (len >= 2) {
                String end = bits[len - 1];
                char[] chars = end.toCharArray();
                boolean all_digits = true;
                for (char c : chars) {
                    if (Character.isDigit(c)) continue;
                    all_digits = false;
                    break;
                }
                if (!all_digits) {
                    set.add(bits[len - 2] + "." + end);
                }
            }
        }
    }

    private byte getNetworks(Download download) {
        String[] networks = download.getListAttribute(this.ta_networks);
        if (networks == null) {
            return 0;
        }
        return RelatedContentManager.convertNetworks(networks);
    }

    public static String[] convertNetworks(byte net) {
        if (net == 0) {
            return new String[0];
        }
        if (net == 1) {
            return NET_PUBLIC_ARRAY;
        }
        if (net == 2) {
            return NET_I2P_ARRAY;
        }
        if (net == 4) {
            return NET_TOR_ARRAY;
        }
        if (net == 3) {
            return NET_PUBLIC_AND_I2P_ARRAY;
        }
        ArrayList<String> nets = new ArrayList<String>();
        if ((net & 1) != 0) {
            nets.add("Public");
        }
        if ((net & 2) != 0) {
            nets.add("I2P");
        }
        if ((net & 4) != 0) {
            nets.add("Tor");
        }
        return nets.toArray(new String[nets.size()]);
    }

    public static byte convertNetworks(String[] networks) {
        byte nets = 0;
        for (int i = 0; i < networks.length; ++i) {
            String n = networks[i];
            if (n.equalsIgnoreCase("Public")) {
                nets = (byte)(nets | 1);
                continue;
            }
            if (n.equalsIgnoreCase("I2P")) {
                nets = (byte)(nets | 2);
                continue;
            }
            if (!n.equalsIgnoreCase("Tor")) continue;
            nets = (byte)(nets | 4);
        }
        return nets;
    }

    private String[] getTags(Download download) {
        String[] networks;
        HashSet<String> all_tags = new HashSet<String>();
        if (this.tag_manager.isEnabled()) {
            Tag cat_tag;
            String cat_name;
            String string = cat_name = this.ta_category == null ? null : download.getAttribute(this.ta_category);
            if (cat_name != null && (cat_tag = this.tag_manager.getTagType(1).getTag(cat_name, true)) != null && cat_tag.isPublic()) {
                all_tags.add(cat_name.toLowerCase(Locale.US));
            }
            List<Tag> tags = this.tag_manager.getTagType(3).getTagsForTaggable(PluginCoreUtils.unwrap(download));
            for (Tag t : tags) {
                if (!t.isPublic()) continue;
                all_tags.add(t.getTagName(true).toLowerCase(Locale.US));
            }
        }
        for (String network : networks = download.getListAttribute(this.ta_networks)) {
            if (network.equals("Public") || !AEPluginProxyHandler.hasPluginProxyForNetwork(network, true)) continue;
            all_tags.add("_" + network.toLowerCase(Locale.US) + "_");
        }
        if (all_tags.size() == 0) {
            return null;
        }
        if (all_tags.size() == 1) {
            return new String[]{(String)all_tags.iterator().next()};
        }
        ArrayList temp = new ArrayList(all_tags);
        Collections.shuffle(temp);
        return temp.toArray(new String[temp.size()]);
    }

    protected byte[] encodeTags(String[] tags) {
        if (tags == null || tags.length == 0) {
            return null;
        }
        byte[] temp = new byte[63];
        int pos = 0;
        for (int i = 0; i < Math.min(3, tags.length); ++i) {
            String tag = tags[i];
            tag = this.truncateTag(tag);
            try {
                byte[] tag_bytes = tag.getBytes("UTF-8");
                int tb_len = tag_bytes.length;
                temp[pos++] = (byte)tb_len;
                System.arraycopy(tag_bytes, 0, temp, pos, tb_len);
                pos += tb_len;
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (pos == 0) {
            return null;
        }
        byte[] result = new byte[pos];
        System.arraycopy(temp, 0, result, 0, pos);
        return result;
    }

    protected String truncateTag(String tag) {
        if (tag.length() > 20) {
            tag = tag.substring(0, 20);
        }
        while (tag.length() > 0) {
            try {
                byte[] tag_bytes = tag.getBytes("UTF-8");
                if (tag_bytes.length <= 20) break;
                tag = tag.substring(0, tag.length() - 1);
            }
            catch (Throwable e) {
                break;
            }
        }
        return tag;
    }

    protected String[] decodeTags(byte[] bytes) {
        int tag_len;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ArrayList<String> tags = new ArrayList<String>(3);
        for (int pos = 0; pos < bytes.length && (tag_len = bytes[pos++] & 0xFF) <= 20; pos += tag_len) {
            try {
                tags.add(new String(bytes, pos, tag_len, "UTF-8"));
                continue;
            }
            catch (Throwable e) {
                break;
            }
        }
        if (tags.size() == 0) {
            return null;
        }
        return tags.toArray(new String[tags.size()]);
    }

    protected byte[] getPermDelKey(RelatedContent info) {
        byte[] bytes = info.getHash();
        if (bytes == null) {
            try {
                bytes = new SHA1Simple().calculateHash(this.getPrivateInfoKey(info).getBytes("ISO-8859-1"));
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }
        byte[] key = new byte[8];
        System.arraycopy(bytes, 0, key, 0, 8);
        return key;
    }

    protected List<byte[]> loadPersistentlyDeleted() {
        List entries = null;
        if (FileUtil.resilientConfigFileExists(PERSIST_DEL_FILE)) {
            Map map = FileUtil.readResilientConfigFile(PERSIST_DEL_FILE);
            entries = (List)map.get("entries");
        }
        if (entries == null) {
            entries = new ArrayList(0);
        }
        return entries;
    }

    protected void addPersistentlyDeleted(RelatedContent[] content) {
        block6: {
            if (content.length == 0) {
                return;
            }
            List<byte[]> entries = this.loadPersistentlyDeleted();
            ArrayList<byte[]> new_keys = new ArrayList<byte[]>(content.length);
            for (RelatedContent rc : content) {
                byte[] key = this.getPermDelKey(rc);
                new_keys.add(key);
                entries.add(key);
            }
            HashMap<String, List<byte[]>> map = new HashMap<String, List<byte[]>>();
            map.put("entries", entries);
            FileUtil.writeResilientConfigFile(PERSIST_DEL_FILE, map);
            if (this.persist_del_bloom == null) break block6;
            if (this.persist_del_bloom.getSize() / (this.persist_del_bloom.getEntryCount() + content.length) < 10) {
                this.persist_del_bloom = BloomFilterFactory.createAddOnly(Math.max(1000, this.persist_del_bloom.getSize() * 10 + 1000 + content.length));
                for (byte[] k : entries) {
                    this.persist_del_bloom.add(k);
                }
            } else {
                for (byte[] k : new_keys) {
                    this.persist_del_bloom.add(k);
                }
            }
        }
    }

    protected boolean isPersistentlyDeleted(RelatedContent content) {
        if (this.persist_del_bloom == null) {
            List<byte[]> entries = this.loadPersistentlyDeleted();
            this.persist_del_bloom = BloomFilterFactory.createAddOnly(Math.max(1000, entries.size() * 10 + 1000));
            for (byte[] k : entries) {
                this.persist_del_bloom.add(k);
            }
        }
        byte[] key = this.getPermDelKey(content);
        return this.persist_del_bloom.contains(key);
    }

    protected void resetPersistentlyDeleted() {
        FileUtil.deleteResilientConfigFile(PERSIST_DEL_FILE);
        this.persist_del_bloom = BloomFilterFactory.createAddOnly(1000);
    }

    public void reserveTemporarySpace() {
        this.temporary_space.addAndGet(50);
    }

    public void releaseTemporarySpace() {
        boolean reset_explicit = this.temporary_space.addAndGet(-50) == 0;
        this.enforceMaxResults(reset_explicit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enforceMaxResults(boolean reset_explicit) {
        Object object = this.rcm_lock;
        synchronized (object) {
            ContentCache content_cache = this.loadRelatedContent();
            this.enforceMaxResults(content_cache, reset_explicit);
        }
    }

    protected void enforceMaxResults(ContentCache content_cache, boolean reset_explicit) {
        Map<String, DownloadInfo> related_content = content_cache.related_content;
        int num_to_remove = related_content.size() - (this.max_results + this.temporary_space.get());
        if (num_to_remove > 0) {
            ArrayList<DownloadInfo> infos = new ArrayList<DownloadInfo>(related_content.values());
            if (reset_explicit) {
                for (DownloadInfo info : infos) {
                    if (!info.isExplicit()) continue;
                    info.setExplicit(false);
                }
            }
            Collections.sort(infos, new Comparator<DownloadInfo>(){

                @Override
                public int compare(DownloadInfo o1, DownloadInfo o2) {
                    int res = o2.getLevel() - o1.getLevel();
                    if (res != 0) {
                        return res;
                    }
                    res = o1.getRank() - o2.getRank();
                    if (res != 0) {
                        return res;
                    }
                    return o1.getLastSeenSecs() - o2.getLastSeenSecs();
                }
            });
            ArrayList to_remove = new ArrayList();
            for (int i = 0; i < Math.min(num_to_remove, infos.size()); ++i) {
                to_remove.add(infos.get(i));
            }
            if (to_remove.size() > 0) {
                this.delete(to_remove.toArray(new RelatedContent[to_remove.size()]), content_cache, false);
            }
        }
    }

    public void addListener(RelatedContentManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RelatedContentManagerListener listener) {
        this.listeners.remove(listener);
    }

    private Map<String, Object> serialiseDI(DownloadInfo info, ContentCache cc) {
        try {
            byte nets;
            String[] tags;
            byte[] ws_keys;
            HashMap<String, Object> info_map = new HashMap<String, Object>();
            info_map.put("h", info.getHash());
            ImportExportUtils.exportString(info_map, "d", info.getTitle());
            ImportExportUtils.exportInt(info_map, "r", info.getRand());
            ImportExportUtils.exportString(info_map, "t", info.getTracker());
            ImportExportUtils.exportLong(info_map, "z", info.getSize());
            ImportExportUtils.exportInt(info_map, "p", (int)(info.getPublishDate() / 3600000L));
            ImportExportUtils.exportInt(info_map, "q", info.getSeeds() << 16 | info.getLeechers() & 0xFFFF);
            ImportExportUtils.exportInt(info_map, "c", (int)info.getContentNetwork());
            byte[] tracker_keys = info.getTrackerKeys();
            if (tracker_keys != null) {
                info_map.put("k", tracker_keys);
            }
            if ((ws_keys = info.getWebSeedKeys()) != null) {
                info_map.put("w", ws_keys);
            }
            if ((tags = info.getTags()) != null) {
                info_map.put("g", this.encodeTags(tags));
            }
            if ((nets = info.getNetworksInternal()) != 1) {
                info_map.put("o", new Long(nets & 0xFF));
            }
            if (cc != null) {
                ImportExportUtils.exportBoolean(info_map, "u", info.isUnread());
                ImportExportUtils.exportIntArray(info_map, "l", info.getRandList());
                ImportExportUtils.exportInt(info_map, "s", info.getLastSeenSecs());
                ImportExportUtils.exportInt(info_map, "e", info.getLevel());
            }
            ImportExportUtils.exportLong(info_map, "cl", info.getChangedLocallyOn());
            return info_map;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    private DownloadInfo deserialiseDI(Map<String, Object> info_map, ContentCache cc) {
        try {
            byte nets;
            byte[] hash = (byte[])info_map.get("h");
            String title = ImportExportUtils.importString(info_map, "d");
            int rand = ImportExportUtils.importInt(info_map, "r");
            String tracker = ImportExportUtils.importString(info_map, "t");
            long size = ImportExportUtils.importLong(info_map, "z");
            int date = ImportExportUtils.importInt(info_map, "p", 0);
            int seeds_leechers = ImportExportUtils.importInt(info_map, "q", -1);
            byte cnet = (byte)ImportExportUtils.importInt(info_map, "c", -1);
            byte[] tracker_keys = (byte[])info_map.get("k");
            byte[] ws_keys = (byte[])info_map.get("w");
            long lastChangedLocally = ImportExportUtils.importLong(info_map, "cl");
            if (tracker_keys != null && tracker_keys.length % 4 != 0) {
                tracker_keys = null;
            }
            if (ws_keys != null && ws_keys.length % 4 != 0) {
                ws_keys = null;
            }
            byte[] _tags = (byte[])info_map.get("g");
            String[] tags = this.decodeTags(_tags);
            Long _nets = (Long)info_map.get("o");
            byte by = nets = _nets == null ? (byte)1 : _nets.byteValue();
            if (cc == null) {
                DownloadInfo info = new DownloadInfo(hash, hash, title, rand, tracker, tracker_keys, ws_keys, tags, nets, 0, false, size, date, seeds_leechers, cnet);
                info.setChangedLocallyOn(lastChangedLocally);
                return info;
            }
            boolean unread = ImportExportUtils.importBoolean(info_map, "u");
            int[] rand_list = ImportExportUtils.importIntArray(info_map, "l");
            int last_seen = ImportExportUtils.importInt(info_map, "s");
            int level = ImportExportUtils.importInt(info_map, "e");
            DownloadInfo info = new DownloadInfo(hash, title, rand, tracker, tracker_keys, ws_keys, tags, nets, unread, rand_list, last_seen, level, size, date, seeds_leechers, cnet, cc);
            info.setChangedLocallyOn(lastChangedLocally);
            return info;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    private void dump() {
        RelatedContent[] related_content = this.getRelatedContent();
        ByteArrayHashMap<ArrayList<String>> tk_map = new ByteArrayHashMap<ArrayList<String>>();
        ByteArrayHashMap<ArrayList<String>> ws_map = new ByteArrayHashMap<ArrayList<String>>();
        for (RelatedContent rc : related_content) {
            byte[] ws_keys;
            byte[] tracker_keys = rc.getTrackerKeys();
            if (tracker_keys != null) {
                for (int i = 0; i < tracker_keys.length; i += 4) {
                    byte[] tk = new byte[4];
                    System.arraycopy(tracker_keys, i, tk, 0, 4);
                    ArrayList<String> titles = (ArrayList<String>)tk_map.get(tk);
                    if (titles == null) {
                        titles = new ArrayList<String>();
                        tk_map.put(tk, titles);
                    }
                    titles.add(rc.getTitle());
                }
            }
            if ((ws_keys = rc.getWebSeedKeys()) == null) continue;
            for (int i = 0; i < ws_keys.length; i += 4) {
                byte[] wk = new byte[4];
                System.arraycopy(ws_keys, i, wk, 0, 4);
                ArrayList<String> titles = (ArrayList<String>)ws_map.get(wk);
                if (titles == null) {
                    titles = new ArrayList<String>();
                    ws_map.put(wk, titles);
                }
                titles.add(rc.getTitle());
            }
        }
        System.out.println("-- Trackers --");
        for (byte[] key : tk_map.keys()) {
            List titles = (List)tk_map.get(key);
            System.out.println(ByteFormatter.encodeString(key));
            for (String title : titles) {
                System.out.println("    " + title);
            }
        }
        System.out.println("-- Web Seeds --");
        for (byte[] key : ws_map.keys()) {
            List titles = (List)ws_map.get(key);
            System.out.println(ByteFormatter.encodeString(key));
            for (String title : titles) {
                System.out.println("    " + title);
            }
        }
    }

    static {
        NET_PUBLIC_ARRAY = new String[]{"Public"};
        NET_I2P_ARRAY = new String[]{"I2P"};
        NET_TOR_ARRAY = new String[]{"Tor"};
        NET_PUBLIC_AND_I2P_ARRAY = new String[]{"Public", "I2P"};
        transient_info_cache = new LinkedHashMap<String, DownloadInfo>(256, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, DownloadInfo> eldest) {
                return this.size() > 256;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ByteArrayHashMapEx<T>
    extends ByteArrayHashMap<T> {
        protected ByteArrayHashMapEx() {
        }

        public T getRandomValueExcluding(T excluded) {
            int num = RandomUtils.nextInt(this.size);
            T result = null;
            for (int j = 0; j < this.table.length; ++j) {
                ByteArrayHashMap.Entry e = this.table[j];
                while (e != null) {
                    Object value = e.value;
                    if (value != excluded) {
                        result = (T)value;
                    }
                    if (num <= 0 && result != null) {
                        return result;
                    }
                    --num;
                    e = e.next;
                }
            }
            return result;
        }
    }

    protected static class ContentCache {
        protected Map<String, DownloadInfo> related_content = new HashMap<String, DownloadInfo>();
        protected ByteArrayHashMapEx<ArrayList<DownloadInfo>> related_content_map = new ByteArrayHashMapEx();

        protected ContentCache() {
        }
    }

    protected class DownloadInfo
    extends RelatedContent {
        private final int rand;
        private boolean unread;
        private int[] rand_list;
        private int last_seen;
        private int level;
        private boolean explicit;
        private ContentCache cc;

        protected DownloadInfo(byte[] _related_to, byte[] _hash, String _title, int _rand, String _tracker, byte[] _tracker_keys, byte[] _ws_keys, String[] _tags, byte _nets, int _level, boolean _explicit, long _size, int _date, int _seeds_leechers, byte _cnet) {
            super(_related_to, _title, _hash, _tracker, _tracker_keys, _ws_keys, _tags, _nets, _size, _date, _seeds_leechers, _cnet);
            this.unread = true;
            this.rand = _rand;
            this.level = _level;
            this.explicit = _explicit;
            this.updateLastSeen();
        }

        protected DownloadInfo(byte[] _hash, String _title, int _rand, String _tracker, byte[] _tracker_keys, byte[] _ws_keys, String[] _tags, byte _nets, boolean _unread, int[] _rand_list, int _last_seen, int _level, long _size, int _date, int _seeds_leechers, byte _cnet, ContentCache _cc) {
            super(_title, _hash, _tracker, _tracker_keys, _ws_keys, _tags, _nets, _size, _date, _seeds_leechers, _cnet);
            this.unread = true;
            this.rand = _rand;
            this.unread = _unread;
            this.rand_list = _rand_list;
            this.last_seen = _last_seen;
            this.level = _level;
            this.cc = _cc;
            if (this.rand_list != null && this.rand_list.length > 100) {
                int[] temp = new int[100];
                System.arraycopy(this.rand_list, 0, temp, 0, 100);
                this.rand_list = temp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean addInfo(DownloadInfo info) {
            byte existing_nets;
            byte other_nets;
            String[] other_tags;
            int d;
            int sl;
            long cn;
            boolean result = false;
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                this.updateLastSeen();
                int r = info.getRand();
                if (this.rand_list == null) {
                    this.rand_list = new int[]{r};
                    result = true;
                } else {
                    boolean match = false;
                    for (int i = 0; i < this.rand_list.length; ++i) {
                        if (this.rand_list[i] != r) continue;
                        match = true;
                        break;
                    }
                    if (!match && this.rand_list.length < 100) {
                        int len = this.rand_list.length;
                        int[] new_rand_list = new int[len + 1];
                        System.arraycopy(this.rand_list, 0, new_rand_list, 0, len);
                        new_rand_list[len] = r;
                        this.rand_list = new_rand_list;
                        result = true;
                    }
                }
            }
            if (info.getLevel() < this.level) {
                this.level = info.getLevel();
                result = true;
            }
            if ((cn = info.getContentNetwork()) != -1L && this.getContentNetwork() == -1L) {
                this.setContentNetwork(cn);
            }
            if ((sl = info.getSeedsLeechers()) != -1 && sl != this.getSeedsLeechers()) {
                this.setSeedsLeechers(sl);
                result = true;
            }
            if ((d = info.getDateHours()) > 0 && this.getDateHours() == 0) {
                this.setDateHours(d);
                result = true;
            }
            if ((other_tags = info.getTags()) != null && other_tags.length > 0) {
                String[] existing_tags = this.getTags();
                if (existing_tags == NO_TAGS) {
                    this.setTags(other_tags);
                    result = true;
                } else {
                    boolean same;
                    if (other_tags.length == existing_tags.length) {
                        if (existing_tags.length == 1) {
                            same = other_tags[0].equals(existing_tags[0]);
                        } else {
                            same = true;
                            for (int i = 0; i < existing_tags.length; ++i) {
                                String e_tag = existing_tags[i];
                                boolean found = false;
                                for (int j = 0; j < other_tags.length; ++j) {
                                    if (!e_tag.equals(other_tags[j])) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                same = false;
                                break;
                            }
                        }
                    } else {
                        same = false;
                    }
                    if (!same) {
                        HashSet<String> tags = new HashSet<String>();
                        for (String t : existing_tags) {
                            tags.add(t);
                        }
                        for (String t : other_tags) {
                            tags.add(t);
                        }
                        this.setTags(tags.toArray(new String[tags.size()]));
                        result = true;
                    }
                }
            }
            if ((other_nets = info.getNetworksInternal()) != (existing_nets = this.getNetworksInternal())) {
                this.setNetworksInternal((byte)(other_nets | existing_nets));
                result = true;
            }
            if (result) {
                this.setChangedLocallyOn(0L);
            }
            return result;
        }

        public int getLevel() {
            return this.level;
        }

        protected boolean isExplicit() {
            return this.explicit;
        }

        protected void setExplicit(boolean b) {
            this.explicit = b;
        }

        protected void updateLastSeen() {
            this.last_seen = (int)(SystemTime.getCurrentTime() / 1000L);
        }

        public int getRank() {
            return this.rand_list == null ? 0 : this.rand_list.length;
        }

        public boolean isUnread() {
            return this.unread;
        }

        protected void setPublic(ContentCache _cc) {
            this.cc = _cc;
            if (this.unread) {
                RelatedContentManager.this.incrementUnread();
            }
            this.rand_list = new int[]{this.rand};
            this.setChangedLocallyOn(0L);
        }

        public int getLastSeenSecs() {
            return this.last_seen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setUnreadInternal(boolean _unread) {
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                this.unread = _unread;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setUnread(boolean _unread) {
            boolean changed = false;
            DownloadInfo downloadInfo = this;
            synchronized (downloadInfo) {
                if (this.unread != _unread) {
                    this.unread = _unread;
                    changed = true;
                }
            }
            if (changed) {
                if (_unread) {
                    RelatedContentManager.this.incrementUnread();
                } else {
                    RelatedContentManager.this.decrementUnread();
                }
                this.setChangedLocallyOn(0L);
                RelatedContentManager.this.contentChanged(this);
            }
        }

        protected int getRand() {
            return this.rand;
        }

        protected int[] getRandList() {
            return this.rand_list;
        }

        public Download getRelatedToDownload() {
            try {
                return RelatedContentManager.this.getDownload(this.getRelatedToHash());
            }
            catch (Throwable e) {
                Debug.out(e);
                return null;
            }
        }

        public void delete() {
            this.setChangedLocallyOn(0L);
            RelatedContentManager.this.delete(new RelatedContent[]{this});
        }

        public String getString() {
            return super.getString() + ", " + this.rand + ", rl=" + this.rand_list + ", last_seen=" + this.last_seen + ", level=" + this.level;
        }
    }

    protected class RCMSearchXFer
    implements DistributedDatabaseTransferType {
        protected RCMSearchXFer() {
        }
    }

    private static class SecondaryLookup {
        private final byte[] hash;
        private final int level;
        private final byte nets;

        private SecondaryLookup(byte[] _hash, int _level, byte _nets) {
            this.hash = _hash;
            this.level = _level;
            this.nets = _nets;
        }

        private byte[] getHash() {
            return this.hash;
        }

        private int getLevel() {
            return this.level;
        }

        private byte getNetworks() {
            return this.nets;
        }
    }
}

