/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.db.impl;

import com.aelitis.azureus.core.dht.DHTStorageKey;
import com.aelitis.azureus.core.dht.db.impl.DHTDBImpl;
import com.aelitis.azureus.core.dht.db.impl.DHTDBValueImpl;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTDBMapping {
    private static final boolean TRACE_ADDS = false;
    private DHTDBImpl db;
    private HashWrapper key;
    private ShortHash short_key;
    private DHTStorageKey adapter_key;
    private Map<HashWrapper, DHTDBValueImpl> direct_originator_map_may_be_null;
    private Map<HashWrapper, DHTDBValueImpl> indirect_originator_value_map = this.createLinkedMap();
    private int hits;
    private int direct_data_size;
    private int indirect_data_size;
    private int local_size;
    private byte diversification_state = 1;
    private static final int IP_COUNT_BLOOM_SIZE_INCREASE_CHUNK = 50;
    private Object ip_count_bloom_filter;

    protected DHTDBMapping(DHTDBImpl _db, HashWrapper _key, boolean _local) {
        this.db = _db;
        this.key = _key;
        this.short_key = new ShortHash(this.key.getBytes());
        try {
            if (this.db.getAdapter() != null) {
                this.adapter_key = this.db.getAdapter().keyCreated(this.key, _local);
                if (this.adapter_key != null) {
                    this.diversification_state = this.adapter_key.getDiversificationType();
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected Map<HashWrapper, DHTDBValueImpl> createLinkedMap() {
        return new LinkedHashMap<HashWrapper, DHTDBValueImpl>(1, 0.75f, true);
    }

    protected HashWrapper getKey() {
        return this.key;
    }

    protected ShortHash getShortKey() {
        return this.short_key;
    }

    protected void updateLocalContact(DHTTransportContact contact) {
        if (this.direct_originator_map_may_be_null == null) {
            return;
        }
        ArrayList<DHTDBValueImpl> changed = new ArrayList<DHTDBValueImpl>();
        Iterator<DHTDBValueImpl> it = this.direct_originator_map_may_be_null.values().iterator();
        while (it.hasNext()) {
            DHTDBValueImpl value = it.next();
            if (!value.isLocal()) continue;
            value.setOriginatorAndSender(contact);
            changed.add(value);
            this.direct_data_size -= value.getValue().length;
            this.local_size -= value.getValue().length;
            it.remove();
            this.informDeleted(value);
        }
        for (int i = 0; i < changed.size(); ++i) {
            this.add((DHTDBValueImpl)changed.get(i));
        }
    }

    protected void add(DHTDBValueImpl new_value) {
        DHTTransportContact originator = new_value.getOriginator();
        DHTTransportContact sender = new_value.getSender();
        HashWrapper originator_id = new HashWrapper(originator.getID());
        boolean direct = Arrays.equals(originator.getID(), sender.getID());
        if (direct) {
            this.addDirectValue(originator_id, new_value);
            Iterator<Map.Entry<HashWrapper, DHTDBValueImpl>> it = this.indirect_originator_value_map.entrySet().iterator();
            ArrayList<HashWrapper> to_remove = new ArrayList<HashWrapper>();
            while (it.hasNext()) {
                Map.Entry<HashWrapper, DHTDBValueImpl> entry = it.next();
                HashWrapper existing_key = entry.getKey();
                DHTDBValueImpl existing_value = entry.getValue();
                if (!Arrays.equals(existing_value.getOriginator().getID(), originator.getID())) continue;
                to_remove.add(existing_key);
            }
            for (int i = 0; i < to_remove.size(); ++i) {
                this.removeIndirectValue((HashWrapper)to_remove.get(i));
            }
        } else {
            if (this.direct_originator_map_may_be_null != null && this.direct_originator_map_may_be_null.get(originator_id) != null) {
                return;
            }
            HashWrapper originator_value_id = this.getOriginatorValueID(new_value);
            DHTDBValueImpl existing_value = this.indirect_originator_value_map.get(originator_value_id);
            if (existing_value != null) {
                this.addIndirectValue(originator_value_id, new_value);
            } else if (this.diversification_state == 1) {
                this.addIndirectValue(originator_value_id, new_value);
            }
        }
    }

    private HashWrapper getOriginatorValueID(DHTDBValueImpl value) {
        DHTTransportContact originator = value.getOriginator();
        byte[] originator_id = originator.getID();
        return new HashWrapper(originator_id);
    }

    protected void addHit() {
        ++this.hits;
    }

    protected int getHits() {
        return this.hits;
    }

    protected int getIndirectSize() {
        return this.indirect_data_size;
    }

    protected int getDirectSize() {
        return this.direct_data_size - this.local_size;
    }

    protected int getLocalSize() {
        return this.local_size;
    }

    protected DHTDBValueImpl[] get(DHTTransportContact by_who, int max, short flags) {
        if ((flags & 8) != 0) {
            if (this.adapter_key != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
                    DataOutputStream dos = new DataOutputStream(baos);
                    this.adapter_key.serialiseStats(dos);
                    dos.close();
                    return new DHTDBValueImpl[]{new DHTDBValueImpl(SystemTime.getCurrentTime(), baos.toByteArray(), 0, this.db.getLocalContact(), this.db.getLocalContact(), true, 8, 0, -1)};
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            return new DHTDBValueImpl[0];
        }
        ArrayList<DHTDBValueImpl> res = new ArrayList<DHTDBValueImpl>();
        HashSet<HashWrapper> duplicate_check = new HashSet<HashWrapper>();
        Map[] maps = new Map[]{this.direct_originator_map_may_be_null, this.indirect_originator_value_map};
        for (int i = 0; i < maps.length; ++i) {
            Map map = maps[i];
            if (map == null) continue;
            ArrayList<HashWrapper> keys_used = new ArrayList<HashWrapper>();
            Iterator it = map.entrySet().iterator();
            while (it.hasNext() && (max == 0 || res.size() < max)) {
                Map.Entry entry = it.next();
                HashWrapper entry_key = (HashWrapper)entry.getKey();
                DHTDBValueImpl entry_value = (DHTDBValueImpl)entry.getValue();
                HashWrapper x = new HashWrapper(entry_value.getValue());
                if (duplicate_check.contains(x)) continue;
                duplicate_check.add(x);
                if (entry_value.getValue().length <= 0) continue;
                res.add(entry_value);
                keys_used.add(entry_key);
            }
            for (int j = 0; j < keys_used.size(); ++j) {
                map.get(keys_used.get(j));
            }
        }
        this.informRead(by_who);
        DHTDBValueImpl[] v = new DHTDBValueImpl[res.size()];
        res.toArray(v);
        return v;
    }

    protected DHTDBValueImpl get(DHTTransportContact originator) {
        if (this.direct_originator_map_may_be_null == null) {
            return null;
        }
        HashWrapper originator_id = new HashWrapper(originator.getID());
        DHTDBValueImpl res = this.direct_originator_map_may_be_null.get(originator_id);
        return res;
    }

    protected DHTDBValueImpl getAnyValue(DHTTransportContact originator) {
        DHTDBValueImpl res = null;
        try {
            Iterator<DHTDBValueImpl> it;
            Map<HashWrapper, DHTDBValueImpl> map = this.direct_originator_map_may_be_null;
            if (map != null) {
                HashWrapper originator_id = new HashWrapper(originator.getID());
                res = map.get(originator_id);
            }
            if (res == null && (it = this.indirect_originator_value_map.values().iterator()).hasNext()) {
                res = it.next();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    protected DHTDBValueImpl remove(DHTTransportContact originator) {
        HashWrapper originator_id = new HashWrapper(originator.getID());
        DHTDBValueImpl res = this.removeDirectValue(originator_id);
        return res;
    }

    protected int getValueCount() {
        if (this.direct_originator_map_may_be_null == null) {
            return this.indirect_originator_value_map.size();
        }
        return this.direct_originator_map_may_be_null.size() + this.indirect_originator_value_map.size();
    }

    protected int getDirectValueCount() {
        if (this.direct_originator_map_may_be_null == null) {
            return 0;
        }
        return this.direct_originator_map_may_be_null.size();
    }

    protected int getIndirectValueCount() {
        return this.indirect_originator_value_map.size();
    }

    protected Iterator<DHTDBValueImpl> getValues() {
        return new valueIterator(true, true);
    }

    protected Iterator<DHTDBValueImpl> getDirectValues() {
        return new valueIterator(true, false);
    }

    protected Iterator<DHTDBValueImpl> getIndirectValues() {
        return new valueIterator(false, true);
    }

    protected byte getDiversificationType() {
        return this.diversification_state;
    }

    protected void addDirectValue(HashWrapper value_key, DHTDBValueImpl value) {
        DHTDBValueImpl old;
        if (this.direct_originator_map_may_be_null == null) {
            this.direct_originator_map_may_be_null = this.createLinkedMap();
        }
        if ((old = this.direct_originator_map_may_be_null.put(value_key, value)) != null) {
            int old_version = old.getVersion();
            int new_version = value.getVersion();
            if (old_version != -1 && new_version != -1 && old_version >= new_version) {
                if (old_version == new_version) {
                    old.reset();
                }
                this.direct_originator_map_may_be_null.put(value_key, old);
                return;
            }
            this.direct_data_size -= old.getValue().length;
            if (old.isLocal()) {
                this.local_size -= old.getValue().length;
            }
        }
        this.direct_data_size += value.getValue().length;
        if (value.isLocal()) {
            this.local_size += value.getValue().length;
        }
        if (old == null) {
            this.informAdded(value);
        } else {
            this.informUpdated(old, value);
        }
    }

    protected DHTDBValueImpl removeDirectValue(HashWrapper value_key) {
        if (this.direct_originator_map_may_be_null == null) {
            return null;
        }
        DHTDBValueImpl old = this.direct_originator_map_may_be_null.remove(value_key);
        if (old != null) {
            this.direct_data_size -= old.getValue().length;
            if (old.isLocal()) {
                this.local_size -= old.getValue().length;
            }
            this.informDeleted(old);
        }
        return old;
    }

    protected void addIndirectValue(HashWrapper value_key, DHTDBValueImpl value) {
        DHTDBValueImpl old = this.indirect_originator_value_map.put(value_key, value);
        if (old != null) {
            int old_version = old.getVersion();
            int new_version = value.getVersion();
            if (old_version != -1 && new_version != -1 && old_version >= new_version) {
                if (old_version == new_version) {
                    old.reset();
                }
                this.indirect_originator_value_map.put(value_key, old);
                return;
            }
            if ((old_version == -1 || new_version == -1) && old.getCreationTime() > value.getCreationTime() + 30000L) {
                this.indirect_originator_value_map.put(value_key, old);
                return;
            }
            this.indirect_data_size -= old.getValue().length;
            if (old.isLocal()) {
                this.local_size -= old.getValue().length;
            }
        }
        this.indirect_data_size += value.getValue().length;
        if (value.isLocal()) {
            this.local_size += value.getValue().length;
        }
        if (old == null) {
            this.informAdded(value);
        } else {
            this.informUpdated(old, value);
        }
    }

    protected DHTDBValueImpl removeIndirectValue(HashWrapper value_key) {
        DHTDBValueImpl old = this.indirect_originator_value_map.remove(value_key);
        if (old != null) {
            this.indirect_data_size -= old.getValue().length;
            if (old.isLocal()) {
                this.local_size -= old.getValue().length;
            }
            this.informDeleted(old);
        }
        return old;
    }

    protected void destroy() {
        try {
            if (this.adapter_key != null) {
                Iterator<DHTDBValueImpl> it = this.getValues();
                while (it.hasNext()) {
                    it.next();
                    it.remove();
                }
                this.db.getAdapter().keyDeleted(this.adapter_key);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private void informDeleted(DHTDBValueImpl value) {
        boolean direct;
        boolean bl = direct = !value.isLocal() && Arrays.equals(value.getOriginator().getID(), value.getSender().getID());
        if (direct) {
            this.removeFromBloom(value);
        }
        try {
            if (this.adapter_key != null) {
                this.db.getAdapter().valueDeleted(this.adapter_key, value);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private void informAdded(DHTDBValueImpl value) {
        boolean direct;
        boolean bl = direct = !value.isLocal() && Arrays.equals(value.getOriginator().getID(), value.getSender().getID());
        if (direct) {
            this.addToBloom(value);
        }
        try {
            if (this.adapter_key != null) {
                this.db.getAdapter().valueAdded(this.adapter_key, value);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private void informUpdated(DHTDBValueImpl old_value, DHTDBValueImpl new_value) {
        boolean new_direct;
        boolean old_direct = !old_value.isLocal() && Arrays.equals(old_value.getOriginator().getID(), old_value.getSender().getID());
        boolean bl = new_direct = !new_value.isLocal() && Arrays.equals(new_value.getOriginator().getID(), new_value.getSender().getID());
        if (new_direct && !old_direct) {
            this.addToBloom(new_value);
        }
        try {
            if (this.adapter_key != null) {
                this.db.getAdapter().valueUpdated(this.adapter_key, old_value, new_value);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private void informRead(DHTTransportContact contact) {
        try {
            if (this.adapter_key != null && contact != null) {
                this.db.getAdapter().keyRead(this.adapter_key, contact);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void addToBloom(DHTDBValueImpl value) {
        BloomFilter filter2;
        DHTTransportContact originator = value.getOriginator();
        byte[] bloom_key = originator.getBloomKey();
        if (this.ip_count_bloom_filter == null) {
            this.ip_count_bloom_filter = bloom_key;
            return;
        }
        if (this.ip_count_bloom_filter instanceof byte[]) {
            byte[] existing_address = (byte[])this.ip_count_bloom_filter;
            filter2 = BloomFilterFactory.createAddRemove4Bit(50);
            this.ip_count_bloom_filter = filter2;
            filter2.add(existing_address);
        } else {
            filter2 = (BloomFilter)this.ip_count_bloom_filter;
        }
        int hit_count = filter2.add(bloom_key);
        if (filter2.getSize() / filter2.getEntryCount() < 10) {
            this.rebuildIPBloomFilter(true);
        }
        if (hit_count >= 15) {
            this.db.banContact(originator, "local flood on '" + DHTLog.getFullString(this.key.getBytes()) + "'");
        }
    }

    protected void removeFromBloom(DHTDBValueImpl value) {
        DHTTransportContact originator = value.getOriginator();
        if (this.ip_count_bloom_filter == null) {
            return;
        }
        byte[] bloom_key = originator.getBloomKey();
        if (this.ip_count_bloom_filter instanceof byte[]) {
            byte[] existing_address = (byte[])this.ip_count_bloom_filter;
            if (Arrays.equals(bloom_key, existing_address)) {
                this.ip_count_bloom_filter = null;
            }
            return;
        }
        BloomFilter filter2 = (BloomFilter)this.ip_count_bloom_filter;
        int hit_count = filter2.remove(bloom_key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildIPBloomFilter(boolean increase_size) {
        int old_size = this.ip_count_bloom_filter instanceof BloomFilter ? ((BloomFilter)this.ip_count_bloom_filter).getSize() : 50;
        BloomFilter new_filter = increase_size ? BloomFilterFactory.createAddRemove4Bit(old_size + 50) : BloomFilterFactory.createAddRemove4Bit(old_size);
        try {
            Iterator<DHTDBValueImpl> it = this.getDirectValues();
            int max_hits = 0;
            while (it.hasNext()) {
                int hits;
                DHTDBValueImpl val = it.next();
                if (val.isLocal() || (hits = new_filter.add(val.getOriginator().getBloomKey())) <= max_hits) continue;
                max_hits = hits;
            }
            Object var9_8 = null;
            this.ip_count_bloom_filter = new_filter;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.ip_count_bloom_filter = new_filter;
            throw throwable;
        }
    }

    protected void print() {
        int entries = this.ip_count_bloom_filter == null ? 0 : (this.ip_count_bloom_filter instanceof byte[] ? 1 : ((BloomFilter)this.ip_count_bloom_filter).getEntryCount());
        System.out.println(ByteFormatter.encodeString(this.key.getBytes()) + ": " + "dir=" + (this.direct_originator_map_may_be_null == null ? 0 : this.direct_originator_map_may_be_null.size()) + "," + "indir=" + this.indirect_originator_value_map.size() + "," + "bloom=" + entries);
        System.out.println("    indirect");
        Iterator<DHTDBValueImpl> it = this.getIndirectValues();
        while (it.hasNext()) {
            DHTDBValueImpl val = it.next();
            System.out.println("        " + val.getOriginator().getString() + ": " + new String(val.getValue()));
        }
    }

    public static class ShortHash {
        private byte[] bytes;
        private int hash_code;

        protected ShortHash(byte[] _bytes) {
            this.bytes = _bytes;
            int hc = 0;
            for (int i = 0; i < 6; ++i) {
                hc = 31 * hc + this.bytes[i];
            }
            this.hash_code = hc;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof ShortHash)) {
                return false;
            }
            ShortHash other = (ShortHash)o;
            byte[] other_hash = other.bytes;
            for (int i = 0; i < 6; ++i) {
                if (this.bytes[i] == other_hash[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hash_code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class valueIterator
    implements Iterator<DHTDBValueImpl> {
        private List<Map<HashWrapper, DHTDBValueImpl>> maps = new ArrayList<Map<HashWrapper, DHTDBValueImpl>>(2);
        private int map_index = 0;
        private Map<HashWrapper, DHTDBValueImpl> map;
        private Iterator<DHTDBValueImpl> it;
        private DHTDBValueImpl value;

        protected valueIterator(boolean direct, boolean indirect) {
            if (direct && DHTDBMapping.this.direct_originator_map_may_be_null != null) {
                this.maps.add(DHTDBMapping.this.direct_originator_map_may_be_null);
            }
            if (indirect) {
                this.maps.add(DHTDBMapping.this.indirect_originator_value_map);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.it != null && this.it.hasNext()) {
                return true;
            }
            while (this.map_index < this.maps.size()) {
                this.map = this.maps.get(this.map_index++);
                this.it = this.map.values().iterator();
                if (!this.it.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public DHTDBValueImpl next() {
            if (this.hasNext()) {
                this.value = this.it.next();
                return this.value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.it == null) {
                throw new IllegalStateException();
            }
            if (this.value != null) {
                if (this.value.isLocal()) {
                    DHTDBMapping.this.local_size -= this.value.getValue().length;
                }
                if (this.map == DHTDBMapping.this.indirect_originator_value_map) {
                    DHTDBMapping.this.indirect_data_size -= this.value.getValue().length;
                } else {
                    DHTDBMapping.this.direct_data_size -= this.value.getValue().length;
                }
            } else {
                throw new IllegalStateException();
            }
            this.it.remove();
            DHTDBMapping.this.informDeleted(this.value);
            this.value = null;
        }
    }
}

