/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportAlternativeContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportAlternativeNetwork;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTTransportAlternativeNetworkImpl
implements DHTTransportAlternativeNetwork {
    private static final int LIVE_AGE_SECS = 1200;
    private static final int LIVEISH_AGE_SECS = 2400;
    private static final int MAX_CONTACTS_PUB = 64;
    private static final int MAX_CONTACTS_I2P = 16;
    private static final boolean TRACE = false;
    private int network;
    private final int max_contacts;
    private TreeSet<DHTTransportAlternativeContact> contacts = new TreeSet<DHTTransportAlternativeContact>(new Comparator<DHTTransportAlternativeContact>(){

        @Override
        public int compare(DHTTransportAlternativeContact o1, DHTTransportAlternativeContact o2) {
            int res = o1.getAge() - o2.getAge();
            if (res == 0) {
                res = o1.getID() - o2.getID();
            }
            return res;
        }
    });

    protected DHTTransportAlternativeNetworkImpl(int _net) {
        this.network = _net;
        this.max_contacts = this.network == 3 ? 16 : 64;
    }

    @Override
    public int getNetworkType() {
        return this.network;
    }

    @Override
    public List<DHTTransportAlternativeContact> getContacts(int max) {
        return this.getContacts(max, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DHTTransportAlternativeContact> getContacts(int max, boolean live_only) {
        if (max == 0) {
            max = this.max_contacts;
        }
        ArrayList<DHTTransportAlternativeContact> result = new ArrayList<DHTTransportAlternativeContact>(max);
        HashSet<Integer> used_ids = new HashSet<Integer>();
        TreeSet<DHTTransportAlternativeContact> treeSet = this.contacts;
        synchronized (treeSet) {
            for (DHTTransportAlternativeContact contact : this.contacts) {
                if (live_only && contact.getAge() > 2400) break;
                Integer id = contact.getID();
                if (used_ids.contains(id)) continue;
                used_ids.add(id);
                result.add(contact);
                if (result.size() != max) continue;
                break;
            }
        }
        return result;
    }

    private void trim() {
        Iterator<DHTTransportAlternativeContact> it = this.contacts.iterator();
        int pos = 0;
        while (it.hasNext()) {
            it.next();
            if (++pos <= this.max_contacts) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContactsForSend(List<DHTTransportAlternativeContact> new_contacts) {
        TreeSet<DHTTransportAlternativeContact> treeSet = this.contacts;
        synchronized (treeSet) {
            for (DHTTransportAlternativeContact new_contact : new_contacts) {
                this.contacts.add(new_contact);
            }
            if (this.contacts.size() > this.max_contacts) {
                this.trim();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContactFromReply(DHTTransportAlternativeContact new_contact) {
        TreeSet<DHTTransportAlternativeContact> treeSet = this.contacts;
        synchronized (treeSet) {
            this.contacts.add(new_contact);
            if (this.contacts.size() > this.max_contacts) {
                this.trim();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRequiredContactCount() {
        TreeSet<DHTTransportAlternativeContact> treeSet = this.contacts;
        synchronized (treeSet) {
            int num_contacts = this.contacts.size();
            int result = 0;
            if (num_contacts < this.max_contacts) {
                result = this.max_contacts - num_contacts;
            } else {
                Iterator<DHTTransportAlternativeContact> it = this.contacts.iterator();
                int pos = 0;
                while (it.hasNext()) {
                    DHTTransportAlternativeContact contact = it.next();
                    if (contact.getAge() > 1200) {
                        result = this.max_contacts - pos;
                        break;
                    }
                    ++pos;
                }
            }
            return result;
        }
    }

    private String getString(DHTTransportAlternativeContact contact) {
        return contact.getProperties() + ", age=" + contact.getAge();
    }
}

