/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreLifecycleListener;
import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationListener;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.backup.BackupManagerFactory;
import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTListener;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerAdapter;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerFactory;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.nat.NATTraverser;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.pairing.PairingManagerFactory;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.nat.PeerNATTraverser;
import com.aelitis.azureus.core.proxy.AEProxySelectorFactory;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.speedmanager.SpeedLimitHandler;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerAdapter;
import com.aelitis.azureus.core.speedmanager.SpeedManagerFactory;
import com.aelitis.azureus.core.update.AzureusRestarterFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import com.aelitis.azureus.launcher.classloading.PrimaryClassloader;
import com.aelitis.azureus.plugins.clientid.ClientIDPlugin;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.DefaultRankCalculator;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerFactory;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.GlobalMangerProgressListener;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.PlatformManagerListener;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.PowerManagementListener;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class AzureusCoreImpl
implements AzureusCore {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected static AzureusCore singleton;
    protected static AEMonitor class_mon;
    private static final String DM_ANNOUNCE_KEY = "AzureusCore:announce_key";
    private static final boolean LOAD_PLUGINS_IN_OTHER_THREAD = true;
    static List<AzureusCoreRunningListener> coreRunningListeners;
    static AEMonitor mon_coreRunningListeners;
    private PluginInitializer pi;
    private GlobalManager global_manager;
    private AZInstanceManager instance_manager;
    private SpeedManager speed_manager;
    private CryptoManager crypto_manager;
    private NATTraverser nat_traverser;
    private final long create_time;
    private volatile boolean started;
    private volatile boolean stopped;
    private volatile boolean restarting;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private CopyOnWriteList lifecycle_listeners = new CopyOnWriteList();
    private List operation_listeners = new ArrayList();
    private CopyOnWriteList<PowerManagementListener> power_listeners = new CopyOnWriteList();
    private AESemaphore stopping_sem = new AESemaphore("AzureusCore::stopping");
    private AEMonitor this_mon = new AEMonitor("AzureusCore");
    private AzureusCoreOperation initialisation_op = this.createOperation(1);
    public static boolean SUPPRESS_CLASSLOADER_ERRORS;
    private boolean ca_shutdown_computer_after_stop = false;
    private long ca_last_time_downloading = -1L;
    private long ca_last_time_seeding = -1L;
    private boolean prevent_sleep_remove_trigger = false;
    private FileLock file_lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AzureusCore create() throws AzureusCoreException {
        try {
            class_mon.enter();
            if (singleton != null) {
                throw new AzureusCoreException("Azureus core already instantiated");
            }
            AzureusCore azureusCore = singleton = new AzureusCoreImpl();
            Object var2_1 = null;
            class_mon.exit();
            return azureusCore;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    public static boolean isCoreAvailable() {
        return singleton != null;
    }

    public static boolean isCoreRunning() {
        return singleton != null && singleton.isStarted();
    }

    public static AzureusCore getSingleton() throws AzureusCoreException {
        if (singleton == null) {
            throw new AzureusCoreException("core not instantiated");
        }
        return singleton;
    }

    protected AzureusCoreImpl() {
        this.create_time = SystemTime.getCurrentTime();
        if (!SUPPRESS_CLASSLOADER_ERRORS && !(this.getClass().getClassLoader() instanceof PrimaryClassloader)) {
            System.out.println("###\nWarning: Core not instantiated through a PrimaryClassloader, this can lead to restricted functionality or bugs in future versions\n###");
        }
        COConfigurationManager.initialise();
        MessageText.loadBundle();
        AEDiagnostics.startup(COConfigurationManager.getBooleanParameter("diags.enable.pending.writes", false));
        COConfigurationManager.setParameter("diags.enable.pending.writes", false);
        AEDiagnostics.markDirty();
        AETemporaryFileHandler.startup();
        AEThread2.setOurThread();
        COConfigurationManager.setParameter("azureus.application.directory", new File(SystemProperties.getApplicationPath()).getAbsolutePath());
        COConfigurationManager.setParameter("azureus.user.directory", new File(SystemProperties.getUserPath()).getAbsolutePath());
        this.crypto_manager = CryptoManagerFactory.getSingleton();
        PlatformManagerFactory.getPlatformManager().addListener(new PlatformManagerListener(){

            public int eventOccurred(int type) {
                if (type == 1) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Platform manager requested shutdown"));
                    }
                    COConfigurationManager.save();
                    AzureusCoreImpl.this.requestStop();
                    return 0;
                }
                if (type == 2) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Platform manager requested suspend"));
                    }
                    COConfigurationManager.save();
                } else if (type == 3) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Platform manager requested resume"));
                    }
                    AzureusCoreImpl.this.announceAll(true);
                }
                return -1;
            }
        });
        CustomizationManagerFactory.getSingleton().initialize();
        AEProxySelectorFactory.getSelector();
        NetworkManager.getSingleton();
        PeerManager.getSingleton();
        ClientIDPlugin.initialize();
        this.pi = PluginInitializer.getSingleton(this, this.initialisation_op);
        this.instance_manager = AZInstanceManagerFactory.getSingleton(new AZInstanceManagerAdapter(){

            public String getID() {
                return COConfigurationManager.getStringParameter("ID", "");
            }

            public InetAddress getPublicAddress() {
                return PluginInitializer.getDefaultInterface().getUtilities().getPublicAddress();
            }

            public int[] getPorts() {
                return new int[]{TCPNetworkManager.getSingleton().getTCPListeningPortNumber(), UDPNetworkManager.getSingleton().getUDPListeningPortNumber(), UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber()};
            }

            public AZInstanceManagerAdapter.VCPublicAddress getVCPublicAddress() {
                return new AZInstanceManagerAdapter.VCPublicAddress(){
                    private VersionCheckClient vcc = VersionCheckClient.getSingleton();

                    public String getAddress() {
                        return this.vcc.getExternalIpAddress(true, false);
                    }

                    public long getCacheTime() {
                        1 v0 = this;
                        return v0.vcc.getSingleton().getCacheTime(false);
                    }
                };
            }

            public AZInstanceTracked.TrackTarget track(byte[] hash) {
                List<DownloadManager> dms = AzureusCoreImpl.this.getGlobalManager().getDownloadManagers();
                Iterator<DownloadManager> it = dms.iterator();
                DownloadManager matching_dm = null;
                try {
                    while (it.hasNext()) {
                        DownloadManager dm = it.next();
                        TOTorrent torrent = dm.getTorrent();
                        if (torrent == null) continue;
                        byte[] sha1_hash = (byte[])dm.getData("AZInstanceManager::sha1_hash");
                        if (sha1_hash == null) {
                            sha1_hash = new SHA1Simple().calculateHash(torrent.getHash());
                            dm.setData("AZInstanceManager::sha1_hash", sha1_hash);
                        }
                        if (!Arrays.equals(hash, sha1_hash)) continue;
                        matching_dm = dm;
                        break;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                if (matching_dm == null) {
                    return null;
                }
                if (!matching_dm.getDownloadState().isPeerSourceEnabled("Plugin")) {
                    return null;
                }
                int dm_state = matching_dm.getState();
                if (dm_state == 100 || dm_state == 70) {
                    return null;
                }
                try {
                    final DownloadImpl target = DownloadManagerImpl.getDownloadStatic(matching_dm);
                    final boolean is_seed = matching_dm.isDownloadComplete(true);
                    return new AZInstanceTracked.TrackTarget(){

                        public Object getTarget() {
                            return target;
                        }

                        public boolean isSeed() {
                            return is_seed;
                        }
                    };
                }
                catch (Throwable e) {
                    return null;
                }
            }

            public DHTPlugin getDHTPlugin() {
                PluginInterface pi = AzureusCoreImpl.this.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                if (pi != null) {
                    return (DHTPlugin)pi.getPlugin();
                }
                return null;
            }

            public UPnPPlugin getUPnPPlugin() {
                PluginInterface pi = AzureusCoreImpl.this.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                if (pi != null) {
                    return (UPnPPlugin)pi.getPlugin();
                }
                return null;
            }

            public void addListener(final AZInstanceManagerAdapter.StateListener listener) {
                AzureusCoreImpl.this.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                    public void started(AzureusCore core) {
                        listener.started();
                    }

                    public void stopping(AzureusCore core) {
                        listener.stopped();
                    }
                });
            }
        });
        if (COConfigurationManager.getBooleanParameter("speedmanager.enable", true)) {
            this.speed_manager = SpeedManagerFactory.createSpeedManager(this, new SpeedManagerAdapter(){
                private static final int UPLOAD_SPEED_ADJUST_MIN_KB_SEC = 10;
                private static final int DOWNLOAD_SPEED_ADJUST_MIN_KB_SEC = 300;
                private boolean setting_limits;

                public int getCurrentProtocolUploadSpeed(int average_period) {
                    if (AzureusCoreImpl.this.global_manager != null) {
                        GlobalManagerStats stats2 = AzureusCoreImpl.this.global_manager.getStats();
                        return stats2.getProtocolSendRateNoLAN(average_period);
                    }
                    return 0;
                }

                public int getCurrentDataUploadSpeed(int average_period) {
                    if (AzureusCoreImpl.this.global_manager != null) {
                        GlobalManagerStats stats2 = AzureusCoreImpl.this.global_manager.getStats();
                        return stats2.getDataSendRateNoLAN(average_period);
                    }
                    return 0;
                }

                public int getCurrentProtocolDownloadSpeed(int average_period) {
                    if (AzureusCoreImpl.this.global_manager != null) {
                        GlobalManagerStats stats2 = AzureusCoreImpl.this.global_manager.getStats();
                        return stats2.getProtocolReceiveRateNoLAN(average_period);
                    }
                    return 0;
                }

                public int getCurrentDataDownloadSpeed(int average_period) {
                    if (AzureusCoreImpl.this.global_manager != null) {
                        GlobalManagerStats stats2 = AzureusCoreImpl.this.global_manager.getStats();
                        return stats2.getDataReceiveRateNoLAN(average_period);
                    }
                    return 0;
                }

                public int getCurrentUploadLimit() {
                    String key = TransferSpeedValidator.getActiveUploadParameter(AzureusCoreImpl.this.global_manager);
                    int k_per_second = COConfigurationManager.getIntParameter(key);
                    int bytes_per_second = k_per_second == 0 ? Integer.MAX_VALUE : k_per_second * 1024;
                    return bytes_per_second;
                }

                public void setCurrentUploadLimit(int bytes_per_second) {
                    if (bytes_per_second != this.getCurrentUploadLimit()) {
                        String key = TransferSpeedValidator.getActiveUploadParameter(AzureusCoreImpl.this.global_manager);
                        int k_per_second = bytes_per_second == Integer.MAX_VALUE ? 0 : (bytes_per_second + 1023) / 1024;
                        if (k_per_second > 0) {
                            k_per_second = Math.max(k_per_second, 10);
                        }
                        COConfigurationManager.setParameter(key, k_per_second);
                    }
                }

                public int getCurrentDownloadLimit() {
                    return TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond();
                }

                public void setCurrentDownloadLimit(int bytes_per_second) {
                    if (bytes_per_second == Integer.MAX_VALUE) {
                        bytes_per_second = 0;
                    }
                    if (bytes_per_second > 0) {
                        bytes_per_second = Math.max(bytes_per_second, 307200);
                    }
                    TransferSpeedValidator.setGlobalDownloadRateLimitBytesPerSecond(bytes_per_second);
                }

                public Object getLimits() {
                    String up_key = TransferSpeedValidator.getActiveUploadParameter(AzureusCoreImpl.this.global_manager);
                    String down_key = TransferSpeedValidator.getDownloadParameter();
                    return new Object[]{up_key, new Integer(COConfigurationManager.getIntParameter(up_key)), down_key, new Integer(COConfigurationManager.getIntParameter(down_key))};
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setLimits(Object limits, boolean do_up, boolean do_down) {
                    if (limits == null) {
                        return;
                    }
                    try {
                        if (this.setting_limits) {
                            Object var6_4 = null;
                            this.setting_limits = false;
                            return;
                        }
                        this.setting_limits = true;
                        Object[] bits = (Object[])limits;
                        if (do_up) {
                            COConfigurationManager.setParameter((String)bits[0], (Integer)bits[1]);
                        }
                        if (do_down) {
                            COConfigurationManager.setParameter((String)bits[2], (Integer)bits[3]);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.setting_limits = false;
                        throw throwable;
                    }
                    Object var6_5 = null;
                    this.setting_limits = false;
                }
            });
        }
        this.nat_traverser = new NATTraverser(this);
        PeerNATTraverser.initialise(this);
        BackupManagerFactory.getManager(this);
        SimpleTimer.addEvent("AzureusCore:gc", SystemTime.getOffsetTime(60000L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                System.gc();
            }
        });
    }

    public long getCreateTime() {
        return this.create_time;
    }

    protected void announceAll(boolean force) {
        PluginInterface dht_tracker_pi;
        Logger.log(new LogEvent(LOGID, "Updating trackers"));
        GlobalManager gm = this.getGlobalManager();
        if (gm != null) {
            List<DownloadManager> downloads = gm.getDownloadManagers();
            long now = SystemTime.getCurrentTime();
            for (int i = 0; i < downloads.size(); ++i) {
                DownloadManager dm = downloads.get(i);
                Long last_announce_l = (Long)dm.getUserData(DM_ANNOUNCE_KEY);
                long last_announce = last_announce_l == null ? this.create_time : last_announce_l;
                TRTrackerAnnouncer an = dm.getTrackerClient();
                if (an == null) continue;
                TRTrackerAnnouncerResponse last_announce_response = an.getLastResponse();
                if (now - last_announce <= 900000L && last_announce_response != null && last_announce_response.getStatus() != 0 && !force) continue;
                dm.setUserData(DM_ANNOUNCE_KEY, new Long(now));
                Logger.log(new LogEvent(LOGID, "    updating tracker for " + dm.getDisplayName()));
                dm.requestTrackerAnnounce(true);
            }
        }
        if ((dht_tracker_pi = this.getPluginManager().getPluginInterfaceByClass(DHTTrackerPlugin.class)) != null) {
            ((DHTTrackerPlugin)dht_tracker_pi.getPlugin()).announceAll();
        }
    }

    public LocaleUtil getLocaleUtil() {
        return LocaleUtil.getSingleton();
    }

    public File getLockFile() {
        return new File(SystemProperties.getUserPath(), ".azlock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canStart() {
        if (System.getProperty("azureus.instance.lock.disable", "0").equals("1")) {
            return true;
        }
        AzureusCoreImpl azureusCoreImpl = this;
        synchronized (azureusCoreImpl) {
            if (this.file_lock != null) {
                return true;
            }
            File lock_file = this.getLockFile();
            try {
                RandomAccessFile raf = new RandomAccessFile(lock_file, "rw");
                FileChannel channel2 = raf.getChannel();
                for (int i = 0; i < 15; ++i) {
                    this.file_lock = channel2.tryLock();
                    if (this.file_lock != null) {
                        return true;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws AzureusCoreException {
        AzureusCoreRunningListener[] runningListeners;
        String sDelayCore;
        if (!this.canStart()) {
            throw new AzureusCoreException("Core: already started (alternative process)");
        }
        AEThread2.setOurThread();
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new AzureusCoreException("Core: already started");
            }
            if (this.stopped) {
                throw new AzureusCoreException("Core: already stopped");
            }
            this.started = true;
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if ("1".equals(System.getProperty("azureus.safemode"))) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Safe mode enabled"));
            }
            Constants.isSafeMode = true;
            System.setProperty("azureus.loadplugins", "0");
            System.setProperty("azureus.disabledownloads", "1");
            System.setProperty("azureus.skipSWTcheck", "1");
            Logger.log(new LogAlert(false, 1, "You are running " + Constants.APP_NAME + " in safe mode - you " + "can change your configuration, but any downloads added will " + "not be remembered when you close " + Constants.APP_NAME + "."));
        }
        if ((sDelayCore = System.getProperty("delay.core", null)) != null) {
            try {
                long delayCore = Long.parseLong(sDelayCore);
                Thread.sleep(delayCore);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        AEThread2 pluginload = new AEThread2("PluginLoader", true){

            public void run() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Loading of Plugins starts"));
                }
                AzureusCoreImpl.this.pi.loadPlugins(AzureusCoreImpl.this, false, !"0".equals(System.getProperty("azureus.loadplugins")), true, true);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Loading of Plugins complete"));
                }
            }
        };
        pluginload.start();
        this.global_manager = GlobalManagerFactory.create(this, new GlobalMangerProgressListener(){

            public void reportCurrentTask(String currentTask) {
                AzureusCoreImpl.this.initialisation_op.reportCurrentTask(currentTask);
            }

            public void reportPercent(int percent) {
                AzureusCoreImpl.this.initialisation_op.reportPercent(percent);
            }
        }, 0L);
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        pluginload.join();
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            public void process(VuzeFile[] files, int expected_types) {
                for (int i = 0; i < files.length; ++i) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    for (int j = 0; j < comps.length; ++j) {
                        VuzeFileComponent comp2 = comps[j];
                        int comp_type = comp2.getType();
                        if (comp_type != 2048) continue;
                        PluginInterface default_pi = AzureusCoreImpl.this.getPluginManager().getDefaultPluginInterface();
                        Map map = comp2.getContent();
                        try {
                            Torrent torrent;
                            String url = MapUtils.getMapString(map, "torrent_url", null);
                            if (url != null) {
                                TorrentDownloader dl = default_pi.getTorrentManager().getURLDownloader(new URL(url));
                                torrent = dl.download();
                            } else {
                                String tf = MapUtils.getMapString(map, "torrent_file", null);
                                if (tf != null) {
                                    File file = new File(tf);
                                    if (!file.canRead() || file.isDirectory()) {
                                        throw new Exception("torrent_file '" + tf + "' is invalid");
                                    }
                                    torrent = default_pi.getTorrentManager().createFromBEncodedFile(file);
                                } else {
                                    throw new Exception("torrent_url or torrent_file must be specified");
                                }
                            }
                            File dest = null;
                            String save_folder = MapUtils.getMapString(map, "save_folder", null);
                            if (save_folder != null) {
                                dest = new File(save_folder, torrent.getName());
                            } else {
                                String save_file = MapUtils.getMapString(map, "save_file", null);
                                if (save_file != null) {
                                    dest = new File(save_file);
                                }
                            }
                            if (dest != null) {
                                dest.getParentFile().mkdirs();
                            }
                            default_pi.getDownloadManager().addDownload(torrent, null, dest);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        comp2.setProcessed();
                    }
                }
            }
        });
        this.triggerLifeCycleComponentCreated(this.global_manager);
        this.pi.initialisePlugins();
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Initializing Plugins complete"));
        }
        try {
            PluginInterface dht_pi = this.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi != null) {
                dht_pi.addEventListener(new PluginEventListener(){
                    private boolean first_dht = true;

                    public void handleEvent(PluginEvent ev) {
                        if (ev.getType() == 1024 && this.first_dht) {
                            this.first_dht = false;
                            DHT dht = (DHT)ev.getValue();
                            dht.addListener(new DHTListener(){

                                public void speedTesterAvailable(DHTSpeedTester tester) {
                                    if (AzureusCoreImpl.this.speed_manager != null) {
                                        AzureusCoreImpl.this.speed_manager.setSpeedTester(tester);
                                    }
                                }
                            });
                            AzureusCoreImpl.this.global_manager.addListener(new GlobalManagerAdapter(){

                                public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
                                    this.checkConfig();
                                }
                            });
                            COConfigurationManager.addAndFireParameterListeners(new String[]{"Auto Upload Speed Enabled", "Auto Upload Speed Seeding Enabled"}, new ParameterListener(){

                                public void parameterChanged(String parameterName) {
                                    this.checkConfig();
                                }
                            });
                        }
                    }

                    protected void checkConfig() {
                        if (AzureusCoreImpl.this.speed_manager != null) {
                            AzureusCoreImpl.this.speed_manager.setEnabled(TransferSpeedValidator.isAutoSpeedActive(AzureusCoreImpl.this.global_manager));
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (COConfigurationManager.getBooleanParameter("Resume Downloads On Start")) {
            this.global_manager.resumeDownloads();
        }
        VersionCheckClient.getSingleton().initialise();
        this.instance_manager.initialize();
        NetworkManager.getSingleton().initialize(this);
        SpeedLimitHandler.getSingleton(this);
        Runtime.getRuntime().addShutdownHook(new AEThread("Shutdown Hook"){

            public void runSupport() {
                Logger.log(new LogEvent(LOGID, "Shutdown hook triggered"));
                AzureusCoreImpl.this.stop();
            }
        });
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("Core", new Runnable(){

            public void run() {
                new AEThread2("core:delayTask", true){

                    public void run() {
                        AEDiagnostics.checkDumpsAndNatives();
                        COConfigurationManager.setParameter("diags.enable.pending.writes", true);
                        AEDiagnostics.flushPendingLogs();
                        NetworkAdmin na = NetworkAdmin.getSingleton();
                        na.runInitialChecks(AzureusCoreImpl.this);
                        na.addPropertyChangeListener(new NetworkAdminPropertyChangeListener(){
                            private String last_as;

                            public void propertyChanged(String property) {
                                NetworkAdmin na = NetworkAdmin.getSingleton();
                                if (property.equals("Network Interfaces")) {
                                    boolean found_usable = false;
                                    NetworkAdminNetworkInterface[] intf = na.getInterfaces();
                                    for (int i = 0; i < intf.length; ++i) {
                                        NetworkAdminNetworkInterfaceAddress[] addresses = intf[i].getAddresses();
                                        for (int j = 0; j < addresses.length; ++j) {
                                            if (addresses[j].isLoopback()) continue;
                                            found_usable = true;
                                        }
                                    }
                                    if (!found_usable) {
                                        return;
                                    }
                                    Logger.log(new LogEvent(LOGID, "Network interfaces have changed (new=" + na.getNetworkInterfacesAsString() + ")"));
                                    AzureusCoreImpl.this.announceAll(false);
                                } else if (property.equals("AS")) {
                                    String as = na.getCurrentASN().getAS();
                                    if (this.last_as == null) {
                                        this.last_as = as;
                                    } else if (!as.equals(this.last_as)) {
                                        Logger.log(new LogEvent(LOGID, "AS has changed (new=" + as + ")"));
                                        this.last_as = as;
                                        AzureusCoreImpl.this.announceAll(false);
                                    }
                                }
                            }
                        });
                        AzureusCoreImpl.this.setupSleepAndCloseActions();
                    }
                }.start();
            }
        });
        delayed_task.queue();
        if (this.stopped) {
            System.err.println("Core stopped while starting");
            return;
        }
        PairingManagerFactory.getSingleton();
        mon_coreRunningListeners.enter();
        try {
            if (coreRunningListeners == null) {
                runningListeners = new AzureusCoreRunningListener[]{};
            } else {
                runningListeners = coreRunningListeners.toArray(new AzureusCoreRunningListener[0]);
                coreRunningListeners = null;
            }
            Object var6_10 = null;
            mon_coreRunningListeners.exit();
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            mon_coreRunningListeners.exit();
            throw throwable;
        }
        new AEThread2("Plugin Init Complete", false){

            public void run() {
                AzureusCoreLifecycleListener listener;
                try {
                    PlatformManagerFactory.getPlatformManager().startup(AzureusCoreImpl.this);
                }
                catch (Throwable e) {
                    Debug.out("PlatformManager: init failed", e);
                }
                Iterator it = AzureusCoreImpl.this.lifecycle_listeners.iterator();
                while (it.hasNext()) {
                    try {
                        listener = (AzureusCoreLifecycleListener)it.next();
                        if (listener.requiresPluginInitCompleteBeforeStartedEvent()) continue;
                        listener.started(AzureusCoreImpl.this);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                AzureusCoreImpl.this.pi.initialisationComplete();
                it = AzureusCoreImpl.this.lifecycle_listeners.iterator();
                while (it.hasNext()) {
                    try {
                        listener = (AzureusCoreLifecycleListener)it.next();
                        if (!listener.requiresPluginInitCompleteBeforeStartedEvent()) continue;
                        listener.started(AzureusCoreImpl.this);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }.start();
        ThreadPool tp2 = new ThreadPool("Trigger AzureusCoreRunning Listeners", 3);
        for (final AzureusCoreRunningListener l : runningListeners) {
            try {
                tp2.run(new AERunnable(){

                    public void runSupport() {
                        l.azureusCoreRunning(AzureusCoreImpl.this);
                    }
                });
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
    }

    public boolean isInitThread() {
        return AEThread2.isOurThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        mon_coreRunningListeners.enter();
        try {
            boolean bl = this.started && coreRunningListeners == null;
            Object var3_2 = null;
            mon_coreRunningListeners.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            mon_coreRunningListeners.exit();
            throw throwable;
        }
    }

    public void triggerLifeCycleComponentCreated(AzureusCoreComponent component) {
        Iterator it = this.lifecycle_listeners.iterator();
        while (it.hasNext()) {
            try {
                ((AzureusCoreLifecycleListener)it.next()).componentCreated(this, component);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void runNonDaemon(final Runnable r) throws AzureusCoreException {
        if (!Thread.currentThread().isDaemon()) {
            r.run();
        } else {
            final AESemaphore sem = new AESemaphore("AzureusCore:runNonDaemon");
            final Throwable[] error = new Throwable[]{null};
            new AEThread2("AzureusCore:runNonDaemon", false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        try {
                            r.run();
                        }
                        catch (Throwable e) {
                            error[0] = e;
                            Object var3_2 = null;
                            sem.release();
                        }
                        Object var3_1 = null;
                        sem.release();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        sem.release();
                        throw throwable;
                    }
                }
            }.start();
            sem.reserve();
            if (error[0] != null) {
                if (error[0] instanceof AzureusCoreException) {
                    throw (AzureusCoreException)error[0];
                }
                throw new AzureusCoreException("Operation failed", error[0]);
            }
        }
    }

    public void stop() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Stop operation starts"));
                }
                AzureusCoreImpl.this.stopSupport(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSupport(boolean apply_updates) throws AzureusCoreException {
        AEDiagnostics.flushPendingLogs();
        boolean wait_and_return = false;
        try {
            this.this_mon.enter();
            if (this.stopped) {
                COConfigurationManager.save();
                wait_and_return = true;
            } else {
                this.stopped = true;
                if (!this.started) {
                    Logger.log(new LogEvent(LOGID, "Core not started"));
                    if (AEDiagnostics.isDirty()) {
                        AEDiagnostics.markClean();
                    }
                    this.stopping_sem.releaseForever();
                    Object var4_3 = null;
                    this.this_mon.exit();
                    return;
                }
            }
            Object var4_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (wait_and_return) {
            Logger.log(new LogEvent(LOGID, "Waiting for stop to complete"));
            this.stopping_sem.reserve();
            return;
        }
        SimpleTimer.addEvent("ShutFail", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){
            boolean die_die_die;

            public void perform(TimerEvent event2) {
                AEDiagnostics.dumpThreads();
                if (this.die_die_die) {
                    Debug.out("Shutdown blocked, force exiting");
                    AzureusCoreImpl.this.stopping_sem.releaseForever();
                    SESecurityManager.exitVM(0);
                }
                this.die_die_die = true;
                SimpleTimer.addEvent("ShutFail", SystemTime.getOffsetTime(30000L), this);
            }
        });
        ArrayList<AzureusCoreLifecycleListener> sync_listeners = new ArrayList<AzureusCoreLifecycleListener>();
        ArrayList<AzureusCoreLifecycleListener> async_listeners = new ArrayList<AzureusCoreLifecycleListener>();
        for (AzureusCoreLifecycleListener l : this.lifecycle_listeners) {
            if (l.syncInvokeRequired()) {
                sync_listeners.add(l);
                continue;
            }
            async_listeners.add(l);
        }
        try {
            int i;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Invoking synchronous 'stopping' listeners"));
            }
            for (i = 0; i < sync_listeners.size(); ++i) {
                try {
                    ((AzureusCoreLifecycleListener)sync_listeners.get(i)).stopping(this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Invoking asynchronous 'stopping' listeners"));
            }
            ListenerManager.dispatchWithTimeout(async_listeners, new ListenerManagerDispatcher(){

                public void dispatch(Object listener, int type, Object value) {
                    ((AzureusCoreLifecycleListener)listener).stopping(AzureusCoreImpl.this);
                }
            }, 10000L);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Stopping global manager"));
            }
            if (this.global_manager != null) {
                this.global_manager.stopGlobalManager();
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Invoking synchronous 'stopped' listeners"));
            }
            for (i = 0; i < sync_listeners.size(); ++i) {
                try {
                    ((AzureusCoreLifecycleListener)sync_listeners.get(i)).stopped(this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Invoking asynchronous 'stopped' listeners"));
            }
            ListenerManager.dispatchWithTimeout(async_listeners, new ListenerManagerDispatcher(){

                public void dispatch(Object listener, int type, Object value) {
                    ((AzureusCoreLifecycleListener)listener).stopped(AzureusCoreImpl.this);
                }
            }, 10000L);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Waiting for quiescence"));
            }
            NonDaemonTaskRunner.waitUntilIdle();
            AEDiagnostics.markClean();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Stop operation completes"));
            }
            if (apply_updates && this.getPluginManager().getDefaultPluginInterface().getUpdateManager().getInstallers().length > 0) {
                AzureusRestarterFactory.create(this).restart(true);
            }
            try {
                Class<?> c = Class.forName("sun.awt.AWTAutoShutdown");
                if (c != null) {
                    c.getMethod("notifyToolkitThreadFree", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (this.ca_shutdown_computer_after_stop) {
                if (apply_updates) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                try {
                    PlatformManagerFactory.getPlatformManager().shutdown(1);
                }
                catch (Throwable e) {
                    Debug.out("PlatformManager: shutdown failed", e);
                }
            }
            try {
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                while (tg.getParent() != null) {
                    tg = tg.getParent();
                }
                Thread[] threads = new Thread[tg.activeCount() + 1024];
                tg.enumerate(threads, true);
                boolean bad_found = false;
                for (int i2 = 0; i2 < threads.length; ++i2) {
                    Thread t = threads[i2];
                    if (t == null || !t.isAlive() || t == Thread.currentThread() || t.isDaemon() || AEThread2.isOurThread(t)) continue;
                    bad_found = true;
                    break;
                }
                if (bad_found) {
                    new AEThread2("VMKiller", true){

                        public void run() {
                            try {
                                Thread.sleep(10000L);
                                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                                Thread[] threads = new Thread[tg.activeCount() + 1024];
                                tg.enumerate(threads, true);
                                String bad_found = "";
                                for (int i = 0; i < threads.length; ++i) {
                                    Thread t = threads[i];
                                    if (t == null || !t.isAlive() || t.isDaemon() || AEThread2.isOurThread(t)) continue;
                                    String details = t.getName();
                                    StackTraceElement[] trace = t.getStackTrace();
                                    if (trace.length > 0) {
                                        details = details + "[";
                                        for (int j = 0; j < trace.length; ++j) {
                                            details = details + (j == 0 ? "" : ",") + trace[j];
                                        }
                                        details = details + "]";
                                    }
                                    bad_found = bad_found + (bad_found.length() == 0 ? "" : ", ") + details;
                                }
                                Debug.out("Non-daemon thread(s) found: '" + bad_found + "' - force closing VM");
                                SESecurityManager.exitVM(0);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
            }
            catch (Throwable e) {
            }
            Object var12_22 = null;
            this.stopping_sem.releaseForever();
        }
        catch (Throwable throwable) {
            Object var12_23 = null;
            this.stopping_sem.releaseForever();
            throw throwable;
        }
    }

    public void requestStop() throws AzureusCoreException {
        if (this.stopped) {
            return;
        }
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                Iterator it = AzureusCoreImpl.this.lifecycle_listeners.iterator();
                while (it.hasNext()) {
                    if (((AzureusCoreLifecycleListener)it.next()).stopRequested(AzureusCoreImpl.this)) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Request to stop the core has been denied"));
                    }
                    return;
                }
                AzureusCoreImpl.this.stop();
            }
        });
    }

    public void restart() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Restart operation starts"));
                }
                AzureusCoreImpl.this.checkRestartSupported();
                AzureusCoreImpl.this.restarting = true;
                AzureusCoreImpl.this.stopSupport(false);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Restart operation: stop complete,restart initiated"));
                }
                AzureusRestarterFactory.create(AzureusCoreImpl.this).restart(false);
            }
        });
    }

    public void requestRestart() throws AzureusCoreException {
        this.runNonDaemon(new AERunnable(){

            public void runSupport() {
                AzureusCoreImpl.this.checkRestartSupported();
                for (AzureusCoreLifecycleListener l : AzureusCoreImpl.this.lifecycle_listeners) {
                    if (l.restartRequested(AzureusCoreImpl.this)) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "Request to restart the core has been denied"));
                    }
                    return;
                }
                AzureusCoreImpl.this.restart();
            }
        });
    }

    public boolean isRestarting() {
        return this.restarting;
    }

    public void checkRestartSupported() throws AzureusCoreException {
        if (this.getPluginManager().getPluginInterfaceByClass("org.gudy.azureus2.update.UpdaterPatcher") == null) {
            Logger.log(new LogAlert(true, 3, "Can't restart without the 'azupdater' plugin installed"));
            throw new AzureusCoreException("Can't restart without the 'azupdater' plugin installed");
        }
    }

    public void saveState() {
        GlobalManager gm = this.global_manager;
        if (gm != null) {
            gm.saveState();
        }
        COConfigurationManager.save();
    }

    public GlobalManager getGlobalManager() throws AzureusCoreException {
        if (this.global_manager == null) {
            throw new AzureusCoreException("Core not running");
        }
        return this.global_manager;
    }

    public TRHost getTrackerHost() throws AzureusCoreException {
        return TRHostFactory.getSingleton();
    }

    public PluginManagerDefaults getPluginManagerDefaults() throws AzureusCoreException {
        return PluginManager.getDefaults();
    }

    public PluginManager getPluginManager() throws AzureusCoreException {
        return PluginInitializer.getDefaultInterface().getPluginManager();
    }

    public IpFilterManager getIpFilterManager() throws AzureusCoreException {
        return IpFilterManagerFactory.getSingleton();
    }

    public AZInstanceManager getInstanceManager() {
        return this.instance_manager;
    }

    public SpeedManager getSpeedManager() {
        return this.speed_manager;
    }

    public CryptoManager getCryptoManager() {
        return this.crypto_manager;
    }

    public NATTraverser getNATTraverser() {
        return this.nat_traverser;
    }

    private void setupSleepAndCloseActions() {
        if (PlatformManagerFactory.getPlatformManager().hasCapability(PlatformManagerCapabilities.PreventComputerSleep)) {
            COConfigurationManager.addAndFireParameterListeners(new String[]{"Prevent Sleep Downloading", "Prevent Sleep FP Seeding"}, new ParameterListener(){
                private TimerEventPeriodic timer_event;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void parameterChanged(String parameterName) {
                    22 var2_2 = this;
                    synchronized (var2_2) {
                        boolean dl = COConfigurationManager.getBooleanParameter("Prevent Sleep Downloading");
                        boolean se = COConfigurationManager.getBooleanParameter("Prevent Sleep FP Seeding");
                        boolean active = dl || se;
                        try {
                            AzureusCoreImpl.this.setPreventComputerSleep(PlatformManagerFactory.getPlatformManager(), active, "config change");
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        if (!active) {
                            if (this.timer_event != null) {
                                this.timer_event.cancel();
                                this.timer_event = null;
                            }
                        } else if (this.timer_event == null) {
                            this.timer_event = SimpleTimer.addPeriodicEvent("core:sleepAct", 120000L, new TimerEventPerformer(){

                                public void perform(TimerEvent event2) {
                                    if (!AzureusCoreImpl.this.stopped) {
                                        AzureusCoreImpl.this.checkSleepActions();
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{"On Downloading Complete Do", "On Seeding Complete Do"}, new ParameterListener(){
            private TimerEventPeriodic timer_event;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void parameterChanged(String parameterName) {
                String dl_act = COConfigurationManager.getStringParameter("On Downloading Complete Do");
                String se_act = COConfigurationManager.getStringParameter("On Seeding Complete Do");
                23 var4_4 = this;
                synchronized (var4_4) {
                    boolean dl_nothing = dl_act.equals("Nothing");
                    boolean se_nothing = se_act.equals("Nothing");
                    if (dl_nothing) {
                        AzureusCoreImpl.this.ca_last_time_downloading = -1L;
                    }
                    if (se_nothing) {
                        AzureusCoreImpl.this.ca_last_time_seeding = -1L;
                    }
                    if (dl_nothing && se_nothing) {
                        if (this.timer_event != null) {
                            this.timer_event.cancel();
                            this.timer_event = null;
                        }
                    } else {
                        if (this.timer_event == null) {
                            this.timer_event = SimpleTimer.addPeriodicEvent("core:closeAct", 30000L, new TimerEventPerformer(){

                                public void perform(TimerEvent event2) {
                                    if (!AzureusCoreImpl.this.stopped) {
                                        AzureusCoreImpl.this.checkCloseActions();
                                    }
                                }
                            });
                        }
                        AzureusCoreImpl.this.checkCloseActions();
                    }
                }
            }
        });
    }

    protected void checkSleepActions() {
        boolean ps_downloading = COConfigurationManager.getBooleanParameter("Prevent Sleep Downloading");
        boolean ps_fp_seed = COConfigurationManager.getBooleanParameter("Prevent Sleep FP Seeding");
        String declining_subsystems = "";
        for (PowerManagementListener l : this.power_listeners) {
            try {
                if (l.requestPowerStateChange(1, null)) continue;
                declining_subsystems = declining_subsystems + (declining_subsystems.length() == 0 ? "" : ",") + l.getPowerName();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (declining_subsystems.length() == 0 && !ps_downloading && !ps_fp_seed) {
            return;
        }
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        boolean prevent_sleep = false;
        String prevent_reason = null;
        if (declining_subsystems.length() > 0) {
            prevent_sleep = true;
            prevent_reason = "subsystems declined sleep: " + declining_subsystems;
        } else {
            List<DownloadManager> managers = this.getGlobalManager().getDownloadManagers();
            for (DownloadManager manager : managers) {
                PEPeerManager pm;
                int state = manager.getState();
                if (state == 55 || manager.getDownloadState().getFlag(512L)) {
                    if (!ps_downloading) continue;
                    prevent_sleep = true;
                    prevent_reason = "active downloads";
                    break;
                }
                if (state == 50 && (pm = manager.getPeerManager()) != null) {
                    if (pm.hasDownloadablePiece()) {
                        if (ps_downloading) {
                            prevent_sleep = true;
                            prevent_reason = "active downloads";
                            break;
                        }
                    } else {
                        state = 60;
                    }
                }
                if (state != 60 || !ps_fp_seed) continue;
                DiskManager disk_manager = manager.getDiskManager();
                if (disk_manager != null && disk_manager.getCompleteRecheckStatus() != -1) {
                    if (!ps_downloading) continue;
                    prevent_sleep = true;
                    prevent_reason = "active downloads";
                    break;
                }
                try {
                    DefaultRankCalculator calc = StartStopRulesDefaultPlugin.getRankCalculator(PluginCoreUtils.wrap(manager));
                    if (!calc.getCachedIsFP()) continue;
                    prevent_sleep = true;
                    prevent_reason = "first-priority seeding";
                    break;
                }
                catch (Throwable e) {
                }
            }
        }
        if (prevent_sleep != platform.getPreventComputerSleep()) {
            if (prevent_sleep) {
                this.prevent_sleep_remove_trigger = false;
            } else if (!this.prevent_sleep_remove_trigger) {
                this.prevent_sleep_remove_trigger = true;
                return;
            }
            if (prevent_reason == null) {
                prevent_reason = ps_downloading && ps_fp_seed ? "no active downloads or first-priority seeding" : (ps_downloading ? "no active downloads" : "no active first-priority seeding");
            }
            this.setPreventComputerSleep(platform, prevent_sleep, prevent_reason);
        }
    }

    private void setPreventComputerSleep(PlatformManager platform, boolean prevent_sleep, String prevent_reason) {
        for (PowerManagementListener l : this.power_listeners) {
            try {
                l.informPowerStateChange(1, new Object[]{prevent_sleep, prevent_reason});
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        Logger.log(new LogEvent(LOGID, "Computer sleep prevented state changed to '" + prevent_sleep + "' due to " + prevent_reason));
        try {
            platform.setPreventComputerSleep(prevent_sleep);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected void checkCloseActions() {
        String se_act;
        List<DownloadManager> managers = this.getGlobalManager().getDownloadManagers();
        boolean is_downloading = false;
        boolean is_seeding = false;
        for (DownloadManager manager : managers) {
            PEPeerManager pm;
            if (manager.isPaused()) {
                return;
            }
            if (manager.getDownloadState().getFlag(512L)) {
                return;
            }
            if (manager.getDownloadState().getFlag(16L)) continue;
            int state = manager.getState();
            if (state == 55) {
                is_downloading = true;
                continue;
            }
            if (state == 50 && (pm = manager.getPeerManager()) != null) {
                if (pm.hasDownloadablePiece()) {
                    is_downloading = true;
                } else {
                    state = 60;
                }
            }
            if (state != 60) continue;
            DiskManager disk_manager = manager.getDiskManager();
            if (disk_manager != null && disk_manager.getCompleteRecheckStatus() != -1) {
                is_downloading = true;
                continue;
            }
            is_seeding = true;
        }
        long now = SystemTime.getMonotonousTime();
        if (is_downloading) {
            this.ca_last_time_downloading = now;
            this.ca_last_time_seeding = -1L;
        } else if (is_seeding) {
            this.ca_last_time_seeding = now;
        }
        String dl_act = COConfigurationManager.getStringParameter("On Downloading Complete Do");
        if (!dl_act.equals("Nothing") && this.ca_last_time_downloading >= 0L && !is_downloading && now - this.ca_last_time_downloading >= 30000L) {
            this.executeCloseAction(true, true, dl_act, null);
        }
        if (!(se_act = COConfigurationManager.getStringParameter("On Seeding Complete Do")).equals("Nothing") && this.ca_last_time_seeding >= 0L && !is_seeding && now - this.ca_last_time_seeding >= 30000L) {
            this.executeCloseAction(true, false, se_act, null);
        }
    }

    public void executeCloseAction(String action, String reason) {
        this.executeCloseAction(false, false, action, reason);
    }

    private void executeCloseAction(boolean obey_reset, final boolean download_trigger, final String action, String reason) {
        boolean reset;
        this.ca_last_time_downloading = -1L;
        this.ca_last_time_seeding = -1L;
        boolean bl = reset = obey_reset && COConfigurationManager.getBooleanParameter("Stop Triggers Auto Reset");
        if (reset) {
            if (download_trigger) {
                COConfigurationManager.setParameter("On Downloading Complete Do", "Nothing");
            } else {
                COConfigurationManager.setParameter("On Seeding Complete Do", "Nothing");
            }
        }
        String type_str = reason == null ? MessageText.getString("core.shutdown." + (download_trigger ? "dl" : "se")) : reason;
        String action_str = MessageText.getString("ConfigView.label.stop." + action);
        String message = MessageText.getString("core.shutdown.alert", new String[]{action_str, type_str});
        UIFunctions ui_functions = UIFunctionsManager.getUIFunctions();
        if (ui_functions != null) {
            ui_functions.forceNotify(0, null, message, null, new Object[0], -1);
        }
        Logger.log(new LogAlert(false, 0, message));
        new DelayedEvent("CoreShutdown", 10000L, new AERunnable(){

            public void runSupport() {
                Logger.log(new LogEvent(LOGID, "Executing close action '" + action + "' due to " + (download_trigger ? "downloading" : "seeding") + " completion"));
                if (action.equals("QuitVuze")) {
                    AzureusCoreImpl.this.requestStop();
                } else if (action.equals("Sleep") || action.equals("Hibernate")) {
                    AzureusCoreImpl.this.announceAll(true);
                    try {
                        PlatformManagerFactory.getPlatformManager().shutdown(action.equals("Sleep") ? 4 : 2);
                    }
                    catch (Throwable e) {
                        Debug.out("PlatformManager: shutdown failed", e);
                    }
                } else if (action.equals("Shutdown")) {
                    AzureusCoreImpl.this.ca_shutdown_computer_after_stop = true;
                    AzureusCoreImpl.this.requestStop();
                } else if (action.startsWith("RunScript")) {
                    String script = download_trigger ? COConfigurationManager.getStringParameter("On Downloading Complete Script", "") : COConfigurationManager.getStringParameter("On Seeding Complete Script", "");
                    File script_file = new File(script.trim());
                    if (!script_file.isFile()) {
                        Logger.log(new LogEvent(LOGID, "Script failed to run - '" + script_file + "' isn't a valid script file"));
                        Debug.out("Invalid script: " + script_file);
                    } else {
                        try {
                            boolean close_vuze = action.equals("RunScriptAndClose");
                            if (!close_vuze) {
                                AzureusCoreImpl.this.announceAll(true);
                            }
                            AzureusCoreImpl.this.getPluginManager().getDefaultPluginInterface().getUtilities().createProcess(script_file.getAbsolutePath());
                            if (close_vuze) {
                                AzureusCoreImpl.this.requestStop();
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                } else {
                    Debug.out("Unknown close action '" + action + "'");
                }
            }
        });
    }

    public AzureusCoreOperation createOperation(final int type) {
        AzureusCoreOperation op = new AzureusCoreOperation(){

            public int getOperationType() {
                return type;
            }

            public AzureusCoreOperationTask getTask() {
                return null;
            }

            public void reportCurrentTask(String task2) {
                AzureusCoreImpl.this.reportCurrentTask(this, task2);
            }

            public void reportPercent(int percent) {
                AzureusCoreImpl.this.reportPercent(this, percent);
            }
        };
        for (int i = 0; i < this.operation_listeners.size(); ++i) {
            try {
                ((AzureusCoreOperationListener)this.operation_listeners.get(i)).operationCreated(op);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return op;
    }

    public void createOperation(final int type, AzureusCoreOperationTask task2) {
        final AzureusCoreOperationTask[] f_task = new AzureusCoreOperationTask[]{task2};
        AzureusCoreOperation op = new AzureusCoreOperation(){

            public int getOperationType() {
                return type;
            }

            public AzureusCoreOperationTask getTask() {
                return f_task[0];
            }

            public void reportCurrentTask(String task2) {
                AzureusCoreImpl.this.reportCurrentTask(this, task2);
            }

            public void reportPercent(int percent) {
                AzureusCoreImpl.this.reportPercent(this, percent);
            }
        };
        for (int i = 0; i < this.operation_listeners.size(); ++i) {
            if (!((AzureusCoreOperationListener)this.operation_listeners.get(i)).operationCreated(op)) continue;
            f_task[0] = null;
        }
        if (f_task[0] != null) {
            task2.run(op);
        }
    }

    protected void reportCurrentTask(AzureusCoreOperation op, String currentTask) {
        if (op.getOperationType() == 1) {
            PluginInitializer.fireEvent(3, currentTask);
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((AzureusCoreListener)it.next()).reportCurrentTask(op, currentTask);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void reportPercent(AzureusCoreOperation op, int percent) {
        if (op.getOperationType() == 1) {
            PluginInitializer.fireEvent(4, new Integer(percent));
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((AzureusCoreListener)it.next()).reportPercent(op, percent);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addLifecycleListener(AzureusCoreLifecycleListener l) {
        this.lifecycle_listeners.add(l);
        if (this.global_manager != null) {
            l.componentCreated(this, this.global_manager);
        }
    }

    public void removeLifecycleListener(AzureusCoreLifecycleListener l) {
        this.lifecycle_listeners.remove(l);
    }

    public void addListener(AzureusCoreListener l) {
        this.listeners.add(l);
    }

    public void removeListener(AzureusCoreListener l) {
        this.listeners.remove(l);
    }

    public void addOperationListener(AzureusCoreOperationListener l) {
        this.operation_listeners.add(l);
    }

    public void removeOperationListener(AzureusCoreOperationListener l) {
        this.operation_listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCoreRunningListener(AzureusCoreRunningListener l) {
        mon_coreRunningListeners.enter();
        try {
            if (coreRunningListeners != null) {
                coreRunningListeners.add(l);
                Object var2_1 = null;
                mon_coreRunningListeners.exit();
                return;
            }
            Object var2_2 = null;
            mon_coreRunningListeners.exit();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            mon_coreRunningListeners.exit();
            throw throwable;
        }
        l.azureusCoreRunning(AzureusCoreImpl.getSingleton());
    }

    public void addPowerManagementListener(PowerManagementListener listener) {
        this.power_listeners.add(listener);
    }

    public void removePowerManagementListener(PowerManagementListener listener) {
        this.power_listeners.remove(listener);
    }

    static {
        class_mon = new AEMonitor("AzureusCore:class");
        coreRunningListeners = new ArrayList<AzureusCoreRunningListener>(1);
        mon_coreRunningListeners = new AEMonitor("CoreCreationListeners");
        SUPPRESS_CLASSLOADER_ERRORS = true;
    }
}

