/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.messenger.config.PlatformMetaSearchMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearch;
import com.aelitis.azureus.core.metasearch.MetaSearchException;
import com.aelitis.azureus.core.metasearch.MetaSearchListener;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchManagerImpl;
import com.aelitis.azureus.core.metasearch.impl.SearchExecuter;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginEngine;
import com.aelitis.azureus.core.metasearch.impl.web.rss.RSSEngine;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaSearchImpl
implements MetaSearch {
    private static final String CONFIG_FILE = "metasearch.config";
    private MetaSearchManagerImpl manager;
    private CopyOnWriteList<EngineImpl> engines = new CopyOnWriteList();
    private Map<String, Long> plugin_map = new HashMap<String, Long>();
    private boolean config_dirty;
    private CopyOnWriteList<MetaSearchListener> listeners = new CopyOnWriteList();
    private TimerEventPeriodic update_check_timer;
    private static final int UPDATE_CHECK_PERIOD = 900000;
    private static final int MIN_UPDATE_CHECK_SECS = 600;
    private Object MS_UPDATE_CONSEC_FAIL_KEY = new Object();
    private AsyncDispatcher update_dispatcher = new AsyncDispatcher();

    protected MetaSearchImpl(MetaSearchManagerImpl _manager) {
        this.manager = _manager;
        this.loadConfig();
    }

    protected MetaSearchManagerImpl getManager() {
        return this.manager;
    }

    @Override
    public Engine importFromBEncodedMap(Map<String, Object> map) throws IOException {
        return EngineImpl.importFromBEncodedMap(this, map);
    }

    public Engine importFromJSONString(int type, long id, long last_updated, float rank_bias, String name, String content) throws IOException {
        return EngineImpl.importFromJSONString(this, type, id, last_updated, rank_bias, name, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EngineImpl importFromPlugin(String _pid, SearchProvider provider2) throws IOException {
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            long id;
            String pid;
            Long l_id;
            Iterator<String> it = this.plugin_map.keySet().iterator();
            while (it.hasNext()) {
                if (it.next().length() <= 1024) continue;
                Debug.out("plugin_map corrupted, resetting");
                this.plugin_map.clear();
                break;
            }
            if ((l_id = this.plugin_map.get(pid = Base32.encode(_pid.getBytes("UTF-8")))) == null) {
                id = this.manager.getLocalTemplateID();
                this.plugin_map.put(pid, new Long(id));
                this.configDirty();
            } else {
                id = l_id;
            }
            EngineImpl engine = (EngineImpl)this.getEngine(id);
            if (engine == null) {
                engine = new PluginEngine(this, id, provider2);
                engine.setSource(2);
                engine.setSelectionState(2);
                this.addEngine(engine);
            } else if (engine instanceof PluginEngine) {
                ((PluginEngine)engine).setProvider(provider2);
            } else {
                Debug.out("Inconsistent: plugin must be a PluginEngine!");
                this.plugin_map.remove(pid);
                this.removeEngine(engine);
                throw new IOException("Inconsistent");
            }
            return engine;
        }
    }

    public SearchProvider resolveProvider(PluginEngine for_engine) {
        List<EngineImpl> l = this.engines.getList();
        for (EngineImpl e : l) {
            PluginEngine pe;
            SearchProvider provider2;
            if (!(e instanceof PluginEngine) || (provider2 = (pe = (PluginEngine)e).getProvider()) == null || !pe.getName().equals(for_engine.getName())) continue;
            return provider2;
        }
        return null;
    }

    @Override
    public Engine createRSSEngine(String name, URL url) throws MetaSearchException {
        RSSEngine engine = new RSSEngine(this, this.manager.getLocalTemplateID(), SystemTime.getCurrentTime(), 1.0f, name, url.toExternalForm(), false, "transparent", null, new String[0]);
        engine.setSource(3);
        this.addEngine(engine, false);
        this.log("Created RSS engine '" + url + "'");
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableUpdateChecks() {
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            if (this.update_check_timer == null) {
                this.update_check_timer = SimpleTimer.addPeriodicEvent("MS:updater", 900000L, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        MetaSearchImpl.this.checkUpdates();
                    }
                });
            }
        }
    }

    private void checkUpdates() {
        this.update_dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                MetaSearchImpl.this.checkUpdatesSupport();
            }
        });
    }

    private void checkUpdatesSupport() {
        for (EngineImpl engine : this.engines) {
            int consec_fails;
            long check_secs;
            String update_url = engine.getUpdateURL();
            if (update_url == null) continue;
            long now = SystemTime.getCurrentTime();
            long last_check = engine.getLastUpdateCheck();
            if (last_check > now) {
                last_check = now;
                engine.setLastUpdateCheck(now);
            }
            if ((check_secs = (long)engine.getUpdateCheckSecs()) < 600L) {
                this.log("Engine '" + engine.getName() + "': Update check period too small (" + check_secs + " secs) adjusting to " + 600 + ": " + engine.getName());
                check_secs = 600L;
            }
            long check_millis = check_secs * 1000L;
            long next_check = last_check + check_millis;
            Object consec_fails_o = engine.getUserData(this.MS_UPDATE_CONSEC_FAIL_KEY);
            int n = consec_fails = consec_fails_o == null ? 0 : (Integer)consec_fails_o;
            if (consec_fails > 0) {
                next_check += (long)(900000 << consec_fails);
            }
            if (next_check >= now) continue;
            if (this.updateEngine(engine)) {
                consec_fails = 0;
                engine.setLastUpdateCheck(now);
            } else if (++consec_fails > 3) {
                consec_fails = 0;
                engine.setLastUpdateCheck(now);
            }
            engine.setUserData(this.MS_UPDATE_CONSEC_FAIL_KEY, consec_fails == 0 ? null : new Integer(consec_fails));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean updateEngine(EngineImpl engine) {
        String update_url = engine.getUpdateURL();
        int pos = update_url.indexOf(63);
        update_url = pos == -1 ? update_url + "?" : update_url + "&";
        update_url = update_url + "az_template_uid=" + engine.getUID() + "&az_template_version=" + engine.getVersion() + "&az_version=" + "5.6.1.3_B16" + "&az_locale=" + MessageText.getCurrentLocale().toString() + "&az_rand=" + RandomUtils.nextAbsoluteLong();
        this.log("Engine " + engine.getName() + ": auto-update check via " + update_url);
        try {
            boolean bl;
            InputStream is;
            block15: {
                boolean check_secs2;
                block14: {
                    int check_secs2;
                    block13: {
                        ResourceDownloaderFactory rdf = StaticUtilities.getResourceDownloaderFactory();
                        ResourceDownloader url_rd = rdf.create(new URL(update_url));
                        ResourceDownloader rd = rdf.getMetaRefreshDownloader(url_rd);
                        is = rd.download();
                        try {
                            Map<String, Object> map = BDecoder.decode(new BufferedInputStream(is));
                            this.log("    update check reply: " + map);
                            Map response = (Map)map.get("response");
                            if (response != null) {
                                Long update_secs = (Long)response.get("update_url_check_secs");
                                if (update_secs == null) {
                                    engine.setLocalUpdateCheckSecs(0);
                                } else {
                                    check_secs2 = update_secs.intValue();
                                    if (check_secs2 < 600) {
                                        this.log("    update check secs for to small, min is 600");
                                        check_secs2 = 600;
                                    }
                                    engine.setLocalUpdateCheckSecs(check_secs2);
                                }
                                check_secs2 = 1;
                                Object var18_16 = null;
                                break block13;
                            }
                            VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(map);
                            if (vf == null) {
                                this.log("    failed to decode vuze file");
                                check_secs2 = false;
                                break block14;
                            }
                            Engine[] updated_engines = this.manager.loadFromVuzeFile(vf);
                            if (updated_engines.length > 0) {
                                String existing_uid = engine.getUID();
                                boolean found = false;
                                String engine_str = "";
                                for (int i = 0; i < updated_engines.length; ++i) {
                                    Engine updated_engine = updated_engines[i];
                                    engine_str = engine_str + (i == 0 ? "" : ",") + updated_engine.getName() + ": uid=" + updated_engine.getUID() + ",version=" + updated_engine.getVersion();
                                    if (!updated_engine.getUID().equals(existing_uid)) continue;
                                    found = true;
                                }
                                if (!found) {
                                    this.log("    existing engine not found in updated set, deleting");
                                    engine.delete();
                                }
                                this.log("    update complete: new engines=" + engine_str);
                            } else {
                                this.log("    no engines found in vuze file");
                            }
                            bl = true;
                            break block15;
                        }
                        catch (Throwable throwable) {
                            Object var18_19 = null;
                            is.close();
                            throw throwable;
                        }
                    }
                    is.close();
                    return check_secs2 != 0;
                }
                Object var18_17 = null;
                is.close();
                return check_secs2;
            }
            Object var18_18 = null;
            is.close();
            return bl;
        }
        catch (Throwable e) {
            this.log("    update check failed", e);
            return false;
        }
    }

    @Override
    public void addEngine(Engine engine) {
        this.addEngine((EngineImpl)engine, false);
    }

    @Override
    public Engine addEngine(long id) throws MetaSearchException {
        try {
            PlatformMetaSearchMessenger.templateDetails details = PlatformMetaSearchMessenger.getTemplate(this.manager.getExtensionKey(), id);
            this.log("Downloading definition of template " + id);
            this.log(details.getValue());
            if (details.isVisible()) {
                Engine engine = this.importFromJSONString(details.getType() == 1 ? 2 : 1, details.getId(), details.getModifiedDate(), details.getRankBias(), details.getName(), details.getValue());
                engine.setSource(1);
                engine.setSelectionState(0);
                this.addEngine(engine);
                return engine;
            }
            throw new MetaSearchException("Search template is not visible");
        }
        catch (MetaSearchException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new MetaSearchException("Template load failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEngine(EngineImpl new_engine, boolean loading) {
        boolean add_op = true;
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            Iterator<EngineImpl> it = this.engines.iterator();
            while (it.hasNext()) {
                Engine existing_engine = it.next();
                if (existing_engine.getId() == new_engine.getId()) {
                    this.log("Updating engine with same ID " + existing_engine.getId() + ": " + existing_engine.getName() + "/" + existing_engine.getUID());
                    it.remove();
                    new_engine.setUID(existing_engine.getUID());
                    if (existing_engine.sameLogicAs(new_engine)) {
                        new_engine.setVersion(existing_engine.getVersion());
                    } else {
                        new_engine.setVersion(existing_engine.getVersion() + 1);
                        this.log("    new version=" + new_engine.getVersion());
                    }
                    add_op = false;
                    continue;
                }
                if (!existing_engine.getUID().equals(new_engine.getUID())) continue;
                this.log("Removing engine with same UID " + existing_engine.getUID() + "(" + existing_engine.getName() + ")");
                it.remove();
            }
            this.engines.add(new_engine);
        }
        if (new_engine.getUpdateURL() != null) {
            this.enableUpdateChecks();
        }
        if (!loading) {
            this.log("Engine '" + new_engine.getName() + "' added");
            this.saveConfig();
            for (MetaSearchListener listener : this.listeners) {
                try {
                    if (add_op) {
                        listener.engineAdded(new_engine);
                        continue;
                    }
                    listener.engineUpdated(new_engine);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public void removeEngine(Engine engine) {
        if (this.engines.remove((EngineImpl)engine)) {
            this.log("Engine '" + engine.getName() + "' removed");
            this.saveConfig();
            Iterator<MetaSearchListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    it.next().engineRemoved(engine);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public String getFUD() {
        List<EngineImpl> l = this.engines.getList();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (EngineImpl engine : l) {
            if (engine.getSource() != 1) continue;
            ids.add(engine.getId());
        }
        Collections.sort(ids);
        String fud = "";
        for (Long id : ids) {
            fud = fud + (fud.length() == 0 ? "" : ",") + id;
        }
        return fud;
    }

    protected void addPotentialAssociation(EngineImpl engine, String key) {
        this.manager.addPotentialAssociation(engine, key);
    }

    @Override
    public Engine[] getEngines(boolean active_only, boolean ensure_up_to_date) {
        List<EngineImpl> result;
        if (ensure_up_to_date) {
            this.manager.ensureEnginesUpToDate();
        }
        List<EngineImpl> l = this.engines.getList();
        if (active_only) {
            result = new ArrayList<EngineImpl>();
            for (int i = 0; i < l.size(); ++i) {
                EngineImpl e = l.get(i);
                if (!e.isActive()) continue;
                result.add(e);
            }
        } else {
            result = l;
        }
        return result.toArray(new Engine[result.size()]);
    }

    @Override
    public Engine getEngine(long id) {
        List<EngineImpl> l = this.engines.getList();
        for (int i = 0; i < l.size(); ++i) {
            Engine e = l.get(i);
            if (e.getId() != id) continue;
            return e;
        }
        return null;
    }

    @Override
    public Engine getEngineByUID(String uid) {
        List<EngineImpl> l = this.engines.getList();
        for (int i = 0; i < l.size(); ++i) {
            Engine e = l.get(i);
            if (!e.getUID().equals(uid)) continue;
            return e;
        }
        return null;
    }

    @Override
    public int getEngineCount() {
        return this.engines.size();
    }

    @Override
    public Engine[] search(ResultListener original_listener, SearchParameter[] searchParameters, String headers, int max_results_per_engine) {
        return this.search(original_listener, searchParameters, headers, new HashMap<String, String>(), max_results_per_engine);
    }

    @Override
    public Engine[] search(ResultListener original_listener, SearchParameter[] searchParameters, String headers, Map<String, String> context2, int max_results_per_engine) {
        return this.search(null, original_listener, searchParameters, headers, context2, max_results_per_engine);
    }

    @Override
    public Engine[] search(Engine[] engines, ResultListener listener, SearchParameter[] search_parameters, String headers, int max_results_per_engine) {
        return this.search(engines, listener, search_parameters, headers, new HashMap<String, String>(), max_results_per_engine);
    }

    @Override
    public void enginePreferred(Engine engine) {
        Engine[] engines = this.getEngines(true, false);
        int num_other_preferred = 0;
        for (Engine e : engines) {
            if (e.getId() == engine.getId()) {
                e.setPreferredDelta(1.0f);
                continue;
            }
            if (!(e.getPreferredWeighting() > 0.0f)) continue;
            ++num_other_preferred;
        }
        if (num_other_preferred > 0) {
            float negative_weighting = -1.0f / (float)num_other_preferred;
            for (Engine e : engines) {
                if (e.getId() == engine.getId() || !(e.getPreferredWeighting() > 0.0f)) continue;
                e.setPreferredDelta(negative_weighting);
            }
        }
    }

    @Override
    public Engine[] search(Engine[] engines, final ResultListener original_listener, SearchParameter[] searchParameters, String headers, Map<String, String> context2, final int max_results_per_engine) {
        int i;
        String batch_millis_str = context2.get("batch_millis");
        final long batch_millis = batch_millis_str == null ? 0L : Long.parseLong(batch_millis_str);
        String rem_dups_str = context2.get("remove_dup_hash");
        final boolean rem_dups = rem_dups_str == null ? false : rem_dups_str.equalsIgnoreCase("true");
        ResultListener listener = new ResultListener(){
            private AsyncDispatcher dispatcher = new AsyncDispatcher(5000);
            private final Map<Engine, List<Result[]>> pending_results = new HashMap<Engine, List<Result[]>>();
            private final Map<Engine, Set<String>> result_hashes = new HashMap<Engine, Set<String>>();

            public void contentReceived(final Engine engine, final String content) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        original_listener.contentReceived(engine, content);
                    }
                });
            }

            public void matchFound(final Engine engine, final String[] fields) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        original_listener.matchFound(engine, fields);
                    }
                });
            }

            public void resultsReceived(final Engine engine, final Result[] results) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        Result[] results_to_return = null;
                        if (batch_millis > 0L) {
                            List list = (List)pending_results.get(engine);
                            if (list == null) {
                                results_to_return = results;
                                pending_results.put(engine, new ArrayList());
                                new DelayedEvent("SearchBatcher", batch_millis, new AERunnable(){

                                    public void runSupport() {
                                        dispatcher.dispatch(new AERunnable(){

                                            public void runSupport() {
                                                this.batchResultsComplete(engine);
                                            }
                                        });
                                    }
                                });
                            } else {
                                list.add(results);
                            }
                        } else {
                            results_to_return = results;
                        }
                        if (results_to_return != null) {
                            results_to_return = this.truncateResults(engine, results_to_return, max_results_per_engine);
                            original_listener.resultsReceived(engine, results_to_return);
                        }
                    }
                });
            }

            public void resultsComplete(final Engine engine) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        if (batch_millis > 0L) {
                            this.batchResultsComplete(engine);
                        }
                        original_listener.resultsComplete(engine);
                    }
                });
            }

            protected void batchResultsComplete(Engine engine) {
                List<Result[]> list = this.pending_results.remove(engine);
                if (list != null) {
                    ArrayList<Result> x = new ArrayList<Result>();
                    for (Result[] y : list) {
                        x.addAll(Arrays.asList(y));
                    }
                    Result[] results = x.toArray(new Result[x.size()]);
                    results = this.truncateResults(engine, results, max_results_per_engine);
                    original_listener.resultsReceived(engine, results);
                }
            }

            protected Result[] truncateResults(Engine engine, Result[] a_results, int max) {
                Set<String> hash_set = this.result_hashes.get(engine);
                if (hash_set == null) {
                    hash_set = new HashSet<String>();
                    this.result_hashes.put(engine, hash_set);
                }
                ArrayList<Result> results = new ArrayList<Result>(a_results.length);
                for (Result r : a_results) {
                    String name = r.getName();
                    if (name == null || name.trim().length() == 0) continue;
                    if (rem_dups) {
                        String hash = r.getHash();
                        if (hash == null || hash.length() == 0) {
                            results.add(r);
                            continue;
                        }
                        if (hash_set.contains(hash)) continue;
                        results.add(r);
                        hash_set.add(hash);
                        continue;
                    }
                    results.add(r);
                }
                if (max < results.size()) {
                    MetaSearchImpl.this.log("Truncating search results for " + engine.getName() + " from " + results.size() + " to " + max);
                    Collections.sort(results, new Comparator<Result>(){
                        Map<Result, Float> ranks = new HashMap<Result, Float>();

                        @Override
                        public int compare(Result r1, Result r2) {
                            Float rank2;
                            Float rank1 = this.ranks.get(r1);
                            if (rank1 == null) {
                                rank1 = new Float(r1.getRank());
                                this.ranks.put(r1, rank1);
                            }
                            if ((rank2 = this.ranks.get(r2)) == null) {
                                rank2 = new Float(r2.getRank());
                                this.ranks.put(r2, rank2);
                            }
                            return rank2.compareTo(rank1);
                        }
                    });
                    Result[] x = new Result[max];
                    for (int pos = 0; pos < max; ++pos) {
                        x[pos] = (Result)results.get(pos);
                    }
                    return x;
                }
                return results.toArray(new Result[results.size()]);
            }

            public void engineFailed(final Engine engine, final Throwable e) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        original_listener.engineFailed(engine, e);
                    }
                });
            }

            public void engineRequiresLogin(final Engine engine, final Throwable e) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        original_listener.engineRequiresLogin(engine, e);
                    }
                });
            }
        };
        SearchExecuter se = new SearchExecuter(context2, listener);
        if (engines == null) {
            engines = this.getEngines(true, true);
        }
        String engines_str = "";
        for (i = 0; i < engines.length; ++i) {
            engines_str = engines_str + (i == 0 ? "" : ",") + engines[i].getId();
        }
        this.log("Search: engines=" + engines_str);
        for (i = 0; i < engines.length; ++i) {
            se.search(engines[i], searchParameters, headers, max_results_per_engine);
        }
        return engines;
    }

    @Override
    public void exportEngines(File target) throws MetaSearchException {
        Engine[] engines = this.getEngines(true, false);
        VuzeFile vf = VuzeFileHandler.getSingleton().create();
        for (Engine engine : engines) {
            try {
                vf.addComponent(1, engine.exportToBencodedMap());
            }
            catch (IOException e) {
                Debug.out(e);
            }
        }
        try {
            vf.write(target);
        }
        catch (IOException e) {
            throw new MetaSearchException("Failed to write file", e);
        }
    }

    @Override
    public void addListener(MetaSearchListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(MetaSearchListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        this.log("Loading configuration");
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            Map p_map;
            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
            List l_engines = (List)map.get("engines");
            if (l_engines != null) {
                for (int i = 0; i < l_engines.size(); ++i) {
                    Map m = (Map)l_engines.get(i);
                    try {
                        Engine e = this.importFromBEncodedMap(m);
                        this.addEngine((EngineImpl)e, true);
                        this.log("    loaded " + e.getString());
                        continue;
                    }
                    catch (Throwable e) {
                        this.log("Failed to import engine from " + m, e);
                    }
                }
            }
            if ((p_map = (Map)map.get("plugin_map")) != null) {
                this.plugin_map = p_map;
            }
            if (this.update_check_timer != null) {
                this.checkUpdates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configDirty() {
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("MetaSearch:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    MetaSearchImpl metaSearchImpl = MetaSearchImpl.this;
                    synchronized (metaSearchImpl) {
                        if (!MetaSearchImpl.this.config_dirty) {
                            return;
                        }
                        MetaSearchImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        this.log("Saving configuration");
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            this.config_dirty = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> l_engines = new ArrayList<Map<String, Object>>();
            map.put("engines", l_engines);
            for (Engine engine : this.engines) {
                try {
                    l_engines.add(engine.exportToBencodedMap());
                }
                catch (Throwable f) {
                    this.log("Failed to export engine " + engine.getName(), f);
                }
            }
            if (this.plugin_map != null) {
                map.put("plugin_map", this.plugin_map);
            }
            FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
        }
    }

    protected void log(String str) {
        this.manager.log("search :" + str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log("search :" + str, e);
    }

    protected void generate(IndentWriter writer) {
        for (EngineImpl e : this.engines) {
            writer.println(e.getString(true));
        }
    }
}

