/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportBase;
import com.aelitis.azureus.core.networkmanager.TransportStartpoint;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASNListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNATDevice;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNode;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminRouteListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminRoutesListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduler;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminASNImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminASNLookupImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminHTTPProxyImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminNATDeviceImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSocksProxyImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTestSchedulerImpl;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.proxy.AEProxySelectorFactory;
import com.aelitis.azureus.core.proxy.socks.AESocksProxy;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.NetUtils;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAdminImpl
extends NetworkAdmin
implements AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final boolean FULL_INTF_PROBE = false;
    private static InetAddress anyLocalAddress;
    private static InetAddress anyLocalAddressIPv4;
    private static InetAddress anyLocalAddressIPv6;
    private static InetAddress localhostV4;
    private static InetAddress localhostV6;
    private static final int INTERFACE_CHECK_MILLIS = 15000;
    private static final int ROUTE_CHECK_MILLIS = 60000;
    private static final int ROUTE_CHECK_TICKS = 4;
    private Set<NetworkInterface> old_network_interfaces;
    private Map<String, AddressHistoryRecord> address_history = new HashMap<String, AddressHistoryRecord>();
    private long address_history_update_time;
    private InetAddress[] currentBindIPs = new InetAddress[]{null};
    private boolean forceBind = false;
    private boolean supportsIPv6withNIO = true;
    private boolean supportsIPv6 = true;
    private boolean supportsIPv4 = true;
    private boolean IPv6_enabled;
    private int roundRobinCounterV4;
    private int roundRobinCounterV6;
    private boolean logged_bind_force_issue;
    private CopyOnWriteList listeners;
    private NetworkAdminRouteListener trace_route_listener;
    private static final int ASN_MIN_CHECK = 1800000;
    private long last_asn_lookup_time;
    private List asn_ips_checked;
    private List as_history;
    private AsyncDispatcher async_asn_dispacher;
    private static final int MAX_ASYNC_ASN_LOOKUPS = 1024;
    private Map<InetAddress, NetworkAdminASN> async_asn_history;
    private boolean initialised;
    private List<NetworkInterface> last_getni_result;
    private Object getni_lock;
    private static InetAddress[] gdpa_lock;
    private static AESemaphore gdpa_sem;
    private static long gdpa_last_fail;
    private static long gdpa_last_lookup;
    private static AESemaphore gdpa_initial_sem;
    public static final int BS_INACTIVE = 0;
    public static final int BS_OK = 1;
    public static final int BS_WARNING = 2;
    public static final int BS_ERROR = 3;
    private long bs_last_calc;
    private Object[] bs_last_value;

    public NetworkAdminImpl() {
        COConfigurationManager.addAndFireParameterListener("IPV6 Enable Support", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                NetworkAdminImpl.this.setIPv6Enabled(COConfigurationManager.getBooleanParameter("IPV6 Enable Support"));
            }
        });
        COConfigurationManager.addResetToDefaultsListener(new COConfigurationManager.ResetToDefaultsListener(){

            public void reset() {
                NetworkAdminImpl.this.clearMaybeVPNs();
            }
        });
        this.roundRobinCounterV4 = 0;
        this.roundRobinCounterV6 = 0;
        this.listeners = new CopyOnWriteList();
        this.trace_route_listener = new NetworkAdminRouteListener(){
            private int node_count = 0;

            public boolean foundNode(NetworkAdminNode node, int distance, int rtt) {
                ++this.node_count;
                return true;
            }

            public boolean timeout(int distance) {
                return distance != 3 || this.node_count != 0;
            }
        };
        this.asn_ips_checked = new ArrayList(0);
        this.as_history = new ArrayList();
        this.async_asn_dispacher = new AsyncDispatcher();
        this.async_asn_history = new LinkedHashMap<InetAddress, NetworkAdminASN>(256, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<InetAddress, NetworkAdminASN> eldest) {
                return this.size() > 256;
            }
        };
        this.getni_lock = new Object();
        this.bs_last_calc = 0L;
        this.bs_last_value = null;
        COConfigurationManager.addParameterListener(new String[]{"Bind IP", "Enforce Bind IP"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                NetworkAdminImpl.this.checkDefaultBindAddress(false);
            }
        });
        SimpleTimer.addPeriodicEvent("NetworkAdmin:checker", 15000L, new TimerEventPerformer(){
            private int tick_count;

            public void perform(TimerEvent event2) {
                ++this.tick_count;
                boolean changed = NetworkAdminImpl.this.checkNetworkInterfaces(false, false);
                if (changed || this.tick_count % 4 == 0) {
                    NetworkAdminImpl.this.checkConnectionRoutes();
                }
            }
        });
        this.checkNetworkInterfaces(true, true);
        this.checkDefaultBindAddress(true);
        AEDiagnostics.addEvidenceGenerator(this);
        this.checkDNSSPI();
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                try {
                    Class.forName("com.aelitis.azureus.core.networkmanager.admin.impl.swt.NetworkAdminSWTImpl").getConstructor(AzureusCore.class, NetworkAdminImpl.class).newInstance(core, NetworkAdminImpl.this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.initialised = true;
    }

    private void checkDNSSPI() {
        String error_str = null;
        try {
            InetAddress ia = InetAddress.getByName("dns.test.client.vuze.com");
            if (!ia.isLoopbackAddress()) {
                error_str = "Loopback address expected, got " + ia;
            }
        }
        catch (UnknownHostException e) {
            error_str = "DNS SPI not loaded";
        }
        catch (Throwable e) {
            error_str = "Test lookup failed: " + Debug.getNestedExceptionMessage(e);
        }
        if (error_str != null) {
            Logger.log(new LogAlert(true, 1, MessageText.getString("network.admin.dns.spi.fail", new String[]{error_str})));
        }
    }

    protected void setIPv6Enabled(boolean enabled) {
        this.IPv6_enabled = enabled;
        this.supportsIPv6withNIO = enabled;
        this.supportsIPv6 = enabled;
        if (this.initialised) {
            this.checkNetworkInterfaces(false, true);
            this.checkDefaultBindAddress(false);
        }
    }

    @Override
    public boolean isIPV6Enabled() {
        return this.IPv6_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkNetworkInterfaces(boolean first_time, boolean force) {
        boolean changed = false;
        try {
            List<NetworkInterface> x = NetUtils.getNetworkInterfaces();
            boolean fire_stuff = false;
            Object object = this.getni_lock;
            synchronized (object) {
                if (this.last_getni_result != x) {
                    this.last_getni_result = x;
                    if (x.size() != 0 || this.old_network_interfaces != null) {
                        HashSet<NetworkInterface> new_network_interfaces;
                        if (x.size() == 0) {
                            this.old_network_interfaces = null;
                            changed = true;
                        } else if (this.old_network_interfaces == null) {
                            new_network_interfaces = new HashSet<NetworkInterface>();
                            new_network_interfaces.addAll(x);
                            this.old_network_interfaces = new_network_interfaces;
                            changed = true;
                        } else {
                            new_network_interfaces = new HashSet();
                            for (NetworkInterface ni : x) {
                                if (!this.old_network_interfaces.contains(ni)) {
                                    changed = true;
                                }
                                new_network_interfaces.add(ni);
                            }
                            if (this.old_network_interfaces.size() != new_network_interfaces.size()) {
                                changed = true;
                            }
                            this.old_network_interfaces = new_network_interfaces;
                        }
                    }
                    if (changed || force) {
                        boolean newV6 = false;
                        boolean newV4 = false;
                        Set<NetworkInterface> interfaces = this.old_network_interfaces;
                        long now = SystemTime.getMonotonousTime();
                        ArrayList<AddressHistoryRecord> a_history = new ArrayList<AddressHistoryRecord>();
                        if (interfaces != null) {
                            for (NetworkInterface ni : interfaces) {
                                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                                while (addresses.hasMoreElements()) {
                                    InetAddress ia = addresses.nextElement();
                                    a_history.add(new AddressHistoryRecord(ni, ia, now));
                                    if (ia.isLoopbackAddress()) continue;
                                    if (ia instanceof Inet6Address && !ia.isLinkLocalAddress()) {
                                        if (!this.IPv6_enabled) continue;
                                        newV6 = true;
                                        continue;
                                    }
                                    if (!(ia instanceof Inet4Address)) continue;
                                    newV4 = true;
                                }
                            }
                        }
                        Map<String, AddressHistoryRecord> it = this.address_history;
                        synchronized (it) {
                            this.address_history_update_time = now;
                            for (AddressHistoryRecord entry : a_history) {
                                String name = entry.getAddress().getHostAddress();
                                AddressHistoryRecord existing = this.address_history.get(name);
                                if (existing == null) {
                                    this.address_history.put(name, entry);
                                    continue;
                                }
                                existing.setLastSeen(now);
                            }
                            Iterator<AddressHistoryRecord> it2 = this.address_history.values().iterator();
                            while (it2.hasNext()) {
                                AddressHistoryRecord entry;
                                entry = it2.next();
                                long age = now - entry.getLastSeen();
                                if (age <= 600000L) continue;
                                it2.remove();
                            }
                        }
                        this.supportsIPv4 = newV4;
                        this.supportsIPv6 = newV6;
                        Logger.log(new LogEvent(LOGID, "NetworkAdmin: ipv4 supported: " + this.supportsIPv4 + "; ipv6: " + this.supportsIPv6 + "; probing v6+nio functionality"));
                        if (newV6) {
                            ServerSocketChannel channel2 = ServerSocketChannel.open();
                            try {
                                channel2.configureBlocking(false);
                                channel2.socket().bind(new InetSocketAddress(anyLocalAddressIPv6, 0));
                                Logger.log(new LogEvent(LOGID, "NetworkAdmin: testing nio + ipv6 bind successful"));
                                this.supportsIPv6withNIO = true;
                            }
                            catch (Exception e) {
                                Logger.log(new LogEvent(LOGID, 1, "nio + ipv6 test failed", (Throwable)e));
                                this.supportsIPv6withNIO = false;
                            }
                            channel2.close();
                        } else {
                            this.supportsIPv6withNIO = false;
                        }
                        if (!first_time) {
                            Logger.log(new LogEvent(LOGID, "NetworkAdmin: network interfaces have changed"));
                        }
                        fire_stuff = true;
                    }
                }
            }
            if (fire_stuff) {
                this.firePropertyChange("Network Interfaces");
                this.checkDefaultBindAddress(first_time);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return changed;
    }

    @Override
    public InetAddress getMultiHomedOutgoingRoundRobinBindAddress(InetAddress target) {
        InetAddress[] addresses = this.currentBindIPs;
        boolean v6 = target instanceof Inet6Address;
        int previous = (v6 ? this.roundRobinCounterV6 : this.roundRobinCounterV4) % addresses.length;
        InetAddress toReturn = null;
        int i = previous;
        do {
            ++i;
            if (target == null || v6 && addresses[i %= addresses.length] instanceof Inet6Address || !v6 && addresses[i] instanceof Inet4Address) {
                toReturn = addresses[i];
                break;
            }
            if (v6 || !addresses[i].isAnyLocalAddress()) continue;
            toReturn = anyLocalAddressIPv4;
            break;
        } while (i != previous);
        if (v6) {
            this.roundRobinCounterV6 = i;
        } else {
            this.roundRobinCounterV4 = i;
        }
        return toReturn != null ? toReturn : (v6 ? localhostV6 : localhostV4);
    }

    @Override
    public InetAddress[] getMultiHomedServiceBindAddresses(boolean nio) {
        InetAddress[] bindIPs = this.currentBindIPs;
        for (int i = 0; i < bindIPs.length; ++i) {
            if (!bindIPs[i].isAnyLocalAddress()) continue;
            return new InetAddress[]{nio && !this.supportsIPv6withNIO && bindIPs[i] instanceof Inet6Address ? anyLocalAddressIPv4 : bindIPs[i]};
        }
        return bindIPs;
    }

    @Override
    public InetAddress getSingleHomedServiceBindAddress(int proto) {
        InetAddress[] addrs = this.currentBindIPs;
        if (proto == 0) {
            return addrs[0];
        }
        for (InetAddress addr : addrs) {
            if ((proto != 1 || !(addr instanceof Inet4Address)) && !addr.isAnyLocalAddress() && (proto != 2 || !(addr instanceof Inet6Address))) continue;
            if (addr.isAnyLocalAddress()) {
                if (proto == 1) {
                    return anyLocalAddressIPv4;
                }
                return anyLocalAddressIPv6;
            }
            return addr;
        }
        throw new UnsupportedAddressTypeException();
    }

    @Override
    public InetAddress[] getAllBindAddresses(boolean include_wildcard) {
        InetAddress[] bind_ips;
        if (include_wildcard) {
            return this.currentBindIPs;
        }
        ArrayList<InetAddress> res = new ArrayList<InetAddress>();
        for (InetAddress ip : bind_ips = this.currentBindIPs) {
            if (ip.isAnyLocalAddress()) continue;
            res.add(ip);
        }
        return res.toArray(new InetAddress[res.size()]);
    }

    private InetAddress[] calcBindAddresses(String addressString, boolean enforceBind) {
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        Pattern addressSplitter = Pattern.compile(";");
        Pattern interfaceSplitter = Pattern.compile("[\\]\\[]");
        String[] tokens = addressSplitter.split(addressString);
        block8: for (int i = 0; i < tokens.length; ++i) {
            String currentAddress = tokens[i];
            if ((currentAddress = currentAddress.trim()).length() == 0) continue;
            InetAddress parsedAddress = null;
            try {
                if (currentAddress.indexOf(46) != -1 || currentAddress.indexOf(58) != -1) {
                    parsedAddress = InetAddress.getByName(currentAddress);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (parsedAddress != null) {
                block19: {
                    try {
                        if (!(parsedAddress.isAnyLocalAddress() && addrs.size() <= 0 || NetworkInterface.getByInetAddress(parsedAddress) != null)) {
                        }
                        break block19;
                    }
                    catch (SocketException e) {
                        Debug.printStackTrace(e);
                    }
                    continue;
                }
                addrs.add(parsedAddress);
                continue;
            }
            String[] ifaces = interfaceSplitter.split(currentAddress);
            NetworkInterface netInterface = null;
            try {
                netInterface = NetworkInterface.getByName(ifaces[0]);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            if (netInterface == null) continue;
            Enumeration<InetAddress> interfaceAddresses = netInterface.getInetAddresses();
            if (ifaces.length != 2) {
                while (interfaceAddresses.hasMoreElements()) {
                    addrs.add(interfaceAddresses.nextElement());
                }
                continue;
            }
            int selectedAddress = 0;
            try {
                selectedAddress = Integer.parseInt(ifaces[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            int j = 0;
            while (interfaceAddresses.hasMoreElements()) {
                if (j == selectedAddress) {
                    addrs.add(interfaceAddresses.nextElement());
                    continue block8;
                }
                ++j;
                interfaceAddresses.nextElement();
            }
        }
        if (!this.IPv6_enabled) {
            Iterator it = addrs.iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof Inet6Address)) continue;
                it.remove();
            }
        }
        if (addrs.size() < 1) {
            return new InetAddress[]{enforceBind ? localhostV4 : (this.hasIPV6Potential() ? anyLocalAddressIPv6 : anyLocalAddressIPv4)};
        }
        return addrs.toArray(new InetAddress[addrs.size()]);
    }

    private String checkBindAddresses(boolean log_alerts) {
        Pattern addressSplitter = Pattern.compile(";");
        Pattern interfaceSplitter = Pattern.compile("[\\]\\[]");
        String bind_ips = COConfigurationManager.getStringParameter("Bind IP", "").trim();
        boolean enforceBind = COConfigurationManager.getBooleanParameter("Enforce Bind IP");
        if (enforceBind && bind_ips.length() == 0 && log_alerts) {
            Logger.log(new LogAlert(true, 1, MessageText.getString("network.admin.bind.enforce.fail")));
        }
        String[] tokens = addressSplitter.split(bind_ips);
        String failed_entries = "";
        for (int i = 0; i < tokens.length; ++i) {
            String currentAddress = tokens[i];
            if ((currentAddress = currentAddress.trim()).length() == 0) continue;
            boolean ok = false;
            InetAddress parsedAddress = null;
            try {
                if (currentAddress.indexOf(46) != -1 || currentAddress.indexOf(58) != -1) {
                    parsedAddress = InetAddress.getByName(currentAddress);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (parsedAddress != null) {
                try {
                    if (parsedAddress.isAnyLocalAddress() || NetworkInterface.getByInetAddress(parsedAddress) != null) {
                        ok = true;
                    }
                }
                catch (Throwable e) {}
            } else {
                String[] ifaces = interfaceSplitter.split(currentAddress);
                NetworkInterface netInterface = null;
                try {
                    netInterface = NetworkInterface.getByName(ifaces[0]);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (netInterface != null) {
                    Enumeration<InetAddress> interfaceAddresses = netInterface.getInetAddresses();
                    if (ifaces.length != 2) {
                        ok = interfaceAddresses.hasMoreElements();
                    } else {
                        try {
                            int selectedAddress = Integer.parseInt(ifaces[1]);
                            int j = 0;
                            while (interfaceAddresses.hasMoreElements()) {
                                if (j == selectedAddress) {
                                    ok = true;
                                    break;
                                }
                                ++j;
                                interfaceAddresses.nextElement();
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (ok) continue;
            failed_entries = failed_entries + (failed_entries.length() == 0 ? "" : ", ") + currentAddress;
        }
        if (failed_entries.length() > 0) {
            if (log_alerts) {
                Logger.log(new LogAlert(true, 1, "Bind IPs not resolved: " + failed_entries + "\n\nSee Tools->Options->Connection->Advanced Network Settings"));
            }
            return failed_entries;
        }
        return null;
    }

    protected void checkDefaultBindAddress(boolean first_time) {
        boolean changed = false;
        String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "").trim();
        boolean enforceBind = COConfigurationManager.getBooleanParameter("Enforce Bind IP");
        if (enforceBind) {
            if (bind_ip.length() == 0) {
                if (!this.logged_bind_force_issue) {
                    this.logged_bind_force_issue = true;
                    Debug.out("'Enforce IP Bindings' is selected but no bindings have been specified - ignoring force request!");
                }
                enforceBind = false;
            } else {
                this.logged_bind_force_issue = false;
            }
        }
        this.forceBind = enforceBind;
        Object[] addrs = this.calcBindAddresses(bind_ip, enforceBind);
        boolean bl = changed = !Arrays.equals(this.currentBindIPs, addrs);
        if (changed) {
            this.currentBindIPs = addrs;
            if (!first_time) {
                String logmsg = "NetworkAdmin: default bind ip has changed to '";
                for (int i = 0; i < addrs.length; ++i) {
                    logmsg = logmsg + (addrs[i] == null ? "none" : ((InetAddress)addrs[i]).getHostAddress()) + (i < addrs.length ? ";" : "");
                }
                logmsg = logmsg + "'";
                Logger.log(new LogEvent(LOGID, logmsg));
                if (bind_ip.length() == 0) {
                    this.clearMaybeVPNs();
                }
            }
            this.firePropertyChange("Default Bind IP");
        }
    }

    @Override
    public String getNetworkInterfacesAsString() {
        Set<NetworkInterface> interfaces = this.old_network_interfaces;
        if (interfaces == null) {
            return "";
        }
        Iterator<NetworkInterface> it = interfaces.iterator();
        StringBuilder sb = new StringBuilder(1024);
        while (it.hasNext()) {
            NetworkInterface ni = it.next();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            sb.append(ni.getName());
            sb.append("\t(");
            sb.append(ni.getDisplayName());
            sb.append(")\n");
            int i = 0;
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                sb.append("\t");
                sb.append(ni.getName());
                sb.append("[");
                sb.append(i++);
                sb.append("]\t");
                sb.append(address.getHostAddress());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean hasIPV4Potential() {
        return this.supportsIPv4;
    }

    @Override
    public boolean hasIPV6Potential(boolean nio) {
        return nio ? this.supportsIPv6withNIO : this.supportsIPv6;
    }

    @Override
    public InetAddress[] getBindableAddresses() {
        return this.getBindableAddresses(false, false);
    }

    private InetAddress[] getBindableAddresses(boolean ignore_loopback, boolean ignore_link_local) {
        NetworkAdminNetworkInterface[] interfaces;
        ArrayList<InetAddress> bindable = new ArrayList<InetAddress>();
        for (NetworkAdminNetworkInterface intf : interfaces = NetworkAdmin.getSingleton().getInterfaces()) {
            NetworkAdminNetworkInterfaceAddress[] addresses;
            for (NetworkAdminNetworkInterfaceAddress address : addresses = intf.getAddresses()) {
                InetAddress a = address.getAddress();
                if (ignore_loopback && a.isLoopbackAddress() || ignore_link_local && a.isLinkLocalAddress() || !this.canBind(a)) continue;
                bindable.add(a);
            }
        }
        return bindable.toArray(new InetAddress[bindable.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canBind(InetAddress bind_ip) {
        boolean bl;
        ServerSocketChannel ssc = null;
        try {
            try {
                ssc = ServerSocketChannel.open();
                ssc.socket().bind(new InetSocketAddress(bind_ip, 0), 16);
                bl = true;
                Object var6_5 = null;
                if (ssc == null) return bl;
            }
            catch (Throwable e) {
                boolean bl2 = false;
                Object var6_6 = null;
                if (ssc == null) return bl2;
                try {
                    ssc.close();
                    return bl2;
                }
                catch (Throwable e2) {
                    Debug.out(e2);
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (ssc == null) throw throwable;
            try {}
            catch (Throwable e2) {
                Debug.out(e2);
                throw throwable;
            }
            ssc.close();
            throw throwable;
        }
        try {}
        catch (Throwable e2) {
            Debug.out(e2);
            return bl;
        }
        ssc.close();
        return bl;
    }

    @Override
    public int getBindablePort(int prefer_port) throws IOException {
        int tries = 1024;
        Random random = new Random();
        for (int i = 1; i <= 1024; ++i) {
            int port = i == 1 && prefer_port != 0 ? prefer_port : (i == 1024 ? 0 : random.nextInt(20000) + 40000);
            ServerSocketChannel ssc = null;
            try {
                ssc = ServerSocketChannel.open();
                ssc.socket().setReuseAddress(true);
                this.bind(ssc, null, port);
                port = ssc.socket().getLocalPort();
                ssc.close();
                return port;
            }
            catch (Throwable e) {
                if (ssc == null) continue;
                try {
                    ssc.close();
                }
                catch (Throwable f) {
                    Debug.printStackTrace(e);
                }
                ssc = null;
                continue;
            }
        }
        throw new IOException("No bindable ports found");
    }

    protected void bind(ServerSocketChannel ssc, InetAddress address, int port) throws IOException {
        if (address == null) {
            ssc.socket().bind(new InetSocketAddress(port), 1024);
        } else {
            ssc.socket().bind(new InetSocketAddress(address, port), 1024);
        }
    }

    @Override
    public InetAddress guessRoutableBindAddress() {
        try {
            ArrayList<InetAddress> local_addresses = new ArrayList<InetAddress>();
            ArrayList<InetAddress> non_local_addresses = new ArrayList<InetAddress>();
            try {
                NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
                ArrayList<InetAddress> possible = new ArrayList<InetAddress>();
                for (int i = 0; i < interfaces.length; ++i) {
                    NetworkAdminNetworkInterface intf = interfaces[i];
                    NetworkAdminNetworkInterfaceAddress[] addresses = intf.getAddresses();
                    for (int j = 0; j < addresses.length; ++j) {
                        NetworkAdminNetworkInterfaceAddress address = addresses[j];
                        InetAddress ia = address.getAddress();
                        if (ia.isLoopbackAddress()) continue;
                        if (ia.isLinkLocalAddress() || ia.isSiteLocalAddress()) {
                            local_addresses.add(ia);
                        } else {
                            non_local_addresses.add(ia);
                        }
                        if ((!this.hasIPV4Potential() || !(ia instanceof Inet4Address)) && (!this.hasIPV6Potential() || !(ia instanceof Inet6Address))) continue;
                        possible.add(ia);
                    }
                }
                if (possible.size() == 1) {
                    return (InetAddress)possible.get(0);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                NetworkAdminSocksProxy[] socks = this.getSocksProxies();
                if (socks.length > 0) {
                    return this.mapAddressToBindIP(InetAddress.getByName(socks[0].getHost()));
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                NetworkAdminNATDevice[] nat = this.getNATDevices(AzureusCoreFactory.getSingleton());
                if (nat.length > 0) {
                    return this.mapAddressToBindIP(nat[0].getAddress());
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                final AESemaphore sem = new AESemaphore("NA:conTest");
                final InetAddress[] can_connect = new InetAddress[]{null};
                int timeout = 10000;
                for (int i = 0; i < local_addresses.size(); ++i) {
                    final InetAddress address = (InetAddress)local_addresses.get(i);
                    new AEThread2("NA:conTest", true){

                        public void run() {
                            if (NetworkAdminImpl.this.canConnectWithBind(address, 10000)) {
                                can_connect[0] = address;
                                sem.release();
                            }
                        }
                    }.start();
                }
                if (sem.reserve(10000L)) {
                    return can_connect[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (non_local_addresses.size() > 0) {
                return this.guessAddress(non_local_addresses);
            }
            if (local_addresses.size() > 0) {
                return this.guessAddress(local_addresses);
            }
            return null;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canConnectWithBind(InetAddress bind_address, int timeout) {
        boolean bl;
        Socket socket = null;
        try {
            try {
                socket = new Socket();
                socket.bind(new InetSocketAddress(bind_address, 0));
                socket.setSoTimeout(timeout);
                socket.connect(new InetSocketAddress("www.google.com", 80), timeout);
                bl = true;
                Object var7_6 = null;
                if (socket == null) return bl;
            }
            catch (Throwable e) {
                boolean bl2 = false;
                Object var7_7 = null;
                if (socket == null) return bl2;
                try {
                    socket.close();
                    return bl2;
                }
                catch (Throwable f) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (socket == null) throw throwable;
            try {}
            catch (Throwable f) {
                throw throwable;
            }
            socket.close();
            throw throwable;
        }
        try {}
        catch (Throwable f) {
            // empty catch block
            return bl;
        }
        socket.close();
        return bl;
    }

    protected InetAddress mapAddressToBindIP(InetAddress address) {
        boolean[] address_bits = this.bytesToBits(address.getAddress());
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        InetAddress best_bind_address = null;
        int best_prefix = 0;
        for (int i = 0; i < interfaces.length; ++i) {
            NetworkAdminNetworkInterface intf = interfaces[i];
            NetworkAdminNetworkInterfaceAddress[] addresses = intf.getAddresses();
            for (int j = 0; j < addresses.length; ++j) {
                NetworkAdminNetworkInterfaceAddress bind_address = addresses[j];
                InetAddress ba = bind_address.getAddress();
                byte[] bind_bytes = ba.getAddress();
                if (address_bits.length != bind_bytes.length) continue;
                boolean[] bind_bits = this.bytesToBits(bind_bytes);
                for (int k = 0; k < bind_bits.length && address_bits[k] == bind_bits[k]; ++k) {
                    if (k <= best_prefix) continue;
                    best_prefix = k;
                    best_bind_address = ba;
                }
            }
        }
        return best_bind_address;
    }

    protected boolean[] bytesToBits(byte[] bytes) {
        boolean[] res = new boolean[bytes.length * 8];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            for (int j = 0; j < 8; ++j) {
                res[i * 8 + j] = (b & (byte)(1 << 7 - j)) != 0;
            }
        }
        return res;
    }

    protected InetAddress guessAddress(List addresses) {
        InetAddress address;
        int i;
        for (i = 0; i < addresses.size(); ++i) {
            address = (InetAddress)addresses.get(i);
            String str = address.getHostAddress();
            if (!str.startsWith("192.168.0.") && !str.startsWith("192.168.1.")) continue;
            return address;
        }
        for (i = 0; i < addresses.size(); ++i) {
            address = (InetAddress)addresses.get(i);
            if (!(address instanceof Inet4Address)) continue;
            return address;
        }
        for (i = 0; i < addresses.size(); ++i) {
            address = (InetAddress)addresses.get(i);
            if (!(address instanceof Inet6Address)) continue;
            return address;
        }
        if (addresses.size() > 0) {
            return (InetAddress)addresses.get(0);
        }
        return null;
    }

    @Override
    public InetAddress getDefaultPublicAddress() {
        return this.getDefaultPublicAddress(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getDefaultPublicAddress(boolean peek) {
        InetAddress[] inetAddressArray = gdpa_lock;
        synchronized (gdpa_lock) {
            AESemaphore sem;
            long now = SystemTime.getMonotonousTime();
            if (gdpa_sem == null) {
                boolean do_lookup = true;
                if (peek && gdpa_last_lookup != 0L && now - gdpa_last_lookup <= 60000L) {
                    do_lookup = false;
                }
                if (do_lookup) {
                    gdpa_last_lookup = now;
                    gdpa_sem = sem = new AESemaphore("getDefaultPublicAddress");
                    new AEThread2("getDefaultPublicAddress"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            InetAddress address = null;
                            try {
                                block8: {
                                    try {
                                        Utilities utils = PluginInitializer.getDefaultInterface().getUtilities();
                                        address = utils.getPublicAddress();
                                        if (address != null) break block8;
                                        address = utils.getPublicAddress(true);
                                    }
                                    catch (Throwable throwable) {
                                        Object var4_5 = null;
                                        InetAddress[] inetAddressArray2 = gdpa_lock;
                                        synchronized (inetAddressArray2) {
                                            gdpa_lock[0] = address;
                                            sem.releaseForever();
                                            gdpa_sem = null;
                                            gdpa_initial_sem.releaseForever();
                                            return;
                                        }
                                    }
                                }
                                Object var4_4 = null;
                                InetAddress[] inetAddressArray = gdpa_lock;
                                synchronized (inetAddressArray) {
                                    gdpa_lock[0] = address;
                                    sem.releaseForever();
                                    gdpa_sem = null;
                                    gdpa_initial_sem.releaseForever();
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                InetAddress[] inetAddressArray = gdpa_lock;
                                synchronized (inetAddressArray) {
                                    gdpa_lock[0] = address;
                                    sem.releaseForever();
                                    gdpa_sem = null;
                                    gdpa_initial_sem.releaseForever();
                                    throw throwable;
                                }
                            }
                        }
                    }.start();
                } else {
                    sem = null;
                }
            } else {
                sem = gdpa_sem;
            }
            if (gdpa_last_fail != 0L && SystemTime.getMonotonousTime() - gdpa_last_fail < 300000L) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return gdpa_lock[0];
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (peek) {
                gdpa_initial_sem.reserve(10000L);
                inetAddressArray = gdpa_lock;
                synchronized (gdpa_lock) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return gdpa_lock[0];
                }
            }
            boolean worked = sem.reserve(10000L);
            InetAddress[] inetAddressArray2 = gdpa_lock;
            synchronized (gdpa_lock) {
                if (worked) {
                    gdpa_last_fail = 0L;
                } else {
                    gdpa_initial_sem.releaseForever();
                    gdpa_last_fail = SystemTime.getMonotonousTime();
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return gdpa_lock[0];
            }
        }
    }

    @Override
    public InetAddress getDefaultPublicAddressV6() {
        return this.getDefaultPublicAddressV6(false);
    }

    @Override
    public InetAddress getDefaultPublicAddressV6(boolean peek) {
        if (!this.supportsIPv6) {
            return null;
        }
        for (InetAddress addr : this.currentBindIPs) {
            if (!AddressUtils.isGlobalAddressV6(addr)) continue;
            return addr;
        }
        for (InetAddress addr : this.currentBindIPs) {
            if (!(addr instanceof Inet6Address) || !addr.isAnyLocalAddress()) continue;
            ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
            for (NetworkInterface iface : this.old_network_interfaces) {
                addrs.addAll(Collections.list(iface.getInetAddresses()));
            }
            return AddressUtils.pickBestGlobalV6Address(addrs);
        }
        return null;
    }

    @Override
    public boolean hasDHTIPV6() {
        if (this.hasIPV6Potential(false)) {
            InetAddress v6 = this.getDefaultPublicAddressV6();
            if (v6 == null) {
                return false;
            }
            if (Constants.IS_CVS_VERSION) {
                return true;
            }
            return !AddressUtils.isTeredo(v6);
        }
        return false;
    }

    protected void firePropertyChange(String property) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((NetworkAdminPropertyChangeListener)it.next()).propertyChanged(property);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public NetworkAdminNetworkInterface[] getInterfaces() {
        Set<NetworkInterface> interfaces = this.old_network_interfaces;
        if (interfaces == null) {
            return new NetworkAdminNetworkInterface[0];
        }
        NetworkAdminNetworkInterface[] res = new NetworkAdminNetworkInterface[interfaces.size()];
        Iterator<NetworkInterface> it = interfaces.iterator();
        int pos = 0;
        while (it.hasNext()) {
            NetworkInterface ni = it.next();
            res[pos++] = new networkInterface(ni);
        }
        return res;
    }

    @Override
    public NetworkAdminProtocol[] getOutboundProtocols(AzureusCore azureus_core) {
        NetworkAdminProtocol[] res = new NetworkAdminProtocol[]{new NetworkAdminProtocolImpl(azureus_core, 1), new NetworkAdminProtocolImpl(azureus_core, 2), new NetworkAdminProtocolImpl(azureus_core, 3)};
        return res;
    }

    @Override
    public NetworkAdminProtocol createInboundProtocol(AzureusCore azureus_core, int type, int port) {
        return new NetworkAdminProtocolImpl(azureus_core, type, port);
    }

    @Override
    public NetworkAdminProtocol[] getInboundProtocols(AzureusCore azureus_core) {
        HTTPNetworkManager http_manager;
        int port;
        ArrayList<NetworkAdminProtocolImpl> protocols = new ArrayList<NetworkAdminProtocolImpl>();
        TCPNetworkManager tcp_manager = TCPNetworkManager.getSingleton();
        if (tcp_manager.isTCPListenerEnabled()) {
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 2, tcp_manager.getTCPListeningPortNumber()));
        }
        UDPNetworkManager udp_manager = UDPNetworkManager.getSingleton();
        int done_udp = -1;
        if (udp_manager.isUDPListenerEnabled()) {
            done_udp = udp_manager.getUDPListeningPortNumber();
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 3, done_udp));
        }
        if (udp_manager.isUDPNonDataListenerEnabled() && (port = udp_manager.getUDPNonDataListeningPortNumber()) != done_udp) {
            done_udp = udp_manager.getUDPNonDataListeningPortNumber();
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 3, done_udp));
        }
        if ((http_manager = HTTPNetworkManager.getSingleton()).isHTTPListenerEnabled()) {
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 1, http_manager.getHTTPListeningPortNumber()));
        }
        return protocols.toArray(new NetworkAdminProtocol[protocols.size()]);
    }

    @Override
    public InetAddress testProtocol(NetworkAdminProtocol protocol) throws NetworkAdminException {
        return protocol.test(null);
    }

    @Override
    public boolean isSocksActive() {
        Proxy proxy = AEProxySelectorFactory.getSelector().getActiveProxy();
        return proxy != null && proxy.type() == Proxy.Type.SOCKS;
    }

    @Override
    public NetworkAdminSocksProxy createSocksProxy(String host, int port, String username, String password) {
        return new NetworkAdminSocksProxyImpl(host, "" + port, username, password);
    }

    @Override
    public NetworkAdminSocksProxy[] getSocksProxies() {
        String host = System.getProperty("socksProxyHost", "").trim();
        String port = System.getProperty("socksProxyPort", "").trim();
        String user = System.getProperty("java.net.socks.username", "").trim();
        String password = System.getProperty("java.net.socks.password", "").trim();
        ArrayList<NetworkAdminSocksProxyImpl> res = new ArrayList<NetworkAdminSocksProxyImpl>();
        NetworkAdminSocksProxyImpl p1 = new NetworkAdminSocksProxyImpl(host, port, user, password);
        if (p1.isConfigured()) {
            res.add(p1);
        }
        if (COConfigurationManager.getBooleanParameter("Proxy.Data.Enable") && !COConfigurationManager.getBooleanParameter("Proxy.Data.Same")) {
            NetworkAdminSocksProxyImpl p2;
            host = COConfigurationManager.getStringParameter("Proxy.Data.Host");
            port = COConfigurationManager.getStringParameter("Proxy.Data.Port");
            user = COConfigurationManager.getStringParameter("Proxy.Data.Username");
            if (user.trim().equalsIgnoreCase("<none>")) {
                user = "";
            }
            if ((p2 = new NetworkAdminSocksProxyImpl(host, port, user, password = COConfigurationManager.getStringParameter("Proxy.Data.Password"))).isConfigured()) {
                res.add(p2);
            }
        }
        return res.toArray(new NetworkAdminSocksProxy[res.size()]);
    }

    @Override
    public NetworkAdminHTTPProxy getHTTPProxy() {
        NetworkAdminHTTPProxyImpl res = new NetworkAdminHTTPProxyImpl();
        if (!res.isConfigured()) {
            res = null;
        }
        return res;
    }

    @Override
    public NetworkAdminNATDevice[] getNATDevices(AzureusCore azureus_core) {
        ArrayList<NetworkAdminNATDeviceImpl> devices = new ArrayList<NetworkAdminNATDeviceImpl>();
        try {
            PluginInterface upnp_pi = azureus_core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
            if (upnp_pi != null) {
                UPnPPluginService[] services;
                UPnPPlugin upnp = (UPnPPlugin)upnp_pi.getPlugin();
                for (UPnPPluginService service : services = upnp.getServices()) {
                    NetworkAdminNATDeviceImpl dev = new NetworkAdminNATDeviceImpl(service);
                    boolean same = false;
                    for (NetworkAdminNATDeviceImpl d : devices) {
                        if (!d.sameAs(dev)) continue;
                        same = true;
                        break;
                    }
                    if (same) continue;
                    devices.add(dev);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return devices.toArray(new NetworkAdminNATDevice[devices.size()]);
    }

    @Override
    public NetworkAdminASN getCurrentASN() {
        List asns = COConfigurationManager.getListParameter("ASN Details", new ArrayList());
        if (asns.size() == 0) {
            String as = "";
            String asn = "";
            String bgp = "";
            try {
                as = COConfigurationManager.getStringParameter("ASN AS");
                asn = COConfigurationManager.getStringParameter("ASN ASN");
                bgp = COConfigurationManager.getStringParameter("ASN BGP");
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            COConfigurationManager.removeParameter("ASN AS");
            COConfigurationManager.removeParameter("ASN ASN");
            COConfigurationManager.removeParameter("ASN BGP");
            COConfigurationManager.removeParameter("ASN Autocheck Performed Time");
            asns.add(this.ASNToMap(new NetworkAdminASNImpl(as, asn, bgp)));
            COConfigurationManager.setParameter("ASN Details", asns);
        }
        if (asns.size() > 0) {
            Map m = (Map)asns.get(0);
            return this.ASNFromMap(m);
        }
        return new NetworkAdminASNImpl("", "", "");
    }

    protected Map ASNToMap(NetworkAdminASNImpl x) {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        byte[] as = new byte[]{};
        byte[] asn = new byte[]{};
        byte[] bgp = new byte[]{};
        try {
            as = x.getAS().getBytes("UTF-8");
            asn = x.getASName().getBytes("UTF-8");
            bgp = x.getBGPPrefix().getBytes("UTF-8");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        m.put("as", as);
        m.put("name", asn);
        m.put("bgp", bgp);
        return m;
    }

    protected NetworkAdminASNImpl ASNFromMap(Map m) {
        String as = "";
        String asn = "";
        String bgp = "";
        try {
            as = new String((byte[])m.get("as"), "UTF-8");
            asn = new String((byte[])m.get("name"), "UTF-8");
            bgp = new String((byte[])m.get("bgp"), "UTF-8");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return new NetworkAdminASNImpl(as, asn, bgp);
    }

    @Override
    public NetworkAdminASN lookupCurrentASN(InetAddress address) throws NetworkAdminException {
        NetworkAdminASN current = this.getCurrentASN();
        if (current.matchesCIDR(address)) {
            return current;
        }
        List asns = COConfigurationManager.getListParameter("ASN Details", new ArrayList());
        for (int i = 0; i < asns.size(); ++i) {
            Map m = (Map)asns.get(i);
            NetworkAdminASNImpl x = this.ASNFromMap(m);
            if (!x.matchesCIDR(address)) continue;
            asns.remove(i);
            asns.add(0, m);
            this.firePropertyChange("AS");
            return x;
        }
        if (this.asn_ips_checked.contains(address)) {
            return current;
        }
        long now = SystemTime.getCurrentTime();
        if (now < this.last_asn_lookup_time || now - this.last_asn_lookup_time > 1800000L) {
            this.last_asn_lookup_time = now;
            NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(address);
            NetworkAdminASNImpl x = lookup.lookup();
            this.asn_ips_checked.add(address);
            asns.add(0, this.ASNToMap(x));
            this.firePropertyChange("AS");
            return x;
        }
        return current;
    }

    @Override
    public NetworkAdminASN lookupASN(InetAddress address) throws NetworkAdminException {
        NetworkAdminASN existing = this.getFromASHistory(address);
        if (existing != null) {
            return existing;
        }
        NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(address);
        NetworkAdminASNImpl result = lookup.lookup();
        this.addToASHistory(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lookupASN(final InetAddress address, final NetworkAdminASNListener listener) {
        Map<InetAddress, NetworkAdminASN> map = this.async_asn_history;
        synchronized (map) {
            NetworkAdminASN existing = this.async_asn_history.get(address);
            if (existing != null) {
                listener.success(existing);
            }
        }
        int queue_size = this.async_asn_dispacher.getQueueSize();
        if (queue_size >= 1024) {
            listener.failed(new NetworkAdminException("Too many outstanding lookups"));
        } else {
            this.async_asn_dispacher.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    Map map = NetworkAdminImpl.this.async_asn_history;
                    synchronized (map) {
                        NetworkAdminASN existing = (NetworkAdminASN)NetworkAdminImpl.this.async_asn_history.get(address);
                        if (existing != null) {
                            listener.success(existing);
                            return;
                        }
                    }
                    try {
                        NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(address);
                        NetworkAdminASNImpl result = lookup.lookup();
                        Map map2 = NetworkAdminImpl.this.async_asn_history;
                        synchronized (map2) {
                            NetworkAdminImpl.this.async_asn_history.put(address, result);
                        }
                        listener.success(result);
                    }
                    catch (NetworkAdminException e) {
                        listener.failed(e);
                    }
                    catch (Throwable e) {
                        listener.failed(new NetworkAdminException("lookup failed", e));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToASHistory(NetworkAdminASN asn) {
        List list = this.as_history;
        synchronized (list) {
            boolean found = false;
            for (int i = 0; i < this.as_history.size(); ++i) {
                NetworkAdminASN x = (NetworkAdminASN)this.as_history.get(i);
                if (!asn.getAS().equals(x.getAS())) continue;
                found = true;
                break;
            }
            if (!found) {
                this.as_history.add(asn);
                if (this.as_history.size() > 256) {
                    this.as_history.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetworkAdminASN getFromASHistory(InetAddress address) {
        List list = this.as_history;
        synchronized (list) {
            for (int i = 0; i < this.as_history.size(); ++i) {
                NetworkAdminASN x = (NetworkAdminASN)this.as_history.get(i);
                if (!x.matchesCIDR(address)) continue;
                return x;
            }
        }
        return null;
    }

    @Override
    public void runInitialChecks(AzureusCore azureus_core) {
        AZInstanceManager i_man = azureus_core.getInstanceManager();
        final AZInstance my_instance = i_man.getMyInstance();
        i_man.addListener(new AZInstanceManagerListener(){
            private InetAddress external_address;

            public void instanceFound(AZInstance instance) {
            }

            public void instanceChanged(AZInstance instance) {
                if (instance == my_instance) {
                    InetAddress address = instance.getExternalAddress();
                    if (this.external_address == null || !this.external_address.equals(address)) {
                        this.external_address = address;
                        try {
                            NetworkAdminImpl.this.lookupCurrentASN(address);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }

            public void instanceLost(AZInstance instance) {
            }

            public void instanceTracked(AZInstanceTracked instance) {
            }
        });
        if (COConfigurationManager.getBooleanParameter("Proxy.Check.On.Start")) {
            NetworkAdminSocksProxy[] socks = this.getSocksProxies();
            for (int i = 0; i < socks.length; ++i) {
                NetworkAdminSocksProxy sock = socks[i];
                try {
                    sock.getVersionsSupported();
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    Logger.log(new LogAlert(true, 1, "Socks proxy " + sock.getName() + " check failed: " + Debug.getNestedExceptionMessage(e)));
                }
            }
            NetworkAdminHTTPProxy http_proxy = this.getHTTPProxy();
            if (http_proxy != null) {
                try {
                    http_proxy.getDetails();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    Logger.log(new LogAlert(true, 1, "HTTP proxy " + http_proxy.getName() + " check failed: " + Debug.getNestedExceptionMessage(e)));
                }
            }
        }
        if (COConfigurationManager.getBooleanParameter("Check Bind IP On Start")) {
            this.checkBindAddresses(true);
        }
        NetworkAdminSpeedTestScheduler nast = NetworkAdminSpeedTestSchedulerImpl.getInstance();
        nast.initialise();
    }

    @Override
    public boolean canTraceRoute() {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        return pm.hasCapability(PlatformManagerCapabilities.TraceRouteAvailability);
    }

    public NetworkAdminNode[] getRoute(InetAddress interface_address, InetAddress target, final int max_millis, final NetworkAdminRouteListener listener) throws NetworkAdminException {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        if (!this.canTraceRoute()) {
            throw new NetworkAdminException("No trace-route capability on platform");
        }
        final ArrayList nodes = new ArrayList();
        try {
            pm.traceRoute(interface_address, target, new PlatformManagerPingCallback(){
                private long start_time = SystemTime.getCurrentTime();

                public boolean reportNode(int distance, InetAddress address, int millis) {
                    boolean timeout = false;
                    if (max_millis >= 0) {
                        long now = SystemTime.getCurrentTime();
                        if (now < this.start_time) {
                            this.start_time = now;
                        }
                        if (now - this.start_time >= (long)max_millis) {
                            timeout = true;
                        }
                    }
                    networkNode node = null;
                    if (address != null) {
                        node = new networkNode(address, distance, millis);
                        nodes.add(node);
                    }
                    boolean result = listener == null ? true : (node == null ? listener.timeout(distance) : listener.foundNode(node, distance, millis));
                    return result && !timeout;
                }
            });
        }
        catch (PlatformManagerException e) {
            throw new NetworkAdminException("trace-route failed", e);
        }
        return nodes.toArray(new NetworkAdminNode[nodes.size()]);
    }

    @Override
    public boolean canPing() {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        return pm.hasCapability(PlatformManagerCapabilities.PingAvailability);
    }

    public NetworkAdminNode pingTarget(InetAddress interface_address, InetAddress target, final int max_millis, final NetworkAdminRouteListener listener) throws NetworkAdminException {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        if (!this.canPing()) {
            throw new NetworkAdminException("No ping capability on platform");
        }
        final NetworkAdminNode[] nodes = new NetworkAdminNode[]{null};
        try {
            pm.ping(interface_address, target, new PlatformManagerPingCallback(){
                private long start_time = SystemTime.getCurrentTime();

                public boolean reportNode(int distance, InetAddress address, int millis) {
                    boolean timeout = false;
                    if (max_millis >= 0) {
                        long now = SystemTime.getCurrentTime();
                        if (now < this.start_time) {
                            this.start_time = now;
                        }
                        if (now - this.start_time >= (long)max_millis) {
                            timeout = true;
                        }
                    }
                    networkNode node = null;
                    if (address != null) {
                        node = new networkNode(address, distance, millis);
                        nodes[0] = node;
                    }
                    boolean result = listener == null ? false : (node == null ? listener.timeout(distance) : listener.foundNode(node, distance, millis));
                    return result && !timeout;
                }
            });
        }
        catch (PlatformManagerException e) {
            throw new NetworkAdminException("ping failed", e);
        }
        return nodes[0];
    }

    @Override
    public void getRoutes(final InetAddress target, int max_millis, final NetworkAdminRoutesListener listener) throws NetworkAdminException {
        int i;
        ArrayList<AESemaphore> sems = new ArrayList<AESemaphore>();
        ArrayList traces = new ArrayList();
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            NetworkAdminNetworkInterface interf = interfaces[i];
            NetworkAdminNetworkInterfaceAddress[] addresses = interf.getAddresses();
            for (int j = 0; j < addresses.length; ++j) {
                final NetworkAdminNetworkInterfaceAddress address = addresses[j];
                InetAddress ia = address.getAddress();
                if (ia.isLoopbackAddress() || ia instanceof Inet6Address) continue;
                final AESemaphore sem = new AESemaphore("parallelRouter");
                final ArrayList trace = new ArrayList();
                sems.add(sem);
                traces.add(trace);
                new AEThread2("parallelRouter", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            try {
                                address.getRoute(target, 30000, new NetworkAdminRouteListener(){

                                    public boolean foundNode(NetworkAdminNode node, int distance, int rtt) {
                                        trace.add(node);
                                        NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                        trace.toArray(route);
                                        return listener.foundNode(address, route, distance, rtt);
                                    }

                                    public boolean timeout(int distance) {
                                        NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                        trace.toArray(route);
                                        return listener.timeout(address, route, distance);
                                    }
                                });
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                Object var3_2 = null;
                                sem.release();
                            }
                            Object var3_1 = null;
                            sem.release();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            sem.release();
                            throw throwable;
                        }
                    }
                }.start();
            }
        }
        for (i = 0; i < sems.size(); ++i) {
            ((AESemaphore)sems.get(i)).reserve();
        }
    }

    @Override
    public void pingTargets(final InetAddress target, int max_millis, final NetworkAdminRoutesListener listener) throws NetworkAdminException {
        int i;
        ArrayList<AESemaphore> sems = new ArrayList<AESemaphore>();
        ArrayList traces = new ArrayList();
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            NetworkAdminNetworkInterface interf = interfaces[i];
            NetworkAdminNetworkInterfaceAddress[] addresses = interf.getAddresses();
            for (int j = 0; j < addresses.length; ++j) {
                final NetworkAdminNetworkInterfaceAddress address = addresses[j];
                InetAddress ia = address.getAddress();
                if (ia.isLoopbackAddress() || ia instanceof Inet6Address) continue;
                final AESemaphore sem = new AESemaphore("parallelPinger");
                final ArrayList trace = new ArrayList();
                sems.add(sem);
                traces.add(trace);
                new AEThread2("parallelPinger", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            try {
                                address.pingTarget(target, 30000, new NetworkAdminRouteListener(){

                                    public boolean foundNode(NetworkAdminNode node, int distance, int rtt) {
                                        trace.add(node);
                                        NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                        trace.toArray(route);
                                        return listener.foundNode(address, route, distance, rtt);
                                    }

                                    public boolean timeout(int distance) {
                                        NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                        trace.toArray(route);
                                        return listener.timeout(address, route, distance);
                                    }
                                });
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                Object var3_2 = null;
                                sem.release();
                            }
                            Object var3_1 = null;
                            sem.release();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            sem.release();
                            throw throwable;
                        }
                    }
                }.start();
            }
        }
        for (i = 0; i < sems.size(); ++i) {
            ((AESemaphore)sems.get(i)).reserve();
        }
    }

    @Override
    public boolean mustBind() {
        return this.forceBind;
    }

    @Override
    public boolean hasMissingForcedBind() {
        Object[] status = this.getBindingStatus();
        return (Integer)status[0] == 3;
    }

    @Override
    public String getBindStatus() {
        Object[] status = this.getBindingStatus();
        int state = (Integer)status[0];
        if (state == 0) {
            return "No binding configured";
        }
        String str = "";
        str = state == 1 ? "Binding OK" : (state == 2 ? "Binding warning" : "Binding error");
        String status_str = (String)status[1];
        if (status_str.length() > 0) {
            str = str + ": " + status_str;
        }
        return str;
    }

    public Object[] getBindingStatus() {
        int[] counts;
        InetAddress address;
        long now = SystemTime.getMonotonousTime();
        if (this.bs_last_value != null && now - this.bs_last_calc < 30000L) {
            return this.bs_last_value;
        }
        String bind_ips = COConfigurationManager.getStringParameter("Bind IP", "").trim();
        if (bind_ips.length() == 0) {
            return new Object[]{0, ""};
        }
        boolean enforceBind = COConfigurationManager.getBooleanParameter("Enforce Bind IP");
        String missing = this.checkBindAddresses(false);
        InetAddress[] binds = this.getAllBindAddresses(false);
        ArrayList<InetAddress> bindable = new ArrayList<InetAddress>();
        ArrayList<InetAddress> unbindable = new ArrayList<InetAddress>();
        for (InetAddress b : binds) {
            if (this.canBind(b)) {
                bindable.add(b);
                continue;
            }
            if (b.isLoopbackAddress() || b.isLinkLocalAddress()) continue;
            unbindable.add(b);
        }
        Set<NetworkConnectionBase> connections = NetworkManager.getSingleton().getConnections();
        HashMap<InetAddress, int[]> lookup_map = new HashMap<InetAddress, int[]>();
        for (NetworkConnectionBase connection : connections) {
            InetSocketAddress socket_address;
            Transport transport;
            TransportStartpoint start;
            TransportBase tb = connection.getTransportBase();
            if (!(tb instanceof Transport) || (start = (transport = (Transport)tb).getTransportStartpoint()) == null || (socket_address = start.getProtocolStartpoint().getAddress()) == null) continue;
            address = socket_address.getAddress();
            counts = (int[])lookup_map.get(address);
            if (counts == null) {
                counts = new int[2];
                lookup_map.put(address, counts);
            }
            if (connection.isIncoming()) {
                counts[0] = counts[0] + 1;
                continue;
            }
            counts[1] = counts[1] + 1;
        }
        int status = 1;
        if (unbindable.size() > 0 || missing != null) {
            status = enforceBind ? 3 : 2;
        }
        String str = MessageText.getString("network.admin.binding.state", new String[]{this.getString(bindable), MessageText.getString(enforceBind ? "GeneralView.yes" : "GeneralView.no").toLowerCase()});
        if (unbindable.size() > 0) {
            str = str + "\nUnbindable: " + this.getString(unbindable);
        }
        if (missing != null) {
            str = str + "\n" + MessageText.getString("label.missing") + ": " + missing;
        }
        boolean unbound_connections = false;
        if (lookup_map.size() == 0) {
            str = str + "\n" + MessageText.getString("label.no.connections");
        } else {
            String con_str = "";
            for (Map.Entry entry : lookup_map.entrySet()) {
                String s;
                address = (InetAddress)entry.getKey();
                counts = (int[])entry.getValue();
                if (address.isAnyLocalAddress()) {
                    s = "*";
                    unbound_connections = true;
                } else {
                    s = address.getHostAddress();
                    if (!bindable.contains(address)) {
                        unbound_connections = true;
                    }
                }
                s = s + " - " + MessageText.getString("label.in") + "=" + counts[0] + ", " + MessageText.getString("label.out") + "=" + counts[1];
                con_str = con_str + (con_str.length() == 0 ? "" : "; ") + s.toLowerCase();
            }
            str = str + "\n" + MessageText.getString("label.connections") + ": " + con_str;
        }
        if (unbound_connections) {
            status = enforceBind ? 3 : 2;
        }
        this.bs_last_value = new Object[]{status, str};
        this.bs_last_calc = now;
        return this.bs_last_value;
    }

    private String getString(List<InetAddress> addresses) {
        if (addresses.size() == 0) {
            return "<none>";
        }
        String str = "";
        for (InetAddress address : addresses) {
            str = str + (str.length() == 0 ? "" : ", ") + address.getHostAddress();
        }
        return str;
    }

    private void checkConnectionRoutes() {
        if (this.getAllBindAddresses(false).length > 0) {
            return;
        }
        Set<NetworkConnectionBase> connections = NetworkManager.getSingleton().getConnections();
        boolean found_wildcard = false;
        int tcp_found = 0;
        HashMap<InetAddress, Object[]> lookup_map = new HashMap<InetAddress, Object[]>();
        HashMap<String, Object[]> bind_map = new HashMap<String, Object[]>();
        for (NetworkConnectionBase connection : connections) {
            InetSocketAddress socket_address;
            TransportStartpoint start;
            Transport transport;
            TransportBase tb;
            if (connection.isIncoming() || !((tb = connection.getTransportBase()) instanceof Transport) || !(transport = (Transport)tb).isTCP() || (start = transport.getTransportStartpoint()) == null || (socket_address = start.getProtocolStartpoint().getAddress()) == null) continue;
            ++tcp_found;
            InetAddress address = socket_address.getAddress();
            if (address.isAnyLocalAddress()) {
                found_wildcard = true;
                continue;
            }
            Object[] details = (Object[])lookup_map.get(address);
            if (details == null && !lookup_map.containsKey(address)) {
                details = this.getInterfaceForAddress(address);
                lookup_map.put(address, details);
            }
            if (details == null || !(details[0] instanceof NetworkInterface)) continue;
            NetworkInterface intf = (NetworkInterface)details[0];
            InetAddress intf_address = details.length == 1 ? null : (InetAddress)details[1];
            String key = intf.getName() + "/" + intf_address;
            Object[] entry = (Object[])bind_map.get(key);
            if (entry == null) {
                entry = new Object[]{new int[1], details};
                bind_map.put(key, entry);
            }
            int[] nArray = (int[])entry[0];
            nArray[0] = nArray[0] + 1;
        }
        if (tcp_found > 8) {
            InetAddress[] bindable_addresses;
            Object[] bound_details;
            NetworkInterface bound_intf;
            int bound_type;
            if (found_wildcard && bind_map.size() == 0) {
                InetAddress[] bindable_addresses2 = this.getBindableAddresses(true, true);
                if (bindable_addresses2.length > 1) {
                    HashMap<String, NetworkInterface> intf_map = new HashMap<String, NetworkInterface>();
                    for (InetAddress address : bindable_addresses2) {
                        Object[] details = this.getInterfaceForAddress(address);
                        if (details == null || !(details[0] instanceof NetworkInterface)) continue;
                        NetworkInterface intf = (NetworkInterface)details[0];
                        intf_map.put(intf.getName(), intf);
                    }
                    if (intf_map.size() > 1) {
                        int eth_like = 0;
                        HashMap vpn_like = new HashMap();
                        for (Map.Entry entry : intf_map.entrySet()) {
                            int type = this.categoriseIntf((NetworkInterface)entry.getValue());
                            if (type == 1) {
                                ++eth_like;
                                continue;
                            }
                            if (type != 2) continue;
                            vpn_like.put(entry.getKey(), entry.getValue());
                        }
                        if (vpn_like.size() == 1 && eth_like > 0) {
                            this.maybeVPN((NetworkInterface)vpn_like.values().iterator().next());
                        }
                    }
                }
            } else if (!found_wildcard && bind_map.size() == 1 && (bound_type = this.categoriseIntf(bound_intf = (NetworkInterface)(bound_details = (Object[])((Object[])bind_map.values().iterator().next())[1])[0])) == 2 && !this.maybeVPNDone(bound_intf) && (bindable_addresses = this.getBindableAddresses(true, true)).length > 1) {
                int eth_like = 0;
                int vpn_like = 0;
                for (InetAddress address : bindable_addresses) {
                    NetworkInterface intf;
                    Object[] details = this.getInterfaceForAddress(address);
                    if (details == null || !(details[0] instanceof NetworkInterface) || (intf = (NetworkInterface)details[0]) == bound_intf) continue;
                    int type = this.categoriseIntf(intf);
                    if (type == 1) {
                        ++eth_like;
                        continue;
                    }
                    if (type != 2) continue;
                    ++vpn_like;
                }
                if (vpn_like == 0 && eth_like > 0) {
                    this.maybeVPN(bound_intf);
                }
            }
        }
    }

    private void clearMaybeVPNs() {
        Set<String> keys = COConfigurationManager.getDefinedParameters();
        for (String key : keys) {
            if (!key.startsWith("network.admin.maybe.vpn.done.")) continue;
            COConfigurationManager.removeParameter(key);
        }
    }

    private boolean maybeVPNDone(NetworkInterface intf) {
        return COConfigurationManager.getBooleanParameter("network.admin.maybe.vpn.done." + this.getConfigKey(intf), false);
    }

    private void maybeVPN(final NetworkInterface intf) {
        final UIManager ui_manager = StaticUtilities.getUIManager(5000L);
        if (ui_manager == null) {
            return;
        }
        if (this.maybeVPNDone(intf)) {
            return;
        }
        COConfigurationManager.setParameter("network.admin.maybe.vpn.done." + this.getConfigKey(intf), true);
        new AEThread2("NetworkAdmin:vpn?"){

            public void run() {
                String msg_details = MessageText.getString("network.admin.maybe.vpn.msg", new String[]{intf.getName() + " - " + intf.getDisplayName()});
                long res = ui_manager.showMessageBox("network.admin.maybe.vpn.title", "!" + msg_details + "!", 36L);
                if (res == 4L) {
                    COConfigurationManager.setParameter("User Mode", 2);
                    COConfigurationManager.setParameter("Bind IP", intf.getName());
                    COConfigurationManager.setParameter("Enforce Bind IP", true);
                    COConfigurationManager.setParameter("Check Bind IP On Start", true);
                    COConfigurationManager.save();
                    try {
                        Set<NetworkConnectionBase> connections = NetworkManager.getSingleton().getConnections();
                        HashMap<InetAddress, Object[]> lookup_map = new HashMap<InetAddress, Object[]>();
                        for (NetworkConnectionBase connection : connections) {
                            InetAddress address;
                            Object[] details;
                            InetSocketAddress socket_address;
                            TransportStartpoint start;
                            TransportBase tb = connection.getTransportBase();
                            if (!(tb instanceof Transport)) continue;
                            boolean ok = false;
                            Transport transport = (Transport)tb;
                            if (transport.isTCP() && (start = transport.getTransportStartpoint()) != null && (socket_address = start.getProtocolStartpoint().getAddress()) != null && (details = (Object[])lookup_map.get(address = socket_address.getAddress())) == null) {
                                if (!lookup_map.containsKey(address)) {
                                    details = NetworkAdminImpl.this.getInterfaceForAddress(address);
                                    lookup_map.put(address, details);
                                }
                                if (details[0] == intf) {
                                    ok = true;
                                }
                            }
                            if (ok) continue;
                            transport.close("Explicit bind IP set, disconnecting incompatible connections");
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    NetworkAdminImpl.this.bs_last_calc = 0L;
                    ui_manager.showMessageBox("settings.updated.title", "settings.updated.msg", 1L);
                }
            }
        }.start();
    }

    private String getConfigKey(NetworkInterface intf) {
        try {
            return Base32.encode(intf.getName().getBytes("UTF-8"));
        }
        catch (Throwable e) {
            Debug.out(e);
            return "derp";
        }
    }

    private int categoriseIntf(NetworkInterface intf) {
        String name = intf.getName().toLowerCase();
        String desc = intf.getDisplayName().toLowerCase();
        if (desc.startsWith("tap-") || desc.contains("vpn")) {
            return 2;
        }
        if (name.startsWith("ppp")) {
            return 2;
        }
        if (name.startsWith("tun")) {
            return 2;
        }
        if (name.startsWith("eth") || name.startsWith("en")) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String classifyRoute(InetAddress address) {
        Map<String, AddressHistoryRecord> map = this.address_history;
        synchronized (map) {
            if (this.address_history_update_time == 0L) {
                return "Initializing";
            }
            byte[] address_bytes = address.getAddress();
            AddressHistoryRecord best_entry = null;
            int best_prefix = 0;
            for (AddressHistoryRecord entry : this.address_history.values()) {
                InetAddress other_address = entry.getAddress();
                byte[] other_bytes = other_address.getAddress();
                if (other_bytes.length != address_bytes.length) continue;
                int prefix_len = 0;
                for (int i = 0; i < other_bytes.length; ++i) {
                    byte b1 = address_bytes[i];
                    byte b2 = other_bytes[i];
                    if (b1 == b2) {
                        prefix_len += 8;
                        continue;
                    }
                    for (int j = 7; j >= 1 && (b1 >> j & 1) == (b2 >> j & 1); --j) {
                        ++prefix_len;
                    }
                    break;
                }
                if (prefix_len <= best_prefix) continue;
                best_prefix = prefix_len;
                best_entry = entry;
            }
            if (best_entry == null) {
                return "Unknown";
            }
            return best_entry.getName(this.address_history_update_time);
        }
    }

    public Object[] getInterfaceForAddress(InetAddress address) {
        byte[] address_bytes = address.getAddress();
        Set<NetworkInterface> interfaces = this.old_network_interfaces;
        if (interfaces == null) {
            return null;
        }
        NetworkInterface best_intf = null;
        InetAddress best_addr = null;
        int best_prefix = 0;
        for (NetworkInterface intf : interfaces) {
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            int num_addresses = 0;
            InetAddress derp = null;
            while (addresses.hasMoreElements()) {
                InetAddress other_address = addresses.nextElement();
                byte[] other_bytes = other_address.getAddress();
                if (other_bytes.length != address_bytes.length) continue;
                ++num_addresses;
                int prefix_len = 0;
                for (int i = 0; i < other_bytes.length; ++i) {
                    byte b1 = address_bytes[i];
                    byte b2 = other_bytes[i];
                    if (b1 == b2) {
                        prefix_len += 8;
                        continue;
                    }
                    for (int j = 7; j >= 1 && (b1 >> j & 1) == (b2 >> j & 1); --j) {
                        ++prefix_len;
                    }
                    break;
                }
                if (prefix_len <= best_prefix) continue;
                best_prefix = prefix_len;
                best_intf = intf;
                best_addr = null;
                derp = other_address;
            }
            if (derp == null || num_addresses <= true) continue;
            best_addr = derp;
        }
        if (best_addr != null) {
            return new Object[]{best_intf, best_addr};
        }
        if (best_intf != null) {
            return new Object[]{best_intf};
        }
        return new Object[]{address};
    }

    @Override
    public void addPropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addAndFirePropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.add(listener);
        for (int i = 0; i < NetworkAdmin.PR_NAMES.length; ++i) {
            try {
                listener.propertyChanged(PR_NAMES[i]);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void removePropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Network Admin");
        try {
            writer.indent();
            try {
                writer.println("Binding Details");
                writer.indent();
                boolean enforceBind = COConfigurationManager.getBooleanParameter("Enforce Bind IP");
                writer.println("bind to: " + this.getString(this.getAllBindAddresses(false)) + ", enforce=" + enforceBind);
                writer.println("bindable: " + this.getString(this.getBindableAddresses()));
                writer.println("ipv6_enabled=" + this.IPv6_enabled);
                writer.println("ipv4_potential=" + this.hasIPV4Potential());
                writer.println("ipv6_potential=" + this.hasIPV6Potential(false) + "/" + this.hasIPV6Potential(true));
                try {
                    writer.println("single homed: " + this.getSingleHomedServiceBindAddress());
                }
                catch (Throwable e) {
                    writer.println("single homed: none");
                }
                try {
                    writer.println("single homed (4): " + this.getSingleHomedServiceBindAddress(1));
                }
                catch (Throwable e) {
                    writer.println("single homed (4): none");
                }
                try {
                    writer.println("single homed (6): " + this.getSingleHomedServiceBindAddress(2));
                }
                catch (Throwable e) {
                    writer.println("single homed (6): none");
                }
                writer.println("multi homed, nio=false: " + this.getString(this.getMultiHomedServiceBindAddresses(false)));
                writer.println("multi homed, nio=true:  " + this.getString(this.getMultiHomedServiceBindAddresses(true)));
                Object var5_9 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                writer.exdent();
                throw throwable;
            }
            NetworkAdminHTTPProxy proxy = this.getHTTPProxy();
            if (proxy == null) {
                writer.println("HTTP proxy: none");
            } else {
                writer.println("HTTP proxy: " + proxy.getName());
                try {
                    NetworkAdminHTTPProxy.Details details = proxy.getDetails();
                    writer.println("    name: " + details.getServerName());
                    writer.println("    resp: " + details.getResponse());
                    writer.println("    auth: " + details.getAuthenticationType());
                }
                catch (NetworkAdminException e) {
                    writer.println("    failed: " + e.getLocalizedMessage());
                }
            }
            NetworkAdminSocksProxy[] socks = this.getSocksProxies();
            if (socks.length == 0) {
                writer.println("Socks proxy: none");
            } else {
                for (int i = 0; i < socks.length; ++i) {
                    NetworkAdminSocksProxy sock = socks[i];
                    writer.println("Socks proxy: " + sock.getName());
                    try {
                        String[] versions = sock.getVersionsSupported();
                        String str = "";
                        for (int j = 0; j < versions.length; ++j) {
                            str = str + (j == 0 ? "" : ",") + versions[j];
                        }
                        writer.println("   version: " + str);
                        continue;
                    }
                    catch (NetworkAdminException e) {
                        writer.println("    failed: " + e.getLocalizedMessage());
                    }
                }
            }
            try {
                NetworkAdminNATDevice[] nat_devices = this.getNATDevices(AzureusCoreFactory.getSingleton());
                writer.println("NAT Devices: " + nat_devices.length);
                for (int i = 0; i < nat_devices.length; ++i) {
                    NetworkAdminNATDevice device = nat_devices[i];
                    writer.println("    " + device.getName() + ",address=" + device.getAddress().getHostAddress() + ":" + device.getPort() + ",ext=" + device.getExternalAddress());
                }
            }
            catch (Exception e) {
                writer.println("Nat Devices: Can't get -> " + e.toString());
            }
            writer.println("Interfaces");
            writer.println("   " + this.getNetworkInterfacesAsString());
            Object var10_20 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var10_21 = null;
            writer.exdent();
            throw throwable;
        }
    }

    private String getString(InetAddress[] addresses) {
        String str = "";
        for (InetAddress address : addresses) {
            str = str + (str.length() == 0 ? "" : ", ") + address.getHostAddress();
        }
        return str;
    }

    @Override
    public void generateDiagnostics(final IndentWriter iw) {
        HashSet<InetAddress> public_addresses = new HashSet<InetAddress>();
        NetworkAdminHTTPProxy proxy = this.getHTTPProxy();
        if (proxy == null) {
            iw.println("HTTP proxy: none");
        } else {
            iw.println("HTTP proxy: " + proxy.getName());
            try {
                NetworkAdminHTTPProxy.Details details = proxy.getDetails();
                iw.println("    name: " + details.getServerName());
                iw.println("    resp: " + details.getResponse());
                iw.println("    auth: " + details.getAuthenticationType());
            }
            catch (NetworkAdminException e) {
                iw.println("    failed: " + e.getLocalizedMessage());
            }
        }
        NetworkAdminSocksProxy[] socks = this.getSocksProxies();
        if (socks.length == 0) {
            iw.println("Socks proxy: none");
        } else {
            for (int i = 0; i < socks.length; ++i) {
                NetworkAdminSocksProxy sock = socks[i];
                iw.println("Socks proxy: " + sock.getName());
                try {
                    String[] versions = sock.getVersionsSupported();
                    String str = "";
                    for (int j = 0; j < versions.length; ++j) {
                        str = str + (j == 0 ? "" : ",") + versions[j];
                    }
                    iw.println("   version: " + str);
                    continue;
                }
                catch (NetworkAdminException e) {
                    iw.println("    failed: " + e.getLocalizedMessage());
                }
            }
        }
        try {
            NetworkAdminNATDevice[] nat_devices = this.getNATDevices(AzureusCoreFactory.getSingleton());
            iw.println("NAT Devices: " + nat_devices.length);
            for (int i = 0; i < nat_devices.length; ++i) {
                NetworkAdminNATDevice device = nat_devices[i];
                iw.println("    " + device.getName() + ",address=" + device.getAddress().getHostAddress() + ":" + device.getPort() + ",ext=" + device.getExternalAddress());
                public_addresses.add(device.getExternalAddress());
            }
        }
        catch (Exception e) {
            iw.println("Nat Devices: Can't get -> " + e.toString());
        }
        iw.println("Interfaces");
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        try {
            this.pingTargets(InetAddress.getByName("www.google.com"), 30000, new NetworkAdminRoutesListener(){
                private int timeouts = 0;

                public boolean foundNode(NetworkAdminNetworkInterfaceAddress intf, NetworkAdminNode[] route, int distance, int rtt) {
                    iw.println(intf.getAddress().getHostAddress() + ": " + route[route.length - 1].getAddress().getHostAddress() + " (" + distance + ")");
                    return false;
                }

                public boolean timeout(NetworkAdminNetworkInterfaceAddress intf, NetworkAdminNode[] route, int distance) {
                    iw.println(intf.getAddress().getHostAddress() + ": timeout (dist=" + distance + ")");
                    ++this.timeouts;
                    return this.timeouts < 3;
                }
            });
        }
        catch (Throwable e) {
            iw.println("getRoutes failed: " + Debug.getNestedExceptionMessage(e));
        }
        iw.println("Inbound protocols: default routing");
        if (AzureusCoreFactory.isCoreRunning()) {
            InetAddress ext_addr;
            int i;
            AzureusCore azureus_core = AzureusCoreFactory.getSingleton();
            NetworkAdminProtocol[] protocols = this.getInboundProtocols(azureus_core);
            for (i = 0; i < protocols.length; ++i) {
                NetworkAdminProtocol protocol = protocols[i];
                try {
                    ext_addr = this.testProtocol(protocol);
                    if (ext_addr != null) {
                        public_addresses.add(ext_addr);
                    }
                    iw.println("    " + protocol.getName() + " - " + ext_addr);
                    continue;
                }
                catch (NetworkAdminException e) {
                    iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                }
            }
            iw.println("Outbound protocols: default routing");
            protocols = this.getOutboundProtocols(azureus_core);
            for (i = 0; i < protocols.length; ++i) {
                NetworkAdminProtocol protocol = protocols[i];
                try {
                    ext_addr = this.testProtocol(protocol);
                    if (ext_addr != null) {
                        public_addresses.add(ext_addr);
                    }
                    iw.println("    " + protocol.getName() + " - " + ext_addr);
                    continue;
                }
                catch (NetworkAdminException e) {
                    iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                }
            }
        }
        Iterator it = public_addresses.iterator();
        iw.println("Public Addresses");
        while (it.hasNext()) {
            InetAddress pub_address = (InetAddress)it.next();
            try {
                NetworkAdminASN res = this.lookupCurrentASN(pub_address);
                iw.println("    " + pub_address.getHostAddress() + " -> " + res.getAS() + "/" + res.getASName());
            }
            catch (Throwable e) {
                iw.println("    " + pub_address.getHostAddress() + " -> " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    protected void generateDiagnostics(IndentWriter iw, NetworkAdminProtocol[] protocols) {
        for (int i = 0; i < protocols.length; ++i) {
            NetworkAdminProtocol protocol = protocols[i];
            iw.println("Testing " + protocol.getName());
            try {
                InetAddress ext_addr = this.testProtocol(protocol);
                iw.println("    -> OK, public address=" + ext_addr);
                continue;
            }
            catch (NetworkAdminException e) {
                iw.println("    -> Failed: " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    @Override
    public void logNATStatus(IndentWriter iw) {
        if (AzureusCoreFactory.isCoreRunning()) {
            this.generateDiagnostics(iw, this.getInboundProtocols(AzureusCoreFactory.getSingleton()));
        }
    }

    public static void main(String[] args) {
        boolean TEST_SOCKS_PROXY = false;
        boolean TEST_HTTP_PROXY = false;
        try {
            if (TEST_SOCKS_PROXY) {
                AESocksProxy proxy = AESocksProxyFactory.create(4567, 10000L, 10000L);
                proxy.setAllowExternalConnections(true);
                System.setProperty("socksProxyHost", "localhost");
                System.setProperty("socksProxyPort", "4567");
            }
            if (TEST_HTTP_PROXY) {
                System.setProperty("http.proxyHost", "localhost");
                System.setProperty("http.proxyPort", "3128");
                System.setProperty("https.proxyHost", "localhost");
                System.setProperty("https.proxyPort", "3128");
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication("fred", "bill".toCharArray());
                    }
                });
            }
            IndentWriter iw = new IndentWriter(new PrintWriter(System.out));
            iw.setForce(true);
            COConfigurationManager.initialise();
            AzureusCoreFactory.create();
            NetworkAdmin admin = NetworkAdminImpl.getSingleton();
            admin.generateDiagnostics(iw);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            anyLocalAddressIPv4 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
            anyLocalAddressIPv6 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
            anyLocalAddress = new InetSocketAddress(0).getAddress();
            localhostV4 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            localhostV6 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        gdpa_lock = new InetAddress[]{null};
        gdpa_initial_sem = new AESemaphore("gdpa:init");
    }

    private static class AddressHistoryRecord {
        private String ni_name;
        private boolean ni_has_multiple_addresses;
        private InetAddress address;
        private long last_seen;

        private AddressHistoryRecord(NetworkInterface _ni, InetAddress _a, long _now) {
            this.ni_name = _ni.getName();
            this.address = _a;
            this.last_seen = _now;
            Enumeration<InetAddress> addresses = _ni.getInetAddresses();
            int hits = 0;
            int len = this.address.getAddress().length;
            while (addresses.hasMoreElements()) {
                if (addresses.nextElement().getAddress().length != len) continue;
                ++hits;
            }
            this.ni_has_multiple_addresses = hits > 1;
        }

        private void setLastSeen(long t) {
            this.last_seen = t;
        }

        private long getLastSeen() {
            return this.last_seen;
        }

        private InetAddress getAddress() {
            return this.address;
        }

        private String getName(long last_update) {
            String result = this.ni_name;
            if (this.ni_has_multiple_addresses) {
                result = result + "/" + this.address.getHostAddress();
            }
            if (last_update > this.last_seen) {
                result = result + " (disconnected)";
            }
            return result;
        }
    }

    protected class networkInterface
    implements NetworkAdminNetworkInterface {
        private NetworkInterface ni;

        protected networkInterface(NetworkInterface _ni) {
            this.ni = _ni;
        }

        public String getDisplayName() {
            return this.ni.getDisplayName();
        }

        public String getName() {
            return this.ni.getName();
        }

        public NetworkAdminNetworkInterfaceAddress[] getAddresses() {
            Enumeration<InetAddress> e = this.ni.getInetAddresses();
            ArrayList<networkAddress> addresses = new ArrayList<networkAddress>();
            while (e.hasMoreElements()) {
                InetAddress address = e.nextElement();
                if (address instanceof Inet6Address && !NetworkAdminImpl.this.IPv6_enabled) continue;
                addresses.add(new networkAddress(address));
            }
            return addresses.toArray(new NetworkAdminNetworkInterfaceAddress[addresses.size()]);
        }

        public String getString() {
            String str = this.getDisplayName() + "/" + this.getName() + " [";
            NetworkAdminNetworkInterfaceAddress[] addresses = this.getAddresses();
            for (int i = 0; i < addresses.length; ++i) {
                networkAddress addr = (networkAddress)addresses[i];
                str = str + (i == 0 ? "" : ",") + addr.getAddress().getHostAddress();
            }
            return str + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateDiagnostics(IndentWriter iw, Set public_addresses) {
            iw.println(this.getDisplayName() + "/" + this.getName());
            NetworkAdminNetworkInterfaceAddress[] addresses = this.getAddresses();
            for (int i = 0; i < addresses.length; ++i) {
                Object var7_6;
                networkAddress addr = (networkAddress)addresses[i];
                iw.indent();
                try {
                    addr.generateDiagnostics(iw, public_addresses);
                    var7_6 = null;
                    iw.exdent();
                    continue;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    iw.exdent();
                    throw throwable;
                }
            }
        }

        protected class networkAddress
        implements NetworkAdminNetworkInterfaceAddress {
            private InetAddress address;

            protected networkAddress(InetAddress _address) {
                this.address = _address;
            }

            public NetworkAdminNetworkInterface getInterface() {
                return networkInterface.this;
            }

            public InetAddress getAddress() {
                return this.address;
            }

            public boolean isLoopback() {
                return this.address.isLoopbackAddress();
            }

            public NetworkAdminNode[] getRoute(InetAddress target, int max_millis, NetworkAdminRouteListener listener) throws NetworkAdminException {
                return NetworkAdminImpl.this.getRoute(this.address, target, max_millis, listener);
            }

            public NetworkAdminNode pingTarget(InetAddress target, int max_millis, NetworkAdminRouteListener listener) throws NetworkAdminException {
                return NetworkAdminImpl.this.pingTarget(this.address, target, max_millis, listener);
            }

            public InetAddress testProtocol(NetworkAdminProtocol protocol) throws NetworkAdminException {
                return protocol.test(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generateDiagnostics(IndentWriter iw, Set public_addresses) {
                iw.println("" + this.getAddress());
                try {
                    iw.println("  Trace route");
                    iw.indent();
                    if (this.isLoopback()) {
                        iw.println("Loopback - ignoring");
                    } else {
                        InetAddress res;
                        NetworkAdminProtocol protocol;
                        int i;
                        try {
                            NetworkAdminNode[] nodes = this.getRoute(InetAddress.getByName("www.google.com"), 30000, NetworkAdminImpl.this.trace_route_listener);
                            for (int i2 = 0; i2 < nodes.length; ++i2) {
                                networkNode node = (networkNode)nodes[i2];
                                iw.println(node.getString());
                            }
                        }
                        catch (Throwable e) {
                            iw.println("Can't resolve host for route trace - " + e.getMessage());
                        }
                        iw.println("Outbound protocols: bound");
                        AzureusCore azureus_core = AzureusCoreFactory.getSingleton();
                        NetworkAdminProtocol[] protocols = NetworkAdminImpl.this.getOutboundProtocols(azureus_core);
                        for (i = 0; i < protocols.length; ++i) {
                            protocol = protocols[i];
                            try {
                                res = this.testProtocol(protocol);
                                if (res != null) {
                                    public_addresses.add(res);
                                }
                                iw.println("    " + protocol.getName() + " - " + res);
                                continue;
                            }
                            catch (NetworkAdminException e) {
                                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                            }
                        }
                        iw.println("Inbound protocols: bound");
                        protocols = NetworkAdminImpl.this.getInboundProtocols(azureus_core);
                        for (i = 0; i < protocols.length; ++i) {
                            protocol = protocols[i];
                            try {
                                res = this.testProtocol(protocol);
                                if (res != null) {
                                    public_addresses.add(res);
                                }
                                iw.println("    " + protocol.getName() + " - " + res);
                                continue;
                            }
                            catch (NetworkAdminException e) {
                                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                            }
                        }
                    }
                    Object var9_13 = null;
                    iw.exdent();
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    iw.exdent();
                    throw throwable;
                }
            }
        }
    }

    protected class networkNode
    implements NetworkAdminNode {
        private InetAddress address;
        private int distance;
        private int rtt;

        protected networkNode(InetAddress _address, int _distance, int _millis) {
            this.address = _address;
            this.distance = _distance;
            this.rtt = _millis;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public boolean isLocalAddress() {
            return this.address.isLinkLocalAddress() || this.address.isSiteLocalAddress();
        }

        public int getDistance() {
            return this.distance;
        }

        public int getRTT() {
            return this.rtt;
        }

        protected String getString() {
            if (this.address == null) {
                return "" + this.distance;
            }
            return this.distance + "," + this.address + "[local=" + this.isLocalAddress() + "]," + this.rtt;
        }
    }
}

