/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagDownload;
import com.aelitis.azureus.core.tag.TagFeatureExecOnAssign;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagPeer;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.impl.TagBase;
import com.aelitis.azureus.core.tag.impl.TagTypeWithState;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.stats.transfer.LongTermStats;
import org.gudy.azureus2.core3.stats.transfer.LongTermStatsListener;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerEvent;
import org.gudy.azureus2.plugins.peers.PeerManagerListener2;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeedLimitHandler
implements LongTermStatsListener {
    private static SpeedLimitHandler singleton;
    private static Object RL_TO_BE_REMOVED_LOCK;
    private static Object RLD_TO_BE_REMOVED_KEY;
    private static Object RLU_TO_BE_REMOVED_KEY;
    private AzureusCore core;
    private PluginInterface plugin_interface;
    private TorrentAttribute category_attribute;
    private LoggerChannel logger;
    private TimerEventPeriodic schedule_event;
    private List<ScheduleRule> current_rules = new ArrayList<ScheduleRule>();
    private ScheduleRule active_rule;
    private Map<String, IPSet> current_ip_sets = new HashMap<String, IPSet>();
    private Map<String, RateLimiter> ip_set_rate_limiters_up = new HashMap<String, RateLimiter>();
    private Map<String, RateLimiter> ip_set_rate_limiters_down = new HashMap<String, RateLimiter>();
    private TimerEventPeriodic ip_set_event;
    private boolean net_limit_listener_added;
    private Map<Integer, List<NetLimit>> net_limits = new HashMap<Integer, List<NetLimit>>();
    private List<String> predefined_profile_names = new ArrayList<String>();
    private boolean rule_pause_all_active;
    private boolean net_limit_pause_all_active;
    private final IPSetTagType ip_set_tag_type;
    private DML current_dml;
    private static Object ip_set_peer_key;
    private FrequencyLimitedDispatcher check_ip_sets_limiter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpeedLimitHandler getSingleton(AzureusCore core) {
        Class<SpeedLimitHandler> clazz = SpeedLimitHandler.class;
        synchronized (SpeedLimitHandler.class) {
            if (singleton == null) {
                singleton = new SpeedLimitHandler(core);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private SpeedLimitHandler(AzureusCore _core) {
        this.predefined_profile_names.add("pause_all");
        this.predefined_profile_names.add("resume_all");
        this.ip_set_tag_type = TagManagerFactory.getTagManager().isEnabled() ? new IPSetTagType() : null;
        this.check_ip_sets_limiter = new FrequencyLimitedDispatcher(new AERunnable(){

            public void runSupport() {
                SpeedLimitHandler.this.checkIPSetsSupport();
            }
        }, 500);
        this.check_ip_sets_limiter.setSingleThreaded();
        this.core = _core;
        this.plugin_interface = this.core.getPluginManager().getDefaultPluginInterface();
        this.category_attribute = this.plugin_interface.getTorrentManager().getAttribute("Category");
        this.logger = this.plugin_interface.getLogger().getTimeStampedChannel("Speed Limit Handler");
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel("Speed Limit Handler");
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.logger.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        this.loadPauseAllActive();
        this.loadSchedule();
    }

    public boolean hasAnyProfiles() {
        if (!COConfigurationManager.hasParameter("speed.limit.handler.state", true)) {
            return false;
        }
        Map map = this.loadConfig();
        if (map.size() == 0) {
            return false;
        }
        List list = (List)map.get("profiles");
        return list != null && list.size() != 0;
    }

    private synchronized Map loadConfig() {
        return BEncoder.cloneMap(COConfigurationManager.getMapParameter("speed.limit.handler.state", new HashMap()));
    }

    private synchronized void saveConfig(Map map) {
        if (map.isEmpty()) {
            COConfigurationManager.removeParameter("speed.limit.handler.state");
        } else {
            COConfigurationManager.setParameter("speed.limit.handler.state", map);
        }
        COConfigurationManager.save();
    }

    private void loadPauseAllActive() {
        this.setRulePauseAllActive(COConfigurationManager.getBooleanParameter("speed.limit.handler.schedule.pa_active", false));
        this.setNetLimitPauseAllActive(COConfigurationManager.getBooleanParameter("speed.limit.handler.schedule.nl_pa_active", false));
    }

    private void setRulePauseAllActive(boolean active) {
        GlobalManager gm = this.core.getGlobalManager();
        if (active) {
            if (!this.rule_pause_all_active) {
                this.logger.logAlertRepeatable(1, "Pausing all downloads due to pause_all rule");
            }
            gm.pauseDownloads();
            this.rule_pause_all_active = true;
        } else {
            if (!this.net_limit_pause_all_active && COConfigurationManager.getBooleanParameter("speed.limit.handler.schedule.pa_capable", false)) {
                if (this.rule_pause_all_active) {
                    this.logger.logAlertRepeatable(1, "Resuming all downloads as pause_all rule no longer applies");
                }
                gm.resumeDownloads(true);
            }
            this.rule_pause_all_active = false;
        }
        COConfigurationManager.setParameter("speed.limit.handler.schedule.pa_active", active);
    }

    private void setNetLimitPauseAllActive(boolean active) {
        GlobalManager gm = this.core.getGlobalManager();
        if (active) {
            if (!this.net_limit_pause_all_active) {
                this.logger.logAlertRepeatable(1, "Pausing all downloads as network limit exceeded");
            }
            gm.pauseDownloads();
            this.net_limit_pause_all_active = true;
        } else {
            if (!this.rule_pause_all_active && COConfigurationManager.getBooleanParameter("speed.limit.handler.schedule.pa_capable", false)) {
                if (this.net_limit_pause_all_active) {
                    this.logger.logAlertRepeatable(1, "Resuming all downloads as network limit no longer exceeded");
                }
                gm.resumeDownloads(true);
            }
            this.net_limit_pause_all_active = false;
        }
        COConfigurationManager.setParameter("speed.limit.handler.schedule.nl_pa_active", active);
    }

    public List<String> reset() {
        if (this.net_limit_pause_all_active) {
            this.setNetLimitPauseAllActive(false);
        }
        return this.resetRules();
    }

    private List<String> resetRules() {
        if (this.rule_pause_all_active) {
            this.setRulePauseAllActive(false);
        }
        LimitDetails details = new LimitDetails();
        details.loadForReset();
        details.apply();
        return details.getString(true, false);
    }

    public List<String> getCurrent() {
        LimitDetails details = new LimitDetails();
        details.loadCurrent();
        List lines = details.getString(true, false);
        lines.add("");
        lines.add("Peer Sets");
        if (this.current_ip_sets.size() == 0) {
            lines.add("    None");
        } else {
            for (Map.Entry<String, IPSet> entry : this.current_ip_sets.entrySet()) {
                lines.add("    " + entry.getValue().getDetailString());
            }
        }
        ScheduleRule rule = this.active_rule;
        lines.add("");
        lines.add("Scheduler");
        lines.add("    Rules defined: " + this.current_rules.size());
        lines.add("    Active rule: " + (rule == null ? "None" : rule.getString()));
        lines.add("");
        lines.add("Network Totals");
        LongTermStats lt_stats = StatsFactory.getLongTermStats();
        if (lt_stats == null || !lt_stats.isEnabled()) {
            lines.add("    Not Available");
        } else {
            lines.add("    Today:\t\t" + this.getString(lt_stats, 1, this.net_limits.get(1)));
            lines.add("    This week:\t" + this.getString(lt_stats, 2, this.net_limits.get(2)));
            lines.add("    This month:\t" + this.getString(lt_stats, 3, this.net_limits.get(3)));
            lines.add("");
            lines.add("    Rate (3 minute average):\t\t" + this.getString(lt_stats.getCurrentRateBytesPerSecond(), null, true));
        }
        return lines;
    }

    private String getString(LongTermStats lts, int type, List<NetLimit> net_limits) {
        if (net_limits == null) {
            net_limits = new ArrayList<NetLimit>();
            net_limits.add(null);
        }
        String result = "";
        for (NetLimit net_limit : net_limits) {
            long[] stats2 = this.getLongTermUsage(lts, type, net_limit);
            long total_up = stats2[0] + stats2[1] + stats2[4];
            long total_do = stats2[2] + stats2[3] + stats2[5];
            String lim_str = "";
            String profile = null;
            if (net_limit != null) {
                profile = net_limit.getProfile();
                long[] limits = net_limit.getLimits();
                long total_lim = limits[0];
                long up_lim = limits[1];
                long down_lim = limits[2];
                if (total_lim > 0L) {
                    lim_str = lim_str + "Total=" + DisplayFormatters.formatByteCountToKiBEtc(total_lim) + " " + 100L * (total_up + total_do) / total_lim + "%";
                }
                if (up_lim > 0L) {
                    lim_str = lim_str + (lim_str.length() == 0 ? "" : ", ") + "Up=" + DisplayFormatters.formatByteCountToKiBEtc(up_lim) + " " + 100L * total_up / up_lim + "%";
                }
                if (down_lim > 0L) {
                    lim_str = lim_str + (lim_str.length() == 0 ? "" : ", ") + "Down=" + DisplayFormatters.formatByteCountToKiBEtc(down_lim) + " " + 100L * total_do / down_lim + "%";
                }
                if (lim_str.length() > 0) {
                    lim_str = "\t[ Limits: " + lim_str + "]";
                }
            }
            if (net_limits.size() > 1) {
                result = result + "\r\n        ";
            }
            result = result + (profile == null ? "Overall" : profile) + " - " + "Upload=" + DisplayFormatters.formatByteCountToKiBEtc(total_up) + ", Download=" + DisplayFormatters.formatByteCountToKiBEtc(total_do) + lim_str;
        }
        return result;
    }

    private long[] getLongTermUsage(LongTermStats lts, int type, NetLimit net_limit) {
        if (net_limit == null || net_limit.getProfile() == null) {
            return lts.getTotalUsageInPeriod(type);
        }
        final String profile = net_limit.getProfile();
        System.out.println("getLongTermUsage:" + profile);
        return lts.getTotalUsageInPeriod(type, new LongTermStats.RecordAccepter(){

            public boolean acceptRecord(long timestamp) {
                ScheduleRule rule = SpeedLimitHandler.this.getActiveRule(new Date(timestamp));
                return rule != null && rule.profile_name.equals(profile);
            }
        });
    }

    private String getString(long[] stats2, long[] limits, boolean is_rate) {
        long total_up = stats2[0] + stats2[1] + stats2[4];
        long total_do = stats2[2] + stats2[3] + stats2[5];
        String lim_str = "";
        if (limits != null) {
            long total_lim = limits[0];
            long up_lim = limits[1];
            long down_lim = limits[2];
            if (total_lim > 0L) {
                lim_str = lim_str + "Total=" + DisplayFormatters.formatByteCountToKiBEtc(total_lim) + " " + 100L * (total_up + total_do) / total_lim + "%";
            }
            if (up_lim > 0L) {
                lim_str = lim_str + (lim_str.length() == 0 ? "" : ", ") + "Up=" + DisplayFormatters.formatByteCountToKiBEtc(up_lim) + " " + 100L * total_up / up_lim + "%";
            }
            if (down_lim > 0L) {
                lim_str = lim_str + (lim_str.length() == 0 ? "" : ", ") + "Down=" + DisplayFormatters.formatByteCountToKiBEtc(down_lim) + " " + 100L * total_do / down_lim + "%";
            }
            if (lim_str.length() > 0) {
                lim_str = "\t[ Limits: " + lim_str + "]";
            }
        }
        if (is_rate) {
            return "Upload=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(total_up) + ", Download=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(total_do);
        }
        return "Upload=" + DisplayFormatters.formatByteCountToKiBEtc(total_up) + ", Download=" + DisplayFormatters.formatByteCountToKiBEtc(total_do) + lim_str;
    }

    public List<String> getProfileNames() {
        Map map = this.loadConfig();
        ArrayList<String> profiles = new ArrayList<String>();
        List list = (List)map.get("profiles");
        if (list != null) {
            for (Map m : list) {
                String name = this.importString(m, "n");
                if (name == null) continue;
                profiles.add(name);
            }
        }
        return profiles;
    }

    public List<String> loadProfile(String name) {
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        if (list != null) {
            for (Map m : list) {
                String p_name = this.importString(m, "n");
                if (p_name == null || !name.equals(p_name)) continue;
                Map profile = (Map)m.get("p");
                LimitDetails ld = new LimitDetails(profile);
                ld.apply();
                return ld.getString(false, false);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("Profile not found");
        return result;
    }

    private boolean profileExists(String name) {
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        if (list != null) {
            for (Map m : list) {
                String p_name = this.importString(m, "n");
                if (p_name == null || !name.equals(p_name)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getProfile(String name) {
        return this.getProfileSupport(name, false);
    }

    public List<String> getProfileSupport(String name, boolean use_hashes) {
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        if (list != null) {
            for (Map m : list) {
                String p_name = this.importString(m, "n");
                if (p_name == null || !name.equals(p_name)) continue;
                Map profile = (Map)m.get("p");
                LimitDetails ld = new LimitDetails(profile);
                return ld.getString(false, use_hashes);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("Profile not found");
        return result;
    }

    public List<String> getProfilesForDownload(byte[] hash) {
        ArrayList<String> result = new ArrayList<String>();
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        if (list != null) {
            String hash_str = Base32.encode(hash);
            for (Map m : list) {
                Map profile;
                LimitDetails ld;
                String p_name = this.importString(m, "n");
                if (p_name == null || (ld = new LimitDetails(profile = (Map)m.get("p"))).getLimitsForDownload(hash_str) == null) continue;
                result.add(p_name);
            }
        }
        return result;
    }

    private void addRemoveDownloadsToProfile(String name, List<byte[]> hashes, boolean add) {
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        ArrayList<String> hash_strs = new ArrayList<String>();
        for (byte[] hash : hashes) {
            hash_strs.add(Base32.encode(hash));
        }
        if (list != null) {
            for (Map m : list) {
                String p_name = this.importString(m, "n");
                if (p_name == null || !name.equals(p_name)) continue;
                Map profile = (Map)m.get("p");
                LimitDetails ld = new LimitDetails(profile);
                ld.addRemoveDownloads(hash_strs, add);
                m.put("p", ld.export());
                this.saveConfig(map);
                return;
            }
        }
    }

    public void addDownloadsToProfile(String name, List<byte[]> hashes) {
        this.addRemoveDownloadsToProfile(name, hashes, true);
    }

    public void removeDownloadsFromProfile(String name, List<byte[]> hashes) {
        this.addRemoveDownloadsToProfile(name, hashes, false);
    }

    public void deleteProfile(String name) {
        Map map = this.loadConfig();
        List list = (List)map.get("profiles");
        if (list != null) {
            for (Map m : list) {
                String p_name = this.importString(m, "n");
                if (p_name == null || !name.equals(p_name)) continue;
                list.remove(m);
                this.saveConfig(map);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> saveProfile(String name) {
        ScheduleRule scheduleRule;
        LimitDetails details = new LimitDetails();
        details.loadCurrent();
        Map map = this.loadConfig();
        ArrayList list = (ArrayList)map.get("profiles");
        if (list == null) {
            list = new ArrayList();
            map.put("profiles", list);
        }
        for (Map map2 : list) {
            String p_name = this.importString(map2, "n");
            if (p_name == null || !name.equals(p_name)) continue;
            list.remove(map2);
            break;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        list.add(m);
        m.put("n", name);
        m.put("p", details.export());
        this.saveConfig(map);
        SpeedLimitHandler speedLimitHandler = this;
        synchronized (speedLimitHandler) {
            scheduleRule = this.active_rule;
        }
        if (scheduleRule != null && scheduleRule.profile_name.equals(name)) {
            details.apply();
        }
        return details.getString(false, false);
    }

    private synchronized List<String> loadSchedule() {
        ArrayList<String> result = new ArrayList<String>();
        List list = COConfigurationManager.getListParameter("speed.limit.handler.schedule.lines", new ArrayList());
        List schedule_lines = BDecoder.decodeStrings(BEncoder.cloneList(list));
        boolean enabled = true;
        ArrayList<ScheduleRule> rules = new ArrayList<ScheduleRule>();
        HashMap<String, IPSet> ip_sets = new HashMap<String, IPSet>();
        HashMap<Integer, List<NetLimit>> new_net_limits = new HashMap<Integer, List<NetLimit>>();
        boolean checked_lts_enabled = false;
        boolean lts_enabled = false;
        for (String line : schedule_lines) {
            String rhs;
            String[] args;
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            String lc_line = line.toLowerCase(Locale.US);
            if (lc_line.startsWith("enable")) {
                String[] bits = lc_line.split("=");
                boolean ok = false;
                if (bits.length == 2) {
                    String arg = bits[1];
                    if (arg.equals("yes")) {
                        enabled = true;
                        ok = true;
                    } else if (arg.equals("no")) {
                        enabled = false;
                        ok = true;
                    }
                }
                if (ok) continue;
                result.add("'" + line + "' is invalid: use enable=(yes|no)");
                continue;
            }
            if (lc_line.startsWith("ip_set") || lc_line.startsWith("peer_set")) {
                try {
                    args = line.substring(lc_line.indexOf(95) + 4).split(",");
                    boolean inverse = false;
                    int up_lim = -1;
                    int down_lim = -1;
                    int peer_up_lim = 0;
                    int peer_down_lim = 0;
                    HashSet<String> categories_or_tags = new HashSet<String>();
                    IPSet set = null;
                    for (String arg : args) {
                        String[] bits = arg.split("=");
                        if (bits.length != 2) {
                            throw new Exception("Expected <key>=<value> for '" + arg + "'");
                        }
                        String lhs = bits[0].trim();
                        String lc_lhs = lhs.toLowerCase(Locale.US);
                        rhs = bits[1].trim();
                        String lc_rhs = rhs.toLowerCase(Locale.US);
                        if (lc_lhs.equals("inverse")) {
                            inverse = lc_rhs.equals("yes");
                            continue;
                        }
                        if (lc_lhs.equals("up")) {
                            up_lim = (int)this.parseRate(lc_rhs);
                            continue;
                        }
                        if (lc_lhs.equals("down")) {
                            down_lim = (int)this.parseRate(lc_rhs);
                            continue;
                        }
                        if (lc_lhs.equals("peer_up")) {
                            peer_up_lim = (int)this.parseRate(lc_rhs);
                            continue;
                        }
                        if (lc_lhs.equals("peer_down")) {
                            peer_down_lim = (int)this.parseRate(lc_rhs);
                            continue;
                        }
                        if (lc_lhs.equals("cat") || lc_lhs.equals("tag")) {
                            String[] cats;
                            for (String cat : cats = rhs.split(" ")) {
                                if ((cat = cat.trim()).length() <= 0) continue;
                                categories_or_tags.add(cat);
                            }
                            continue;
                        }
                        String name = lhs;
                        String def = rhs.replace(';', ' ');
                        set = (IPSet)ip_sets.get(name);
                        if (set == null) {
                            set = new IPSet(name);
                            ip_sets.put(name, set);
                        }
                        for (String bit : bits = def.split(" ")) {
                            if ((bit = bit.trim()).length() <= 0) continue;
                            IPSet other_set = (IPSet)ip_sets.get(bit);
                            if (other_set != null && other_set != set) {
                                set.addSet(other_set);
                                continue;
                            }
                            if (set.addCIDRorCCetc(bit)) continue;
                            result.add("CIDR, CC, Network or ip_set reference '" + bit + "' isn't valid");
                        }
                    }
                    if (set == null) {
                        throw new Exception();
                    }
                    set.setParameters(inverse, up_lim, down_lim, peer_up_lim, peer_down_lim, categories_or_tags);
                }
                catch (Throwable e) {
                    result.add("'" + line + "' is invalid: use ip_set <name>=<cidrs...> [,inverse=[yes|no]] [,up=<limit>] [,down=<limit>] [,peer_up=<limit>] [,peer_down=<limit>] [,cat=<categories>]: " + e.getMessage());
                }
                continue;
            }
            if (lc_line.startsWith("net_limit")) {
                if (!checked_lts_enabled) {
                    checked_lts_enabled = true;
                    lts_enabled = StatsFactory.getLongTermStats().isEnabled();
                    if (!lts_enabled) {
                        result.add("Long-term stats are currently disabled, limits will NOT be applied");
                    }
                }
                line = lc_line.substring(9).replace(",", " ");
                args = line.split(" ");
                int type = -1;
                String profile = null;
                long total_lim = 0L;
                long up_lim = 0L;
                long down_lim = 0L;
                for (String arg : args) {
                    if ((arg = arg.trim()).length() == 0) continue;
                    if (type == -1) {
                        int sep = arg.indexOf(":");
                        if (sep != -1) {
                            profile = arg.substring(sep + 1).trim();
                            if (!this.profileExists(profile)) {
                                result.add("net_limit profile '" + profile + "' not defined");
                                break;
                            }
                            arg = arg.substring(0, sep);
                        }
                        if (arg.equalsIgnoreCase("daily")) {
                            type = 1;
                            continue;
                        }
                        if (arg.equalsIgnoreCase("weekly")) {
                            type = 2;
                            continue;
                        }
                        if (arg.equalsIgnoreCase("monthly")) {
                            type = 3;
                            continue;
                        }
                        result.add("net_limit type of '" + arg + "' not recognised - use daily, weekly or monthly");
                        break;
                    }
                    String[] bits = arg.split("=");
                    if (bits.length != 2) {
                        result.add("'" + line + "': invalid net_limit specification");
                        continue;
                    }
                    String lhs = bits[0];
                    rhs = bits[1];
                    long lim = this.parseRate(rhs);
                    if (lhs.equalsIgnoreCase("total")) {
                        total_lim = lim;
                        continue;
                    }
                    if (lhs.equalsIgnoreCase("up")) {
                        up_lim = lim;
                        continue;
                    }
                    if (lhs.equalsIgnoreCase("down")) {
                        down_lim = lim;
                        continue;
                    }
                    result.add("'" + line + "': invalid net_limit specification");
                }
                if (type == -1) continue;
                ArrayList<NetLimit> limits = (ArrayList<NetLimit>)new_net_limits.get(type);
                if (limits == null) {
                    limits = new ArrayList<NetLimit>();
                    new_net_limits.put(type, limits);
                }
                limits.add(new NetLimit(profile, total_lim, up_lim, down_lim));
                continue;
            }
            String[] _bits = line.split(" ");
            ArrayList<String> bits = new ArrayList<String>();
            for (String b : _bits) {
                if ((b = b.trim()).length() <= 0) continue;
                bits.add(b);
            }
            ArrayList<String> errors = new ArrayList<String>();
            if (bits.size() >= 6) {
                String freq_str = ((String)bits.get(0)).toLowerCase(Locale.US);
                byte freq = 0;
                if (freq_str.equals("daily")) {
                    freq = 127;
                } else if (freq_str.equals("weekdays")) {
                    freq = 31;
                } else if (freq_str.equals("weekends")) {
                    freq = 96;
                } else if (freq_str.equals("mon")) {
                    freq = 1;
                } else if (freq_str.equals("tue")) {
                    freq = 2;
                } else if (freq_str.equals("wed")) {
                    freq = 4;
                } else if (freq_str.equals("thu")) {
                    freq = 8;
                } else if (freq_str.equals("fri")) {
                    freq = 16;
                } else if (freq_str.equals("sat")) {
                    freq = 32;
                } else if (freq_str.equals("sun")) {
                    freq = 64;
                } else {
                    errors.add("frequency '" + freq_str + "' is invalid");
                }
                String profile = (String)bits.get(1);
                if (!this.profileExists(profile) && !this.predefined_profile_names.contains(profile.toLowerCase())) {
                    errors.add("profile '" + profile + "' not found");
                    profile = null;
                }
                int from_mins = -1;
                if (((String)bits.get(2)).equalsIgnoreCase("from")) {
                    from_mins = this.getMins((String)bits.get(3));
                }
                if (from_mins == -1) {
                    errors.add("'from' is invalid");
                }
                int to_mins = -1;
                if (((String)bits.get(4)).equalsIgnoreCase("to")) {
                    to_mins = this.getMins((String)bits.get(5));
                }
                if (to_mins == -1) {
                    errors.add("'to' is invalid");
                }
                ArrayList<ScheduleRuleExtensions> extensions = null;
                for (int i = 6; i < bits.size(); ++i) {
                    String extension = (String)bits.get(i);
                    String[] temp = extension.split(":");
                    boolean ok = false;
                    String extra = "";
                    if (temp.length == 2) {
                        String ext_cmd = temp[0];
                        String ext_param = temp[1];
                        if (ext_cmd.equals("start_tag") || ext_cmd.equals("stop_tag") || ext_cmd.equals("pause_tag") || ext_cmd.equals("resume_tag")) {
                            TagDownload tag = (TagDownload)TagManagerFactory.getTagManager().getTagType(3).getTag(ext_param, true);
                            if (tag == null) {
                                tag = (TagDownload)TagManagerFactory.getTagManager().getTagType(2).getTag(ext_param, true);
                            }
                            if (tag == null) {
                                extra = ", tag '" + ext_param + "' not found";
                            } else {
                                if (extensions == null) {
                                    extensions = new ArrayList<ScheduleRuleExtensions>(bits.size() - 6);
                                }
                                int et = ext_cmd.equals("start_tag") ? 1 : (ext_cmd.equals("stop_tag") ? 2 : (ext_cmd.equals("pause_tag") ? 3 : 4));
                                extensions.add(new ScheduleRuleExtensions(et, tag));
                                ok = true;
                            }
                        }
                    }
                    if (ok) continue;
                    errors.add("extension '" + extension + "' is invalid" + extra);
                }
                if (errors.size() == 0) {
                    rules.add(new ScheduleRule(freq, profile, from_mins, to_mins, extensions));
                    continue;
                }
                String err_str = "";
                for (String e : errors) {
                    err_str = err_str + (err_str.length() == 0 ? "" : ", ") + e;
                }
                result.add("'" + line + "' is invalid (" + err_str + ") - use <frequency> <profile> from <hh:mm> to <hh:mm>");
                continue;
            }
            result.add("'" + line + "' is invalid: use <frequency> <profile> from <hh:mm> to <hh:mm> [extensions]*");
        }
        boolean schedule_has_net_limits = false;
        boolean schedule_has_pausing = false;
        if (enabled) {
            if (new_net_limits.size() > 0) {
                schedule_has_net_limits = true;
            }
            for (ScheduleRule rule : rules) {
                String profile_name = rule.profile_name;
                if (!profile_name.equalsIgnoreCase("pause_all") && !profile_name.equalsIgnoreCase("resume_all")) continue;
                schedule_has_pausing = true;
                break;
            }
        }
        if (!schedule_has_pausing) {
            this.setRulePauseAllActive(false);
        }
        if (!schedule_has_net_limits) {
            this.setNetLimitPauseAllActive(false);
        }
        COConfigurationManager.setParameter("speed.limit.handler.schedule.pa_capable", enabled && (schedule_has_pausing || schedule_has_net_limits));
        if (enabled) {
            this.current_rules = rules;
            if (this.schedule_event == null && (rules.size() > 0 || this.net_limits.size() > 0)) {
                this.schedule_event = SimpleTimer.addPeriodicEvent("speed handler scheduler", 30000L, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        SpeedLimitHandler.this.checkSchedule();
                    }
                });
            }
            if (this.active_rule != null || rules.size() > 0 || this.net_limits.size() > 0) {
                this.checkSchedule();
            }
            for (IPSet s : this.current_ip_sets.values()) {
                s.destroy();
            }
            this.current_ip_sets = ip_sets;
            HashMap<IPSet, Integer> id_map = new HashMap<IPSet, Integer>();
            int id_max = -1;
            for (int i = 0; i < 2; ++i) {
                for (IPSet s : this.current_ip_sets.values()) {
                    String name = s.getName();
                    try {
                        String config_key = "speed.limit.handler.ipset_n." + Base32.encode(name.getBytes("UTF-8"));
                        if (i == 0) {
                            int existing = COConfigurationManager.getIntParameter(config_key, -1);
                            if (existing == -1) continue;
                            id_map.put(s, existing);
                            id_max = Math.max(id_max, existing);
                            continue;
                        }
                        Integer tag_id = (Integer)id_map.get(s);
                        if (tag_id == null) {
                            tag_id = ++id_max;
                            COConfigurationManager.setParameter(config_key, tag_id);
                        }
                        s.initialise(tag_id);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
            this.checkIPSets();
            if (!lts_enabled) {
                new_net_limits.clear();
            }
            this.net_limits = new_net_limits;
            if (this.net_limits.size() > 0) {
                if (!this.net_limit_listener_added) {
                    this.net_limit_listener_added = true;
                    StatsFactory.getLongTermStats().addListener(0x100000L, this);
                }
                this.updated(StatsFactory.getLongTermStats());
            } else if (this.net_limit_listener_added) {
                this.net_limit_listener_added = false;
                StatsFactory.getLongTermStats().removeListener(this);
            }
        } else {
            this.current_rules.clear();
            if (this.schedule_event != null) {
                this.schedule_event.cancel();
                this.schedule_event = null;
            }
            if (this.active_rule != null) {
                this.active_rule = null;
                this.resetRules();
            }
            for (IPSet s : this.current_ip_sets.values()) {
                s.destroy();
            }
            this.current_ip_sets.clear();
            this.checkIPSets();
            if (this.net_limit_pause_all_active) {
                this.setNetLimitPauseAllActive(false);
            }
            this.net_limits.clear();
            if (this.net_limit_listener_added) {
                this.net_limit_listener_added = false;
                StatsFactory.getLongTermStats().removeListener(this);
            }
        }
        return result;
    }

    private long parseRate(String str) {
        int pos = str.indexOf("/");
        if (pos != -1) {
            str = str.substring(0, pos).trim();
        }
        String num = "";
        long mult = 1L;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isDigit(c) && c != '.') {
                if (c == 'k') {
                    mult = 1024L;
                    break;
                }
                if (c == 'm') {
                    mult = 0x100000L;
                    break;
                }
                if (c != 'g') break;
                mult = 0x40000000L;
                break;
            }
            num = num + c;
        }
        if (num.contains(".")) {
            return (long)(Float.parseFloat(num) * (float)mult);
        }
        return (long)Integer.parseInt(num) * mult;
    }

    private int getMins(String str) {
        try {
            String[] bits = str.split(":");
            if (bits.length == 2) {
                return Integer.parseInt(bits[0].trim()) * 60 + Integer.parseInt(bits[1].trim());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    private void checkIPSets() {
        this.check_ip_sets_limiter.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkIPSetsSupport() {
        Download[] downloads;
        org.gudy.azureus2.plugins.download.DownloadManager download_manager = this.plugin_interface.getDownloadManager();
        if (this.current_dml != null) {
            this.current_dml.destroy();
            this.current_dml = null;
        }
        for (Download dm : downloads = download_manager.getDownloads()) {
            Peer[] peers;
            PeerManager pm = dm.getPeerManager();
            if (pm == null) continue;
            for (Peer peer : peers = pm.getPeers()) {
                List<RateLimiter> to_be_removed;
                Object object;
                RateLimiter[] lims;
                for (RateLimiter l : lims = peer.getRateLimiters(false)) {
                    if (!this.ip_set_rate_limiters_down.containsValue(l)) continue;
                    object = RL_TO_BE_REMOVED_LOCK;
                    synchronized (object) {
                        to_be_removed = (ArrayList<RateLimiter>)peer.getUserData(RLD_TO_BE_REMOVED_KEY);
                        if (to_be_removed == null) {
                            to_be_removed = new ArrayList<RateLimiter>();
                            peer.setUserData(RLD_TO_BE_REMOVED_KEY, to_be_removed);
                        }
                        to_be_removed.add(l);
                    }
                }
                for (RateLimiter l : lims = peer.getRateLimiters(true)) {
                    if (!this.ip_set_rate_limiters_up.containsValue(l)) continue;
                    object = RL_TO_BE_REMOVED_LOCK;
                    synchronized (object) {
                        to_be_removed = (List)peer.getUserData(RLU_TO_BE_REMOVED_KEY);
                        if (to_be_removed == null) {
                            to_be_removed = new ArrayList();
                            peer.setUserData(RLU_TO_BE_REMOVED_KEY, to_be_removed);
                        }
                        to_be_removed.add(l);
                    }
                }
            }
        }
        this.ip_set_rate_limiters_down.clear();
        this.ip_set_rate_limiters_up.clear();
        boolean has_cats_or_tags = false;
        for (IPSet set : this.current_ip_sets.values()) {
            this.ip_set_rate_limiters_down.put(set.getName(), set.getDownLimiter());
            this.ip_set_rate_limiters_up.put(set.getName(), set.getUpLimiter());
            if (set.getCategoriesOrTags() != null) {
                has_cats_or_tags = true;
            }
            set.removeAllPeers();
        }
        if (this.current_ip_sets.size() == 0) {
            if (this.ip_set_event != null) {
                this.ip_set_event.cancel();
                this.ip_set_event = null;
            }
        } else {
            if (this.ip_set_event == null) {
                this.ip_set_event = SimpleTimer.addPeriodicEvent("speed handler ip set scheduler", 1000L, new TimerEventPerformer(){
                    private int tick_count;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        ++this.tick_count;
                        SpeedLimitHandler speedLimitHandler = SpeedLimitHandler.this;
                        synchronized (speedLimitHandler) {
                            for (IPSet set : SpeedLimitHandler.this.current_ip_sets.values()) {
                                set.updateStats(this.tick_count);
                            }
                        }
                    }
                });
            }
            this.current_dml = new DML(download_manager, has_cats_or_tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void peersAdded(Download download, PeerManager peer_manager, Peer[] peers) {
        List<Tag> tags;
        Set[] set_nets;
        Set[] set_ccs;
        long[][][] set_ranges;
        IPSet[] sets;
        boolean has_ccs = false;
        boolean has_nets = false;
        HashSet<String> category_or_tags = null;
        TagManager tm = TagManagerFactory.getTagManager();
        SpeedLimitHandler speedLimitHandler = this;
        synchronized (speedLimitHandler) {
            int len = this.current_ip_sets.size();
            sets = new IPSet[len];
            set_ranges = new long[len][][];
            set_ccs = new Set[len];
            set_nets = new Set[len];
            int pos = 0;
            Iterator<IPSet> i$ = this.current_ip_sets.values().iterator();
            while (i$.hasNext()) {
                IPSet set;
                sets[pos] = set = i$.next();
                set_ranges[pos] = set.getRanges();
                set_ccs[pos] = set.getCountryCodes();
                set_nets[pos] = set.getNetworks();
                if (set_ccs[pos].size() > 0) {
                    has_ccs = true;
                }
                if (set_nets[pos].size() > 0) {
                    has_nets = true;
                }
                ++pos;
                if (category_or_tags != null || set.getCategoriesOrTags() == null) continue;
                category_or_tags = new HashSet<String>();
                String cat = download.getAttribute(this.category_attribute);
                if (cat != null && cat.length() > 0) {
                    category_or_tags.add(cat);
                }
                tags = tm.getTagsForTaggable(3, PluginCoreUtils.unwrap(download));
                for (Tag t : tags) {
                    category_or_tags.add(t.getTagName(true));
                }
            }
        }
        if (sets.length == 0) {
            return;
        }
        for (Peer peer : peers) {
            List rld_tbr;
            block35: {
                Object var35_37;
                List rlu_tbr;
                tags = RL_TO_BE_REMOVED_LOCK;
                synchronized (tags) {
                    rlu_tbr = (List)peer.getUserData(RLU_TO_BE_REMOVED_KEY);
                    rld_tbr = (List)peer.getUserData(RLD_TO_BE_REMOVED_KEY);
                    if (rlu_tbr != null) {
                        peer.setUserData(RLU_TO_BE_REMOVED_KEY, null);
                    }
                    if (rld_tbr != null) {
                        peer.setUserData(RLD_TO_BE_REMOVED_KEY, null);
                    }
                }
                try {
                    boolean not_inverse;
                    IPSet set;
                    boolean hit;
                    Set set_cats_or_tags;
                    int i;
                    String[] details;
                    long l_address;
                    long[] entry = (long[])peer.getUserData(ip_set_peer_key);
                    if (entry == null) {
                        byte[] bytes;
                        l_address = 0L;
                        String ip = peer.getIp();
                        if (!ip.contains(":") && (bytes = HostNameToIPResolver.hostAddressToBytes(ip)) != null) {
                            l_address = (long)(bytes[0] << 24 & 0xFF000000 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF) & 0xFFFFFFFFL;
                        }
                        entry = new long[]{l_address};
                        peer.setUserData(ip_set_peer_key, entry);
                    } else {
                        l_address = entry[0];
                    }
                    String peer_cc = null;
                    String peer_net = null;
                    if (has_ccs && (details = PeerUtils.getCountryDetails(peer)) != null && details.length > 0) {
                        peer_cc = details[0];
                    }
                    if (has_nets) {
                        peer_net = AENetworkClassifier.categoriseAddress(peer.getIp());
                    }
                    HashSet<IPSet> added_to_sets = new HashSet<IPSet>();
                    if (l_address != 0L) {
                        for (i = 0; i < set_ranges.length; ++i) {
                            long[][] ranges = set_ranges[i];
                            if (ranges.length == 0) continue;
                            IPSet set2 = sets[i];
                            boolean is_inverse = set2.isInverse();
                            set_cats_or_tags = set2.getCategoriesOrTags();
                            if (set_cats_or_tags != null && !new HashSet(set_cats_or_tags).removeAll(category_or_tags)) continue;
                            hit = false;
                            for (long[] range : ranges) {
                                if (l_address < range[0] || l_address > range[1]) continue;
                                hit = true;
                                if (is_inverse) break;
                                this.addLimiters(peer_manager, peer, set2, rlu_tbr, rld_tbr);
                                added_to_sets.add(set2);
                                break;
                            }
                            if (!is_inverse || hit) continue;
                            this.addLimiters(peer_manager, peer, set2, rlu_tbr, rld_tbr);
                            added_to_sets.add(set2);
                        }
                    }
                    if (peer_cc != null) {
                        for (i = 0; i < set_ccs.length; ++i) {
                            Set ccs;
                            set = sets[i];
                            if (added_to_sets.contains(set) || (ccs = set_ccs[i]).size() == 0) continue;
                            not_inverse = !set.isInverse();
                            set_cats_or_tags = set.getCategoriesOrTags();
                            if (set_cats_or_tags != null && !new HashSet(set_cats_or_tags).removeAll(category_or_tags) || (hit = ccs.contains(peer_cc)) != not_inverse) continue;
                            this.addLimiters(peer_manager, peer, set, rlu_tbr, rld_tbr);
                            added_to_sets.add(set);
                        }
                    }
                    if (peer_net != null) {
                        for (i = 0; i < set_nets.length; ++i) {
                            Set nets;
                            set = sets[i];
                            if (added_to_sets.contains(set) || (nets = set_nets[i]).size() == 0) continue;
                            not_inverse = !set.isInverse();
                            set_cats_or_tags = set.getCategoriesOrTags();
                            if (set_cats_or_tags != null && !new HashSet(set_cats_or_tags).removeAll(category_or_tags) || (hit = nets.contains(peer_net)) != not_inverse) continue;
                            this.addLimiters(peer_manager, peer, set, rlu_tbr, rld_tbr);
                            added_to_sets.add(set);
                        }
                    }
                    var35_37 = null;
                    if (rlu_tbr == null) break block35;
                }
                catch (Throwable throwable) {
                    var35_37 = null;
                    if (rlu_tbr != null) {
                        for (RateLimiter l : rlu_tbr) {
                            peer.removeRateLimiter(l, true);
                        }
                    }
                    if (rld_tbr != null) {
                        for (RateLimiter l : rld_tbr) {
                            peer.removeRateLimiter(l, false);
                        }
                    }
                    throw throwable;
                }
                for (RateLimiter l : rlu_tbr) {
                    peer.removeRateLimiter(l, true);
                }
            }
            if (rld_tbr == null) continue;
            for (RateLimiter l : rld_tbr) {
                peer.removeRateLimiter(l, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void peerRemoved(Download download, PeerManager peer_manager, Peer peer) {
        Collection<IPSet> sets;
        SpeedLimitHandler speedLimitHandler = this;
        synchronized (speedLimitHandler) {
            if (this.current_ip_sets.size() == 0) {
                return;
            }
            sets = this.current_ip_sets.values();
        }
        for (IPSet s : sets) {
            s.removePeer(peer_manager, peer);
        }
    }

    private void addLimiters(PeerManager peer_manager, Peer peer, IPSet set, List<RateLimiter> up_to_be_removed, List<RateLimiter> down_to_be_removed) {
        int peer_down;
        int peer_up;
        boolean matched = false;
        RateLimiter l = set.getUpLimiter();
        RateLimiter[] existing = peer.getRateLimiters(true);
        boolean found = false;
        for (RateLimiter e : existing) {
            if (e != l) continue;
            found = true;
            break;
        }
        if (found) {
            if (up_to_be_removed != null && up_to_be_removed.remove(l)) {
                matched = true;
            }
        } else {
            peer.addRateLimiter(l, true);
            matched = true;
        }
        l = set.getDownLimiter();
        existing = peer.getRateLimiters(false);
        found = false;
        for (RateLimiter e : existing) {
            if (e != l) continue;
            found = true;
            break;
        }
        if (found) {
            if (down_to_be_removed != null && down_to_be_removed.remove(l)) {
                matched = true;
            }
        } else {
            peer.addRateLimiter(l, false);
            matched = true;
        }
        if (matched) {
            set.addPeer(peer_manager, peer);
        }
        if ((peer_up = set.getPeerUpLimit()) > 0) {
            peer.getStats().setUploadRateLimit(peer_up);
        }
        if ((peer_down = set.getPeerDownLimit()) > 0) {
            peer.getStats().setDownloadRateLimit(peer_down);
        }
    }

    private ScheduleRule getActiveRule(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int day_of_week = cal.get(7);
        int hour_of_day = cal.get(11);
        int min_of_hour = cal.get(12);
        int day = -1;
        switch (day_of_week) {
            case 2: {
                day = 1;
                break;
            }
            case 3: {
                day = 2;
                break;
            }
            case 4: {
                day = 4;
                break;
            }
            case 5: {
                day = 8;
                break;
            }
            case 6: {
                day = 16;
                break;
            }
            case 7: {
                day = 32;
                break;
            }
            case 1: {
                day = 64;
            }
        }
        int min_of_day = hour_of_day * 60 + min_of_hour;
        ScheduleRule latest_match = null;
        for (ScheduleRule main_rule : this.current_rules) {
            List sub_rules = main_rule.splitByDay();
            for (ScheduleRule rule : sub_rules) {
                if ((rule.frequency & day) == 0 || rule.from_mins > min_of_day || rule.to_mins < min_of_day) continue;
                latest_match = main_rule;
            }
        }
        return latest_match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSchedule() {
        ScheduleRule current_rule;
        GlobalManager gm = this.core.getGlobalManager();
        SpeedLimitHandler speedLimitHandler = this;
        synchronized (speedLimitHandler) {
            current_rule = this.active_rule;
            ScheduleRule latest_match = this.getActiveRule(new Date());
            if (latest_match == null) {
                this.active_rule = null;
                this.resetRules();
            } else {
                String profile_name = latest_match.profile_name;
                boolean is_rule_pause_all = false;
                if (this.active_rule == null || !this.active_rule.sameAs(latest_match)) {
                    String lc_profile_name = profile_name.toLowerCase();
                    if (this.predefined_profile_names.contains(lc_profile_name)) {
                        if (lc_profile_name.equals("pause_all")) {
                            this.active_rule = latest_match;
                            is_rule_pause_all = true;
                            this.setRulePauseAllActive(true);
                        } else if (lc_profile_name.equals("resume_all")) {
                            this.active_rule = latest_match;
                            this.setRulePauseAllActive(false);
                        } else {
                            Debug.out("Unknown pre-def name '" + profile_name + "'");
                        }
                    } else if (this.profileExists(profile_name)) {
                        this.active_rule = latest_match;
                        this.loadProfile(profile_name);
                    } else {
                        this.active_rule = null;
                        this.resetRules();
                    }
                } else {
                    is_rule_pause_all = this.rule_pause_all_active;
                }
                if (this.rule_pause_all_active) {
                    if (!is_rule_pause_all) {
                        this.setRulePauseAllActive(false);
                    } else if (gm.canPauseDownloads()) {
                        gm.pauseDownloads();
                    }
                }
            }
        }
        if (this.active_rule != null) {
            this.active_rule.checkExtensions();
        }
        if (current_rule != this.active_rule && this.net_limits.size() > 0) {
            this.updated(StatsFactory.getLongTermStats());
        }
        if (this.net_limit_pause_all_active && gm.canPauseDownloads()) {
            gm.pauseDownloads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSchedule() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("# Enter rules on separate lines below this section - see http://wiki.vuze.com/w/Speed_Limit_Scheduler for more details");
        result.add("# Rules are of the following types:");
        result.add("#    enable=(yes|no)   - controls whether the entire schedule is enabled or not (default=yes)");
        result.add("#    <frequency> <profile_name> from <time> to <time> [extension]*");
        result.add("#        frequency: daily|weekdays|weekends|<day_of_week>");
        result.add("#            day_of_week: mon|tue|wed|thu|fri|sat|sun");
        result.add("#        time: hh:mm - 24 hour clock; 00:00=midnight; local time");
        result.add("#        extension: (start_tag|stop_tag|pause_tag|resume_tag):<tag_name>");
        result.add("#    peer_set <set_name>=[<CIDR_specs...>|CC list|Network List|<prior_set_name>] [,inverse=[yes|no]] [,up=<limit>] [,down=<limit>] [,cat=<cat names>] [,tag=<tag names>]");
        result.add("#    net_limit (daily|weekly|monthly)[:<profile>] [total=<limit>] [up=<limit>] [down=<limit>] [peer_up=<limit>] [peer_down=<limit>]");
        result.add("#");
        result.add("# For example - assuming there are profiles called 'no_limits' and 'limited_upload' defined:");
        result.add("#");
        result.add("#     daily no_limits from 00:00 to 23:59");
        result.add("#     daily limited_upload from 06:00 to 22:00 stop_tag:bigstuff");
        result.add("#     daily pause_all from 08:00 to 17:00");
        result.add("#");
        result.add("#     net_limit monthly total=250G          // flat montly limit");
        result.add("#");
        result.add("#     net_limit monthly:no_limits                  // no monthly limit when no_limits active");
        result.add("#     net_limit monthly:limited_upload total=100G  // 100G a month limit when limited_upload active");
        result.add("#");
        result.add("#     peer_set external=211.34.128.0/19 211.35.128.0/17");
        result.add("#     peer_set Europe=EU;AD;AL;AT;BA;BE;BG;BY;CH;CS;CZ;DE;DK;EE;ES;FI;FO;FR;FX;GB;GI;GR;HR;HU;IE;IS;IT;LI;LT;LU;LV;MC;MD;MK;MT;NL;NO;PL;PT;RO;SE;SI;SJ;SK;SM;UA;VA");
        result.add("#     peer_set Blorp=Europe;US");
        result.add("#");
        result.add("# When multiple rules apply the one further down the list of rules take precedence");
        result.add("# Currently peer_set limits are not schedulable");
        result.add("# Comment lines are prefixed with '#'");
        result.add("# Pre-defined profiles: " + this.predefined_profile_names);
        List<String> profiles = this.getProfileNames();
        if (profiles.size() == 0) {
            result.add("# No user profiles currently defined.");
        } else {
            ScheduleRule current_rule;
            String str = "";
            for (String string : profiles) {
                str = str + (str.length() == 0 ? "" : ", ") + string;
            }
            result.add("# Current profiles details:");
            result.add("#     defined: " + str);
            SpeedLimitHandler speedLimitHandler = this;
            synchronized (speedLimitHandler) {
                current_rule = this.active_rule;
            }
            result.add("#     active: " + (current_rule == null ? "none" : current_rule.profile_name));
        }
        result.add("# ---- Do not edit this line or any text above! ----");
        List lines_list = COConfigurationManager.getListParameter("speed.limit.handler.schedule.lines", new ArrayList());
        List schedule_lines = BDecoder.decodeStrings(BEncoder.cloneList(lines_list));
        if (schedule_lines.size() == 0) {
            schedule_lines.add("");
            schedule_lines.add("");
        } else {
            for (String l : schedule_lines) {
                result.add(l.trim());
            }
        }
        return result;
    }

    public List<String> setSchedule(List<String> lines) {
        int trim_from = 0;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.startsWith("# ---- Do not edit")) continue;
            trim_from = i + 1;
        }
        if (trim_from > 0) {
            lines = lines.subList(trim_from, lines.size());
        }
        COConfigurationManager.setParameter("speed.limit.handler.schedule.lines", lines);
        COConfigurationManager.save();
        return this.loadSchedule();
    }

    private List<LimitedRateGroup> trim(LimitedRateGroup[] groups) {
        ArrayList<LimitedRateGroup> result = new ArrayList<LimitedRateGroup>();
        for (LimitedRateGroup group : groups) {
            if (!(group instanceof UtilitiesImpl.PluginLimitedRateGroup)) continue;
            result.add(group);
        }
        return result;
    }

    @Override
    public void updated(LongTermStats stats2) {
        boolean exceeded = false;
        for (Map.Entry<Integer, List<NetLimit>> entry : this.net_limits.entrySet()) {
            int type = entry.getKey();
            for (NetLimit limit : entry.getValue()) {
                String profile = limit.getProfile();
                if (profile != null && (this.active_rule == null || !this.active_rule.profile_name.equals(profile))) continue;
                long[] usage = this.getLongTermUsage(stats2, type, limit);
                long total_up = usage[0] + usage[1] + usage[4];
                long total_do = usage[2] + usage[3] + usage[5];
                long[] limits = limit.getLimits();
                if (limits[0] > 0L) {
                    boolean bl = exceeded = total_up + total_do >= limits[0];
                }
                if (limits[1] > 0L && !exceeded) {
                    boolean bl = exceeded = total_up >= limits[1];
                }
                if (limits[2] > 0L && !exceeded) {
                    boolean bl = exceeded = total_do >= limits[2];
                }
                if (!exceeded) continue;
                break;
            }
            if (!exceeded) continue;
            break;
        }
        if (this.net_limit_pause_all_active != exceeded) {
            this.setNetLimitPauseAllActive(exceeded);
        }
    }

    private String formatUp(int rate) {
        return "Up=" + this.format(rate);
    }

    private String formatDown(int rate) {
        return "Down=" + this.format(rate);
    }

    private String format(int rate) {
        if (rate < 0) {
            return "Disabled";
        }
        if (rate == 0) {
            return "Unlimited";
        }
        return DisplayFormatters.formatByteCountToKiBEtcPerSec(rate);
    }

    private String formatUp(List<LimitedRateGroup> groups) {
        return "Up=" + this.format(groups);
    }

    private String formatDown(List<LimitedRateGroup> groups) {
        return "Down=" + this.format(groups);
    }

    private String format(List<LimitedRateGroup> groups) {
        String str = "";
        for (LimitedRateGroup group : groups) {
            str = str + (str.length() == 0 ? "" : ", ") + group.getName() + ":" + this.format(group.getRateLimitBytesPerSecond());
        }
        return str;
    }

    private void exportBoolean(Map<String, Object> map, String key, boolean b) {
        map.put(key, new Long(b ? 1L : 0L));
    }

    private boolean importBoolean(Map<String, Object> map, String key) {
        Long l = (Long)map.get(key);
        if (l != null) {
            return l == 1L;
        }
        return false;
    }

    private void exportInt(Map<String, Object> map, String key, int i) {
        map.put(key, new Long(i));
    }

    private int importInt(Map<String, Object> map, String key) {
        Long l = (Long)map.get(key);
        if (l != null) {
            return l.intValue();
        }
        return 0;
    }

    private void exportString(Map<String, Object> map, String key, String s) {
        try {
            map.put(key, s.getBytes("UTF-8"));
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    private String importString(Map<String, Object> map, String key) {
        Object obj = map.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return new String((byte[])obj, "UTF-8");
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(IndentWriter iw) {
        iw.println("Profiles");
        iw.indent();
        try {
            List<String> profiles = this.getProfileNames();
            for (String profile : profiles) {
                Object var9_8;
                iw.println(profile);
                iw.indent();
                try {
                    List<String> p_lines = this.getProfileSupport(profile, true);
                    for (String line : p_lines) {
                        iw.println(line);
                    }
                    var9_8 = null;
                    iw.exdent();
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    iw.exdent();
                    throw throwable;
                }
            }
            Object var11_10 = null;
            iw.exdent();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            iw.exdent();
            throw throwable;
        }
        iw.println("Schedule");
        iw.indent();
        try {
            List lines_list = COConfigurationManager.getListParameter("speed.limit.handler.schedule.lines", new ArrayList());
            List schedule_lines = BDecoder.decodeStrings(BEncoder.cloneList(lines_list));
            for (String line : schedule_lines) {
                iw.println(line);
            }
            Object var13_13 = null;
            iw.exdent();
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            iw.exdent();
            throw throwable;
        }
    }

    static {
        RL_TO_BE_REMOVED_LOCK = new Object();
        RLD_TO_BE_REMOVED_KEY = new Object();
        RLU_TO_BE_REMOVED_KEY = new Object();
        ip_set_peer_key = new Object();
    }

    private class DML
    implements DownloadManagerListener {
        private final Object lock;
        private final org.gudy.azureus2.plugins.download.DownloadManager download_manager;
        private final boolean has_cats_or_tags;
        private List<Runnable> listener_removers;
        private volatile boolean destroyed;

        private DML(org.gudy.azureus2.plugins.download.DownloadManager _download_manager, boolean _has_cats_or_tags) {
            this.lock = SpeedLimitHandler.this;
            this.listener_removers = new ArrayList<Runnable>();
            this.download_manager = _download_manager;
            this.has_cats_or_tags = _has_cats_or_tags;
            this.download_manager.addListener(this, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroy() {
            Object object = this.lock;
            synchronized (object) {
                this.destroyed = true;
                this.download_manager.removeListener(this);
                for (Runnable r : this.listener_removers) {
                    try {
                        r.run();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                this.listener_removers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void downloadAdded(final Download download) {
            Object object = this.lock;
            synchronized (object) {
                if (this.destroyed) {
                    return;
                }
                if (this.has_cats_or_tags) {
                    final DownloadAttributeListener attr_listener = new DownloadAttributeListener(){

                        public void attributeEventOccurred(Download download, TorrentAttribute attribute, int event_type) {
                            SpeedLimitHandler.this.checkIPSets();
                        }
                    };
                    final TagType tt = TagManagerFactory.getTagManager().getTagType(3);
                    final DownloadManager core_download = PluginCoreUtils.unwrap(download);
                    final TagListener tag_listener = new TagListener(){

                        public void taggableSync(Tag tag) {
                        }

                        public void taggableRemoved(Tag tag, Taggable tagged) {
                            SpeedLimitHandler.this.checkIPSets();
                        }

                        public void taggableAdded(Tag tag, Taggable tagged) {
                            SpeedLimitHandler.this.checkIPSets();
                        }
                    };
                    download.addAttributeListener(attr_listener, SpeedLimitHandler.this.category_attribute, 1);
                    tt.addTagListener(core_download, tag_listener);
                    this.listener_removers.add(new Runnable(){

                        public void run() {
                            download.removeAttributeListener(attr_listener, SpeedLimitHandler.this.category_attribute, 1);
                            tt.removeTagListener(core_download, tag_listener);
                        }
                    });
                }
                final DownloadPeerListener peer_listener = new DownloadPeerListener(){
                    private Runnable pm_listener_remover;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void peerManagerAdded(final Download download, final PeerManager peer_manager) {
                        Object object = DML.this.lock;
                        synchronized (object) {
                            if (DML.this.destroyed) {
                                return;
                            }
                            final PeerManagerListener2 listener = new PeerManagerListener2(){

                                public void eventOccurred(PeerManagerEvent event2) {
                                    if (DML.this.destroyed) {
                                        return;
                                    }
                                    if (event2.getType() == 1) {
                                        SpeedLimitHandler.this.peersAdded(download, peer_manager, new Peer[]{event2.getPeer()});
                                    } else if (event2.getType() == 2) {
                                        SpeedLimitHandler.this.peerRemoved(download, peer_manager, event2.getPeer());
                                    }
                                }
                            };
                            peer_manager.addListener(listener);
                            this.pm_listener_remover = new Runnable(){

                                public void run() {
                                    peer_manager.removeListener(listener);
                                }
                            };
                            DML.this.listener_removers.add(this.pm_listener_remover);
                        }
                        Peer[] peers = peer_manager.getPeers();
                        SpeedLimitHandler.this.peersAdded(download, peer_manager, peers);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                        Object object = DML.this.lock;
                        synchronized (object) {
                            if (this.pm_listener_remover != null && DML.this.listener_removers.contains(this.pm_listener_remover)) {
                                this.pm_listener_remover.run();
                                DML.this.listener_removers.remove(this.pm_listener_remover);
                            }
                        }
                    }
                };
                download.addPeerListener(peer_listener);
                this.listener_removers.add(new Runnable(){

                    public void run() {
                        download.removePeerListener(peer_listener);
                    }
                });
            }
        }

        public void downloadRemoved(Download download) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IPSet {
        private final String name;
        private long[][] ranges = new long[0][];
        private Set<String> country_codes = new HashSet<String>();
        private Set<String> networks = new HashSet<String>();
        private boolean inverse;
        private Set<String> categories_or_tags;
        private boolean has_explicit_up_lim;
        private boolean has_explicit_down_lim;
        private long last_send_total = -1L;
        private long last_recv_total = -1L;
        private Average send_rate = AverageFactory.MovingImmediateAverage(10);
        private Average receive_rate = AverageFactory.MovingImmediateAverage(10);
        private RateLimiter up_limiter;
        private RateLimiter down_limiter;
        private int peer_up_lim;
        private int peer_down_lim;
        private TagPeerImpl tag_impl;

        private IPSet(String _name) {
            this.name = _name;
            this.up_limiter = SpeedLimitHandler.this.plugin_interface.getConnectionManager().createRateLimiter("ps-" + this.name, 0);
            this.down_limiter = SpeedLimitHandler.this.plugin_interface.getConnectionManager().createRateLimiter("ps-" + this.name, 0);
        }

        private void initialise(int tag_id) {
            if (SpeedLimitHandler.this.ip_set_tag_type != null) {
                this.tag_impl = new TagPeerImpl(tag_id);
            }
            if (!this.has_explicit_up_lim) {
                this.up_limiter.setRateLimitBytesPerSecond(COConfigurationManager.getIntParameter("speed.limit.handler.ipset_n." + tag_id + ".up", 0));
            }
            if (!this.has_explicit_down_lim) {
                this.down_limiter.setRateLimitBytesPerSecond(COConfigurationManager.getIntParameter("speed.limit.handler.ipset_n." + tag_id + ".down", 0));
            }
        }

        private void setParameters(boolean _inverse, int _up_lim, int _down_lim, int _peer_up_lim, int _peer_down_lim, Set<String> _cats_or_tags) {
            this.inverse = _inverse;
            boolean bl = this.has_explicit_up_lim = _up_lim >= 0;
            if (!this.has_explicit_up_lim) {
                _up_lim = 0;
            }
            boolean bl2 = this.has_explicit_down_lim = _down_lim >= 0;
            if (!this.has_explicit_down_lim) {
                _down_lim = 0;
            }
            this.up_limiter.setRateLimitBytesPerSecond(_up_lim);
            this.down_limiter.setRateLimitBytesPerSecond(_down_lim);
            this.peer_up_lim = _peer_up_lim;
            this.peer_down_lim = _peer_down_lim;
            this.categories_or_tags = _cats_or_tags.size() == 0 ? null : _cats_or_tags;
        }

        private int getPeerUpLimit() {
            return this.peer_up_lim;
        }

        private int getPeerDownLimit() {
            return this.peer_down_lim;
        }

        private boolean addCIDRorCCetc(String cidr_or_cc_etc) {
            if (Character.isDigit(cidr_or_cc_etc.charAt(0))) {
                String cidr = cidr_or_cc_etc;
                int pos = cidr.indexOf(47);
                if (pos == -1) {
                    return false;
                }
                String address = cidr.substring(0, pos);
                if (address.contains(":")) {
                    return false;
                }
                try {
                    byte[] start_bytes = HostNameToIPResolver.syncResolve(address).getAddress();
                    int cidr_mask = Integer.parseInt(cidr.substring(pos + 1));
                    int rev_mask = 0;
                    for (int i = 0; i < 32 - cidr_mask; ++i) {
                        rev_mask = rev_mask << 1 | 1;
                    }
                    start_bytes[0] = (byte)(start_bytes[0] & ~(rev_mask >> 24));
                    start_bytes[1] = (byte)(start_bytes[1] & ~(rev_mask >> 16));
                    start_bytes[2] = (byte)(start_bytes[2] & ~(rev_mask >> 8));
                    start_bytes[3] = (byte)(start_bytes[3] & ~rev_mask);
                    byte[] end_bytes = (byte[])start_bytes.clone();
                    end_bytes[0] = (byte)(end_bytes[0] | rev_mask >> 24 & 0xFF);
                    end_bytes[1] = (byte)(end_bytes[1] | rev_mask >> 16 & 0xFF);
                    end_bytes[2] = (byte)(end_bytes[2] | rev_mask >> 8 & 0xFF);
                    end_bytes[3] = (byte)(end_bytes[3] | rev_mask & 0xFF);
                    long l_start = (long)(start_bytes[0] << 24 & 0xFF000000 | start_bytes[1] << 16 & 0xFF0000 | start_bytes[2] << 8 & 0xFF00 | start_bytes[3] & 0xFF) & 0xFFFFFFFFL;
                    long l_end = (long)(end_bytes[0] << 24 & 0xFF000000 | end_bytes[1] << 16 & 0xFF0000 | end_bytes[2] << 8 & 0xFF00 | end_bytes[3] & 0xFF) & 0xFFFFFFFFL;
                    int len = this.ranges.length;
                    long[][] new_ranges = new long[len + 1][];
                    for (int i = 0; i < len; ++i) {
                        new_ranges[i] = this.ranges[i];
                    }
                    new_ranges[len] = new long[]{l_start, l_end};
                    this.ranges = new_ranges;
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }
            for (String net : AENetworkClassifier.AT_NETWORKS) {
                if (!cidr_or_cc_etc.equalsIgnoreCase(net)) continue;
                this.networks.add(net);
                return true;
            }
            if (cidr_or_cc_etc.equalsIgnoreCase("all")) {
                this.networks.addAll(Arrays.asList(AENetworkClassifier.AT_NETWORKS));
                return true;
            }
            String cc = cidr_or_cc_etc;
            if (cc.length() != 2) {
                return false;
            }
            this.country_codes.add(cc.toUpperCase(Locale.US));
            return true;
        }

        private void addSet(IPSet other) {
            long[][] new_ranges = new long[this.ranges.length + other.ranges.length][];
            System.arraycopy(this.ranges, 0, new_ranges, 0, this.ranges.length);
            System.arraycopy(other.ranges, 0, new_ranges, this.ranges.length, other.ranges.length);
            this.ranges = new_ranges;
            this.country_codes.addAll(other.country_codes);
            this.networks.addAll(other.networks);
        }

        private String getName() {
            return this.name;
        }

        private long[][] getRanges() {
            return this.ranges;
        }

        private Set<String> getCountryCodes() {
            return this.country_codes;
        }

        private Set<String> getNetworks() {
            return this.networks;
        }

        private RateLimiter getUpLimiter() {
            return this.up_limiter;
        }

        private RateLimiter getDownLimiter() {
            return this.down_limiter;
        }

        private Set<String> getCategoriesOrTags() {
            return this.categories_or_tags;
        }

        private void updateStats(int tick_count) {
            long send_total = this.up_limiter.getRateLimitTotalByteCount();
            long recv_total = this.down_limiter.getRateLimitTotalByteCount();
            if (this.last_send_total != -1L) {
                long send_diff = send_total - this.last_send_total;
                long recv_diff = recv_total - this.last_recv_total;
                this.send_rate.update(send_diff);
                this.receive_rate.update(recv_diff);
            }
            this.last_send_total = send_total;
            this.last_recv_total = recv_total;
            TagPeerImpl tag = this.tag_impl;
            if (tag != null) {
                tag.update(tick_count);
            }
        }

        private boolean isInverse() {
            return this.inverse;
        }

        private void addPeer(PeerManager peer_manager, Peer peer) {
            TagPeerImpl tag = this.tag_impl;
            if (tag != null) {
                tag.add(peer_manager, peer);
            }
        }

        private void removePeer(PeerManager peer_manager, Peer peer) {
            TagPeerImpl tag = this.tag_impl;
            if (tag != null) {
                tag.remove(peer_manager, peer);
            }
        }

        private void removeAllPeers() {
            TagPeerImpl tag = this.tag_impl;
            if (tag != null) {
                tag.removeAll();
            }
        }

        private void destroy() {
            if (this.tag_impl != null) {
                this.tag_impl.removeTag();
                this.tag_impl = null;
            }
        }

        private String getAddressString() {
            long address_count = 0L;
            for (long[] range : this.ranges) {
                address_count += range[1] - range[0] + 1L;
            }
            if (address_count == 0L) {
                return "[]";
            }
            return String.valueOf(address_count);
        }

        private String getDetailString() {
            return this.name + ": Up=" + SpeedLimitHandler.this.format(this.up_limiter.getRateLimitBytesPerSecond()) + " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec((long)this.send_rate.getAverage()) + ")" + ", Down=" + SpeedLimitHandler.this.format(this.down_limiter.getRateLimitBytesPerSecond()) + " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec((long)this.receive_rate.getAverage()) + ")" + ", Addresses=" + this.getAddressString() + ", CC=" + this.country_codes + ", Networks=" + this.networks + ", Inverse=" + this.inverse + ", Categories/Tags=" + (this.categories_or_tags == null ? "[]" : String.valueOf(this.categories_or_tags)) + ", Peer_Up=" + SpeedLimitHandler.this.format(this.peer_up_lim) + ", Peer_Down=" + SpeedLimitHandler.this.format(this.peer_down_lim);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class TagPeerImpl
        extends TagBase
        implements TagPeer,
        TagFeatureExecOnAssign {
            private Object UPLOAD_PRIORITY_ADDED_KEY;
            private int upload_priority;
            private Set<PEPeer> added_peers;
            private Set<PEPeer> pending_peers;

            private TagPeerImpl(int tag_id) {
                super(SpeedLimitHandler.this.ip_set_tag_type, tag_id, IPSet.this.name);
                this.UPLOAD_PRIORITY_ADDED_KEY = new Object();
                this.added_peers = new HashSet<PEPeer>();
                this.pending_peers = new HashSet<PEPeer>();
                this.addTag();
                this.upload_priority = COConfigurationManager.getIntParameter("speed.limit.handler.ipset_n." + this.getTagID() + ".uppri", 0);
            }

            @Override
            public int getTaggableTypes() {
                return 4;
            }

            @Override
            public int getSupportedActions() {
                return 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void update(int tick_count) {
                ArrayList<PEPeer> to_remove = null;
                ArrayList<PEPeer> to_add = null;
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    PEPeer peer;
                    Iterator<PEPeer> it;
                    if (tick_count % 5 == 0) {
                        it = this.added_peers.iterator();
                        while (it.hasNext()) {
                            peer = it.next();
                            if (peer.getPeerState() != 50) continue;
                            it.remove();
                            if (to_remove == null) {
                                to_remove = new ArrayList<PEPeer>();
                            }
                            to_remove.add(peer);
                        }
                    }
                    it = this.pending_peers.iterator();
                    while (it.hasNext()) {
                        peer = it.next();
                        int state = peer.getPeerState();
                        if (state == 30) {
                            it.remove();
                            this.added_peers.add(peer);
                            if (to_add == null) {
                                to_add = new ArrayList<PEPeer>();
                            }
                            to_add.add(peer);
                            continue;
                        }
                        if (state != 50) continue;
                        it.remove();
                    }
                }
                if (to_add != null) {
                    for (PEPeer peer : to_add) {
                        this.addTaggable(peer);
                    }
                }
                if (to_remove != null) {
                    for (PEPeer peer : to_remove) {
                        this.removeTaggable(peer);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void add(PeerManager peer_manager, Peer _peer) {
                PEPeer peer = PluginCoreUtils.unwrap(_peer);
                if (this.isActionEnabled(1)) {
                    peer_manager.removePeer(_peer);
                    return;
                }
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    if (peer.getPeerState() == 30) {
                        if (this.added_peers.contains(peer)) {
                            return;
                        }
                    } else {
                        this.pending_peers.add(peer);
                        return;
                    }
                    this.pending_peers.remove(peer);
                    this.added_peers.add(peer);
                }
                this.addTaggable(peer);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void remove(PeerManager peer_manager, Peer _peer) {
                PEPeer peer = PluginCoreUtils.unwrap(_peer);
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    if (this.pending_peers.remove(peer)) {
                        return;
                    }
                    if (!this.added_peers.remove(peer)) {
                        return;
                    }
                }
                this.removeTaggable(peer);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void removeAll() {
                ArrayList<PEPeer> to_remove;
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    this.pending_peers.clear();
                    to_remove = new ArrayList<PEPeer>(this.added_peers);
                    this.added_peers.clear();
                }
                for (PEPeer peer : to_remove) {
                    this.removeTaggable(peer);
                }
            }

            @Override
            public void addTaggable(Taggable t) {
                if (this.upload_priority > 0) {
                    ((PEPeer)t).updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, true);
                }
                super.addTaggable(t);
            }

            @Override
            public void removeTaggable(Taggable t) {
                if (this.upload_priority > 0) {
                    ((PEPeer)t).updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, false);
                }
                super.removeTaggable(t);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getTaggedCount() {
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    return this.added_peers.size();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PEPeer> getTaggedPeers() {
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    return new ArrayList<PEPeer>(this.added_peers);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Set<Taggable> getTagged() {
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    return new HashSet<Taggable>(this.added_peers);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasTaggable(Taggable t) {
                TagPeerImpl tagPeerImpl = this;
                synchronized (tagPeerImpl) {
                    return this.added_peers.contains(t);
                }
            }

            @Override
            public boolean supportsTagRates() {
                return true;
            }

            @Override
            public boolean supportsTagUploadLimit() {
                return !IPSet.this.has_explicit_up_lim;
            }

            @Override
            public boolean supportsTagDownloadLimit() {
                return !IPSet.this.has_explicit_down_lim;
            }

            @Override
            public int getTagUploadLimit() {
                return IPSet.this.up_limiter.getRateLimitBytesPerSecond();
            }

            @Override
            public void setTagUploadLimit(int bps) {
                if (this.supportsTagUploadLimit()) {
                    IPSet.this.up_limiter.setRateLimitBytesPerSecond(bps);
                    COConfigurationManager.setParameter("speed.limit.handler.ipset_n." + this.getTagID() + ".up", bps);
                    List<PEPeer> peers = this.getTaggedPeers();
                    for (PEPeer peer : peers) {
                        for (LimitedRateGroup l : peer.getRateLimiters(true)) {
                            l.getRateLimitBytesPerSecond();
                        }
                    }
                }
            }

            @Override
            public int getTagCurrentUploadRate() {
                return (int)IPSet.this.send_rate.getAverage();
            }

            @Override
            public int getTagDownloadLimit() {
                return IPSet.this.down_limiter.getRateLimitBytesPerSecond();
            }

            @Override
            public void setTagDownloadLimit(int bps) {
                if (this.supportsTagDownloadLimit()) {
                    IPSet.this.down_limiter.setRateLimitBytesPerSecond(bps);
                    COConfigurationManager.setParameter("speed.limit.handler.ipset_n." + this.getTagID() + ".down", bps);
                    List<PEPeer> peers = this.getTaggedPeers();
                    for (PEPeer peer : peers) {
                        for (LimitedRateGroup l : peer.getRateLimiters(false)) {
                            l.getRateLimitBytesPerSecond();
                        }
                    }
                }
            }

            @Override
            public int getTagCurrentDownloadRate() {
                return (int)IPSet.this.receive_rate.getAverage();
            }

            @Override
            public boolean getCanBePublicDefault() {
                return false;
            }

            @Override
            public int getTagUploadPriority() {
                return this.upload_priority;
            }

            @Override
            public void setTagUploadPriority(int priority) {
                if (priority < 0) {
                    priority = 0;
                }
                if (priority == this.upload_priority) {
                    return;
                }
                int old_up = this.upload_priority;
                this.upload_priority = priority;
                COConfigurationManager.setParameter("speed.limit.handler.ipset_n." + this.getTagID() + ".uppri", priority);
                if (old_up == 0 || priority == 0) {
                    List<PEPeer> peers = this.getTaggedPeers();
                    for (PEPeer peer : peers) {
                        peer.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, priority > 0);
                    }
                }
            }

            @Override
            public void removeTag() {
                if (this.upload_priority > 0) {
                    List<PEPeer> peers = this.getTaggedPeers();
                    for (PEPeer peer : peers) {
                        peer.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, false);
                    }
                }
                super.removeTag();
            }

            @Override
            public String getDescription() {
                return IPSet.this.getDetailString();
            }
        }
    }

    private class IPSetTagType
    extends TagTypeWithState {
        private final int[] color_default;

        private IPSetTagType() {
            super(4, 65, "tag.type.ipset");
            this.color_default = new int[]{132, 16, 57};
            this.addTagType();
        }

        public int[] getColorDefault() {
            return this.color_default;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LimitDetails {
        private boolean auto_up_enabled;
        private boolean auto_up_seeding_enabled;
        private boolean seeding_limits_enabled;
        private int up_limit;
        private int up_seeding_limit;
        private int down_limit;
        private boolean lan_rates_enabled;
        private int lan_up_limit;
        private int lan_down_limit;
        private Map<String, int[]> download_limits = new HashMap<String, int[]>();
        private Map<String, int[]> category_limits = new HashMap<String, int[]>();
        private Map<String, int[]> tag_limits = new HashMap<String, int[]>();

        private LimitDetails() {
        }

        private LimitDetails(Map<String, Object> map) {
            List t_list;
            List c_list;
            this.auto_up_enabled = SpeedLimitHandler.this.importBoolean(map, "aue");
            this.auto_up_seeding_enabled = SpeedLimitHandler.this.importBoolean(map, "ause");
            this.seeding_limits_enabled = SpeedLimitHandler.this.importBoolean(map, "sle");
            this.up_limit = SpeedLimitHandler.this.importInt(map, "ul");
            this.up_seeding_limit = SpeedLimitHandler.this.importInt(map, "usl");
            this.down_limit = SpeedLimitHandler.this.importInt(map, "dl");
            this.lan_rates_enabled = map.containsKey("lre") ? SpeedLimitHandler.this.importBoolean(map, "lre") : COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
            this.lan_up_limit = SpeedLimitHandler.this.importInt(map, "lul");
            this.lan_down_limit = SpeedLimitHandler.this.importInt(map, "ldl");
            List d_list = (List)map.get("dms");
            if (d_list != null) {
                for (Map m : d_list) {
                    String k = SpeedLimitHandler.this.importString(m, "k");
                    if (k == null) continue;
                    int ul = SpeedLimitHandler.this.importInt(m, "u");
                    int dl = SpeedLimitHandler.this.importInt(m, "d");
                    this.download_limits.put(k, new int[]{ul, dl});
                }
            }
            if ((c_list = (List)map.get("cts")) != null) {
                for (Map m : c_list) {
                    String k = SpeedLimitHandler.this.importString(m, "k");
                    if (k == null) continue;
                    int ul = SpeedLimitHandler.this.importInt(m, "u");
                    int dl = SpeedLimitHandler.this.importInt(m, "d");
                    this.category_limits.put(k, new int[]{ul, dl});
                }
            }
            if ((t_list = (List)map.get("tgs")) != null) {
                for (Map m : t_list) {
                    String t = SpeedLimitHandler.this.importString(m, "k");
                    if (t == null) continue;
                    int ul = SpeedLimitHandler.this.importInt(m, "u");
                    int dl = SpeedLimitHandler.this.importInt(m, "d");
                    this.tag_limits.put(t, new int[]{ul, dl});
                }
            }
        }

        private Map<String, Object> export() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            SpeedLimitHandler.this.exportBoolean(map, "aue", this.auto_up_enabled);
            SpeedLimitHandler.this.exportBoolean(map, "ause", this.auto_up_seeding_enabled);
            SpeedLimitHandler.this.exportBoolean(map, "sle", this.seeding_limits_enabled);
            SpeedLimitHandler.this.exportInt(map, "ul", this.up_limit);
            SpeedLimitHandler.this.exportInt(map, "usl", this.up_seeding_limit);
            SpeedLimitHandler.this.exportInt(map, "dl", this.down_limit);
            SpeedLimitHandler.this.exportBoolean(map, "lre", this.lan_rates_enabled);
            SpeedLimitHandler.this.exportInt(map, "lul", this.lan_up_limit);
            SpeedLimitHandler.this.exportInt(map, "ldl", this.lan_down_limit);
            ArrayList d_list = new ArrayList();
            map.put("dms", d_list);
            for (Map.Entry<String, int[]> entry : this.download_limits.entrySet()) {
                HashMap m = new HashMap();
                d_list.add(m);
                SpeedLimitHandler.this.exportString(m, "k", entry.getKey());
                SpeedLimitHandler.this.exportInt(m, "u", entry.getValue()[0]);
                SpeedLimitHandler.this.exportInt(m, "d", entry.getValue()[1]);
            }
            ArrayList c_list = new ArrayList();
            map.put("cts", c_list);
            for (Map.Entry<String, int[]> entry : this.category_limits.entrySet()) {
                HashMap m = new HashMap();
                c_list.add(m);
                SpeedLimitHandler.this.exportString(m, "k", entry.getKey());
                SpeedLimitHandler.this.exportInt(m, "u", entry.getValue()[0]);
                SpeedLimitHandler.this.exportInt(m, "d", entry.getValue()[1]);
            }
            ArrayList t_list = new ArrayList();
            map.put("tgs", t_list);
            for (Map.Entry<String, int[]> entry : this.tag_limits.entrySet()) {
                HashMap m = new HashMap();
                t_list.add(m);
                SpeedLimitHandler.this.exportString(m, "k", entry.getKey());
                SpeedLimitHandler.this.exportInt(m, "u", entry.getValue()[0]);
                SpeedLimitHandler.this.exportInt(m, "d", entry.getValue()[1]);
            }
            return map;
        }

        private void loadForReset() {
            this.auto_up_enabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
        }

        private void loadCurrent() {
            this.auto_up_enabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
            this.auto_up_seeding_enabled = COConfigurationManager.getBooleanParameter("Auto Upload Speed Seeding Enabled");
            this.seeding_limits_enabled = COConfigurationManager.getBooleanParameter("enable.seedingonly.upload.rate");
            this.up_limit = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
            this.up_seeding_limit = COConfigurationManager.getIntParameter("Max Upload Speed Seeding KBs");
            this.down_limit = COConfigurationManager.getIntParameter("Max Download Speed KBs");
            this.lan_rates_enabled = COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
            this.lan_up_limit = COConfigurationManager.getIntParameter("Max LAN Upload Speed KBs");
            this.lan_down_limit = COConfigurationManager.getIntParameter("Max LAN Download Speed KBs");
            this.download_limits.clear();
            GlobalManager gm = SpeedLimitHandler.this.core.getGlobalManager();
            List<DownloadManager> downloads = gm.getDownloadManagers();
            for (DownloadManager download : downloads) {
                TOTorrent torrent = download.getTorrent();
                byte[] hash = null;
                if (torrent != null) {
                    try {
                        hash = torrent.getHash();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                if (hash == null) continue;
                int download_up_limit = download.getStats().getUploadRateLimitBytesPerSecond();
                int download_down_limit = download.getStats().getDownloadRateLimitBytesPerSecond();
                if (download_up_limit <= 0 && download_down_limit <= 0) continue;
                this.download_limits.put(Base32.encode(hash), new int[]{download_up_limit, download_down_limit});
            }
            Category[] categories = CategoryManager.getCategories();
            this.category_limits.clear();
            for (Category category : categories) {
                int cat_up_limit = category.getUploadSpeed();
                int cat_down_limit = category.getDownloadSpeed();
                if (cat_up_limit <= 0 && cat_down_limit <= 0) continue;
                this.category_limits.put(category.getName(), new int[]{cat_up_limit, cat_down_limit});
            }
            List<TagType> tag_types = TagManagerFactory.getTagManager().getTagTypes();
            this.tag_limits.clear();
            for (TagType tag_type : tag_types) {
                if (tag_type.getTagType() == 1 || !tag_type.hasTagTypeFeature(1L)) continue;
                List<Tag> tags = tag_type.getTags();
                for (Tag tag : tags) {
                    TagFeatureRateLimit rl = (TagFeatureRateLimit)((Object)tag);
                    int tag_up_limit = rl.getTagUploadLimit();
                    int tag_down_limit = rl.getTagDownloadLimit();
                    if (tag_up_limit == 0 && tag_down_limit == 0) continue;
                    this.tag_limits.put(tag_type.getTagType() + "." + tag.getTagID(), new int[]{tag_up_limit, tag_down_limit});
                }
            }
        }

        private int[] getLimitsForDownload(String hash) {
            return this.download_limits.get(hash);
        }

        private void addRemoveDownloads(List<String> hashes, boolean add) {
            GlobalManager gm = SpeedLimitHandler.this.core.getGlobalManager();
            for (String hash : hashes) {
                if (add) {
                    DownloadManager download = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                    if (download == null) continue;
                    int download_up_limit = download.getStats().getUploadRateLimitBytesPerSecond();
                    int download_down_limit = download.getStats().getDownloadRateLimitBytesPerSecond();
                    if (download_up_limit <= 0 && download_down_limit <= 0) continue;
                    this.download_limits.put(hash, new int[]{download_up_limit, download_down_limit});
                    continue;
                }
                this.download_limits.remove(hash);
            }
        }

        private void apply() {
            COConfigurationManager.setParameter("Auto Upload Speed Enabled", this.auto_up_enabled);
            COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", this.auto_up_seeding_enabled);
            if (!this.auto_up_enabled && !this.auto_up_seeding_enabled) {
                COConfigurationManager.setParameter("Max Upload Speed KBs", this.up_limit);
            }
            COConfigurationManager.setParameter("enable.seedingonly.upload.rate", this.seeding_limits_enabled);
            COConfigurationManager.setParameter("Max Upload Speed Seeding KBs", this.up_seeding_limit);
            COConfigurationManager.setParameter("Max Download Speed KBs", this.down_limit);
            COConfigurationManager.setParameter("LAN Speed Enabled", this.lan_rates_enabled);
            COConfigurationManager.setParameter("Max LAN Upload Speed KBs", this.lan_up_limit);
            COConfigurationManager.setParameter("Max LAN Download Speed KBs", this.lan_down_limit);
            GlobalManager gm = SpeedLimitHandler.this.core.getGlobalManager();
            HashSet<DownloadManager> all_managers = new HashSet<DownloadManager>(gm.getDownloadManagers());
            for (Map.Entry<String, int[]> entry : this.download_limits.entrySet()) {
                byte[] hash = Base32.decode(entry.getKey());
                DownloadManager downloadManager = gm.getDownloadManager(new HashWrapper(hash));
                if (downloadManager == null) continue;
                int[] limits = entry.getValue();
                downloadManager.getStats().setUploadRateLimitBytesPerSecond(limits[0]);
                downloadManager.getStats().setDownloadRateLimitBytesPerSecond(limits[1]);
                all_managers.remove(downloadManager);
            }
            for (DownloadManager dm : all_managers) {
                dm.getStats().setUploadRateLimitBytesPerSecond(0);
                dm.getStats().setDownloadRateLimitBytesPerSecond(0);
            }
            HashSet<Category> all_categories = new HashSet<Category>(Arrays.asList(CategoryManager.getCategories()));
            HashMap<String, Category> cat_map = new HashMap<String, Category>();
            for (Category category : all_categories) {
                cat_map.put(category.getName(), category);
            }
            for (Map.Entry entry : this.category_limits.entrySet()) {
                String cat_name = (String)entry.getKey();
                Category category = (Category)cat_map.get(cat_name);
                if (category == null) continue;
                int[] nArray = (int[])entry.getValue();
                category.setUploadSpeed(nArray[0]);
                category.setDownloadSpeed(nArray[1]);
                all_categories.remove(category);
            }
            for (Category category : all_categories) {
                category.setUploadSpeed(0);
                category.setDownloadSpeed(0);
            }
            TagManager tm = TagManagerFactory.getTagManager();
            List<TagType> list = tm.getTagTypes();
            HashSet<Tag> all_rl_tags = new HashSet<Tag>();
            for (TagType tagType : list) {
                if (tagType.getTagType() == 1 || !tagType.hasTagTypeFeature(1L)) continue;
                all_rl_tags.addAll(tagType.getTags());
            }
            for (Map.Entry entry : this.tag_limits.entrySet()) {
                String tag_key = (String)entry.getKey();
                String[] bits = tag_key.split("\\.");
                try {
                    Tag tag;
                    int tag_type = Integer.parseInt(bits[0]);
                    int tag_id = Integer.parseInt(bits[1]);
                    TagType tt = tm.getTagType(tag_type);
                    if (tt == null || !tt.hasTagTypeFeature(1L) || (tag = tt.getTag(tag_id)) == null) continue;
                    TagFeatureRateLimit rl = (TagFeatureRateLimit)((Object)tag);
                    int[] limits = (int[])entry.getValue();
                    rl.setTagUploadLimit(limits[0]);
                    rl.setTagDownloadLimit(limits[1]);
                    all_rl_tags.remove(tag);
                }
                catch (Throwable e) {}
            }
            for (Tag tag : all_rl_tags) {
                try {
                    TagFeatureRateLimit rl = (TagFeatureRateLimit)((Object)tag);
                    rl.setTagUploadLimit(0);
                    rl.setTagDownloadLimit(0);
                }
                catch (Throwable e) {}
            }
        }

        private List<String> getString(boolean is_current, boolean use_hashes) {
            ArrayList<String> result = new ArrayList<String>();
            result.add("Global Limits");
            if (this.auto_up_enabled) {
                result.add("    Auto upload limit enabled");
            } else if (this.auto_up_seeding_enabled) {
                result.add("    Auto upload seeding limit enabled");
            } else {
                result.add("    " + SpeedLimitHandler.this.formatUp(this.up_limit * 1024));
                if (this.seeding_limits_enabled) {
                    result.add("    Seeding only limit enabled");
                    result.add("    Seeding only: " + SpeedLimitHandler.this.format(this.up_seeding_limit * 1024));
                }
            }
            result.add("    " + SpeedLimitHandler.this.formatDown(this.down_limit * 1024));
            if (this.lan_rates_enabled) {
                result.add("");
                result.add("    LAN limits enabled");
                result.add("        " + SpeedLimitHandler.this.formatUp(this.lan_up_limit * 1024));
                result.add("        " + SpeedLimitHandler.this.formatDown(this.lan_down_limit * 1024));
            }
            result.add("");
            result.add("Download Limits");
            int total_download_limits = 0;
            int total_download_limits_up = 0;
            int total_download_limits_up_disabled = 0;
            int total_download_limits_down = 0;
            int total_download_limits_down_disabled = 0;
            GlobalManager gm = SpeedLimitHandler.this.core.getGlobalManager();
            for (Map.Entry<String, int[]> entry : this.download_limits.entrySet()) {
                String hash_str = entry.getKey();
                byte[] hash = Base32.decode(hash_str);
                DownloadManager dm = gm.getDownloadManager(new HashWrapper(hash));
                if (dm == null) continue;
                int[] limits = entry.getValue();
                ++total_download_limits;
                int up = limits[0];
                int down = limits[1];
                if (up < 0) {
                    ++total_download_limits_up_disabled;
                } else {
                    total_download_limits_up += up;
                }
                if (down < 0) {
                    ++total_download_limits_down_disabled;
                } else {
                    total_download_limits_down += down;
                }
                result.add("    " + (use_hashes ? hash_str.substring(0, 16) : dm.getDisplayName()) + ": " + SpeedLimitHandler.this.formatUp(up) + ", " + SpeedLimitHandler.this.formatDown(down));
            }
            if (total_download_limits == 0) {
                result.add("    None");
            } else {
                result.add("    ----");
                result.add("    Total=" + total_download_limits + " - Compounded limits: " + SpeedLimitHandler.this.formatUp(total_download_limits_up) + (total_download_limits_up_disabled == 0 ? "" : " [" + total_download_limits_up_disabled + " disabled]") + ", " + SpeedLimitHandler.this.formatDown(total_download_limits_down) + (total_download_limits_down_disabled == 0 ? "" : " [" + total_download_limits_down_disabled + " disabled]"));
            }
            Category[] categories = CategoryManager.getCategories();
            HashMap<String, Category> cat_map = new HashMap<String, Category>();
            for (Category c : categories) {
                cat_map.put(c.getName(), c);
            }
            result.add("");
            result.add("Category Limits");
            int total_cat_limits = 0;
            int total_cat_limits_up = 0;
            int total_cat_limits_down = 0;
            for (Map.Entry<String, int[]> entry : this.category_limits.entrySet()) {
                String cat_name = entry.getKey();
                Category category = (Category)cat_map.get(cat_name);
                if (category == null) continue;
                if (category.getType() == 2) {
                    cat_name = "Uncategorised";
                }
                int[] limits = entry.getValue();
                ++total_cat_limits;
                int up = limits[0];
                int down = limits[1];
                total_cat_limits_up += up;
                total_cat_limits_down += down;
                result.add("    " + cat_name + ": " + SpeedLimitHandler.this.formatUp(up) + ", " + SpeedLimitHandler.this.formatDown(down));
            }
            if (total_cat_limits == 0) {
                result.add("    None");
            } else {
                result.add("    ----");
                result.add("    Total=" + total_cat_limits + " - Compounded limits: " + SpeedLimitHandler.this.formatUp(total_cat_limits_up) + ", " + SpeedLimitHandler.this.formatDown(total_cat_limits_down));
            }
            result.add("");
            result.add("Tag Limits");
            int total_tag_limits = 0;
            int total_tag_limits_up = 0;
            int total_tag_limits_down = 0;
            boolean some_up_disabled = false;
            boolean some_down_disabled = false;
            TagManager tm = TagManagerFactory.getTagManager();
            for (Map.Entry<String, int[]> entry : this.tag_limits.entrySet()) {
                String tag_key = entry.getKey();
                String[] bits = tag_key.split("\\.");
                try {
                    Tag tag;
                    int tag_type = Integer.parseInt(bits[0]);
                    int tag_id = Integer.parseInt(bits[1]);
                    TagType tt = tm.getTagType(tag_type);
                    if (tt == null || !tt.hasTagTypeFeature(1L) || (tag = tt.getTag(tag_id)) == null) continue;
                    String tag_name = tt.getTagTypeName(true) + " - " + tag.getTagName(true);
                    int[] limits = entry.getValue();
                    ++total_tag_limits;
                    int up = limits[0];
                    int down = limits[1];
                    if (up > 0) {
                        total_tag_limits_up += up;
                    } else if (up < 0) {
                        some_up_disabled = true;
                    }
                    if (down > 0) {
                        total_tag_limits_down += down;
                    } else if (down < 0) {
                        some_down_disabled = true;
                    }
                    result.add("    " + tag_name + ": " + SpeedLimitHandler.this.formatUp(up) + ", " + SpeedLimitHandler.this.formatDown(down));
                }
                catch (Throwable e) {}
            }
            String dis_str = "";
            if (some_up_disabled) {
                dis_str = "up";
            }
            if (some_down_disabled) {
                dis_str = dis_str + (dis_str.length() == 0 ? "" : "&") + "down";
            }
            if (dis_str.length() > 0) {
                dis_str = " (some " + dis_str + " disabled)";
            }
            if (total_tag_limits == 0) {
                result.add("    None" + dis_str);
            } else {
                result.add("    ----");
                result.add("    Total=" + total_tag_limits + " - Compounded limits: " + SpeedLimitHandler.this.formatUp(total_tag_limits_up) + ", " + SpeedLimitHandler.this.formatDown(total_tag_limits_down) + dis_str);
            }
            if (is_current) {
                HashMap plugin_limiters = new HashMap();
                List<DownloadManager> dms = gm.getDownloadManagers();
                for (DownloadManager dm : dms) {
                    Boolean[] arr$ = new Boolean[]{true, false};
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        boolean upload = arr$[i$];
                        List limiters = SpeedLimitHandler.this.trim(dm.getRateLimiters(upload));
                        for (LimitedRateGroup g : limiters) {
                            ArrayList<DownloadManager> entries = (ArrayList<DownloadManager>)plugin_limiters.get(g);
                            if (entries == null) {
                                entries = new ArrayList<DownloadManager>();
                                plugin_limiters.put(g, entries);
                                entries.add((DownloadManager)((Object)Boolean.valueOf(upload)));
                                entries.add((DownloadManager)new int[]{0});
                            }
                            entries.add(dm);
                        }
                    }
                    PEPeerManager pm = dm.getPeerManager();
                    if (pm == null) continue;
                    List<PEPeer> peers = pm.getPeers();
                    for (PEPeer peer : peers) {
                        Boolean[] arr$2 = new Boolean[]{true, false};
                        int len$2 = arr$2.length;
                        for (int i$ = 0; i$ < len$2; ++i$) {
                            boolean upload = arr$2[i$];
                            List limiters = SpeedLimitHandler.this.trim(peer.getRateLimiters(upload));
                            for (LimitedRateGroup g : limiters) {
                                ArrayList<Object> entries = (ArrayList<Object>)plugin_limiters.get(g);
                                if (entries == null) {
                                    entries = new ArrayList<Object>();
                                    plugin_limiters.put(g, entries);
                                    entries.add(upload);
                                    entries.add(new int[]{1});
                                    continue;
                                }
                                int[] nArray = (int[])entries.get(1);
                                nArray[0] = nArray[0] + 1;
                            }
                        }
                    }
                }
                result.add("");
                result.add("Plugin Limits");
                if (plugin_limiters.size() == 0) {
                    result.add("    None");
                } else {
                    ArrayList<String> plugin_lines = new ArrayList<String>();
                    for (Map.Entry entry : plugin_limiters.entrySet()) {
                        LimitedRateGroup group = (LimitedRateGroup)entry.getKey();
                        List list = (List)entry.getValue();
                        boolean is_upload = (Boolean)list.get(0);
                        int peers = ((int[])list.get(1))[0];
                        String line = "    " + group.getName() + ": " + (is_upload ? SpeedLimitHandler.this.formatUp(group.getRateLimitBytesPerSecond()) : SpeedLimitHandler.this.formatDown(group.getRateLimitBytesPerSecond()));
                        if (peers > 0) {
                            line = line + ", peers=" + peers;
                        }
                        if (list.size() > 2) {
                            line = line + ", downloads=" + (list.size() - 2);
                        }
                        plugin_lines.add(line);
                    }
                    Collections.sort(plugin_lines);
                    result.addAll(plugin_lines);
                }
            }
            return result;
        }
    }

    private static class NetLimit {
        private String profile;
        private long[] limits;

        private NetLimit(String _profile, long _total_lim, long _up_lim, long _down_lim) {
            this.profile = _profile;
            this.limits = new long[]{_total_lim, _up_lim, _down_lim};
        }

        private String getProfile() {
            return this.profile;
        }

        private long[] getLimits() {
            return this.limits;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScheduleRule {
        private static final byte FR_MON = 1;
        private static final byte FR_TUE = 2;
        private static final byte FR_WED = 4;
        private static final byte FR_THU = 8;
        private static final byte FR_FRI = 16;
        private static final byte FR_SAT = 32;
        private static final byte FR_SUN = 64;
        private static final byte FR_OVERFLOW = -128;
        private static final byte FR_WEEKDAY = 31;
        private static final byte FR_WEEKEND = 96;
        private static final byte FR_DAILY = 127;
        private String profile_name;
        private byte frequency;
        private int from_mins;
        private int to_mins;
        private List<ScheduleRuleExtensions> extensions;

        private ScheduleRule(byte _freq, String _profile, int _from, int _to, List<ScheduleRuleExtensions> _exts) {
            this.frequency = _freq;
            this.profile_name = _profile;
            this.from_mins = _from;
            this.to_mins = _to;
            this.extensions = _exts;
        }

        private List<ScheduleRule> splitByDay() {
            ArrayList<ScheduleRule> result = new ArrayList<ScheduleRule>();
            if (this.to_mins > this.from_mins) {
                result.add(this);
            } else {
                byte next_frequency = (byte)(this.frequency << 1);
                if ((next_frequency & 0xFFFFFF80) != 0) {
                    next_frequency = (byte)(next_frequency & 0x7F);
                    next_frequency = (byte)(next_frequency | 1);
                }
                ScheduleRule rule1 = new ScheduleRule(this.frequency, this.profile_name, this.from_mins, 1439, this.extensions);
                ScheduleRule rule2 = new ScheduleRule(next_frequency, this.profile_name, 0, this.to_mins, this.extensions);
                result.add(rule1);
                result.add(rule2);
            }
            return result;
        }

        private void checkExtensions() {
            if (this.extensions != null) {
                for (ScheduleRuleExtensions ext : this.extensions) {
                    ext.checkExtension();
                }
            }
        }

        private boolean sameAs(ScheduleRule other) {
            if (other == null) {
                return false;
            }
            if (this.extensions != other.extensions) {
                if (this.extensions == null || other.extensions == null || this.extensions.size() != other.extensions.size()) {
                    return false;
                }
                for (ScheduleRuleExtensions ext1 : this.extensions) {
                    boolean match = false;
                    for (ScheduleRuleExtensions ext2 : other.extensions) {
                        if (!ext1.sameAs(ext2)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    return false;
                }
            }
            return this.frequency == other.frequency && this.profile_name.equals(other.profile_name) && this.from_mins == other.from_mins && this.to_mins == other.to_mins;
        }

        public String getString() {
            String freq_str = "";
            if (this.frequency == 127) {
                freq_str = "daily";
            } else if (this.frequency == 31) {
                freq_str = "weekdays";
            } else if (this.frequency == 96) {
                freq_str = "weekends";
            } else if (this.frequency == 1) {
                freq_str = "mon";
            } else if (this.frequency == 2) {
                freq_str = "tue";
            } else if (this.frequency == 4) {
                freq_str = "wed";
            } else if (this.frequency == 8) {
                freq_str = "thu";
            } else if (this.frequency == 16) {
                freq_str = "fri";
            } else if (this.frequency == 32) {
                freq_str = "sat";
            } else if (this.frequency == 64) {
                freq_str = "sun";
            }
            String ext_str = "";
            if (this.extensions != null) {
                for (ScheduleRuleExtensions ext : this.extensions) {
                    ext_str = ext_str + ", " + ext.getString();
                }
            }
            return "profile=" + this.profile_name + ", frequency=" + freq_str + ", from=" + this.getTime(this.from_mins) + ", to=" + this.getTime(this.to_mins) + ext_str;
        }

        private String getTime(int mins) {
            String str = this.getTimeBit(mins / 60) + ":" + this.getTimeBit(mins % 60);
            return str;
        }

        private String getTimeBit(int num) {
            String str = String.valueOf(num);
            if (str.length() < 2) {
                str = "0" + str;
            }
            return str;
        }
    }

    private class ScheduleRuleExtensions {
        private static final int ET_START_TAG = 1;
        private static final int ET_STOP_TAG = 2;
        private static final int ET_PAUSE_TAG = 3;
        private static final int ET_RESUME_TAG = 4;
        private int extension_type;
        private TagDownload tag;

        private ScheduleRuleExtensions(int _et, TagDownload _tag) {
            this.extension_type = _et;
            this.tag = _tag;
        }

        private void checkExtension() {
            Set<DownloadManager> downloads = this.tag.getTaggedDownloads();
            for (DownloadManager download : downloads) {
                if (download.isPaused()) {
                    if (this.extension_type != 4 || SpeedLimitHandler.this.rule_pause_all_active || SpeedLimitHandler.this.net_limit_pause_all_active) continue;
                    download.resume();
                    continue;
                }
                int state = download.getState();
                if (this.extension_type == 1) {
                    if (state != 70) continue;
                    download.setStateWaiting();
                    continue;
                }
                if (this.extension_type == 3) {
                    if (download.isPaused()) continue;
                    download.pause();
                    continue;
                }
                if (this.extension_type != 2 || state == 8 || state == 7 || state == 6) continue;
                download.stopIt(70, false, false);
            }
        }

        private boolean sameAs(ScheduleRuleExtensions other) {
            return this.extension_type == other.extension_type && this.tag == other.tag;
        }

        private String getString() {
            String str = this.extension_type == 1 ? "start_tag" : (this.extension_type == 2 ? "stop_tag" : (this.extension_type == 4 ? "resume_tag" : "pause_tag"));
            str = str + ":" + this.tag.getTagName(true);
            return str;
        }
    }
}

