/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.tag.impl;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagDownload;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import com.aelitis.azureus.core.tag.TagListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.core.tag.impl.TagTypeBase;
import com.aelitis.azureus.core.tag.impl.TagWithState;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagDownloadWithState
extends TagWithState
implements TagDownload {
    private int upload_rate_limit;
    private int download_rate_limit;
    private int upload_rate = -1;
    private int download_rate = -1;
    private long last_rate_update;
    private Object UPLOAD_PRIORITY_ADDED_KEY = new Object();
    private int upload_priority;
    private int min_share_ratio;
    private int max_share_ratio;
    private boolean supports_xcode;
    private boolean supports_file_location;
    private LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        public String getName() {
            return "tag_up: " + TagDownloadWithState.this.getTagName(true);
        }

        public int getRateLimitBytesPerSecond() {
            return TagDownloadWithState.this.upload_rate_limit;
        }

        public void updateBytesUsed(int used) {
        }
    };
    private LimitedRateGroup download_limiter = new LimitedRateGroup(){

        public String getName() {
            return "tag_down: " + TagDownloadWithState.this.getTagName(true);
        }

        public int getRateLimitBytesPerSecond() {
            return TagDownloadWithState.this.download_rate_limit;
        }

        public void updateBytesUsed(int used) {
        }
    };
    private boolean do_rates;
    private boolean do_up;
    private boolean do_down;
    private int run_states;
    private static AsyncDispatcher rs_async = new AsyncDispatcher(2000);
    private TagFeatureProperties.TagProperty[] tag_properties = new TagFeatureProperties.TagProperty[]{this.createTagProperty("trackers", 1), this.createTagProperty("untagged", 2), this.createTagProperty("tracker_templates", 1), this.createTagProperty("constraint", 1)};

    public TagDownloadWithState(TagTypeBase tt, int tag_id, String name, boolean do_rates, boolean do_up, boolean do_down, int run_states) {
        super(tt, tag_id, name);
        this.init(do_rates, do_up, do_down, run_states);
    }

    protected TagDownloadWithState(TagTypeBase tt, int tag_id, Map details, boolean do_rates, boolean do_up, boolean do_down, int run_states) {
        super(tt, tag_id, details);
        this.init(do_rates, do_up, do_down, run_states);
    }

    private void init(boolean _do_rates, boolean _do_up, boolean _do_down, int _run_states) {
        this.do_rates = _do_rates;
        this.do_up = _do_up;
        this.do_down = _do_down;
        this.run_states = _run_states;
        if (this.do_up) {
            this.upload_rate_limit = (int)this.readLongAttribute("rl.up", 0L);
        }
        if (this.do_down) {
            this.download_rate_limit = (int)this.readLongAttribute("rl.down", 0L);
        }
        this.upload_priority = (int)this.readLongAttribute("rl.uppri", 0L);
        this.min_share_ratio = (int)this.readLongAttribute("rl.minsr", 0L);
        this.max_share_ratio = (int)this.readLongAttribute("rl.maxsr", 0L);
        this.addTagListener(new TagListener(){

            public void taggableAdded(Tag tag, Taggable tagged) {
                DownloadManager manager = (DownloadManager)tagged;
                manager.addRateLimiter(TagDownloadWithState.this.upload_limiter, true);
                manager.addRateLimiter(TagDownloadWithState.this.download_limiter, false);
                if (TagDownloadWithState.this.upload_priority > 0) {
                    manager.updateAutoUploadPriority(TagDownloadWithState.this.UPLOAD_PRIORITY_ADDED_KEY, true);
                }
                if (TagDownloadWithState.this.min_share_ratio > 0) {
                    this.updateMinShareRatio(manager, TagDownloadWithState.this.min_share_ratio);
                }
                if (TagDownloadWithState.this.max_share_ratio > 0) {
                    this.updateMaxShareRatio(manager, TagDownloadWithState.this.max_share_ratio);
                }
            }

            public void taggableSync(Tag tag) {
            }

            public void taggableRemoved(Tag tag, Taggable tagged) {
                DownloadManager manager = (DownloadManager)tagged;
                manager.removeRateLimiter(TagDownloadWithState.this.upload_limiter, true);
                manager.removeRateLimiter(TagDownloadWithState.this.download_limiter, false);
                if (TagDownloadWithState.this.upload_priority > 0) {
                    manager.updateAutoUploadPriority(TagDownloadWithState.this.UPLOAD_PRIORITY_ADDED_KEY, false);
                }
                if (TagDownloadWithState.this.min_share_ratio > 0) {
                    this.updateMinShareRatio(manager, 0);
                }
                if (TagDownloadWithState.this.max_share_ratio > 0) {
                    this.updateMaxShareRatio(manager, 0);
                }
            }

            private void updateMinShareRatio(DownloadManager manager, int sr) {
                List<Tag> dm_tags = TagDownloadWithState.this.getTagType().getTagsForTaggable(manager);
                for (Tag t : dm_tags) {
                    int o_sr;
                    if (t == TagDownloadWithState.this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMinShareRatio()) <= sr) continue;
                    sr = o_sr;
                }
                manager.getDownloadState().setIntParameter("sr.min", sr);
            }

            private void updateMaxShareRatio(DownloadManager manager, int sr) {
                List<Tag> dm_tags = TagDownloadWithState.this.getTagType().getTagsForTaggable(manager);
                for (Tag t : dm_tags) {
                    int o_sr;
                    if (t == TagDownloadWithState.this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMaxShareRatio()) <= sr) continue;
                    sr = o_sr;
                }
                manager.getDownloadState().setIntParameter("sr.max", sr);
            }
        }, true);
    }

    @Override
    public void removeTag() {
        for (DownloadManager dm : this.getTaggedDownloads()) {
            dm.removeRateLimiter(this.upload_limiter, true);
            dm.removeRateLimiter(this.download_limiter, false);
            if (this.upload_priority <= 0) continue;
            dm.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, false);
        }
        super.removeTag();
    }

    @Override
    public void addTaggable(Taggable t) {
        if (t instanceof DownloadManager) {
            DownloadManager dm = (DownloadManager)t;
            if (!dm.isDestroyed()) {
                super.addTaggable(t);
            }
        } else {
            Debug.out("Invalid Taggable added: " + t);
        }
    }

    @Override
    public int getTaggableTypes() {
        return 2;
    }

    @Override
    public Set<DownloadManager> getTaggedDownloads() {
        return this.getTagged();
    }

    @Override
    public boolean supportsTagRates() {
        return this.do_rates;
    }

    @Override
    public boolean supportsTagUploadLimit() {
        return this.do_up;
    }

    @Override
    public boolean supportsTagDownloadLimit() {
        return this.do_down;
    }

    @Override
    public int getTagUploadLimit() {
        return this.upload_rate_limit;
    }

    @Override
    public void setTagUploadLimit(int bps) {
        if (this.upload_rate_limit == bps) {
            return;
        }
        if (!this.do_up) {
            Debug.out("Not supported");
            return;
        }
        this.upload_rate_limit = bps;
        this.writeLongAttribute("rl.up", this.upload_rate_limit);
        this.getTagType().fireChanged(this);
    }

    @Override
    public int getTagCurrentUploadRate() {
        this.updateRates();
        return this.upload_rate;
    }

    @Override
    public int getTagDownloadLimit() {
        return this.download_rate_limit;
    }

    @Override
    public void setTagDownloadLimit(int bps) {
        if (this.download_rate_limit == bps) {
            return;
        }
        if (!this.do_down) {
            Debug.out("Not supported");
            return;
        }
        this.download_rate_limit = bps;
        this.writeLongAttribute("rl.down", this.download_rate_limit);
        this.getTagType().fireChanged(this);
    }

    @Override
    public int getTagCurrentDownloadRate() {
        this.updateRates();
        return this.download_rate;
    }

    @Override
    public int getTagUploadPriority() {
        return this.upload_priority;
    }

    @Override
    public void setTagUploadPriority(int priority) {
        if (priority < 0) {
            priority = 0;
        }
        if (priority == this.upload_priority) {
            return;
        }
        int old_up = this.upload_priority;
        this.upload_priority = priority;
        this.writeLongAttribute("rl.uppri", priority);
        if (old_up == 0 || priority == 0) {
            Set<DownloadManager> dms = this.getTaggedDownloads();
            for (DownloadManager dm : dms) {
                dm.updateAutoUploadPriority(this.UPLOAD_PRIORITY_ADDED_KEY, priority > 0);
            }
        }
        this.getTagType().fireChanged(this);
    }

    @Override
    public int getTagMinShareRatio() {
        return this.min_share_ratio;
    }

    @Override
    public void setTagMinShareRatio(int sr) {
        if (sr < 0) {
            sr = 0;
        }
        if (sr == this.min_share_ratio) {
            return;
        }
        this.min_share_ratio = sr;
        this.writeLongAttribute("rl.minsr", sr);
        Set<DownloadManager> dms = this.getTaggedDownloads();
        for (DownloadManager dm : dms) {
            List<Tag> dm_tags = this.getTagType().getTagsForTaggable(dm);
            for (Tag t : dm_tags) {
                int o_sr;
                if (t == this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMinShareRatio()) <= sr) continue;
                sr = o_sr;
            }
            dm.getDownloadState().setIntParameter("sr.min", sr);
        }
        this.getTagType().fireChanged(this);
    }

    @Override
    public int getTagMaxShareRatio() {
        return this.max_share_ratio;
    }

    @Override
    public void setTagMaxShareRatio(int sr) {
        if (sr < 0) {
            sr = 0;
        }
        if (sr == this.max_share_ratio) {
            return;
        }
        this.max_share_ratio = sr;
        this.writeLongAttribute("rl.maxsr", sr);
        Set<DownloadManager> dms = this.getTaggedDownloads();
        for (DownloadManager dm : dms) {
            List<Tag> dm_tags = this.getTagType().getTagsForTaggable(dm);
            for (Tag t : dm_tags) {
                int o_sr;
                if (t == this || !(t instanceof TagFeatureRateLimit) || (o_sr = ((TagFeatureRateLimit)((Object)t)).getTagMaxShareRatio()) <= sr) continue;
                sr = o_sr;
            }
            dm.getDownloadState().setIntParameter("sr.max", sr);
        }
        this.getTagType().fireChanged(this);
    }

    private void updateRates() {
        long now = SystemTime.getCurrentTime();
        if (now - this.last_rate_update > 2500L) {
            int new_up = 0;
            int new_down = 0;
            Set<DownloadManager> dms = this.getTaggedDownloads();
            if (dms.size() == 0) {
                new_up = -1;
                new_down = -1;
            } else {
                new_up = 0;
                new_down = 0;
                for (DownloadManager dm : dms) {
                    DownloadManagerStats stats2 = dm.getStats();
                    new_up = (int)((long)new_up + (stats2.getDataSendRate() + stats2.getProtocolSendRate()));
                    new_down = (int)((long)new_down + (stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate()));
                }
            }
            this.upload_rate = new_up;
            this.download_rate = new_down;
            this.last_rate_update = now;
        }
    }

    @Override
    public int getRunStateCapabilities() {
        return this.run_states;
    }

    @Override
    public boolean hasRunStateCapability(int capability) {
        return (this.run_states & capability) != 0;
    }

    @Override
    public boolean[] getPerformableOperations(int[] ops) {
        boolean[] result = new boolean[ops.length];
        Set<DownloadManager> dms = this.getTaggedDownloads();
        for (DownloadManager dm : dms) {
            int dm_state = dm.getState();
            for (int i = 0; i < ops.length; ++i) {
                if (result[i]) continue;
                int op = ops[i];
                if ((op & 8) != 0 && (dm_state == 70 || dm_state == 100)) {
                    result[i] = true;
                }
                if ((op & 1) != 0 && dm_state != 70 && dm_state != 65 && dm_state != 100) {
                    result[i] = true;
                }
                if ((op & 2) != 0 && dm_state != 70 && dm_state != 65 && dm_state != 100 && !dm.isPaused()) {
                    result[i] = true;
                }
                if ((op & 4) == 0 || !dm.isPaused()) continue;
                result[i] = true;
            }
        }
        return result;
    }

    @Override
    public void performOperation(int op) {
        Set<DownloadManager> dms = this.getTaggedDownloads();
        for (final DownloadManager dm : dms) {
            int dm_state = dm.getState();
            if (op == 8) {
                if (dm_state != 70 && dm_state != 100) continue;
                rs_async.dispatch(new AERunnable(){

                    public void runSupport() {
                        dm.setStateQueued();
                    }
                });
                continue;
            }
            if (op == 1) {
                if (dm_state == 70 || dm_state == 65 || dm_state == 100) continue;
                rs_async.dispatch(new AERunnable(){

                    public void runSupport() {
                        dm.stopIt(70, false, false);
                    }
                });
                continue;
            }
            if (op == 2) {
                if (dm_state == 70 || dm_state == 65 || dm_state == 100) continue;
                rs_async.dispatch(new AERunnable(){

                    public void runSupport() {
                        dm.pause();
                    }
                });
                continue;
            }
            if (op != 4 || !dm.isPaused()) continue;
            rs_async.dispatch(new AERunnable(){

                public void runSupport() {
                    dm.resume();
                }
            });
        }
    }

    protected void setSupportsTagTranscode(boolean sup) {
        this.supports_xcode = sup;
    }

    @Override
    public boolean supportsTagTranscode() {
        return this.supports_xcode;
    }

    @Override
    public String[] getTagTranscodeTarget() {
        String temp = this.readStringAttribute("xcode.to", null);
        if (temp == null) {
            return null;
        }
        String[] bits = temp.split("\n");
        if (bits.length != 2) {
            return null;
        }
        return bits;
    }

    @Override
    public void setTagTranscodeTarget(String uid, String name) {
        this.writeStringAttribute("xcode.to", uid == null ? null : uid + "\n" + name);
        this.getTagType().fireChanged(this);
        this.getManager().featureChanged(this, 8);
    }

    protected void setSupportsFileLocation(boolean sup) {
        this.supports_file_location = sup;
    }

    @Override
    public boolean supportsTagInitialSaveFolder() {
        return this.supports_file_location;
    }

    @Override
    public boolean supportsTagMoveOnComplete() {
        return this.supports_file_location;
    }

    @Override
    public boolean supportsTagCopyOnComplete() {
        return this.supports_file_location;
    }

    @Override
    public TagFeatureProperties.TagProperty[] getSupportedProperties() {
        return this.getTagType().isTagTypeAuto() ? new TagFeatureProperties.TagProperty[]{} : this.tag_properties;
    }

    @Override
    public boolean isTagAuto() {
        TagFeatureProperties.TagProperty[] props;
        for (TagFeatureProperties.TagProperty prop : props = this.getSupportedProperties()) {
            String[] val;
            Boolean b;
            int type;
            String name = prop.getName(false);
            if (name.equals("tracker_templates") || !((type = prop.getType()) == 2 ? (b = prop.getBoolean()) != null && b != false : type == 1 && (val = prop.getStringList()) != null && val.length > 0)) continue;
            return true;
        }
        return false;
    }
}

