/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.swt;

import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBeta;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginUtils;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginViewInterface;
import com.aelitis.azureus.plugins.net.buddy.swt.ChatMDIEntry;
import com.aelitis.azureus.plugins.net.buddy.swt.SBC_ChatOverview;
import java.util.HashMap;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class ChatView
implements UISWTViewCoreEventListener {
    private BuddyPluginBeta.ChatInstance current_chat;
    private BuddyPluginBeta.ChatInstance initialized_chat;
    private BuddyPluginViewInterface.View chat_view;

    private void initialize(Composite _parent_composite) {
        try {
            if (this.current_chat != null) {
                this.initialized_chat = this.current_chat;
                HashMap<String, Object> chat_properties = new HashMap<String, Object>();
                chat_properties.put("swt_comp", _parent_composite);
                chat_properties.put("chat", this.current_chat);
                this.chat_view = BuddyPluginUtils.buildChatView(chat_properties, new BuddyPluginViewInterface.ViewListener(){

                    public void chatActivated(BuddyPluginBeta.ChatInstance chat) {
                    }
                });
                ChatMDIEntry mdi_entry = (ChatMDIEntry)this.current_chat.getUserData(SBC_ChatOverview.MDI_KEY);
                if (mdi_entry != null) {
                    mdi_entry.setView(this);
                }
            } else {
                Debug.out("No current chat");
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected void handleDrop(String drop) {
        this.chat_view.handleDrop(drop);
    }

    private void viewActivated() {
        if (this.chat_view != null) {
            this.chat_view.activate();
        }
    }

    private void viewDeactivated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataSourceChanged(Object data) {
        ChatView chatView = this;
        synchronized (chatView) {
            if (data instanceof BuddyPluginBeta.ChatInstance) {
                BuddyPluginBeta.ChatInstance chat = (BuddyPluginBeta.ChatInstance)data;
                try {
                    if (this.current_chat == null) {
                        this.current_chat = chat.getClone();
                    } else if (!this.current_chat.getNetAndKey().equals(chat.getNetAndKey())) {
                        this.current_chat.destroy();
                        this.current_chat = chat.getClone();
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                break;
            }
            case 7: {
                ChatView chatView = this;
                synchronized (chatView) {
                    if (this.current_chat != null && this.current_chat != this.initialized_chat) {
                        this.current_chat.destroy();
                        this.current_chat = null;
                    }
                    break;
                }
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
                break;
            }
        }
        return true;
    }
}

