/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.tag;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagFeatureExecOnAssign;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnTagProperties
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag.properties";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)1);
    }

    public ColumnTagProperties(TableColumn column) {
        column.setWidth(160);
        column.setRefreshInterval(-2);
        column.addListeners(this);
    }

    public void refresh(TableCell cell) {
        TagFeatureExecOnAssign eoa;
        int actions;
        TagFeatureProperties tp2;
        TagFeatureProperties.TagProperty[] props;
        Tag tag = (Tag)cell.getDataSource();
        String text = "";
        if (tag instanceof TagFeatureProperties && (props = (tp2 = (TagFeatureProperties)((Object)tag)).getSupportedProperties()).length > 0) {
            for (TagFeatureProperties.TagProperty prop : props) {
                String prop_str = prop.getString();
                if (prop_str.length() <= 0) continue;
                text = text + (text.length() == 0 ? "" : "; ") + prop_str;
            }
        }
        if (tag instanceof TagFeatureExecOnAssign && (actions = (eoa = (TagFeatureExecOnAssign)((Object)tag)).getSupportedActions()) != 0) {
            boolean enabled;
            String actions_str = "";
            if (eoa.supportsAction(1) && (enabled = eoa.isActionEnabled(1))) {
                actions_str = actions_str + MessageText.getString("FileItem.delete") + "=Y";
            }
            if (actions_str.length() > 0) {
                text = text + (text.length() == 0 ? "" : "; ") + MessageText.getString("label.exec.on.assign") + ": ";
                text = text + actions_str;
            }
        }
        if (!cell.setSortValue((Comparable)((Object)text)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(text);
    }
}

