/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnTorrentFileProgress;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnProgressETA
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellMouseListener,
TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "ProgressETA";
    private static final int borderWidth = 1;
    private static final int COLUMN_WIDTH = 200;
    public static final long SHOW_ETA_AFTER_MS = 30000L;
    private static final Object CLICK_KEY = new Object();
    protected static final String CFG_SHOWETA = "ColumnProgressETA.showETA";
    protected static final String CFG_SHOWSPEED = "ColumnProgressETA.showSpeed";
    private static Font fontText = null;
    Display display;
    private Color cBGdl;
    private Color cBGcd;
    private Color cBorder;
    private Color cText;
    Color textColor;
    private Image imgBGTorrent;
    private Color cTextDrop;
    private ViewUtils.CustomDateFormat cdf;
    private ColumnTorrentFileProgress fileProgress;
    protected boolean showETA;
    protected boolean showSpeed;

    public ColumnProgressETA(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 200, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.initializeAsGraphic(200);
        this.setAlignment(1);
        this.setMinWidth(200);
        this.display = SWTThread.getInstance().getDisplay();
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.cBGdl = skinProperties.getColor("color.progress.bg.dl");
        if (this.cBGdl == null) {
            this.cBGdl = Colors.blues[9];
        }
        this.cBGcd = skinProperties.getColor("color.progress.bg.cd");
        if (this.cBGcd == null) {
            this.cBGcd = Colors.green;
        }
        this.cBorder = skinProperties.getColor("color.progress.border");
        if (this.cBorder == null) {
            this.cBorder = Colors.grey;
        }
        this.cText = skinProperties.getColor("color.progress.text");
        if (this.cText == null) {
            this.cText = Colors.black;
        }
        this.cTextDrop = skinProperties.getColor("color.progress.text.drop");
        this.cdf = ViewUtils.addCustomDateFormat(this);
        ImageLoader imageLoader = ImageLoader.getInstance();
        this.imgBGTorrent = imageLoader.getImage("image.progress.bg.torrent");
        this.fileProgress = new ColumnTorrentFileProgress(this.display);
        TableContextMenuItem menuShowETA = this.addContextMenuItem(CFG_SHOWETA, 1);
        menuShowETA.setStyle(2);
        menuShowETA.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(new Boolean(ColumnProgressETA.this.showETA));
            }
        });
        menuShowETA.addMultiListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                ColumnProgressETA.this.showETA = (Boolean)menu.getData();
                ColumnProgressETA.this.setUserData(ColumnProgressETA.CFG_SHOWETA, ColumnProgressETA.this.showETA ? 1 : 0);
            }
        });
        TableContextMenuItem menuShowSpeed = this.addContextMenuItem(CFG_SHOWSPEED, 1);
        menuShowSpeed.setStyle(2);
        menuShowSpeed.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(new Boolean(ColumnProgressETA.this.showSpeed));
            }
        });
        menuShowSpeed.addMultiListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                ColumnProgressETA.this.showSpeed = (Boolean)menu.getData();
                ColumnProgressETA.this.setUserData(ColumnProgressETA.CFG_SHOWSPEED, ColumnProgressETA.this.showSpeed ? 1 : 0);
            }
        });
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "essential", "time"});
        info.setProficiency((byte)0);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginHeight(3);
        cell.setMarginWidth(8);
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String url;
        Object ds = event2.cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            this.fileProgress.fileInfoMouseTrigger(event2);
            return;
        }
        DownloadManager dm = (DownloadManager)ds;
        if (dm == null) {
            return;
        }
        String clickable = (String)dm.getUserData(CLICK_KEY);
        if (clickable == null) {
            return;
        }
        event2.skipCoreFunctionality = true;
        if (event2.eventType == 1 && (url = UrlUtils.getURL(clickable)) != null) {
            Utils.launch(url);
        }
    }

    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        long percentDone = this.getPercentDone(ds);
        long sortValue = 0L;
        if (ds instanceof DownloadManager) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            int hashCode = Math.abs(DisplayFormatters.formatDownloadStatus(dm).hashCode());
            long completedTime = dm.getDownloadState().getLongParameter("stats.download.completed.time");
            sortValue = completedTime <= 0L || !dm.isDownloadComplete(false) ? (percentDone << 31) + (long)hashCode : (completedTime / 1000L << 31) + (long)hashCode;
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            int st = fileInfo2.getStorageType();
            if ((st == 2 || st == 4) && fileInfo2.isSkipped()) {
                sortValue = 1L;
            } else if (fileInfo2.isSkipped()) {
                sortValue = 2L;
            } else if (fileInfo2.getPriority() > 0) {
                int pri = fileInfo2.getPriority();
                sortValue = 4L;
                if (pri > 1) {
                    sortValue += (long)pri;
                }
            } else {
                sortValue = 3L;
            }
            sortValue = (long)(fileInfo2.getDownloadManager().getState() * 10000) + percentDone + sortValue;
        }
        long eta = this.showETA ? this.getETA(cell) : 0L;
        long speed = this.showSpeed ? this.getSpeed(ds) : 0L;
        Comparable old = cell.getSortValue();
        boolean sortChanged = cell.setSortValue(sortValue);
        if (sortChanged && old != null && !(old instanceof String)) {
            UIFunctionsManagerSWT.getUIFunctionsSWT().refreshIconBar();
        }
        long lastETA = 0L;
        long lastSpeed = 0L;
        TableRow row = cell.getTableRow();
        if (row != null) {
            Object data;
            if (this.showETA) {
                data = row.getData("lastETA");
                if (data instanceof Number) {
                    lastETA = ((Number)data).longValue();
                }
                row.setData("lastETA", new Long(eta));
            }
            if (this.showSpeed) {
                data = row.getData("lastSpeed");
                if (data instanceof Number) {
                    lastSpeed = ((Number)data).longValue();
                }
                row.setData("lastSpeed", new Long(speed));
            }
        }
        if (!(sortChanged || lastETA == eta && lastSpeed == speed)) {
            cell.invalidate();
        }
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        long lSpeed;
        boolean showSecondLine;
        Color fgFirst;
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            this.fileProgress.fillInfoProgressETA(cell.getTableRowCore(), gc, (DiskManagerFileInfo)ds, cell.getBounds());
            return;
        }
        if (!(ds instanceof DownloadManager)) {
            return;
        }
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int percentDone = this.getPercentDone(ds);
        long eta = this.showETA ? this.getETA(cell) : 0L;
        int newWidth = cell.getWidth();
        if (newWidth <= 0) {
            return;
        }
        int newHeight = cell.getHeight();
        Color fgOriginal = fgFirst = gc.getForeground();
        Rectangle cellBounds = cell.getBounds();
        int xStart = cellBounds.x;
        int yStart = cellBounds.y;
        int xRelProgressFillStart = 1;
        int yRelProgressFillStart = 1;
        int xRelProgressFillEnd = newWidth - xRelProgressFillStart - 1;
        int yRelProgressFillEnd = yRelProgressFillStart + 13;
        boolean bl = showSecondLine = yRelProgressFillEnd + 10 < newHeight;
        if (xRelProgressFillEnd < 10) {
            return;
        }
        String sStatusLine = null;
        Rectangle boundsImgBG = !ImageLoader.isRealImage(this.imgBGTorrent) ? new Rectangle(0, 0, 0, 13) : this.imgBGTorrent.getBounds();
        if (fontText == null) {
            fontText = FontUtils.getFontWithHeight(gc.getFont(), gc, boundsImgBG.height - 3);
        }
        if (!showSecondLine) {
            yRelProgressFillStart = cellBounds.height / 2 - boundsImgBG.height / 2;
        }
        yRelProgressFillEnd = yRelProgressFillStart + boundsImgBG.height;
        int progressWidth = newWidth - 2;
        gc.setForeground(this.cBorder);
        gc.drawRectangle(xStart + xRelProgressFillStart - 1, yStart + yRelProgressFillStart - 1, progressWidth + 1, boundsImgBG.height + 1);
        int pctWidth = percentDone * progressWidth / 1000;
        gc.setBackground(percentDone == 1000 || dm.isDownloadComplete(false) ? this.cBGcd : this.cBGdl);
        gc.fillRectangle(xStart + xRelProgressFillStart, yStart + yRelProgressFillStart, pctWidth, boundsImgBG.height);
        if (progressWidth > pctWidth) {
            gc.setBackground(Colors.white);
            gc.fillRectangle(xStart + xRelProgressFillStart + pctWidth, yStart + yRelProgressFillStart, progressWidth - pctWidth, boundsImgBG.height);
        }
        if (boundsImgBG.width > 0) {
            gc.drawImage(this.imgBGTorrent, 0, 0, boundsImgBG.width, boundsImgBG.height, xStart + xRelProgressFillStart, yStart + yRelProgressFillStart, progressWidth, boundsImgBG.height);
        }
        if (sStatusLine == null) {
            int cursor_id;
            if (dm.isUnauthorisedOnTracker()) {
                sStatusLine = dm.getTrackerStatus();
            } else if (this.showETA && eta > 0L) {
                String sETA = ViewUtils.formatETA(eta, MyTorrentsView.progress_eta_absolute, this.cdf.getDateFormat());
                sStatusLine = MessageText.getString("MyTorrents.column.ColumnProgressETA.2ndLine", new String[]{sETA});
            } else {
                sStatusLine = DisplayFormatters.formatDownloadStatus(dm).toUpperCase();
            }
            if (sStatusLine != null && sStatusLine.indexOf("http://") == -1) {
                dm.setUserData(CLICK_KEY, null);
                cursor_id = 0;
            } else {
                dm.setUserData(CLICK_KEY, sStatusLine);
                cursor_id = 21;
                if (!cell.getTableRow().isSelected()) {
                    fgFirst = Colors.blue;
                }
            }
            cell.setCursorID(cursor_id);
        }
        gc.setTextAntialias(1);
        gc.setFont(fontText);
        if (showSecondLine && sStatusLine != null) {
            gc.setForeground(fgFirst);
            boolean over = GCStringPrinter.printString(gc, sStatusLine, new Rectangle(cellBounds.x, yStart + yRelProgressFillEnd, cellBounds.width, newHeight - yRelProgressFillEnd), true, false, 0x1000000);
            cell.setToolTip(over ? sStatusLine : null);
            gc.setForeground(fgOriginal);
        }
        String sSpeed = "";
        if (this.showSpeed && (lSpeed = this.getSpeed(ds)) > 0L) {
            sSpeed = " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(lSpeed, true) + ")";
        }
        String sPercent = DisplayFormatters.formatPercentFromThousands(percentDone);
        Rectangle area = new Rectangle(xStart + xRelProgressFillStart + 3, yStart + yRelProgressFillStart, xRelProgressFillEnd - xRelProgressFillStart - 6, yRelProgressFillEnd - yRelProgressFillStart);
        GCStringPrinter sp = new GCStringPrinter(gc, sPercent + sSpeed, area, true, false, 16384);
        if (this.cTextDrop != null) {
            ++area.x;
            ++area.y;
            gc.setForeground(this.cTextDrop);
            sp.printString();
            --area.x;
            --area.y;
        }
        gc.setForeground(this.cText);
        sp.printString();
        Point pctExtent = sp.getCalculatedSize();
        area.width -= pctExtent.x + 3;
        area.x += pctExtent.x + 3;
        if (!showSecondLine && sStatusLine != null) {
            boolean fit = GCStringPrinter.printString(gc, sStatusLine, area.intersection(cellBounds), true, false, 131072);
            cell.setToolTip(fit ? null : sStatusLine);
        }
        gc.setFont(null);
    }

    private int getPercentDone(Object ds) {
        if (ds instanceof DownloadManager) {
            return ((DownloadManager)ds).getStats().getPercentDoneExcludingDND();
        }
        if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            long length = fileInfo2.getLength();
            if (length == 0L) {
                return 1000;
            }
            return (int)(fileInfo2.getDownloaded() * 1000L / length);
        }
        return 0;
    }

    private long getETA(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            return 0L;
        }
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long diff = SystemTime.getCurrentTime() - dm.getStats().getTimeStarted();
        if (diff > 30000L) {
            return dm.getStats().getSmoothedETA();
        }
        return 0L;
    }

    private int getState(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return 100;
        }
        return dm.getState();
    }

    private boolean isStopped(TableCell cell) {
        int state = this.getState(cell);
        return state == 75 || state == 70 || state == 65 || state == 100;
    }

    private long getSpeed(Object ds) {
        if (!(ds instanceof DownloadManager)) {
            return 0L;
        }
        return ((DownloadManager)ds).getStats().getDataReceiveRate();
    }

    public EnhancedDownloadManager getEDM(DownloadManager dm) {
        DownloadManagerEnhancer dmEnhancer = DownloadManagerEnhancer.getSingleton();
        if (dmEnhancer == null) {
            return null;
        }
        return dmEnhancer.getEnhancedDownload(dm);
    }

    private void log(TableCell cell, String s) {
        System.out.println(((TableRowCore)cell.getTableRow()).getIndex() + ":" + System.currentTimeMillis() + ": " + s);
    }

    public void postConfigLoad() {
        super.postConfigLoad();
        Object oShowETA = this.getUserData(CFG_SHOWETA);
        if (oShowETA == null) {
            this.showETA = false;
        } else if (oShowETA instanceof Number) {
            this.showETA = ((Number)oShowETA).intValue() == 1;
        }
        Object oShowSpeed = this.getUserData(CFG_SHOWSPEED);
        if (oShowSpeed == null) {
            this.showSpeed = false;
        } else if (oShowSpeed instanceof Number) {
            this.showSpeed = ((Number)oShowSpeed).intValue() == 1;
        }
        this.cdf.update();
    }
}

