/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.search;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.views.skin.SearchResultsTabArea;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.util.ConstantsVuze;
import java.util.Locale;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.webplugin.WebPlugin;

public class SearchHandler {
    public static void handleSearch(String sSearchText, boolean toSubscribe) {
        boolean internal_search;
        if (!toSubscribe) {
            try {
                PluginInterface pi;
                if (COConfigurationManager.getBooleanParameter("rcm.overall.enabled", true) && COConfigurationManager.getBooleanParameter("Plugin.aercm.rcm.search.enable", false) && AzureusCoreFactory.isCoreRunning() && (pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("aercm")) != null && pi.getPluginState().isOperational() && pi.getIPC().canInvoke("lookupByExpression", new Object[]{""})) {
                    pi.getIPC().invoke("lookupByExpression", new Object[]{sSearchText});
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        boolean bl = internal_search = !COConfigurationManager.getBooleanParameter("browser.external.search");
        if (internal_search) {
            String id;
            SearchResultsTabArea.SearchQuery sq = new SearchResultsTabArea.SearchQuery(sSearchText, toSubscribe);
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            MdiEntry existingEntry = mdi.getEntry(id = "Search");
            if (existingEntry != null && existingEntry.isAdded()) {
                SearchResultsTabArea searchClass = (SearchResultsTabArea)SkinViewManager.getByClass(SearchResultsTabArea.class);
                if (searchClass != null) {
                    searchClass.anotherSearch(sSearchText, toSubscribe);
                }
                mdi.showEntry(existingEntry);
                return;
            }
            MdiEntry entry = mdi.createEntryFromSkinRef("header.discovery", id, "main.area.searchresultstab", sSearchText, null, sq, true, "");
            if (entry != null) {
                entry.setImageLeftID("image.sidebar.search");
                entry.setDatasource(sq);
                entry.setViewTitleInfo(new ViewTitleInfo(){

                    public Object getTitleInfoProperty(int propertyID) {
                        SearchResultsTabArea searchClass;
                        if (propertyID == 5 && (searchClass = (SearchResultsTabArea)SkinViewManager.getByClass(SearchResultsTabArea.class)) != null && searchClass.sq != null) {
                            return searchClass.sq.term;
                        }
                        return null;
                    }
                });
            }
            mdi.showEntryByID(id);
        } else {
            PluginInterface xmweb_ui = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("xmwebui");
            if (xmweb_ui == null || !xmweb_ui.getPluginState().isOperational()) {
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("external.browser.failed"), MessageText.getString("xmwebui.required"));
                mb.setParent(uiFunctions.getMainShell());
                mb.open(null);
            } else {
                WebPlugin wp = (WebPlugin)xmweb_ui.getPlugin();
                String remui = wp.getProtocol().toLowerCase(Locale.US) + "://127.0.0.1:" + wp.getPort() + "/";
                String test_url = ConstantsVuze.getDefaultContentNetwork().getServiceURL(2, new Object[]{"", false});
                int pos = test_url.indexOf(63);
                String mode = xmweb_ui.getUtilities().getFeatureManager().isFeatureInstalled("core") ? "plus" : "trial";
                String search_url = test_url.substring(0, pos + 1) + "q=" + UrlUtils.encode(sSearchText) + "&" + "mode=" + mode + "&" + "search_source=" + UrlUtils.encode(remui);
                Utils.launch(search_url);
            }
        }
    }
}

