/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryLogIdListener;
import com.aelitis.azureus.ui.mdi.MdiListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.Initializer;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.UISkinnableManagerSWT;
import com.aelitis.azureus.ui.swt.UISkinnableSWTListener;
import com.aelitis.azureus.ui.swt.columns.utils.TableColumnCreatorV3;
import com.aelitis.azureus.ui.swt.extlistener.StimulusRPC;
import com.aelitis.azureus.ui.swt.mdi.BaseMDI;
import com.aelitis.azureus.ui.swt.mdi.TabbedMDI;
import com.aelitis.azureus.ui.swt.shells.main.MainHelpers;
import com.aelitis.azureus.ui.swt.shells.main.MainMDISetup;
import com.aelitis.azureus.ui.swt.shells.main.MainMenu;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.shells.main.UIFunctionsImpl;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import com.aelitis.azureus.ui.swt.views.skin.WelcomeView;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.NavigationHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelationUtils;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableBoolean;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.TrayWindow;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.associations.AssociationChecker;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.ObfusticateShell;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.donations.DonationWindow;
import org.gudy.azureus2.ui.swt.mainwindow.IMainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.minibar.AllTransfersBar;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.sharing.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.speedtest.SpeedTestSelector;
import org.gudy.azureus2.ui.swt.views.utils.LocProvUtils;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;
import org.gudy.azureus2.ui.swt.welcome.WelcomeWindow;
import org.gudy.azureus2.ui.systray.SystemTraySWT;

public class MainWindowImpl
implements MainWindow,
ObfusticateShell,
MdiListener,
AEDiagnosticsEvidenceGenerator,
MdiEntryLogIdListener,
UIUpdatable {
    private static final LogIDs LOGID = LogIDs.GUI;
    private Shell shell;
    private Display display;
    private AzureusCore core;
    private IUIIntializer uiInitializer;
    private SWTSkin skin;
    private IMainMenu menu;
    private UISWTInstanceImpl uiSWTInstanceImpl;
    private UIFunctionsImpl uiFunctions;
    private SystemTraySWT systemTraySWT;
    private static Map<String, List> mapTrackUsage = null;
    private static final AEMonitor mapTrackUsage_mon = new AEMonitor("mapTrackUsage");
    private long lCurrentTrackTime = 0L;
    private long lCurrentTrackTimeIdle = 0L;
    private boolean disposedOrDisposing;
    private DownloadManager[] dms_Startup;
    private boolean isReady = false;
    private MainStatusBar statusBar;
    private String lastShellStatus = null;
    private Color colorSearchTextBG;
    private Color colorSearchTextFG;
    private boolean delayedCore;
    private TrayWindow downloadBasket;
    private String last_eta_str = null;
    private long last_eta;
    private int eta_tick_count;
    private Set<Shell> minimized_on_hide = new HashSet<Shell>();

    protected MainWindowImpl(AzureusCore core, Display display, final IUIIntializer uiInitializer) {
        this.delayedCore = false;
        this.core = core;
        this.display = display;
        this.uiInitializer = uiInitializer;
        AEDiagnostics.addEvidenceGenerator(this);
        this.disposedOrDisposing = false;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    MainWindowImpl.this.createWindow(uiInitializer);
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(false, "Error Initialize MainWindow", e));
                }
                if (uiInitializer != null) {
                    uiInitializer.abortProgress();
                }
            }
        });
        GlobalManager gm = core.getGlobalManager();
        this.dms_Startup = gm.getDownloadManagers().toArray(new DownloadManager[0]);
        gm.addListener(new GlobalManagerListener(){

            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }

            public void downloadManagerRemoved(DownloadManager dm) {
            }

            public void downloadManagerAdded(DownloadManager dm) {
                MainWindowImpl.this.downloadAdded(new DownloadManager[]{dm});
            }

            public void destroyed() {
            }

            public void destroyInitiated() {
            }
        }, false);
        Alerts.addListener(new Alerts.AlertListener(){

            public boolean allowPopup(Object[] relatedObjects, int configID) {
                DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                if (dm == null) {
                    return true;
                }
                return !dm.getDownloadState().getFlag(16L);
            }
        });
    }

    protected MainWindowImpl(final Display display, final IUIIntializer uiInitializer) {
        this.delayedCore = true;
        this.display = display;
        this.uiInitializer = uiInitializer;
        AEDiagnostics.addEvidenceGenerator(this);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    MainWindowImpl.this.createWindow(uiInitializer);
                }
                catch (Throwable e) {
                    Logger.log(new LogAlert(false, "Error Initialize MainWindow", e));
                }
                while (!display.isDisposed() && display.readAndDispatch()) {
                }
            }
        });
    }

    public void init(final AzureusCore core) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MainWindowImpl.this._init(core);
                if (MainWindowImpl.this.uiInitializer != null) {
                    MainWindowImpl.this.uiInitializer.abortProgress();
                }
            }
        });
        UIUpdaterSWT.getInstance().addUpdater(this);
    }

    private void _init(AzureusCore core) {
        this.core = core;
        this.disposedOrDisposing = false;
        StimulusRPC.hookListeners(core, this);
        if (this.uiSWTInstanceImpl == null) {
            this.uiSWTInstanceImpl = new UISWTInstanceImpl();
            this.uiSWTInstanceImpl.init(this.uiInitializer);
        }
        this.postPluginSetup(core);
        GlobalManager gm = core.getGlobalManager();
        this.dms_Startup = gm.getDownloadManagers().toArray(new DownloadManager[0]);
        gm.addListener(new GlobalManagerListener(){

            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }

            public void downloadManagerRemoved(DownloadManager dm) {
            }

            public void downloadManagerAdded(DownloadManager dm) {
                MainWindowImpl.this.downloadAdded(new DownloadManager[]{dm});
            }

            public void destroyed() {
            }

            public void destroyInitiated() {
            }
        }, false);
        Alerts.addListener(new Alerts.AlertListener(){

            public boolean allowPopup(Object[] relatedObjects, int configID) {
                DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                if (dm == null) {
                    return true;
                }
                return !dm.getDownloadState().getFlag(16L);
            }
        });
        core.triggerLifeCycleComponentCreated(this.uiFunctions);
        this.processStartupDMS();
    }

    private void postPluginSetup(AzureusCore core) {
        if (core == null) {
            return;
        }
        if (!Utils.isAZ2UI()) {
            VuzeActivitiesManager.initialize(core);
        }
        LocProvUtils.initialise(core);
        if (!Constants.isSafeMode) {
            COConfigurationManager.removeParameter("GUI_SWT_share_count_at_close");
            MainHelpers.initTransferBar();
            COConfigurationManager.addAndFireParameterListener("IconBar.enabled", new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    MainWindowImpl.this.setVisible(2, COConfigurationManager.getBooleanParameter(parameterName));
                }
            });
        }
        new ProgressWindow(this.display);
    }

    private void processStartupDMS() {
        AEThread2 thread = new AEThread2("v3.mw.dmAdded", true){

            public void run() {
                long startTime = SystemTime.getCurrentTime();
                if (MainWindowImpl.this.dms_Startup == null || MainWindowImpl.this.dms_Startup.length == 0) {
                    MainWindowImpl.access$402(MainWindowImpl.this, null);
                    return;
                }
                MainWindowImpl.this.downloadAdded(MainWindowImpl.this.dms_Startup);
                MainWindowImpl.access$402(MainWindowImpl.this, null);
                System.out.println("psDMS " + (SystemTime.getCurrentTime() - startTime) + "ms");
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    private void downloadAdded(DownloadManager[] dms) {
        boolean oneIsNotPlatformAndPersistent = false;
        for (final DownloadManager dm : dms) {
            boolean isContent;
            long completedTime;
            String lastVersion;
            if (dm == null) continue;
            DownloadManagerState dmState = dm.getDownloadState();
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null) continue;
            String title = PlatformTorrentUtils.getContentTitle(torrent);
            if (title != null && title.length() > 0 && dmState.getDisplayName() == null) {
                dmState.setDisplayName(title);
            }
            if (ConfigurationChecker.isNewVersion() && dm.getAssumedComplete() && Constants.compareVersions(lastVersion = COConfigurationManager.getStringParameter("Last Version"), "3.1.1.1") <= 0 && (completedTime = dmState.getLongParameter("stats.download.completed.time")) < SystemTime.getOffsetTime(-60000L)) {
                PlatformTorrentUtils.setHasBeenOpened(dm, true);
            }
            boolean bl = isContent = PlatformTorrentUtils.isContent(torrent, true) || PlatformTorrentUtils.getContentNetworkID(torrent) == 3L;
            if (!oneIsNotPlatformAndPersistent && !isContent && !dmState.getFlag(16L) && dm.isPersistent()) {
                oneIsNotPlatformAndPersistent = true;
            }
            if (!isContent) continue;
            long now = SystemTime.getCurrentTime();
            long expiresOn = PlatformTorrentUtils.getExpiresOn(torrent);
            if (expiresOn <= now) continue;
            SimpleTimer.addEvent("dm Expirey", expiresOn, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    dm.getDownloadState().setFlag(16L, true);
                    ManagerUtils.asyncStopDelete(dm, 70, true, true, null);
                }
            });
        }
        if (oneIsNotPlatformAndPersistent && this.dms_Startup == null) {
            DonationWindow.checkForDonationPopup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createWindow(IUIIntializer uiInitializer) {
        String configID2222;
        long startTime;
        block27: {
            startTime = SystemTime.getCurrentTime();
            UIFunctionsSWT existing_uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
            this.uiFunctions = new UIFunctionsImpl(this);
            UIFunctionsManager.setUIFunctions(this.uiFunctions);
            Utils.disposeComposite((Composite)this.shell);
            this.increaseProgress(uiInitializer, "splash.initializeGui");
            System.out.println("UIFunctions/ImageLoad took " + (SystemTime.getCurrentTime() - startTime) + "ms");
            startTime = SystemTime.getCurrentTime();
            Shell shell = this.shell = existing_uif == null ? new Shell(this.display, 1264) : existing_uif.getMainShell();
            if (Constants.isWindows) {
                try {
                    Class<?> ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.win32.Win32UIEnhancer");
                    Method method = ehancerClass.getMethod("initMainShell", Shell.class);
                    method.invoke(null, this.shell);
                }
                catch (Exception e) {
                    Debug.outNoStack(Debug.getCompressedStackTrace(e, 0, 30), true);
                }
            }
            try {
                try {
                    this.shell.setData("class", (Object)this);
                    this.shell.setText(UIFunctions.MAIN_WINDOW_NAME);
                    Utils.setShellIcon(this.shell);
                    Utils.linkShellMetricsToConfig(this.shell, "window");
                    System.out.println("new shell took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    PlatformConfigMessenger.addPlatformLoginCompleteListener(new PlatformConfigMessenger.PlatformLoginCompleteListener(){

                        public void platformLoginComplete() {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    MainWindowImpl.this.setupUsageTracker();
                                }
                            });
                        }
                    });
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    this.skin = SWTSkinFactory.getInstance();
                    if (Utils.isAZ2UI()) {
                        SWTSkinProperties skinProperties = this.skin.getSkinProperties();
                        String skinPath = "com/aelitis/azureus/ui/skin/skin3_classic";
                        ResourceBundle rb = ResourceBundle.getBundle(skinPath);
                        skinProperties.addResourceBundle(rb, skinPath);
                    }
                    this.uiFunctions.setSkin(this.skin);
                    System.out.println("new shell setup took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.initSkinListeners();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    String startID = Utils.isAZ2UI() ? "classic.shell" : "main.shell";
                    this.skin.initialize((Composite)this.shell, startID, uiInitializer);
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("skin init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.menu = Utils.isAZ2UI() ? new org.gudy.azureus2.ui.swt.mainwindow.MainMenu(this.shell) : new MainMenu(this.skin, this.shell);
                    this.shell.setData("MainMenu", (Object)this.menu);
                    System.out.println("MainMenu init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (Constants.isOSX) {
                        block26: {
                            Class<?> ehancerClass;
                            if (Utils.isCarbon) {
                                try {
                                    ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CarbonUIEnhancer");
                                    Method method = ehancerClass.getMethod("registerToolbarToggle", Shell.class);
                                    method.invoke(null, this.shell);
                                }
                                catch (Exception e) {
                                    Debug.printStackTrace(e);
                                }
                            } else if (Utils.isCocoa) {
                                try {
                                    ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CocoaUIEnhancer");
                                    Method mGetInstance = ehancerClass.getMethod("getInstance", new Class[0]);
                                    Object claObj = mGetInstance.invoke(null, new Object[0]);
                                    Method mregTBToggle = claObj.getClass().getMethod("registerToolbarToggle", Shell.class);
                                    if (mregTBToggle != null) {
                                        mregTBToggle.invoke(claObj, this.shell);
                                    }
                                }
                                catch (Throwable e) {
                                    if (Constants.isOSX_10_7_OrHigher) break block26;
                                    Debug.printStackTrace(e);
                                }
                            }
                        }
                        Listener toggleListener = new Listener(){

                            public void handleEvent(Event event2) {
                                SWTSkinObject so = MainWindowImpl.this.skin.getSkinObject("global-toolbar");
                                if (so != null) {
                                    so.setVisible(!so.isVisible());
                                }
                            }
                        };
                        this.shell.addListener(17, toggleListener);
                        this.shell.addListener(18, toggleListener);
                        System.out.println("createWindow init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                        startTime = SystemTime.getCurrentTime();
                    }
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    this.skin.layout();
                    try {
                        Utils.createTorrentDropTarget((Composite)this.shell, false);
                    }
                    catch (Throwable e) {
                        Logger.log(new LogEvent(LOGID, "Drag and Drop not available", e));
                    }
                    this.shell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            MainWindowImpl.this.dispose(false, false);
                        }
                    });
                    this.shell.addShellListener((ShellListener)new ShellAdapter(){

                        public void shellClosed(ShellEvent event2) {
                            if (MainWindowImpl.this.disposedOrDisposing) {
                                return;
                            }
                            if (MainWindowImpl.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray")) {
                                MainWindowImpl.this.minimizeToTray(event2);
                            } else {
                                event2.doit = MainWindowImpl.this.dispose(false, false);
                            }
                        }

                        public void shellActivated(ShellEvent e) {
                            Shell shellAppModal = Utils.findFirstShellWithStyle(65536);
                            if (shellAppModal != null) {
                                shellAppModal.forceActive();
                            } else {
                                MainWindowImpl.this.shell.forceActive();
                            }
                        }

                        public void shellIconified(ShellEvent event2) {
                            if (MainWindowImpl.this.disposedOrDisposing) {
                                return;
                            }
                            if (MainWindowImpl.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Minimize To Tray")) {
                                MainWindowImpl.this.minimizeToTray(event2);
                            }
                        }

                        public void shellDeiconified(ShellEvent e) {
                            if (Constants.isOSX && COConfigurationManager.getBooleanParameter("Password enabled")) {
                                MainWindowImpl.this.shell.setVisible(false);
                                if (PasswordWindow.showPasswordWindow(MainWindowImpl.this.display)) {
                                    MainWindowImpl.this.shell.setVisible(true);
                                }
                            }
                        }
                    });
                    this.display.addFilter(1, new Listener(){

                        public void handleEvent(Event event2) {
                            Control focus_control = MainWindowImpl.this.display.getFocusControl();
                            if (focus_control != null && focus_control.getShell() != MainWindowImpl.this.shell) {
                                return;
                            }
                            int key = event2.character;
                            if ((event2.stateMask & SWT.MOD1) != 0 && event2.character <= '\u001a' && event2.character > '\u0000') {
                                key += 96;
                            }
                            if (key == 108 && (event2.stateMask & SWT.MOD1) != 0) {
                                if (MainWindowImpl.this.core == null) {
                                    return;
                                }
                                GlobalManager gm = MainWindowImpl.this.core.getGlobalManager();
                                if (gm != null) {
                                    UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentWindow();
                                    event2.doit = false;
                                }
                            } else if (key == 102 && (event2.stateMask & SWT.MOD1 + 131072) == SWT.MOD1 + 131072) {
                                MainWindowImpl.this.shell.setFullScreen(!MainWindowImpl.this.shell.getFullScreen());
                            }
                        }
                    });
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("pre skin widgets init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null) {
                        StimulusRPC.hookListeners(this.core, this);
                    }
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    this.initMDI();
                    System.out.println("skin widgets (1/2) init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.initWidgets2();
                    this.increaseProgress(uiInitializer, "v3.splash.initSkin");
                    System.out.println("skin widgets (2/2) init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    System.out.println("pre SWTInstance init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "v3.splash.hookPluginUI");
                    startTime = SystemTime.getCurrentTime();
                    TableColumnCreatorV3.initCoreColumns();
                    System.out.println("Init Core Columns took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "v3.splash.hookPluginUI");
                    startTime = SystemTime.getCurrentTime();
                    this.uiSWTInstanceImpl = new UISWTInstanceImpl();
                    this.uiSWTInstanceImpl.init(uiInitializer);
                    System.out.println("SWTInstance init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    this.increaseProgress(uiInitializer, "splash.initializeGui");
                    startTime = SystemTime.getCurrentTime();
                }
                catch (Throwable t) {
                    Debug.out(t);
                    Object var11_15 = null;
                    String configID2222 = "pluginbar.visible";
                    if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) {
                        COConfigurationManager.setBooleanDefault(configID2222, true);
                    }
                    this.setVisible(4, COConfigurationManager.getBooleanParameter(configID2222) && COConfigurationManager.getIntParameter("User Mode") > 1);
                    this.setVisible(2, COConfigurationManager.getBooleanParameter("IconBar.enabled"));
                    this.shell.layout(true, true);
                    System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.showMainWindow();
                    this.increaseProgress(uiInitializer, "splash.initializeGui");
                    System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    this.processStartupDMS();
                    System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    if (this.core != null) {
                        this.postPluginSetup(this.core);
                    }
                    System.out.println("postPluginSetup init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                    startTime = SystemTime.getCurrentTime();
                    NavigationHelper.addListener(new NavigationHelper.navigationListener(){

                        public void processCommand(final int type, final String[] args) {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (type == 1) {
                                        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                                        if (mdi == null) {
                                            return;
                                        }
                                        mdi.showEntryByID(args[0]);
                                        if (uif != null) {
                                            uif.bringToFront();
                                        }
                                    } else if (type == 2) {
                                        // empty if block
                                    }
                                }
                            });
                        }
                    });
                    if (Constants.isOSX) return;
                    COConfigurationManager.addAndFireParameterListener("Show Status In Window Title", new ParameterListener(){
                        private TimerEventPeriodic timer;
                        private String old_text;
                        private String my_last_text;

                        public void parameterChanged(final String name) {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    boolean enable = COConfigurationManager.getBooleanParameter(name);
                                    if (enable) {
                                        if (timer == null) {
                                            timer = SimpleTimer.addPeriodicEvent("window.title.updater", 1000L, new TimerEventPerformer(){

                                                public void perform(TimerEvent event2) {
                                                    Utils.execSWTThread(new AERunnable(){

                                                        public void runSupport() {
                                                            if (MainWindowImpl.this.shell.isDisposed()) {
                                                                return;
                                                            }
                                                            String txt = MainWindowImpl.this.shell.getText();
                                                            if (txt != null && !txt.equals(my_last_text)) {
                                                                old_text = txt;
                                                            }
                                                            if ((txt = MainWindowImpl.this.getCurrentTitleText()) != null) {
                                                                MainWindowImpl.this.shell.setText(txt);
                                                                my_last_text = txt;
                                                            }
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                    } else {
                                        if (timer != null) {
                                            timer.cancel();
                                            timer = null;
                                        }
                                        if (old_text != null && !MainWindowImpl.this.shell.isDisposed()) {
                                            MainWindowImpl.this.shell.setText(old_text);
                                        }
                                    }
                                }
                            });
                        }
                    });
                    return;
                }
                Object var11_14 = null;
                configID2222 = "pluginbar.visible";
                if (ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) break block27;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                String configID2222 = "pluginbar.visible";
                if (!ConfigurationDefaults.getInstance().doesParameterDefaultExist(configID2222)) {
                    COConfigurationManager.setBooleanDefault(configID2222, true);
                }
                this.setVisible(4, COConfigurationManager.getBooleanParameter(configID2222) && COConfigurationManager.getIntParameter("User Mode") > 1);
                this.setVisible(2, COConfigurationManager.getBooleanParameter("IconBar.enabled"));
                this.shell.layout(true, true);
                System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                this.showMainWindow();
                this.increaseProgress(uiInitializer, "splash.initializeGui");
                System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                this.processStartupDMS();
                System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                if (this.core != null) {
                    this.postPluginSetup(this.core);
                }
                System.out.println("postPluginSetup init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
                startTime = SystemTime.getCurrentTime();
                NavigationHelper.addListener(new /* invalid duplicate definition of identical inner class */);
                if (Constants.isOSX) throw throwable;
                COConfigurationManager.addAndFireParameterListener("Show Status In Window Title", new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            COConfigurationManager.setBooleanDefault(configID2222, true);
        }
        this.setVisible(4, COConfigurationManager.getBooleanParameter(configID2222) && COConfigurationManager.getIntParameter("User Mode") > 1);
        this.setVisible(2, COConfigurationManager.getBooleanParameter("IconBar.enabled"));
        this.shell.layout(true, true);
        System.out.println("shell.layout took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.showMainWindow();
        this.increaseProgress(uiInitializer, "splash.initializeGui");
        System.out.println("shell.open took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.processStartupDMS();
        System.out.println("processStartupDMS took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        if (this.core != null) {
            this.postPluginSetup(this.core);
        }
        System.out.println("postPluginSetup init took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        NavigationHelper.addListener(new /* invalid duplicate definition of identical inner class */);
        if (Constants.isOSX) return;
        COConfigurationManager.addAndFireParameterListener("Show Status In Window Title", new /* invalid duplicate definition of identical inner class */);
    }

    private String getCurrentTitleText() {
        if (this.core == null) {
            return null;
        }
        GlobalManager gm = this.core.getGlobalManager();
        if (gm == null) {
            return null;
        }
        GlobalManagerStats stats2 = gm.getStats();
        int down = stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate();
        int up = stats2.getDataSendRate() + stats2.getProtocolSendRate();
        ++this.eta_tick_count;
        String eta_str = this.last_eta_str;
        if (eta_str == null || this.last_eta < 120L || this.eta_tick_count % 10 == 0) {
            long min_eta = Long.MAX_VALUE;
            int num_downloading = 0;
            List<DownloadManager> dms = gm.getDownloadManagers();
            for (DownloadManager dm : dms) {
                if (dm.getState() != 50) continue;
                ++num_downloading;
                long dm_eta = dm.getStats().getSmoothedETA();
                if (dm_eta >= min_eta) continue;
                min_eta = dm_eta;
            }
            if (min_eta == Long.MAX_VALUE) {
                min_eta = 1827387392L;
            }
            this.last_eta = min_eta;
            this.last_eta_str = num_downloading == 0 ? "" : DisplayFormatters.formatETA(min_eta);
            eta_str = this.last_eta_str;
        }
        String down_str = this.formatRateCompact(down);
        String up_str = this.formatRateCompact(up);
        StringBuilder result = new StringBuilder(50);
        result.append(MessageText.getString("ConfigView.download.abbreviated"));
        result.append(" ");
        result.append(down_str);
        result.append(" ");
        result.append(MessageText.getString("ConfigView.upload.abbreviated"));
        result.append(" ");
        result.append(up_str);
        if (eta_str.length() > 0) {
            result.append(" ");
            result.append(MessageText.getString("ConfigView.eta.abbreviated"));
            result.append(" ");
            result.append(eta_str);
        }
        return result.toString();
    }

    private String formatRateCompact(int rate) {
        String str = DisplayFormatters.formatByteCountToKiBEtc(rate, false, true, 2, 1);
        String[] bits = str.split(" ");
        if (bits.length == 2) {
            String sep = String.valueOf(DisplayFormatters.getDecimalSeparator());
            String num = bits[0];
            String unit = bits[1];
            int num_len = num.length();
            if (num_len < 4) {
                if (!num.contains(sep)) {
                    num = num + sep;
                    ++num_len;
                }
                while (num_len < 4) {
                    num = num + "0";
                    ++num_len;
                }
            } else if (num_len > 4) {
                num = num.substring(0, 4);
                num_len = 4;
            }
            if (num.endsWith(sep)) {
                num = num.substring(0, num_len - 1) + " ";
            }
            str = num + " " + unit.charAt(0);
        }
        return str;
    }

    private void increaseProgress(IUIIntializer uiInitializer, String taskKey) {
        if (uiInitializer != null) {
            uiInitializer.increaseProgress();
            if (taskKey != null) {
                uiInitializer.reportCurrentTask(MessageText.getString(taskKey));
            }
        }
    }

    public boolean dispose(final boolean for_restart, final boolean close_already_in_progress) {
        if (this.disposedOrDisposing) {
            return true;
        }
        Boolean b = Utils.execSWTThreadWithBool("v3.MainWindow.dispose", new AERunnableBoolean(){

            public boolean runSupport() {
                return MainWindowImpl.this._dispose(for_restart, close_already_in_progress);
            }
        });
        return b == null || b != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _dispose(final boolean bForRestart, boolean bCloseAlreadyInProgress) {
        if (this.disposedOrDisposing) {
            return true;
        }
        this.disposedOrDisposing = true;
        if (this.core != null && !UIExitUtilsSWT.canClose(this.core.getGlobalManager(), bForRestart)) {
            this.disposedOrDisposing = false;
            return false;
        }
        this.isReady = false;
        UIExitUtilsSWT.uiShutdown();
        if (this.systemTraySWT != null) {
            this.systemTraySWT.dispose();
        }
        try {
            AllTransfersBar transfer_bar;
            if (this.core != null && (transfer_bar = AllTransfersBar.getBarIfOpen(this.core.getGlobalManager())) != null) {
                transfer_bar.forceSaveLocation();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        mapTrackUsage_mon.enter();
        try {
            if (mapTrackUsage != null) {
                String id = this.getUsageActiveTabID();
                if (id != null) {
                    if (this.lastShellStatus == null) {
                        this.lastShellStatus = id;
                    }
                    this.updateMapTrackUsage(this.lastShellStatus);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("version", "5.6.1.3_B16");
                map.put("statsmap", mapTrackUsage);
                FileUtil.writeResilientFile(new File(SystemProperties.getUserPath(), "timingstats.dat"), map);
            }
            Object var6_6 = null;
            mapTrackUsage_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            mapTrackUsage_mon.exit();
            throw throwable;
        }
        if (!SWTThread.getInstance().isTerminated()) {
            Utils.getOffOfSWTThread(new AERunnable(){

                public void runSupport() {
                    if (!SWTThread.getInstance().isTerminated()) {
                        SWTThread.getInstance().getInitializer().stopIt(bForRestart, false);
                    }
                }
            });
        }
        return true;
    }

    private String getUsageActiveTabID() {
        try {
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null) {
                MdiEntry curEntry = mdi.getCurrentEntry();
                if (curEntry == null) {
                    return "none";
                }
                String id = curEntry.getLogID();
                return id == null ? "null" : id;
            }
        }
        catch (Exception e) {
            String name = e.getClass().getName();
            int i = name.indexOf(46);
            if (i > 0) {
                return name.substring(i);
            }
            return name;
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupUsageTracker() {
        mapTrackUsage_mon.enter();
        try {
            try {
                File f = new File(SystemProperties.getUserPath(), "timingstats.dat");
                if (COConfigurationManager.getBooleanParameter("Send Version Info") && PlatformConfigMessenger.allowSendStats()) {
                    mapTrackUsage = new HashMap<String, List>();
                    if (f.exists()) {
                        Map oldMapTrackUsage = FileUtil.readResilientFile(f);
                        String version = MapUtils.getMapString(oldMapTrackUsage, "version", null);
                        Map map = MapUtils.getMapMap(oldMapTrackUsage, "statsmap", null);
                        if (version != null && map != null) {
                            PlatformConfigMessenger.sendUsageStats(map, f.lastModified(), version, null);
                        }
                    }
                    SimpleTimer.addPeriodicEvent("UsageTracker", 1000L, new TimerEventPerformer(){
                        long lLastMouseMove = SystemTime.getCurrentTime();
                        Point ptLastMousePos = new Point(0, 0);

                        public void perform(TimerEvent event2) {
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    if (MainWindowImpl.this.shell == null || MainWindowImpl.this.shell.isDisposed() || MainWindowImpl.this.shell.getDisplay().getActiveShell() == null) {
                                        if (ptLastMousePos.x > 0) {
                                            ptLastMousePos.x = 0;
                                            ptLastMousePos.y = 0;
                                            lLastMouseMove = 0L;
                                        }
                                        return;
                                    }
                                    Point pt = MainWindowImpl.this.shell.getDisplay().getCursorLocation();
                                    if (pt.equals((Object)ptLastMousePos)) {
                                        return;
                                    }
                                    ptLastMousePos = pt;
                                    long now = SystemTime.getCurrentTime();
                                    if (lLastMouseMove > 0L) {
                                        long diff = now - lLastMouseMove;
                                        if (diff < 10000L) {
                                            MainWindowImpl.this.lCurrentTrackTime += diff;
                                        } else {
                                            MainWindowImpl.this.lCurrentTrackTimeIdle += diff;
                                        }
                                    }
                                    lLastMouseMove = now;
                                }
                            });
                        }
                    });
                    Listener lActivateDeactivate = new Listener(){
                        long start;

                        public void handleEvent(Event event2) {
                            if (event2.type == 26) {
                                MainWindowImpl.this.lCurrentTrackTimeIdle = 0L;
                                if (this.start > 0L && MainWindowImpl.this.lastShellStatus != null) {
                                    MainWindowImpl.this.lCurrentTrackTime = SystemTime.getCurrentTime() - this.start;
                                    MainWindowImpl.this.updateMapTrackUsage(MainWindowImpl.this.lastShellStatus);
                                }
                                MainWindowImpl.this.lastShellStatus = null;
                            } else {
                                MainWindowImpl.this.updateMapTrackUsage(MainWindowImpl.this.getUsageActiveTabID());
                                if (MainWindowImpl.this.shell.getMinimized()) {
                                    MainWindowImpl.this.lastShellStatus = "idle-minimized";
                                } else if (!MainWindowImpl.this.shell.isVisible()) {
                                    MainWindowImpl.this.lastShellStatus = "idle-invisible";
                                } else {
                                    MainWindowImpl.this.lastShellStatus = "idle-nofocus";
                                }
                                this.start = SystemTime.getCurrentTime();
                            }
                        }
                    };
                    this.shell.addListener(26, lActivateDeactivate);
                    this.shell.addListener(27, lActivateDeactivate);
                } else {
                    mapTrackUsage = null;
                    try {
                        if (f.exists()) {
                            f.delete();
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                Object var6_7 = null;
                mapTrackUsage_mon.exit();
            }
            catch (Exception e) {
                Debug.out(e);
                Object var6_8 = null;
                mapTrackUsage_mon.exit();
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            mapTrackUsage_mon.exit();
            throw throwable;
        }
    }

    private void showMainWindow() {
        COConfigurationManager.addAndFireParameterListener("Show Download Basket", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainWindowImpl.this.configureDownloadBasket();
            }
        });
        boolean isOSX = Constants.isOSX;
        boolean bEnableTray = COConfigurationManager.getBooleanParameter("Enable System Tray");
        boolean bPassworded = COConfigurationManager.getBooleanParameter("Password enabled");
        boolean bStartMinimize = bEnableTray && (bPassworded || COConfigurationManager.getBooleanParameter("Start Minimized"));
        SWTSkinObject soMain = this.skin.getSkinObject("main");
        if (soMain != null) {
            soMain.getControl().setVisible(true);
        }
        this.shell.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                System.out.println("---------SHOWN AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
                if (MainWindowImpl.this.statusBar != null) {
                    Utils.execSWTThreadLater(10, new Runnable(){

                        public void run() {
                            MainWindowImpl.this.statusBar.relayout();
                        }
                    });
                }
                ShellManager.sharedManager().performForShells(new Listener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleEvent(Event event2) {
                        Shell this_shell = (Shell)event2.widget;
                        if (this_shell.getParent() == null && !this_shell.isVisible()) {
                            boolean minimize;
                            Set set = MainWindowImpl.this.minimized_on_hide;
                            synchronized (set) {
                                minimize = MainWindowImpl.this.minimized_on_hide.remove(this_shell);
                            }
                            this_shell.setVisible(true);
                            if (minimize) {
                                this_shell.setMinimized(true);
                            } else {
                                this_shell.moveAbove((Control)MainWindowImpl.this.shell);
                            }
                        }
                    }
                });
            }
        });
        if (!bStartMinimize) {
            this.shell.open();
            if (!isOSX) {
                this.shell.forceActive();
            }
        } else if (Utils.isCarbon) {
            this.shell.setVisible(true);
            this.shell.setMinimized(true);
        }
        if (this.delayedCore) {
            try {
                long endSWTDispatchOn = SystemTime.getOffsetTime(5000L);
                while (SystemTime.getCurrentTime() < endSWTDispatchOn && !this.display.isDisposed() && this.display.readAndDispatch()) {
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
            System.out.println("---------DONE DISPATCH AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
            if (this.display.isDisposed()) {
                return;
            }
        }
        if (bEnableTray) {
            try {
                this.systemTraySWT = SystemTraySWT.getTray();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Logger.log(new LogEvent(LOGID, 3, "Upgrade to SWT3.0M8 or later for system tray support."));
            }
            if (bStartMinimize) {
                this.minimizeToTray(null);
            } else if (bPassworded) {
                this.minimizeToTray(null);
                this.setVisible(true);
            }
        }
        if (this.uiInitializer != null) {
            this.uiInitializer.initializationComplete();
        }
        boolean run_speed_test = false;
        if (!Utils.isAZ2UI() && !COConfigurationManager.getBooleanParameter("SpeedTest Completed") && !ConfigurationChecker.isNewInstall() && FeatureAvailability.triggerSpeedTestV1()) {
            long upload_limit = COConfigurationManager.getLongParameter("Max Upload Speed KBs");
            boolean auto_up = COConfigurationManager.getBooleanParameter("Auto Upload Speed Enabled");
            if (auto_up) {
                if (upload_limit <= 18L) {
                    run_speed_test = true;
                }
            } else {
                boolean up_seed_limit = COConfigurationManager.getBooleanParameter("enable.seedingonly.upload.rate");
                if (upload_limit == 0L && !up_seed_limit) {
                    run_speed_test = true;
                }
            }
        }
        if (run_speed_test) {
            SpeedTestSelector.runMLABTest(new AERunnable(){

                public void runSupport() {
                    WelcomeView.setWaitLoadingURL(false);
                }
            });
        } else {
            WelcomeView.setWaitLoadingURL(false);
        }
        if (Utils.isAZ2UI()) {
            if (!COConfigurationManager.getBooleanParameter("Wizard Completed")) {
                CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        new ConfigureWizard(false, 0);
                    }
                });
            }
            this.checkForWhatsNewWindow();
        }
        AssociationChecker.checkAssociations();
        Map map = VersionCheckClient.getSingleton().getMostRecentVersionCheckData();
        DonationWindow.setInitialAskHours(MapUtils.getMapInt(map, "donations.askhrs", DonationWindow.getInitialAskHours()));
        if (this.core != null) {
            this.core.triggerLifeCycleComponentCreated(this.uiFunctions);
        }
        System.out.println("---------READY AT " + SystemTime.getCurrentTime() + ";" + (SystemTime.getCurrentTime() - Initializer.startTime) + "ms");
        this.isReady = true;
    }

    private void configureDownloadBasket() {
        if (COConfigurationManager.getBooleanParameter("Show Download Basket")) {
            if (this.downloadBasket == null) {
                this.downloadBasket = new TrayWindow();
                this.downloadBasket.setVisible(true);
            }
        } else if (this.downloadBasket != null) {
            this.downloadBasket.setVisible(false);
            this.downloadBasket = null;
        }
    }

    private void checkForWhatsNewWindow() {
        String CONFIG_LASTSHOWN = "welcome.version.lastshown";
        try {
            int latestDisplayed;
            String lastShown = "";
            boolean bIsStringParam = true;
            try {
                lastShown = COConfigurationManager.getStringParameter("welcome.version.lastshown", "");
            }
            catch (Exception e) {
                bIsStringParam = false;
            }
            if (lastShown.length() == 0 && (latestDisplayed = COConfigurationManager.getIntParameter("welcome.version.lastshown", 0)) > 0) {
                bIsStringParam = false;
                String s = "" + latestDisplayed;
                for (int i = 0; i < s.length(); ++i) {
                    if (i != 0) {
                        lastShown = lastShown + ".";
                    }
                    lastShown = lastShown + s.charAt(i);
                }
            }
            if (Constants.compareVersions(lastShown, Constants.getBaseVersion()) < 0) {
                new WelcomeWindow(this.shell);
                if (!bIsStringParam) {
                    COConfigurationManager.removeParameter("welcome.version.lastshown");
                }
                COConfigurationManager.setParameter("welcome.version.lastshown", Constants.getBaseVersion());
                COConfigurationManager.save();
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public void setHideAll(final boolean hide) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (hide) {
                    MainWindowImpl.this.setVisible(false, true);
                    if (MainWindowImpl.this.systemTraySWT != null) {
                        MainWindowImpl.this.systemTraySWT.dispose();
                    }
                } else {
                    MainWindowImpl.this.setVisible(true, true);
                    if (COConfigurationManager.getBooleanParameter("Enable System Tray")) {
                        MainWindowImpl.this.systemTraySWT = SystemTraySWT.getTray();
                    }
                }
            }
        });
    }

    private void setVisible(boolean visible) {
        this.setVisible(visible, true);
    }

    public void setVisible(final boolean visible, boolean tryTricks) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int i;
                Shell[] shells;
                boolean currentlyVisible;
                boolean bl = currentlyVisible = MainWindowImpl.this.shell.getVisible() && !MainWindowImpl.this.shell.getMinimized();
                if (visible && !currentlyVisible && COConfigurationManager.getBooleanParameter("Password enabled") && !PasswordWindow.showPasswordWindow(MainWindowImpl.this.display)) {
                    MainWindowImpl.this.shell.setVisible(false);
                    return;
                }
                if (!MainWindowImpl.this.isReady) {
                    return;
                }
                ArrayList<Shell> wasVisibleList = null;
                boolean bHideAndShow = false;
                if (bHideAndShow) {
                    wasVisibleList = new ArrayList<Shell>();
                    try {
                        MainWindowImpl.this.shell.setMinimized(true);
                        shells = MainWindowImpl.this.shell.getDisplay().getShells();
                        for (i = 0; i < shells.length; ++i) {
                            if (!shells[i].isVisible()) continue;
                            wasVisibleList.add(shells[i]);
                            shells[i].setVisible(false);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (visible) {
                    if (MainWindowImpl.this.shell.getMinimized()) {
                        MainWindowImpl.this.shell.setMinimized(false);
                    }
                    if (!currentlyVisible && COConfigurationManager.getBooleanParameter("window.maximized")) {
                        MainWindowImpl.this.shell.setMaximized(true);
                    }
                } else {
                    COConfigurationManager.setParameter("window.maximized", MainWindowImpl.this.shell.getMaximized());
                }
                MainWindowImpl.this.shell.setVisible(visible);
                if (visible) {
                    MainWindowImpl.this.shell.forceActive();
                    if (bHideAndShow) {
                        try {
                            shells = MainWindowImpl.this.shell.getDisplay().getShells();
                            for (i = 0; i < shells.length; ++i) {
                                if (shells[i] == MainWindowImpl.this.shell) continue;
                                if (wasVisibleList != null && wasVisibleList.contains(shells[i])) {
                                    shells[i].setVisible(visible);
                                }
                                shells[i].setFocus();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    private void minimizeToTray(ShellEvent event2) {
        if (event2 != null) {
            event2.doit = false;
        }
        COConfigurationManager.setParameter("window.maximized", this.shell.getMaximized());
        this.shell.setVisible(false);
        ShellManager.sharedManager().performForShells(new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event2) {
                final Shell shell = (Shell)event2.widget;
                if (shell.getParent() == null) {
                    if (shell.getMinimized()) {
                        Set set = MainWindowImpl.this.minimized_on_hide;
                        synchronized (set) {
                            MainWindowImpl.this.minimized_on_hide.add(shell);
                            shell.addDisposeListener(new DisposeListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void widgetDisposed(DisposeEvent e) {
                                    Set set = MainWindowImpl.this.minimized_on_hide;
                                    synchronized (set) {
                                        MainWindowImpl.this.minimized_on_hide.remove(shell);
                                    }
                                }
                            });
                        }
                    }
                    shell.setVisible(false);
                }
            }
        });
        MiniBarManager.getManager().setAllVisible(true);
    }

    private void initSkinListeners() {
        UISkinnableManagerSWT skinnableManagerSWT = UISkinnableManagerSWT.getInstance();
        skinnableManagerSWT.addSkinnableListener(MessageBoxShell.class.toString(), new UISkinnableSWTListener(){

            public void skinBeforeComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
                byte[] contentThumbnail;
                MessageBoxShell shell = (MessageBoxShell)skinnableObject;
                TOTorrent torrent = null;
                DownloadManager dm = (DownloadManager)LogRelationUtils.queryForClass(relatedObjects, DownloadManager.class);
                torrent = dm != null ? dm.getTorrent() : (TOTorrent)LogRelationUtils.queryForClass(relatedObjects, TOTorrent.class);
                if (torrent != null && shell.getLeftImage() == null && (contentThumbnail = PlatformTorrentUtils.getContentThumbnail(torrent)) != null) {
                    try {
                        ByteArrayInputStream bis = new ByteArrayInputStream(contentThumbnail);
                        final Image img = new Image((Device)Display.getDefault(), (InputStream)bis);
                        shell.setLeftImage(img);
                        composite.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (!img.isDisposed()) {
                                    img.dispose();
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }

            public void skinAfterComponents(Composite composite, Object skinnableObject, Object[] relatedObjects) {
            }
        });
    }

    private void initMDI() {
        Class classMDI = Utils.isAZ2UI() ? TabbedMDI.class : SideBar.class;
        try {
            SWTSkinObject skinObject = this.skin.getSkinObject("mdi");
            if (null != skinObject) {
                BaseMDI mdi = (BaseMDI)classMDI.newInstance();
                mdi.setMainSkinObject(skinObject);
                skinObject.addListener(mdi);
                MainMDISetup.setupSideBar(mdi, this);
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
    }

    private void initWidgets2() {
        SWTSkinObject skinObject = this.skin.getSkinObject("statusbar");
        if (skinObject != null) {
            Composite cArea = (Composite)skinObject.getControl();
            this.statusBar = new MainStatusBar();
            Composite composite = this.statusBar.initStatusBar(cArea);
            composite.setLayoutData((Object)Utils.getFilledFormData());
        }
        if ((skinObject = this.skin.getSkinObject("search-text")) != null) {
            this.attachSearchBox(skinObject);
        }
        if ((skinObject = this.skin.getSkinObject("add-torrent")) instanceof SWTSkinObjectButton) {
            SWTSkinObjectButton btn = (SWTSkinObjectButton)skinObject;
            btn.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentWindow();
                }
            });
        }
        if ((skinObject = this.skin.getSkinObject("pluginbar")) != null) {
            Menu topbarMenu = new Menu((Decorations)this.shell, 8);
            if (COConfigurationManager.getIntParameter("User Mode") > 1) {
                MenuItem mi = MainMenu.createViewMenuItem(this.skin, topbarMenu, "v3.MainWindow.menu.view.pluginbar", "pluginbar.visible", "pluginbar", true, -1);
                if (Utils.isAZ2UI()) {
                    String str = mi.getText();
                    int pos = str.indexOf("\t");
                    if (pos != -1) {
                        str = str.substring(0, pos).trim();
                        mi.setText(str);
                    }
                    mi.setAccelerator(0);
                }
            }
            new MenuItem(topbarMenu, 2);
            final MenuItem itemClipMon = new MenuItem(topbarMenu, 32);
            Messages.setLanguageText((Widget)itemClipMon, "label.monitor.clipboard");
            itemClipMon.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    COConfigurationManager.setParameter("Monitor Clipboard For Torrents", itemClipMon.getSelection());
                }
            });
            boolean enabled = COConfigurationManager.getBooleanParameter("Monitor Clipboard For Torrents");
            itemClipMon.setSelection(enabled);
            COConfigurationManager.addAndFireParameterListener("Monitor Clipboard For Torrents", new ParameterListener(){
                private volatile AEThread2 monitor_thread;
                private Clipboard clipboard;
                private String last_text;

                public void parameterChanged(String parameterName) {
                    boolean enabled = COConfigurationManager.getBooleanParameter(parameterName);
                    if (enabled) {
                        if (this.clipboard == null) {
                            this.clipboard = new Clipboard(Display.getDefault());
                        }
                        if (this.monitor_thread == null) {
                            final AEThread2[] new_thread = new AEThread2[]{null};
                            this.monitor_thread = new_thread[0] = new AEThread2("Clipboard Monitor"){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public void run() {
                                    Object var4_3;
                                    Runnable checker = new Runnable(){

                                        public void run() {
                                            if (monitor_thread != new_thread[0] || clipboard == null) {
                                                return;
                                            }
                                            String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                                            if (!(text == null || text.length() > 2048 || last_text != null && last_text.equals(text))) {
                                                last_text = text;
                                                MainWindowImpl.this.addTorrentsFromClipboard(text);
                                            }
                                        }
                                    };
                                    try {
                                        while (true) {
                                            try {
                                                Utils.execSWTThread(checker);
                                            }
                                            catch (Throwable e) {
                                                Debug.out(e);
                                                var4_3 = null;
                                                if (monitor_thread != new_thread[0]) {
                                                    return;
                                                }
                                                try {}
                                                catch (Throwable e2) {
                                                    Debug.out(e2);
                                                    return;
                                                }
                                                Thread.sleep(500L);
                                                continue;
                                            }
                                            var4_3 = null;
                                            if (monitor_thread != new_thread[0]) {
                                                return;
                                            }
                                            try {
                                                Thread.sleep(500L);
                                            }
                                            catch (Throwable e2) {
                                                Debug.out(e2);
                                                return;
                                            }
                                            break;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var4_3 = null;
                                        if (monitor_thread != new_thread[0]) {
                                            return;
                                        }
                                        try {}
                                        catch (Throwable e2) {
                                            Debug.out(e2);
                                            return;
                                        }
                                        Thread.sleep(500L);
                                        throw throwable;
                                    }
                                }
                            };
                            this.monitor_thread.start();
                        }
                    } else {
                        this.monitor_thread = null;
                        this.last_text = null;
                        if (this.clipboard != null) {
                            this.clipboard.dispose();
                            this.clipboard = null;
                        }
                    }
                }
            });
            new MenuItem(topbarMenu, 2);
            MenuItem itemExport = new MenuItem(topbarMenu, 8);
            Messages.setLanguageText((Widget)itemExport, "search.export.all");
            itemExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final Shell shell = Utils.findAnyShell();
                    shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            FileDialog dialog = new FileDialog(shell, 139264);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                            dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                            dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                            String path = TorrentOpener.setFilterPathData(dialog.open());
                            if (path != null) {
                                String lc = path.toLowerCase();
                                if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                                    path = path + ".vuze";
                                }
                                try {
                                    MetaSearchManagerFactory.getSingleton().getMetaSearch().exportEngines(new File(path));
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            });
            this.addMenuAndNonTextChildren((Composite)skinObject.getControl(), topbarMenu);
            skinObject = this.skin.getSkinObject("global-toolbar");
            if (skinObject != null) {
                this.addMenuAndNonTextChildren((Composite)skinObject.getControl(), topbarMenu);
            }
        }
    }

    private void addMenuAndNonTextChildren(Composite parent, Menu menu) {
        parent.setMenu(menu);
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (control instanceof Composite) {
                Composite c = (Composite)control;
                this.addMenuAndNonTextChildren(c, menu);
                continue;
            }
            if (control instanceof Text) continue;
            control.setMenu(menu);
        }
    }

    private void addTorrentsFromClipboard(String text) {
        int i;
        String[] splitters = new String[]{"\r\n", "\n", "\r", "\t"};
        String[] lines = null;
        for (i = 0; i < splitters.length; ++i) {
            if (text.indexOf(splitters[i]) < 0) continue;
            lines = text.split(splitters[i]);
            break;
        }
        if (lines == null) {
            lines = new String[]{text};
        }
        for (i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.startsWith("\"") && line.endsWith("\"")) {
                line = line.length() < 3 ? "" : line.substring(1, line.length() - 2);
            }
            if (!UrlUtils.isURL(line)) continue;
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("hideErrors", true);
            TorrentOpener.openTorrent(line, options);
        }
    }

    private void attachSearchBox(SWTSkinObject skinObject) {
        SWTSkinObject so;
        Composite cArea = (Composite)skinObject.getControl();
        final Text text = new Text(cArea, 0);
        text.setMessage(MessageText.getString("v3.MainWindow.search.defaultText"));
        FormData filledFormData = Utils.getFilledFormData();
        text.setLayoutData((Object)filledFormData);
        text.setData("ObfusticateImage", (Object)new ObfusticateImage(){

            public Image obfusticatedImage(Image image) {
                Point location = Utils.getLocationRelativeToShell((Control)text);
                Point size = text.getSize();
                UIDebugGenerator.obfusticateArea(image, new Rectangle(location.x, location.y, size.x, size.y));
                return image;
            }
        });
        text.addListener(11, new Listener(){
            Font lastFont = null;
            int lastHeight = -1;

            public void handleEvent(Event event2) {
                Text text = (Text)event2.widget;
                int h = text.getClientArea().height - 2;
                if (h == this.lastHeight) {
                    return;
                }
                this.lastHeight = h;
                Font font = FontUtils.getFontWithHeight(text.getFont(), null, h);
                if (font != null) {
                    text.setFont(font);
                    if (this.lastFont == null) {
                        text.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                Text text = (Text)e.widget;
                                text.setFont(null);
                                Utils.disposeSWTObjects(new Object[]{lastFont});
                            }
                        });
                    } else {
                        Utils.disposeSWTObjects(new Object[]{this.lastFont});
                    }
                    this.lastFont = font;
                }
            }
        });
        text.setTextLimit(2048);
        if (Constants.isWindows) {
            text.addListener(3, new Listener(){

                public void handleEvent(Event event2) {
                    if (event2.count == 3) {
                        text.selectAll();
                    }
                }
            });
        }
        String tooltip = MessageText.getString("v3.MainWindow.search.tooltip");
        text.setToolTipText(tooltip);
        SWTSkinProperties properties = skinObject.getProperties();
        this.colorSearchTextBG = properties.getColor("color.search.text.bg");
        this.colorSearchTextFG = properties.getColor("color.search.text.fg");
        if (this.colorSearchTextBG != null) {
            text.setBackground(this.colorSearchTextBG);
        }
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == SWT.MOD1) {
                    int key = e.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (key == 97) {
                        text.selectAll();
                    }
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        text.addListener(1, new Listener(){

            public void handleEvent(Event event2) {
                Text text = (Text)event2.widget;
                if (event2.keyCode == 27) {
                    text.setText("");
                    return;
                }
                if (event2.character == '\r') {
                    MainWindowImpl.this.uiFunctions.doSearch(text.getText());
                }
            }
        });
        SWTSkinObject searchGo = this.skin.getSkinObject("search-go");
        if (searchGo != null) {
            SWTSkinButtonUtility btnGo = new SWTSkinButtonUtility(searchGo);
            btnGo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    String sSearchText = text.getText().trim();
                    MainWindowImpl.this.uiFunctions.doSearch(sSearchText);
                }
            });
        }
        if ((so = this.skin.getSkinObject("search-dropdown")) != null) {
            SWTSkinButtonUtility btnSearchDD = new SWTSkinButtonUtility(so);
            btnSearchDD.setTooltipID("v3.MainWindow.search.tooltip");
            btnSearchDD.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    String sSearchText = text.getText().trim();
                    MainWindowImpl.this.uiFunctions.doSearch(sSearchText);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMapTrackUsage(String sTabID) {
        if (mapTrackUsage != null) {
            mapTrackUsage_mon.enter();
            try {
                if (this.lCurrentTrackTime > 1000L) {
                    MainWindowImpl.addUsageStat(sTabID, this.lCurrentTrackTime);
                }
                if (this.lCurrentTrackTimeIdle > 1000L) {
                    String id = "idle-" + sTabID;
                    MainWindowImpl.addUsageStat(id, this.lCurrentTrackTimeIdle);
                }
                Object var4_3 = null;
                mapTrackUsage_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                mapTrackUsage_mon.exit();
                throw throwable;
            }
        }
        this.lCurrentTrackTime = 0L;
        this.lCurrentTrackTimeIdle = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addUsageStat(String id, long value) {
        if (id == null) {
            return;
        }
        if (id.length() > 150) {
            id = id.substring(0, 150);
        }
        if (mapTrackUsage != null) {
            mapTrackUsage_mon.enter();
            try {
                ArrayList<Number> currentLength = mapTrackUsage.get(id);
                if (currentLength == null) {
                    currentLength = new ArrayList<Number>();
                    currentLength.add(1);
                    currentLength.add(value / 100L);
                } else {
                    ArrayList<Number> oldList = currentLength;
                    currentLength = new ArrayList();
                    currentLength.add(((Number)oldList.get(0)).longValue() + 1L);
                    currentLength.add(((Number)oldList.get(1)).longValue() + value / 1000L);
                }
                mapTrackUsage.put(id, currentLength);
                Object var6_4 = null;
                mapTrackUsage_mon.exit();
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                mapTrackUsage_mon.exit();
                throw throwable;
            }
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public UISWTInstanceImpl getUISWTInstanceImpl() {
        return this.uiSWTInstanceImpl;
    }

    public MainStatusBar getMainStatusBar() {
        return this.statusBar;
    }

    public boolean isVisible(int windowElement) {
        if (windowElement == 2) {
            SWTSkinObject skinObject = this.skin.getSkinObject("global-toolbar");
            if (skinObject != null) {
                return skinObject.isVisible();
            }
        } else if (windowElement == 4) {
            SWTSkinObject skinObject = this.skin.getSkinObject("pluginbar");
            if (skinObject != null) {
                return skinObject.isVisible();
            }
        } else if (windowElement == 3 || windowElement == 1) {
            // empty if block
        }
        return false;
    }

    public void setVisible(int windowElement, boolean value) {
        if (windowElement == 2) {
            SWTSkinUtils.setVisibility(this.skin, "IconBar.enabled", "global-toolbar", value, true, true);
        } else if (windowElement == 4) {
            SWTSkinUtils.setVisibility(this.skin, "pluginbar.visible", "pluginbar", value, true, true);
        } else if (windowElement == 3 || windowElement == 1) {
            // empty if block
        }
    }

    public Rectangle getMetrics(int windowElement) {
        if (windowElement != 2) {
            if (windowElement == 4) {
                SWTSkinObject skinObject = this.skin.getSkinObject("pluginbar");
                if (skinObject != null) {
                    return skinObject.getControl().getBounds();
                }
            } else {
                if (windowElement == 3) {
                    return this.statusBar.getBounds();
                }
                if (windowElement == 6) {
                    return this.shell.getClientArea();
                }
                if (windowElement == 7) {
                    Rectangle r = this.getMetrics(6);
                    r.height -= this.getMetrics((int)4).height;
                    r.height -= this.getMetrics((int)2).height;
                    r.height -= this.getMetrics((int)3).height;
                    return r;
                }
            }
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private SWTSkin getSkin() {
        return this.skin;
    }

    public boolean isReady() {
        return this.isReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image generateObfusticatedImage() {
        Rectangle shellBounds = this.shell.getBounds();
        Rectangle shellClientArea = this.shell.getClientArea();
        Image fullImage = new Image((Device)this.display, shellBounds.width, shellBounds.height);
        Image subImage = new Image((Device)this.display, shellClientArea.width, shellClientArea.height);
        GC gc = new GC((Drawable)this.display);
        try {
            gc.copyArea(fullImage, shellBounds.x, shellBounds.y);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        GC gcShell = new GC((Drawable)this.shell);
        try {
            gcShell.copyArea(subImage, 0, 0);
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            gcShell.dispose();
            throw throwable;
        }
        gcShell.dispose();
        GC gcFullImage = new GC((Drawable)fullImage);
        try {
            Point location = this.shell.toDisplay(0, 0);
            gcFullImage.drawImage(subImage, location.x - shellBounds.x, location.y - shellBounds.y);
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            gcFullImage.dispose();
            throw throwable;
        }
        gcFullImage.dispose();
        subImage.dispose();
        Control[] children = this.shell.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            SWTSkinObject so = (SWTSkinObject)control.getData("SkinObject");
            if (!(so instanceof ObfusticateImage)) continue;
            ObfusticateImage oi = (ObfusticateImage)((Object)so);
            oi.obfusticatedImage(fullImage);
        }
        return fullImage;
    }

    public void mdiEntrySelected(MdiEntry newEntry, MdiEntry oldEntry) {
        if (newEntry == null) {
            return;
        }
        if (mapTrackUsage != null && oldEntry != null) {
            oldEntry.removeListener(this);
            String id2 = null;
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null) {
                id2 = oldEntry.getLogID();
            }
            if (id2 == null) {
                id2 = oldEntry.getId();
            }
            this.updateMapTrackUsage(id2);
        }
        if (mapTrackUsage != null) {
            newEntry.addListener(this);
        }
    }

    public void mdiEntryLogIdChanged(MdiEntry sideBarEntrySWT, String oldID, String newID) {
        if (oldID == null) {
            oldID = "null";
        }
        this.updateMapTrackUsage(oldID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("SWT UI");
        try {
            writer.indent();
            TableColumnManager.getInstance().generateDiagnostics(writer);
            Object var3_2 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            throw throwable;
        }
    }

    public void setSelectedLanguageItem() {
        Messages.updateLanguageForControl((Widget)this.shell);
        if (this.systemTraySWT != null) {
            this.systemTraySWT.updateLanguage();
        }
        if (this.statusBar != null) {
            this.statusBar.refreshStatusText();
        }
        this.skin.triggerLanguageChange();
        if (this.statusBar != null) {
            this.statusBar.updateStatusText();
        }
        if (this.menu != null) {
            MenuFactory.updateMenuText(this.menu.getMenu("menu.bar"));
        }
    }

    public IMainMenu getMainMenu() {
        return this.menu;
    }

    public void updateUI() {
    }

    public String getUpdateUIName() {
        return "MainWindow";
    }

    static /* synthetic */ DownloadManager[] access$402(MainWindowImpl x0, DownloadManager[] x1) {
        x0.dms_Startup = x1;
        return x1;
    }
}

