/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectButton;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinButtonUtility {
    ArrayList<ButtonListenerAdapter> listeners = new ArrayList();
    private final SWTSkinObject skinObject;
    private final String imageViewID;
    private boolean inSetDisabled = false;
    private boolean lastDisabledState = false;

    public SWTSkinButtonUtility(SWTSkinObject skinObject) {
        this(skinObject, null);
    }

    public SWTSkinButtonUtility(SWTSkinObject skinObject, String imageViewID) {
        this.skinObject = skinObject;
        this.imageViewID = imageViewID;
        if (skinObject == null) {
            Debug.out("Can't make button out of null skinObject");
            return;
        }
        if (skinObject.getControl() == null) {
            Debug.out("Can't make button out of null skinObject control");
            return;
        }
        if (skinObject instanceof SWTSkinObjectButton) {
            return;
        }
        Listener l = new Listener(){
            boolean bDownPressed;
            private TimerEvent timerEvent;

            public void handleEvent(Event event2) {
                if (event2.type == 3) {
                    if (this.timerEvent == null) {
                        this.timerEvent = SimpleTimer.addEvent("MouseHold", SystemTime.getOffsetTime(1000L), new TimerEventPerformer(){

                            public void perform(TimerEvent event2) {
                                timerEvent = null;
                                if (!bDownPressed) {
                                    return;
                                }
                                bDownPressed = false;
                                boolean stillPressed = true;
                                for (ButtonListenerAdapter l : SWTSkinButtonUtility.this.listeners) {
                                    stillPressed &= !l.held(SWTSkinButtonUtility.this);
                                }
                                bDownPressed = stillPressed;
                            }
                        });
                    }
                    this.bDownPressed = true;
                    return;
                }
                if (this.timerEvent != null) {
                    this.timerEvent.cancel();
                    this.timerEvent = null;
                }
                if (!this.bDownPressed) {
                    return;
                }
                this.bDownPressed = false;
                if (SWTSkinButtonUtility.this.isDisabled()) {
                    return;
                }
                for (ButtonListenerAdapter l : SWTSkinButtonUtility.this.listeners) {
                    l.pressed(SWTSkinButtonUtility.this, SWTSkinButtonUtility.this.skinObject, event2.stateMask);
                }
            }
        };
        if (skinObject instanceof SWTSkinObjectContainer) {
            Utils.addListenerAndChildren((Composite)skinObject.getControl(), 4, l);
            Utils.addListenerAndChildren((Composite)skinObject.getControl(), 3, l);
        } else {
            skinObject.getControl().addListener(4, l);
            skinObject.getControl().addListener(3, l);
        }
    }

    public boolean isDisabled() {
        return this.skinObject == null ? true : this.skinObject.getSuffix().indexOf("-disabled") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabled(boolean disabled) {
        if (this.inSetDisabled || this.skinObject == null) {
            return;
        }
        this.inSetDisabled = true;
        try {
            if (disabled == this.isDisabled()) {
                Object var6_2 = null;
                this.inSetDisabled = false;
                return;
            }
            if (this.skinObject instanceof SWTSkinObjectButton) {
                this.lastDisabledState = disabled;
                Utils.execSWTThreadLater(100, new AERunnable(){

                    public void runSupport() {
                        ((SWTSkinObjectButton)SWTSkinButtonUtility.this.skinObject).getButton().setEnabled(!SWTSkinButtonUtility.this.lastDisabledState);
                    }
                });
            }
            String suffix = disabled ? "-disabled" : "";
            this.skinObject.switchSuffix(suffix, 1, false);
            for (ButtonListenerAdapter l : this.listeners) {
                l.disabledStateChanged(this, disabled);
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.inSetDisabled = false;
            throw throwable;
        }
        Object var6_3 = null;
        this.inSetDisabled = false;
    }

    public void addSelectionListener(ButtonListenerAdapter listener) {
        if (this.skinObject instanceof SWTSkinObjectButton) {
            ((SWTSkinObjectButton)this.skinObject).addSelectionListener(listener);
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public SWTSkinObject getSkinObject() {
        return this.skinObject;
    }

    public void setTextID(final String id) {
        if (this.skinObject == null) {
            return;
        }
        if (this.skinObject instanceof SWTSkinObjectButton) {
            ((SWTSkinObjectButton)this.skinObject).setText(MessageText.getString(id));
            return;
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SWTSkinObject[] children;
                if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectText) {
                    SWTSkinObjectText skinTextObject = (SWTSkinObjectText)SWTSkinButtonUtility.this.skinObject;
                    skinTextObject.setTextID(id);
                } else if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectContainer && (children = ((SWTSkinObjectContainer)SWTSkinButtonUtility.this.skinObject).getChildren()).length > 0 && children[0] instanceof SWTSkinObjectText) {
                    SWTSkinObjectText skinTextObject = (SWTSkinObjectText)children[0];
                    skinTextObject.setTextID(id);
                }
                Utils.relayout(SWTSkinButtonUtility.this.skinObject.getControl());
            }
        });
    }

    public void setImage(final String id) {
        if (this.skinObject == null) {
            return;
        }
        if (this.skinObject instanceof SWTSkinObjectButton) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinObject[] children;
                SWTSkinObject skinImageObject;
                if (SWTSkinButtonUtility.this.imageViewID != null && (skinImageObject = SWTSkinButtonUtility.this.skinObject.getSkin().getSkinObject(SWTSkinButtonUtility.this.imageViewID, SWTSkinButtonUtility.this.skinObject)) instanceof SWTSkinObjectImage) {
                    ((SWTSkinObjectImage)skinImageObject).setImageByID(id, null);
                    return;
                }
                if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectImage) {
                    skinImageObject = (SWTSkinObjectImage)SWTSkinButtonUtility.this.skinObject;
                    ((SWTSkinObjectImage)skinImageObject).setImageByID(id, null);
                } else if (SWTSkinButtonUtility.this.skinObject instanceof SWTSkinObjectContainer && (children = ((SWTSkinObjectContainer)SWTSkinButtonUtility.this.skinObject).getChildren()).length > 0 && children[0] instanceof SWTSkinObjectImage) {
                    SWTSkinObjectImage skinImageObject2 = (SWTSkinObjectImage)children[0];
                    skinImageObject2.setImageByID(id, null);
                }
            }
        });
    }

    public void setTooltipID(String id) {
        SWTSkinObject[] children;
        if (this.skinObject == null) {
            return;
        }
        if (this.skinObject instanceof SWTSkinObjectButton) {
            return;
        }
        if (this.skinObject instanceof SWTSkinObjectImage) {
            SWTSkinObjectImage skinImageObject = (SWTSkinObjectImage)this.skinObject;
            skinImageObject.setTooltipID(id);
        } else if (this.skinObject instanceof SWTSkinObjectContainer && (children = ((SWTSkinObjectContainer)this.skinObject).getChildren()).length > 0 && children[0] instanceof SWTSkinObjectImage) {
            SWTSkinObjectImage skinImageObject = (SWTSkinObjectImage)children[0];
            skinImageObject.setTooltipID(id);
        }
    }

    public static class ButtonListenerAdapter {
        public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
        }

        public boolean held(SWTSkinButtonUtility buttonUtility) {
            return false;
        }

        public void disabledStateChanged(SWTSkinButtonUtility buttonUtility, boolean disabled) {
        }
    }
}

