/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.utils;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectCheckbox;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.StandardButtonsArea;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;

public class TagUIUtilsV3 {
    public static void showCreateTagDialog(final UIFunctions.TagReturner tagReturner) {
        final SkinnedDialog dialog = new SkinnedDialog("skin3_dlg_addtag", "shell", 2144);
        SWTSkin skin = dialog.getSkin();
        final SWTSkinObjectTextbox tb = (SWTSkinObjectTextbox)skin.getSkinObject("tag-name");
        final SWTSkinObjectCheckbox cb = (SWTSkinObjectCheckbox)skin.getSkinObject("tag-share");
        if (tb == null || cb == null) {
            return;
        }
        cb.setChecked(COConfigurationManager.getBooleanParameter("tag.sharing.default.checked"));
        SWTSkinObject soButtonArea = skin.getSkinObject("bottom-area");
        if (soButtonArea instanceof SWTSkinObjectContainer) {
            StandardButtonsArea buttonsArea = new StandardButtonsArea(){

                protected void clicked(int buttonValue) {
                    if (buttonValue == 32) {
                        String tag_name = tb.getText().trim();
                        TagType tt = TagManagerFactory.getTagManager().getTagType(3);
                        Tag tag = tt.getTag(tag_name, true);
                        if (tag == null) {
                            try {
                                tag = tt.createTag(tag_name, true);
                                tag.setPublic(cb.isChecked());
                            }
                            catch (TagException e) {
                                Debug.out(e);
                            }
                        }
                        if (tagReturner != null && tag != null) {
                            tagReturner.returnedTags(new Tag[]{tag});
                        }
                    }
                    dialog.close();
                }
            };
            buttonsArea.setButtonIDs(new String[]{MessageText.getString("Button.add"), MessageText.getString("Button.cancel")});
            buttonsArea.setButtonVals(new Integer[]{32, 256});
            buttonsArea.swt_createButtons(((SWTSkinObjectContainer)soButtonArea).getComposite());
        }
        dialog.open();
    }
}

