/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.util.RegExUtil;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableColumnCoreCreationListener;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.common.table.TableViewFilterCheck;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.columns.archivedls.ColumnArchiveDLDate;
import com.aelitis.azureus.ui.swt.columns.archivedls.ColumnArchiveDLFileCount;
import com.aelitis.azureus.ui.swt.columns.archivedls.ColumnArchiveDLName;
import com.aelitis.azureus.ui.swt.columns.archivedls.ColumnArchiveDLSize;
import com.aelitis.azureus.ui.swt.columns.archivedls.ColumnArchiveDLTags;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.views.skin.InfoBarUtil;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.download.DownloadStubEvent;
import org.gudy.azureus2.plugins.download.DownloadStubListener;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.views.ArchivedFilesView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_ArchivedDownloadsView
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
TableViewFilterCheck<DownloadStub>,
TableViewSWTMenuFillListener,
TableSelectionListener,
DownloadStubListener {
    private static final String TABLE_NAME = "ArchivedDownloads";
    TableViewSWT<DownloadStub> tv;
    private Text txtFilter;
    private Composite table_parent;
    private boolean columnsAdded = false;
    private boolean dm_listener_added;
    private boolean registeredCoreSubViews;
    private Object datasource;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.initColumns();
        new InfoBarUtil(skinObject, "archivedlsview.infobar", false, "archivedls.infobar", "archivedls.view.infobar"){

            public boolean allowShow() {
                return true;
            }
        };
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initColumns() {
        Class<SBC_ArchivedDownloadsView> clazz = SBC_ArchivedDownloadsView.class;
        synchronized (SBC_ArchivedDownloadsView.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TableColumnManager tableManager = TableColumnManager.getInstance();
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLName.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLName(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLSize.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLSize(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLFileCount.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLFileCount(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLDate.COLUMN_ID, new TableColumnCoreCreationListener(){

                @Override
                public TableColumnCore createTableColumnCore(Class<?> forDataSourceType, String tableID, String columnID) {
                    return new ColumnDateSizer(DownloadStub.class, columnID, TableColumnCreator.DATE_COLUMN_WIDTH, tableID){};
                }

                @Override
                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLDate(column);
                }
            });
            tableManager.registerColumn(DownloadStub.class, ColumnArchiveDLTags.COLUMN_ID, new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnArchiveDLTags(column);
                }
            });
            tableManager.setDefaultColumnNames(TABLE_NAME, new String[]{ColumnArchiveDLName.COLUMN_ID, ColumnArchiveDLSize.COLUMN_ID, ColumnArchiveDLFileCount.COLUMN_ID, ColumnArchiveDLDate.COLUMN_ID});
            tableManager.setDefaultSortColumnName(TABLE_NAME, ColumnArchiveDLName.COLUMN_ID);
            return;
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        if (this.tv != null) {
            this.tv.delete();
            this.tv = null;
        }
        Utils.disposeSWTObjects(new Object[]{this.table_parent});
        if (this.dm_listener_added) {
            PluginInitializer.getDefaultInterface().getDownloadManager().removeDownloadStubListener(this);
            this.dm_listener_added = false;
        }
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        SWTSkinObject so_list;
        super.skinObjectShown(skinObject, params);
        SWTSkinObjectTextbox soFilter = (SWTSkinObjectTextbox)this.getSkinObject("filterbox");
        if (soFilter != null) {
            this.txtFilter = soFilter.getTextControl();
        }
        if ((so_list = this.getSkinObject("archived-dls-list")) == null) {
            System.out.println("NO archived-dls-list");
            return null;
        }
        this.initTable((Composite)so_list.getControl());
        if (this.tv == null) {
            return null;
        }
        PluginInitializer.getDefaultInterface().getDownloadManager().addDownloadStubListener(this, true);
        this.dm_listener_added = true;
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.dm_listener_added) {
            PluginInitializer.getDefaultInterface().getDownloadManager().removeDownloadStubListener(this);
            this.dm_listener_added = false;
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    private void initTable(Composite control) {
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            UISWTInstance pluginUI = uiFunctions.getUISWTInstance();
            this.registerPluginViews(pluginUI);
        }
        if (this.tv == null) {
            this.tv = TableViewFactory.createTableViewSWT(DownloadStub.class, TABLE_NAME, TABLE_NAME, new TableColumnCore[0], ColumnArchiveDLName.COLUMN_ID, 0x10010002);
            if (this.txtFilter != null) {
                this.tv.enableFilterCheck(this.txtFilter, this);
            }
            this.tv.setRowDefaultHeight(16);
            this.tv.setEnableTabViews(true, true, null);
            this.table_parent = new Composite(control, 2048);
            this.table_parent.setLayoutData((Object)Utils.getFilledFormData());
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.table_parent.setLayout((Layout)layout);
            this.tv.addMenuFillListener(this);
            this.tv.addSelectionListener(this, false);
            this.tv.initialize(this.table_parent);
            this.tv.addCountChangeListener(new TableCountChangeListener(){

                public void rowRemoved(TableRowCore row) {
                }

                public void rowAdded(TableRowCore row) {
                    if (SBC_ArchivedDownloadsView.this.datasource == row.getDataSource()) {
                        SBC_ArchivedDownloadsView.this.tv.setSelectedRows(new TableRowCore[]{row});
                    }
                }
            });
        }
        control.layout(true);
    }

    private void registerPluginViews(UISWTInstance pluginUI) {
        if (this.registeredCoreSubViews) {
            return;
        }
        pluginUI.addView(TABLE_NAME, "ArchivedFilesView", ArchivedFilesView.class, null);
        this.registeredCoreSubViews = true;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (this.tv == null || !this.tv.isVisible()) {
            return false;
        }
        List<Object> datasources = this.tv.getSelectedDataSources();
        if (datasources.size() > 0) {
            ArrayList<DownloadStub> dms = new ArrayList<DownloadStub>(datasources.size());
            for (Object o : datasources) {
                dms.add((DownloadStub)o);
            }
            String id = item.getID();
            if (id.equals("remove")) {
                TorrentUtil.removeDataSources(datasources.toArray());
            } else if (id.equals("startstop") || id.equals("start")) {
                ManagerUtils.restoreFromArchive(dms, true, null);
            }
            return true;
        }
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.tv == null || !this.tv.isVisible()) {
            return;
        }
        boolean canEnable = false;
        Object[] datasources = this.tv.getSelectedDataSources().toArray();
        if (datasources.length > 0) {
            canEnable = true;
        }
        list.put("start", canEnable ? 1L : 0L);
        list.put("startstop", canEnable ? 1L : 0L);
        list.put("remove", canEnable ? 1L : 0L);
    }

    @Override
    public void updateUI() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    @Override
    public String getUpdateUIName() {
        return TABLE_NAME;
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        List<Object> ds = this.tv.getSelectedDataSources();
        final ArrayList<DownloadStub> dms = new ArrayList<DownloadStub>(ds.size());
        for (Object o : ds) {
            dms.add((DownloadStub)o);
        }
        boolean hasSelection = dms.size() > 0;
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (DownloadStub download : dms) {
                    ManagerUtils.open(new File(download.getSavePath()), use_open_containing_folder);
                }
            }
        });
        itemExplore.setEnabled(hasSelection);
        new MenuItem(menu, 2);
        MenuItem itemRestore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRestore, "MyTorrentsView.menu.restore");
        itemRestore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.restoreFromArchive(dms, false, null);
            }
        });
        itemRestore.setEnabled(hasSelection);
        MenuItem itemRestoreAnd = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRestoreAnd, "MyTorrentsView.menu.restore.and");
        itemRestoreAnd.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                ManagerUtils.restoreFromArchive(dms, false, new ManagerUtils.ArchiveCallback(){
                    private List<DownloadManager> targets = new ArrayList<DownloadManager>();

                    public void success(DownloadStub source, DownloadStub target) {
                        DownloadManager dm = PluginCoreUtils.unwrap((Download)target);
                        if (dm != null) {
                            this.targets.add(dm);
                        }
                    }

                    public void completed() {
                        Utils.execSWTThread(new Runnable(){

                            public void run() {
                                if (targets.size() == 0) {
                                    return;
                                }
                                final Menu menu = new Menu((Control)SBC_ArchivedDownloadsView.this.table_parent);
                                DownloadManager[] dm_list = targets.toArray(new DownloadManager[dms.size()]);
                                TorrentUtil.fillTorrentMenu(menu, dm_list, AzureusCoreFactory.getSingleton(), SBC_ArchivedDownloadsView.this.table_parent, true, 0, SBC_ArchivedDownloadsView.this.tv);
                                menu.addMenuListener(new MenuListener(){

                                    public void menuShown(MenuEvent e) {
                                    }

                                    public void menuHidden(MenuEvent e) {
                                        Utils.execSWTThreadLater(1, new Runnable(){

                                            public void run() {
                                                menu.dispose();
                                            }
                                        });
                                    }
                                });
                                menu.setVisible(true);
                            }
                        });
                    }
                });
            }
        });
        itemRestoreAnd.setEnabled(hasSelection);
        new MenuItem(menu, 2);
    }

    @Override
    public void selected(TableRowCore[] row) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        if (rows.length == 1) {
            Object object = rows[0].getDataSource();
        }
    }

    @Override
    public void downloadStubEventOccurred(DownloadStubEvent event2) throws DownloadException {
        int type = event2.getEventType();
        List<DownloadStub> dls = event2.getDownloadStubs();
        if (type == 1) {
            this.tv.addDataSources((DownloadStub[])dls.toArray(new DownloadStub[dls.size()]));
        } else if (type == 2) {
            this.tv.removeDataSources((DownloadStub[])dls.toArray(new DownloadStub[dls.size()]));
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    @Override
    public void filterSet(String filter2) {
    }

    @Override
    public boolean filterCheck(DownloadStub ds, String filter2, boolean regex) {
        Pattern pattern;
        if (filter2.toLowerCase(Locale.US).startsWith("f:")) {
            filter2 = filter2.substring(2).trim();
            DownloadStub.DownloadStubFile[] files = ds.getStubFiles();
            String s = regex ? filter2 : "\\Q" + filter2.replaceAll("\\s*[|;]\\s*", "\\\\E|\\\\Q") + "\\E";
            boolean match_result = true;
            if (regex && s.startsWith("!")) {
                s = s.substring(1);
                match_result = false;
            }
            Pattern pattern2 = RegExUtil.getCachedPattern("archiveview:search", s, 2);
            boolean result = !match_result;
            for (DownloadStub.DownloadStubFile file : files) {
                String name = file.getFile().getName();
                if (!pattern2.matcher(name).find()) continue;
                result = match_result;
                break;
            }
            return result;
        }
        String name = ds.getName();
        String s = regex ? filter2 : "\\Q" + filter2.replaceAll("\\s*[|;]\\s*", "\\\\E|\\\\Q") + "\\E";
        boolean match_result = true;
        if (regex && s.startsWith("!")) {
            s = s.substring(1);
            match_result = false;
        }
        return (pattern = RegExUtil.getCachedPattern("archiveview:search", s, 2)).matcher(name).find() == match_result;
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        TableRowCore row;
        if (params instanceof DownloadStub && this.tv != null && (row = this.tv.getRow((DownloadStub)params)) != null) {
            this.tv.setSelectedRows(new TableRowCore[]{row});
        }
        this.datasource = params;
        return null;
    }
}

