/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.content.AzureusPlatformContentDirectory;
import com.aelitis.azureus.core.content.RelatedContentManager;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerListener;
import com.aelitis.azureus.core.peer.cache.CacheDiscovery;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.plugins.net.buddy.swt.SBC_ChatOverview;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.DownloadUtils;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.NavigationHelper;
import com.aelitis.azureus.util.PlayUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

public class InitialisationFunctions {
    private static final String EXTENSION_PREFIX = "azid";

    public static void earlyInitialisation(AzureusCore core) {
        DownloadUtils.initialise();
        DownloadManagerEnhancer dme = DownloadManagerEnhancer.initialise(core);
        InitialisationFunctions.hookDownloadAddition();
        AzureusPlatformContentDirectory.register();
        CacheDiscovery.initialise(dme);
        ContentNetworkManagerFactory.preInitialise();
        MetaSearchManagerFactory.preInitialise();
        SubscriptionManagerFactory.preInitialise();
        DeviceManagerFactory.preInitialise();
        NavigationHelper.initialise();
        RelatedContentManager.preInitialise(core);
        SBC_ChatOverview.preInitialize();
        AZ3Functions.setProvider(new AZ3Functions.provider(){

            public String getDefaultContentNetworkURL(int type, Object[] params) {
                return ConstantsVuze.getDefaultContentNetwork().getServiceURL(type, params);
            }

            public void subscribeToRSS(String name, URL url, int interval, boolean is_public, String creator_ref) throws Exception {
                Subscription subs = SubscriptionManagerFactory.getSingleton().createSingletonRSS(name, url, interval);
                if (!subs.getName(false).equals(name)) {
                    subs.setName(name);
                }
                if (subs.isPublic() != is_public) {
                    subs.setPublic(is_public);
                }
                if (!subs.isSubscribed()) {
                    subs.setSubscribed(true);
                }
                if (creator_ref != null) {
                    subs.setCreatorRef(creator_ref);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void subscribeToSubscription(String uri) throws Exception {
                SubscriptionManager manager = SubscriptionManagerFactory.getSingleton();
                Subscription subs = manager.createFromURI(uri);
                if (!subs.isSubscribed()) {
                    subs.setSubscribed(true);
                    if (subs.isSearchTemplate()) {
                        try {
                            VuzeFile vf = subs.getSearchTemplateVuzeFile();
                            if (vf == null) return;
                            subs.setSubscribed(true);
                            VuzeFileHandler.getSingleton().handleFiles(new VuzeFile[]{vf}, 0);
                            for (VuzeFileComponent comp2 : vf.getComponents()) {
                                Engine engine = (Engine)comp2.getData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY);
                                if (engine == null || engine.getSelectionState() != 0) continue;
                                engine.setSelectionState(2);
                            }
                            return;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            return;
                        }
                    } else {
                        subs.requestAttention();
                    }
                    return;
                } else {
                    subs.requestAttention();
                }
            }

            public void openRemotePairingWindow() {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif == null) {
                    Debug.out("UIFunctions not available, can't open remote pairing window");
                } else {
                    uif.openRemotePairingWindow();
                }
            }

            public void setOpened(org.gudy.azureus2.core3.download.DownloadManager dm, boolean opened) {
                PlatformTorrentUtils.setHasBeenOpened(dm, opened);
            }

            public boolean canPlay(org.gudy.azureus2.core3.download.DownloadManager dm, int file_index) {
                return PlayUtils.canPlayDS(dm, file_index, true) || PlayUtils.canStreamDS(dm, file_index, true);
            }

            public void play(org.gudy.azureus2.core3.download.DownloadManager dm, int file_index) {
                UIFunctions uif;
                DiskManagerFileInfo[] files;
                Object ds = dm;
                if (file_index >= 0 && file_index < (files = dm.getDiskManagerFileInfoSet().getFiles()).length) {
                    ds = files[file_index];
                }
                if ((uif = UIFunctionsManager.getUIFunctions()) == null) {
                    Debug.out("UIFunctions not available, can't open play/stream content");
                } else if (PlayUtils.canPlayDS(dm, file_index, true)) {
                    uif.playOrStreamDataSource(ds, "playdownloadmanager", false, true);
                } else if (PlayUtils.canStreamDS(dm, file_index, true)) {
                    uif.playOrStreamDataSource(ds, "playdownloadmanager", true, false);
                }
            }

            public void openChat(String network, String key) {
                SBC_ChatOverview.openChat(network, key);
            }

            public AZ3Functions.provider.TranscodeTarget[] getTranscodeTargets() {
                ArrayList<1> result = new ArrayList<1>();
                if (!COConfigurationManager.getStringParameter("ui").equals("az2")) {
                    try {
                        Device[] devices;
                        DeviceManager dm = DeviceManagerFactory.getSingleton();
                        for (final Device d : devices = dm.getDevices()) {
                            if (!(d instanceof DeviceMediaRenderer)) continue;
                            final DeviceMediaRenderer dmr = (DeviceMediaRenderer)d;
                            boolean hide_device = d.isHidden();
                            if (COConfigurationManager.getBooleanParameter("device.sidebar.ui.rend.hidegeneric", true) && dmr.isNonSimple()) {
                                hide_device = true;
                            }
                            if (hide_device) continue;
                            result.add(new AZ3Functions.provider.TranscodeTarget(){

                                public String getName() {
                                    return d.getName();
                                }

                                public String getID() {
                                    return d.getID();
                                }

                                public AZ3Functions.provider.TranscodeProfile[] getProfiles() {
                                    ArrayList<AZ3Functions.provider.TranscodeProfile> ps = new ArrayList<AZ3Functions.provider.TranscodeProfile>();
                                    TranscodeProfile[] profs = dmr.getTranscodeProfiles();
                                    if (profs.length == 0) {
                                        if (dmr.getTranscodeRequirement() == 1) {
                                            ps.add(new AZ3Functions.provider.TranscodeProfile(){

                                                public String getUID() {
                                                    return dmr.getID() + "/" + dmr.getBlankProfile().getName();
                                                }

                                                public String getName() {
                                                    return MessageText.getString("devices.profile.direct");
                                                }
                                            });
                                        }
                                    } else {
                                        for (final TranscodeProfile prof : profs) {
                                            ps.add(new AZ3Functions.provider.TranscodeProfile(){

                                                public String getUID() {
                                                    return prof.getUID();
                                                }

                                                public String getName() {
                                                    return prof.getName();
                                                }
                                            });
                                        }
                                    }
                                    return ps.toArray(new AZ3Functions.provider.TranscodeProfile[ps.size()]);
                                }
                            });
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                Collections.sort(result, new Comparator<AZ3Functions.provider.TranscodeTarget>(){

                    @Override
                    public int compare(AZ3Functions.provider.TranscodeTarget o1, AZ3Functions.provider.TranscodeTarget o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                return result.toArray(new AZ3Functions.provider.TranscodeTarget[result.size()]);
            }
        });
    }

    public static void lateInitialisation(AzureusCore core) {
        ExternalStimulusHandler.initialise(core);
        PluginInitializer.getDefaultInterface().getUtilities().createDelayedTask(new Runnable(){

            public void run() {
                MetaSearchManagerFactory.getSingleton();
                SubscriptionManagerFactory.getSingleton();
                try {
                    RelatedContentManager.getSingleton();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                try {
                    MetaSearchManagerFactory.getSingleton().addListener(new MetaSearchManagerListener(){

                        public void searchRequest(String term) {
                            UIFunctionsManager.getUIFunctions().doSearch(term);
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }).queue();
    }

    protected static void hookDownloadAddition() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        DownloadManager dm = pi.getDownloadManager();
        dm.addDownloadWillBeAddedListener(new DownloadWillBeAddedListener(){

            public void initialised(Download download) {
                org.gudy.azureus2.core3.download.DownloadManager dm = PluginCoreUtils.unwrap(download);
                if (PlatformTorrentUtils.getHasBeenOpened(dm)) {
                    PlatformTorrentUtils.setHasBeenOpened(dm, false);
                }
                InitialisationFunctions.register(download);
            }
        });
        dm.addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                InitialisationFunctions.register(download);
            }

            public void downloadRemoved(Download download) {
            }
        });
    }

    protected static void register(final Download download) {
        DownloadManagerStateAttributeListener dmsal = new DownloadManagerStateAttributeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void attributeEventOccurred(org.gudy.azureus2.core3.download.DownloadManager dm, String attribute_name, int event_type) {
                block5: {
                    block4: {
                        try {
                            Torrent t = download.getTorrent();
                            if (t == null) {
                                Object var6_5 = null;
                                dm.getDownloadState().removeListener(this, "trackerclientextensions", 2);
                                return;
                            }
                            if (!PlatformTorrentUtils.isContent(t, true)) {
                                break block4;
                            }
                            DownloadUtils.addTrackerExtension(download, InitialisationFunctions.EXTENSION_PREFIX, ConstantsVuze.AZID);
                            download.setFlag(32L, true);
                            break block5;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            dm.getDownloadState().removeListener(this, "trackerclientextensions", 2);
                            throw throwable;
                        }
                    }
                    Object var6_6 = null;
                    dm.getDownloadState().removeListener(this, "trackerclientextensions", 2);
                    return;
                }
                Object var6_7 = null;
                dm.getDownloadState().removeListener(this, "trackerclientextensions", 2);
            }
        };
        PluginCoreUtils.unwrap(download).getDownloadState().addListener(dmsal, "trackerclientextensions", 2);
    }
}

