/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.magneturi.impl;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.HTTPUtils;
import com.aelitis.azureus.core.util.png.PNG;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;

public class MagnetURIHandlerImpl
extends MagnetURIHandler {
    private static final LogIDs LOGID = LogIDs.NET;
    private static MagnetURIHandlerImpl singleton;
    private static AEMonitor class_mon;
    private static final int DOWNLOAD_TIMEOUT = 600000;
    protected static final String NL = "\r\n";
    private static final boolean DEBUG = false;
    private int port;
    private CopyOnWriteList<MagnetURIHandlerListener> listeners = new CopyOnWriteList();
    private Map info_map = new HashMap();
    private Map<String, MagnetURIHandler.ResourceProvider> resources = new HashMap<String, MagnetURIHandler.ResourceProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MagnetURIHandler getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new MagnetURIHandlerImpl();
            }
            MagnetURIHandlerImpl magnetURIHandlerImpl = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return magnetURIHandlerImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected MagnetURIHandlerImpl() {
        ServerSocket socket = null;
        for (int i = 45100; i <= 45199; ++i) {
            try {
                socket = new ServerSocket(i, 50, InetAddress.getByName("127.0.0.1"));
                this.port = i;
                break;
            }
            catch (Throwable e) {
                continue;
            }
        }
        COConfigurationManager.setIntDefault("magnet.uri.port", this.port);
        COConfigurationManager.registerExportedParameter("magnet.port", "magnet.uri.port");
        if (socket == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "MagnetURI: no free sockets, giving up"));
            }
        } else {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MagnetURI: bound on " + socket.getLocalPort()));
            }
            final ServerSocket f_socket = socket;
            AEThread t = new AEThread("MagnetURIHandler"){

                public void runSupport() {
                    int errors = 0;
                    int ok = 0;
                    while (true) {
                        try {
                            while (true) {
                                final Socket sck = f_socket.accept();
                                ++ok;
                                errors = 0;
                                new AEThread2("MagnetURIHandler:processor", true){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     * Loose catch block
                                     */
                                    public void run() {
                                        block18: {
                                            boolean close_socket;
                                            block17: {
                                                close_socket = true;
                                                String address = sck.getInetAddress().getHostAddress();
                                                if (address.equals("localhost") || address.equals("127.0.0.1")) {
                                                    BufferedReader br = new BufferedReader(new InputStreamReader(sck.getInputStream(), "UTF8"));
                                                    String line = br.readLine();
                                                    if (line != null) {
                                                        if (line.toUpperCase().startsWith("GET ")) {
                                                            Logger.log(new LogEvent(LOGID, "MagnetURIHandler: processing '" + line + "'"));
                                                            line = line.substring(4);
                                                            int pos = line.lastIndexOf(32);
                                                            line = line.substring(0, pos);
                                                            close_socket = MagnetURIHandlerImpl.this.process(line, br, sck.getOutputStream());
                                                        } else {
                                                            Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: invalid command - '" + line + "'"));
                                                        }
                                                    } else {
                                                        Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: connect from '" + address + "': no data read"));
                                                    }
                                                    break block17;
                                                }
                                                Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: connect from invalid address '" + address + "'"));
                                            }
                                            Object var7_7 = null;
                                            try {
                                                if (close_socket) {
                                                    sck.close();
                                                }
                                                break block18;
                                            }
                                            catch (Throwable e2) {}
                                            break block18;
                                            {
                                                catch (Throwable e) {
                                                    if (!(e instanceof IOException) && !(e instanceof SocketException)) {
                                                        Debug.printStackTrace(e);
                                                    }
                                                    Object var7_8 = null;
                                                    try {
                                                        if (close_socket) {
                                                            sck.close();
                                                        }
                                                        break block18;
                                                    }
                                                    catch (Throwable e2) {}
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var7_9 = null;
                                                try {
                                                    if (close_socket) {
                                                        sck.close();
                                                    }
                                                }
                                                catch (Throwable e2) {
                                                    // empty catch block
                                                }
                                                throw throwable;
                                            }
                                        }
                                    }
                                }.start();
                            }
                        }
                        catch (Throwable e) {
                            block4: {
                                Debug.printStackTrace(e);
                                if (++errors <= 100) continue;
                                if (!Logger.isEnabled()) break block4;
                                Logger.log(new LogEvent(LOGID, "MagnetURIHandler: bailing out, too many socket errors"));
                            }
                            return;
                        }
                        break;
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    public void process(final String get, final InputStream is, final OutputStream os) throws IOException {
        new AEThread2("MagnetProcessor", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block25: {
                    Throwable e2;
                    boolean close;
                    block21: {
                        close = false;
                        close = MagnetURIHandlerImpl.this.process(get, new BufferedReader(new InputStreamReader(is)), os);
                        Object var4_2 = null;
                        if (!close) break block21;
                        try {
                            is.close();
                        }
                        catch (Throwable e2) {
                            Debug.out(e2);
                        }
                    }
                    try {
                        os.flush();
                    }
                    catch (Throwable e2) {
                        Debug.out(e2);
                    }
                    if (close) {
                        try {
                            os.close();
                        }
                        catch (Throwable e2) {
                            Debug.out(e2);
                        }
                    }
                    break block25;
                    {
                        catch (Throwable e3) {
                            Debug.out("Magnet processing failed", e3);
                            Object var4_3 = null;
                            if (close) {
                                try {
                                    is.close();
                                }
                                catch (Throwable e2) {
                                    Debug.out(e2);
                                }
                            }
                            try {
                                os.flush();
                            }
                            catch (Throwable e2) {
                                Debug.out(e2);
                            }
                            if (close) {
                                try {
                                    os.close();
                                }
                                catch (Throwable e2) {
                                    Debug.out(e2);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (close) {
                            try {
                                is.close();
                            }
                            catch (Throwable e2) {
                                Debug.out(e2);
                            }
                        }
                        try {
                            os.flush();
                        }
                        catch (Throwable e2) {
                            Debug.out(e2);
                        }
                        if (close) {
                            try {
                                os.close();
                            }
                            catch (Throwable e2) {
                                Debug.out(e2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean process(String get, BufferedReader is, OutputStream os) throws IOException {
        String header;
        String headers_str;
        String name;
        byte[] data;
        byte[] data2;
        String arg_str;
        HashMap<String, String> original_params = new HashMap<String, String>();
        HashMap<String, String> lc_params = new HashMap<String, String>();
        ArrayList<String> source_params = new ArrayList<String>();
        int pos = get.indexOf(63);
        if (pos == -1) {
            arg_str = "";
        } else {
            arg_str = get.substring(pos + 1);
            if ((pos = arg_str.lastIndexOf(32)) >= 0) {
                arg_str = arg_str.substring(0, pos).trim();
            }
            StringTokenizer tok = new StringTokenizer(arg_str, "&");
            while (tok.hasMoreTokens()) {
                String lhs;
                String arg = tok.nextToken();
                pos = arg.indexOf(61);
                if (pos == -1) {
                    lhs = arg.trim();
                    original_params.put(lhs, "");
                    lc_params.put(lhs.toLowerCase(MessageText.LOCALE_ENGLISH), "");
                    continue;
                }
                try {
                    lhs = arg.substring(0, pos).trim();
                    String lc_lhs = lhs.toLowerCase(MessageText.LOCALE_ENGLISH);
                    String rhs = UrlUtils.decode(arg.substring(pos + 1).trim());
                    if (lc_lhs.equals("xt")) {
                        if (rhs.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:")) {
                            original_params.put(lhs, rhs);
                            lc_params.put(lhs, rhs);
                            continue;
                        }
                        String existing = (String)lc_params.get("xt");
                        if (existing != null && (existing.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:") || !rhs.startsWith("urn:sha1:"))) continue;
                        original_params.put(lhs, rhs);
                        lc_params.put(lhs, rhs);
                        continue;
                    }
                    original_params.put(lhs, rhs);
                    lc_params.put(lc_lhs, rhs);
                    if (!lc_lhs.equals("xsource")) continue;
                    source_params.add(rhs);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (get.startsWith("/magnet10/badge.img")) {
            MagnetURIHandlerListener listener;
            Iterator<MagnetURIHandlerListener> i$ = this.listeners.iterator();
            do {
                if (i$.hasNext()) continue;
                this.writeNotFound(os);
                return true;
            } while ((data2 = (listener = i$.next()).badge()) == null);
            this.writeReply(os, "image/gif", data2);
            return true;
        }
        if (get.startsWith("/magnet10/canHandle.img?")) {
            String urn = (String)lc_params.get("xt");
            if (urn != null && urn.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:")) {
                for (MagnetURIHandlerListener listener : this.listeners) {
                    byte[] data3 = listener.badge();
                    if (data3 == null) continue;
                    this.writeReply(os, "image/gif", data3);
                    return true;
                }
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/azversion")) {
            this.writeReply(os, "text/plain", "5.6.1.3_B16");
            return true;
        }
        if (get.startsWith("/magnet10/options.js?") || get.startsWith("/magnet10/default.js?")) {
            String resp = "";
            resp = resp + this.getJS("magnetOptionsPreamble");
            resp = resp + this.getJSS("<a href=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/select/?\"+magnetQueryString+\"\\\" target=\\\"_blank\\\">");
            resp = resp + this.getJSS("<img src=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/magnet10/badge.img\\\">");
            resp = resp + this.getJSS("Download with Azureus");
            resp = resp + this.getJSS("</a>");
            resp = resp + this.getJS("magnetOptionsPostamble");
            resp = resp + "magnetOptionsPollSuccesses++";
            this.writeReply(os, "application/x-javascript", resp);
            return true;
        }
        if (get.startsWith("/magnet10/pause")) {
            try {
                Thread.sleep(250L);
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/select/")) {
            String fail_reason = "";
            boolean ok = false;
            String urn = (String)lc_params.get("xt");
            if (urn == null) {
                fail_reason = "xt missing";
            } else {
                String lc_urn = urn.toLowerCase(MessageText.LOCALE_ENGLISH);
                try {
                    URL url = lc_urn.startsWith("http:") || lc_urn.startsWith("https:") ? new URL(urn) : new URL("magnet:?xt=" + urn);
                    for (MagnetURIHandlerListener listener : this.listeners) {
                        if (!listener.download(url)) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        fail_reason = "No listeners accepted the operation";
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    fail_reason = Debug.getNestedExceptionMessage(e);
                }
            }
            if (!ok) {
                this.writeReply(os, "text/plain", "Download initiation failed: " + fail_reason);
                return true;
            }
            if ("image".equalsIgnoreCase((String)lc_params.get("result"))) {
                for (MagnetURIHandlerListener listener : this.listeners) {
                    data = listener.badge();
                    if (data == null) continue;
                    this.writeReply(os, "image/gif", data);
                    return true;
                }
            }
            this.writeReply(os, "text/plain", "Download initiated");
            return true;
        }
        if (get.startsWith("/download/")) {
            final PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
            try {
                byte[] _sha1;
                pw.print("HTTP/1.0 200 OK\r\n");
                pw.flush();
                String urn = (String)lc_params.get("xt");
                if (urn == null || !urn.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:sha1:") && !urn.toLowerCase(MessageText.LOCALE_ENGLISH).startsWith("urn:btih:")) {
                    if (!Logger.isEnabled()) throw new IOException("Invalid magnet URI - no urn:sha1 or urn:btih argument supplied.");
                    Logger.log(new LogEvent(LOGID, 1, "MagnetURIHandler: invalid command - '" + get + "'"));
                    throw new IOException("Invalid magnet URI - no urn:sha1 or urn:btih argument supplied.");
                }
                String encoded = urn.substring(9);
                ArrayList<InetSocketAddress> sources = new ArrayList<InetSocketAddress>();
                for (int i = 0; i < source_params.size(); ++i) {
                    String source = (String)source_params.get(i);
                    int p = source.indexOf(58);
                    if (p == -1) continue;
                    try {
                        String host = source.substring(0, p);
                        int port = Integer.parseInt(source.substring(p + 1));
                        if (host.startsWith("/")) {
                            host = host.substring(1);
                        }
                        InetSocketAddress sa = new InetSocketAddress(host, port);
                        sources.add(sa);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                final InetSocketAddress[] s = sources.toArray(new InetSocketAddress[sources.size()]);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "MagnetURIHandler: download of '" + encoded + "' starts (initial sources=" + s.length + ")"));
                }
                if ((_sha1 = UrlUtils.decodeSHA1Hash(encoded)) == null) {
                    _sha1 = new byte[20];
                }
                final byte[] sha1 = _sha1;
                byte[] data4 = null;
                String verbose_str = (String)lc_params.get("verbose");
                final boolean verbose = verbose_str != null && verbose_str.equalsIgnoreCase("true");
                final boolean[] cancel = new boolean[]{false};
                TimerEventPeriodic keep_alive = SimpleTimer.addPeriodicEvent("MURI:keepalive", 5000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void perform(TimerEvent event2) {
                        pw.print("X-KeepAlive: YEAH!\r\n");
                        boolean failed = pw.checkError();
                        if (!failed) return;
                        boolean[] blArray = cancel;
                        synchronized (cancel) {
                            cancel[0] = true;
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return;
                        }
                    }
                });
                try {
                    final String f_arg_str = arg_str;
                    final byte[][] f_data = new byte[][]{null};
                    final Throwable[] f_error = new Throwable[]{null};
                    final AESemaphore wait_sem = new AESemaphore("download-waiter");
                    ArrayList<4> tasks = new ArrayList<4>();
                    for (final MagnetURIHandlerListener magnetURIHandlerListener : this.listeners) {
                        tasks.add(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run() {
                                try {
                                    try {
                                        byte[] data = magnetURIHandlerListener.download(new MagnetURIHandlerProgressListener(){

                                            public void reportSize(long size) {
                                                pw.print("X-Report: " + MagnetURIHandlerImpl.this.getMessageText("torrent_size", String.valueOf(size)) + MagnetURIHandlerImpl.NL);
                                                pw.flush();
                                            }

                                            public void reportActivity(String str) {
                                                pw.print("X-Report: " + str + MagnetURIHandlerImpl.NL);
                                                pw.flush();
                                            }

                                            public void reportCompleteness(int percent) {
                                                pw.print("X-Report: " + MagnetURIHandlerImpl.this.getMessageText("percent", String.valueOf(percent)) + MagnetURIHandlerImpl.NL);
                                                pw.flush();
                                            }

                                            public boolean verbose() {
                                                return verbose;
                                            }

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public boolean cancelled() {
                                                Object object = cancel;
                                                synchronized (cancel) {
                                                    if (cancel[0]) {
                                                        // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                                                        return true;
                                                    }
                                                    // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                                                    object = f_data;
                                                    synchronized (f_data) {
                                                        // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                                                        return f_data[0] != null;
                                                    }
                                                }
                                            }
                                        }, sha1, f_arg_str, s, 600000L);
                                        byte[][] byArray = f_data;
                                        synchronized (f_data) {
                                            if (data != null && f_data[0] == null) {
                                                f_data[0] = data;
                                            }
                                            // ** MonitorExit[var2_3] (shouldn't be in output)
                                        }
                                    }
                                    catch (Throwable e) {
                                        byte[][] byArray = f_data;
                                        synchronized (f_data) {
                                            f_error[0] = e;
                                            // ** MonitorExit[var2_4] (shouldn't be in output)
                                            Object var6_6 = null;
                                            wait_sem.release();
                                            return;
                                        }
                                    }
                                    {
                                        Object var6_5 = null;
                                        wait_sem.release();
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var6_7 = null;
                                    wait_sem.release();
                                    throw throwable;
                                }
                            }
                        });
                    }
                    if (tasks.size() > 0) {
                        if (tasks.size() == 1) {
                            ((Runnable)tasks.get(0)).run();
                        } else {
                            for (final Runnable runnable : tasks) {
                                new AEThread2("MUH:dasync"){

                                    public void run() {
                                        runnable.run();
                                    }
                                }.start();
                            }
                            for (int i = 0; i < tasks.size(); ++i) {
                                wait_sem.reserve();
                            }
                        }
                        byte[][] byArrayArray = f_data;
                        // MONITORENTER : f_data
                        data4 = f_data[0];
                        if (data4 == null && f_error[0] != null) {
                            throw f_error[0];
                        }
                        // MONITOREXIT : byArrayArray
                    }
                    Object var30_58 = null;
                    keep_alive.cancel();
                }
                catch (Throwable throwable) {
                    Object var30_59 = null;
                    keep_alive.cancel();
                    throw throwable;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "MagnetURIHandler: download of '" + encoded + "' completes, data " + (data4 == null ? "not found" : "found, length = " + data4.length)));
                }
                if (data4 != null) {
                    pw.print("Content-Length: " + data4.length + NL + NL);
                    pw.flush();
                    os.write(data4);
                    os.flush();
                    return true;
                }
                pw.print("X-Report: error: " + this.getMessageText("no_sources") + NL);
                pw.flush();
                if (lc_params.containsKey("pause_on_error")) return false;
                return true;
            }
            catch (Throwable e) {
                pw.print("X-Report: error: " + this.getMessageText("error", Debug.getNestedExceptionMessage(e)) + NL);
                pw.flush();
                if (lc_params.containsKey("pause_on_error")) return false;
                return true;
            }
        }
        if (get.startsWith("/getinfo?")) {
            name = (String)lc_params.get("name");
            if (name != null) {
                Integer info = (Integer)this.info_map.get(name);
                int value = Integer.MIN_VALUE;
                if (info != null) {
                    value = info;
                } else {
                    for (MagnetURIHandlerListener listener : this.listeners) {
                        HashMap<String, String> paramsCopy = new HashMap<String, String>();
                        paramsCopy.putAll(original_params);
                        value = listener.get(name, paramsCopy);
                        if (value == Integer.MIN_VALUE) continue;
                    }
                }
                if (value == Integer.MIN_VALUE) {
                    String def_str = (String)lc_params.get("default");
                    if (def_str != null) {
                        try {
                            value = Integer.parseInt(def_str);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                } else {
                    String max_str = (String)lc_params.get("max");
                    if (max_str != null) {
                        try {
                            int max = Integer.parseInt(max_str);
                            if (value > max) {
                                value = max;
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                if (value != Integer.MIN_VALUE) {
                    if (value < 0) {
                        value = 0;
                    }
                    if (value > 0x100000) {
                        value = 0x100000;
                    }
                    int width = value;
                    int height = 1;
                    String div_mod = (String)lc_params.get("divmod");
                    if (div_mod != null) {
                        int n = Integer.parseInt(div_mod);
                        width = value / n + 1;
                        height = value % n + 1;
                    } else {
                        String div = (String)lc_params.get("div");
                        if (div != null) {
                            width = value / Integer.parseInt(div);
                        } else {
                            String mod = (String)lc_params.get("mod");
                            if (mod != null) {
                                width = value % Integer.parseInt(mod);
                            }
                        }
                    }
                    String img_type = (String)lc_params.get("img_type");
                    if (img_type != null && img_type.equals("png")) {
                        byte[] data5 = PNG.getPNGBytesForSize(width, height);
                        this.writeReply(os, "image/png", data5);
                        return true;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.writeImage(baos, width, height);
                    byte[] data6 = baos.toByteArray();
                    this.writeReply(os, "image/bmp", data6);
                    return true;
                }
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/setinfo?")) {
            name = (String)lc_params.get("name");
            if (name == null) return true;
            boolean result = false;
            for (MagnetURIHandlerListener listener : this.listeners) {
                HashMap<String, String> paramsCopy = new HashMap<String, String>();
                paramsCopy.putAll(original_params);
                result = listener.set(name, paramsCopy);
                if (!result) continue;
            }
            int width = result ? 20 : 10;
            int height = result ? 20 : 10;
            String img_type = (String)lc_params.get("img_type");
            if (img_type != null && img_type.equals("png")) {
                data = PNG.getPNGBytesForSize(width, height);
                this.writeReply(os, "image/png", data);
                return true;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeImage(baos, width, height);
            byte[] data7 = baos.toByteArray();
            this.writeReply(os, "image/bmp", data7);
            return true;
        }
        if (get.equals("/browserheaders.js")) {
            headers_str = "";
        } else {
            if (!get.startsWith("/resource.")) return true;
            String rid = (String)lc_params.get("rid");
            Map<String, MagnetURIHandler.ResourceProvider> width = this.resources;
            // MONITORENTER : width
            MagnetURIHandler.ResourceProvider provider2 = this.resources.get(rid);
            // MONITOREXIT : width
            if (provider2 == null) {
                this.writeNotFound(os);
                return true;
            }
            data2 = provider2.getData();
            if (data2 != null) {
                this.writeReply(os, HTTPUtils.guessContentTypeFromFileType(provider2.getFileType()), data2);
                return true;
            }
            this.writeNotFound(os);
            return true;
        }
        while ((header = is.readLine()) != null && (header = header.trim()).length() != 0) {
            headers_str = headers_str + (headers_str.length() == 0 ? "" : "\n") + header;
        }
        String script = "var headers = \"" + new String(Base64.encode(headers_str.getBytes("UTF-8"))) + "\";";
        this.writeReply(os, "application/x-javascript", script);
        return true;
    }

    private void writeImage(OutputStream os, int width, int height) {
        int rowWidth = width / 8;
        if (rowWidth % 4 != 0) {
            rowWidth = (rowWidth / 4 + 1) * 4;
        }
        int imageSize = rowWidth * height;
        int fileSize = 54 + imageSize;
        try {
            os.write(new byte[]{66, 77});
            this.write4Bytes(os, fileSize);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 54L);
            this.write4Bytes(os, 40L);
            this.write4Bytes(os, width);
            this.write4Bytes(os, height);
            this.write4Bytes(os, 65537L);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, imageSize);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 0L);
            this.write4Bytes(os, 0L);
            byte[] data = new byte[imageSize];
            os.write(data);
        }
        catch (IOException e) {
            Debug.out(e);
        }
    }

    private void write4Bytes(OutputStream os, long l) {
        try {
            os.write((int)(l & 0xFFL));
            os.write((int)(l >> 8 & 0xFFL));
            os.write((int)(l >> 16 & 0xFFL));
            os.write((int)(l >> 24 & 0xFFL));
        }
        catch (IOException e) {
            Debug.out(e);
        }
    }

    protected String getMessageText(String resource) {
        return MessageText.getString("MagnetURLHandler.report." + resource);
    }

    protected String getMessageText(String resource, String param) {
        if (resource.equals("error")) {
            return param;
        }
        return MessageText.getString("MagnetURLHandler.report." + resource, new String[]{param});
    }

    protected String getJS(String s) {
        return "document.write(" + s + ");" + NL;
    }

    protected String getJSS(String s) {
        return "document.write(\"" + s + "\");" + NL;
    }

    protected void writeReply(OutputStream os, String content_type, String content) throws IOException {
        this.writeReply(os, content_type, content.getBytes());
    }

    protected void writeReply(OutputStream os, String content_type, byte[] content) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.1 200 OK\r\n");
        pw.print("Cache-Control: no-cache\r\n");
        pw.print("Pragma: no-cache\r\n");
        pw.print("Content-Type: " + content_type + NL);
        pw.print("Content-Length: " + content.length + NL + NL);
        pw.flush();
        os.write(content);
    }

    protected void writeNotFound(OutputStream os) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.0 404 Not Found\r\n\r\n");
        pw.flush();
    }

    public int getPort() {
        return this.port;
    }

    public void addInfo(String name, int info) {
        this.info_map.put(name, new Integer(info));
        Logger.log(new LogEvent(LOGID, 0, "MagnetURIHandler: global info registered: " + name + " -> " + info));
    }

    public void addListener(MagnetURIHandlerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(MagnetURIHandlerListener l) {
        this.listeners.remove(l);
    }

    public static void main(String[] args) {
        new MagnetURIHandlerImpl();
        try {
            Thread.sleep(1000000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL registerResource(MagnetURIHandler.ResourceProvider provider2) {
        try {
            String rid = URLEncoder.encode(provider2.getUID(), "UTF-8");
            Map<String, MagnetURIHandler.ResourceProvider> map = this.resources;
            synchronized (map) {
                this.resources.put(rid, provider2);
            }
            return new URL("http://127.0.0.1:" + this.port + "/resource." + provider2.getFileType() + "?rid=" + rid);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    static {
        class_mon = new AEMonitor("MagnetURLHandler:class");
    }
}

