/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnpms.impl;

import com.aelitis.net.upnpms.UPNPMSBrowser;
import com.aelitis.net.upnpms.UPNPMSBrowserListener;
import com.aelitis.net.upnpms.UPNPMSContainer;
import com.aelitis.net.upnpms.UPnPMSException;
import com.aelitis.net.upnpms.impl.UPNPMSContainerImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPNPMSBrowserImpl
implements UPNPMSBrowser {
    private List<URL> endpoints;
    private String client_name;
    private UPNPMSBrowserListener listener;
    private UPNPMSContainerImpl root;
    private URL preferred_endpoint;

    public UPNPMSBrowserImpl(String _client_name, List<URL> _urls, UPNPMSBrowserListener _listener) throws UPnPMSException {
        this.client_name = _client_name;
        this.endpoints = _urls;
        this.listener = _listener;
        this.client_name = this.client_name.replaceAll("\"", "'");
        this.client_name = this.client_name.replaceAll(";", ",");
        this.client_name = this.client_name.replaceAll("=", "-");
        this.root = new UPNPMSContainerImpl(this, "0", "");
    }

    @Override
    public UPNPMSContainer getRoot() throws UPnPMSException {
        return this.root;
    }

    private void setPreferredEndpoint(URL url) {
        if (this.endpoints.size() > 1 && url != this.preferred_endpoint) {
            this.preferred_endpoint = url;
            this.listener.setPreferredURL(this.preferred_endpoint);
            this.endpoints.remove(this.preferred_endpoint);
            this.endpoints.add(0, this.preferred_endpoint);
        }
    }

    protected List<SimpleXMLParserDocumentNode> getContainerContents(String id) throws UPnPMSException {
        try {
            int total_matches;
            SimpleXMLParserDocumentNode response;
            int num_returned;
            ArrayList<SimpleXMLParserDocumentNode> results = new ArrayList<SimpleXMLParserDocumentNode>();
            int starting_index = 0;
            do {
                String NL = "\r\n";
                String soap_action = "urn:schemas-upnp-org:service:ContentDirectory:1#Browse";
                String request2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + NL + "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">" + NL + "<s:Body>" + NL + "<u:Browse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\">" + NL + "<ObjectID>" + id + "</ObjectID>" + NL + "<BrowseFlag>BrowseDirectChildren</BrowseFlag>" + NL + "<Filter>dc:date,res@protocolInfo,res@size</Filter>" + NL + "<StartingIndex>" + starting_index + "</StartingIndex>" + NL + "<RequestedCount>256</RequestedCount>" + NL + "<SortCriteria></SortCriteria>" + NL + "</u:Browse>" + NL + "</s:Body>" + NL + "</s:Envelope>";
                SimpleXMLParserDocumentNode doc = null;
                UPnPMSException last_error = null;
                for (URL endpoint : new ArrayList<URL>(this.endpoints)) {
                    try {
                        doc = this.getXML(endpoint, soap_action, request2);
                        this.setPreferredEndpoint(endpoint);
                        break;
                    }
                    catch (UPnPMSException e) {
                        last_error = e;
                    }
                }
                if (doc == null) {
                    throw last_error;
                }
                SimpleXMLParserDocumentNode body = doc.getChild("Body");
                response = body.getChild("BrowseResponse");
                SimpleXMLParserDocumentNode didl_result = response.getChild("Result");
                String didl_str = didl_result.getValue();
                SimpleXMLParserDocument didle_doc = SimpleXMLParserDocumentFactory.create(didl_str);
                results.add(didle_doc);
            } while ((num_returned = Integer.parseInt(response.getChild("NumberReturned").getValue())) > 0 && (starting_index += num_returned) < (total_matches = Integer.parseInt(response.getChild("TotalMatches").getValue())));
            return results;
        }
        catch (UPnPMSException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UPnPMSException("Failed to read container", e);
        }
    }

    private SimpleXMLParserDocument getXML(URL url, String soap_action, String post_data) throws UPnPMSException {
        ResourceDownloader rd = new ResourceDownloaderFactoryImpl().create(url, post_data);
        try {
            rd.setProperty("URL_Connection", "Keep-Alive");
            rd.setProperty("URL_Read_Timeout", 600000);
            rd.setProperty("URL_Connect_Timeout", 300000);
            rd.setProperty("URL_SOAPAction", "\"" + soap_action + "\"");
            rd.setProperty("URL_X-AV-Client-Info", "av=1.0; cn=\"Azureus Software, Inc.\"; mn=\"" + this.client_name + "\"; mv=\"" + "5.6.1.3_B16" + "\"");
            rd.setProperty("URL_Content-Type", "text/xml; charset=\"utf-8\"");
            SimpleXMLParserDocument doc = SimpleXMLParserDocumentFactory.create(url, rd.download());
            return doc;
        }
        catch (Throwable e) {
            throw new UPnPMSException("XML RPC failed", e);
        }
    }
}

