/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;

public class StatsWriterImpl
extends XUXmlWriter {
    AzureusCore core;

    protected StatsWriterImpl(AzureusCore _core) {
        this.core = _core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(String file_name) throws IOException {
        try {
            this.setOutputStream(new FileOutputStream(file_name));
            this.writeSupport();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.closeOutputStream();
            throw throwable;
        }
        this.closeOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(OutputStream os) throws IOException {
        try {
            this.setOutputStream(os);
            this.writeSupport();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.flushOutputStream();
            throw throwable;
        }
        this.flushOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeSupport() {
        this.writeLineRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        boolean export_peer_stats = COConfigurationManager.getBooleanParameter("Stats Export Peer Details");
        boolean export_file_stats = COConfigurationManager.getBooleanParameter("Stats Export File Details");
        String xsl = COConfigurationManager.getStringParameter("Stats XSL File");
        if (xsl.length() > 0) {
            this.writeLineRaw("<?xml-stylesheet type=\"text/xsl\" href=\"" + xsl + "\"?>");
        }
        this.writeLineRaw("<STATS>");
        GlobalManager global = this.core.getGlobalManager();
        try {
            this.indent();
            this.writeTag("AZUREUS_VERSION", "5.6.1.3_B16");
            this.writeLineRaw("<GLOBAL>");
            try {
                this.indent();
                GlobalManagerStats gm_stats = global.getStats();
                this.writeRawCookedAverageTag("DOWNLOAD_SPEED", gm_stats.getDataReceiveRate() + gm_stats.getProtocolReceiveRate());
                this.writeRawCookedAverageTag("UPLOAD_SPEED", gm_stats.getDataSendRate() + gm_stats.getProtocolSendRate());
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.exdent();
                throw throwable;
            }
            this.exdent();
            this.writeLineRaw("</GLOBAL>");
            this.writeLineRaw("<DOWNLOADS>");
            try {
                this.indent();
                List<DownloadManager> _dms = global.getDownloadManagers();
                DownloadManager[] dms = new DownloadManager[_dms.size()];
                _dms.toArray(dms);
                Arrays.sort(dms, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        DownloadManager d1 = (DownloadManager)o1;
                        DownloadManager d2 = (DownloadManager)o2;
                        int d1_index = d1.getPosition();
                        int d2_index = d2.getPosition();
                        if (d1.isDownloadComplete(false)) {
                            d1_index += 1000000;
                        }
                        if (d2.isDownloadComplete(false)) {
                            d2_index += 1000000;
                        }
                        return d1_index - d2_index;
                    }
                });
                for (int i = 0; i < dms.length; ++i) {
                    Object var24_30;
                    DownloadManager dm = dms[i];
                    DownloadManagerStats dm_stats = dm.getStats();
                    this.writeLineRaw("<DOWNLOAD>");
                    try {
                        Object var12_16;
                        this.indent();
                        this.writeLineRaw("<TORRENT>");
                        TOTorrent torrent = dm.getTorrent();
                        try {
                            this.indent();
                            this.writeTag("NAME", dm.getDisplayName());
                            this.writeTag("TORRENT_FILE", dm.getTorrentFileName());
                            if (torrent != null) {
                                this.writeTag("HASH", TorrentUtils.nicePrintTorrentHash(torrent, true));
                                this.writeRawCookedTag("SIZE", torrent.getSize());
                                this.writeTag("PIECE_LENGTH", torrent.getPieceLength());
                                this.writeTag("PIECE_COUNT", torrent.getNumberOfPieces());
                                this.writeTag("FILE_COUNT", torrent.getFiles().length);
                                this.writeTag("COMMENT", dm.getTorrentComment());
                                this.writeTag("CREATED_BY", dm.getTorrentCreatedBy());
                                this.writeTag("CREATION_DATE", torrent.getCreationDate());
                            }
                            var12_16 = null;
                        }
                        catch (Throwable throwable) {
                            var12_16 = null;
                            this.exdent();
                            throw throwable;
                        }
                        this.exdent();
                        this.writeLineRaw("</TORRENT>");
                        this.writeTag("DOWNLOAD_STATUS", DisplayFormatters.formatDownloadStatusDefaultLocale(dm));
                        this.writeTag("DOWNLOAD_DIR", dm.getSaveLocation().toString());
                        if (torrent != null) {
                            if (torrent.isSimpleTorrent()) {
                                this.writeTag("TARGET_FILE", dm.getSaveLocation().toString());
                            } else {
                                this.writeTag("TARGET_DIR", dm.getSaveLocation().toString());
                            }
                        }
                        this.writeTag("TRACKER_STATUS", dm.getTrackerStatus());
                        this.writeTag("COMPLETED", dm_stats.getCompleted());
                        this.writeTag("NON_DND_COMPLETED", dm.isDownloadComplete(false));
                        this.writeRawCookedTag("DOWNLOADED", dm_stats.getTotalDataBytesReceived());
                        this.writeRawCookedTag("UPLOADED", dm_stats.getTotalDataBytesSent());
                        this.writeRawCookedTag("DISCARDED", dm_stats.getDiscarded());
                        this.writeRawCookedAverageTag("DOWNLOAD_SPEED", dm_stats.getDataReceiveRate());
                        this.writeRawCookedAverageTag("UPLOAD_SPEED", dm_stats.getDataSendRate());
                        this.writeRawCookedAverageTag("TOTAL_SPEED", dm_stats.getTotalAverage());
                        this.writeTag("ELAPSED", dm_stats.getElapsedTime());
                        this.writeTag("ETA", DisplayFormatters.formatETA(dm_stats.getSmoothedETA()));
                        this.writeTag("HASH_FAILS", dm_stats.getHashFailCount());
                        this.writeTag("SHARE_RATIO", dm_stats.getShareRatio());
                        this.writeTag("TOTAL_SEEDS", dm.getNbSeeds());
                        this.writeTag("TOTAL_LEECHERS", dm.getNbPeers());
                        if (export_file_stats) {
                            Object var17_25;
                            try {
                                this.writeLineRaw("<FILES>");
                                this.indent();
                                DiskManagerFileInfo[] files = dm.getDiskManagerFileInfo();
                                for (int j = 0; j < files.length; ++j) {
                                    Object var15_22;
                                    DiskManagerFileInfo file = files[j];
                                    try {
                                        this.writeLineRaw("<FILE>");
                                        this.indent();
                                        this.writeTag("NAME", file.getTorrentFile().getRelativePath());
                                        this.writeTag("DND", file.isSkipped());
                                        this.writeRawCookedTag("SIZE", file.getLength());
                                        this.writeRawCookedTag("DOWNLOADED", file.getDownloaded());
                                        var15_22 = null;
                                    }
                                    catch (Throwable throwable) {
                                        var15_22 = null;
                                        this.exdent();
                                        this.writeLineRaw("</FILE>");
                                        throw throwable;
                                    }
                                    this.exdent();
                                    this.writeLineRaw("</FILE>");
                                }
                                var17_25 = null;
                            }
                            catch (Throwable throwable) {
                                var17_25 = null;
                                this.exdent();
                                this.writeLineRaw("</FILES>");
                                throw throwable;
                            }
                            this.exdent();
                            this.writeLineRaw("</FILES>");
                        }
                        if (export_peer_stats) {
                            Object var22_29;
                            try {
                                this.writeLineRaw("<PEERS>");
                                this.indent();
                                PEPeerManager pm = dm.getPeerManager();
                                if (pm != null) {
                                    List<PEPeer> peers = pm.getPeers();
                                    for (int j = 0; j < peers.size(); ++j) {
                                        Object var20_28;
                                        PEPeer peer = peers.get(j);
                                        PEPeerStats peer_stats = peer.getStats();
                                        byte[] id = peer.getId();
                                        if (id == null) continue;
                                        try {
                                            try {
                                                String peer_id = PeerClassifier.getPrintablePeerID(id);
                                                peer_id = StatsWriterImpl.escapeXML(peer_id);
                                                String type = StatsWriterImpl.escapeXML(peer.getClient());
                                                this.writeLineRaw("<PEER hex_id=\"" + ByteFormatter.encodeString(id) + "\" printable_id=\"" + peer_id + "\" type=\"" + type + "\">");
                                                this.indent();
                                                this.writeTag("IP", peer.getIp());
                                                this.writeTag("IS_SEED", peer.isSeed());
                                                this.writeRawCookedTag("DOWNLOADED", peer_stats.getTotalDataBytesReceived());
                                                this.writeRawCookedTag("UPLOADED", peer_stats.getTotalDataBytesSent());
                                                this.writeRawCookedAverageTag("DOWNLOAD_SPEED", peer_stats.getDataReceiveRate());
                                                this.writeRawCookedAverageTag("UPLOAD_SPEED", peer_stats.getDataSendRate());
                                            }
                                            catch (Throwable e) {
                                                Debug.printStackTrace(e);
                                                var20_28 = null;
                                                this.exdent();
                                                this.writeLineRaw("</PEER>");
                                                continue;
                                            }
                                            var20_28 = null;
                                        }
                                        catch (Throwable throwable) {
                                            var20_28 = null;
                                            this.exdent();
                                            this.writeLineRaw("</PEER>");
                                            throw throwable;
                                        }
                                        this.exdent();
                                        this.writeLineRaw("</PEER>");
                                    }
                                }
                                var22_29 = null;
                            }
                            catch (Throwable throwable) {
                                var22_29 = null;
                                this.exdent();
                                this.writeLineRaw("</PEERS>");
                                throw throwable;
                            }
                            this.exdent();
                            this.writeLineRaw("</PEERS>");
                        }
                        var24_30 = null;
                    }
                    catch (Throwable throwable) {
                        var24_30 = null;
                        this.exdent();
                        throw throwable;
                    }
                    this.exdent();
                    this.writeLineRaw("</DOWNLOAD>");
                }
                Object var26_34 = null;
            }
            catch (Throwable throwable) {
                Object var26_35 = null;
                this.exdent();
                throw throwable;
            }
            this.exdent();
            this.writeLineRaw("</DOWNLOADS>");
            Object var28_37 = null;
        }
        catch (Throwable throwable) {
            Object var28_38 = null;
            this.exdent();
            throw throwable;
        }
        this.exdent();
        this.writeLineRaw("</STATS>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRawCookedTag(String tag, long raw) {
        this.writeLineRaw("<" + tag + ">");
        try {
            this.indent();
            this.writeTag("TEXT", DisplayFormatters.formatByteCountToKiBEtc(raw));
            this.writeTag("RAW", raw);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.exdent();
            throw throwable;
        }
        this.exdent();
        this.writeLineRaw("</" + tag + ">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRawCookedAverageTag(String tag, long raw) {
        this.writeLineRaw("<" + tag + ">");
        try {
            this.indent();
            this.writeTag("TEXT", DisplayFormatters.formatByteCountToKiBEtcPerSec(raw));
            this.writeTag("RAW", raw);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.exdent();
            throw throwable;
        }
        this.exdent();
        this.writeLineRaw("</" + tag + ">");
    }
}

