/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.dht;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerHelper;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TRTrackerDHTAnnouncerImpl
implements TRTrackerAnnouncerHelper {
    public static final LogIDs LOGID = LogIDs.TRACKER;
    private TOTorrent torrent;
    private HashWrapper torrent_hash;
    private TRTrackerAnnouncerImpl.Helper helper;
    private byte[] data_peer_id;
    private String tracker_status_str;
    private long last_update_time;
    private int state = 1;
    private TRTrackerAnnouncerResponseImpl last_response;
    private boolean manual;

    public TRTrackerDHTAnnouncerImpl(TOTorrent _torrent, String[] _networks, boolean _manual, TRTrackerAnnouncerImpl.Helper _helper) throws TRTrackerAnnouncerException {
        this.torrent = _torrent;
        this.manual = _manual;
        this.helper = _helper;
        try {
            this.torrent_hash = this.torrent.getHashWrapper();
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
        try {
            this.data_peer_id = ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent, false);
        }
        catch (ClientIDException e) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", e);
        }
        this.last_response = new TRTrackerAnnouncerResponseImpl(this.torrent.getAnnounceURL(), this.torrent_hash, 0, 0L, "Initialising");
        this.tracker_status_str = MessageText.getString("PeerManager.status.checking") + "...";
    }

    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider provider2) {
    }

    public boolean isManual() {
        return this.manual;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public URL getTrackerURL() {
        return TorrentUtils.getDecentralisedURL(this.torrent);
    }

    public void setTrackerURL(URL url) {
        Debug.out("Not implemented");
    }

    public TOTorrentAnnounceURLSet[] getAnnounceSets() {
        return new TOTorrentAnnounceURLSet[]{this.torrent.getAnnounceURLGroup().createAnnounceURLSet(new URL[]{TorrentUtils.getDecentralisedURL(this.torrent)})};
    }

    public void resetTrackerUrl(boolean shuffle) {
    }

    public void setIPOverride(String override) {
    }

    public void clearIPOverride() {
    }

    public int getPort() {
        return 0;
    }

    public byte[] getPeerId() {
        return this.data_peer_id;
    }

    public void setRefreshDelayOverrides(int percentage) {
    }

    public int getTimeUntilNextUpdate() {
        long elapsed = (SystemTime.getCurrentTime() - this.last_update_time) / 1000L;
        return (int)(this.last_response.getTimeToWait() - elapsed);
    }

    public int getLastUpdateTime() {
        return (int)(this.last_update_time / 1000L);
    }

    public void update(boolean force) {
        this.state = 2;
    }

    public void complete(boolean already_reported) {
        this.state = 3;
    }

    public void stop(boolean for_queue) {
        this.state = 4;
    }

    public void destroy() {
    }

    public int getStatus() {
        return this.state;
    }

    public String getStatusString() {
        return this.tracker_status_str;
    }

    public TRTrackerAnnouncer getBestAnnouncer() {
        return this;
    }

    public TRTrackerAnnouncerResponse getLastResponse() {
        return this.last_response;
    }

    public boolean isUpdating() {
        return false;
    }

    public long getInterval() {
        return -1L;
    }

    public long getMinInterval() {
        return -1L;
    }

    public void refreshListeners() {
    }

    public void setAnnounceResult(DownloadAnnounceResult result) {
        TRTrackerAnnouncerResponsePeer[] cached_peers;
        TRTrackerAnnouncerResponseImpl response;
        this.last_update_time = SystemTime.getCurrentTime();
        if (result.getResponseType() == 2) {
            this.tracker_status_str = MessageText.getString("PeerManager.status.error");
            String reason = result.getError();
            if (reason != null) {
                this.tracker_status_str = this.tracker_status_str + " (" + reason + ")";
            }
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash, 0, result.getTimeToWait(), reason);
        } else {
            DownloadAnnounceResultPeer[] ext_peers = result.getPeers();
            ArrayList<TRTrackerAnnouncerResponsePeerImpl> peers_list = new ArrayList<TRTrackerAnnouncerResponsePeerImpl>(ext_peers.length);
            for (int i = 0; i < ext_peers.length; ++i) {
                DownloadAnnounceResultPeer ext_peer = ext_peers[i];
                if (ext_peer == null) continue;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "EXTERNAL PEER DHT: ip=" + ext_peer.getAddress() + ",port=" + ext_peer.getPort() + ",prot=" + ext_peer.getProtocol()));
                }
                int http_port = 0;
                byte az_version = 1;
                peers_list.add(new TRTrackerAnnouncerResponsePeerImpl(ext_peer.getSource(), ext_peer.getPeerID(), ext_peer.getAddress(), ext_peer.getPort(), ext_peer.getUDPPort(), http_port, ext_peer.getProtocol(), az_version, 0));
            }
            TRTrackerAnnouncerResponsePeer[] peers = peers_list.toArray(new TRTrackerAnnouncerResponsePeerImpl[peers_list.size()]);
            this.helper.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])peers);
            this.tracker_status_str = MessageText.getString("PeerManager.status.ok");
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash, 2, result.getTimeToWait(), peers);
        }
        this.last_response = response;
        TRTrackerAnnouncerResponsePeer[] peers = response.getPeers();
        if ((peers == null || peers.length < 5) && (cached_peers = this.helper.getPeersFromCache(100)).length > 0) {
            TreeSet<TRTrackerAnnouncerResponsePeer> new_peers = new TreeSet<TRTrackerAnnouncerResponsePeer>(new Comparator<TRTrackerAnnouncerResponsePeer>(){

                @Override
                public int compare(TRTrackerAnnouncerResponsePeer o1, TRTrackerAnnouncerResponsePeer o2) {
                    return o1.compareTo(o2);
                }
            });
            if (peers != null) {
                new_peers.addAll(Arrays.asList(peers));
            }
            new_peers.addAll(Arrays.asList(cached_peers));
            response.setPeers(new_peers.toArray(new TRTrackerAnnouncerResponsePeer[new_peers.size()]));
        }
        this.helper.informResponse(this, response);
    }

    public void addListener(TRTrackerAnnouncerListener l) {
        this.helper.addListener(l);
    }

    public void removeListener(TRTrackerAnnouncerListener l) {
        this.helper.removeListener(l);
    }

    public void setTrackerResponseCache(Map map) {
        this.helper.setTrackerResponseCache(map);
    }

    public void removeFromTrackerResponseCache(String ip, int tcpPort) {
        this.helper.removeFromTrackerResponseCache(ip, tcpPort);
    }

    public Map getTrackerResponseCache() {
        return this.helper.getTrackerResponseCache();
    }

    public TrackerPeerSource getTrackerPeerSource(TOTorrentAnnounceURLSet set) {
        Debug.out("not implemented");
        return null;
    }

    public TrackerPeerSource getCacheTrackerPeerSource() {
        Debug.out("not implemented");
        return null;
    }

    public void generateEvidence(IndentWriter writer) {
        writer.println("DHT announce: " + (this.last_response == null ? "null" : this.last_response.getString()));
    }
}

