/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServer;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class TRNonBlockingServerProcessor
extends TRTrackerServerProcessorTCP {
    private static final int MAX_POST = 262144;
    private static final int READ_BUFFER_INITIAL = 1024;
    private static final int READ_BUFFER_INCREMENT = 1024;
    private static final int READ_BUFFER_LIMIT = 32768;
    private SocketChannel socket_channel;
    private VirtualChannelSelector.VirtualSelectorListener read_listener;
    private VirtualChannelSelector.VirtualSelectorListener write_listener;
    private long start_time;
    private ByteBuffer read_buffer;
    private ByteBuffer post_data_buffer;
    private String request_header;
    private String lc_request_header;
    private ByteBuffer write_buffer;
    private boolean keep_alive;

    protected TRNonBlockingServerProcessor(TRTrackerServerTCP _server, SocketChannel _socket) {
        super(_server);
        this.socket_channel = _socket;
        this.start_time = SystemTime.getCurrentTime();
        this.read_buffer = ByteBuffer.allocate(1024);
    }

    protected void setReadListener(VirtualChannelSelector.VirtualSelectorListener rl) {
        this.read_listener = rl;
    }

    protected VirtualChannelSelector.VirtualSelectorListener getReadListener() {
        return this.read_listener;
    }

    protected void setWriteListener(VirtualChannelSelector.VirtualSelectorListener wl) {
        this.write_listener = wl;
    }

    protected VirtualChannelSelector.VirtualSelectorListener getWriteListener() {
        return this.write_listener;
    }

    protected int processRead() {
        byte[] data;
        if (this.post_data_buffer != null) {
            try {
                int len = this.socket_channel.read(this.post_data_buffer);
                if (len < 0) {
                    return -1;
                }
                if (this.post_data_buffer.remaining() == 0) {
                    this.post_data_buffer.flip();
                    this.getServer().runProcessor(this);
                    return 0;
                }
                return 1;
            }
            catch (IOException e) {
                return -1;
            }
        }
        if (this.read_buffer.remaining() == 0) {
            int capacity = this.read_buffer.capacity();
            if (capacity == 32768) {
                return -1;
            }
            this.read_buffer.position(0);
            data = new byte[capacity];
            this.read_buffer.get(data);
            this.read_buffer = ByteBuffer.allocate(capacity + 1024);
            this.read_buffer.put(data);
        }
        try {
            int len = this.socket_channel.read(this.read_buffer);
            if (len < 0) {
                return -1;
            }
            if (len == 0) {
                return 2;
            }
            data = this.read_buffer.array();
            int array_offset = this.read_buffer.arrayOffset();
            int array_position = array_offset + this.read_buffer.position();
            for (int i = array_offset; i <= array_position - 4; ++i) {
                if (data[i] != 13 || data[i + 1] != 10 || data[i + 2] != 13 || data[i + 3] != 10) continue;
                int header_end = i + 4;
                int header_length = header_end - array_offset;
                this.request_header = new String(data, array_offset, header_length);
                this.lc_request_header = this.request_header.toLowerCase();
                int rem = array_position - header_end;
                if (rem == 0) {
                    this.read_buffer = ByteBuffer.allocate(1024);
                } else {
                    this.read_buffer = ByteBuffer.allocate(rem + 1024);
                    this.read_buffer.put(data, header_end, rem);
                }
                this.post_data_buffer = null;
                int pos1 = this.lc_request_header.indexOf("content-length");
                if (pos1 == -1) {
                    if (this.lc_request_header.contains("transfer-encoding") && this.lc_request_header.contains("chunked")) {
                        Debug.out("Chunked transfer-encoding not supported!!!!");
                    }
                } else {
                    int pos2 = this.lc_request_header.indexOf("\r\n", pos1);
                    String entry = pos2 == -1 ? this.lc_request_header.substring(pos1) : this.lc_request_header.substring(pos1, pos2);
                    int pos = entry.indexOf(58);
                    if (pos != -1) {
                        int content_length = 0;
                        try {
                            content_length = Integer.parseInt(entry.substring(pos + 1).trim());
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        if (content_length > 0) {
                            if (content_length > 262144) {
                                throw new IOException("content-length too large, max=262144");
                            }
                            this.post_data_buffer = ByteBuffer.allocate(content_length);
                            int buffer_position = this.read_buffer.position();
                            if (buffer_position > 0) {
                                byte[] already_read = new byte[Math.min(buffer_position, content_length)];
                                this.read_buffer.flip();
                                this.read_buffer.get(already_read);
                                byte[] xrem = new byte[this.read_buffer.remaining()];
                                this.read_buffer.get(xrem);
                                this.read_buffer = ByteBuffer.allocate(xrem.length + 1024);
                                this.read_buffer.put(xrem);
                                this.post_data_buffer.put(already_read);
                                if (this.post_data_buffer.remaining() == 0) {
                                    this.getServer().runProcessor(this);
                                    return 0;
                                }
                            }
                        }
                    }
                }
                if (this.post_data_buffer == null) {
                    this.getServer().runProcessor(this);
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    protected int processWrite() {
        if (this.write_buffer == null) {
            return -1;
        }
        if (!this.write_buffer.hasRemaining()) {
            this.writeComplete();
            return 0;
        }
        try {
            int written = this.socket_channel.write(this.write_buffer);
            if (written == 0) {
                return 2;
            }
            if (this.write_buffer.hasRemaining()) {
                return 1;
            }
            this.writeComplete();
            return 0;
        }
        catch (IOException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSupport() {
        boolean async = false;
        try {
            try {
                String url = this.request_header.substring(this.request_header.indexOf(32)).trim();
                int pos = url.indexOf(" ");
                url = url.substring(0, pos);
                final AESemaphore[] went_async = new AESemaphore[]{null};
                final ByteArrayOutputStream[] async_stream = new ByteArrayOutputStream[]{null};
                AsyncController async_control = new AsyncController(){

                    public void setAsyncStart() {
                        went_async[0] = new AESemaphore("async");
                    }

                    public void setAsyncComplete() {
                        went_async[0].reserve();
                        TRNonBlockingServerProcessor.this.asyncProcessComplete(async_stream[0]);
                    }
                };
                try {
                    ByteArrayOutputStream response = this.process(this.request_header, this.lc_request_header, url, (InetSocketAddress)this.socket_channel.socket().getRemoteSocketAddress(), this.getServer().getRestrictNonBlocking(), new ByteArrayInputStream(new byte[0]), async_control);
                    if (response == null) {
                        async = true;
                    } else if (went_async[0] != null) {
                        async_stream[0] = response;
                        async = true;
                    } else {
                        this.write_buffer = ByteBuffer.wrap(response.toByteArray());
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (went_async[0] != null) {
                        went_async[0].release();
                    }
                    throw throwable;
                }
                if (went_async[0] != null) {
                    went_async[0].release();
                }
                Object var11_12 = null;
                if (!async) {
                    ((TRNonBlockingServer)this.getServer()).readyToWrite(this);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (!async) {
                    ((TRNonBlockingServer)this.getServer()).readyToWrite(this);
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!async) {
                ((TRNonBlockingServer)this.getServer()).readyToWrite(this);
            }
            throw throwable;
        }
    }

    protected abstract ByteArrayOutputStream process(String var1, String var2, String var3, InetSocketAddress var4, boolean var5, InputStream var6, AsyncController var7) throws IOException;

    protected void asyncProcessComplete(ByteArrayOutputStream response) {
        this.write_buffer = ByteBuffer.wrap(response.toByteArray());
        ((TRNonBlockingServer)this.getServer()).readyToWrite(this);
    }

    protected SocketChannel getSocketChannel() {
        return this.socket_channel;
    }

    protected byte[] getPostData() {
        ByteBuffer result = this.post_data_buffer;
        if (result == null) {
            return null;
        }
        this.post_data_buffer = null;
        return result.array();
    }

    protected long getStartTime() {
        return this.start_time;
    }

    protected boolean getKeepAlive() {
        return this.keep_alive;
    }

    protected void setKeepAlive(boolean k) {
        this.keep_alive = k;
    }

    public boolean isActive() {
        return !this.socket_channel.socket().isClosed();
    }

    public void interruptTask() {
    }

    protected void failed() {
    }

    protected void writeComplete() {
        if (this.keep_alive) {
            this.start_time = SystemTime.getCurrentTime();
        }
    }

    protected void completed() {
    }

    protected void closed() {
    }
}

