/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactory;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationAdapter;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationListener;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWCHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerWebContextImpl
extends TrackerWCHelper
implements TRTrackerServerListener2,
TRTrackerServerAuthenticationListener {
    protected TRTrackerServer server;
    protected List<TrackerAuthenticationListener> auth_listeners = new ArrayList<TrackerAuthenticationListener>();

    public TrackerWebContextImpl(TrackerImpl _tracker, String name, int port, int protocol, InetAddress bind_ip, Map<String, Object> properties) throws TrackerException {
        this.setTracker(_tracker);
        try {
            this.server = protocol == 1 ? TRTrackerServerFactory.create(name, 1, port, bind_ip, false, false, properties) : TRTrackerServerFactory.createSSL(name, 1, port, bind_ip, false, false, properties);
            this.server.addListener2(this);
        }
        catch (TRTrackerServerException e) {
            throw new TrackerException("TRTrackerServerFactory failed", e);
        }
    }

    @Override
    public String getName() {
        return this.server.getName();
    }

    @Override
    public void setEnableKeepAlive(boolean enable) {
        this.server.setEnableKeepAlive(enable);
    }

    @Override
    public URL[] getURLs() {
        try {
            URL url = new URL((this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + "/");
            if (url.getPort() != this.server.getPort()) {
                Debug.out("Invalid URL '" + url + "' - check tracker configuration");
                url = new URL("http://i.am.invalid:" + this.server.getPort() + "/");
            }
            return new URL[]{url};
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    @Override
    public InetAddress getBindIP() {
        return this.server.getBindIP();
    }

    @Override
    public boolean authenticate(String headers, URL resource, String user, String password) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                TrackerAuthenticationListener listener = this.auth_listeners.get(i);
                boolean res = listener instanceof TrackerAuthenticationAdapter ? ((TrackerAuthenticationAdapter)listener).authenticate(headers, resource, user, password) : listener.authenticate(resource, user, password);
                if (!res) continue;
                return true;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    @Override
    public byte[] authenticate(URL resource, String user) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                byte[] res = this.auth_listeners.get(i).authenticate(resource, user);
                if (res == null) continue;
                return res;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(l);
            if (this.auth_listeners.size() == 1) {
                this.server.addAuthenticationListener(this);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(l);
            if (this.auth_listeners.size() == 0) {
                this.server.removeAuthenticationListener(this);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.auth_listeners.clear();
        this.server.removeAuthenticationListener(this);
        this.server.close();
    }
}

