/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

import java.util.Properties;
import java.util.Random;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginState;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTManager;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.ipc.IPCInterface;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.plugins.platform.PlatformManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.PluginConfigUIFactory;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.ShortCuts;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPPluginConfig;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadManager;
import org.gudy.azureus2.pluginsimpl.remote.ipfilter.RPIPFilter;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrentManager;
import org.gudy.azureus2.pluginsimpl.remote.tracker.RPTracker;
import org.gudy.azureus2.pluginsimpl.remote.utils.RPShortCuts;

public class RPPluginInterface
extends RPObject
implements PluginInterface {
    protected static transient long connection_id_next = new Random().nextLong();
    protected transient PluginInterface delegate;
    protected transient long request_id_next;
    public String azureus_name = "Azureus";
    public String azureus_version = "5.6.1.3_B16";
    public long _connection_id;

    public static RPPluginInterface create(PluginInterface _delegate) {
        RPPluginInterface res = (RPPluginInterface)RPPluginInterface._lookupLocal(_delegate);
        if (res == null) {
            res = new RPPluginInterface(_delegate);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RPPluginInterface(PluginInterface _delegate) {
        super(_delegate);
        Class<RPPluginInterface> clazz = RPPluginInterface.class;
        synchronized (RPPluginInterface.class) {
            this._connection_id = connection_id_next++;
            if (this._connection_id == 0L) {
                this._connection_id = connection_id_next++;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected long _getConectionId() {
        return this._connection_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _getNextRequestId() {
        RPPluginInterface rPPluginInterface = this;
        synchronized (rPPluginInterface) {
            return this.request_id_next++;
        }
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (PluginInterface)_delegate;
    }

    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        if (method.equals("getPluginProperties")) {
            Properties p = new Properties();
            Properties x = this.delegate.getPluginProperties();
            for (Object key : x.keySet()) {
                p.put(key, x.get(key));
            }
            return new RPReply(p);
        }
        if (method.equals("getDownloadManager")) {
            return new RPReply(RPDownloadManager.create(this.delegate.getDownloadManager()));
        }
        if (method.equals("getTorrentManager")) {
            return new RPReply(RPTorrentManager.create(this.delegate.getTorrentManager()));
        }
        if (method.equals("getPluginconfig")) {
            return new RPReply(RPPluginConfig.create(this.delegate.getPluginconfig()));
        }
        if (method.equals("getIPFilter")) {
            return new RPReply(RPIPFilter.create(this.delegate.getIPFilter()));
        }
        if (method.equals("getShortCuts")) {
            return new RPReply(RPShortCuts.create(this.delegate.getShortCuts()));
        }
        if (method.equals("getTracker")) {
            return new RPReply(RPTracker.create(this.delegate.getTracker()));
        }
        throw new RPException("Unknown method: " + method);
    }

    public PluginManager getPluginManager() {
        this.notSupported();
        return null;
    }

    public Plugin getPlugin() {
        this.notSupported();
        return null;
    }

    public String getAzureusName() {
        return this.azureus_name;
    }

    public String getAzureusVersion() {
        return this.azureus_version;
    }

    public String getApplicationName() {
        return Constants.APP_NAME;
    }

    public void addConfigUIParameters(Parameter[] parameters, String displayName) {
        this.notSupported();
    }

    public void addConfigSection(ConfigSection tab) {
        this.notSupported();
    }

    public void removeConfigSection(ConfigSection tab) {
        this.notSupported();
    }

    public Tracker getTracker() {
        RPTracker res = (RPTracker)this._dispatcher.dispatch(new RPRequest(this, "getTracker", null)).getResponse();
        res._setRemote(this._dispatcher);
        return res;
    }

    public Logger getLogger() {
        this.notSupported();
        return null;
    }

    public IPFilter getIPFilter() {
        RPIPFilter res = (RPIPFilter)this._dispatcher.dispatch(new RPRequest(this, "getIPFilter", null)).getResponse();
        res._setRemote(this._dispatcher);
        return res;
    }

    public DownloadManager getDownloadManager() {
        RPDownloadManager res = (RPDownloadManager)this._dispatcher.dispatch(new RPRequest(this, "getDownloadManager", null)).getResponse();
        res._setRemote(this._dispatcher);
        return res;
    }

    public ShareManager getShareManager() throws ShareException {
        this.notSupported();
        return null;
    }

    public Utilities getUtilities() {
        this.notSupported();
        return null;
    }

    public ShortCuts getShortCuts() {
        RPShortCuts res = (RPShortCuts)this._dispatcher.dispatch(new RPRequest(this, "getShortCuts", null)).getResponse();
        res._setRemote(this._dispatcher);
        return res;
    }

    public UIManager getUIManager() {
        this.notSupported();
        return null;
    }

    public TorrentManager getTorrentManager() {
        RPTorrentManager res = (RPTorrentManager)this._dispatcher.dispatch(new RPRequest(this, "getTorrentManager", null)).getResponse();
        res._setRemote(this._dispatcher);
        return res;
    }

    public void openTorrentFile(String fileName) {
        this.notSupported();
    }

    public void openTorrentURL(String url) {
        this.notSupported();
    }

    public Properties getPluginProperties() {
        return (Properties)this._dispatcher.dispatch(new RPRequest(this, "getPluginProperties", null)).getResponse();
    }

    public String getPluginDirectoryName() {
        this.notSupported();
        return null;
    }

    public String getPerUserPluginDirectoryName() {
        this.notSupported();
        return null;
    }

    public boolean isShared() {
        this.notSupported();
        return false;
    }

    public String getPluginName() {
        this.notSupported();
        return null;
    }

    public String getPluginID() {
        this.notSupported();
        return null;
    }

    public boolean isMandatory() {
        this.notSupported();
        return false;
    }

    public boolean isBuiltIn() {
        this.notSupported();
        return false;
    }

    public boolean isSigned() {
        this.notSupported();
        return false;
    }

    public boolean isOperational() {
        this.notSupported();
        return false;
    }

    public void setDisabled(boolean disabled) {
        this.notSupported();
    }

    public boolean isDisabled() {
        this.notSupported();
        return false;
    }

    public String getPluginVersion() {
        this.notSupported();
        return null;
    }

    public PluginConfig getPluginconfig() {
        RPPluginConfig res = (RPPluginConfig)this._dispatcher.dispatch(new RPRequest(this, "getPluginconfig", null)).getResponse();
        res._setRemote(this._dispatcher);
        return res;
    }

    public PluginConfigUIFactory getPluginConfigUIFactory() {
        this.notSupported();
        return null;
    }

    public ClassLoader getPluginClassLoader() {
        this.notSupported();
        return null;
    }

    public PluginInterface getLocalPluginInterface(Class plugin, String id) {
        this.notSupported();
        return null;
    }

    public IPCInterface getIPC() {
        this.notSupported();
        return null;
    }

    public UpdateManager getUpdateManager() {
        this.notSupported();
        return null;
    }

    public boolean isUnloadable() {
        this.notSupported();
        return false;
    }

    public void unload() throws PluginException {
        this.notSupported();
    }

    public void reload() throws PluginException {
        this.notSupported();
    }

    public void uninstall() throws PluginException {
        this.notSupported();
    }

    public boolean isInitialisationThread() {
        this.notSupported();
        return false;
    }

    public ClientIDManager getClientIDManager() {
        this.notSupported();
        return null;
    }

    public ConnectionManager getConnectionManager() {
        this.notSupported();
        return null;
    }

    public MessageManager getMessageManager() {
        this.notSupported();
        return null;
    }

    public DistributedDatabase getDistributedDatabase() {
        this.notSupported();
        return null;
    }

    public PlatformManager getPlatformManager() {
        this.notSupported();
        return null;
    }

    public void addListener(PluginListener l) {
        this.notSupported();
    }

    public void removeListener(PluginListener l) {
        this.notSupported();
    }

    public void firePluginEvent(PluginEvent event2) {
        this.notSupported();
    }

    public void addEventListener(PluginEventListener l) {
        this.notSupported();
    }

    public void removeEventListener(PluginEventListener l) {
        this.notSupported();
    }

    public ConfigSection[] getConfigSections() {
        return null;
    }

    public MainlineDHTManager getMainlineDHTManager() {
        this.notSupported();
        return null;
    }

    public PluginState getPluginState() {
        this.notSupported();
        return null;
    }
}

