/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIInputValidator;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.pluginsimpl.AbstractUISWTInputReceiver;

public class SimpleTextEntryWindow
extends AbstractUISWTInputReceiver {
    private Display display;
    private Shell shell;
    private int textLimit;
    private Combo text_entry_combo;
    private Text text_entry_text;

    public SimpleTextEntryWindow() {
    }

    public SimpleTextEntryWindow(String sTitleKey, String sLabelKey) {
        this.setTitle(sTitleKey);
        this.setMessage(sLabelKey);
    }

    public SimpleTextEntryWindow(String sTitleKey, String sLabelKey, boolean bMultiLine) {
        this.setTitle(sTitleKey);
        this.setMessage(sLabelKey);
        this.setMultiLine(bMultiLine);
    }

    public void initTexts(String sTitleKey, String[] p0, String sLabelKey, String[] p1) {
        this.setLocalisedTitle(MessageText.getString(sTitleKey, p0));
        this.setLocalisedMessage(MessageText.getString(sLabelKey, p1));
    }

    protected void promptForInput() {
        Utils.execSWTThread(new Runnable(){

            public void run() {
                SimpleTextEntryWindow.this.promptForInput0();
                if (SimpleTextEntryWindow.this.receiver_listener == null) {
                    while (SimpleTextEntryWindow.this.shell != null && !SimpleTextEntryWindow.this.shell.isDisposed()) {
                        if (SimpleTextEntryWindow.this.display.readAndDispatch()) continue;
                        SimpleTextEntryWindow.this.display.sleep();
                    }
                }
            }
        }, this.receiver_listener != null);
    }

    private void promptForInput0() {
        Button ok;
        Button cancel;
        Text text_entry;
        int text_entry_flags;
        Shell parent = Display.getDefault().getActiveShell();
        if (parent == null) {
            parent = Utils.findAnyShell();
        }
        this.shell = ShellFactory.createShell(parent, 2144);
        this.display = this.shell.getDisplay();
        if (this.title != null) {
            this.shell.setText(this.title);
        }
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        this.shell.setLayout((Layout)layout);
        int width_hint = this.width_hint == -1 ? 330 : this.width_hint;
        Label label = null;
        GridData gridData = null;
        for (int i = 0; i < this.messages.length; ++i) {
            label = new Label((Composite)this.shell, 64);
            label.setText(this.messages[i]);
            gridData = new GridData();
            gridData.widthHint = width_hint;
            label.setLayoutData((Object)gridData);
        }
        if (this.choices != null) {
            text_entry_flags = 4;
            if (!this.choices_allow_edit) {
                text_entry_flags |= 8;
            }
            this.text_entry_combo = new Combo((Composite)this.shell, text_entry_flags);
            this.text_entry_combo.setItems(this.choices);
            if (this.textLimit > 0) {
                this.text_entry_combo.setTextLimit(this.textLimit);
            }
            this.text_entry_text = null;
            text_entry = this.text_entry_combo;
        } else {
            text_entry_flags = 2048;
            text_entry_flags = this.multiline_mode ? (text_entry_flags |= 0x242) : (text_entry_flags |= 4);
            this.text_entry_text = new Text((Composite)this.shell, text_entry_flags);
            if (this.textLimit > 0) {
                this.text_entry_text.setTextLimit(this.textLimit);
            }
            this.text_entry_combo = null;
            text_entry = this.text_entry_text;
        }
        if (this.preentered_text != null) {
            if (this.text_entry_text != null) {
                this.text_entry_text.setText(this.preentered_text);
                if (this.select_preentered_text) {
                    int[] range = this.select_preentered_text_range;
                    if (range == null || range.length != 2) {
                        this.text_entry_text.selectAll();
                    } else {
                        try {
                            this.text_entry_text.setSelection(range[0], range[1]);
                        }
                        catch (Throwable e) {
                            this.text_entry_text.selectAll();
                        }
                    }
                }
            } else if (this.text_entry_combo != null) {
                this.text_entry_combo.setText(this.preentered_text);
            }
        }
        text_entry.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        text_entry.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int key = e.character;
                if (key <= 26 && key > 0) {
                    key += 96;
                }
                if (key == 97 && e.stateMask == SWT.MOD1 && SimpleTextEntryWindow.this.text_entry_text != null) {
                    SimpleTextEntryWindow.this.text_entry_text.selectAll();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        int line_height = this.line_height;
        if (line_height == -1) {
            line_height = this.multiline_mode ? 3 : 1;
        }
        gridData = new GridData();
        gridData.widthHint = width_hint;
        if (this.text_entry_text != null) {
            gridData.minimumHeight = this.text_entry_text.getLineHeight() * line_height;
        }
        gridData.heightHint = gridData.minimumHeight;
        text_entry.setLayoutData((Object)gridData);
        Composite panel = new Composite((Composite)this.shell, 0);
        RowLayout rLayout = new RowLayout();
        rLayout.marginTop = 0;
        rLayout.marginLeft = 0;
        rLayout.marginBottom = 0;
        rLayout.marginRight = 0;
        try {
            rLayout.fill = true;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        rLayout.spacing = Utils.BUTTON_MARGIN;
        panel.setLayout((Layout)rLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        panel.setLayoutData((Object)gridData);
        if (Constants.isOSX) {
            cancel = SimpleTextEntryWindow.createAlertButton(panel, "Button.cancel");
            ok = SimpleTextEntryWindow.createAlertButton(panel, "Button.ok");
        } else {
            ok = SimpleTextEntryWindow.createAlertButton(panel, "Button.ok");
            cancel = SimpleTextEntryWindow.createAlertButton(panel, "Button.cancel");
        }
        ok.addListener(13, new Listener(){

            private void showError(String text) {
                String error_title = SimpleTextEntryWindow.this.title;
                if (error_title == null) {
                    error_title = "";
                }
                MessageBox mb = new MessageBox(SimpleTextEntryWindow.this.shell, 33);
                mb.setText(error_title);
                mb.setMessage(text);
                mb.open();
            }

            public void handleEvent(Event event2) {
                try {
                    String validate_result;
                    String entered_data = "";
                    if (SimpleTextEntryWindow.this.text_entry_text != null) {
                        entered_data = SimpleTextEntryWindow.this.text_entry_text.getText();
                    } else if (SimpleTextEntryWindow.this.text_entry_combo != null) {
                        entered_data = SimpleTextEntryWindow.this.text_entry_combo.getText();
                    }
                    if (!SimpleTextEntryWindow.this.maintain_whitespace) {
                        entered_data = entered_data.trim();
                    }
                    if (SimpleTextEntryWindow.this.textLimit > 0 && entered_data.length() > SimpleTextEntryWindow.this.textLimit) {
                        entered_data = entered_data.substring(0, SimpleTextEntryWindow.this.textLimit);
                    }
                    if (!SimpleTextEntryWindow.this.allow_empty_input && entered_data.length() == 0) {
                        this.showError(MessageText.getString("UI.cannot_submit_blank_text"));
                        return;
                    }
                    UIInputValidator validator = SimpleTextEntryWindow.this.validator;
                    if (validator != null && (validate_result = validator.validate(entered_data)) != null) {
                        this.showError(MessageText.getString(validate_result));
                        return;
                    }
                    SimpleTextEntryWindow.this.recordUserInput(entered_data);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    SimpleTextEntryWindow.this.recordUserAbort();
                }
                SimpleTextEntryWindow.this.shell.dispose();
            }
        });
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                SimpleTextEntryWindow.this.recordUserAbort();
                SimpleTextEntryWindow.this.shell.dispose();
            }
        });
        this.shell.setDefaultButton(ok);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    SimpleTextEntryWindow.this.recordUserAbort();
                    SimpleTextEntryWindow.this.shell.dispose();
                }
            }
        });
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                if (!SimpleTextEntryWindow.this.isResultRecorded()) {
                    SimpleTextEntryWindow.this.recordUserAbort();
                }
                SimpleTextEntryWindow.this.triggerReceiverListener();
            }
        });
        this.shell.pack();
        if (this.text_entry_text != null) {
            Utils.createURLDropTarget((Composite)this.shell, this.text_entry_text);
        }
        Utils.centreWindow(this.shell, false);
        this.shell.open();
    }

    private static Button createAlertButton(Composite panel, String localizationKey) {
        Button button = new Button(panel, 8);
        button.setText(MessageText.getString(localizationKey));
        RowData rData = new RowData();
        rData.width = Math.max(Utils.BUTTON_MINWIDTH, button.computeSize((int)-1, (int)-1).x);
        button.setLayoutData((Object)rData);
        return button;
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SimpleTextEntryWindow.this.text_entry_combo != null && !SimpleTextEntryWindow.this.text_entry_combo.isDisposed()) {
                    SimpleTextEntryWindow.this.text_entry_combo.setTextLimit(SimpleTextEntryWindow.this.textLimit);
                }
                if (SimpleTextEntryWindow.this.text_entry_text != null && !SimpleTextEntryWindow.this.text_entry_text.isDisposed()) {
                    SimpleTextEntryWindow.this.text_entry_text.setTextLimit(SimpleTextEntryWindow.this.textLimit);
                }
            }
        });
    }
}

