/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;

public class ConfigParameterAdapter
extends GenericParameterAdapter {
    private static final int CHANGINGCOUNT_BREAKER = 5;
    private Parameter owner;
    private int changingCount = 0;
    private boolean changedExternally = false;

    protected ConfigParameterAdapter(Parameter _owner, final String configID) {
        this.owner = _owner;
        COConfigurationManager.addParameterListener(configID, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                try {
                    if (!ConfigParameterAdapter.this.owner.isInitialised()) {
                        return;
                    }
                    if (ConfigParameterAdapter.this.owner.isDisposed()) {
                        COConfigurationManager.removeParameterListener(parameterName, this);
                        return;
                    }
                    ConfigParameterAdapter.this.informChanged(true);
                    Object valueObject = ConfigParameterAdapter.this.owner.getValueObject();
                    if (valueObject instanceof Boolean) {
                        boolean b = COConfigurationManager.getBooleanParameter(parameterName);
                        ConfigParameterAdapter.this.owner.setValue(new Boolean(b));
                    } else if (valueObject instanceof Integer) {
                        int i = COConfigurationManager.getIntParameter(parameterName);
                        ConfigParameterAdapter.this.owner.setValue(new Integer(i));
                    } else if (valueObject instanceof String) {
                        String s = COConfigurationManager.getStringParameter(parameterName);
                        ConfigParameterAdapter.this.owner.setValue(s);
                    }
                }
                catch (Exception e) {
                    Debug.out("parameterChanged trigger from ConfigParamAdapter " + configID, e);
                }
            }
        });
    }

    public int getIntValue(String key) {
        return COConfigurationManager.getIntParameter(key);
    }

    public int getIntValue(String key, int def) {
        return COConfigurationManager.getIntParameter(key, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntValue(String key, int value) {
        block5: {
            if (this.changingCount == 0) {
                this.changedExternally = false;
            }
            ++this.changingCount;
            try {
                if (this.getIntValue(key) == value) {
                    this.changedExternally = true;
                    Object var4_3 = null;
                    --this.changingCount;
                    return;
                }
                if (this.changingCount > 5) {
                    Debug.out("Preventing StackOverflow on setting " + key + " to " + value + " (was " + this.getIntValue(key) + ") via " + Debug.getCompressedStackTrace());
                    this.changingCount = 1;
                    break block5;
                }
                this.informChanging(value);
                if (this.changedExternally) break block5;
                COConfigurationManager.setParameter(key, value);
                this.changedExternally = true;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                --this.changingCount;
                throw throwable;
            }
        }
        Object var4_4 = null;
        --this.changingCount;
        {
        }
    }

    public boolean resetIntDefault(String key) {
        if (COConfigurationManager.doesParameterDefaultExist(key)) {
            COConfigurationManager.removeParameter(key);
            return true;
        }
        return false;
    }

    public boolean getBooleanValue(String key) {
        return COConfigurationManager.getBooleanParameter(key);
    }

    public boolean getBooleanValue(String key, boolean def) {
        return COConfigurationManager.getBooleanParameter(key, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBooleanValue(String key, boolean value) {
        block5: {
            if (this.changingCount == 0) {
                this.changedExternally = false;
            }
            ++this.changingCount;
            try {
                if (this.getBooleanValue(key) == value && (COConfigurationManager.doesParameterNonDefaultExist(key) || COConfigurationManager.doesParameterDefaultExist(key))) {
                    this.changedExternally = true;
                    Object var4_3 = null;
                    --this.changingCount;
                    return;
                }
                if (this.changingCount > 5) {
                    Debug.out("Preventing StackOverflow on setting " + key + " to " + value + " (was " + this.getBooleanValue(key) + ") via " + Debug.getCompressedStackTrace());
                    this.changingCount = 1;
                    break block5;
                }
                this.informChanging(value);
                if (this.changedExternally) break block5;
                COConfigurationManager.setParameter(key, value);
                this.changedExternally = true;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                --this.changingCount;
                throw throwable;
            }
        }
        Object var4_4 = null;
        --this.changingCount;
        {
        }
    }

    public void informChanged(boolean internally) {
        if (this.owner.change_listeners != null) {
            for (int i = 0; i < this.owner.change_listeners.size(); ++i) {
                try {
                    ((ParameterChangeListener)this.owner.change_listeners.get(i)).parameterChanged(this.owner, internally);
                    continue;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public void informChanging(int toValue) {
        if (this.owner.change_listeners != null) {
            for (int i = 0; i < this.owner.change_listeners.size(); ++i) {
                try {
                    ParameterChangeListener l = (ParameterChangeListener)this.owner.change_listeners.get(i);
                    l.intParameterChanging(this.owner, toValue);
                    continue;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public void informChanging(boolean toValue) {
        if (this.owner.change_listeners != null) {
            for (int i = 0; i < this.owner.change_listeners.size(); ++i) {
                try {
                    ParameterChangeListener l = (ParameterChangeListener)this.owner.change_listeners.get(i);
                    l.booleanParameterChanging(this.owner, toValue);
                    continue;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public void informChanging(String toValue) {
        if (this.owner.change_listeners != null) {
            for (int i = 0; i < this.owner.change_listeners.size(); ++i) {
                try {
                    ParameterChangeListener l = (ParameterChangeListener)this.owner.change_listeners.get(i);
                    l.stringParameterChanging(this.owner, toValue);
                    continue;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public void informChanging(double toValue) {
        if (this.owner.change_listeners != null) {
            for (int i = 0; i < this.owner.change_listeners.size(); ++i) {
                try {
                    ParameterChangeListener l = (ParameterChangeListener)this.owner.change_listeners.get(i);
                    l.floatParameterChanging(this.owner, toValue);
                    continue;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }
}

