/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenFileOptions;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.subscriptions.SubscriptionManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSUtils;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorrentOpener {
    public static void openTorrent(String torrentFile) {
        TorrentOpener.openTorrent(torrentFile, new HashMap<String, Object>());
    }

    public static void openTorrent(final String torrentFile, final Map<String, Object> options) {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uif != null) {
                    uif.openTorrentOpenOptions(null, null, new String[]{torrentFile}, options);
                }
            }
        });
    }

    protected static void openTorrentsForTracking(final String path, final String[] fileNames) {
        CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                Display display = SWTThread.getInstance().getDisplay();
                if (display == null || display.isDisposed() || core == null) {
                    return;
                }
                new AEThread2("TorrentOpener"){

                    public void run() {
                        for (int i = 0; i < fileNames.length; ++i) {
                            try {
                                TOTorrent t = TorrentUtils.readFromFile(new File(path, fileNames[i]), true);
                                core.getTrackerHost().hostTorrent(t, true, true);
                                continue;
                            }
                            catch (Throwable e) {
                                Logger.log(new LogAlert(false, "Torrent open fails for '" + path + File.separator + fileNames[i] + "'", e));
                            }
                        }
                    }
                }.start();
            }
        });
    }

    public static void openTorrentTrackingOnly() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Shell shell = Utils.findAnyShell();
                if (shell == null) {
                    return;
                }
                FileDialog fDialog = new FileDialog(shell, 4098);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path == null) {
                    return;
                }
                TorrentOpener.openTorrentsForTracking(path, fDialog.getFileNames());
            }
        });
    }

    public static void openTorrentSimple() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Shell shell = Utils.findAnyShell();
                if (shell == null) {
                    return;
                }
                FileDialog fDialog = new FileDialog(shell, 4098);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path == null) {
                    return;
                }
                UIFunctionsManagerSWT.getUIFunctionsSWT().openTorrentOpenOptions(shell, path, fDialog.getFileNames(), false, false);
            }
        });
    }

    public static void openDroppedTorrents(DropTargetEvent event2, boolean deprecated_sharing_param) {
        UIFunctionsSWT uif;
        String link;
        Object data = event2.data;
        if (data == null) {
            return;
        }
        if (data instanceof String) {
            if (((String)data).contains("azcdid=" + RandomUtils.INSTANCE_ID)) {
                event2.detail = 0;
                return;
            }
        } else if (data instanceof URLTransfer.URLType && (link = ((URLTransfer.URLType)data).linkURL) != null && link.contains("azcdid=" + RandomUtils.INSTANCE_ID)) {
            event2.detail = 0;
            return;
        }
        if (event2.data instanceof String[] || event2.data instanceof String) {
            String[] stringArray;
            if (event2.data instanceof String[]) {
                stringArray = (String[])event2.data;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)event2.data;
            }
            String[] sourceNames = stringArray;
            if (event2.detail == 0) {
                return;
            }
            for (int i = 0; i < sourceNames.length; ++i) {
                final File source = new File(sourceNames[i]);
                String sURL = UrlUtils.parseTextForURL(sourceNames[i], true);
                if (sURL != null && !source.exists()) {
                    UIFunctionsSWT uif2 = UIFunctionsManagerSWT.getUIFunctionsSWT();
                    if (uif2 == null) continue;
                    uif2.openTorrentOpenOptions(null, null, new String[]{sURL}, false, false);
                    continue;
                }
                if (source.isFile()) {
                    new AEThread2("asyncOpen", true){

                        public void run() {
                            String filename = source.getAbsolutePath();
                            VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                            if (vfh.loadAndHandleVuzeFile(filename, 0) != null) {
                                return;
                            }
                            UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                            if (uif != null) {
                                uif.openTorrentOpenOptions(null, null, new String[]{filename}, false, false);
                            }
                        }
                    }.start();
                    continue;
                }
                if (!source.isDirectory()) continue;
                String dir_name = source.getAbsolutePath();
                UIFunctionsSWT uif3 = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uif3 == null) continue;
                uif3.openTorrentOpenOptions(null, dir_name, null, false, false);
            }
        } else if (event2.data instanceof URLTransfer.URLType && (uif = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null) {
            uif.openTorrentOpenOptions(null, null, new String[]{((URLTransfer.URLType)event2.data).linkURL}, false, false);
        }
    }

    public static String getFilterPathData() {
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.data");
        if (before != null && before.length() > 0) {
            return before;
        }
        try {
            String def = COConfigurationManager.getDirectoryParameter("Default save path");
            return def;
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getFilterPathTorrent() {
        String before = COConfigurationManager.getStringParameter("previous.filter.dir.torrent");
        if (before != null && before.length() > 0) {
            return before;
        }
        return COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
    }

    public static String setFilterPathData(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.data")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.data", now);
                COConfigurationManager.save();
            }
        }
        return path;
    }

    public static String setFilterPathTorrent(String path) {
        if (path != null && path.length() > 0) {
            String before;
            File test = new File(path);
            if (!test.isDirectory()) {
                test = test.getParentFile();
            }
            String now = "";
            if (test != null) {
                now = test.getAbsolutePath();
            }
            if ((before = COConfigurationManager.getStringParameter("previous.filter.dir.torrent")) == null || before.length() == 0 || !before.equals(now)) {
                COConfigurationManager.setParameter("previous.filter.dir.torrent", now);
                COConfigurationManager.save();
            }
            return now;
        }
        return path;
    }

    public static boolean doesDropHaveTorrents(DropTargetEvent event2) {
        boolean isTorrent = false;
        if (event2.data == null && event2.currentDataType != null) {
            FileTransfer ft = FileTransfer.getInstance();
            if (ft.isSupportedType(event2.currentDataType)) {
                String[] fileList;
                String[] stringArray;
                Object data = ft.nativeToJava(event2.currentDataType);
                if (data instanceof String) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)data;
                } else {
                    stringArray = fileList = (String[])data;
                }
                if (fileList != null) {
                    for (String file : fileList) {
                        if (!file.endsWith(".torrent") && !file.endsWith(".vuze")) continue;
                        isTorrent = true;
                        break;
                    }
                }
            } else {
                Object object = URLTransfer.getInstance().nativeToJava(event2.currentDataType);
                if (object instanceof URLTransfer.URLType) {
                    URLTransfer.URLType xfer = (URLTransfer.URLType)object;
                    String link = xfer.linkURL;
                    if (link == null || !link.contains("azcdid=" + RandomUtils.INSTANCE_ID)) {
                        isTorrent = true;
                    }
                }
            }
        } else if (!(event2.data instanceof String) || !((String)event2.data).contains("azcdid=" + RandomUtils.INSTANCE_ID)) {
            if (event2.data instanceof String[] || event2.data instanceof String) {
                String[] sourceNames;
                String[] stringArray;
                if (event2.data instanceof String[]) {
                    stringArray = (String[])event2.data;
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = (String)event2.data;
                }
                for (String name : sourceNames = stringArray) {
                    String sURL = UrlUtils.parseTextForURL(name, true);
                    if (sURL == null) continue;
                    isTorrent = true;
                    break;
                }
            } else if (event2.data instanceof URLTransfer.URLType) {
                URLTransfer.URLType xfer = (URLTransfer.URLType)event2.data;
                String link = xfer.linkURL;
                if (link == null || !link.contains("azcdid=" + RandomUtils.INSTANCE_ID)) {
                    isTorrent = true;
                }
            }
        }
        return isTorrent;
    }

    public static final boolean addTorrent(final TorrentOpenOptions torrentOptions) {
        try {
            if (torrentOptions.getTorrent() == null) {
                return false;
            }
            final DownloadManagerInitialisationAdapter dmia = new DownloadManagerInitialisationAdapter(){

                public int getActions() {
                    return 1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void initialised(DownloadManager dm, boolean for_seeding) {
                    DiskManagerFileInfoSet file_info_set = dm.getDiskManagerFileInfoSet();
                    DiskManagerFileInfo[] fileInfos = file_info_set.getFiles();
                    boolean reorder_mode = COConfigurationManager.getBooleanParameter("Enable reorder storage mode");
                    int reorder_mode_min_mb = COConfigurationManager.getIntParameter("Reorder storage mode min MB");
                    try {
                        Map<String, Boolean> enabledNetworks;
                        int maxDown;
                        int maxUp;
                        dm.getDownloadState().suppressStateSave(true);
                        boolean[] toSkip = new boolean[fileInfos.length];
                        boolean[] toCompact = new boolean[fileInfos.length];
                        boolean[] toReorderCompact = new boolean[fileInfos.length];
                        int[] priorities = null;
                        int comp_num = 0;
                        int reorder_comp_num = 0;
                        TorrentOpenFileOptions[] files = torrentOptions.getFiles();
                        for (int iIndex = 0; iIndex < fileInfos.length; ++iIndex) {
                            DiskManagerFileInfo fileInfo2 = fileInfos[iIndex];
                            if (iIndex < 0 || iIndex >= files.length || files[iIndex].lSize != fileInfo2.getLength()) continue;
                            File fDest = fileInfo2.getFile(true);
                            if (files[iIndex].isLinked()) {
                                fDest = files[iIndex].getDestFileFullName();
                                dm.getDownloadState().setFileLink(iIndex, fileInfo2.getFile(false), fDest);
                            }
                            if (files[iIndex].isToDownload()) {
                                int priority = files[iIndex].getPriority();
                                if (priority == 0) continue;
                                if (priorities == null) {
                                    priorities = new int[fileInfos.length];
                                }
                                priorities[iIndex] = priority;
                                continue;
                            }
                            toSkip[iIndex] = true;
                            if (fDest.exists()) continue;
                            if (reorder_mode && fileInfo2.getLength() / 0x100000L >= (long)reorder_mode_min_mb) {
                                toReorderCompact[iIndex] = true;
                                ++reorder_comp_num;
                                continue;
                            }
                            toCompact[iIndex] = true;
                            ++comp_num;
                        }
                        if (files.length == 1) {
                            String fileRename;
                            TorrentOpenFileOptions file = files[0];
                            if (file.isManualRename() && (fileRename = file.getDestFileName()) != null && fileRename.length() > 0) {
                                dm.getDownloadState().setDisplayName(fileRename);
                            }
                        } else {
                            String folderRename = torrentOptions.getManualRename();
                            if (folderRename != null && folderRename.length() > 0 && new File(torrentOptions.getParentDir()).getName().equals(folderRename)) {
                                dm.getDownloadState().setDisplayName(folderRename);
                            }
                        }
                        if (comp_num > 0) {
                            file_info_set.setStorageTypes(toCompact, 2);
                        }
                        if (reorder_comp_num > 0) {
                            file_info_set.setStorageTypes(toReorderCompact, 4);
                        }
                        file_info_set.setSkipped(toSkip, true);
                        if (priorities != null) {
                            file_info_set.setPriority(priorities);
                        }
                        if ((maxUp = torrentOptions.getMaxUploadSpeed()) > 0) {
                            dm.getStats().setUploadRateLimitBytesPerSecond(maxUp * 1024);
                        }
                        if ((maxDown = torrentOptions.getMaxDownloadSpeed()) > 0) {
                            dm.getStats().setDownloadRateLimitBytesPerSecond(maxDown * 1024);
                        }
                        if (torrentOptions.disableIPFilter) {
                            dm.getDownloadState().setFlag(256L, true);
                        }
                        if (torrentOptions.peerSource != null) {
                            for (String peerSource : torrentOptions.peerSource.keySet()) {
                                boolean enable = torrentOptions.peerSource.get(peerSource);
                                dm.getDownloadState().setPeerSourceEnabled(peerSource, enable);
                            }
                        }
                        if ((enabledNetworks = torrentOptions.getEnabledNetworks()) != null) {
                            for (String net : enabledNetworks.keySet()) {
                                boolean enable = enabledNetworks.get(net);
                                dm.getDownloadState().setNetworkEnabled(net, enable);
                            }
                        }
                        List<Tag> initialTags = torrentOptions.getInitialTags();
                        for (Tag t : initialTags) {
                            t.addTaggable(dm);
                        }
                        List<List<String>> trackers = torrentOptions.getTrackers(true);
                        if (trackers != null) {
                            TOTorrent torrent = dm.getTorrent();
                            TorrentUtils.listToAnnounceGroups(trackers, torrent);
                            try {
                                TorrentUtils.writeToFile(torrent);
                            }
                            catch (Throwable e2) {
                                Debug.printStackTrace(e2);
                            }
                        }
                        Object var22_31 = null;
                        dm.getDownloadState().suppressStateSave(false);
                    }
                    catch (Throwable throwable) {
                        Object var22_32 = null;
                        dm.getDownloadState().suppressStateSave(false);
                        throw throwable;
                    }
                }
            };
            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                public void azureusCoreRunning(AzureusCore core) {
                    TOTorrent torrent = torrentOptions.getTorrent();
                    byte[] hash = null;
                    try {
                        hash = torrent.getHash();
                    }
                    catch (TOTorrentException e1) {
                        // empty catch block
                    }
                    int iStartState = torrentOptions.getStartMode() == 1 ? 70 : 75;
                    GlobalManager gm = core.getGlobalManager();
                    DownloadManager dm = gm.addDownloadManager(torrentOptions.sFileName, hash, torrentOptions.getParentDir(), torrentOptions.getSubDir(), iStartState, true, torrentOptions.getStartMode() == 3, dmia);
                    if (dm == null) {
                        return;
                    }
                    if (torrentOptions.iQueueLocation == 0) {
                        gm.moveTop(new DownloadManager[]{dm});
                    }
                    if (torrentOptions.getStartMode() == 2) {
                        dm.setForceStart(true);
                    }
                }
            });
        }
        catch (Exception e) {
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            if (uif != null) {
                uif.showErrorMessage("OpenTorrentWindow.mb.openError", Debug.getStackTrace(e), new String[]{torrentOptions.sOriginatingLocation, e.getMessage()});
            }
            return false;
        }
        return true;
    }

    public static boolean mergeFileIntoTorrentInfo(String sFileName, String sOriginatingLocation, TorrentOpenOptions torrentOptions) {
        File torrentFile;
        TOTorrent torrent = null;
        boolean bDeleteFileOnCancel = false;
        try {
            File fOriginal;
            if (sFileName.startsWith("file://localhost/")) {
                sFileName = UrlUtils.decode(sFileName.substring(16));
            }
            if (!(fOriginal = new File(sFileName)).isFile() || !fOriginal.exists()) {
                UIFunctionsManager.getUIFunctions().showErrorMessage("OpenTorrentWindow.mb.openError", fOriginal.toString(), new String[]{UrlUtils.decode(sOriginatingLocation), "Not a File"});
                return false;
            }
            if (fOriginal.length() > 0x4000000L) {
                UIFunctionsManager.getUIFunctions().showErrorMessage("OpenTorrentWindow.mb.openError", fOriginal.toString(), new String[]{UrlUtils.decode(sOriginatingLocation), "Too large to be a torrent"});
                return false;
            }
            torrentFile = TorrentUtils.copyTorrentFileToSaveDir(fOriginal, true);
            bDeleteFileOnCancel = !fOriginal.equals(torrentFile);
        }
        catch (IOException e1) {
            torrentFile = new File(sFileName);
        }
        VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
        VuzeFile vf = vfh.loadVuzeFile(torrentFile);
        if (vf != null) {
            vfh.handleFiles(new VuzeFile[]{vf}, 0);
            return false;
        }
        if (RSSUtils.isRSSFeed(torrentFile)) {
            boolean done = false;
            try {
                URL url = new URL(sOriginatingLocation);
                UIManager ui_manager = StaticUtilities.getUIManager(10000L);
                if (ui_manager != null) {
                    String details = MessageText.getString("subscription.request.add.message", new String[]{sOriginatingLocation});
                    long res = ui_manager.showMessageBox("subscription.request.add.title", "!" + details + "!", 12L);
                    if (res == 4L) {
                        SubscriptionManager sm = PluginInitializer.getDefaultInterface().getUtilities().getSubscriptionManager();
                        sm.requestSubscription(url);
                        done = true;
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            if (done) {
                if (bDeleteFileOnCancel) {
                    torrentFile.delete();
                }
                return false;
            }
        }
        if (!TorrentUtil.isFileTorrent(torrentFile, torrentFile.getName(), !torrentOptions.getHideErrors())) {
            if (bDeleteFileOnCancel) {
                torrentFile.delete();
            }
            return false;
        }
        try {
            torrent = TorrentUtils.readFromFile(torrentFile, false);
        }
        catch (TOTorrentException e) {
            UIFunctionsManager.getUIFunctions().showErrorMessage("OpenTorrentWindow.mb.openError", Debug.getStackTrace(e), new String[]{sOriginatingLocation, e.getMessage()});
            if (bDeleteFileOnCancel) {
                torrentFile.delete();
            }
            return false;
        }
        torrentOptions.bDeleteFileOnCancel = bDeleteFileOnCancel;
        torrentOptions.sFileName = torrentFile.getAbsolutePath();
        torrentOptions.setTorrent(torrent);
        torrentOptions.sOriginatingLocation = sOriginatingLocation;
        return torrentOptions.getTorrent() != null;
    }

    public static void openTorrentsFromStrings(TorrentOpenOptions optionsToClone, Shell parent, String pathPrefix, String[] torrents, String referrer, TorrentDownloaderCallBackInterface listener, boolean forceTorrentOptionsWindow) {
        if (torrents == null || torrents.length == 0) {
            File[] listFiles;
            if (pathPrefix == null) {
                return;
            }
            File path = new File(pathPrefix);
            if (!path.isDirectory()) {
                return;
            }
            ArrayList<String> newTorrents = new ArrayList<String>();
            for (File file : listFiles = path.listFiles()) {
                try {
                    if (!file.isFile() || !TorrentUtils.isTorrentFile(file.getAbsolutePath())) continue;
                    newTorrents.add(file.getName());
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (newTorrents.size() == 0) {
                return;
            }
            torrents = newTorrents.toArray(new String[0]);
        }
        final VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
        ArrayList<VuzeFile> vuze_files = new ArrayList<VuzeFile>();
        for (String line : torrents) {
            File file;
            if ((line = line.trim()).startsWith("\"") && line.endsWith("\"")) {
                line = line.length() < 3 ? "" : line.substring(1, line.length() - 2);
            }
            TorrentOpenOptions torrentOptions = optionsToClone == null ? new TorrentOpenOptions() : new TorrentOpenOptions(optionsToClone);
            File file2 = file = pathPrefix == null ? new File(line) : new File(pathPrefix, line);
            if (file.exists()) {
                try {
                    VuzeFile vf = vfh.loadVuzeFile(file);
                    if (vf != null) {
                        vuze_files.add(vf);
                        continue;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (!TorrentOpener.mergeFileIntoTorrentInfo(file.getAbsolutePath(), null, torrentOptions)) continue;
                uif.addTorrentWithOptions(forceTorrentOptionsWindow, torrentOptions);
                continue;
            }
            final String url = UrlUtils.parseTextForURL(line, true);
            if (url == null) continue;
            if (url.endsWith(".vuze")) {
                new AEThread2("VuzeLoader"){

                    public void run() {
                        try {
                            VuzeFile vf = vfh.loadVuzeFile(url);
                            if (vf != null) {
                                vfh.handleFiles(new VuzeFile[]{vf}, 0);
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }.start();
                continue;
            }
            new FileDownloadWindow(parent, url, referrer, null, torrentOptions, listener);
        }
        if (vuze_files.size() > 0) {
            VuzeFile[] vfs = new VuzeFile[vuze_files.size()];
            vuze_files.toArray(vfs);
            vfh.handleFiles(vfs, 0);
        }
    }
}

