/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.minibar;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.ListIterator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.components.DoubleBufferedLabel;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;

public abstract class MiniBar
implements MenuBuildUtils.MenuBuilder {
    protected Label lDrag;
    protected MiniBar stucked;
    protected Monitor[] screens;
    protected int xPressed;
    protected int yPressed;
    protected boolean moving;
    protected int hSize;
    protected Shell splash;
    protected MiniBarManager manager;
    private Font bold_font = null;
    private boolean constructing = false;
    private boolean constructed = false;
    private Menu menu;
    private MouseMoveListener mMoveListener;
    private MouseListener mListener;
    private int xSize;
    private boolean separateDataProt;
    private float width_multiplier = 1.0f;

    protected MiniBar(MiniBarManager manager) {
        this.manager = manager;
        this.setPrebuildValues();
        this.separateDataProt = DisplayFormatters.isDataProtSeparate();
    }

    private void setPrebuildValues() {
        this.constructing = false;
        this.constructed = false;
        this.xSize = 0;
        this.hSize = -1;
    }

    private void assertConstructing() {
        if (!this.constructing) {
            throw new RuntimeException("not constructing!");
        }
    }

    private Font createBoldFont(Font original) {
        FontData[] font_data = original.getFontData();
        for (int i = 0; i < font_data.length; ++i) {
            font_data[i].setStyle(font_data[i].getStyle() | 1);
        }
        return new Font(original.getDevice(), font_data);
    }

    protected final void createGap(int width) {
        width = (int)((float)width * this.width_multiplier);
        this.assertConstructing();
        Label result = new Label((Composite)this.splash, 0);
        result.setBackground(Colors.blues[0]);
        result.setForeground(Colors.blues[9]);
        result.setText("");
        result.addMouseListener(this.mListener);
        result.addMouseMoveListener(this.mMoveListener);
        result.setLocation(this.xSize, 0);
        result.setSize(width, this.hSize);
        result.setMenu(this.menu);
        this.xSize += width;
    }

    protected final Label createFixedTextLabel(String msg_key, boolean add_colon, boolean bold) {
        this.assertConstructing();
        Label result = new Label((Composite)this.splash, 0);
        result.setBackground(Colors.blues[0]);
        result.setForeground(Colors.blues[9]);
        result.setText(MessageText.getString(msg_key) + (add_colon ? ":" : ""));
        if (bold) {
            if (this.bold_font == null) {
                this.bold_font = this.createBoldFont(result.getFont());
            }
            result.setFont(this.bold_font);
        }
        result.addMouseListener(this.mListener);
        result.addMouseMoveListener(this.mMoveListener);
        result.pack();
        result.setLocation(this.xSize, 0);
        result.setMenu(this.menu);
        if (this.hSize == -1) {
            int hSizeText = result.getSize().y;
            int hSizeImage = this.lDrag.getSize().y;
            this.hSize = hSizeText > hSizeImage ? hSizeText : hSizeImage;
        }
        this.xSize += result.getSize().x + 3;
        return result;
    }

    protected final Label createFixedLabel(int width) {
        this.assertConstructing();
        Label result = new Label((Composite)this.splash, 0);
        result.setBackground(Colors.white);
        result.setSize(width, -1);
        result.setLocation(this.xSize, 0);
        result.addMouseListener(this.mListener);
        result.addMouseMoveListener(this.mMoveListener);
        result.setMenu(this.menu);
        if (this.hSize == -1) {
            int hSizeText = result.getSize().y;
            int hSizeImage = this.lDrag.getSize().y;
            this.hSize = hSizeText > hSizeImage ? hSizeText : hSizeImage;
        }
        this.xSize += width;
        return result;
    }

    protected final DoubleBufferedLabel createDataLabel(int width, boolean centered) {
        width = (int)((float)width * this.width_multiplier);
        this.assertConstructing();
        DoubleBufferedLabel result = new DoubleBufferedLabel((Composite)this.splash, (centered ? 0x1000000 : 0) | 0x20000000);
        result.setBackground(Colors.blues[0]);
        result.setText("");
        result.addMouseListener(this.mListener);
        result.addMouseMoveListener(this.mMoveListener);
        if (this.hSize == -1) {
            throw new RuntimeException("must add fixed text label first!");
        }
        result.setSize(width, this.hSize);
        result.setLocation(this.xSize, 0);
        result.setMenu(this.menu);
        this.xSize += width + 3;
        return result;
    }

    protected final DoubleBufferedLabel createDataLabel(int width) {
        return this.createDataLabel(width, false);
    }

    protected final DoubleBufferedLabel createSpeedLabel() {
        return this.createDataLabel(this.separateDataProt ? 110 : 65, this.separateDataProt);
    }

    protected void updateSpeedLabel(DoubleBufferedLabel label, long data_rate, long protocol_rate) {
        if (this.separateDataProt) {
            label.setText(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(data_rate, protocol_rate));
        } else {
            label.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(data_rate + protocol_rate));
        }
    }

    protected final ProgressBar createProgressBar(int min, int max, int width, final ProgressBarText pbt) {
        width = (int)((float)width * this.width_multiplier);
        final ProgressBar result = new ProgressBar((Composite)this.splash, 65536);
        result.setBackground(Colors.blues[0]);
        result.setForeground(Colors.blues[2]);
        result.setMinimum(min);
        result.setMaximum(max);
        result.addMouseListener(this.mListener);
        result.addMouseMoveListener(this.mMoveListener);
        if (this.hSize == -1) {
            throw new RuntimeException("must add fixed text label first!");
        }
        result.setSize(width, this.hSize);
        result.setLocation(this.xSize, 0);
        result.setMenu(this.menu);
        this.xSize += width + 3;
        if (pbt != null) {
            result.addListener(9, new Listener(){

                public void handleEvent(Event event2) {
                    Color old = event2.gc.getForeground();
                    event2.gc.setForeground(Colors.black);
                    int char_width = event2.gc.getFontMetrics().getAverageCharWidth();
                    String pb_text = pbt.convert(result.getSelection());
                    event2.gc.drawText(pb_text, (result.getSize().x - pb_text.length() * char_width) / 2, -1, true);
                    event2.gc.setForeground(old);
                }
            });
        }
        return result;
    }

    protected final ProgressBar createPercentProgressBar(int width) {
        return this.createProgressBar(0, 1000, width, new ProgressBarText(){

            public String convert(int value) {
                return DisplayFormatters.formatPercentFromThousands(value);
            }
        });
    }

    public final void construct(final Shell main) {
        if (this.constructed) {
            throw new RuntimeException("already constructed!");
        }
        this.constructing = true;
        this.stucked = null;
        this.splash = ShellFactory.createShell(16384);
        int trans = COConfigurationManager.getIntParameter("Bar Transparency");
        if (trans > 0 && trans <= 100) {
            int alpha = (int)(255.0f * (100.0f - (float)trans) / 100.0f);
            this.splash.setAlpha(alpha);
        }
        this.manager.register(this);
        final DisposeListener mainDisposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                MiniBar.this.close();
            }
        };
        main.addDisposeListener(mainDisposeListener);
        this.splash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (main.isDisposed()) {
                    return;
                }
                main.removeDisposeListener(mainDisposeListener);
            }
        });
        this.screens = main.getDisplay().getMonitors();
        this.build();
    }

    private void build() {
        this.lDrag = new Label((Composite)this.splash, 0);
        int testTextHeight = 0;
        try {
            GC gc = new GC((Drawable)this.lDrag);
            gc.setFont(this.splash.getDisplay().getSystemFont());
            Point textSize = gc.textExtent("Vuze Rocks innit: 100 MB/sec");
            int textWidth = textSize.x;
            testTextHeight = textSize.y;
            if (textWidth > 139) {
                this.width_multiplier = (float)textWidth / 139.0f;
            }
            gc.dispose();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        if (!Constants.isOSX) {
            this.lDrag.setImage(ImageLoader.getInstance().getImage("dragger"));
            this.lDrag.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ImageLoader.getInstance().releaseImage("dragger");
                }
            });
        }
        this.lDrag.pack();
        int yPad = 0;
        Point lDragSize = this.lDrag.getSize();
        this.xSize = lDragSize.x + 3;
        if (lDragSize.y < testTextHeight) {
            yPad = (testTextHeight - lDragSize.y) / 2;
        }
        this.lDrag.setLocation(0, yPad);
        this.mListener = new MouseAdapter(){
            int old_alpha;

            public void mouseDown(MouseEvent e) {
                MiniBar.this.xPressed = e.x;
                MiniBar.this.yPressed = e.y;
                MiniBar.this.moving = true;
                this.old_alpha = MiniBar.this.splash.getAlpha();
                if (this.old_alpha != 255) {
                    MiniBar.this.splash.setAlpha(255);
                }
            }

            public void mouseUp(MouseEvent e) {
                MiniBar.this.moving = false;
                if (this.old_alpha != 255) {
                    MiniBar.this.splash.setAlpha(this.old_alpha);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                MiniBar.this.doubleClick();
            }
        };
        this.mMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (MiniBar.this.moving) {
                    int dX = MiniBar.this.xPressed - e.x;
                    int dY = MiniBar.this.yPressed - e.y;
                    Point currentLoc = MiniBar.this.splash.getLocation();
                    currentLoc.x -= dX;
                    currentLoc.y -= dY;
                    MiniBar.this.setSnapLocation(currentLoc);
                }
            }
        };
        this.splash.setBackground(Colors.blues[0]);
        this.splash.setForeground(Colors.blues[9]);
        this.splash.addMouseListener(this.mListener);
        this.splash.addMouseMoveListener(this.mMoveListener);
        this.lDrag.addMouseListener(this.mListener);
        this.lDrag.addMouseMoveListener(this.mMoveListener);
        this.menu = new Menu((Decorations)this.splash, 8);
        MenuBuildUtils.addMaintenanceListenerForMenu(this.menu, this);
        this.beginConstruction();
        this.splash.addListener(20, new Listener(){

            public void handleEvent(Event e) {
                MiniBar.this.splash.setVisible(true);
                MiniBar.this.splash.setActive();
            }
        });
        this.splash.setSize(this.xSize + 3, this.hSize + 2);
        this.mListener = null;
        this.mMoveListener = null;
        this.menu = null;
        this.refresh();
        this.constructing = false;
        this.constructed = true;
        Point point = this.getInitialLocation();
        if (point != null) {
            this.splash.setLocation(point);
        }
        this.splash.setVisible(true);
    }

    public void buildMenu(Menu menu) {
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items;
        Object[] plugin_context_objs = this.getPluginMenuContextObjects();
        String[] plugin_menu_ids = this.getPluginMenuIdentifiers(plugin_context_objs);
        if (plugin_menu_ids != null && (menu_items = MenuItemManager.getInstance().getAllAsArray(plugin_menu_ids)).length > 0) {
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(plugin_context_objs));
            new MenuItem(menu, 2);
        }
        MenuItem itemClose = new MenuItem(menu, 0);
        itemClose.setText(MessageText.getString("wizard.close"));
        itemClose.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MiniBar.this.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSnapLocation(Point currentLoc) {
        Rectangle dim = new Rectangle(currentLoc.x, currentLoc.y, this.splash.getBounds().width, this.splash.getBounds().height);
        int topIntersectArea = 0;
        int bestScreen = 0;
        for (int i = 0; i < this.screens.length; ++i) {
            Rectangle curScreen = this.screens[i].getClientArea();
            curScreen.intersect(dim);
            int area = curScreen.width * curScreen.height;
            if (area <= topIntersectArea) continue;
            bestScreen = i;
            topIntersectArea = area;
        }
        Rectangle screen = this.screens[bestScreen].getClientArea();
        if (currentLoc.x - screen.x < 10) {
            currentLoc.x = screen.x;
        } else if (currentLoc.x - screen.x > screen.width - dim.width - 10) {
            currentLoc.x = screen.x + screen.width - dim.width;
        }
        if (currentLoc.y - screen.y < 10) {
            currentLoc.y = screen.y;
        }
        MiniBar mw = this;
        int height = 0;
        while (mw != null) {
            Shell s = mw.getShell();
            if (s.isDisposed()) {
                mw = null;
                continue;
            }
            height += s.getBounds().height - 1;
            if ((mw = mw.getStucked()) != this) continue;
            mw = null;
        }
        if (currentLoc.y - screen.y > screen.height - height - 10) {
            currentLoc.y = screen.y + screen.height - height;
        }
        MiniBarManager g_manager = MiniBarManager.getManager();
        try {
            g_manager.getMiniBarMonitor().enter();
            if (g_manager.countMiniBars() > 1) {
                ListIterator itr = g_manager.getMiniBarIterator();
                while (itr.hasNext()) {
                    MiniBar downloadBar = (MiniBar)itr.next();
                    Point location = downloadBar.getShell().getLocation();
                    location.y += downloadBar.getShell().getBounds().height;
                    if ((downloadBar != this && downloadBar.getStucked() == null || downloadBar.getStucked() == this) && Math.abs(location.x - currentLoc.x) < 10 && location.y - currentLoc.y < 10 && location.y - currentLoc.y > 0) {
                        downloadBar.setStucked(this);
                        currentLoc.x = location.x;
                        currentLoc.y = location.y - 1;
                    }
                    if (downloadBar == this || downloadBar.getStucked() != this || Math.abs(location.x - currentLoc.x) <= 10 && Math.abs(location.y - currentLoc.y) <= 10) continue;
                    downloadBar.setStucked(null);
                }
            }
            Object var13_13 = null;
            g_manager.getMiniBarMonitor().exit();
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            g_manager.getMiniBarMonitor().exit();
            throw throwable;
        }
        this.splash.setLocation(currentLoc);
        MiniBar mwCurrent = this;
        while (mwCurrent != null) {
            currentLoc.y += mwCurrent.getShell().getBounds().height - 1;
            MiniBar mwChild = mwCurrent.getStucked();
            if (mwChild != null && mwChild != this) {
                Shell s = mwChild.getShell();
                if (s.isDisposed()) {
                    mwCurrent.setStucked(null);
                    mwCurrent = null;
                    continue;
                }
                mwCurrent = mwChild;
                mwCurrent.getShell().setLocation(currentLoc);
                continue;
            }
            mwCurrent = null;
        }
    }

    public Shell getShell() {
        return this.splash;
    }

    public void setVisible(boolean visible) {
        this.splash.setVisible(visible);
    }

    public final boolean hasSameContext(MiniBar m) {
        return this.hasContext(m.getContextObject());
    }

    public final boolean hasContext(Object context2) {
        Object my_context = this.getContextObject();
        if (my_context == null) {
            return context2 == null;
        }
        return my_context.equals(context2);
    }

    public MiniBar getStucked() {
        return this.stucked;
    }

    public void setStucked(MiniBar mw) {
        this.stucked = mw;
    }

    public final void forceSaveLocation() {
        if (!this.splash.isDisposed()) {
            this.storeLastLocation(this.splash.getLocation());
        }
    }

    public final void close() {
        Display display;
        if (!this.splash.isDisposed() && (display = this.splash.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    MiniBar.this.dispose();
                }
            });
        }
        this.manager.unregister(this);
    }

    public void dispose() {
        if (!this.splash.isDisposed()) {
            this.forceSaveLocation();
            this.splash.dispose();
        }
        if (this.bold_font != null && !this.bold_font.isDisposed()) {
            this.bold_font.dispose();
        }
    }

    public final void refresh() {
        if (this.splash.isDisposed()) {
            return;
        }
        this.refresh0();
    }

    protected abstract void refresh0();

    protected abstract void beginConstruction();

    protected abstract Object getContextObject();

    public String[] getPluginMenuIdentifiers(Object[] context2) {
        return null;
    }

    public Object[] getPluginMenuContextObjects() {
        return null;
    }

    protected Point getInitialLocation() {
        return null;
    }

    protected void doubleClick() {
    }

    protected void storeLastLocation(Point point) {
    }

    protected static interface ProgressBarText {
        public String convert(int var1);
    }
}

