/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.util.GeneralUtils;
import com.aelitis.azureus.core.util.average.MovingImmediateAverage;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.components.graphics.MultiPlotGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.ValueFormater;
import org.gudy.azureus2.ui.swt.components.graphics.ValueSource;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.views.ViewUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadActivityView
implements UISWTViewCoreEventListener,
UIPluginViewToolBarListener {
    public static final String MSGID_PREFIX = "DownloadActivityView";
    private static Color[] colors = new Color[]{Colors.fadedGreen, Colors.fadedGreen, Colors.blues[9], Colors.blues[9], Colors.light_grey};
    private UISWTView swtView;
    private boolean legend_at_bottom;
    private Composite panel;
    private MultiPlotGraphic mpg;
    private DownloadManager manager;
    private Composite parent;
    private boolean comp_focused;
    private Object focus_pending_ds;

    private String getFullTitle() {
        return MessageText.getString("DownloadActivityView.title.full");
    }

    public void initialize(Composite parent) {
        this.parent = parent;
        this.panel = new Composite(parent, 0);
        this.panel.setLayout((Layout)new GridLayout(this.legend_at_bottom ? 1 : 2, false));
        this.fillPanel();
    }

    public void fillPanel() {
        GridData gridData;
        Utils.disposeComposite(this.panel, false);
        ValueFormater formatter = new ValueFormater(){

            public String format(int value) {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(value);
            }
        };
        ValueSource[] sources = new ValueSourceImpl[]{new ValueSourceImpl("Up", 0, colors, true, false, false){

            public int getValue() {
                DownloadManager dm = DownloadActivityView.this.manager;
                if (dm == null) {
                    return 0;
                }
                DownloadManagerStats stats2 = DownloadActivityView.this.manager.getStats();
                return (int)stats2.getDataSendRate();
            }
        }, new ValueSourceImpl("Up Smooth", 1, colors, true, false, true){

            public int getValue() {
                DownloadManager dm = DownloadActivityView.this.manager;
                if (dm == null) {
                    return 0;
                }
                DownloadManagerStats stats2 = DownloadActivityView.this.manager.getStats();
                return (int)stats2.getSmoothedDataSendRate();
            }
        }, new ValueSourceImpl("Down", 2, colors, false, false, false){

            public int getValue() {
                DownloadManager dm = DownloadActivityView.this.manager;
                if (dm == null) {
                    return 0;
                }
                DownloadManagerStats stats2 = DownloadActivityView.this.manager.getStats();
                return (int)stats2.getDataReceiveRate();
            }
        }, new ValueSourceImpl("Down Smooth", 3, colors, false, false, true){

            public int getValue() {
                DownloadManager dm = DownloadActivityView.this.manager;
                if (dm == null) {
                    return 0;
                }
                DownloadManagerStats stats2 = DownloadActivityView.this.manager.getStats();
                return (int)stats2.getSmoothedDataReceiveRate();
            }
        }, new ValueSourceImpl("Swarm Peer Average", 4, colors, false, true, false){

            public int getValue() {
                DownloadManager dm = DownloadActivityView.this.manager;
                if (dm == null) {
                    return 0;
                }
                return (int)DownloadActivityView.this.manager.getStats().getTotalAveragePerPeer();
            }
        }};
        MultiPlotGraphic f_mpg = this.mpg = MultiPlotGraphic.getInstance(sources, formatter);
        String[] color_configs = new String[]{"DownloadActivityView.legend.up", "DownloadActivityView.legend.up_smooth", "DownloadActivityView.legend.down", "DownloadActivityView.legend.down_smooth", "DownloadActivityView.legend.peeraverage"};
        Legend.LegendListener legend_listener = new Legend.LegendListener((ValueSourceImpl[])sources, f_mpg){
            private int hover_index = -1;
            final /* synthetic */ ValueSourceImpl[] val$sources;
            final /* synthetic */ MultiPlotGraphic val$f_mpg;
            {
                this.val$sources = valueSourceImplArray;
                this.val$f_mpg = multiPlotGraphic;
            }

            public void hoverChange(boolean entry, int index) {
                if (this.hover_index != -1) {
                    this.val$sources[this.hover_index].setHover(false);
                }
                if (entry) {
                    this.hover_index = index;
                    this.val$sources[index].setHover(true);
                }
                this.val$f_mpg.refresh(true);
            }

            public void visibilityChange(boolean visible, int index) {
                this.val$sources[index].setVisible(visible);
                this.val$f_mpg.refresh(true);
            }
        };
        if (!this.legend_at_bottom) {
            gridData = new GridData(1040);
            gridData.verticalAlignment = 0x1000000;
            Legend.createLegendComposite(this.panel, colors, color_configs, null, gridData, false, legend_listener);
        }
        Composite gSpeed = new Composite(this.panel, 0);
        gridData = new GridData(1808);
        gSpeed.setLayoutData((Object)gridData);
        gSpeed.setLayout((Layout)new GridLayout());
        if (this.legend_at_bottom) {
            gridData = new GridData(768);
            Legend.createLegendComposite(this.panel, colors, color_configs, null, gridData, true, legend_listener);
        }
        Canvas speedCanvas = new Canvas(gSpeed, 262144);
        gridData = new GridData(1808);
        speedCanvas.setLayoutData((Object)gridData);
        this.mpg.initialize(speedCanvas, false);
    }

    private void refresh(boolean force) {
        if (this.mpg == null) {
            return;
        }
        this.mpg.refresh(force);
    }

    public Composite getComposite() {
        return this.panel;
    }

    private void setFocused(boolean foc) {
        if (foc) {
            this.comp_focused = true;
            this.dataSourceChanged(this.focus_pending_ds);
        } else {
            this.focus_pending_ds = this.manager;
            this.dataSourceChanged(null);
            this.comp_focused = false;
        }
    }

    public void dataSourceChanged(Object newDataSource) {
        if (!this.comp_focused) {
            this.focus_pending_ds = newDataSource;
            return;
        }
        DownloadManager newManager = null;
        if (newDataSource instanceof Object[]) {
            Object[] newDataSources = (Object[])newDataSource;
            if (newDataSources.length == 1) {
                Object temp = ((Object[])newDataSource)[0];
                if (temp instanceof DownloadManager) {
                    newManager = (DownloadManager)temp;
                } else if (temp instanceof DiskManagerFileInfo) {
                    newManager = ((DiskManagerFileInfo)temp).getDownloadManager();
                }
            }
        } else if (newDataSource instanceof DownloadManager) {
            newManager = (DownloadManager)newDataSource;
        } else if (newDataSource instanceof DiskManagerFileInfo) {
            newManager = ((DiskManagerFileInfo)newDataSource).getDownloadManager();
        }
        if (newManager == this.manager) {
            return;
        }
        this.manager = newManager;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (DownloadActivityView.this.panel == null || DownloadActivityView.this.panel.isDisposed()) {
                    return;
                }
                Utils.disposeComposite(DownloadActivityView.this.panel, false);
                if (DownloadActivityView.this.manager != null) {
                    DownloadActivityView.this.fillPanel();
                    DownloadActivityView.this.parent.layout(true, true);
                } else {
                    ViewUtils.setViewRequiresOneDownload(DownloadActivityView.this.panel);
                }
            }
        });
        if (this.manager == null) {
            this.mpg.setActive(false);
            this.mpg.reset(new int[5][0]);
        } else {
            DownloadManagerStats stats2 = this.manager.getStats();
            stats2.setRecentHistoryRetention(true);
            int[][] _history = stats2.getRecentHistory();
            int[] send_history = _history[0];
            int[] recv_history = _history[1];
            int history_secs = send_history.length;
            int[] smoothed_send = new int[history_secs];
            int[] smoothed_recv = new int[history_secs];
            MovingImmediateAverage send_average = GeneralUtils.getSmoothAverage();
            MovingImmediateAverage recv_average = GeneralUtils.getSmoothAverage();
            int smooth_interval = GeneralUtils.getSmoothUpdateInterval();
            int current_smooth_send = 0;
            int current_smooth_recv = 0;
            int pending_smooth_send = 0;
            int pending_smooth_recv = 0;
            for (int i = 0; i < history_secs; ++i) {
                pending_smooth_send += send_history[i];
                pending_smooth_recv += recv_history[i];
                if (i % smooth_interval == 0) {
                    current_smooth_send = (int)(send_average.update(pending_smooth_send) / (double)smooth_interval);
                    current_smooth_recv = (int)(recv_average.update(pending_smooth_recv) / (double)smooth_interval);
                    pending_smooth_send = 0;
                    pending_smooth_recv = 0;
                }
                smoothed_send[i] = current_smooth_send;
                smoothed_recv[i] = current_smooth_recv;
            }
            int[][] history = new int[][]{send_history, smoothed_send, recv_history, smoothed_recv, _history[2]};
            this.mpg.reset(history);
            this.mpg.setActive(true);
        }
    }

    public void delete() {
        Utils.disposeComposite(this.panel);
        if (this.mpg != null) {
            this.mpg.dispose();
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                this.swtView.setToolBarListener(this);
                if (!(event2 instanceof UISWTViewEventImpl)) break;
                String parent = ((UISWTViewEventImpl)event2).getParentID();
                this.legend_at_bottom = parent != null && parent.equals("TorrentDetailsView");
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 5: {
                this.refresh(false);
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                String id = "DMDetails_DownloadGraph";
                this.setFocused(true);
                if (this.manager != null) {
                    id = this.manager.getTorrent() != null ? id + "." + this.manager.getInternalName() : id + ":" + this.manager.getSize();
                    SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(this.manager)});
                } else {
                    SelectedContentManager.changeCurrentlySelectedContent(id, null);
                }
                this.refresh(true);
                break;
            }
            case 4: {
                this.setFocused(false);
                SelectedContentManager.clearCurrentlySelectedContent();
            }
        }
        return true;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        Map<String, Long> states = TorrentUtil.calculateToolbarStates(SelectedContentManager.getCurrentlySelectedContent(), null);
        list.putAll(states);
    }

    private abstract class ValueSourceImpl
    implements ValueSource {
        private String name;
        private int index;
        private Color[] colours;
        private boolean is_up;
        private boolean trimmable;
        private boolean is_hover;
        private boolean is_invisible;
        private boolean is_dotted;

        private ValueSourceImpl(String _name, int _index, Color[] _colours, boolean _is_up, boolean _trimmable, boolean _is_dotted) {
            this.name = _name;
            this.index = _index;
            this.colours = _colours;
            this.is_up = _is_up;
            this.trimmable = _trimmable;
            this.is_dotted = _is_dotted;
        }

        public String getName() {
            return this.name;
        }

        public Color getLineColor() {
            return this.colours[this.index];
        }

        public boolean isTrimmable() {
            return this.trimmable;
        }

        private void setHover(boolean h) {
            this.is_hover = h;
        }

        private void setVisible(boolean visible) {
            this.is_invisible = !visible;
        }

        public int getStyle() {
            int style;
            if (this.is_invisible) {
                return 16;
            }
            int n = style = this.is_up ? 1 : 2;
            if (this.is_hover) {
                style |= 8;
            }
            if (this.is_dotted) {
                style |= 0x40;
            }
            return style;
        }

        public int getAlpha() {
            return this.is_dotted ? 128 : 255;
        }
    }
}

