/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableView;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;
import org.gudy.azureus2.ui.swt.shells.AdvRenameWindow;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesViewMenuUtil {
    public static final Object PRIORITY_HIGH = new Object();
    public static final Object PRIORITY_NORMAL = new Object();
    public static final Object PRIORITY_LOW = new Object();
    public static final Object PRIORITY_NUMERIC = new Object();
    public static final Object PRIORITY_NUMERIC_AUTO = new Object();
    public static final Object PRIORITY_SKIPPED = new Object();
    public static final Object PRIORITY_DELETE = new Object();

    public static void fillMenu(final TableView<?> tv, Menu menu, final DownloadManager manager, final Object[] data_sources) {
        Shell shell = menu.getShell();
        boolean hasSelection = data_sources.length > 0;
        final DiskManagerFileInfo[] dmi_array = new DiskManagerFileInfo[data_sources.length];
        System.arraycopy(data_sources, 0, dmi_array, 0, data_sources.length);
        MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOpen, "FilesView.menu.open");
        Utils.setMenuItemImage(itemOpen, "run");
        menu.setDefaultItem(itemOpen);
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (int i = data_sources.length - 1; i >= 0; --i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)data_sources[i];
                    if (info == null) continue;
                    ManagerUtils.open(info, use_open_containing_folder);
                }
            }
        });
        itemExplore.setEnabled(hasSelection);
        Menu menuBrowse = new Menu((Decorations)menu.getShell(), 4);
        MenuItem itemBrowse = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemBrowse, "MyTorrentsView.menu.browse");
        itemBrowse.setMenu(menuBrowse);
        MenuItem itemBrowsePublic = new MenuItem(menuBrowse, 8);
        itemBrowsePublic.setText(MessageText.getString("label.public") + "...");
        itemBrowsePublic.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (int i = data_sources.length - 1; i >= 0; --i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)data_sources[i];
                    if (info == null) continue;
                    ManagerUtils.browse(info, false, true);
                }
            }
        });
        MenuItem itemBrowseAnon = new MenuItem(menuBrowse, 8);
        itemBrowseAnon.setText(MessageText.getString("label.anon") + "...");
        itemBrowseAnon.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (int i = data_sources.length - 1; i >= 0; --i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)data_sources[i];
                    if (info == null) continue;
                    ManagerUtils.browse(info, true, true);
                }
            }
        });
        new MenuItem(menuBrowse, 2);
        MenuItem itemBrowseURL = new MenuItem(menuBrowse, 8);
        Messages.setLanguageText((Widget)itemBrowseURL, "label.copy.url.to.clip");
        itemBrowseURL.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Utils.getOffOfSWTThread(new AERunnable(){

                    public void runSupport() {
                        String url = ManagerUtils.browse(dmi_array[0], true, false);
                        if (url != null) {
                            ClipboardCopy.copyToClipBoard(url);
                        }
                    }
                });
            }
        });
        itemBrowseURL.setEnabled(data_sources.length == 1);
        menuBrowse.setEnabled(hasSelection);
        MenuItem itemRenameOrRetarget = null;
        MenuItem itemRename = null;
        MenuItem itemRetarget = null;
        itemRenameOrRetarget = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRenameOrRetarget, "FilesView.menu.rename");
        itemRenameOrRetarget.setData("rename", (Object)true);
        itemRenameOrRetarget.setData("retarget", (Object)true);
        itemRename = new MenuItem(menu, 8);
        itemRetarget = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRename, "FilesView.menu.rename_only");
        Messages.setLanguageText((Widget)itemRetarget, "FilesView.menu.retarget");
        itemRename.setData("rename", (Object)true);
        itemRename.setData("retarget", (Object)false);
        itemRetarget.setData("rename", (Object)false);
        itemRetarget.setData("retarget", (Object)true);
        final MenuItem itemQuickView = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemQuickView, "MainWindow.menu.quick_view");
        itemQuickView.setEnabled(data_sources.length == 1 && Utils.isQuickViewSupported((DiskManagerFileInfo)data_sources[0]));
        itemQuickView.setSelection(data_sources.length == 1 && Utils.isQuickViewActive((DiskManagerFileInfo)data_sources[0]));
        itemQuickView.addListener(13, new Listener(){

            public void handleEvent(Event arg) {
                Utils.setQuickViewActive((DiskManagerFileInfo)data_sources[0], itemQuickView.getSelection());
            }
        });
        MenuFactory.addAlertsMenu(menu, manager, dmi_array);
        MenuItem itemPersonalShare = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemPersonalShare, "MyTorrentsView.menu.create_personal_share");
        MenuItem itemPriority = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemPriority, "FilesView.menu.setpriority");
        Menu menuPriority = new Menu((Decorations)shell, 4);
        itemPriority.setMenu(menuPriority);
        MenuItem itemHigh = new MenuItem(menuPriority, 64);
        itemHigh.setData("Priority", PRIORITY_HIGH);
        Messages.setLanguageText((Widget)itemHigh, "FilesView.menu.setpriority.high");
        MenuItem itemNormal = new MenuItem(menuPriority, 64);
        itemNormal.setData("Priority", PRIORITY_NORMAL);
        Messages.setLanguageText((Widget)itemNormal, "FilesView.menu.setpriority.normal");
        MenuItem itemLow = new MenuItem(menuPriority, 64);
        itemLow.setData("Priority", PRIORITY_LOW);
        Messages.setLanguageText((Widget)itemLow, "FileItem.low");
        MenuItem itemNumeric = new MenuItem(menuPriority, 64);
        itemNumeric.setData("Priority", PRIORITY_NUMERIC);
        Messages.setLanguageText((Widget)itemNumeric, "FilesView.menu.setpriority.numeric");
        MenuItem itemNumericAuto = new MenuItem(menuPriority, 64);
        itemNumericAuto.setData("Priority", PRIORITY_NUMERIC_AUTO);
        Messages.setLanguageText((Widget)itemNumericAuto, "FilesView.menu.setpriority.numeric.auto");
        MenuItem itemSkipped = new MenuItem(menuPriority, 64);
        itemSkipped.setData("Priority", PRIORITY_SKIPPED);
        Messages.setLanguageText((Widget)itemSkipped, "FilesView.menu.setpriority.skipped");
        MenuItem itemDelete = new MenuItem(menuPriority, 64);
        itemDelete.setData("Priority", PRIORITY_DELETE);
        Messages.setLanguageText((Widget)itemDelete, "wizard.multitracker.delete");
        new MenuItem(menu, 2);
        if (!hasSelection) {
            itemOpen.setEnabled(false);
            itemPriority.setEnabled(false);
            itemRenameOrRetarget.setEnabled(false);
            itemRename.setEnabled(false);
            itemRetarget.setEnabled(false);
            itemPersonalShare.setEnabled(false);
            return;
        }
        boolean open = true;
        boolean all_compact = true;
        boolean all_skipped = true;
        boolean all_high_pri = true;
        boolean all_normal_pri = true;
        boolean all_low_pri = true;
        boolean all_complete = true;
        int[] storage_types = manager.getStorageType(dmi_array);
        for (int i = 0; i < dmi_array.length; ++i) {
            DiskManagerFileInfo file_info = dmi_array[i];
            if (open && file_info.getAccessMode() != 1) {
                open = false;
            }
            if (all_compact && storage_types[i] != 2 && storage_types[i] != 4) {
                all_compact = false;
            }
            if (all_skipped || all_high_pri || all_normal_pri || all_low_pri) {
                if (file_info.isSkipped()) {
                    all_low_pri = false;
                    all_normal_pri = false;
                    all_high_pri = false;
                } else {
                    all_skipped = false;
                    if (all_high_pri || all_normal_pri || all_low_pri) {
                        int file_pri = file_info.getPriority();
                        if (file_pri == 0) {
                            all_low_pri = false;
                            all_high_pri = false;
                        } else if (file_pri == 1) {
                            all_low_pri = false;
                            all_normal_pri = false;
                        } else if (file_pri == -1) {
                            all_high_pri = false;
                            all_normal_pri = false;
                        } else {
                            all_high_pri = false;
                            all_normal_pri = false;
                            all_low_pri = false;
                        }
                    }
                }
            }
            if (file_info.getDownloaded() == file_info.getLength() && file_info.getFile(true).length() == file_info.getLength()) continue;
            all_complete = false;
        }
        itemOpen.setEnabled(open);
        itemRenameOrRetarget.setEnabled(manager.isPersistent());
        itemRename.setEnabled(manager.isPersistent());
        itemRetarget.setEnabled(manager.isPersistent());
        itemPersonalShare.setEnabled(all_complete && dmi_array.length == 1);
        itemSkipped.setEnabled(!all_skipped);
        itemHigh.setEnabled(!all_high_pri);
        itemNormal.setEnabled(!all_normal_pri);
        itemLow.setEnabled(!all_low_pri);
        itemDelete.setEnabled(!all_compact);
        itemOpen.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (int i = 0; i < data_sources.length; ++i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)data_sources[i];
                    if (info == null || info.getAccessMode() != 1) continue;
                    Utils.launch(info);
                }
            }
        });
        Listener rename_listener = new Listener(){

            public void handleEvent(Event event2) {
                boolean rename_it = (Boolean)event2.widget.getData("rename");
                boolean retarget_it = (Boolean)event2.widget.getData("retarget");
                FilesViewMenuUtil.rename(tv, manager, data_sources, rename_it, retarget_it);
            }
        };
        itemRenameOrRetarget.addListener(13, rename_listener);
        itemRename.addListener(13, rename_listener);
        itemRetarget.addListener(13, rename_listener);
        itemPersonalShare.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("personal", "true");
                for (int i = 0; i < dmi_array.length; ++i) {
                    DiskManagerFileInfo file_info = dmi_array[i];
                    File file = file_info.getFile(true);
                    if (file.isFile()) {
                        ShareUtils.shareFile(file.getAbsolutePath(), properties);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    ShareUtils.shareDir(file.getAbsolutePath(), properties);
                }
            }
        });
        Listener priorityListener = new Listener(){

            public void handleEvent(Event event2) {
                final Object priority = event2.widget.getData("Priority");
                Utils.getOffOfSWTThread(new AERunnable(){

                    public void runSupport() {
                        FilesViewMenuUtil.changePriority(priority, data_sources);
                    }
                });
            }
        };
        itemNumeric.addListener(13, priorityListener);
        itemNumericAuto.addListener(13, priorityListener);
        itemHigh.addListener(13, priorityListener);
        itemNormal.addListener(13, priorityListener);
        itemLow.addListener(13, priorityListener);
        itemSkipped.addListener(13, priorityListener);
        itemDelete.addListener(13, priorityListener);
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray("file_context");
        if (menu_items.length > 0) {
            Object[] fileInfos = new org.gudy.azureus2.plugins.disk.DiskManagerFileInfo[data_sources.length];
            for (int i = 0; i < data_sources.length; ++i) {
                fileInfos[i] = (org.gudy.azureus2.plugins.disk.DiskManagerFileInfo)PluginCoreUtils.convert(data_sources[i], false);
            }
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, false, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(fileInfos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rename(TableView tv, DownloadManager not_used, Object[] datasources, boolean rename_it, boolean retarget_it) {
        ArrayList<DownloadManager> pausedDownloads;
        block26: {
            Iterator i$2;
            block25: {
                if (datasources.length == 0) {
                    return;
                }
                String save_dir = null;
                if (!rename_it && retarget_it && (save_dir = FilesViewMenuUtil.askForSaveDirectory((DiskManagerFileInfo)datasources[0])) == null) {
                    return;
                }
                pausedDownloads = new ArrayList<DownloadManager>(0);
                boolean paused = false;
                try {
                    for (int i = 0; i < datasources.length; ++i) {
                        TableRowCore[] subrows;
                        TableRowCore row;
                        if (datasources[i] instanceof DownloadManager) {
                            AdvRenameWindow window = new AdvRenameWindow();
                            window.open((DownloadManager)datasources[i]);
                            continue;
                        }
                        if (!(datasources[i] instanceof DiskManagerFileInfo)) continue;
                        final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)datasources[i];
                        File existing_file = fileInfo2.getFile(true);
                        File f_target = null;
                        if (rename_it && retarget_it) {
                            String s_target = FilesViewMenuUtil.askForRetargetedFilename(fileInfo2);
                            if (s_target != null) {
                                f_target = new File(s_target);
                            }
                        } else if (rename_it) {
                            String s_target = FilesViewMenuUtil.askForRenameFilename(fileInfo2);
                            if (s_target != null) {
                                f_target = new File(existing_file.getParentFile(), s_target);
                            }
                        } else {
                            f_target = new File(save_dir, existing_file.getName());
                        }
                        if (f_target == null) {
                            Object var21_23 = null;
                            i$2 = pausedDownloads.iterator();
                            break block25;
                        }
                        if (!paused) {
                            DownloadManager manager = fileInfo2.getDownloadManager();
                            if (!pausedDownloads.contains(manager)) {
                                pausedDownloads.add(manager);
                            }
                            paused = manager.pause();
                        }
                        boolean dont_delete_existing = false;
                        if (f_target.exists()) {
                            if (f_target.equals(existing_file)) continue;
                            if (retarget_it) {
                                dont_delete_existing = true;
                            } else if (existing_file.exists() && !FilesViewMenuUtil.askCanOverwrite(existing_file)) continue;
                        }
                        final File ff_target = f_target;
                        TableRowCore tableRowCore = row = tv == null ? null : tv.getRow(datasources[i]);
                        if (row == null && tv != null && (row = tv.getRow(fileInfo2.getDownloadManager())) != null && (subrows = row.getSubRowsWithNull()) != null) {
                            for (TableRowCore sr : subrows) {
                                if (sr.getDataSource(true) != fileInfo2) continue;
                                row = sr;
                                break;
                            }
                        }
                        final TableRowCore f_row = row;
                        final boolean f_dont_delete_existing = dont_delete_existing;
                        Utils.getOffOfSWTThread(new AERunnable(){

                            public void runSupport() {
                                FilesViewMenuUtil.moveFile(fileInfo2.getDownloadManager(), fileInfo2, ff_target, f_dont_delete_existing);
                                if (f_row != null) {
                                    f_row.invalidate(true);
                                }
                            }
                        });
                    }
                    break block26;
                }
                catch (Throwable throwable) {
                    Object var21_25 = null;
                    Iterator i$2 = pausedDownloads.iterator();
                    while (true) {
                        if (!i$2.hasNext()) {
                            throw throwable;
                        }
                        DownloadManager manager = (DownloadManager)i$2.next();
                        manager.resume();
                    }
                }
            }
            while (i$2.hasNext()) {
                DownloadManager manager = (DownloadManager)i$2.next();
                manager.resume();
            }
            return;
        }
        Object var21_24 = null;
        Iterator i$2 = pausedDownloads.iterator();
        while (i$2.hasNext()) {
            DownloadManager manager = (DownloadManager)i$2.next();
            manager.resume();
        }
        return;
    }

    public static void changePriority(Object type, Object[] datasources) {
        if (datasources == null || datasources.length == 0) {
            return;
        }
        if (type == PRIORITY_NUMERIC) {
            FilesViewMenuUtil.changePriorityManual(datasources);
            return;
        }
        if (type == PRIORITY_NUMERIC_AUTO) {
            FilesViewMenuUtil.changePriorityAuto(datasources);
            return;
        }
        HashMap<DownloadManager, ArrayList<DiskManagerFileInfo>> mapDMtoDMFI = new HashMap<DownloadManager, ArrayList<DiskManagerFileInfo>>();
        DiskManagerFileInfo[] file_infos = new DiskManagerFileInfo[datasources.length];
        for (int i = 0; i < datasources.length; ++i) {
            file_infos[i] = (DiskManagerFileInfo)datasources[i];
            DownloadManager dm = file_infos[i].getDownloadManager();
            ArrayList<DiskManagerFileInfo> listFileInfos = (ArrayList<DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
            if (listFileInfos == null) {
                listFileInfos = new ArrayList<DiskManagerFileInfo>(1);
                mapDMtoDMFI.put(dm, listFileInfos);
            }
            listFileInfos.add(file_infos[i]);
            if (type == PRIORITY_NORMAL) {
                file_infos[i].setPriority(0);
                continue;
            }
            if (type == PRIORITY_HIGH) {
                file_infos[i].setPriority(1);
                continue;
            }
            if (type != PRIORITY_LOW) continue;
            file_infos[i].setPriority(-1);
        }
        boolean skipped = type == PRIORITY_SKIPPED || type == PRIORITY_DELETE;
        boolean delete_action = type == PRIORITY_DELETE;
        for (DownloadManager dm : mapDMtoDMFI.keySet()) {
            ArrayList list;
            DiskManagerFileInfo[] fileInfos;
            boolean paused = FilesViewMenuUtil.setSkipped(dm, fileInfos = (list = (ArrayList)mapDMtoDMFI.get(dm)).toArray(new DiskManagerFileInfo[0]), skipped, delete_action);
            if (!paused) continue;
            dm.resume();
        }
    }

    private static void changePriorityManual(final Object[] datasources) {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("FilesView.dialog.priority.title", "FilesView.dialog.priority.text");
        entryWindow.prompt(new UIInputReceiverListener(){

            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String sReturn = entryWindow.getSubmittedInput();
                if (sReturn == null) {
                    return;
                }
                int priority = 0;
                try {
                    priority = Integer.valueOf(sReturn);
                }
                catch (NumberFormatException er) {
                    Debug.out("Invalid priority: " + sReturn);
                    new MessageBoxShell(33, MessageText.getString("FilePriority.invalid.title"), MessageText.getString("FilePriority.invalid.text", new String[]{sReturn})).open(null);
                    return;
                }
                HashMap<DownloadManager, ArrayList<DiskManagerFileInfo>> mapDMtoDMFI = new HashMap<DownloadManager, ArrayList<DiskManagerFileInfo>>();
                DiskManagerFileInfo[] file_infos = new DiskManagerFileInfo[datasources.length];
                for (int i = 0; i < datasources.length; ++i) {
                    file_infos[i] = (DiskManagerFileInfo)datasources[i];
                    DownloadManager dm = file_infos[i].getDownloadManager();
                    ArrayList<DiskManagerFileInfo> listFileInfos = (ArrayList<DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
                    if (listFileInfos == null) {
                        listFileInfos = new ArrayList<DiskManagerFileInfo>(1);
                        mapDMtoDMFI.put(dm, listFileInfos);
                    }
                    listFileInfos.add(file_infos[i]);
                    file_infos[i].setPriority(priority);
                }
                for (DownloadManager dm : mapDMtoDMFI.keySet()) {
                    ArrayList list;
                    DiskManagerFileInfo[] fileInfos;
                    boolean paused = FilesViewMenuUtil.setSkipped(dm, fileInfos = (list = (ArrayList)mapDMtoDMFI.get(dm)).toArray(new DiskManagerFileInfo[0]), false, false);
                    if (!paused) continue;
                    dm.resume();
                }
            }
        });
    }

    private static void changePriorityAuto(Object[] datasources) {
        int priority = 0;
        HashMap<DownloadManager, ArrayList<DiskManagerFileInfo>> mapDMtoDMFI = new HashMap<DownloadManager, ArrayList<DiskManagerFileInfo>>();
        DiskManagerFileInfo[] file_infos = new DiskManagerFileInfo[datasources.length];
        for (int i = 0; i < datasources.length; ++i) {
            file_infos[i] = (DiskManagerFileInfo)datasources[i];
            DownloadManager dm = file_infos[i].getDownloadManager();
            ArrayList<DiskManagerFileInfo> listFileInfos = (ArrayList<DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
            if (listFileInfos == null) {
                listFileInfos = new ArrayList<DiskManagerFileInfo>(1);
                mapDMtoDMFI.put(dm, listFileInfos);
            }
            listFileInfos.add(file_infos[i]);
            file_infos[i].setPriority(priority++);
        }
        for (Map.Entry entry : mapDMtoDMFI.entrySet()) {
            DiskManagerFileInfo[] all_files = ((DownloadManager)entry.getKey()).getDiskManagerFileInfoSet().getFiles();
            ArrayList files = (ArrayList)entry.getValue();
            int next_priority = 0;
            if (all_files.length != files.size()) {
                HashSet<Integer> affected_indexes = new HashSet<Integer>();
                for (DiskManagerFileInfo file : files) {
                    affected_indexes.add(file.getIndex());
                }
                for (DiskManagerFileInfo file : all_files) {
                    if (affected_indexes.contains(file.getIndex()) || file.isSkipped()) continue;
                    next_priority = Math.max(next_priority, file.getPriority() + 1);
                }
            }
            next_priority += files.size();
            for (DiskManagerFileInfo file : files) {
                file.setPriority(--next_priority);
            }
        }
        for (DownloadManager dm : mapDMtoDMFI.keySet()) {
            ArrayList list;
            DiskManagerFileInfo[] fileInfos;
            boolean paused = FilesViewMenuUtil.setSkipped(dm, fileInfos = (list = (ArrayList)mapDMtoDMFI.get(dm)).toArray(new DiskManagerFileInfo[0]), false, false);
            if (!paused) continue;
            dm.resume();
        }
    }

    private static String askForRenameFilename(DiskManagerFileInfo fileInfo2) {
        SimpleTextEntryWindow dialog = new SimpleTextEntryWindow("FilesView.rename.filename.title", "FilesView.rename.filename.text");
        String file_name = fileInfo2.getFile(true).getName();
        dialog.setPreenteredText(file_name, false);
        int pos = file_name.lastIndexOf(46);
        if (pos > 0) {
            String suffix = fileInfo2.getDownloadManager().getDownloadState().getAttribute("incompfilesuffix");
            if (suffix != null && file_name.substring(pos).equals(suffix)) {
                --pos;
                while (pos > 0 && file_name.charAt(pos) != '.') {
                    --pos;
                }
            }
            if (pos > 0) {
                dialog.selectPreenteredTextRange(new int[]{0, pos});
            }
        }
        dialog.allowEmptyInput(false);
        dialog.prompt();
        if (!dialog.hasSubmittedInput()) {
            return null;
        }
        return dialog.getSubmittedInput();
    }

    private static String askForRetargetedFilename(DiskManagerFileInfo fileInfo2) {
        FileDialog fDialog = new FileDialog(Utils.findAnyShell(), 131072);
        File existing_file = fileInfo2.getFile(true);
        fDialog.setFilterPath(existing_file.getParent());
        fDialog.setFileName(existing_file.getName());
        fDialog.setText(MessageText.getString("FilesView.rename.choose.path"));
        return fDialog.open();
    }

    private static String askForSaveDirectory(DiskManagerFileInfo fileInfo2) {
        DirectoryDialog dDialog = new DirectoryDialog(Utils.findAnyShell(), 139264);
        File current_dir = fileInfo2.getFile(true).getParentFile();
        dDialog.setFilterPath(current_dir.getPath());
        dDialog.setText(MessageText.getString("FilesView.rename.choose.path.dir"));
        return dDialog.open();
    }

    private static boolean askCanOverwrite(File file) {
        MessageBoxShell mb = new MessageBoxShell(288, MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{file.toString()}));
        mb.setDefaultButtonUsingStyle(32);
        mb.setRememberOnlyIfButton(0);
        mb.setRemember("FilesView.messagebox.rename.id", true, null);
        mb.setLeftImage(8);
        mb.open(null);
        return mb.waitUntilClosed() == 32;
    }

    private static void moveFile(final DownloadManager manager, final DiskManagerFileInfo fileInfo2, final File target, boolean dont_delete_existing) {
        manager.setUserData("is_changing_links", true);
        if (dont_delete_existing) {
            manager.setUserData("set_link_dont_delete_existing", true);
        }
        try {
            final boolean[] result = new boolean[]{false};
            FileUtil.runAsTask(new AzureusCoreOperationTask(){

                public void run(AzureusCoreOperation operation) {
                    result[0] = fileInfo2.setLink(target);
                    manager.setUserData("is_changing_links", false);
                    manager.setUserData("set_link_dont_delete_existing", null);
                    if (!result[0]) {
                        new MessageBoxShell(33, MessageText.getString("FilesView.rename.failed.title"), MessageText.getString("FilesView.rename.failed.text")).open(null);
                    }
                }
            });
        }
        catch (Exception e) {
            manager.setUserData("is_changing_links", false);
            manager.setUserData("set_link_dont_delete_existing", null);
        }
    }

    private static boolean setSkipped(DownloadManager manager, DiskManagerFileInfo[] infos, boolean skipped, boolean delete_action) {
        File save_location;
        if (!manager.isPersistent()) {
            for (int i = 0; i < infos.length; ++i) {
                infos[i].setSkipped(skipped);
            }
            return false;
        }
        int[] existing_storage_types = manager.getStorageType(infos);
        int nbFiles = manager.getDiskManagerFileInfoSet().nbFiles();
        boolean[] setLinear = new boolean[nbFiles];
        boolean[] setCompact = new boolean[nbFiles];
        boolean[] setReorder = new boolean[nbFiles];
        boolean[] setReorderCompact = new boolean[nbFiles];
        int compactCount = 0;
        int linearCount = 0;
        int reorderCount = 0;
        int reorderCompactCount = 0;
        if (infos.length > 1) {
            // empty if block
        }
        boolean root_exists = (save_location = manager.getAbsoluteSaveLocation()).isDirectory() || infos.length <= 1 && save_location.exists();
        boolean type_has_been_changed = false;
        boolean requires_pausing = false;
        for (int i = 0; i < infos.length; ++i) {
            int new_storage_type;
            int non_compact_target;
            int compact_target;
            int existing_storage_type = existing_storage_types[i];
            if (existing_storage_type == 2 || existing_storage_type == 1) {
                compact_target = 2;
                non_compact_target = 1;
            } else {
                compact_target = 4;
                non_compact_target = 3;
            }
            if (skipped) {
                File existing_file = infos[i].getFile(true);
                boolean perform_check = root_exists ? true : !FileUtil.isAncestorOf(save_location, existing_file);
                if (perform_check && existing_file.exists()) {
                    if (delete_action) {
                        boolean wants_to_delete;
                        MessageBoxShell mb = new MessageBoxShell(288, MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{existing_file.toString()}));
                        mb.setDefaultButtonUsingStyle(32);
                        mb.setRememberOnlyIfButton(0);
                        mb.setRemember("FilesView.messagebox.delete.id", false, null);
                        mb.setLeftImage(8);
                        mb.open(null);
                        boolean bl = wants_to_delete = mb.waitUntilClosed() == 32;
                        new_storage_type = wants_to_delete ? compact_target : non_compact_target;
                    } else {
                        new_storage_type = non_compact_target;
                    }
                } else {
                    new_storage_type = compact_target;
                }
            } else {
                new_storage_type = non_compact_target;
            }
            boolean has_changed = existing_storage_type != new_storage_type;
            type_has_been_changed |= has_changed;
            if (!has_changed) continue;
            requires_pausing |= new_storage_type == 2 || new_storage_type == 4;
            if (new_storage_type == 2) {
                setCompact[infos[i].getIndex()] = true;
                ++compactCount;
                continue;
            }
            if (new_storage_type == 1) {
                setLinear[infos[i].getIndex()] = true;
                ++linearCount;
                continue;
            }
            if (new_storage_type == 3) {
                setReorder[infos[i].getIndex()] = true;
                ++reorderCount;
                continue;
            }
            if (new_storage_type != 4) continue;
            setReorderCompact[infos[i].getIndex()] = true;
            ++reorderCompactCount;
        }
        boolean ok = true;
        boolean paused = false;
        if (type_has_been_changed) {
            if (requires_pausing) {
                paused = manager.pause();
            }
            if (linearCount > 0) {
                ok &= Arrays.equals(setLinear, manager.getDiskManagerFileInfoSet().setStorageTypes(setLinear, 1));
            }
            if (compactCount > 0) {
                ok &= Arrays.equals(setCompact, manager.getDiskManagerFileInfoSet().setStorageTypes(setCompact, 2));
            }
            if (reorderCount > 0) {
                ok &= Arrays.equals(setReorder, manager.getDiskManagerFileInfoSet().setStorageTypes(setReorder, 3));
            }
            if (reorderCompactCount > 0) {
                ok &= Arrays.equals(setReorderCompact, manager.getDiskManagerFileInfoSet().setStorageTypes(setReorderCompact, 4));
            }
        }
        if (ok) {
            for (int i = 0; i < infos.length; ++i) {
                infos[i].setSkipped(skipped);
            }
        }
        return paused;
    }
}

