/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.util.MapUtils;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.ui.swt.DelayedListenerMultiCombiner;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_TabsCommon;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyTorrentsSuperView
implements UISWTViewCoreEventListener,
AEDiagnosticsEvidenceGenerator,
UIPluginViewToolBarListener {
    private static int SASH_WIDTH = 5;
    private MyTorrentsView torrentview;
    private MyTorrentsView seedingview;
    private Composite form;
    private MyTorrentsView lastSelectedView;
    private Composite child1;
    private Composite child2;
    private final Text txtFilter;
    private final Composite cCats;
    private Object ds;
    private UISWTView swtView;
    private MyTorrentsView viewWhenDeactivated;

    public MyTorrentsSuperView(Text txtFilter, Composite cCats) {
        this.txtFilter = txtFilter;
        this.cCats = cCats;
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        TableColumnManager tcManager = TableColumnManager.getInstance();
                        tcManager.addColumns(MyTorrentsSuperView.this.getCompleteColumns());
                        tcManager.addColumns(MyTorrentsSuperView.this.getIncompleteColumns());
                    }
                });
            }
        });
    }

    public Composite getComposite() {
        return this.form;
    }

    public void initialize(final Composite parent) {
        if (this.form != null) {
            return;
        }
        this.form = new Composite(parent, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        this.form.setLayout((Layout)flayout);
        GridData gridData = new GridData(1808);
        this.form.setLayoutData((Object)gridData);
        this.child1 = new Composite(this.form, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.child1.setLayout((Layout)layout);
        final Sash sash = Utils.createSash(this.form, SASH_WIDTH);
        this.child2 = new Composite(this.form, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.child2.setLayout((Layout)layout);
        int weight = (int)COConfigurationManager.getFloatParameter("MyTorrents.SplitAt");
        if (weight > 10000) {
            weight = 10000;
        } else if (weight < 100) {
            weight *= 100;
        }
        if (weight < 500) {
            weight = 500;
        } else if (weight > 9000) {
            weight = 9000;
        }
        double pct = (float)weight / 10000.0f;
        sash.setData("PCT", (Object)new Double(pct));
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((int)(pct * 100.0), 0);
        this.child1.setLayoutData((Object)formData);
        final FormData child1Data = formData;
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.child1);
        formData.height = SASH_WIDTH;
        sash.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)sash);
        this.child2.setLayoutData((Object)formData);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean FASTDRAG = true;
                if (e.detail == 1) {
                    return;
                }
                child1Data.height = e.y + e.height - SASH_WIDTH;
                MyTorrentsSuperView.this.form.layout();
                Double l = new Double((double)((MyTorrentsSuperView)MyTorrentsSuperView.this).child1.getBounds().height / (double)((MyTorrentsSuperView)MyTorrentsSuperView.this).form.getBounds().height);
                sash.setData("PCT", (Object)l);
                if (e.detail != 1) {
                    int i = (int)(l * 10000.0);
                    COConfigurationManager.setParameter("MyTorrents.SplitAt", i);
                }
            }
        });
        this.form.addListener(11, (Listener)new DelayedListenerMultiCombiner(){

            public void handleDelayedEvent(Event e) {
                if (sash.isDisposed()) {
                    return;
                }
                Double l = (Double)sash.getData("PCT");
                if (l == null) {
                    return;
                }
                int newHeight = (int)((double)((MyTorrentsSuperView)MyTorrentsSuperView.this).form.getBounds().height * l);
                if (child1Data.height != newHeight || child1Data.bottom != null) {
                    child1Data.bottom = null;
                    child1Data.height = newHeight;
                    MyTorrentsSuperView.this.form.layout();
                }
            }
        });
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        MyTorrentsSuperView.this.initializeWithCore(core, parent);
                    }
                });
            }
        });
    }

    private void initializeWithCore(AzureusCore core, Composite parent) {
        this.torrentview = this.createTorrentView(core, "MyTorrents", false, this.getIncompleteColumns(), this.child1);
        this.seedingview = this.createTorrentView(core, "MySeeders", true, this.getCompleteColumns(), this.child2);
        this.torrentview.getComposite().addListener(15, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsSuperView.this.seedingview.getTableView().getTabsCommon().setTvOverride(MyTorrentsSuperView.this.torrentview.getTableView());
            }
        });
        this.seedingview.getComposite().addListener(15, new Listener(){

            public void handleEvent(Event event2) {
                MyTorrentsSuperView.this.seedingview.getTableView().getTabsCommon().setTvOverride(null);
            }
        });
        SelectedContentManager.addCurrentlySelectedContentListener(new SelectedContentListener(){

            public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewId) {
                if (MyTorrentsSuperView.this.form.isDisposed() || MyTorrentsSuperView.this.torrentview == null || MyTorrentsSuperView.this.seedingview == null) {
                    SelectedContentManager.removeCurrentlySelectedContentListener(this);
                } else {
                    TableViewSWT_TabsCommon tabs;
                    TableView selected_tv = SelectedContentManager.getCurrentlySelectedTableView();
                    TableViewSWT incomp_tv = MyTorrentsSuperView.this.torrentview.getTableView();
                    TableViewSWT comp_tv = MyTorrentsSuperView.this.seedingview.getTableView();
                    if (incomp_tv != null && comp_tv != null && (selected_tv == incomp_tv || selected_tv == comp_tv) && (tabs = comp_tv.getTabsCommon()) != null) {
                        tabs.triggerTabViewsDataSourceChanged(selected_tv);
                    }
                }
            }
        });
        this.initializeDone();
    }

    public void initializeDone() {
    }

    public void updateLanguage() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        if (this.seedingview != null) {
            this.seedingview.updateLanguage();
        }
        if (this.torrentview != null) {
            this.torrentview.updateLanguage();
        }
    }

    public String getFullTitle() {
        return MessageText.getString("MyTorrentsView.mytorrents");
    }

    private MyTorrentsView getCurrentView() {
        try {
            if (this.torrentview != null && this.torrentview.isTableFocus()) {
                this.lastSelectedView = this.torrentview;
            } else if (this.seedingview != null && this.seedingview.isTableFocus()) {
                this.lastSelectedView = this.seedingview;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lastSelectedView;
    }

    private UIPluginViewToolBarListener getActiveToolbarListener() {
        MyTorrentsView[] viewsToCheck = new MyTorrentsView[]{this.getCurrentView(), this.torrentview, this.seedingview};
        for (int i = 0; i < viewsToCheck.length; ++i) {
            UIPluginViewToolBarListener toolBarListener;
            MyTorrentsView view = viewsToCheck[i];
            if (view == null) continue;
            MdiEntrySWT activeSubView = view.getTableView().getTabsCommon().getActiveSubView();
            if (activeSubView != null && (toolBarListener = activeSubView.getToolBarListener()) != null) {
                return toolBarListener;
            }
            if (i != 0 || !view.isTableFocus()) continue;
            return view;
        }
        return null;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        UIPluginViewToolBarListener currentView = this.getActiveToolbarListener();
        if (currentView != null) {
            currentView.refreshToolBarItems(list);
        }
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        UIPluginViewToolBarListener currentView = this.getActiveToolbarListener();
        if (currentView != null && currentView.toolBarItemActivated(item, activationType, datasource)) {
            return true;
        }
        MyTorrentsView currentView2 = this.getCurrentView();
        return currentView2 != currentView && currentView2 != null && currentView2.toolBarItemActivated(item, activationType, datasource);
    }

    public DownloadManager[] getSelectedDownloads() {
        MyTorrentsView currentView = this.getCurrentView();
        if (currentView == null) {
            return null;
        }
        return currentView.getSelectedDownloads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        try {
            writer.indent();
            writer.println("Downloading");
            writer.indent();
            this.torrentview.generate(writer);
            Object var3_2 = null;
            writer.exdent();
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            writer.exdent();
            writer.exdent();
            throw throwable;
        }
        try {
            writer.indent();
            writer.println("Seeding");
            writer.indent();
            this.seedingview.generate(writer);
            Object var5_5 = null;
            writer.exdent();
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            writer.exdent();
            writer.exdent();
            throw throwable;
        }
    }

    private Image obfusticatedImage(Image image) {
        if (this.torrentview != null) {
            this.torrentview.obfusticatedImage(image);
        }
        if (this.seedingview != null) {
            this.seedingview.obfusticatedImage(image);
        }
        return image;
    }

    public Menu getPrivateMenu() {
        return null;
    }

    public void viewActivated() {
        SelectedContentManager.clearCurrentlySelectedContent();
        if (this.viewWhenDeactivated != null) {
            this.viewWhenDeactivated.getComposite().setFocus();
            this.viewWhenDeactivated.updateSelectedContent(true);
        } else {
            MyTorrentsView currentView = this.getCurrentView();
            if (currentView != null) {
                currentView.updateSelectedContent();
            }
        }
    }

    public void viewDeactivated() {
        this.viewWhenDeactivated = this.getCurrentView();
    }

    protected TableColumnCore[] getIncompleteColumns() {
        return TableColumnCreator.createIncompleteDM("MyTorrents");
    }

    protected TableColumnCore[] getCompleteColumns() {
        return TableColumnCreator.createCompleteDM("MySeeders");
    }

    protected MyTorrentsView createTorrentView(AzureusCore _azureus_core, String tableID, boolean isSeedingView, TableColumnCore[] columns, Composite c) {
        MyTorrentsView view = new MyTorrentsView(_azureus_core, tableID, isSeedingView, columns, this.txtFilter, this.cCats, isSeedingView);
        try {
            UISWTViewImpl swtView = new UISWTViewImpl(tableID, "Main", false);
            swtView.setDatasource(this.ds);
            swtView.setEventListener(view, true);
            swtView.setDelayInitializeToFirstActivate(false);
            swtView.initialize(c);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        c.layout();
        return view;
    }

    public MyTorrentsView getTorrentview() {
        return this.torrentview;
    }

    public MyTorrentsView getSeedingview() {
        return this.seedingview;
    }

    public void dataSourceChanged(Object newDataSource) {
        this.ds = newDataSource;
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setToolBarListener(this);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                return true;
            }
            case 6: {
                this.swtView.setTitle(this.getFullTitle());
                Messages.updateLanguageForControl((Widget)this.getComposite());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 5: {
                break;
            }
            case 9: {
                Object data = event2.getData();
                if (!(data instanceof Map)) break;
                this.obfusticatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
            }
        }
        if (this.seedingview != null) {
            try {
                this.seedingview.getSWTView().triggerEvent(event2.getType(), event2.getData());
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        if (this.torrentview != null) {
            try {
                this.torrentview.getSWTView().triggerEvent(event2.getType(), event2.getData());
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        switch (event2.getType()) {
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
            }
        }
        return true;
    }

    public UISWTView getSWTView() {
        return this.swtView;
    }
}

